/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.updating;

import chatty.gui.UrlOpener;
import chatty.gui.laf.LaF;
import chatty.lang.Language;
import chatty.util.DateTime;
import chatty.util.GitHub;
import chatty.util.colors.HtmlColors;
import com.github.rjeschke.txtmark.Processor;
import java.awt.Component;
import java.awt.Font;
import java.awt.Window;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;

public class Changes
extends JDialog {
    private static final JLabel label = new JLabel();
    private final JTextPane textPane;

    public void showDialog(GitHub.Releases releases, GitHub.Release latest, GitHub.Release current) {
        String markdown = this.makeMarkdown(releases, latest, current);
        try {
            String html = Processor.process(markdown);
            this.textPane.setText(html);
        }
        catch (Exception ex) {
            this.textPane.setText("Error parsing: " + ex);
        }
        this.textPane.setCaretPosition(0);
        if (current == null) {
            this.setTitle("Changes [Latest: " + latest.getVersion() + "]");
        } else {
            this.setTitle("Changes [Installed: " + current.getVersion() + " -> Latest: " + latest.getVersion() + "]");
        }
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    public Changes(Window parent) {
        super(parent);
        this.setDefaultCloseOperation(1);
        this.textPane = new JTextPane();
        this.textPane.setContentType("text/html");
        this.textPane.setEditable(false);
        this.setFont(label.getFont());
        Font font = label.getFont();
        String bold = font.getStyle() == 1 ? "bold" : "normal";
        String color = HtmlColors.getColorString(label.getForeground());
        String fontRule = "body { font-family: " + font.getFamily() + ";font-size: " + font.getSize() + ";font-weight: normal;color: " + color + ";padding: 10px;margin-top: 0;padding-top: 2px;}a {color: " + LaF.getLinkColor() + ";}h2 {border-bottom: 1px solid #AAAAAA;margin-bottom: 0px;}h3 {margin-bottom: 4px;}";
        ((HTMLDocument)this.textPane.getDocument()).getStyleSheet().addRule(fontRule);
        this.textPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String url = e.getURL().toString();
                    String protocol = e.getURL().getProtocol();
                    if (protocol.equals("http") || protocol.equals("https")) {
                        UrlOpener.openUrlPrompt(Changes.this, url, true);
                    }
                }
            }
        });
        this.add((Component)new JScrollPane(this.textPane), "Center");
        JButton closeButton = new JButton(Language.getString("dialog.button.close"));
        closeButton.addActionListener(e -> this.setVisible(false));
        this.add((Component)closeButton, "South");
        this.setSize(800, 600);
    }

    private String makeMarkdown(GitHub.Releases releases, GitHub.Release latest, GitHub.Release current) {
        StringBuilder b = new StringBuilder();
        if (current == null) {
            b.append("The version you are running is rather old, so this may not include the full changelog since then.");
        } else {
            b.append("Changelog since version ").append(current.getVersion()).append(".");
        }
        if (latest.isBeta()) {
            b.append(" Includes latest betas.");
        }
        b.append("\n\n");
        boolean include = false;
        boolean includeBeta = true;
        for (GitHub.Release r : releases.getReleases()) {
            if (r == latest) {
                include = true;
            } else if (r == current) {
                include = false;
                b.append("\n\n");
                b.append("## ").append(r.getName());
                b.append(" <small>(").append(DateTime.agoText(r.getPublishedAt())).append(")</small>");
                b.append(" <small>[Installed]</small>");
                b.append("\n\n");
                b.append("<em>Currently installed version.</em>");
            }
            if (include && !r.isBeta()) {
                includeBeta = false;
            }
            if (!include || r.isBeta() && !includeBeta) continue;
            b.append("\n\n");
            b.append("## ").append(r.getName());
            b.append(" <small>(").append(DateTime.agoText(r.getPublishedAt())).append(")</small>");
            if (r == latest) {
                b.append(" <small>[Latest]</small>");
            }
            b.append("\n\n");
            b.append(r.getDescription());
        }
        return b.toString();
    }
}

