/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.updating;

import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileDownloader
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(FileDownloader.class.getName());
    private static final int CONNECT_TIMEOUT = 10000;
    private static final int READ_TIMEOUT = 10000;
    private final URL from;
    private final Path to;
    private final FileDownloaderListener listener;
    private volatile boolean cancelled;

    public FileDownloader(URL from, Path to, FileDownloaderListener listener) {
        this.from = from;
        this.to = to;
        this.listener = listener;
    }

    public void startAsync() {
        Thread worker = new Thread(this);
        worker.start();
    }

    public void startAsyncDaemon() {
        Thread worker = new Thread(this);
        worker.setDaemon(true);
        worker.start();
    }

    public void cancel() {
        System.out.println("Cancel");
        this.cancelled = true;
    }

    @Override
    public void run() {
        URLConnection connection = null;
        try {
            connection = this.from.openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            int responseCode = -1;
            if (connection instanceof HttpURLConnection) {
                responseCode = ((HttpURLConnection)connection).getResponseCode();
            }
            long contentLength = connection.getContentLengthLong();
            LOGGER.info("Download started (" + responseCode + "): " + this.from + " -> " + this.to);
            long totalBytes = 0L;
            try (BufferedInputStream reader = new BufferedInputStream(connection.getInputStream());
                 FileOutputStream output = new FileOutputStream(this.to.toFile());){
                int count;
                byte[] buffer = new byte[512];
                while ((count = reader.read(buffer)) != -1) {
                    output.write(buffer, 0, count);
                    this.listener.progress(totalBytes += (long)count, contentLength);
                    if (!this.cancelled) continue;
                    this.listener.cancelled(totalBytes, contentLength);
                    LOGGER.info("Download cancelled");
                    return;
                }
            }
            LOGGER.info(String.format(Locale.ROOT, "Download completed (%d/%d)", totalBytes, contentLength));
            this.listener.completed(totalBytes, contentLength);
        }
        catch (IOException ex) {
            LOGGER.warning("Request Error [" + this.from + "] (" + ex + ")");
            this.listener.error(ex);
        }
    }

    public static void main(String[] args) throws IOException {
        URL from = new URL("https://github.com/chatty/chatty/releases/download/v0.9.1/Chatty_0.9.1.zip");
        Path to = Paths.get("G:\\testi.zip", new String[0]);
        FileDownloader downloader = new FileDownloader(from, to, new FileDownloaderListener(){

            @Override
            public void completed(long totalBytes, long contentLenght) {
                System.out.println("completed " + totalBytes + " " + contentLenght);
            }

            @Override
            public void error(IOException ex) {
                System.out.println("error " + ex);
            }

            @Override
            public void progress(long totalBytes, long contentLenght) {
            }

            @Override
            public void cancelled(long totalBytes, long contentLength) {
                System.out.println("cancelled " + totalBytes + " " + contentLength);
            }
        });
        long start = System.currentTimeMillis();
        downloader.startAsync();
        try {
            System.out.println("abc");
            Thread.sleep(3000L);
            downloader.cancel();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(FileDownloader.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.out.println(System.currentTimeMillis() - start);
    }

    public static interface FileDownloaderListener {
        public void completed(long var1, long var3);

        public void error(IOException var1);

        public void progress(long var1, long var3);

        public void cancelled(long var1, long var3);
    }
}

