/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.updating;

import chatty.gui.components.updating.FileDownloader;
import chatty.lang.Language;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class FileDownloaderDialog
extends JDialog {
    private final JProgressBar progressBar;
    private final JButton cancelButton;
    private final JLabel error;
    private final FileDownloader downloader;
    private boolean complete;

    public static boolean downloadFile(Window owner, URL from, Path to, String title) {
        FileDownloaderDialog d = new FileDownloaderDialog(owner, from, to, title);
        return d.showDialog();
    }

    public FileDownloaderDialog(Window owner, URL from, Path to, String title) {
        super(owner);
        this.setTitle(title);
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                FileDownloaderDialog.this.downloader.cancel();
            }
        });
        this.downloader = new FileDownloader(from, to, new FileDownloader.FileDownloaderListener(){

            @Override
            public void completed(long totalBytes, long contentLength) {
                SwingUtilities.invokeLater(() -> {
                    FileDownloaderDialog.this.complete = true;
                    FileDownloaderDialog.this.setVisible(false);
                });
            }

            @Override
            public void error(IOException ex) {
                SwingUtilities.invokeLater(() -> {
                    if (ex instanceof FileNotFoundException) {
                        FileDownloaderDialog.this.setError("Not found (" + ex.getLocalizedMessage() + ")");
                    } else {
                        FileDownloaderDialog.this.setError(ex.toString());
                    }
                });
            }

            @Override
            public void progress(long totalBytes, long contentLength) {
                SwingUtilities.invokeLater(() -> {
                    if (contentLength == -1L) {
                        FileDownloaderDialog.this.progressBar.setIndeterminate(true);
                    } else {
                        int percentage = (int)((double)totalBytes / (double)contentLength * 100.0);
                        FileDownloaderDialog.this.progressBar.setValue(percentage);
                        FileDownloaderDialog.this.progressBar.setString(String.format("%.2f MB / %.2f MB", (double)totalBytes / 1024.0 / 1024.0, (double)contentLength / 1024.0 / 1024.0));
                    }
                });
            }

            @Override
            public void cancelled(long totalBytes, long contentLength) {
                SwingUtilities.invokeLater(() -> FileDownloaderDialog.this.setVisible(false));
            }
        });
        this.error = new JLabel();
        this.add((Component)this.error, "North");
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.add((Component)this.progressBar, "Center");
        this.cancelButton = new JButton(Language.getString("dialog.button.cancel"));
        this.add((Component)this.cancelButton, "South");
        this.cancelButton.addActionListener(e -> {
            this.downloader.cancel();
            this.setVisible(false);
        });
        this.setMinimumSize(new Dimension(250, 10));
        this.pack();
    }

    public boolean showDialog() {
        this.downloader.startAsyncDaemon();
        this.setLocationRelativeTo(this.getOwner());
        this.setVisible(true);
        return this.complete;
    }

    private void setError(String message) {
        this.error.setText("<html><body style='padding:5px;width:250px;'>Download failed: " + message);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    public static void main(String[] args) throws MalformedURLException {
        System.out.println(FileDownloaderDialog.downloadFile(null, new URL("https://github.com/chatty/chatty/releases/download/v0.9.1/Chatty_0.9.1.zip"), Paths.get("G:\\test2.zip", new String[0]), "Downloading update"));
        System.exit(0);
    }
}

