/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.updating;

import chatty.Chatty;
import chatty.util.Debugging;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RunUpdater {
    private static final Logger LOGGER = Logger.getLogger(RunUpdater.class.getName());

    public static void run(Path installerPath, Path installDir, Path jarPath, Path chattyExe, Path javawExe, String[] chattyArgs, boolean debug) throws IOException {
        if (!Files.exists(installerPath, new LinkOption[0])) {
            throw new IOException("Installer not found: " + installerPath);
        }
        if (jarPath == null) {
            throw new IOException("JAR not identified");
        }
        ArrayList<String> command = new ArrayList<String>();
        String installerExe = installerPath.toAbsolutePath().toString();
        command.add(RunUpdater.quote(installerExe));
        command.add(RunUpdater.makeParam("DIR", installDir.toAbsolutePath().toString()));
        command.add(RunUpdater.makeParam("TYPE", "update"));
        if (debug) {
            command.add(RunUpdater.makeParam("LOG", installerExe + ".log"));
        }
        ArrayList<String> restartArgs = new ArrayList<String>();
        if (chattyExe != null && javawExe == null) {
            command.add(RunUpdater.makeParam("runChattyPath", chattyExe.toString()));
        } else if (javawExe != null) {
            command.add(RunUpdater.makeParam("runChattyPath", javawExe.toString()));
            restartArgs.addAll(ManagementFactory.getRuntimeMXBean().getInputArguments());
            restartArgs.add("-jar");
            restartArgs.add(jarPath.toString());
        }
        if (chattyArgs != null) {
            restartArgs.addAll(Arrays.asList(chattyArgs));
        }
        command.add(RunUpdater.makeParam("runChattyWdir", RunUpdater.removeBackslashSuffix(Chatty.getPath(Chatty.PathType.WORKING).toString())));
        String restartParams = RunUpdater.makeJavaParam("runChattyParam", restartArgs);
        if (restartParams == null) {
            throw new IOException("Could not build restart parameters: " + Debugging.filterToken(((Object)restartArgs).toString()));
        }
        command.add(restartParams);
        ProcessBuilder pb = new ProcessBuilder(command);
        LOGGER.info("Starting: " + Debugging.filterToken(((Object)command).toString()));
        pb.start();
    }

    public static String quote(String input) {
        if (!input.contains(" ")) {
            return input;
        }
        return "\"" + input + "\"";
    }

    private static String removeBackslashSuffix(String input) {
        if (input.endsWith("\\")) {
            return input.substring(0, input.length() - 1);
        }
        return input;
    }

    private static String makeParam(String param, String value) {
        return RunUpdater.quote("/" + param + "=" + value);
    }

    public static String makeJavaParam(String param, List<String> input) {
        StringBuilder b = new StringBuilder();
        for (String p : input) {
            String escaped = RunUpdater.replaceQuotes(RunUpdater.escapeForJava(p));
            if (escaped == null) {
                return null;
            }
            if (b.length() > 0) {
                b.append(" ");
            }
            b.append(escaped);
        }
        return RunUpdater.quote("/" + param + "=" + b.toString());
    }

    public static String replaceQuotes(String input) {
        if (input.contains("`")) {
            return null;
        }
        return input.replace('\"', '`');
    }

    public static String escapeForJava(String input) {
        if (!input.matches(".*[ \n\\s\"].*")) {
            return input;
        }
        int numBackslashesBefore = 0;
        StringBuilder b = new StringBuilder().append('\"');
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\\') {
                ++numBackslashesBefore;
                continue;
            }
            if (c == '\"') {
                b.append(String.join((CharSequence)"", Collections.nCopies(numBackslashesBefore * 2 + 1, "\\")));
                numBackslashesBefore = 0;
                b.append('\"');
                continue;
            }
            b.append(String.join((CharSequence)"", Collections.nCopies(numBackslashesBefore, "\\")));
            numBackslashesBefore = 0;
            b.append(c);
        }
        b.append(String.join((CharSequence)"", Collections.nCopies(numBackslashesBefore * 2, "\\")));
        b.append('\"');
        return b.toString();
    }

    public static void main(String[] args) {
        String[] args2 = new String[]{"-token", "abc"};
        Path installerPath = Paths.get("J:\\Chatty_0.16-b2_win_setup.exe", new String[0]);
        Path jarPath = Paths.get("J:\\chatty install\\ParamTest.jar", new String[0]);
        Path chattyExe = null;
        Path javawExe = Paths.get("C:\\Program Files (x86)\\Java\\jre1.8.0_201\\bin\\javaw.exe", new String[0]);
        try {
            RunUpdater.run(installerPath, jarPath.getParent(), jarPath, chattyExe, javawExe, args2, true);
        }
        catch (IOException ex) {
            Logger.getLogger(RunUpdater.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

