/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.updating;

import chatty.util.DateTime;
import chatty.util.Debugging;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class Stuff {
    private static final Logger LOGGER = Logger.getLogger(Stuff.class.getName());
    private static boolean initialized = false;
    private static Path javaHome = null;
    private static Path javawExe = null;
    private static Path chattyExe = null;
    private static Path chattyExeDir = null;
    private static Path jarPath = null;
    private static Path jarDir = null;
    private static Path tempDir = null;
    private static String error;

    public static synchronized Path getTempDir() {
        Stuff.checkInitialized();
        return tempDir;
    }

    public static synchronized boolean isStandalone() {
        Stuff.checkInitialized();
        return chattyExe != null && javawExe == null;
    }

    public static synchronized boolean installPossible() {
        Stuff.checkInitialized();
        return jarDir != null && tempDir != null;
    }

    public static synchronized String getInitError() {
        return error;
    }

    public static synchronized Path getInstallDir(boolean standaloneInstaller) {
        Stuff.checkInitialized();
        if (standaloneInstaller) {
            return chattyExeDir;
        }
        return jarDir;
    }

    public static synchronized Path getJarPath() {
        Stuff.checkInitialized();
        return jarPath;
    }

    public static synchronized Path getChattyExeDir() {
        Stuff.checkInitialized();
        return chattyExeDir;
    }

    public static synchronized Path getChattyExe() {
        Stuff.checkInitialized();
        return chattyExe;
    }

    public static synchronized Path getJavawExe() {
        Stuff.checkInitialized();
        return javawExe;
    }

    private static void checkInitialized() {
        if (!initialized) {
            throw new IllegalStateException("Not initialized");
        }
    }

    public static synchronized void init() {
        Stuff.init(Stuff.determineJarPath());
    }

    public static Path determineJarPath() {
        try {
            Path jarPath = Paths.get(Stuff.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            if (!(jarPath.toString().endsWith(".jar") && Files.exists(jarPath, new LinkOption[0]) && Files.isRegularFile(jarPath, new LinkOption[0]))) {
                jarPath = null;
            }
            return jarPath;
        }
        catch (URISyntaxException ex) {
            LOGGER.warning("jar: " + ex);
            return null;
        }
    }

    public static synchronized void init(Path jarPathTemp) {
        try {
            Path tempDirTemp;
            javaHome = Paths.get(System.getProperty("java.home"), new String[0]);
            Path javawExeTemp = javaHome.resolve("bin").resolve("javaw.exe");
            javawExe = Files.exists(javawExeTemp, new LinkOption[0]) ? javawExeTemp : null;
            jarPath = jarPathTemp;
            if (jarPath != null) {
                jarDir = jarPath.getParent();
            } else {
                jarDir = null;
                error = "JAR path not found";
            }
            if (jarDir != null) {
                Path chattyExeTemp = javaHome.getParent().resolve("Chatty.exe");
                Path chattyExeTemp2 = jarDir.getParent().resolve("Chatty.exe");
                if (Files.exists(chattyExeTemp, new LinkOption[0]) && chattyExeTemp.equals(chattyExeTemp2)) {
                    chattyExe = chattyExeTemp;
                    chattyExeDir = chattyExe.getParent();
                } else {
                    chattyExe = null;
                }
            }
            if (Files.exists(tempDirTemp = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]), new LinkOption[0])) {
                if (Files.isWritable(tempDirTemp)) {
                    tempDir = tempDirTemp;
                } else {
                    LOGGER.warning("Temp dir " + tempDirTemp + " write access denied");
                    error = "Temp Dir " + tempDirTemp + " access denied";
                }
            }
        }
        catch (Exception ex) {
            LOGGER.warning("Error initializing stuff: " + ex);
        }
        LOGGER.info(String.format("Updating Stuff: javaHome: %s / javawExe: %s / jarPath: %s / chattyExe: %s / tempDir: %s", javaHome, javawExe != null ? "yes" : "no", jarPath, chattyExe, tempDir));
        initialized = true;
    }

    public static Path getTempFilePath(String name) {
        return Stuff.getTempDir().resolve(name + "_" + System.currentTimeMillis() + ".exe");
    }

    public static void clearOldSetups() {
        Stuff.checkInitialized();
        if (Stuff.getTempDir() == null) {
            LOGGER.warning("Failed to delete old setup files: Invalid temp dir");
            return;
        }
        Instant oldIfBefore = Instant.now().minus(Duration.ofDays(7L));
        Pattern fileNameCheck = Pattern.compile("Chatty_.*setup.*[0-9]+\\.exe(\\.log)?");
        LOGGER.info("Checking if old setup files should be deleted..");
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(Stuff.getTempDir(), file -> {
            if (Debugging.isEnabled("updater") && fileNameCheck.matcher(file.getFileName().toString()).matches()) {
                Debugging.println(file.getFileName().toString());
            }
            return fileNameCheck.matcher(file.getFileName().toString()).matches() && Files.getLastModifiedTime(file, new LinkOption[0]).toInstant().isBefore(oldIfBefore);
        });){
            for (Path file2 : stream) {
                try {
                    String age = DateTime.ago(Files.getLastModifiedTime(file2, new LinkOption[0]).toMillis(), 0, 0, 3, new DateTime.Formatting[0]);
                    Files.delete(file2);
                    LOGGER.info("Deleted old setup file (" + age + "): " + file2);
                }
                catch (IOException ex) {
                    LOGGER.warning("Failed to delete old setup file: " + ex);
                }
            }
        }
        catch (IOException ex) {
            LOGGER.warning("Failed to delete old setup files: " + ex);
        }
    }
}

