/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.updating;

import chatty.Chatty;
import chatty.gui.GuiUtil;
import chatty.gui.components.LinkLabel;
import chatty.gui.components.LinkLabelListener;
import chatty.gui.components.settings.SettingsUtil;
import chatty.gui.components.updating.Changes;
import chatty.gui.components.updating.FileDownloaderDialog;
import chatty.gui.components.updating.RunUpdater;
import chatty.gui.components.updating.Stuff;
import chatty.gui.components.updating.Version;
import chatty.lang.Language;
import chatty.util.DateTime;
import chatty.util.Debugging;
import chatty.util.GitHub;
import chatty.util.MiscUtil;
import chatty.util.StringUtil;
import chatty.util.settings.Settings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class UpdateDialog
extends JDialog {
    private static final Logger LOGGER = Logger.getLogger(UpdateDialog.class.getName());
    private static final String HTML_PREFIX = "<html><body style='text-align:center;'>";
    private static final String BETA_INFO = "<html><body style='width:350px;'>Betas are steps towards the next which contain the latest features, but may not be quite polished yet.";
    private static final String VERSION = "0.28";
    private final LinkLabel info;
    private final LinkLabel downloadsInfo;
    private final Settings settings;
    private final LinkLabel downloadButtonInfo;
    private final InstallListener installListener;
    private final Changes changes;
    private GitHub.Releases releases;
    private GitHub.Asset downloadAsset;
    private Path installDir;
    private GitHub.Release runningRelease;
    private GitHub.Release latestRelease;
    private final JCheckBox enableCheckBeta;
    private final JCheckBox enableUpdateJar;
    private final JButton closeButton;
    private final JButton downloadButton;

    public UpdateDialog(Window owner, final LinkLabelListener linkLabelListener, Settings settings, InstallListener installListener) {
        super(owner);
        this.setModal(true);
        this.installListener = installListener;
        LinkLabelListener myLinkLabelListener = new LinkLabelListener(){

            @Override
            public void linkClicked(String type, String ref) {
                if (type.equals("changelog")) {
                    if (UpdateDialog.this.releases != null && UpdateDialog.this.latestRelease != null) {
                        UpdateDialog.this.changes.showDialog(UpdateDialog.this.releases, UpdateDialog.this.latestRelease, UpdateDialog.this.runningRelease);
                    }
                } else {
                    linkLabelListener.linkClicked(type, ref);
                }
            }
        };
        this.settings = settings;
        this.setLayout(new GridBagLayout());
        this.changes = new Changes((Window)this);
        this.info = new LinkLabel(null, myLinkLabelListener);
        GridBagConstraints gbc = GuiUtil.makeGbc(0, 0, 1, 1, 10);
        gbc.fill = 1;
        gbc.weighty = 1.0;
        this.add((Component)this.info, gbc);
        this.downloadButton = new JButton("Download & Install Latest Version");
        gbc = GuiUtil.makeGbc(0, 1, 1, 1, 10);
        gbc.insets = new Insets(5, 5, 0, 5);
        this.downloadButton.addActionListener(e -> this.download(this.downloadAsset));
        this.add((Component)this.downloadButton, gbc);
        this.downloadButtonInfo = new LinkLabel("", linkLabelListener);
        gbc = GuiUtil.makeGbc(0, 2, 1, 1, 10);
        gbc.insets = new Insets(0, 5, 5, 5);
        this.add((Component)this.downloadButtonInfo, gbc);
        this.downloadsInfo = new LinkLabel(null, linkLabelListener);
        gbc = GuiUtil.makeGbc(0, 3, 1, 1, 10);
        this.add((Component)this.downloadsInfo, gbc);
        this.enableCheckBeta = new JCheckBox("Show beta versions");
        this.enableCheckBeta.addActionListener(e -> {
            settings.setBoolean("checkNewBeta", this.enableCheckBeta.isSelected());
            this.updateDisplay();
        });
        gbc = GuiUtil.makeGbc(0, 4, 1, 1, 17);
        this.add((Component)this.enableCheckBeta, gbc);
        LinkLabel releaseNotes = new LinkLabel("[help-releases:top Release notes]", linkLabelListener);
        gbc = GuiUtil.makeGbc(0, 5, 1, 1, 17);
        this.add((Component)releaseNotes, gbc);
        this.enableUpdateJar = new JCheckBox("Stay on current Standalone (updates JAR only)");
        this.enableUpdateJar.setToolTipText(SettingsUtil.addTooltipLinebreaks("Will download the JAR installer only, for example if you need to save data or need to stay on the old Standalone version."));
        this.enableUpdateJar.addActionListener(e -> {
            settings.setBoolean("updateJar", this.enableUpdateJar.isSelected());
            this.updateDisplay();
        });
        gbc = GuiUtil.makeGbc(0, 6, 1, 1, 17);
        gbc.insets = new Insets(0, 5, 5, 5);
        this.add((Component)this.enableUpdateJar, gbc);
        this.closeButton = new JButton(Language.getString("dialog.button.close"));
        gbc = GuiUtil.makeGbc(0, 7, 1, 1);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add((Component)this.closeButton, gbc);
        this.closeButton.addActionListener(e -> this.setVisible(false));
    }

    public void showDialog() {
        if (this.releases == null) {
            Version.request(this.settings, (v, r) -> SwingUtilities.invokeLater(() -> this.setInfo(r)));
        }
        this.updateDisplay();
        this.setVisible(true);
    }

    public void showDialog(GitHub.Releases releases) {
        this.setInfo(releases);
        this.setVisible(true);
    }

    public void setInfo(GitHub.Releases releases) {
        this.releases = releases;
        this.updateDisplay();
    }

    private void updateDisplay() {
        this.downloadButton.setVisible(false);
        this.downloadButtonInfo.setText(null);
        this.downloadsInfo.setVisible(false);
        this.enableCheckBeta.setSelected(this.settings.getBoolean("checkNewBeta"));
        this.enableUpdateJar.setSelected(this.settings.getBoolean("updateJar"));
        if (this.releases != null) {
            if (!Stuff.isStandalone()) {
                this.enableUpdateJar.setVisible(false);
            }
            GitHub.Release latest = this.releases.getLatest();
            boolean betaUpdateAvailable = false;
            if (this.releases.getLatestBeta() != null) {
                boolean betaActuallyNewer;
                boolean bl = betaActuallyNewer = Version.compareVersions(VERSION, this.releases.getLatestBeta().getVersion()) == 1;
                if (this.settings.getBoolean("checkNewBeta")) {
                    latest = this.releases.getLatestBeta();
                } else if (betaActuallyNewer) {
                    betaUpdateAvailable = true;
                }
            }
            this.latestRelease = latest;
            this.runningRelease = this.releases.getByVersion(VERSION);
            if (Version.compareVersions(VERSION, latest.getVersion()) == 1 || Debugging.isEnabled("update")) {
                this.setNewVersion(latest, this.runningRelease);
            } else {
                this.setVersion(latest, betaUpdateAvailable);
            }
        } else {
            this.setTitle("Loading..");
            this.info.setText("Loading version info..");
        }
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        SwingUtilities.invokeLater(() -> {
            Dimension p = this.getPreferredSize();
            Dimension c = this.getSize();
            this.setMinimumSize(this.getPreferredSize());
            if (p.width > c.width || p.height > c.height) {
                this.pack();
                this.setLocationRelativeTo(this.getParent());
            }
        });
    }

    private void setVersion(GitHub.Release release, boolean newerBeta) {
        this.setTitle("You are up-to-date!");
        String main = "<html><body style='text-align:center;'><div style='font-size:1.2em;padding-left:10px;padding-right:10px;'>You&nbsp;are&nbsp;running&nbsp;the&nbsp;[help-releases:top latest&nbsp;version]</div>";
        if (newerBeta) {
            main = main + "<div style='margin:5px'>There is a newer beta version though!</div>";
        }
        this.info.setText(String.format(main, VERSION, release.getVersion()));
    }

    private void setNewVersion(GitHub.Release latest, GitHub.Release current) {
        this.setTitle("Update available!");
        String main = "<div style='padding-left:10px;padding-right:10px;'><div style='font-size:1.2em;'>Installed: <span style='font-family:monospaced;'>%1$s</span> <small>%3$s</small></div><div style='padding:5px;'><span style='font-size:1.2em;'>\u2193</span> [changelog:b View Changes]</div><div style='font-size:1.2em;'>Latest: <span style='font-family:monospaced;'>%2$s</span> <small>%4$s</small></div>" + "</div>".replaceAll(" ", "&nbsp;");
        String currentAge = "(?)";
        if (current != null) {
            currentAge = String.format("(%d days)", current.daysOld());
        }
        String latestAge = String.format("(%d days)", latest.daysOld());
        String html = HTML_PREFIX + String.format(main, VERSION, latest.getVersion(), currentAge, latestAge);
        this.info.setText(html);
        boolean isStandalone = Stuff.isStandalone();
        this.installDir = null;
        GitHub.Asset asset = null;
        if (MiscUtil.OS_WINDOWS && Stuff.installPossible()) {
            if (isStandalone && !this.settings.getBoolean("updateJar")) {
                asset = latest.getAsset("win_standalone_setup.exe");
            }
            if (asset == null) {
                isStandalone = false;
                asset = latest.getAsset("win_setup.exe");
            }
        }
        this.downloadAsset = asset;
        this.installDir = Stuff.getInstallDir(isStandalone);
        this.downloadButton.setVisible(true);
        if (asset == null || this.installDir == null) {
            String reason = "";
            if (!MiscUtil.OS_WINDOWS) {
                reason = "only supported on Windows";
            } else if (!Stuff.installPossible() && Stuff.getInitError() != null) {
                reason = Stuff.getInitError();
            }
            if (!StringUtil.isNullOrEmpty(reason)) {
                reason = ", " + reason;
            }
            this.downloadButton.setEnabled(false);
            this.downloadButtonInfo.setText("<html><body style='width:200px;text-align:center;'><small>(Automatic download not available" + reason + ")</small>");
        } else {
            this.downloadButton.setEnabled(true);
            this.downloadButtonInfo.setText("<html><body><div style='width:200px;text-align:center;'><small>(Downloads, closes Chatty and runs the setup: " + asset.getName() + ")</small></div>");
        }
        this.downloadsInfo.setVisible(true);
        this.downloadsInfo.setText("<html><body style='padding:0px 10px 0px 10px;'><p>Direct downloads (manual install):</p>" + this.makeDownloadLinks(latest));
    }

    private String makeDownloadLinks(GitHub.Release release) {
        StringBuilder b = new StringBuilder();
        b.append("<ul style='margin-left:24'>");
        for (GitHub.Asset asset : release.getAssets()) {
            b.append("<li>");
            b.append("[url:").append(asset.getUrl()).append(" ").append(asset.getName()).append("]");
            b.append("</li>");
        }
        b.append("<li>");
        b.append("[url:https://tduva.com/chatty/checksums/v").append(release.getVersion()).append(" View download checksums]");
        b.append("</li>");
        b.append("</ul>");
        return b.toString();
    }

    private void download(GitHub.Asset asset) {
        try {
            Path installerPath = Stuff.getTempFilePath(asset.getName());
            URL downloadUrl = new URL(asset.getUrl());
            if (FileDownloaderDialog.downloadFile(this, downloadUrl, installerPath, "Download update")) {
                this.install(installerPath);
            }
        }
        catch (IOException ex) {
            LOGGER.warning("Error downloading asset: " + ex);
        }
    }

    private void install(Path installerPath) {
        try {
            RunUpdater.run(installerPath, this.installDir, Stuff.getJarPath(), Stuff.getChattyExe(), Stuff.getJavawExe(), Chatty.getArgs(), Debugging.isEnabled("update"));
            this.installListener.installing();
        }
        catch (IOException ex) {
            LOGGER.warning("Error running installer: " + ex);
            String text = "<html><body style='width:400px'>" + ex;
            JOptionPane.showMessageDialog(this, text, "Error installing update", 0);
        }
    }

    public static final void main(String[] args) {
        Debugging.command("+update");
        Stuff.init(Paths.get("H:\\chatty_install\\Param Test.jar", new String[0]));
        Settings settings = new Settings("", null);
        settings.addBoolean("checkNewBeta", true);
        settings.addBoolean("updateJar", false);
        settings.addLong("versionLastChecked", 0L);
        LinkLabelListener linkLabelListener = (type, ref) -> System.out.println("Link clicked: " + type + ":" + ref);
        GitHub.Releases data = UpdateDialog.testReleases();
        UpdateDialog d = new UpdateDialog(null, linkLabelListener, settings, () -> System.exit(0));
        d.setLocationRelativeTo(null);
        d.showDialog(data);
        System.exit(0);
    }

    private static GitHub.Releases testReleases() {
        ArrayList<GitHub.Release> releases = new ArrayList<GitHub.Release>();
        releases.add(UpdateDialog.testRelease("0.9.1-beta2", true, DateTime.parseDatetime("2018-04-04T00:31:11Z")));
        releases.add(UpdateDialog.testRelease("0.9.1-beta1", true, DateTime.parseDatetime("2018-04-03T00:31:11Z")));
        releases.add(UpdateDialog.testRelease("0.9", false, DateTime.parseDatetime("2018-04-02T00:31:11Z")));
        releases.add(UpdateDialog.testRelease("0.9b3", true, DateTime.parseDatetime("2018-03-22T00:31:11Z")));
        releases.add(UpdateDialog.testRelease("0.9b2", true, DateTime.parseDatetime("2018-02-12T00:31:11Z")));
        releases.add(UpdateDialog.testRelease("0.9b1", true, DateTime.parseDatetime("2018-02-03T00:31:11Z")));
        releases.add(UpdateDialog.testRelease("0.8.7", false, DateTime.parseDatetime("2018-02-02T00:31:11Z")));
        releases.add(UpdateDialog.testRelease("0.8.6", false, DateTime.parseDatetime("2018-01-02T00:31:11Z")));
        return new GitHub.Releases(releases);
    }

    private static GitHub.Release testRelease(String version, boolean beta, long datetime) {
        String description = "Changes [compared to previous version](https://github.com/chatty/chatty/compare/v0.9...v0.9.1) (v0.9):\n\n### Main Features\n- Added basic support for Rooms (join via Channels-menu and Favorites/History)\n- Added initial support for translating the Chatty GUI to other languages,\n  added some partial translations (thanks to volunteers translating)";
        ArrayList<GitHub.Asset> assets = new ArrayList<GitHub.Asset>();
        assets.add(new GitHub.Asset("Chatty_" + version + ".zip", "http://example.com/"));
        assets.add(new GitHub.Asset("Chatty_" + version + "_hotkey_32bit.zip", "http://example.com/"));
        assets.add(new GitHub.Asset("Chatty_" + version + "_hotkey_64bit.zip", "http://example.com/"));
        assets.add(new GitHub.Asset("Chatty_" + version + "_win_standalone.zip", "http://example.com/"));
        assets.add(new GitHub.Asset("Chatty_" + version + "_win_setup.exe", "file:\\H:\\chatty_test\\Chatty_0.9.1_installer.exe"));
        assets.add(new GitHub.Asset("Chatty_" + version + "_win_standalone_setup.exe", "http://example.com/"));
        return new GitHub.Release("v" + version, "Version " + version, description, beta, assets, datetime);
    }

    public static interface InstallListener {
        public void installing();
    }
}

