/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.updating;

import chatty.Logging;
import chatty.gui.components.updating.Stuff;
import chatty.util.GitHub;
import chatty.util.settings.Settings;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version {
    private static final Logger LOGGER = Logger.getLogger(Version.class.getName());
    private static final int CHECK_VERSION_INTERVAL = 172800;
    private static final String VERSION = "0.28";
    private final VersionListener listener;
    private final Settings settings;

    private Version(VersionListener listener, Settings settings) {
        this.listener = listener;
        this.settings = settings;
    }

    public static void check(Settings settings, VersionListener listener) {
        Version v = new Version(listener, settings);
        v.checkForNewVersion();
    }

    public static void request(Settings settings, VersionListener listener) {
        Version v = new Version(listener, settings);
        v.checkForNewVersionForced();
    }

    private void checkForNewVersion() {
        if (!this.settings.getBoolean("checkNewVersion")) {
            return;
        }
        long ago = System.currentTimeMillis() - this.settings.getLong("versionLastChecked");
        if (ago / 1000L < 172800L) {
            String updateAvailable = this.settings.getString("updateAvailable");
            if (!updateAvailable.isEmpty()) {
                this.listener.versionChecked(updateAvailable, null);
            }
        } else {
            this.checkForNewVersionForced();
        }
    }

    public void checkForNewVersionForced() {
        this.settings.setLong("versionLastChecked", System.currentTimeMillis());
        LOGGER.log(Logging.USERINFO, "Checking for new version..");
        new Thread(() -> {
            Stuff.init();
            Stuff.clearOldSetups();
            this.versionReceived(GitHub.getReleases());
        }).start();
    }

    private void versionReceived(GitHub.Releases releases) {
        boolean isNewVersion;
        if (releases == null) {
            return;
        }
        GitHub.Release release = releases.getLatest();
        if (releases.getLatestBeta() != null && this.settings.getBoolean("checkNewBeta")) {
            release = releases.getLatestBeta();
        }
        boolean bl = isNewVersion = Version.compareVersions(VERSION, release.getVersion()) == 1;
        if (isNewVersion) {
            this.settings.setString("updateAvailable", release.getVersion());
        }
        LOGGER.info(String.format("[UpdateCheck] Current: %s Latest: %s", VERSION, release.getVersion()));
        this.listener.versionChecked(isNewVersion ? release.getVersion() : null, releases);
    }

    public static int compareVersions(String version1, String version2) {
        int[] v1 = Version.versionToIntArray(version1);
        int[] v2 = Version.versionToIntArray(version2);
        int length = v2.length;
        if (v1.length > v2.length) {
            length = v1.length;
        }
        for (int i = 0; i < length; ++i) {
            int vp1 = 0;
            int vp2 = 0;
            if (i < v1.length) {
                vp1 = v1[i];
            }
            if (i < v2.length) {
                vp2 = v2[i];
            }
            if (vp1 > vp2) {
                return -1;
            }
            if (vp2 <= vp1) continue;
            return 1;
        }
        return 0;
    }

    public static int[] versionToIntArray(String version) {
        int betaVersion = 0;
        Matcher m = Pattern.compile("([.0-9]+)(?:-?([a-z]+)([0-9]+)?)").matcher(version);
        if (m.matches()) {
            try {
                betaVersion = Integer.parseInt(m.group(3));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            version = m.group(1);
        }
        String[] split = version.split("\\.");
        int[] intVersion = new int[split.length + (betaVersion > 0 ? 2 : 0)];
        for (int i = 0; i < split.length; ++i) {
            String part = split[i];
            int partI = 0;
            try {
                partI = Integer.parseInt(part);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            intVersion[i] = partI;
        }
        if (betaVersion > 0) {
            intVersion[intVersion.length - 2] = -1;
            intVersion[intVersion.length - 1] = betaVersion;
        }
        return intVersion;
    }

    public static interface VersionListener {
        public void versionChecked(String var1, GitHub.Releases var2);
    }
}

