/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.userinfo;

import chatty.gui.components.settings.Editor;
import chatty.gui.components.settings.GenericComboSetting;
import chatty.gui.components.settings.SettingsDialog;
import chatty.lang.Language;
import chatty.util.settings.Settings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class BanReasons
extends JPanel {
    private final GenericComboSetting<String> combo = new GenericComboSetting();
    private final Settings settings;
    private final Editor settingEditor;
    private final JTextField customReasonInput = new JTextField();
    private final GridBagConstraints customInputGbc;
    private String currentReasons;
    private final int[] codes = new int[]{49, 50, 51, 52, 53, 54, 55, 56, 57};

    public BanReasons(final Window parent, Settings settings) {
        this.settings = settings;
        this.setLayout(new GridBagLayout());
        JButton editButton = new JButton();
        editButton.setIcon(new ImageIcon(SettingsDialog.class.getResource("edit.png")));
        editButton.setMargin(new Insets(0, 2, 0, 2));
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BanReasons.this.editReasons();
            }
        });
        this.settingEditor = new Editor(parent);
        this.settingEditor.setAllowEmpty(true);
        this.settingEditor.setAllowLinebreaks(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add(this.combo, gbc);
        gbc.gridx = 1;
        gbc.fill = 3;
        this.add((Component)editButton, gbc);
        this.customInputGbc = new GridBagConstraints();
        this.customInputGbc.gridx = 0;
        this.customInputGbc.gridy = 1;
        this.customInputGbc.gridwidth = 2;
        this.customInputGbc.fill = 2;
        this.add((Component)this.customReasonInput, this.customInputGbc);
        this.combo.setRenderer(new BasicComboBoxRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
                String text;
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
                if (index == -1 && value != null && (text = (String)((GenericComboSetting.Entry)value).value) != null && !text.isEmpty()) {
                    this.setText(text);
                }
                return this;
            }
        });
        this.combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BanReasons.this.combo.getItemCount() > 1 && BanReasons.this.combo.getSelectedIndex() == BanReasons.this.combo.getItemCount() - 1) {
                    BanReasons.this.addCustomInput();
                } else {
                    BanReasons.this.removeCustomInput();
                }
            }
        });
        this.combo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!BanReasons.this.combo.isPopupVisible()) {
                    return;
                }
                for (int i = 0; i < BanReasons.this.codes.length; ++i) {
                    if (BanReasons.this.codes[i] != e.getKeyCode()) continue;
                    int indexToSelect = i + 1;
                    if (BanReasons.this.combo.getItemCount() > indexToSelect + 1) {
                        BanReasons.this.combo.setPopupVisible(false);
                        BanReasons.this.combo.setSelectedIndex(indexToSelect);
                    }
                    e.consume();
                }
                if (e.getKeyCode() == 67) {
                    BanReasons.this.combo.setSelectedIndex(BanReasons.this.combo.getItemCount() - 1);
                    e.consume();
                }
            }
        });
        this.updateHotkey();
        this.combo.getActionMap().put(this.combo, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (parent.getFocusOwner().getClass() == JTextField.class) {
                    return;
                }
                if (!BanReasons.this.combo.isPopupVisible() && BanReasons.this.combo.getSelectedIndex() != 0) {
                    BanReasons.this.combo.setSelectedIndex(0);
                }
                BanReasons.this.combo.requestFocusInWindow();
                BanReasons.this.combo.setPopupVisible(!BanReasons.this.combo.isPopupVisible());
            }
        });
        this.customReasonInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
            }
        });
        this.customReasonInput.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 38) {
                    BanReasons.this.combo.requestFocusInWindow();
                    BanReasons.this.combo.setPopupVisible(true);
                    BanReasons.this.combo.setSelectedIndex(BanReasons.this.combo.getItemCount() - 2);
                }
            }
        });
    }

    private void editReasons() {
        String currentReasons = this.settings.getString("banReasons");
        String editedReasons = this.settingEditor.showDialog(Language.getString("userDialog.editBanReasons"), currentReasons, null);
        if (editedReasons != null) {
            this.settings.setString("banReasons", editedReasons);
            this.updateReasonsFromSettings();
        }
    }

    public void updateReasonsFromSettings() {
        String reasons = this.settings.getString("banReasons");
        if (reasons.equals(this.currentReasons)) {
            return;
        }
        String[] split = reasons.split("\n");
        this.combo.removeAllItems();
        this.combo.add("", Language.getString("userDialog.selectBanReason"));
        for (int i = 0; i < split.length; ++i) {
            if (split[i].trim().isEmpty()) continue;
            String shortcut = "-";
            if (this.codes.length > i) {
                shortcut = KeyEvent.getKeyText(this.codes[i]);
            }
            this.combo.add(split[i], "[" + shortcut + "] " + split[i]);
        }
        this.combo.add("[C] " + Language.getString("userDialog.customReason"));
        this.currentReasons = reasons;
    }

    public String getSelectedReason() {
        int index = this.combo.getSelectedIndex();
        if (index == 0 || index == -1) {
            return "";
        }
        if (index == this.combo.getItemCount() - 1) {
            return this.customReasonInput.getText();
        }
        return this.combo.getSettingValue();
    }

    public void reset() {
        if (this.combo.getItemCount() > 0) {
            this.combo.setSelectedIndex(0);
        }
    }

    public void addCustomInput() {
        this.add((Component)this.customReasonInput, this.customInputGbc);
        this.revalidate();
        this.customReasonInput.requestFocusInWindow();
        this.customReasonInput.setSelectionStart(0);
        this.customReasonInput.setSelectionEnd(this.customReasonInput.getText().length());
    }

    public void removeCustomInput() {
        this.remove(this.customReasonInput);
        this.revalidate();
    }

    public void updateHotkey() {
        this.combo.getInputMap(2).clear();
        KeyStroke openReasonsHotkey = KeyStroke.getKeyStroke(this.settings.getString("banReasonsHotkey"));
        if (openReasonsHotkey != null) {
            this.combo.getInputMap(2).put(openReasonsHotkey, this.combo);
        }
    }
}

