/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.userinfo;

import chatty.gui.GuiUtil;
import chatty.gui.components.menus.CommandMenuItem;
import chatty.gui.components.menus.CommandMenuItems;
import chatty.gui.components.userinfo.UserInfoDialog;
import chatty.util.commands.CustomCommand;
import chatty.util.commands.Parameters;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class Buttons {
    private final UserInfoDialog owner;
    private final ActionListener listener;
    private final JPanel primary = new JPanel();
    private final JPanel secondary = new JPanel();
    private final Map<String, JPanel> rows = new HashMap<String, JPanel>();
    private final Map<JButton, CustomCommand> commands = new HashMap<JButton, CustomCommand>();
    private List<CommandMenuItem> items = new ArrayList<CommandMenuItem>();
    private boolean noKeyLabels = false;
    private boolean isTest = false;
    private final CustomCommand modCommand = CustomCommand.parse("/mod $$1");
    private final CustomCommand unmodCommand = CustomCommand.parse("/unmod $$1");
    private final CustomCommand approveCommand = CustomCommand.parse("/automod_approve $(automod-msg-id)");
    private final CustomCommand denyCommand = CustomCommand.parse("/automod_deny $(automod-msg-id)");
    private JButton modUnmodButton;
    private JButton approveButton;
    private JButton denyButton;

    public Buttons(UserInfoDialog owner, ActionListener listener) {
        this.owner = owner;
        this.listener = listener;
        this.primary.setLayout(new BoxLayout(this.primary, 1));
        this.secondary.setLayout(new BoxLayout(this.secondary, 1));
    }

    public void removeAndAddButtons(Parameters parameters) {
        if (this.isTest) {
            parameters.put("menu-test", "true");
        }
        this.removeButtons();
        this.addButtons(parameters);
    }

    public void set(String setting, boolean isTest, Parameters parameters) {
        this.isTest = isTest;
        if (setting.contains("nokeylabels")) {
            setting = setting.replaceAll("nokeylabels", "");
            this.noKeyLabels = true;
        }
        this.items = CommandMenuItems.parse(setting);
        if (parameters != null) {
            this.removeAndAddButtons(parameters);
        }
    }

    protected void updateModButtons(boolean localIsStreamer, boolean userIsMod) {
        if (this.modUnmodButton == null) {
            return;
        }
        if (localIsStreamer) {
            String text = this.modUnmodButton.getText();
            if (userIsMod) {
                text = text.replace("Mod", "Unmod");
                this.commands.put(this.modUnmodButton, this.unmodCommand);
                this.modUnmodButton.setToolTipText("Unmod user");
            } else {
                text = text.replace("Unmod", "Mod");
                this.commands.put(this.modUnmodButton, this.modCommand);
                this.modUnmodButton.setToolTipText("Mod user");
            }
            this.modUnmodButton.setText(text);
        }
        this.modUnmodButton.setVisible(localIsStreamer);
    }

    protected void updateAutoModButtons(String autoModMsgId) {
        boolean show;
        boolean bl = show = autoModMsgId != null;
        if (this.approveButton != null) {
            this.approveButton.setVisible(show);
        }
        if (this.denyButton != null) {
            this.denyButton.setVisible(show);
        }
    }

    private void removeButtons() {
        for (JButton button : this.commands.keySet()) {
            this.clearShortcut(button);
        }
        this.primary.removeAll();
        this.secondary.removeAll();
        this.commands.clear();
        this.rows.clear();
        this.modUnmodButton = null;
    }

    private void addButtons(Parameters parameters) {
        for (CommandMenuItem item : this.items) {
            parameters = CommandMenuItems.getMenuParameters(item, parameters);
            if (item.getCommand() == null || item.getLabel(parameters).isEmpty()) continue;
            JButton button = new JButton(item.getLabel(parameters));
            button.addActionListener(this.listener);
            button.setToolTipText(item.getTooltipHtml());
            this.commands.put(button, item.getCommand());
            boolean secondaryButton = false;
            if (item.getParent() != null && !item.getParent().startsWith("a")) {
                secondaryButton = true;
                GuiUtil.smallButtonInsets(button);
            }
            this.getRow(item.getParent()).add(button);
            if (item.getCommand() != null && item.getCommand().getCommandName() != null) {
                String commandName = item.getCommand().getCommandName();
                if (commandName.equalsIgnoreCase("modunmod")) {
                    button.setVisible(false);
                    this.modUnmodButton = button;
                    button.setText("Mod");
                } else if (commandName.equalsIgnoreCase("automod_approve")) {
                    button.setVisible(false);
                    this.approveButton = button;
                    this.commands.put(button, this.approveCommand);
                } else if (commandName.equalsIgnoreCase("automod_deny")) {
                    button.setVisible(false);
                    this.denyButton = button;
                    this.commands.put(button, this.denyCommand);
                }
            }
            this.addShortcut(item.getKey(), button, secondaryButton, this.noKeyLabels);
        }
    }

    public JPanel getRow(String row) {
        if (row == null) {
            row = "a1";
        }
        if (row.equals("More..")) {
            row = "b1";
        }
        if (!this.rows.containsKey(row)) {
            JPanel newRow = new JPanel();
            ((FlowLayout)newRow.getLayout()).setVgap(4);
            ((FlowLayout)newRow.getLayout()).setHgap(5);
            if (row.startsWith("a")) {
                this.primary.add(newRow);
            } else {
                this.secondary.add(newRow);
            }
            this.rows.put(row, newRow);
        }
        return this.rows.get(row);
    }

    public CustomCommand getCommand(JButton button) {
        return this.commands.get(button);
    }

    public JPanel getPrimary() {
        return this.primary;
    }

    public JPanel getSecondary() {
        return this.secondary;
    }

    private void addShortcut(String key, final JButton button, boolean smallButton, boolean noKeyLabel) {
        KeyStroke keyStroke;
        int index;
        String label = null;
        if (key != null && (index = key.indexOf("|")) > 0) {
            label = key.substring(index + 1);
            key = key.substring(0, index);
        }
        if ((keyStroke = this.getKeyStroke(key)) == null) {
            return;
        }
        if (!noKeyLabel && label == null) {
            label = key;
        }
        if (label != null && !label.isEmpty()) {
            button.setText("<html>" + button.getText() + "<span style='font-size:0.85em;font-weight:normal;color:gray;'> [" + label + "]");
            if (smallButton) {
                button.setMargin(GuiUtil.SPECIAL_SMALL_BUTTON_INSETS);
            } else {
                button.setMargin(GuiUtil.SPECIAL_BUTTON_INSETS);
            }
        }
        button.setToolTipText(String.format("%s<br />Shortcut: %s", button.getToolTipText(), key));
        this.owner.getRootPane().getInputMap(2).put(keyStroke, button);
        this.owner.getRootPane().getActionMap().put(button, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Buttons.this.owner.getFocusOwner().getClass() == JTextField.class) {
                    return;
                }
                button.doClick();
            }
        });
    }

    private KeyStroke getKeyStroke(String key) {
        return KeyStroke.getKeyStroke(key != null ? key.replace("+", " ") : key);
    }

    private void clearShortcut(JButton button) {
        this.owner.getRootPane().getActionMap().remove(button);
    }

    protected void updateButtonForParameters(Parameters parameters) {
        for (Map.Entry<JButton, CustomCommand> entry : this.commands.entrySet()) {
            JButton button = entry.getKey();
            CustomCommand command = entry.getValue();
            boolean allParams = !command.hasError() && parameters.notEmpty(command.getRequiredIdentifiers());
            button.setEnabled(allParams);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateButtonRows() {
        for (JPanel row : this.rows.values()) {
            boolean hasVisibleElements = false;
            Object object = row.getTreeLock();
            synchronized (object) {
                for (int i = 0; i < row.getComponentCount(); ++i) {
                    if (!row.getComponent(i).isVisible()) continue;
                    hasVisibleElements = true;
                    break;
                }
            }
            row.setVisible(hasVisibleElements);
        }
    }
}

