/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.userinfo;

import chatty.Helper;
import chatty.User;
import chatty.gui.components.menus.ContextMenu;
import chatty.gui.components.menus.ContextMenuListener;
import chatty.gui.components.userinfo.UserInfoDialog;
import chatty.gui.components.userinfo.Util;
import chatty.lang.Language;
import chatty.util.DateTime;
import chatty.util.Debugging;
import chatty.util.StringUtil;
import chatty.util.api.BadgeManager;
import chatty.util.api.Follower;
import chatty.util.api.FollowerInfo;
import chatty.util.api.TwitchApi;
import chatty.util.api.UserInfo;
import chatty.util.colors.HtmlColors;
import chatty.util.commands.CustomCommand;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class InfoPanel
extends JPanel {
    private final UserInfoDialog owner;
    private final JPanel panel1 = new JPanel();
    private final JPanel panel2 = new JPanel();
    private final SizeMagicLabel numberOfLines = new SizeMagicLabel();
    private final JLabel colorInfo = new JLabel("Color: #123456");
    private final SizeMagicLabel createdAt = new SizeMagicLabel();
    private final JLabel followers = new JLabel();
    private final SizeMagicLabel firstSeen = new SizeMagicLabel();
    private final SizeMagicLabel followedAt = new SizeMagicLabel();
    private final SizeMagicLabel subscribed = new SizeMagicLabel();
    private final SizeMagic infoLabelSize;
    private User currentUser;
    private UserInfo currentUserInfo;
    private Follower currentFollower;
    protected static final CustomCommand COMMAND_FOLLOW_AGE = CustomCommand.parse("$$(nick) has been following for $$(followage)");
    protected static final CustomCommand COMMAND_ACCOUNT_AGE = CustomCommand.parse("$$(nick) has been registered for $$(accountage)");

    public InfoPanel(UserInfoDialog owner, ContextMenuListener listener) {
        this.owner = owner;
        this.panel1.setLayout(new FlowLayout(1, 10, 2));
        this.panel2.setLayout(new FlowLayout(1, 10, 1));
        this.panel1.add(this.numberOfLines);
        this.panel1.add(this.firstSeen);
        this.panel1.add(this.followedAt);
        this.panel1.add(this.subscribed);
        this.panel2.add(this.colorInfo);
        this.panel2.add(this.followers);
        this.panel2.add(this.createdAt);
        this.followedAt.setComponentPopupMenu(new DataContextMenu("following", listener));
        this.createdAt.setComponentPopupMenu(new DataContextMenu("account", listener));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.panel1, Util.makeGbc(0, 0, 1, 1));
        this.add((Component)this.panel2, Util.makeGbc(0, 1, 1, 1));
        Timer updateTimer = new Timer(60000, e -> this.updateTimes(false));
        updateTimer.setRepeats(true);
        updateTimer.start();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SwingUtilities.invokeLater(() -> InfoPanel.this.infoLabelSize.check());
            }
        });
        this.infoLabelSize = new SizeMagic(this, false);
        this.infoLabelSize.register(this.firstSeen);
        this.infoLabelSize.register(this.followedAt);
        this.infoLabelSize.register(this.subscribed);
        this.infoLabelSize.register(this.createdAt);
        this.infoLabelSize.register(this.numberOfLines);
    }

    public void update(User user) {
        if (user != this.currentUser) {
            this.currentUser = user;
            this.showInfo();
        }
        this.numberOfLines.setText(new String[]{"Messages: " + user.getNumberOfMessages(), "Messages: " + user.getNumberOfMessages(), "Msg: " + user.getNumberOfMessages()});
        this.updateColor();
        this.updateSubscribed();
        this.updateTimes(true);
    }

    private void updateTimes(boolean force) {
        if (!this.owner.isVisible() && !force) {
            return;
        }
        if (this.currentUser != null) {
            if (this.currentUser.getFirstSeen() == -1L) {
                this.firstSeen.setText("First seen: n/a");
                this.firstSeen.setToolTipText(null);
            } else {
                this.firstSeen.setText(new String[]{String.format("First seen: %s ago", this.formatAgoTime(this.currentUser.getFirstSeen(), false)), String.format("First seen: %s ago", this.formatAgoTime(this.currentUser.getFirstSeen(), true))});
                this.firstSeen.setToolTipText(String.format("<html>First seen: %s ago (%s)<br /><br />(Could mean the first message or when the user first joined, during this Chatty session)", InfoPanel.formatAgoTimeVerbose(this.currentUser.getFirstSeen()), DateTime.formatFullDatetime(this.currentUser.getFirstSeen())));
            }
        }
        this.infoLabelSize.check();
    }

    private void updateColor() {
        String colorTooltipText;
        String colorText;
        Color color = this.currentUser.getColor();
        Color correctedColor = this.currentUser.getCorrectedColor();
        String colorNamed = HtmlColors.getNamedColorString(color);
        String correctedColorNamed = HtmlColors.getNamedColorString(correctedColor);
        String colorCode = HtmlColors.getColorString(color);
        String correctedColorCode = HtmlColors.getColorString(correctedColor);
        if (this.currentUser.hasCustomColor()) {
            Color plainColor = this.currentUser.getPlainColor();
            colorText = "Color: " + colorNamed + "**" + (this.currentUser.hasDefaultColor() ? "*" : "");
            colorTooltipText = String.format("Custom Color: %s (Original: %s/%s%s)", colorCode, HtmlColors.getNamedColorString(plainColor), HtmlColors.getColorString(plainColor), this.currentUser.hasDefaultColor() ? " (default)" : "");
        } else if (this.currentUser.hasDefaultColor()) {
            colorText = "Color: " + colorNamed + "*";
            colorTooltipText = "Color: " + colorCode + " (default)";
        } else if (this.currentUser.hasCorrectedColor() && !colorCode.equals(correctedColorCode)) {
            colorText = "Color: " + correctedColorNamed + " (" + colorNamed + ")";
            colorTooltipText = "Corrected Color: " + correctedColorCode + " (Original: " + colorNamed + "/" + colorCode + ")";
        } else {
            colorText = "Color: " + colorNamed;
            colorTooltipText = "Color: " + colorCode;
        }
        this.colorInfo.setText(colorText);
        this.colorInfo.setToolTipText(colorTooltipText);
    }

    private void updateSubscribed() {
        User user = this.currentUser;
        this.subscribed.setToolTipText("");
        if (user.getSubMonths() > 0) {
            this.subscribed.setText(new String[]{String.format("Subscribed: %d %s", user.getSubMonths(), StringUtil.plural("month", user.getSubMonths())), String.format("Sub: %d mo.", user.getSubMonths())});
            if (user.getTwitchBadges() != null) {
                String info = "";
                block8: for (int i = 0; i < user.getTwitchBadges().size(); ++i) {
                    String id = user.getTwitchBadges().getId(i);
                    String version = user.getTwitchBadges().getVersion(i);
                    switch (id) {
                        case "founder": {
                            info = "Founder";
                            continue block8;
                        }
                        case "subscriber": {
                            info = BadgeManager.makeSubscriberTitle(version);
                        }
                    }
                }
                this.subscribed.setToolTipText(String.format("<html>%s Badge, %d total months<br /><br />(All subscriber info depends on the sub badge attached to a chat message.)", info, user.getSubMonths()));
            }
        } else {
            this.subscribed.setText("");
        }
    }

    private void showInfo() {
        UserInfo requestedInfo = this.owner.getUserInfo();
        this.currentUserInfo = null;
        if (requestedInfo == null) {
            this.createdAt.setText(Language.getString("userDialog.loading"));
            this.createdAt.setToolTipText(null);
            this.followers.setText(null);
            this.panel2.setToolTipText(null);
        } else {
            this.setUserInfo(requestedInfo);
        }
        this.owner.getFollowCount();
        Follower follow = this.owner.getFollowInfo(false);
        this.currentFollower = null;
        if (follow == null) {
            this.followedAt.setText(Language.getString("userDialog.loading"));
            this.followedAt.setToolTipText(null);
            this.followedAt.setVisible(false);
        } else {
            this.setFollowInfo(follow, TwitchApi.RequestResultCode.SUCCESS);
        }
        this.owner.updateButtons();
    }

    public void setUserInfo(UserInfo info) {
        if (info != null) {
            this.currentUserInfo = info;
            this.createdAt.setText(new String[]{Language.getString("userDialog.registered", this.formatAgoTime(info.createdAt, false)), Language.getString("userDialog.registered", this.formatAgoTime(info.createdAt, true)), "Reg. " + this.formatAgoTime(info.createdAt, true)});
            String tooltip = String.format("<html>Registered: %3$s ago (%4$s)<br />ID: %5$s<br />Type: %6$s<br /><br />Views: %2$s<br /><br />%1$s<br /><br />(Info may not be entirely up-to-date)", !StringUtil.isNullOrEmpty(info.description) ? StringUtil.addLinebreaks(Helper.htmlspecialchars_encode(info.description), 70, true) : "No description", Helper.formatViewerCount(info.views), InfoPanel.formatAgoTimeVerbose(info.createdAt), DateTime.formatFullDatetime(info.createdAt), info.id, !StringUtil.isNullOrEmpty(info.broadcasterType) ? StringUtil.firstToUpperCase(info.broadcasterType) : "Regular");
            this.createdAt.setToolTipText(tooltip);
            if (this.currentUser.getId() == null) {
                this.currentUser.setId(info.id);
            }
            this.owner.updateButtons();
        } else {
            this.createdAt.setText(Language.getString("userDialog.error"));
        }
        this.infoLabelSize.check();
    }

    public void setFollowInfo(Follower follower, TwitchApi.RequestResultCode result) {
        this.followedAt.setVisible(true);
        if (result == TwitchApi.RequestResultCode.SUCCESS && follower.follow_time != -1L) {
            this.followedAt.setText(new String[]{Language.getString("userDialog.followed", this.formatAgoTime(follower.follow_time, false)), Language.getString("userDialog.followed", this.formatAgoTime(follower.follow_time, true))});
            this.followedAt.setToolTipText(Language.getString("userDialog.followed.tip", InfoPanel.formatAgoTimeVerbose(follower.follow_time), DateTime.formatFullDatetime(follower.follow_time)));
            this.currentFollower = follower;
        } else if (result == TwitchApi.RequestResultCode.NOT_FOUND) {
            this.followedAt.setText(Language.getString("userDialog.notFollowing"));
            this.followedAt.setToolTipText(null);
        } else {
            this.followedAt.setText(Language.getString("userDialog.error"));
            this.followedAt.setToolTipText(null);
        }
        this.owner.updateButtons();
        this.infoLabelSize.check();
    }

    public void setFollowerInfo(FollowerInfo info) {
        this.followers.setText(Language.getString("userDialog.followers", Helper.formatViewerCount(info.total)));
    }

    private String formatAgoTime(long time, boolean compact) {
        return DateTime.formatAccountAgeCompact(time, compact);
    }

    private static String formatAgoTimeVerbose(long time) {
        return DateTime.formatAccountAgeVerbose(time);
    }

    protected String getFollowAge() {
        if (this.currentFollower != null) {
            return InfoPanel.formatAgoTimeVerbose(this.currentFollower.follow_time);
        }
        return null;
    }

    protected String getFollowDate() {
        if (this.currentFollower != null) {
            return DateTime.formatFullDatetime(this.currentFollower.follow_time);
        }
        return null;
    }

    protected String getAccountAge() {
        if (this.currentUserInfo != null) {
            return InfoPanel.formatAgoTimeVerbose(this.currentUserInfo.createdAt);
        }
        return null;
    }

    protected String getAccountDate() {
        if (this.currentUserInfo != null) {
            return DateTime.formatFullDatetime(this.currentUserInfo.createdAt);
        }
        return null;
    }

    protected String getChannelInfoTooltipText() {
        if (this.currentUserInfo != null) {
            return this.createdAt.getToolTipText().replace("<br />", "\n").replace("<html>", "");
        }
        return null;
    }

    protected void setRefreshingFollowAge() {
        this.followedAt.setText(Language.getString("userDialog.loading"));
    }

    private static class SizeMagic {
        private final Set<SizeMagicLabel> components = new HashSet<SizeMagicLabel>();
        private final Component reference;
        private final boolean autoCheck;
        private int currentSize = 0;

        SizeMagic(Component reference, boolean autoCheck) {
            this.reference = reference;
            this.autoCheck = autoCheck;
        }

        public void register(SizeMagicLabel component) {
            this.components.add(component);
            if (this.autoCheck) {
                component.setController(this);
            }
        }

        public void check() {
            if (this.reference.getWidth() == 0) {
                return;
            }
            Debugging.println("sizemagic", "---", new Object[0]);
            if (!this.enoughSpace()) {
                boolean anyChanged;
                do {
                    ++this.currentSize;
                    Debugging.println("sizemagic", "- -> " + this.currentSize, new Object[0]);
                    if (!this.isValidSize(this.currentSize)) {
                        Debugging.println("sizemagic", "invalid size", new Object[0]);
                        --this.currentSize;
                    } else {
                        anyChanged = this.setSize(this.currentSize);
                        if (!anyChanged) {
                            --this.currentSize;
                            Debugging.println("sizemagic", "!anyChanged", new Object[0]);
                            continue;
                        }
                        if (!this.enoughSpace()) continue;
                        Debugging.println("sizemagic", "Enough", new Object[0]);
                    }
                    break;
                } while (anyChanged);
            } else {
                boolean anyChanged;
                do {
                    --this.currentSize;
                    Debugging.println("sizemagic", "+ -> " + this.currentSize, new Object[0]);
                    if (!this.isValidSize(this.currentSize)) {
                        Debugging.println("sizemagic", "invalid size", new Object[0]);
                        ++this.currentSize;
                        break;
                    }
                    anyChanged = this.setSize(this.currentSize);
                    if (!anyChanged) {
                        ++this.currentSize;
                        Debugging.println("sizemagic", "!anyChanged", new Object[0]);
                        continue;
                    }
                    if (this.enoughSpace()) continue;
                    ++this.currentSize;
                    this.setSize(this.currentSize);
                    Debugging.println("sizemagic", "revert", new Object[0]);
                    break;
                } while (anyChanged);
            }
        }

        private boolean setSize(int size) {
            boolean anyChanged = false;
            for (SizeMagicLabel label : this.components) {
                if (!label.setTextSize(size)) continue;
                anyChanged = true;
            }
            return anyChanged;
        }

        private boolean isValidSize(int size) {
            for (SizeMagicLabel label : this.components) {
                if (!label.isValidSize(size)) continue;
                return true;
            }
            return false;
        }

        private boolean enoughSpace() {
            Debugging.println("sizemagic", this.reference.getPreferredSize().width + " <= " + this.reference.getWidth(), new Object[0]);
            return this.reference.getPreferredSize().width <= this.reference.getWidth();
        }
    }

    private static class SizeMagicLabel
    extends JLabel {
        private String[] texts;
        private int currentTextSize = 0;
        private SizeMagic controller;

        private SizeMagicLabel() {
        }

        public void setController(SizeMagic controller) {
            this.controller = controller;
        }

        public void setText(String[] texts) {
            boolean textChanged = !Arrays.equals(texts, this.texts);
            this.texts = texts;
            if (this.currentTextSize >= texts.length) {
                this.currentTextSize = texts.length - 1;
            }
            this.updateText();
            if (this.controller != null && textChanged) {
                this.controller.check();
            }
        }

        @Override
        public void setText(String text) {
            this.setText(new String[]{text});
        }

        private void updateText() {
            if (this.texts.length == 0) {
                super.setText(null);
            } else {
                super.setText(this.texts[this.currentTextSize]);
            }
        }

        public boolean setTextSize(int size) {
            if (size >= this.texts.length) {
                size = this.texts.length - 1;
            }
            if (size < 0) {
                size = 0;
            }
            if (size != this.currentTextSize) {
                Debugging.println("sizemagic", "%d -> %d %s", this.currentTextSize, size, StringUtil.join(this.texts));
                this.currentTextSize = size;
                this.updateText();
                return true;
            }
            return false;
        }

        public boolean isValidSize(int size) {
            return size >= 0 && size < this.texts.length;
        }
    }

    private static class DataContextMenu
    extends ContextMenu {
        private final ContextMenuListener listener;

        public DataContextMenu(String type, ContextMenuListener listener) {
            this.listener = listener;
            if (type.equals("userid")) {
                this.addItem("copyUserId", "Copy User ID");
            } else if (type.equals("following")) {
                this.addItem("sendFollowAge", "Send Follow Age message");
                this.addItem("copyFollowAge", "Copy Follow Age");
                this.addSeparator();
                this.addItem("refresh", "Refresh");
            } else if (type.equals("account")) {
                this.addItem("sendAccountAge", "Send Account Age message");
                this.addItem("copyAccountAge", "Copy Account Age");
                this.addSeparator();
                this.addItem("copyUserId", "Copy ID");
                this.addItem("copyChannelInfo", "Copy Full Info (Tooltip)");
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.listener.menuItemClicked(e);
        }
    }
}

