/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.userinfo;

import chatty.User;
import chatty.util.MiscUtil;
import chatty.util.RepeatMsgHelper;
import chatty.util.StringUtil;
import chatty.util.Timestamp;
import chatty.util.colors.ColorCorrectionNew;
import chatty.util.settings.Settings;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;

public class PastMessages
extends JTextArea {
    private Timestamp timestampFormat = new Timestamp("[HH:mm:ss]", "");
    private String currentMessageIdMessage;
    private final RepeatMsgHelper repeatHelper;
    private final Settings settings;
    private final Map<Integer, Integer> highlights = new HashMap<Integer, Integer>();
    private int highlightStart;
    private final DefaultHighlighter.DefaultHighlightPainter highlightPainter;
    public static final int CURRENT_MSG = 1;
    public static final int REPEATED_MSG = 2;
    public static final int MOD_ACTION = 4;
    public static final int AUTO_MOD = 8;
    public static final int LOW_TRUST = 16;

    public PastMessages(RepeatMsgHelper repeat, Settings settings) {
        this.setEditable(false);
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.repeatHelper = repeat;
        this.settings = settings;
        this.highlightPainter = new DefaultHighlighter.DefaultHighlightPainter(ColorCorrectionNew.offset(this.getBackground(), 0.8f));
    }

    public String getCurrentMessage() {
        return this.currentMessageIdMessage;
    }

    public void update(User user, String currentMessageId) {
        this.setText(null);
        if (user != null) {
            this.highlights.clear();
            this.setText(this.makeLines(user, currentMessageId));
            for (Map.Entry<Integer, Integer> entry : this.highlights.entrySet()) {
                try {
                    this.getHighlighter().addHighlight(entry.getKey(), entry.getValue(), this.highlightPainter);
                }
                catch (BadLocationException badLocationException) {}
            }
        }
    }

    private void startHighlight(int pos, int type) {
        if (MiscUtil.isBitEnabled((int)this.settings.getLong("userMessagesHighlight"), type)) {
            this.highlightStart = pos;
        }
    }

    private void endHighlight(int pos, int type) {
        if (MiscUtil.isBitEnabled((int)this.settings.getLong("userMessagesHighlight"), type) && pos > this.highlightStart) {
            this.highlights.put(this.highlightStart, pos);
        }
    }

    private String makeLines(User user, String currentMessageId) {
        StringBuilder b = new StringBuilder();
        if (user.linesCleared()) {
            b.append("<some lines cleared due to user inactivity>\n");
        }
        if (user.maxLinesExceeded()) {
            b.append("<only last ");
            b.append(user.getMaxNumberOfLines());
            b.append(" lines are saved>\n");
        }
        String currentMsgText = user.getMessageText(currentMessageId);
        String lowTrustInfo = null;
        int messageCountSinceLowTrustInfo = 0;
        List<User.Message> messages = user.getMessages();
        int currentDay = 0;
        for (User.Message m : messages) {
            User.Message ma;
            int simPercentage;
            ++messageCountSinceLowTrustInfo;
            LocalDateTime date = LocalDateTime.ofInstant(Instant.ofEpochMilli(m.getTime()), ZoneId.systemDefault());
            if (date.getDayOfMonth() != currentDay) {
                currentDay = date.getDayOfMonth();
                b.append("- ");
                b.append(date.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.FULL)));
                b.append(" -");
                b.append("\n");
            }
            if (m instanceof User.TextMessage) {
                User.TextMessage tm = (User.TextMessage)m;
                if (!(tm.lowTrust == null || lowTrustInfo != null && lowTrustInfo.equals(tm.lowTrust.makeInfo()) && messageCountSinceLowTrustInfo <= 4)) {
                    lowTrustInfo = tm.lowTrust.makeInfo();
                    b.append(this.timestampFormat.make(m.getTime(), user.getRoom())).append("I ");
                    this.startHighlight(b.length(), 16);
                    b.append(lowTrustInfo);
                    this.endHighlight(b.length(), 16);
                    b.append("\n");
                    messageCountSinceLowTrustInfo = 0;
                }
                simPercentage = 0;
                if (!StringUtil.isNullOrEmpty(currentMessageId) && currentMessageId.equals(tm.id)) {
                    this.startHighlight(b.length(), 1);
                    b.append(">");
                    this.endHighlight(b.length(), 1);
                    this.currentMessageIdMessage = tm.text;
                } else if (currentMsgText != null) {
                    simPercentage = this.repeatHelper.getPercentage(user, tm.text, currentMsgText);
                }
                b.append(this.timestampFormat.make(m.getTime(), user.getRoom()));
                if (tm.lowTrust != null) {
                    this.startHighlight(b.length(), 16);
                    switch (tm.lowTrust.treatment) {
                        case ACTIVE_MONITORING: {
                            b.append("[M]");
                            break;
                        }
                        case RESTRICTED: {
                            b.append("[R]");
                        }
                    }
                    this.endHighlight(b.length(), 16);
                }
                if (simPercentage > 0) {
                    this.startHighlight(b.length() + 1, 2);
                    b.append(" [").append(simPercentage).append("%]");
                    this.endHighlight(b.length(), 2);
                }
                this.addSourceChannel(tm, b);
                if (tm.action) {
                    b.append("* ");
                } else {
                    b.append(" ");
                }
                b.append(tm.text);
                b.append("\n");
                continue;
            }
            if (m instanceof User.BanMessage) {
                User.BanMessage bm = (User.BanMessage)m;
                b.append(this.timestampFormat.make(m.getTime(), user.getRoom()));
                this.addSourceChannel(m, b);
                b.append(">");
                this.startHighlight(b.length(), 4);
                if (bm.duration > 0L) {
                    b.append("Timed out (").append(bm.duration).append("s)");
                } else {
                    b.append("Banned permanently");
                }
                this.endHighlight(b.length(), 4);
                if (bm.id != null) {
                    b.append(" (single message)");
                }
                if (bm.reason != null && !bm.reason.isEmpty()) {
                    b.append(" [").append(bm.reason).append("]");
                }
                if (bm.by != null) {
                    b.append(" (@").append(bm.by).append(")");
                }
                b.append("\n");
                continue;
            }
            if (m instanceof User.UnbanMessage) {
                User.UnbanMessage ubm = (User.UnbanMessage)m;
                b.append(this.timestampFormat.make(m.getTime(), user.getRoom()));
                this.addSourceChannel(m, b);
                b.append(">");
                this.startHighlight(b.length(), 4);
                if (ubm.type == 0) {
                    b.append("Unbanned");
                } else if (ubm.type == 1) {
                    b.append("Timeout removed");
                }
                this.endHighlight(b.length(), 4);
                b.append(" (@").append(ubm.by).append(")");
                b.append("\n");
                continue;
            }
            if (m instanceof User.MsgDeleted) {
                User.MsgDeleted md = (User.MsgDeleted)m;
                b.append(this.timestampFormat.make(m.getTime(), user.getRoom()));
                this.addSourceChannel(m, b);
                b.append(">");
                this.startHighlight(b.length(), 4);
                b.append("Message deleted:");
                this.endHighlight(b.length(), 4);
                b.append(" ").append(md.msg);
                if (md.by != null) {
                    b.append(" (@").append(md.by).append(")");
                }
                b.append("\n");
                continue;
            }
            if (m instanceof User.SubMessage) {
                User.SubMessage sm = (User.SubMessage)m;
                simPercentage = 0;
                if (!StringUtil.isNullOrEmpty(currentMessageId) && currentMessageId.equals(sm.id)) {
                    this.startHighlight(b.length(), 1);
                    b.append(">");
                    this.endHighlight(b.length(), 1);
                    this.currentMessageIdMessage = sm.attached_message;
                } else if (currentMsgText != null) {
                    simPercentage = this.repeatHelper.getPercentage(user, sm.attached_message, currentMsgText);
                }
                b.append(this.timestampFormat.make(m.getTime(), user.getRoom()));
                if (simPercentage > 0) {
                    this.startHighlight(b.length() + 1, 2);
                    b.append(" [").append(simPercentage).append("%]");
                    this.endHighlight(b.length(), 2);
                }
                this.addSourceChannel(sm, b);
                b.append("$ ");
                b.append(sm.system_msg);
                if (!sm.attached_message.isEmpty()) {
                    b.append(" [").append(sm.attached_message).append("]");
                }
                b.append("\n");
                continue;
            }
            if (m instanceof User.InfoMessage) {
                User.InfoMessage im = (User.InfoMessage)m;
                b.append(this.timestampFormat.make(m.getTime(), user.getRoom()));
                this.addSourceChannel(im, b);
                b.append("I ");
                b.append(im.full_text);
                b.append("\n");
                continue;
            }
            if (m instanceof User.WarnMessage) {
                User.WarnMessage wm = (User.WarnMessage)m;
                b.append(this.timestampFormat.make(m.getTime(), user.getRoom())).append("! ");
                if (wm.by == null && wm.reason == null) {
                    b.append("Warning acknowledged");
                } else {
                    b.append("Warned by ").append(wm.by).append(" (").append(wm.reason).append(")");
                }
                b.append("\n");
                continue;
            }
            if (m instanceof User.ModAction) {
                ma = (User.ModAction)m;
                b.append(this.timestampFormat.make(m.getTime(), user.getRoom()));
                this.addSourceChannel(m, b);
                b.append(">");
                b.append("ModAction: ");
                b.append(ma.commandAndParameters);
                b.append("\n");
                continue;
            }
            if (!(m instanceof User.AutoModMessage)) continue;
            ma = (User.AutoModMessage)m;
            if (!StringUtil.isNullOrEmpty(currentMessageId) && currentMessageId.equals(((User.AutoModMessage)ma).id)) {
                b.append(">");
            }
            b.append(this.timestampFormat.make(m.getTime(), user.getRoom())).append(">");
            this.startHighlight(b.length(), 8);
            b.append("Filtered by AutoMod");
            switch (((User.AutoModMessage)ma).status) {
                case AUTOMOD_APPROVED: {
                    b.append(":APPROVED");
                    break;
                }
                case AUTOMOD_DENIED: {
                    b.append(":DENIED");
                }
            }
            this.endHighlight(b.length(), 8);
            if (!StringUtil.isNullOrEmpty(((User.AutoModMessage)ma).reason)) {
                b.append(" [").append(((User.AutoModMessage)ma).reason).append("]");
            }
            b.append(": ").append(((User.AutoModMessage)ma).message);
            if (((User.AutoModMessage)ma).moderatorName != null) {
                b.append(" (@").append(((User.AutoModMessage)ma).moderatorName).append(")");
            }
            b.append("\n");
        }
        if (b.length() > 0 && b.charAt(b.length() - 1) == '\n') {
            b.deleteCharAt(b.length() - 1);
        }
        return b.toString();
    }

    public void setTimestampFormat(Timestamp timestampFormat) {
        if (timestampFormat != null) {
            this.timestampFormat = timestampFormat;
        }
    }

    private void addSourceChannel(User.Message m, StringBuilder b) {
        if (m instanceof User.SharedMessage) {
            User.SharedMessage sm = (User.SharedMessage)((Object)m);
            String channel = sm.getSourceChannel();
            b.append("[");
            b.append(channel != null ? channel : "?");
            b.append("]");
        }
    }
}

