/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.userinfo;

import chatty.Helper;
import chatty.User;
import chatty.gui.GuiUtil;
import chatty.gui.MainGui;
import chatty.gui.components.menus.ContextMenuAdapter;
import chatty.gui.components.menus.ContextMenuListener;
import chatty.gui.components.menus.UserContextMenu;
import chatty.gui.components.userinfo.BanReasons;
import chatty.gui.components.userinfo.Buttons;
import chatty.gui.components.userinfo.InfoPanel;
import chatty.gui.components.userinfo.PastMessages;
import chatty.gui.components.userinfo.UserInfoListener;
import chatty.gui.components.userinfo.UserInfoRequester;
import chatty.gui.components.userinfo.UserNotes;
import chatty.gui.components.userinfo.Util;
import chatty.lang.Language;
import chatty.util.MiscUtil;
import chatty.util.Pronouns;
import chatty.util.StringUtil;
import chatty.util.Timestamp;
import chatty.util.api.Follower;
import chatty.util.api.FollowerInfo;
import chatty.util.api.TwitchApi;
import chatty.util.api.UserInfo;
import chatty.util.commands.CustomCommand;
import chatty.util.commands.Parameters;
import chatty.util.settings.Settings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Objects;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class UserInfoDialog
extends JDialog {
    private static final String SINGLE_MESSAGE_CHECK = "Remove only selected message";
    private final InfoPanel infoPanel;
    private final PastMessages pastMessages;
    private final JButton closeButton = new JButton(Language.getString("dialog.button.close"));
    private final JCheckBox pinnedDialog = new JCheckBox(Language.getString("userDialog.setting.pin"));
    private final JButton notesButton = new JButton("Notes");
    private final JCheckBox singleMessage = new JCheckBox("Remove only selected message");
    private final BanReasons banReasons;
    private final Buttons buttons;
    private User currentUser;
    private String currentLocalUsername;
    private String currentMsgId;
    private String currentAutoModMsgId;
    private float fontSize;
    private final UserInfoRequester requester;
    private final Settings settings;

    public UserInfoDialog(Window parent, final UserInfoListener listener, UserInfoRequester requester, final Settings settings, final ContextMenuListener contextMenuListener) {
        super(parent);
        this.setDefaultCloseOperation(2);
        this.requester = requester;
        this.settings = settings;
        GuiUtil.installEscapeCloseOperation(this);
        this.banReasons = new BanReasons(this, settings);
        this.buttons = new Buttons(this, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomCommand command;
                if (settings.getBoolean("closeUserDialogOnAction") && !UserInfoDialog.this.isPinned()) {
                    UserInfoDialog.this.dispose();
                }
                if ((command = UserInfoDialog.this.getCommand(e.getSource())) == null) {
                    return;
                }
                if (listener != null) {
                    listener.anonCustomCommand(UserInfoDialog.this.getUser().getRoom(), command, UserInfoDialog.this.makeParameters());
                }
            }
        });
        this.closeButton.addActionListener(e -> this.dispose());
        this.setLayout(new GridBagLayout());
        JPanel topPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = Util.makeGbc(0, 0, 4, 1);
        gbc.insets = new Insets(2, 2, 0, 2);
        topPanel.add((Component)this.buttons.getPrimary(), gbc);
        gbc = Util.makeGbc(0, 3, 3, 1);
        gbc.insets = new Insets(0, 6, 2, 2);
        gbc.anchor = 10;
        this.singleMessage.setToolTipText("When doing a ban/timeout only remove a single message of that user [S to toggle]");
        JComboBox<String> reasons = new JComboBox<String>();
        reasons.addItem("-- Select Ban/Timeout Reason --");
        reasons.addItem("No CatBag posted");
        reasons.addItem("Custom Ban/Timeout Reason:");
        gbc = Util.makeGbc(0, 1, 1, 1);
        gbc.insets = new Insets(2, 8, 5, 7);
        gbc.anchor = 17;
        topPanel.add((Component)this.banReasons, gbc);
        gbc = Util.makeGbc(2, 1, 1, 1);
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        GuiUtil.smallButtonInsets(this.notesButton);
        this.notesButton.addActionListener(e -> UserNotes.instance().showDialog(this.currentUser, this, user -> {
            if (user == this.currentUser) {
                this.updateStuff(this.currentUser);
            }
        }));
        topPanel.add((Component)this.notesButton, gbc);
        gbc = Util.makeGbc(3, 1, 1, 1);
        gbc.insets = new Insets(2, 8, 2, 8);
        gbc.anchor = 13;
        this.pinnedDialog.setToolTipText(Language.getString("userDialog.setting.pin.tip"));
        topPanel.add((Component)this.pinnedDialog, gbc);
        gbc = Util.makeGbc(0, 0, 3, 1);
        gbc.insets = new Insets(0, 0, 0, 0);
        this.add((Component)topPanel, gbc);
        this.pastMessages = parent instanceof MainGui ? new PastMessages(((MainGui)parent).repeatMsg, settings) : new PastMessages(null, settings);
        this.pastMessages.setRows(4);
        this.pastMessages.setPreferredSize(this.pastMessages.getPreferredSize());
        JScrollPane scrollPane = new JScrollPane(this.pastMessages);
        scrollPane.setPreferredSize(scrollPane.getPreferredSize());
        this.pastMessages.setRows(0);
        this.pastMessages.setPreferredSize(null);
        gbc = Util.makeGbc(0, 4, 3, 1);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.9;
        this.add((Component)scrollPane, gbc);
        gbc = Util.makeGbc(0, 5, 3, 1);
        gbc.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.buttons.getSecondary(), gbc);
        this.infoPanel = new InfoPanel(this, new ContextMenuAdapter(){

            @Override
            public void menuItemClicked(ActionEvent e) {
                switch (e.getActionCommand()) {
                    case "copyUserId": {
                        MiscUtil.copyToClipboard(UserInfoDialog.this.currentUser.getId());
                        break;
                    }
                    case "sendFollowAge": {
                        listener.anonCustomCommand(UserInfoDialog.this.getUser().getRoom(), InfoPanel.COMMAND_FOLLOW_AGE, UserInfoDialog.this.makeParameters());
                        break;
                    }
                    case "copyFollowAge": {
                        MiscUtil.copyToClipboard(InfoPanel.COMMAND_FOLLOW_AGE.replace(UserInfoDialog.this.makeParameters()));
                        break;
                    }
                    case "sendAccountAge": {
                        listener.anonCustomCommand(UserInfoDialog.this.getUser().getRoom(), InfoPanel.COMMAND_ACCOUNT_AGE, UserInfoDialog.this.makeParameters());
                        break;
                    }
                    case "copyAccountAge": {
                        MiscUtil.copyToClipboard(InfoPanel.COMMAND_ACCOUNT_AGE.replace(UserInfoDialog.this.makeParameters()));
                        break;
                    }
                    case "refresh": {
                        UserInfoDialog.this.infoPanel.setRefreshingFollowAge();
                        UserInfoDialog.this.getFollowInfo(true);
                        break;
                    }
                    case "copyChannelInfo": {
                        MiscUtil.copyToClipboard(UserInfoDialog.this.infoPanel.getChannelInfoTooltipText());
                    }
                }
            }
        });
        gbc = Util.makeGbc(0, 6, 3, 1);
        gbc.fill = 2;
        gbc.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.infoPanel, gbc);
        gbc = Util.makeGbc(0, 8, 3, 1);
        gbc.fill = 2;
        gbc.insets = new Insets(8, 5, 3, 5);
        this.add((Component)this.closeButton, gbc);
        this.buttons.set("30,120,600,1800", false, Parameters.create(""));
        this.finishDialog();
        this.getContentPane().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopupMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopupMenu(e);
                }
            }

            private void showPopupMenu(MouseEvent e) {
                if (contextMenuListener != null) {
                    UserContextMenu menu = new UserContextMenu(UserInfoDialog.this.currentUser, UserInfoDialog.this.currentMsgId, UserInfoDialog.this.currentAutoModMsgId, contextMenuListener);
                    menu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    public CustomCommand getCommand(Object object) {
        if (object instanceof JButton) {
            return this.buttons.getCommand((JButton)object);
        }
        return null;
    }

    private Parameters makeParameters() {
        User user = this.getUser();
        String nick = user.getName();
        String reason = this.getBanReason();
        if (!reason.isEmpty()) {
            reason = " " + reason;
        }
        Parameters parameters = Parameters.create(nick + reason);
        Helper.addUserParameters(user, this.getMsgId(), this.getAutoModMsgId(), parameters);
        parameters.put("reason", reason);
        parameters.put("target-msg-id", this.getTargetMsgId());
        parameters.put("followage", this.infoPanel.getFollowAge());
        parameters.put("followdate", this.infoPanel.getFollowDate());
        parameters.put("accountage", this.infoPanel.getAccountAge());
        parameters.put("accountdate", this.infoPanel.getAccountDate());
        return parameters;
    }

    protected void updateButtons() {
        if (this.currentUser == null) {
            return;
        }
        this.buttons.updateButtonForParameters(this.makeParameters());
        boolean localIsStreamer = this.currentUser.getStream() != null && this.currentUser.getStream().equalsIgnoreCase(this.currentLocalUsername);
        this.buttons.updateModButtons(localIsStreamer, this.currentUser.isModerator());
        this.buttons.updateAutoModButtons(this.currentAutoModMsgId);
        this.buttons.updateButtonRows();
    }

    public void setFontSize(float size) {
        if (size != this.fontSize) {
            GuiUtil.setFontSize(size, this);
            this.finishDialog();
        }
        this.fontSize = size;
    }

    public void setUserDefinedButtonsDef(String def, boolean isTest) {
        this.buttons.set(def, isTest, this.currentUser != null ? this.makeParameters() : null);
        this.updateButtons();
        GuiUtil.setFontSize(this.fontSize, this);
        this.banReasons.addCustomInput();
        this.finishDialog();
        this.banReasons.removeCustomInput();
        this.banReasons.updateHotkey();
    }

    private void updateMessages() {
        this.pastMessages.update(this.currentUser, this.currentMsgId != null ? this.currentMsgId : this.currentAutoModMsgId);
    }

    public void setTimestampFormat(Timestamp timestampFormat) {
        this.pastMessages.setTimestampFormat(timestampFormat);
        this.updateMessages();
    }

    protected void finishDialog() {
        this.setMinimumSize(this.getPreferredSize());
    }

    private void setUser(User user, String msgId, String autoModMsgId, String localUsername, boolean opened) {
        if (this.currentUser != user) {
            this.currentUser = user;
            this.currentMsgId = msgId;
            this.currentAutoModMsgId = autoModMsgId;
        }
        if (msgId != null || autoModMsgId != null) {
            this.currentMsgId = msgId;
            this.currentAutoModMsgId = autoModMsgId;
        }
        this.currentLocalUsername = localUsername;
        this.updateStuff(user);
        this.updateMessages();
        this.infoPanel.update(user);
        this.singleMessage.setEnabled(this.currentMsgId != null);
        if (opened) {
            this.buttons.removeAndAddButtons(this.makeParameters());
        }
        this.updateButtons();
        this.finishDialog();
    }

    private void updateStuff(User user) {
        this.updateTitle(user, null);
        if (this.settings.getBoolean("pronouns")) {
            Pronouns.instance().getUser((username, pronoun) -> {
                if (this.currentUser.getName().equals(username)) {
                    this.updateTitle(user, (String)pronoun);
                }
            }, user.getName());
        }
        this.notesButton.setText(UserNotes.instance().hasNotes(user) ? "Notes*" : "Notes");
    }

    private void updateTitle(User user, String additionalInfo) {
        String categoriesString = "";
        Set<String> categories = user.getCategories();
        if (categories != null && !categories.isEmpty()) {
            categoriesString = categories.toString();
        }
        String displayNickInfo = user.hasDisplayNickSet() ? "" : "*";
        additionalInfo = StringUtil.append(UserNotes.instance().getChatNotes(user), ", ", additionalInfo);
        this.setTitle(Language.getString("userDialog.title") + " " + user.toString() + (user.hasCustomNickSet() ? " (" + user.getDisplayNick() + ")" : "") + (!user.hasRegularDisplayNick() ? " (" + user.getName() + ")" : "") + displayNickInfo + (additionalInfo != null ? " (" + additionalInfo + ")" : "") + " / " + user.getRoom().getDisplayName() + " " + categoriesString);
    }

    public void show(Component owner, User user, String msgId, String autoModMsgId, String localUsername) {
        if (user == this.currentUser && this.isVisible()) {
            if (Objects.equals(this.currentMsgId, msgId)) {
                GuiUtil.shake(this, 2, 2);
            } else {
                GuiUtil.shake(this, 1, 1);
            }
        }
        this.banReasons.updateReasonsFromSettings();
        this.banReasons.reset();
        this.singleMessage.setSelected(false);
        this.setUser(user, msgId, autoModMsgId, localUsername, true);
        this.setVisible(true);
        this.closeButton.requestFocusInWindow();
    }

    public void update(User user, String localUsername) {
        if (this.currentUser == user && this.isVisible()) {
            this.setUser(user, null, null, localUsername, false);
        }
    }

    public User getUser() {
        return this.currentUser;
    }

    public String getChannel() {
        return this.currentUser.getChannel();
    }

    public String getMsgId() {
        return this.currentMsgId;
    }

    public String getMsg() {
        if (this.currentUser != null) {
            return this.currentUser.getMessageText(this.currentMsgId);
        }
        return null;
    }

    public String getTargetMsgId() {
        if (this.singleMessage.isSelected()) {
            return this.currentMsgId;
        }
        return null;
    }

    public String getAutoModMsgId() {
        return this.currentAutoModMsgId;
    }

    public String getBanReason() {
        return this.banReasons.getSelectedReason();
    }

    public boolean isPinned() {
        return this.pinnedDialog.isSelected();
    }

    public void setPinned(boolean isPinned) {
        this.pinnedDialog.setSelected(isPinned);
    }

    public void setUserInfo(UserInfo info) {
        if (this.currentUser == null || !this.currentUser.getName().equals(info.login)) {
            return;
        }
        this.infoPanel.setUserInfo(info);
        this.updateStuff(this.currentUser);
    }

    protected UserInfo getUserInfo() {
        if (this.requester != null) {
            return this.requester.getCachedUserInfo(this.currentUser.getName(), info -> {
                if (info != null) {
                    SwingUtilities.invokeLater(() -> this.setUserInfo((UserInfo)info));
                }
            });
        }
        return null;
    }

    public void setFollowInfo(String stream, String user, Follower follow, TwitchApi.RequestResultCode result) {
        if (this.currentUser == null || !this.currentUser.getName().equals(user) || !Objects.equals(this.currentUser.getStream(), stream)) {
            return;
        }
        this.infoPanel.setFollowInfo(follow, result);
    }

    protected Follower getFollowInfo(boolean refresh) {
        if (this.requester != null) {
            return this.requester.getSingleFollower(this.currentUser.getStream(), this.currentUser.getRoom().getStreamId(), this.currentUser.getName(), this.currentUser.getId(), refresh);
        }
        return null;
    }

    protected void getFollowCount() {
        if (this.requester != null) {
            this.requester.requestFollowerInfo(this.currentUser.getName());
        }
    }

    public void setFollowerInfo(FollowerInfo info) {
        if (this.currentUser == null || !this.currentUser.getName().equals(info.stream)) {
            return;
        }
        this.infoPanel.setFollowerInfo(info);
    }

    public static enum Action {
        NONE,
        TIMEOUT,
        MOD,
        UNMOD,
        COMMAND;

    }
}

