/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.userinfo;

import chatty.Room;
import chatty.User;
import chatty.gui.GuiUtil;
import chatty.gui.MainGui;
import chatty.gui.components.menus.ContextMenuListener;
import chatty.gui.components.userinfo.UserInfoDialog;
import chatty.gui.components.userinfo.UserInfoListener;
import chatty.gui.components.userinfo.UserInfoRequester;
import chatty.util.RecentlyAffectedUsers;
import chatty.util.Timestamp;
import chatty.util.api.Follower;
import chatty.util.api.FollowerInfo;
import chatty.util.api.TwitchApi;
import chatty.util.api.UserInfo;
import chatty.util.commands.CustomCommand;
import chatty.util.commands.Parameters;
import chatty.util.settings.Settings;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class UserInfoManager {
    private final List<UserInfoDialog> dialogs = new ArrayList<UserInfoDialog>();
    private final WindowListener closeListener;
    private final Window dummyWindow = new Window(null);
    private final MainGui main;
    private final Settings settings;
    private final ContextMenuListener contextMenuListener;
    private final UserInfoListener userInfoListener;
    private final UserInfoRequester userInfoRequester;
    private String buttonsDef;
    private float fontSize;
    private Timestamp timestampFormat;

    public UserInfoManager(MainGui owner, Settings settings, ContextMenuListener contextMenuListener, final TwitchApi api) {
        this.main = owner;
        this.settings = settings;
        this.contextMenuListener = contextMenuListener;
        this.closeListener = new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                UserInfoManager.this.handleClosed(e.getWindow());
            }
        };
        this.userInfoListener = new UserInfoListener(){

            @Override
            public void anonCustomCommand(Room room, CustomCommand command, Parameters parameters) {
                UserInfoManager.this.main.anonCustomCommand(room, command, parameters);
            }
        };
        this.userInfoRequester = new UserInfoRequester(){

            @Override
            public Follower getSingleFollower(String stream, String streamId, String user, String userId, boolean refresh) {
                return api.getSingleFollower(stream, streamId, user, userId, refresh);
            }

            @Override
            public UserInfo getCachedUserInfo(String channel, Consumer<UserInfo> result) {
                return api.getCachedUserInfo(channel, result);
            }

            @Override
            public void requestFollowerInfo(String stream) {
                api.getFollowers(stream, false);
            }
        };
    }

    public Window getDummyWindow() {
        return this.dummyWindow;
    }

    public void setUserDefinedButtonsDef(String def) {
        this.buttonsDef = def;
        for (UserInfoDialog dialog : this.dialogs) {
            dialog.setUserDefinedButtonsDef(def, false);
        }
    }

    public void update(User user, String localUsername) {
        for (UserInfoDialog dialog : this.dialogs) {
            dialog.update(user, localUsername);
        }
    }

    public void setFollowInfo(String stream, String user, TwitchApi.RequestResultCode result, Follower follow) {
        for (UserInfoDialog dialog : this.dialogs) {
            dialog.setFollowInfo(stream, user, follow, result);
        }
    }

    public void setFollowerInfo(FollowerInfo info) {
        for (UserInfoDialog dialog : this.dialogs) {
            dialog.setFollowerInfo(info);
        }
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
        for (UserInfoDialog dialog : this.dialogs) {
            dialog.setFontSize(fontSize);
        }
    }

    public void show(Component owner, User user, String msgId, String autoModMsgId, String localUsername, boolean keepPosition) {
        UserInfoDialog dialogToShow = this.getBestByUser(user);
        if (dialogToShow == null) {
            dialogToShow = this.getFirstUnpinned();
        }
        if (dialogToShow == null) {
            dialogToShow = this.createNew();
            this.setInitialLocationAndSize(dialogToShow);
            this.dialogs.add(dialogToShow);
            this.main.setWindowAttached(dialogToShow, true);
        }
        if (this.settings.getBoolean("openUserDialogByMouse") && !dialogToShow.isPinned() && !keepPosition) {
            GuiUtil.setLocationToMouse(dialogToShow);
        }
        this.saveLocationAndSize(dialogToShow);
        dialogToShow.show(owner, user, msgId, autoModMsgId, localUsername);
    }

    private UserInfoDialog getFirstUnpinned() {
        for (UserInfoDialog dialog : this.dialogs) {
            if (dialog.isPinned()) continue;
            return dialog;
        }
        return null;
    }

    private int numUnpinned() {
        int num = 0;
        for (UserInfoDialog dialog : this.dialogs) {
            if (dialog.isPinned()) continue;
            ++num;
        }
        return num;
    }

    private UserInfoDialog getBestByUser(User user) {
        if (this.settings.getBoolean("reuseUserDialog")) {
            for (UserInfoDialog dialog : this.dialogs) {
                if (dialog.getUser() != user || !dialog.isVisible()) continue;
                return dialog;
            }
        }
        for (UserInfoDialog dialog : this.dialogs) {
            if (dialog.isPinned() || !dialog.isVisible()) continue;
            return dialog;
        }
        return null;
    }

    private UserInfoDialog createNew() {
        UserInfoDialog dialog = new UserInfoDialog(this.main, this.userInfoListener, this.userInfoRequester, this.settings, this.contextMenuListener);
        dialog.setUserDefinedButtonsDef(this.buttonsDef, false);
        dialog.setFontSize(this.fontSize);
        dialog.setTimestampFormat(this.timestampFormat);
        return dialog;
    }

    private void setInitialLocationAndSize(UserInfoDialog dialog) {
        Point targetLocation = this.dummyWindow.getLocation();
        if (this.dummyWindow.getWidth() == 0) {
            targetLocation.translate(-dialog.getWidth() / 2, -dialog.getHeight() / 2);
        }
        if (this.isLocationUsed(targetLocation)) {
            targetLocation.translate(20, 20);
        }
        if (this.dummyWindow.getWidth() > 0) {
            dialog.setSize(this.dummyWindow.getSize());
        } else {
            dialog.setSize(400, 360);
        }
        dialog.setLocation(targetLocation);
        dialog.addWindowListener(this.closeListener);
    }

    private void handleClosed(Component c) {
        UserInfoDialog dialog = (UserInfoDialog)c;
        if (this.canRemove(dialog)) {
            this.dialogs.remove(dialog);
            this.main.setWindowAttached(dialog, false);
        } else {
            dialog.setPinned(false);
        }
        if (!dialog.isPinned() && this.numUnpinned() == 1) {
            this.saveLocationAndSize(dialog);
        }
        RecentlyAffectedUsers.addUser(dialog.getUser());
    }

    private void saveLocationAndSize(Component c) {
        UserInfoDialog dialog = (UserInfoDialog)c;
        if (!dialog.isPinned()) {
            this.dummyWindow.setSize(dialog.getSize());
            this.dummyWindow.setLocation(dialog.getLocation());
        }
    }

    private boolean canRemove(UserInfoDialog dialog) {
        int numUnpinned = this.numUnpinned();
        return dialog.isPinned() || numUnpinned != 1;
    }

    private boolean isLocationUsed(Point location) {
        for (UserInfoDialog dialog : this.dialogs) {
            if (!dialog.getLocation().equals(location)) continue;
            return true;
        }
        return false;
    }

    public void aboutToSaveSettings() {
        UserInfoDialog dialog = this.getFirstUnpinned();
        if (dialog != null) {
            this.dummyWindow.setLocation(dialog.getLocation());
            this.dummyWindow.setSize(dialog.getSize());
        }
    }

    public void setTimestampFormat(Timestamp timestampFormat) {
        this.timestampFormat = timestampFormat;
        for (UserInfoDialog dialog : this.dialogs) {
            dialog.setTimestampFormat(timestampFormat);
        }
    }
}

