/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.components.userinfo;

import chatty.Room;
import chatty.User;
import chatty.gui.GuiUtil;
import chatty.gui.components.menus.TextSelectionMenu;
import chatty.lang.Language;
import chatty.util.Pronouns;
import chatty.util.StringUtil;
import chatty.util.api.TwitchApi;
import chatty.util.settings.Settings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class UserNotes {
    private static final String SETTING_NOTES = "userNotes";
    private static final String SETTING_CHAT_NOTES = "userNotesChat";
    private static UserNotes instance;
    private final TwitchApi api;
    private final Settings settings;

    public static void init(TwitchApi api, Settings settings) {
        instance = new UserNotes(api, settings);
    }

    public static UserNotes instance() {
        return instance;
    }

    private UserNotes(TwitchApi api, Settings settings) {
        this.api = api;
        this.settings = settings;
    }

    public void showDialog(User user, Window parent, Consumer<User> listener) {
        if (user.getId() == null) {
            JOptionPane.showMessageDialog(parent, "User ID not found.");
        } else {
            UserNotesDialog d = new UserNotesDialog(user, parent, this.get(SETTING_CHAT_NOTES, user), this.get(SETTING_NOTES, user));
            d.showDialog(e -> {
                this.set(SETTING_NOTES, user, d.getNotes());
                this.set(SETTING_CHAT_NOTES, user, d.getChatNotes());
                if (listener != null) {
                    listener.accept(user);
                }
            });
        }
    }

    public String getNotes(User user) {
        return this.get(SETTING_NOTES, user);
    }

    public String getNotesForChat(User user) {
        String notes = this.get(SETTING_CHAT_NOTES, user);
        String pronouns = null;
        if (this.settings.getBoolean("pronounsChat")) {
            pronouns = Pronouns.instance().getUser2(user.getName());
        }
        return StringUtil.append(notes, ", ", pronouns);
    }

    public String getChatNotes(User user) {
        return this.get(SETTING_CHAT_NOTES, user);
    }

    public boolean hasNotes(User user) {
        return this.get(SETTING_NOTES, user) != null;
    }

    public String get(String setting, User user) {
        if (user.getId() == null) {
            return null;
        }
        String result = (String)this.settings.mapGet(setting, user.getId());
        if (StringUtil.isNullOrEmpty(result)) {
            return null;
        }
        return result;
    }

    public void set(String setting, User user, String newNotes) {
        if (user.getId() != null) {
            if (StringUtil.isNullOrEmpty(newNotes)) {
                this.settings.mapRemove(setting, user.getId());
            } else {
                this.settings.mapPut(setting, user.getId(), newNotes);
            }
        }
    }

    public static void main(String[] args) {
        User user = new User("abc", Room.EMPTY);
        UserNotesDialog d = new UserNotesDialog(user, null, "chat notes", "regular notes");
        d.showDialog(e -> System.out.println("Save"));
    }

    private static class UserNotesDialog
    extends JDialog {
        private final JTextField chatNotesTextField = new JTextField(20);
        private final JTextArea notesTextArea = new JTextArea();
        private final JButton saveButton = new JButton(Language.getString("dialog.button.save"));
        private final JButton cancelButton = new JButton(Language.getString("dialog.button.cancel"));

        public UserNotesDialog(User user, Window parent, String chatNotes, String notes) {
            super(parent);
            this.setTitle("User Notes: " + user.toString());
            this.setResizable(false);
            this.setDefaultCloseOperation(2);
            this.setLayout(new GridBagLayout());
            this.notesTextArea.setRows(6);
            this.notesTextArea.setColumns(40);
            TextSelectionMenu.install(this.chatNotesTextField);
            TextSelectionMenu.install(this.notesTextArea);
            this.add((Component)new JLabel("Shown in chat messages after the username:"), GuiUtil.makeGbc(0, 1, 2, 1, 17));
            this.add((Component)this.chatNotesTextField, GuiUtil.makeGbc(0, 2, 2, 1, 17));
            this.add((Component)new JLabel("Notes (just shown here):"), GuiUtil.makeGbc(0, 3, 2, 1, 17));
            this.add((Component)new JScrollPane(this.notesTextArea), GuiUtil.makeGbc(0, 4, 2, 1, 17));
            this.add((Component)new JLabel("All notes are stored locally only."), GuiUtil.makeGbc(0, 5, 2, 1, 17));
            GridBagConstraints gbc = GuiUtil.makeGbc(0, 6, 1, 1, 17);
            gbc.weightx = 1.0;
            gbc.fill = 2;
            this.add((Component)this.saveButton, gbc);
            this.add((Component)this.cancelButton, GuiUtil.makeGbc(1, 6, 1, 1, 17));
            this.cancelButton.addActionListener(e -> {
                this.setVisible(false);
                this.dispose();
            });
            this.notesTextArea.setText(notes);
            this.chatNotesTextField.setText(chatNotes);
            this.pack();
            this.setLocationRelativeTo(parent);
        }

        public void showDialog(ActionListener listener) {
            this.saveButton.addActionListener(e -> {
                this.setVisible(false);
                this.dispose();
                listener.actionPerformed(e);
            });
            this.setVisible(true);
        }

        public String getChatNotes() {
            return this.chatNotesTextField.getText();
        }

        public String getNotes() {
            return this.notesTextArea.getText();
        }
    }
}

