/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.defaults;

import chatty.gui.defaults.DefaultsPanel;
import chatty.lang.Language;
import chatty.util.IconManager;
import chatty.util.settings.Settings;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class DefaultsDialog
extends JFrame {
    public static void showAndWait(Settings settings) {
        try {
            CountDownLatch latch = new CountDownLatch(1);
            SwingUtilities.invokeLater(() -> {
                DefaultsDialog dialog = new DefaultsDialog(settings, latch);
                dialog.setVisible(true);
            });
            latch.await();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(DefaultsDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private DefaultsDialog(final Settings settings, final CountDownLatch latch) {
        this.setTitle("Chatty - Initial Setup");
        this.setIconImages(IconManager.getMainIcons());
        DefaultsPanel panel = new DefaultsPanel(Language.getString("defaults.info"), new DefaultsPanel.DefaultsHelper(){

            @Override
            public void setString(String setting, String value) {
                settings.setString(setting, value);
            }

            @Override
            public void setLong(String setting, long value) {
                settings.setLong(setting, value);
            }

            @Override
            public void setBoolean(String setting, boolean value) {
                settings.setBoolean(setting, value);
            }

            @Override
            public String getStringDefault(String setting) {
                return settings.getStringDefault(setting);
            }

            @Override
            public boolean getBooleanDefault(String setting) {
                return settings.getBooleanDefault(setting);
            }

            @Override
            public boolean getEnabled(String option) {
                switch (option) {
                    case "notifications": {
                        return true;
                    }
                    case "userlist": {
                        return false;
                    }
                }
                return false;
            }

            @Override
            public void applied() {
                DefaultsDialog.this.dispose();
            }
        });
        this.add((Component)new JScrollPane(panel), "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                latch.countDown();
            }
        });
        SwingUtilities.invokeLater(() -> {
            this.pack();
            this.setLocationRelativeTo(null);
            this.setDefaultCloseOperation(2);
        });
    }

    public static void main(String[] args) {
        Settings settings = new Settings("", null);
        DefaultsDialog.showAndWait(settings);
        System.out.println("continue");
        System.exit(0);
    }
}

