/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.defaults;

import chatty.gui.GuiUtil;
import chatty.gui.components.settings.ColorSettings;
import chatty.gui.defaults.DefaultsDialog;
import chatty.lang.Language;
import chatty.splash.Splash;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;

public class DefaultsPanel
extends JPanel {
    private final DefaultsHelper helper;
    private final JLabel styleImage;
    private final JToggleButton style1Button;
    private final JToggleButton style2Button;
    private final JToggleButton style3Button;
    private final JToggleButton style4Button;
    private final JToggleButton styleFlatLightButton;
    private final JToggleButton styleFlatDarkButton;
    private final JCheckBox userlist;
    private final JTextPane fontPreview;
    private final JToggleButton font1Button;
    private final JToggleButton font2Button;
    private final JToggleButton fontSkipButton;
    private final JCheckBox notifications;
    private final String fontPreviewText = Splash.getThing(20, 80);
    private static float RESIZE_FACTOR = 1.4f;
    private Font currentFont;

    public DefaultsPanel(String introduction, DefaultsHelper helper) {
        JPanel main = new JPanel(new GridBagLayout());
        this.helper = helper;
        JPanel stylePanel = new JPanel(new GridBagLayout());
        stylePanel.setBorder(BorderFactory.createTitledBorder(Language.getString("defaults.style")));
        this.style1Button = new JToggleButton("Metal");
        this.style2Button = new JToggleButton("Fast");
        this.style3Button = new JToggleButton("Smooth");
        this.style4Button = new JToggleButton("Custom");
        this.styleFlatLightButton = new JToggleButton("FlatLight");
        this.styleFlatDarkButton = new JToggleButton("FlatDark");
        ButtonGroup styleButtonGroup = new ButtonGroup();
        styleButtonGroup.add(this.style1Button);
        styleButtonGroup.add(this.style2Button);
        styleButtonGroup.add(this.style3Button);
        styleButtonGroup.add(this.style4Button);
        styleButtonGroup.add(this.styleFlatLightButton);
        styleButtonGroup.add(this.styleFlatDarkButton);
        this.style1Button.addItemListener(e -> this.updateStyle());
        this.style2Button.addItemListener(e -> this.updateStyle());
        this.style3Button.addItemListener(e -> this.updateStyle());
        this.style4Button.addItemListener(e -> this.updateStyle());
        this.styleFlatLightButton.addItemListener(e -> this.updateStyle());
        this.styleFlatDarkButton.addItemListener(e -> this.updateStyle());
        this.styleImage = new JLabel();
        GridBagConstraints gbc = GuiUtil.makeGbc(0, 0, 2, 1, 10);
        gbc.insets = new Insets(10, 10, 5, 10);
        stylePanel.add((Component)this.styleImage, gbc);
        JPanel styleButtonPanel = new JPanel(new GridBagLayout());
        gbc = GuiUtil.makeGbc(0, 0, 3, 1, 10);
        styleButtonPanel.add((Component)new JLabel("-- " + Language.getString("defaults.lightThemes") + " --"), gbc);
        gbc = GuiUtil.makeGbc(3, 0, 3, 1, 10);
        styleButtonPanel.add((Component)new JLabel("-- " + Language.getString("defaults.darkThemes") + " --"), gbc);
        gbc = GuiUtil.makeGbc(0, 1, 1, 1);
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 0);
        styleButtonPanel.add((Component)this.style1Button, gbc);
        gbc = GuiUtil.makeGbc(1, 1, 1, 1);
        gbc.fill = 2;
        gbc.insets = new Insets(5, 0, 5, 0);
        styleButtonPanel.add((Component)this.style2Button, gbc);
        gbc = GuiUtil.makeGbc(2, 1, 1, 1);
        gbc.fill = 2;
        gbc.insets = new Insets(5, 0, 5, 5);
        styleButtonPanel.add((Component)this.styleFlatLightButton, gbc);
        gbc = GuiUtil.makeGbc(3, 1, 1, 1);
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 0);
        styleButtonPanel.add((Component)this.style3Button, gbc);
        gbc = GuiUtil.makeGbc(4, 1, 1, 1);
        gbc.fill = 2;
        gbc.insets = new Insets(5, 0, 5, 0);
        styleButtonPanel.add((Component)this.style4Button, gbc);
        gbc = GuiUtil.makeGbc(5, 1, 1, 1);
        gbc.fill = 2;
        gbc.insets = new Insets(5, 0, 5, 5);
        styleButtonPanel.add((Component)this.styleFlatDarkButton, gbc);
        gbc = GuiUtil.makeGbc(0, 2, 2, 1, 10);
        gbc.weightx = 1.0;
        stylePanel.add((Component)styleButtonPanel, gbc);
        this.userlist = new JCheckBox(Language.getString("defaults.option.showUserlist"));
        this.userlist.setSelected(helper.getEnabled("userlist"));
        this.userlist.setToolTipText(Language.getString("defaults.option.showUserlist.tip"));
        gbc = GuiUtil.makeGbc(0, 3, 2, 1, 10);
        stylePanel.add((Component)this.userlist, gbc);
        gbc = GuiUtil.makeGbc(0, 1, 2, 1);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        main.add((Component)stylePanel, gbc);
        this.userlist.addItemListener(e -> this.updateStyle());
        this.styleFlatLightButton.setSelected(true);
        JPanel fontPanel = new JPanel(new GridBagLayout());
        fontPanel.setBorder(BorderFactory.createTitledBorder(Language.getString("defaults.font")));
        this.fontPreview = new JTextPane();
        GuiUtil.resetFocusTraversalKeys(this.fontPreview);
        gbc = GuiUtil.makeGbc(0, 5, 2, 1, 10);
        gbc.weightx = 1.0;
        gbc.fill = 2;
        fontPanel.add((Component)new JScrollPane(this.fontPreview), gbc);
        this.font1Button = new JToggleButton("Dialog");
        this.font2Button = new JToggleButton("Classic");
        this.fontSkipButton = new JToggleButton("Don't change");
        this.font1Button.addItemListener(e -> this.updateFont());
        this.font2Button.addItemListener(e -> this.updateFont());
        this.fontSkipButton.addItemListener(e -> this.updateFont());
        ButtonGroup fontButtonGroup = new ButtonGroup();
        fontButtonGroup.add(this.font1Button);
        fontButtonGroup.add(this.font2Button);
        fontButtonGroup.add(this.fontSkipButton);
        JPanel fontButtonPanel = new JPanel(new FlowLayout(1, 0, 0));
        fontButtonPanel.add(this.font1Button);
        fontButtonPanel.add(this.font2Button);
        this.font1Button.setSelected(true);
        this.updateFont();
        if (helper.getEnabled("skip")) {
            fontButtonPanel.add(this.fontSkipButton);
            this.fontSkipButton.setSelected(true);
        } else {
            this.font1Button.setSelected(true);
        }
        gbc = GuiUtil.makeGbc(0, 6, 2, 1, 10);
        fontPanel.add((Component)fontButtonPanel, gbc);
        gbc = GuiUtil.makeGbc(0, 6, 2, 1, 10);
        gbc.fill = 2;
        main.add((Component)fontPanel, gbc);
        this.updateFont();
        JPanel otherPanel = new JPanel(new GridBagLayout());
        otherPanel.setBorder(BorderFactory.createTitledBorder("Other"));
        gbc = GuiUtil.makeGbc(0, 0, 1, 1, 18);
        gbc.weighty = 1.0;
        this.notifications = new JCheckBox(Language.getString("defaults.option.notifications"));
        this.notifications.setSelected(helper.getEnabled("notifications"));
        this.notifications.setBorder(BorderFactory.createEmptyBorder());
        otherPanel.add((Component)this.notifications, gbc);
        gbc = GuiUtil.makeGbc(1, 0, 1, 1, 18);
        otherPanel.add((Component)new JLabel("<html><body style='width:300px;'>" + Language.getString("defaults.option.notifications.info")), gbc);
        gbc = GuiUtil.makeGbc(0, 7, 2, 1, 10);
        gbc.fill = 2;
        main.add((Component)otherPanel, gbc);
        gbc = GuiUtil.makeGbc(0, 0, 2, 1, 10);
        main.add((Component)new JLabel(introduction), gbc);
        this.setLayout(new GridBagLayout());
        gbc = GuiUtil.makeGbc(0, 0, 1, 1);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)main, gbc);
        JButton applyButton = new JButton(Language.getString("defaults.button.apply"));
        gbc = GuiUtil.makeGbc(0, 1, 1, 1, 10);
        gbc.fill = 2;
        this.add((Component)applyButton, gbc);
        applyButton.addActionListener(e -> {
            this.applySettings();
            helper.applied();
        });
    }

    private void updateStyle() {
        String name;
        if (this.style1Button.isSelected()) {
            name = "default";
        } else if (this.style2Button.isSelected()) {
            name = "fast";
        } else if (this.style3Button.isSelected()) {
            name = "hifi_soft";
        } else if (this.style4Button.isSelected()) {
            name = "custom";
        } else if (this.styleFlatLightButton.isSelected()) {
            name = "flatLight";
        } else if (this.styleFlatDarkButton.isSelected()) {
            name = "flatDark";
        } else {
            return;
        }
        if (this.userlist.isSelected()) {
            name = name + "_userlist";
        }
        name = name + ".png";
        ImageIcon icon = DefaultsPanel.getImage(name);
        icon.setImage(icon.getImage().getScaledInstance((int)((float)icon.getIconWidth() / RESIZE_FACTOR), (int)((float)icon.getIconHeight() / RESIZE_FACTOR), 4));
        this.styleImage.setIcon(icon);
    }

    private void updateFont() {
        Font font;
        if (this.fontSkipButton.isSelected()) {
            this.fontPreview.setText(Language.getString("defaults.font.skip"));
        } else {
            this.fontPreview.setText(this.fontPreviewText);
        }
        if (this.font1Button.isSelected()) {
            font = Font.decode("Dialog 14");
        } else if (this.font2Button.isSelected()) {
            font = Font.decode("Consolas 14");
        } else {
            return;
        }
        this.currentFont = font;
        this.fontPreview.setFont(font);
    }

    private void applySettings() {
        String key;
        int i;
        if (this.style1Button.isSelected()) {
            this.helper.setString("laf", "default");
        } else if (this.style2Button.isSelected()) {
            this.helper.setString("laf", "fast");
            this.helper.setString("lafTheme", "Default");
        } else if (this.style3Button.isSelected()) {
            this.helper.setString("laf", "hifi2");
            this.helper.setString("lafTheme", "Default");
        } else if (this.style4Button.isSelected()) {
            this.helper.setString("laf", "hifiCustom");
            this.helper.setString("lafTheme", "Default");
            this.helper.setString("lafForeground", "#E5E5E5");
            this.helper.setString("lafBackground", "#2D2D2D");
            this.helper.setLong("lafGradient", 25L);
            this.helper.setLong("lafVariant", 0L);
            this.helper.setString("lafStyle", "classicStrong");
        } else if (this.styleFlatLightButton.isSelected()) {
            this.helper.setString("laf", "flatlight");
        } else if (this.styleFlatDarkButton.isSelected()) {
            this.helper.setString("laf", "flatdark");
        }
        if (this.styleFlatLightButton.isSelected() || this.styleFlatDarkButton.isSelected()) {
            this.helper.setBoolean("lafFlatStyledWindow", true);
            this.helper.setBoolean("lafFlatEmbeddedMenu", true);
            this.helper.setLong("lafFlatTabs", 3L);
        }
        this.helper.setBoolean("lafNativeWindow", true);
        this.helper.setBoolean("userlistEnabled", this.userlist.isSelected());
        for (i = 0; i < ColorSettings.PRESET_SETTINGS.length; ++i) {
            key = ColorSettings.PRESET_SETTINGS[i];
            String value = this.helper.getStringDefault(key);
            if (this.style2Button.isSelected()) {
                value = ColorSettings.LIGHT_FAST[i];
            } else if (this.style3Button.isSelected() || this.styleFlatDarkButton.isSelected()) {
                value = ColorSettings.DARK_SMOOTH[i];
            } else if (this.style4Button.isSelected()) {
                value = ColorSettings.DARK[i];
            }
            this.helper.setString(key, value);
        }
        for (i = 0; i < ColorSettings.PRESET_SETTINGS_BOOLEAN.length; ++i) {
            key = ColorSettings.PRESET_SETTINGS_BOOLEAN[i];
            boolean value = this.helper.getBooleanDefault(key);
            if (this.style2Button.isSelected()) {
                value = ColorSettings.LIGHT_FAST_BOOLEAN[i];
            } else if (this.style3Button.isSelected() || this.styleFlatDarkButton.isSelected()) {
                value = ColorSettings.DARK_SMOOTH_BOOLEAN[i];
            } else if (this.style4Button.isSelected()) {
                value = ColorSettings.DARK_BOOLEAN[i];
            }
            this.helper.setBoolean(key, value);
        }
        if (!this.fontSkipButton.isSelected()) {
            this.helper.setString("font", this.currentFont.getFamily());
            this.helper.setLong("fontSize", this.currentFont.getSize());
            this.helper.setString("userlistFont", this.currentFont.deriveFont(12.0f).getFamily() + " 12");
            this.helper.setBoolean("timestampFontEnabled", this.style1Button.isSelected() || this.styleFlatLightButton.isSelected() || this.styleFlatDarkButton.isSelected());
            this.helper.setString("timestampFont", this.currentFont.deriveFont(12.0f).getFamily() + " 12");
        }
        this.helper.setLong("nType", this.notifications.isSelected() ? 0L : -1L);
    }

    public static ImageIcon getImage(String name) {
        return new ImageIcon(DefaultsDialog.class.getResource(name));
    }

    public static interface DefaultsHelper {
        public void setString(String var1, String var2);

        public void setLong(String var1, long var2);

        public void setBoolean(String var1, boolean var2);

        public String getStringDefault(String var1);

        public boolean getBooleanDefault(String var1);

        public boolean getEnabled(String var1);

        public void applied();
    }
}

