/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.emoji;

import chatty.util.StringUtil;
import chatty.util.api.Emoticon;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class EmojiUtil {
    private static final Logger LOGGER = Logger.getLogger(EmojiUtil.class.getName());
    private static final Pattern EMOJI_PATTERN = Pattern.compile("[\\x{200D}-\\x{2049}]|\\x{20E3}|\\x{2139}|[\\x{2194}-\\x{21AA}]|[\\x{231A}-\\x{2328}]|[\\x{23CF}-\\x{23FA}]|\\x{24C2}|[\\x{25AA}-\\x{25C0}]|[\\x{25FB}-\\x{27BF}]|[\\x{2934}-\\x{2935}]|[\\x{2B05}-\\x{2B1C}]|[\\x{2B50}-\\x{2B55}]|[\\x{3030}-\\x{303D}]|[\\x{3297}-\\x{3299}]|\\x{E50A}|\\x{FE0F}|\\x{1F004}|\\x{1F0CF}|[\\x{1F170}-\\x{1F19A}]|[\\x{1F1E6}-\\x{1F251}]|[\\x{1F300}-\\x{1F6FC}]|[\\x{1F7E0}-\\x{1F7F0}]|[\\x{1F90C}-\\x{1F9FF}]|[\\x{1FA70}-\\x{1FAF6}]|[\\x{E0062}-\\x{E007F}]");
    public static final String ZWJ = "\u200d";
    public static final String ZWJ_REPLACEMENT = "\udb40\udc02";
    private static final Pattern ZWJ_REPLACEMENT_ENCODE = Pattern.compile("\u200d");
    private static final Pattern ZWJ_REPLACEMENT_DECODE = Pattern.compile("\udb40\udc02");

    public static boolean mightContainEmoji(String text) {
        return EMOJI_PATTERN.matcher(text).find();
    }

    public static String encodeZWJ(String input) {
        return ZWJ_REPLACEMENT_ENCODE.matcher(input).replaceAll(ZWJ_REPLACEMENT);
    }

    public static String decodeZWJ(String input) {
        return ZWJ_REPLACEMENT_DECODE.matcher(input).replaceAll(ZWJ);
    }

    public static void add(EmojiSet set, Collection<Emoticon> emotes, String code, String filename, String name, String alias, String category, String unicodeVersion) {
        String url = EmojiUtil.class.getResource(set.internalPath + filename).toString();
        Emoticon.Builder b = new Emoticon.Builder(Emoticon.Type.EMOJI, code);
        b.addUrl(1, url);
        b.setCreator(set.name);
        b.setSize(24, 24);
        if (name != null) {
            b.setStringId(name);
        }
        if (!StringUtil.isNullOrEmpty(alias)) {
            b.setStringIdAlias(alias);
        }
        if (!StringUtil.isNullOrEmpty(category)) {
            if (!StringUtil.isNullOrEmpty(unicodeVersion)) {
                b.addInfo(category + " (Unicode " + unicodeVersion + ")");
            } else {
                b.addInfo(category);
            }
        }
        emotes.add(b.build());
    }

    public static Set<Emoticon> makeEmoticons(String sourceId) {
        HashSet<Emoticon> result = new HashSet<Emoticon>();
        if (sourceId.equals(EmojiSet.E1.id)) {
            EmojiUtil.e1(EmojiSet.E1, result);
        } else if (sourceId.equals(EmojiSet.TWEMOJI.id)) {
            EmojiUtil.twemoji(EmojiSet.TWEMOJI, result);
        }
        LOGGER.info("Created " + result.size() + " emoji from source " + sourceId);
        return result;
    }

    public static void main(String[] args) {
        Set<Emoticon> emotes = EmojiUtil.makeEmoticons("twemoji");
        System.out.println("#" + emotes.size());
    }

    private static void twemoji(EmojiSet set, Set<Emoticon> result) {
        EmojiUtil.twemoji_a(set, result);
        EmojiUtil.twemoji_b(set, result);
    }

    /*
     * Opcode count of 25274 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static void twemoji_a(EmojiSet set, Set<Emoticon> result) {
        EmojiUtil.add(set, result, "\ud83c\udc04", "1f004.png", ":mahjong:", ":mahjong_red_dragon:", "Activities", "");
        EmojiUtil.add(set, result, "\ud83c\udccf", "1f0cf.png", ":black_joker:", ":joker:", "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udd70", "1f170.png", ":a:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udd71", "1f171.png", ":b:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udd7e", "1f17e.png", ":o2:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udd7f", "1f17f.png", ":parking:", null, "Symbols", "5.2");
        EmojiUtil.add(set, result, "\ud83c\udd8e", "1f18e.png", ":ab:", ":ab_button_blood_type:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udd91", "1f191.png", ":cl:", ":cl_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udd92", "1f192.png", ":cool:", ":cool_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udd93", "1f193.png", ":free:", ":free_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udd94", "1f194.png", ":id:", ":id_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udd95", "1f195.png", ":new:", ":new_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udd96", "1f196.png", ":ng:", ":ng_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udd97", "1f197.png", ":ok:", ":ok_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udd98", "1f198.png", ":sos:", ":sos_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udd99", "1f199.png", ":up:", ":up_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udd9a", "1f19a.png", ":vs:", ":vs_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde6\ud83c\udde8", "1f1e6-1f1e8.png", ":ascension_island:", ":flag_ac:", "Flags", "11.0");
        EmojiUtil.add(set, result, "\ud83c\udde6\ud83c\udde9", "1f1e6-1f1e9.png", ":andorra:", ":flag_ad:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde6\ud83c\uddea", "1f1e6-1f1ea.png", ":united_arab_emirates:", ":flag_ae:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde6\ud83c\uddeb", "1f1e6-1f1eb.png", ":afghanistan:", ":flag_af:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde6\ud83c\uddec", "1f1e6-1f1ec.png", ":antigua_barbuda:", ":flag_ag:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde6\ud83c\uddee", "1f1e6-1f1ee.png", ":anguilla:", ":flag_ai:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde6\ud83c\uddf1", "1f1e6-1f1f1.png", ":albania:", ":flag_al:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde6\ud83c\uddf2", "1f1e6-1f1f2.png", ":armenia:", ":flag_am:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde6\ud83c\uddf4", "1f1e6-1f1f4.png", ":angola:", ":flag_ao:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde6\ud83c\uddf6", "1f1e6-1f1f6.png", ":antarctica:", ":flag_aq:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde6\ud83c\uddf7", "1f1e6-1f1f7.png", ":argentina:", ":flag_ar:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde6\ud83c\uddf8", "1f1e6-1f1f8.png", ":american_samoa:", ":flag_as:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde6\ud83c\uddf9", "1f1e6-1f1f9.png", ":austria:", ":flag_at:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde6\ud83c\uddfa", "1f1e6-1f1fa.png", ":australia:", ":flag_au:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde6\ud83c\uddfc", "1f1e6-1f1fc.png", ":aruba:", ":flag_aw:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde6\ud83c\uddfd", "1f1e6-1f1fd.png", ":aland_islands:", ":flag_ax:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde6\ud83c\uddff", "1f1e6-1f1ff.png", ":azerbaijan:", ":flag_az:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde6", "1f1e6.png", ":regional_indicator_a:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\udde6", "1f1e7-1f1e6.png", ":bosnia_herzegovina:", ":flag_ba:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\udde7", "1f1e7-1f1e7.png", ":barbados:", ":flag_bb:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\udde9", "1f1e7-1f1e9.png", ":bangladesh:", ":flag_bd:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\uddea", "1f1e7-1f1ea.png", ":belgium:", ":flag_be:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\uddeb", "1f1e7-1f1eb.png", ":burkina_faso:", ":flag_bf:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\uddec", "1f1e7-1f1ec.png", ":bulgaria:", ":flag_bg:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\udded", "1f1e7-1f1ed.png", ":bahrain:", ":flag_bh:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\uddee", "1f1e7-1f1ee.png", ":burundi:", ":flag_bi:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\uddef", "1f1e7-1f1ef.png", ":benin:", ":flag_bj:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\uddf1", "1f1e7-1f1f1.png", ":st_barthelemy:", ":flag_bl:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\uddf2", "1f1e7-1f1f2.png", ":bermuda:", ":flag_bm:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\uddf3", "1f1e7-1f1f3.png", ":brunei:", ":flag_bn:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\uddf4", "1f1e7-1f1f4.png", ":bolivia:", ":flag_bo:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\uddf6", "1f1e7-1f1f6.png", ":caribbean_netherlands:", ":flag_bq:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\uddf7", "1f1e7-1f1f7.png", ":brazil:", ":flag_br:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\uddf8", "1f1e7-1f1f8.png", ":bahamas:", ":flag_bs:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\uddf9", "1f1e7-1f1f9.png", ":bhutan:", ":flag_bt:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\uddfb", "1f1e7-1f1fb.png", ":bouvet_island:", ":flag_bv:", "Flags", "11.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\uddfc", "1f1e7-1f1fc.png", ":botswana:", ":flag_bw:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\uddfe", "1f1e7-1f1fe.png", ":belarus:", ":flag_by:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\uddff", "1f1e7-1f1ff.png", ":belize:", ":flag_bz:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7", "1f1e7.png", ":regional_indicator_b:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\udde6", "1f1e8-1f1e6.png", ":canada:", ":flag_ca:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\udde8", "1f1e8-1f1e8.png", ":cocos_islands:", ":flag_cc:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\udde9", "1f1e8-1f1e9.png", ":congo_kinshasa:", ":flag_cd:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\uddeb", "1f1e8-1f1eb.png", ":central_african_republic:", ":flag_cf:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\uddec", "1f1e8-1f1ec.png", ":congo_brazzaville:", ":flag_cg:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\udded", "1f1e8-1f1ed.png", ":switzerland:", ":flag_ch:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\uddee", "1f1e8-1f1ee.png", ":cote_divoire:", ":flag_ci:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\uddf0", "1f1e8-1f1f0.png", ":cook_islands:", ":flag_ck:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\uddf1", "1f1e8-1f1f1.png", ":chile:", ":flag_cl:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\uddf2", "1f1e8-1f1f2.png", ":cameroon:", ":flag_cm:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\uddf3", "1f1e8-1f1f3.png", ":cn:", ":flag_cn:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\uddf4", "1f1e8-1f1f4.png", ":colombia:", ":flag_co:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\uddf5", "1f1e8-1f1f5.png", ":clipperton_island:", ":flag_cp:", "Flags", "11.0");
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\uddf7", "1f1e8-1f1f7.png", ":costa_rica:", ":flag_cr:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\uddfa", "1f1e8-1f1fa.png", ":cuba:", ":flag_cu:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\uddfb", "1f1e8-1f1fb.png", ":cape_verde:", ":flag_cv:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\uddfc", "1f1e8-1f1fc.png", ":curacao:", ":flag_cw:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\uddfd", "1f1e8-1f1fd.png", ":christmas_island:", ":flag_cx:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\uddfe", "1f1e8-1f1fe.png", ":cyprus:", ":flag_cy:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\uddff", "1f1e8-1f1ff.png", ":czech_republic:", ":flag_cz:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde8", "1f1e8.png", ":regional_indicator_c:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\udde9\ud83c\uddea", "1f1e9-1f1ea.png", ":de:", ":flag_de:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde9\ud83c\uddec", "1f1e9-1f1ec.png", ":diego_garcia:", ":flag_dg:", "Flags", "11.0");
        EmojiUtil.add(set, result, "\ud83c\udde9\ud83c\uddef", "1f1e9-1f1ef.png", ":djibouti:", ":flag_dj:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde9\ud83c\uddf0", "1f1e9-1f1f0.png", ":denmark:", ":flag_dk:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde9\ud83c\uddf2", "1f1e9-1f1f2.png", ":dominica:", ":flag_dm:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde9\ud83c\uddf4", "1f1e9-1f1f4.png", ":dominican_republic:", ":flag_do:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde9\ud83c\uddff", "1f1e9-1f1ff.png", ":algeria:", ":flag_dz:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde9", "1f1e9.png", ":regional_indicator_d:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddea\ud83c\udde6", "1f1ea-1f1e6.png", ":ceuta_melilla:", ":flag_ea:", "Flags", "11.0");
        EmojiUtil.add(set, result, "\ud83c\uddea\ud83c\udde8", "1f1ea-1f1e8.png", ":ecuador:", ":flag_ec:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddea\ud83c\uddea", "1f1ea-1f1ea.png", ":estonia:", ":flag_ee:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddea\ud83c\uddec", "1f1ea-1f1ec.png", ":egypt:", ":flag_eg:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddea\ud83c\udded", "1f1ea-1f1ed.png", ":western_sahara:", ":flag_eh:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddea\ud83c\uddf7", "1f1ea-1f1f7.png", ":eritrea:", ":flag_er:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddea\ud83c\uddf8", "1f1ea-1f1f8.png", ":es:", ":flag_es:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddea\ud83c\uddf9", "1f1ea-1f1f9.png", ":ethiopia:", ":flag_et:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddea\ud83c\uddfa", "1f1ea-1f1fa.png", ":eu:", ":flag_eu:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddea", "1f1ea.png", ":regional_indicator_e:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddeb\ud83c\uddee", "1f1eb-1f1ee.png", ":finland:", ":flag_fi:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddeb\ud83c\uddef", "1f1eb-1f1ef.png", ":fiji:", ":flag_fj:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddeb\ud83c\uddf0", "1f1eb-1f1f0.png", ":falkland_islands:", ":flag_fk:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddeb\ud83c\uddf2", "1f1eb-1f1f2.png", ":micronesia:", ":flag_fm:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddeb\ud83c\uddf4", "1f1eb-1f1f4.png", ":faroe_islands:", ":flag_fo:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddeb\ud83c\uddf7", "1f1eb-1f1f7.png", ":fr:", ":flag_fr:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddeb", "1f1eb.png", ":regional_indicator_f:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddec\ud83c\udde6", "1f1ec-1f1e6.png", ":gabon:", ":flag_ga:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddec\ud83c\udde7", "1f1ec-1f1e7.png", ":gb:", ":flag_gb:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddec\ud83c\udde9", "1f1ec-1f1e9.png", ":grenada:", ":flag_gd:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddec\ud83c\uddea", "1f1ec-1f1ea.png", ":georgia:", ":flag_ge:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddec\ud83c\uddeb", "1f1ec-1f1eb.png", ":french_guiana:", ":flag_gf:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddec\ud83c\uddec", "1f1ec-1f1ec.png", ":guernsey:", ":flag_gg:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddec\ud83c\udded", "1f1ec-1f1ed.png", ":ghana:", ":flag_gh:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddec\ud83c\uddee", "1f1ec-1f1ee.png", ":gibraltar:", ":flag_gi:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddec\ud83c\uddf1", "1f1ec-1f1f1.png", ":greenland:", ":flag_gl:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddec\ud83c\uddf2", "1f1ec-1f1f2.png", ":gambia:", ":flag_gm:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddec\ud83c\uddf3", "1f1ec-1f1f3.png", ":guinea:", ":flag_gn:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddec\ud83c\uddf5", "1f1ec-1f1f5.png", ":guadeloupe:", ":flag_gp:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddec\ud83c\uddf6", "1f1ec-1f1f6.png", ":equatorial_guinea:", ":flag_gq:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddec\ud83c\uddf7", "1f1ec-1f1f7.png", ":greece:", ":flag_gr:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddec\ud83c\uddf8", "1f1ec-1f1f8.png", ":south_georgia_south_sandwich_islands:", ":flag_gs:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddec\ud83c\uddf9", "1f1ec-1f1f9.png", ":guatemala:", ":flag_gt:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddec\ud83c\uddfa", "1f1ec-1f1fa.png", ":guam:", ":flag_gu:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddec\ud83c\uddfc", "1f1ec-1f1fc.png", ":guinea_bissau:", ":flag_gw:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddec\ud83c\uddfe", "1f1ec-1f1fe.png", ":guyana:", ":flag_gy:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddec", "1f1ec.png", ":regional_indicator_g:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\udded\ud83c\uddf0", "1f1ed-1f1f0.png", ":hong_kong:", ":flag_hk:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udded\ud83c\uddf2", "1f1ed-1f1f2.png", ":heard_mcdonald_islands:", ":flag_hm:", "Flags", "11.0");
        EmojiUtil.add(set, result, "\ud83c\udded\ud83c\uddf3", "1f1ed-1f1f3.png", ":honduras:", ":flag_hn:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udded\ud83c\uddf7", "1f1ed-1f1f7.png", ":croatia:", ":flag_hr:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udded\ud83c\uddf9", "1f1ed-1f1f9.png", ":haiti:", ":flag_ht:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udded\ud83c\uddfa", "1f1ed-1f1fa.png", ":hungary:", ":flag_hu:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udded", "1f1ed.png", ":regional_indicator_h:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddee\ud83c\udde8", "1f1ee-1f1e8.png", ":canary_islands:", ":flag_ic:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddee\ud83c\udde9", "1f1ee-1f1e9.png", ":indonesia:", ":flag_id:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddee\ud83c\uddea", "1f1ee-1f1ea.png", ":ireland:", ":flag_ie:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddee\ud83c\uddf1", "1f1ee-1f1f1.png", ":israel:", ":flag_il:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddee\ud83c\uddf2", "1f1ee-1f1f2.png", ":isle_of_man:", ":flag_im:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddee\ud83c\uddf3", "1f1ee-1f1f3.png", ":india:", ":flag_in:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddee\ud83c\uddf4", "1f1ee-1f1f4.png", ":british_indian_ocean_territory:", ":flag_io:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddee\ud83c\uddf6", "1f1ee-1f1f6.png", ":iraq:", ":flag_iq:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddee\ud83c\uddf7", "1f1ee-1f1f7.png", ":iran:", ":flag_ir:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddee\ud83c\uddf8", "1f1ee-1f1f8.png", ":iceland:", ":flag_is:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddee\ud83c\uddf9", "1f1ee-1f1f9.png", ":it:", ":flag_it:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddee", "1f1ee.png", ":regional_indicator_i:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddef\ud83c\uddea", "1f1ef-1f1ea.png", ":jersey:", ":flag_je:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddef\ud83c\uddf2", "1f1ef-1f1f2.png", ":jamaica:", ":flag_jm:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddef\ud83c\uddf4", "1f1ef-1f1f4.png", ":jordan:", ":flag_jo:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddef\ud83c\uddf5", "1f1ef-1f1f5.png", ":jp:", ":flag_jp:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddef", "1f1ef.png", ":regional_indicator_j:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddf0\ud83c\uddea", "1f1f0-1f1ea.png", ":kenya:", ":flag_ke:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf0\ud83c\uddec", "1f1f0-1f1ec.png", ":kyrgyzstan:", ":flag_kg:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf0\ud83c\udded", "1f1f0-1f1ed.png", ":cambodia:", ":flag_kh:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf0\ud83c\uddee", "1f1f0-1f1ee.png", ":kiribati:", ":flag_ki:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf0\ud83c\uddf2", "1f1f0-1f1f2.png", ":comoros:", ":flag_km:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf0\ud83c\uddf3", "1f1f0-1f1f3.png", ":st_kitts_nevis:", ":flag_kn:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf0\ud83c\uddf5", "1f1f0-1f1f5.png", ":north_korea:", ":flag_kp:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf0\ud83c\uddf7", "1f1f0-1f1f7.png", ":kr:", ":flag_kr:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf0\ud83c\uddfc", "1f1f0-1f1fc.png", ":kuwait:", ":flag_kw:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf0\ud83c\uddfe", "1f1f0-1f1fe.png", ":cayman_islands:", ":flag_ky:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf0\ud83c\uddff", "1f1f0-1f1ff.png", ":kazakhstan:", ":flag_kz:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf0", "1f1f0.png", ":regional_indicator_k:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddf1\ud83c\udde6", "1f1f1-1f1e6.png", ":laos:", ":flag_la:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf1\ud83c\udde7", "1f1f1-1f1e7.png", ":lebanon:", ":flag_lb:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf1\ud83c\udde8", "1f1f1-1f1e8.png", ":st_lucia:", ":flag_lc:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf1\ud83c\uddee", "1f1f1-1f1ee.png", ":liechtenstein:", ":flag_li:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf1\ud83c\uddf0", "1f1f1-1f1f0.png", ":sri_lanka:", ":flag_lk:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf1\ud83c\uddf7", "1f1f1-1f1f7.png", ":liberia:", ":flag_lr:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf1\ud83c\uddf8", "1f1f1-1f1f8.png", ":lesotho:", ":flag_ls:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf1\ud83c\uddf9", "1f1f1-1f1f9.png", ":lithuania:", ":flag_lt:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf1\ud83c\uddfa", "1f1f1-1f1fa.png", ":luxembourg:", ":flag_lu:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf1\ud83c\uddfb", "1f1f1-1f1fb.png", ":latvia:", ":flag_lv:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf1\ud83c\uddfe", "1f1f1-1f1fe.png", ":libya:", ":flag_ly:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf1", "1f1f1.png", ":regional_indicator_l:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\udde6", "1f1f2-1f1e6.png", ":morocco:", ":flag_ma:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\udde8", "1f1f2-1f1e8.png", ":monaco:", ":flag_mc:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\udde9", "1f1f2-1f1e9.png", ":moldova:", ":flag_md:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\uddea", "1f1f2-1f1ea.png", ":montenegro:", ":flag_me:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\uddeb", "1f1f2-1f1eb.png", ":st_martin:", ":flag_mf:", "Flags", "11.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\uddec", "1f1f2-1f1ec.png", ":madagascar:", ":flag_mg:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\udded", "1f1f2-1f1ed.png", ":marshall_islands:", ":flag_mh:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\uddf0", "1f1f2-1f1f0.png", ":macedonia:", ":flag_mk:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\uddf1", "1f1f2-1f1f1.png", ":mali:", ":flag_ml:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\uddf2", "1f1f2-1f1f2.png", ":myanmar:", ":flag_mm:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\uddf3", "1f1f2-1f1f3.png", ":mongolia:", ":flag_mn:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\uddf4", "1f1f2-1f1f4.png", ":macau:", ":flag_mo:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\uddf5", "1f1f2-1f1f5.png", ":northern_mariana_islands:", ":flag_mp:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\uddf6", "1f1f2-1f1f6.png", ":martinique:", ":flag_mq:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\uddf7", "1f1f2-1f1f7.png", ":mauritania:", ":flag_mr:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\uddf8", "1f1f2-1f1f8.png", ":montserrat:", ":flag_ms:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\uddf9", "1f1f2-1f1f9.png", ":malta:", ":flag_mt:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\uddfa", "1f1f2-1f1fa.png", ":mauritius:", ":flag_mu:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\uddfb", "1f1f2-1f1fb.png", ":maldives:", ":flag_mv:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\uddfc", "1f1f2-1f1fc.png", ":malawi:", ":flag_mw:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\uddfd", "1f1f2-1f1fd.png", ":mexico:", ":flag_mx:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\uddfe", "1f1f2-1f1fe.png", ":malaysia:", ":flag_my:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\uddff", "1f1f2-1f1ff.png", ":mozambique:", ":flag_mz:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2", "1f1f2.png", ":regional_indicator_m:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddf3\ud83c\udde6", "1f1f3-1f1e6.png", ":namibia:", ":flag_na:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf3\ud83c\udde8", "1f1f3-1f1e8.png", ":new_caledonia:", ":flag_nc:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf3\ud83c\uddea", "1f1f3-1f1ea.png", ":niger:", ":flag_ne:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf3\ud83c\uddeb", "1f1f3-1f1eb.png", ":norfolk_island:", ":flag_nf:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf3\ud83c\uddec", "1f1f3-1f1ec.png", ":nigeria:", ":flag_ng:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf3\ud83c\uddee", "1f1f3-1f1ee.png", ":nicaragua:", ":flag_ni:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf3\ud83c\uddf1", "1f1f3-1f1f1.png", ":netherlands:", ":flag_nl:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf3\ud83c\uddf4", "1f1f3-1f1f4.png", ":norway:", ":flag_no:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf3\ud83c\uddf5", "1f1f3-1f1f5.png", ":nepal:", ":flag_np:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf3\ud83c\uddf7", "1f1f3-1f1f7.png", ":nauru:", ":flag_nr:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf3\ud83c\uddfa", "1f1f3-1f1fa.png", ":niue:", ":flag_nu:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf3\ud83c\uddff", "1f1f3-1f1ff.png", ":new_zealand:", ":flag_nz:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf3", "1f1f3.png", ":regional_indicator_n:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddf4\ud83c\uddf2", "1f1f4-1f1f2.png", ":oman:", ":flag_om:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf4", "1f1f4.png", ":regional_indicator_o:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddf5\ud83c\udde6", "1f1f5-1f1e6.png", ":panama:", ":flag_pa:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf5\ud83c\uddea", "1f1f5-1f1ea.png", ":peru:", ":flag_pe:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf5\ud83c\uddeb", "1f1f5-1f1eb.png", ":french_polynesia:", ":flag_pf:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf5\ud83c\uddec", "1f1f5-1f1ec.png", ":papua_new_guinea:", ":flag_pg:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf5\ud83c\udded", "1f1f5-1f1ed.png", ":philippines:", ":flag_ph:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf5\ud83c\uddf0", "1f1f5-1f1f0.png", ":pakistan:", ":flag_pk:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf5\ud83c\uddf1", "1f1f5-1f1f1.png", ":poland:", ":flag_pl:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf5\ud83c\uddf2", "1f1f5-1f1f2.png", ":st_pierre_miquelon:", ":flag_pm:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf5\ud83c\uddf3", "1f1f5-1f1f3.png", ":pitcairn_islands:", ":flag_pn:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf5\ud83c\uddf7", "1f1f5-1f1f7.png", ":puerto_rico:", ":flag_pr:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf5\ud83c\uddf8", "1f1f5-1f1f8.png", ":palestinian_territories:", ":flag_ps:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf5\ud83c\uddf9", "1f1f5-1f1f9.png", ":portugal:", ":flag_pt:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf5\ud83c\uddfc", "1f1f5-1f1fc.png", ":palau:", ":flag_pw:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf5\ud83c\uddfe", "1f1f5-1f1fe.png", ":paraguay:", ":flag_py:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf5", "1f1f5.png", ":regional_indicator_p:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddf6\ud83c\udde6", "1f1f6-1f1e6.png", ":qatar:", ":flag_qa:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf6", "1f1f6.png", ":regional_indicator_q:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddf7\ud83c\uddea", "1f1f7-1f1ea.png", ":reunion:", ":flag_re:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf7\ud83c\uddf4", "1f1f7-1f1f4.png", ":romania:", ":flag_ro:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf7\ud83c\uddf8", "1f1f7-1f1f8.png", ":serbia:", ":flag_rs:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf7\ud83c\uddfa", "1f1f7-1f1fa.png", ":ru:", ":flag_ru:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf7\ud83c\uddfc", "1f1f7-1f1fc.png", ":rwanda:", ":flag_rw:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf7", "1f1f7.png", ":regional_indicator_r:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\udde6", "1f1f8-1f1e6.png", ":saudi_arabia:", ":flag_sa:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\udde7", "1f1f8-1f1e7.png", ":solomon_islands:", ":flag_sb:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\udde8", "1f1f8-1f1e8.png", ":seychelles:", ":flag_sc:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\udde9", "1f1f8-1f1e9.png", ":sudan:", ":flag_sd:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\uddea", "1f1f8-1f1ea.png", ":sweden:", ":flag_se:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\uddec", "1f1f8-1f1ec.png", ":singapore:", ":flag_sg:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\udded", "1f1f8-1f1ed.png", ":st_helena:", ":flag_sh:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\uddee", "1f1f8-1f1ee.png", ":slovenia:", ":flag_si:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\uddef", "1f1f8-1f1ef.png", ":svalbard_jan_mayen:", ":flag_sj:", "Flags", "11.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\uddf0", "1f1f8-1f1f0.png", ":slovakia:", ":flag_sk:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\uddf1", "1f1f8-1f1f1.png", ":sierra_leone:", ":flag_sl:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\uddf2", "1f1f8-1f1f2.png", ":san_marino:", ":flag_sm:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\uddf3", "1f1f8-1f1f3.png", ":senegal:", ":flag_sn:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\uddf4", "1f1f8-1f1f4.png", ":somalia:", ":flag_so:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\uddf7", "1f1f8-1f1f7.png", ":suriname:", ":flag_sr:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\uddf8", "1f1f8-1f1f8.png", ":south_sudan:", ":flag_ss:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\uddf9", "1f1f8-1f1f9.png", ":sao_tome_principe:", ":flag_st:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\uddfb", "1f1f8-1f1fb.png", ":el_salvador:", ":flag_sv:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\uddfd", "1f1f8-1f1fd.png", ":sint_maarten:", ":flag_sx:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\uddfe", "1f1f8-1f1fe.png", ":syria:", ":flag_sy:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\uddff", "1f1f8-1f1ff.png", ":swaziland:", ":flag_sz:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8", "1f1f8.png", ":regional_indicator_s:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddf9\ud83c\udde6", "1f1f9-1f1e6.png", ":tristan_da_cunha:", ":flag_ta:", "Flags", "11.0");
        EmojiUtil.add(set, result, "\ud83c\uddf9\ud83c\udde8", "1f1f9-1f1e8.png", ":turks_caicos_islands:", ":flag_tc:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf9\ud83c\udde9", "1f1f9-1f1e9.png", ":chad:", ":flag_td:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf9\ud83c\uddeb", "1f1f9-1f1eb.png", ":french_southern_territories:", ":flag_tf:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf9\ud83c\uddec", "1f1f9-1f1ec.png", ":togo:", ":flag_tg:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf9\ud83c\udded", "1f1f9-1f1ed.png", ":thailand:", ":flag_th:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf9\ud83c\uddef", "1f1f9-1f1ef.png", ":tajikistan:", ":flag_tj:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf9\ud83c\uddf0", "1f1f9-1f1f0.png", ":tokelau:", ":flag_tk:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf9\ud83c\uddf1", "1f1f9-1f1f1.png", ":timor_leste:", ":flag_tl:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf9\ud83c\uddf2", "1f1f9-1f1f2.png", ":turkmenistan:", ":flag_tm:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf9\ud83c\uddf3", "1f1f9-1f1f3.png", ":tunisia:", ":flag_tn:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf9\ud83c\uddf4", "1f1f9-1f1f4.png", ":tonga:", ":flag_to:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf9\ud83c\uddf7", "1f1f9-1f1f7.png", ":tr:", ":flag_tr:", "Flags", "8.0");
        EmojiUtil.add(set, result, "\ud83c\uddf9\ud83c\uddf9", "1f1f9-1f1f9.png", ":trinidad_tobago:", ":flag_tt:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf9\ud83c\uddfb", "1f1f9-1f1fb.png", ":tuvalu:", ":flag_tv:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf9\ud83c\uddfc", "1f1f9-1f1fc.png", ":taiwan:", ":flag_tw:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf9\ud83c\uddff", "1f1f9-1f1ff.png", ":tanzania:", ":flag_tz:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf9", "1f1f9.png", ":regional_indicator_t:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddfa\ud83c\udde6", "1f1fa-1f1e6.png", ":ukraine:", ":flag_ua:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddfa\ud83c\uddec", "1f1fa-1f1ec.png", ":uganda:", ":flag_ug:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddfa\ud83c\uddf2", "1f1fa-1f1f2.png", ":us_outlying_islands:", ":flag_um:", "Flags", "11.0");
        EmojiUtil.add(set, result, "\ud83c\uddfa\ud83c\uddf3", "1f1fa-1f1f3.png", ":united_nations:", ":flag_united_nations:", "Flags", "11.0");
        EmojiUtil.add(set, result, "\ud83c\uddfa\ud83c\uddf8", "1f1fa-1f1f8.png", ":us:", ":flag_us:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddfa\ud83c\uddfe", "1f1fa-1f1fe.png", ":uruguay:", ":flag_uy:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddfa\ud83c\uddff", "1f1fa-1f1ff.png", ":uzbekistan:", ":flag_uz:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddfa", "1f1fa.png", ":regional_indicator_u:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddfb\ud83c\udde6", "1f1fb-1f1e6.png", ":vatican_city:", ":flag_va:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddfb\ud83c\udde8", "1f1fb-1f1e8.png", ":st_vincent_grenadines:", ":flag_vc:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddfb\ud83c\uddea", "1f1fb-1f1ea.png", ":venezuela:", ":flag_ve:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddfb\ud83c\uddec", "1f1fb-1f1ec.png", ":british_virgin_islands:", ":flag_vg:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddfb\ud83c\uddee", "1f1fb-1f1ee.png", ":us_virgin_islands:", ":flag_vi:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddfb\ud83c\uddf3", "1f1fb-1f1f3.png", ":vietnam:", ":flag_vn:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddfb\ud83c\uddfa", "1f1fb-1f1fa.png", ":vanuatu:", ":flag_vu:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddfb", "1f1fb.png", ":regional_indicator_v:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddfc\ud83c\uddeb", "1f1fc-1f1eb.png", ":wallis_futuna:", ":flag_wf:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddfc\ud83c\uddf8", "1f1fc-1f1f8.png", ":samoa:", ":flag_ws:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddfc", "1f1fc.png", ":regional_indicator_w:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddfd\ud83c\uddf0", "1f1fd-1f1f0.png", ":kosovo:", ":flag_xk:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddfd", "1f1fd.png", ":regional_indicator_x:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddfe\ud83c\uddea", "1f1fe-1f1ea.png", ":yemen:", ":flag_ye:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddfe\ud83c\uddf9", "1f1fe-1f1f9.png", ":mayotte:", ":flag_yt:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddfe", "1f1fe.png", ":regional_indicator_y:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddff\ud83c\udde6", "1f1ff-1f1e6.png", ":south_africa:", ":flag_za:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddff\ud83c\uddf2", "1f1ff-1f1f2.png", ":zambia:", ":flag_zm:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddff\ud83c\uddfc", "1f1ff-1f1fc.png", ":zimbabwe:", ":flag_zw:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddff", "1f1ff.png", ":regional_indicator_z:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\ude01", "1f201.png", ":koko:", ":japanese_here_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\ude02", "1f202.png", ":sa:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\ude1a", "1f21a.png", ":u7121:", ":japanese_free_of_charge_button:", "Symbols", "");
        EmojiUtil.add(set, result, "\ud83c\ude2f", "1f22f.png", ":u6307:", ":japanese_reserved_button:", "Symbols", "");
        EmojiUtil.add(set, result, "\ud83c\ude32", "1f232.png", ":u7981:", ":japanese_prohibited_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\ude33", "1f233.png", ":u7a7a:", ":japanese_vacancy_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\ude34", "1f234.png", ":u5408:", ":japanese_passing_grade_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\ude35", "1f235.png", ":u6e80:", ":japanese_no_vacancy_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\ude36", "1f236.png", ":u6709:", ":japanese_not_free_of_charge_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\ude37", "1f237.png", ":u6708:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\ude38", "1f238.png", ":u7533:", ":japanese_application_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\ude39", "1f239.png", ":u5272:", ":japanese_discount_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\ude3a", "1f23a.png", ":u55b6:", ":japanese_open_for_business_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\ude50", "1f250.png", ":ideograph_advantage:", ":japanese_bargain_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\ude51", "1f251.png", ":accept:", ":japanese_acceptable_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf00", "1f300.png", ":cyclone:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf01", "1f301.png", ":foggy:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf02", "1f302.png", ":closed_umbrella:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf03", "1f303.png", ":night_with_stars:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf04", "1f304.png", ":sunrise_over_mountains:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf05", "1f305.png", ":sunrise:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf06", "1f306.png", ":city_sunset:", ":city_dusk:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf07", "1f307.png", ":city_sunrise:", ":sunset:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf08", "1f308.png", ":rainbow:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf09", "1f309.png", ":bridge_at_night:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf0a", "1f30a.png", ":ocean:", ":water_wave:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf0b", "1f30b.png", ":volcano:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf0c", "1f30c.png", ":milky_way:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf0d", "1f30d.png", ":earth_africa:", ":globe_showing_europe_africa:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf0e", "1f30e.png", ":earth_americas:", ":globe_showing_americas:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf0f", "1f30f.png", ":earth_asia:", ":globe_showing_asia_australia:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf10", "1f310.png", ":globe_with_meridians:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf11", "1f311.png", ":new_moon:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf12", "1f312.png", ":waxing_crescent_moon:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf13", "1f313.png", ":first_quarter_moon:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf14", "1f314.png", ":moon:", ":waxing_gibbous_moon:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf15", "1f315.png", ":full_moon:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf16", "1f316.png", ":waning_gibbous_moon:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf17", "1f317.png", ":last_quarter_moon:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf18", "1f318.png", ":waning_crescent_moon:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf19", "1f319.png", ":crescent_moon:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf1a", "1f31a.png", ":new_moon_with_face:", ":new_moon_face:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf1b", "1f31b.png", ":first_quarter_moon_with_face:", ":first_quarter_moon_face:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf1c", "1f31c.png", ":last_quarter_moon_with_face:", ":last_quarter_moon_face:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf1d", "1f31d.png", ":full_moon_with_face:", ":full_moon_face:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf1e", "1f31e.png", ":sun_with_face:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf1f", "1f31f.png", ":star2:", ":glowing_star:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf20", "1f320.png", ":stars:", ":shooting_star:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf21", "1f321.png", ":thermometer:", null, "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udf24", "1f324.png", ":sun_behind_small_cloud:", ":white_sun_small_cloud:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udf25", "1f325.png", ":sun_behind_large_cloud:", ":white_sun_cloud:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udf26", "1f326.png", ":sun_behind_rain_cloud:", ":white_sun_rain_cloud:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udf27", "1f327.png", ":cloud_with_rain:", ":cloud_rain:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udf28", "1f328.png", ":cloud_with_snow:", ":cloud_snow:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udf29", "1f329.png", ":cloud_with_lightning:", ":cloud_lightning:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udf2a", "1f32a.png", ":tornado:", ":cloud_tornado:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udf2b", "1f32b.png", ":fog:", null, "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udf2c", "1f32c.png", ":wind_face:", ":wind_blowing_face:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udf2d", "1f32d.png", ":hotdog:", ":hot_dog:", "Food & Drink", "8.0");
        EmojiUtil.add(set, result, "\ud83c\udf2e", "1f32e.png", ":taco:", null, "Food & Drink", "8.0");
        EmojiUtil.add(set, result, "\ud83c\udf2f", "1f32f.png", ":burrito:", null, "Food & Drink", "8.0");
        EmojiUtil.add(set, result, "\ud83c\udf30", "1f330.png", ":chestnut:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf31", "1f331.png", ":seedling:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf32", "1f332.png", ":evergreen_tree:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf33", "1f333.png", ":deciduous_tree:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf34", "1f334.png", ":palm_tree:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf35", "1f335.png", ":cactus:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf36", "1f336.png", ":hot_pepper:", null, "Food & Drink", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udf37", "1f337.png", ":tulip:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf38", "1f338.png", ":cherry_blossom:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf39", "1f339.png", ":rose:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf3a", "1f33a.png", ":hibiscus:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf3b", "1f33b.png", ":sunflower:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf3c", "1f33c.png", ":blossom:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf3d", "1f33d.png", ":corn:", ":ear_of_corn:", "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf3e", "1f33e.png", ":ear_of_rice:", ":sheaf_of_rice:", "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf3f", "1f33f.png", ":herb:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf40", "1f340.png", ":four_leaf_clover:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf41", "1f341.png", ":maple_leaf:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf42", "1f342.png", ":fallen_leaf:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf43", "1f343.png", ":leaves:", ":leaf_fluttering_in_wind:", "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf44", "1f344.png", ":mushroom:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf45", "1f345.png", ":tomato:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf46", "1f346.png", ":eggplant:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf47", "1f347.png", ":grapes:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf48", "1f348.png", ":melon:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf49", "1f349.png", ":watermelon:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf4a", "1f34a.png", ":tangerine:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf4b", "1f34b.png", ":lemon:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf4c", "1f34c.png", ":banana:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf4d", "1f34d.png", ":pineapple:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf4e", "1f34e.png", ":apple:", ":red_apple:", "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf4f", "1f34f.png", ":green_apple:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf50", "1f350.png", ":pear:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf51", "1f351.png", ":peach:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf52", "1f352.png", ":cherries:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf53", "1f353.png", ":strawberry:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf54", "1f354.png", ":hamburger:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf55", "1f355.png", ":pizza:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf56", "1f356.png", ":meat_on_bone:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf57", "1f357.png", ":poultry_leg:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf58", "1f358.png", ":rice_cracker:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf59", "1f359.png", ":rice_ball:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf5a", "1f35a.png", ":rice:", ":cooked_rice:", "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf5b", "1f35b.png", ":curry:", ":curry_rice:", "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf5c", "1f35c.png", ":ramen:", ":steaming_bowl:", "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf5d", "1f35d.png", ":spaghetti:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf5e", "1f35e.png", ":bread:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf5f", "1f35f.png", ":fries:", ":french_fries:", "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf60", "1f360.png", ":sweet_potato:", ":roasted_sweet_potato:", "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf61", "1f361.png", ":dango:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf62", "1f362.png", ":oden:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf63", "1f363.png", ":sushi:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf64", "1f364.png", ":fried_shrimp:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf65", "1f365.png", ":fish_cake:", ":fish_cake_with_swirl:", "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf66", "1f366.png", ":icecream:", ":soft_ice_cream:", "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf67", "1f367.png", ":shaved_ice:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf68", "1f368.png", ":ice_cream:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf69", "1f369.png", ":doughnut:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf6a", "1f36a.png", ":cookie:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf6b", "1f36b.png", ":chocolate_bar:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf6c", "1f36c.png", ":candy:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf6d", "1f36d.png", ":lollipop:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf6e", "1f36e.png", ":custard:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf6f", "1f36f.png", ":honey_pot:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf70", "1f370.png", ":cake:", ":shortcake:", "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf71", "1f371.png", ":bento:", ":bento_box:", "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf72", "1f372.png", ":stew:", ":pot_of_food:", "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf73", "1f373.png", ":fried_egg:", ":cooking:", "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf74", "1f374.png", ":fork_and_knife:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf75", "1f375.png", ":tea:", ":teacup_without_handle:", "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf76", "1f376.png", ":sake:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf77", "1f377.png", ":wine_glass:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf78", "1f378.png", ":cocktail:", ":cocktail_glass:", "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf79", "1f379.png", ":tropical_drink:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf7a", "1f37a.png", ":beer:", ":beer_mug:", "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf7b", "1f37b.png", ":beers:", ":clinking_beer_mugs:", "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf7c", "1f37c.png", ":baby_bottle:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf7d", "1f37d.png", ":plate_with_cutlery:", ":fork_knife_plate:", "Food & Drink", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udf7e", "1f37e.png", ":champagne:", ":bottle_with_popping_cork:", "Food & Drink", "8.0");
        EmojiUtil.add(set, result, "\ud83c\udf7f", "1f37f.png", ":popcorn:", null, "Food & Drink", "8.0");
        EmojiUtil.add(set, result, "\ud83c\udf80", "1f380.png", ":ribbon:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf81", "1f381.png", ":gift:", ":wrapped_gift:", "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf82", "1f382.png", ":birthday:", ":birthday_cake:", "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf83", "1f383.png", ":jack_o_lantern:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf84", "1f384.png", ":christmas_tree:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf85\ud83c\udffb", "1f385-1f3fb.png", ":santa_tone1:", ":santa_claus_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf85\ud83c\udffc", "1f385-1f3fc.png", ":santa_tone2:", ":santa_claus_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf85\ud83c\udffd", "1f385-1f3fd.png", ":santa_tone3:", ":santa_claus_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf85\ud83c\udffe", "1f385-1f3fe.png", ":santa_tone4:", ":santa_claus_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf85\ud83c\udfff", "1f385-1f3ff.png", ":santa_tone5:", ":santa_claus_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf85", "1f385.png", ":santa:", ":santa_claus:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf86", "1f386.png", ":fireworks:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf87", "1f387.png", ":sparkler:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf88", "1f388.png", ":balloon:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf89", "1f389.png", ":tada:", ":party_popper:", "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf8a", "1f38a.png", ":confetti_ball:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf8b", "1f38b.png", ":tanabata_tree:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf8c", "1f38c.png", ":crossed_flags:", null, "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf8d", "1f38d.png", ":bamboo:", ":pine_decoration:", "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf8e", "1f38e.png", ":dolls:", ":japanese_dolls:", "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf8f", "1f38f.png", ":flags:", ":carp_streamer:", "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf90", "1f390.png", ":wind_chime:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf91", "1f391.png", ":rice_scene:", ":moon_viewing_ceremony:", "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf92", "1f392.png", ":school_satchel:", ":backpack:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf93", "1f393.png", ":mortar_board:", ":graduation_cap:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf96", "1f396.png", ":medal_military:", ":military_medal:", "Activities", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udf97", "1f397.png", ":reminder_ribbon:", null, "Activities", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udf99", "1f399.png", ":studio_microphone:", ":microphone2:", "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udf9a", "1f39a.png", ":level_slider:", null, "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udf9b", "1f39b.png", ":control_knobs:", null, "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udf9e", "1f39e.png", ":film_strip:", ":film_frames:", "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udf9f", "1f39f.png", ":tickets:", null, "Activities", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfa0", "1f3a0.png", ":carousel_horse:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfa1", "1f3a1.png", ":ferris_wheel:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfa2", "1f3a2.png", ":roller_coaster:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfa3", "1f3a3.png", ":fishing_pole_and_fish:", ":fishing_pole:", "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfa4", "1f3a4.png", ":microphone:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfa5", "1f3a5.png", ":movie_camera:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfa6", "1f3a6.png", ":cinema:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfa7", "1f3a7.png", ":headphones:", ":headphone:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfa8", "1f3a8.png", ":art:", ":artist_palette:", "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfa9", "1f3a9.png", ":tophat:", ":top_hat:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfaa", "1f3aa.png", ":circus_tent:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfab", "1f3ab.png", ":ticket:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfac", "1f3ac.png", ":clapper:", ":clapper_board:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfad", "1f3ad.png", ":performing_arts:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfae", "1f3ae.png", ":video_game:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfaf", "1f3af.png", ":dart:", ":bullseye:", "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfb0", "1f3b0.png", ":slot_machine:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfb1", "1f3b1.png", ":8ball:", ":pool_8_ball:", "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfb2", "1f3b2.png", ":game_die:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfb3", "1f3b3.png", ":bowling:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfb4", "1f3b4.png", ":flower_playing_cards:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfb5", "1f3b5.png", ":musical_note:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfb6", "1f3b6.png", ":notes:", ":musical_notes:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfb7", "1f3b7.png", ":saxophone:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfb8", "1f3b8.png", ":guitar:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfb9", "1f3b9.png", ":musical_keyboard:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfba", "1f3ba.png", ":trumpet:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfbb", "1f3bb.png", ":violin:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfbc", "1f3bc.png", ":musical_score:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfbd", "1f3bd.png", ":running_shirt_with_sash:", ":running_shirt:", "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfbe", "1f3be.png", ":tennis:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfbf", "1f3bf.png", ":ski:", ":skis:", "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc0", "1f3c0.png", ":basketball:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc1", "1f3c1.png", ":checkered_flag:", ":chequered_flag:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc2\ud83c\udffb", "1f3c2-1f3fb.png", ":snowboarder_tone1:", ":snowboarder_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc2\ud83c\udffc", "1f3c2-1f3fc.png", ":snowboarder_tone2:", ":snowboarder_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc2\ud83c\udffd", "1f3c2-1f3fd.png", ":snowboarder_tone3:", ":snowboarder_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc2\ud83c\udffe", "1f3c2-1f3fe.png", ":snowboarder_tone4:", ":snowboarder_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc2\ud83c\udfff", "1f3c2-1f3ff.png", ":snowboarder_tone5:", ":snowboarder_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc2", "1f3c2.png", ":snowboarder:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc3\ud83c\udffb\u200d\u2640\ufe0f", "1f3c3-1f3fb-200d-2640-fe0f.png", ":woman_runner_tone1:", ":woman_running_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc3\ud83c\udffb\u200d\u2642\ufe0f", "1f3c3-1f3fb-200d-2642-fe0f.png", ":man_runner_tone1:", ":man_running_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc3\ud83c\udffb", "1f3c3-1f3fb.png", ":runner_tone1:", ":person_running_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc3\ud83c\udffc\u200d\u2640\ufe0f", "1f3c3-1f3fc-200d-2640-fe0f.png", ":woman_runner_tone2:", ":woman_running_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc3\ud83c\udffc\u200d\u2642\ufe0f", "1f3c3-1f3fc-200d-2642-fe0f.png", ":man_runner_tone2:", ":man_running_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc3\ud83c\udffc", "1f3c3-1f3fc.png", ":runner_tone2:", ":person_running_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc3\ud83c\udffd\u200d\u2640\ufe0f", "1f3c3-1f3fd-200d-2640-fe0f.png", ":woman_runner_tone3:", ":woman_running_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc3\ud83c\udffd\u200d\u2642\ufe0f", "1f3c3-1f3fd-200d-2642-fe0f.png", ":man_runner_tone3:", ":man_running_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc3\ud83c\udffd", "1f3c3-1f3fd.png", ":runner_tone3:", ":person_running_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc3\ud83c\udffe\u200d\u2640\ufe0f", "1f3c3-1f3fe-200d-2640-fe0f.png", ":woman_runner_tone4:", ":woman_running_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc3\ud83c\udffe\u200d\u2642\ufe0f", "1f3c3-1f3fe-200d-2642-fe0f.png", ":man_runner_tone4:", ":man_running_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc3\ud83c\udffe", "1f3c3-1f3fe.png", ":runner_tone4:", ":person_running_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc3\ud83c\udfff\u200d\u2640\ufe0f", "1f3c3-1f3ff-200d-2640-fe0f.png", ":woman_runner_tone5:", ":woman_running_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc3\ud83c\udfff\u200d\u2642\ufe0f", "1f3c3-1f3ff-200d-2642-fe0f.png", ":man_runner_tone5:", ":man_running_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc3\ud83c\udfff", "1f3c3-1f3ff.png", ":runner_tone5:", ":person_running_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc3\u200d\u2640\ufe0f", "1f3c3-200d-2640-fe0f.png", ":running_woman:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc3\u200d\u2642\ufe0f", "1f3c3-200d-2642-fe0f.png", ":running_man:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83c\udfc3", "1f3c3.png", ":runner:", ":person_running:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc4\ud83c\udffb\u200d\u2640\ufe0f", "1f3c4-1f3fb-200d-2640-fe0f.png", ":woman_surfer_tone1:", ":woman_surfing_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc4\ud83c\udffb\u200d\u2642\ufe0f", "1f3c4-1f3fb-200d-2642-fe0f.png", ":man_surfer_tone1:", ":man_surfing_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc4\ud83c\udffb", "1f3c4-1f3fb.png", ":surfer_tone1:", ":person_surfing_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc4\ud83c\udffc\u200d\u2640\ufe0f", "1f3c4-1f3fc-200d-2640-fe0f.png", ":woman_surfer_tone2:", ":woman_surfing_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc4\ud83c\udffc\u200d\u2642\ufe0f", "1f3c4-1f3fc-200d-2642-fe0f.png", ":man_surfer_tone2:", ":man_surfing_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc4\ud83c\udffc", "1f3c4-1f3fc.png", ":surfer_tone2:", ":person_surfing_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc4\ud83c\udffd\u200d\u2640\ufe0f", "1f3c4-1f3fd-200d-2640-fe0f.png", ":woman_surfer_tone3:", ":woman_surfing_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc4\ud83c\udffd\u200d\u2642\ufe0f", "1f3c4-1f3fd-200d-2642-fe0f.png", ":man_surfer_tone3:", ":man_surfing_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc4\ud83c\udffd", "1f3c4-1f3fd.png", ":surfer_tone3:", ":person_surfing_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc4\ud83c\udffe\u200d\u2640\ufe0f", "1f3c4-1f3fe-200d-2640-fe0f.png", ":woman_surfer_tone4:", ":woman_surfing_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc4\ud83c\udffe\u200d\u2642\ufe0f", "1f3c4-1f3fe-200d-2642-fe0f.png", ":man_surfer_tone4:", ":man_surfing_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc4\ud83c\udffe", "1f3c4-1f3fe.png", ":surfer_tone4:", ":person_surfing_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc4\ud83c\udfff\u200d\u2640\ufe0f", "1f3c4-1f3ff-200d-2640-fe0f.png", ":woman_surfer_tone5:", ":woman_surfing_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc4\ud83c\udfff\u200d\u2642\ufe0f", "1f3c4-1f3ff-200d-2642-fe0f.png", ":man_surfer_tone5:", ":man_surfing_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc4\ud83c\udfff", "1f3c4-1f3ff.png", ":surfer_tone5:", ":person_surfing_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc4\u200d\u2640\ufe0f", "1f3c4-200d-2640-fe0f.png", ":surfing_woman:", null, "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfc4\u200d\u2642\ufe0f", "1f3c4-200d-2642-fe0f.png", ":surfing_man:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83c\udfc4", "1f3c4.png", ":surfer:", ":person_surfing:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc5", "1f3c5.png", ":medal_sports:", ":medal:", "Activities", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfc6", "1f3c6.png", ":trophy:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc7\ud83c\udffb", "1f3c7-1f3fb.png", ":horse_racing_tone1:", ":horse_racing_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc7\ud83c\udffc", "1f3c7-1f3fc.png", ":horse_racing_tone2:", ":horse_racing_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc7\ud83c\udffd", "1f3c7-1f3fd.png", ":horse_racing_tone3:", ":horse_racing_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc7\ud83c\udffe", "1f3c7-1f3fe.png", ":horse_racing_tone4:", ":horse_racing_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc7\ud83c\udfff", "1f3c7-1f3ff.png", ":horse_racing_tone5:", ":horse_racing_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc7", "1f3c7.png", ":horse_racing:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc8", "1f3c8.png", ":football:", ":american_football:", "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc9", "1f3c9.png", ":rugby_football:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfca\ud83c\udffb\u200d\u2640\ufe0f", "1f3ca-1f3fb-200d-2640-fe0f.png", ":woman_swimmer_tone1:", ":woman_swimming_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfca\ud83c\udffb\u200d\u2642\ufe0f", "1f3ca-1f3fb-200d-2642-fe0f.png", ":man_swimmer_tone1:", ":man_swimming_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfca\ud83c\udffb", "1f3ca-1f3fb.png", ":swimmer_tone1:", ":person_swimming_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfca\ud83c\udffc\u200d\u2640\ufe0f", "1f3ca-1f3fc-200d-2640-fe0f.png", ":woman_swimmer_tone2:", ":woman_swimming_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfca\ud83c\udffc\u200d\u2642\ufe0f", "1f3ca-1f3fc-200d-2642-fe0f.png", ":man_swimmer_tone2:", ":man_swimming_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfca\ud83c\udffc", "1f3ca-1f3fc.png", ":swimmer_tone2:", ":person_swimming_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfca\ud83c\udffd\u200d\u2640\ufe0f", "1f3ca-1f3fd-200d-2640-fe0f.png", ":woman_swimmer_tone3:", ":woman_swimming_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfca\ud83c\udffd\u200d\u2642\ufe0f", "1f3ca-1f3fd-200d-2642-fe0f.png", ":man_swimmer_tone3:", ":man_swimming_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfca\ud83c\udffd", "1f3ca-1f3fd.png", ":swimmer_tone3:", ":person_swimming_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfca\ud83c\udffe\u200d\u2640\ufe0f", "1f3ca-1f3fe-200d-2640-fe0f.png", ":woman_swimmer_tone4:", ":woman_swimming_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfca\ud83c\udffe\u200d\u2642\ufe0f", "1f3ca-1f3fe-200d-2642-fe0f.png", ":man_swimmer_tone4:", ":man_swimming_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfca\ud83c\udffe", "1f3ca-1f3fe.png", ":swimmer_tone4:", ":person_swimming_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfca\ud83c\udfff\u200d\u2640\ufe0f", "1f3ca-1f3ff-200d-2640-fe0f.png", ":woman_swimmer_tone5:", ":woman_swimming_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfca\ud83c\udfff\u200d\u2642\ufe0f", "1f3ca-1f3ff-200d-2642-fe0f.png", ":man_swimmer_tone5:", ":man_swimming_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfca\ud83c\udfff", "1f3ca-1f3ff.png", ":swimmer_tone5:", ":person_swimming_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfca\u200d\u2640\ufe0f", "1f3ca-200d-2640-fe0f.png", ":swimming_woman:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfca\u200d\u2642\ufe0f", "1f3ca-200d-2642-fe0f.png", ":swimming_man:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83c\udfca", "1f3ca.png", ":swimmer:", ":person_swimming:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfcb\ud83c\udffb\u200d\u2640\ufe0f", "1f3cb-1f3fb-200d-2640-fe0f.png", ":woman_weight_lifting_tone1:", ":woman_lifting_weights_light_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcb\ud83c\udffb\u200d\u2642\ufe0f", "1f3cb-1f3fb-200d-2642-fe0f.png", ":man_weight_lifting_tone1:", ":man_lifting_weights_light_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcb\ud83c\udffb", "1f3cb-1f3fb.png", ":weight_lifting_tone1:", ":person_lifting_weights_tone1:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcb\ud83c\udffc\u200d\u2640\ufe0f", "1f3cb-1f3fc-200d-2640-fe0f.png", ":woman_weight_lifting_tone2:", ":woman_lifting_weights_medium_light_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcb\ud83c\udffc\u200d\u2642\ufe0f", "1f3cb-1f3fc-200d-2642-fe0f.png", ":man_weight_lifting_tone2:", ":man_lifting_weights_medium_light_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcb\ud83c\udffc", "1f3cb-1f3fc.png", ":weight_lifting_tone2:", ":person_lifting_weights_tone2:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcb\ud83c\udffd\u200d\u2640\ufe0f", "1f3cb-1f3fd-200d-2640-fe0f.png", ":woman_weight_lifting_tone3:", ":woman_lifting_weights_medium_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcb\ud83c\udffd\u200d\u2642\ufe0f", "1f3cb-1f3fd-200d-2642-fe0f.png", ":man_weight_lifting_tone3:", ":man_lifting_weights_medium_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcb\ud83c\udffd", "1f3cb-1f3fd.png", ":weight_lifting_tone3:", ":person_lifting_weights_tone3:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcb\ud83c\udffe\u200d\u2640\ufe0f", "1f3cb-1f3fe-200d-2640-fe0f.png", ":woman_weight_lifting_tone4:", ":woman_lifting_weights_medium_dark_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcb\ud83c\udffe\u200d\u2642\ufe0f", "1f3cb-1f3fe-200d-2642-fe0f.png", ":man_weight_lifting_tone4:", ":man_lifting_weights_medium_dark_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcb\ud83c\udffe", "1f3cb-1f3fe.png", ":weight_lifting_tone4:", ":person_lifting_weights_tone4:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcb\ud83c\udfff\u200d\u2640\ufe0f", "1f3cb-1f3ff-200d-2640-fe0f.png", ":woman_weight_lifting_tone5:", ":woman_lifting_weights_dark_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcb\ud83c\udfff\u200d\u2642\ufe0f", "1f3cb-1f3ff-200d-2642-fe0f.png", ":man_weight_lifting_tone5:", ":man_lifting_weights_dark_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcb\ud83c\udfff", "1f3cb-1f3ff.png", ":weight_lifting_tone5:", ":person_lifting_weights_tone5:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcb\ufe0f\u200d\u2640\ufe0f", "1f3cb-fe0f-200d-2640-fe0f.png", ":weight_lifting_woman:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfcb\ufe0f\u200d\u2642\ufe0f", "1f3cb-fe0f-200d-2642-fe0f.png", ":weight_lifting_man:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83c\udfcb", "1f3cb.png", ":weight_lifting:", ":person_lifting_weights:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcc\ud83c\udffb\u200d\u2640\ufe0f", "1f3cc-1f3fb-200d-2640-fe0f.png", ":woman_golfing_tone1:", ":woman_golfing_light_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcc\ud83c\udffb\u200d\u2642\ufe0f", "1f3cc-1f3fb-200d-2642-fe0f.png", ":man_golfing_tone1:", ":man_golfing_light_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcc\ud83c\udffb", "1f3cc-1f3fb.png", ":golfing_tone1:", ":person_golfing_tone1:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcc\ud83c\udffc\u200d\u2640\ufe0f", "1f3cc-1f3fc-200d-2640-fe0f.png", ":woman_golfing_tone2:", ":woman_golfing_medium_light_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcc\ud83c\udffc\u200d\u2642\ufe0f", "1f3cc-1f3fc-200d-2642-fe0f.png", ":man_golfing_tone2:", ":man_golfing_medium_light_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcc\ud83c\udffc", "1f3cc-1f3fc.png", ":golfing_tone2:", ":person_golfing_tone2:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcc\ud83c\udffd\u200d\u2640\ufe0f", "1f3cc-1f3fd-200d-2640-fe0f.png", ":woman_golfing_tone3:", ":woman_golfing_medium_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcc\ud83c\udffd\u200d\u2642\ufe0f", "1f3cc-1f3fd-200d-2642-fe0f.png", ":man_golfing_tone3:", ":man_golfing_medium_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcc\ud83c\udffd", "1f3cc-1f3fd.png", ":golfing_tone3:", ":person_golfing_tone3:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcc\ud83c\udffe\u200d\u2640\ufe0f", "1f3cc-1f3fe-200d-2640-fe0f.png", ":woman_golfing_tone4:", ":woman_golfing_medium_dark_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcc\ud83c\udffe\u200d\u2642\ufe0f", "1f3cc-1f3fe-200d-2642-fe0f.png", ":man_golfing_tone4:", ":man_golfing_medium_dark_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcc\ud83c\udffe", "1f3cc-1f3fe.png", ":golfing_tone4:", ":person_golfing_tone4:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcc\ud83c\udfff\u200d\u2640\ufe0f", "1f3cc-1f3ff-200d-2640-fe0f.png", ":woman_golfing_tone5:", ":woman_golfing_dark_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcc\ud83c\udfff\u200d\u2642\ufe0f", "1f3cc-1f3ff-200d-2642-fe0f.png", ":man_golfing_tone5:", ":man_golfing_dark_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcc\ud83c\udfff", "1f3cc-1f3ff.png", ":golfing_tone5:", ":person_golfing_tone5:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcc\ufe0f\u200d\u2640\ufe0f", "1f3cc-fe0f-200d-2640-fe0f.png", ":golfing_woman:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\ud83c\udfcc\ufe0f\u200d\u2642\ufe0f", "1f3cc-fe0f-200d-2642-fe0f.png", ":golfing_man:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83c\udfcc", "1f3cc.png", ":golfing:", ":person_golfing:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcd", "1f3cd.png", ":motorcycle:", null, "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfce", "1f3ce.png", ":racing_car:", ":race_car:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcf", "1f3cf.png", ":cricket_game:", null, "Activities", "8.0");
        EmojiUtil.add(set, result, "\ud83c\udfd0", "1f3d0.png", ":volleyball:", null, "Activities", "8.0");
        EmojiUtil.add(set, result, "\ud83c\udfd1", "1f3d1.png", ":field_hockey:", null, "Activities", "8.0");
        EmojiUtil.add(set, result, "\ud83c\udfd2", "1f3d2.png", ":ice_hockey:", ":hockey:", "Activities", "8.0");
        EmojiUtil.add(set, result, "\ud83c\udfd3", "1f3d3.png", ":ping_pong:", null, "Activities", "8.0");
        EmojiUtil.add(set, result, "\ud83c\udfd4", "1f3d4.png", ":mountain_snow:", null, "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfd5", "1f3d5.png", ":camping:", null, "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfd6", "1f3d6.png", ":beach_umbrella:", ":beach:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfd7", "1f3d7.png", ":building_construction:", ":construction_site:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfd8", "1f3d8.png", ":houses:", ":homes:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfd9", "1f3d9.png", ":cityscape:", null, "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfda", "1f3da.png", ":derelict_house:", ":house_abandoned:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfdb", "1f3db.png", ":classical_building:", null, "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfdc", "1f3dc.png", ":desert:", null, "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfdd", "1f3dd.png", ":desert_island:", ":island:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfde", "1f3de.png", ":national_park:", ":park:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfdf", "1f3df.png", ":stadium:", null, "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfe0", "1f3e0.png", ":house:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfe1", "1f3e1.png", ":house_with_garden:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfe2", "1f3e2.png", ":office:", ":office_building:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfe3", "1f3e3.png", ":post_office:", ":japanese_post_office:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfe4", "1f3e4.png", ":european_post_office:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfe5", "1f3e5.png", ":hospital:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfe6", "1f3e6.png", ":bank:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfe7", "1f3e7.png", ":atm:", ":atm_sign:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfe8", "1f3e8.png", ":hotel:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfe9", "1f3e9.png", ":love_hotel:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfea", "1f3ea.png", ":convenience_store:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfeb", "1f3eb.png", ":school:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfec", "1f3ec.png", ":department_store:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfed", "1f3ed.png", ":factory:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfee", "1f3ee.png", ":izakaya_lantern:", ":red_paper_lantern:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfef", "1f3ef.png", ":japanese_castle:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udff0", "1f3f0.png", ":european_castle:", ":castle:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udff3\ufe0f\u200d\ud83c\udf08", "1f3f3-fe0f-200d-1f308.png", ":rainbow_flag:", null, "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udff3\ufe0f\u200d\u26a7\ufe0f", "1f3f3-fe0f-200d-26a7-fe0f.png", ":transgender_flag:", null, "Flags", "13.0");
        EmojiUtil.add(set, result, "\ud83c\udff3", "1f3f3.png", ":white_flag:", ":flag_white:", "Flags", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udff4\u200d\u2620\ufe0f", "1f3f4-200d-2620-fe0f.png", ":pirate_flag:", null, "Flags", "11.0");
        EmojiUtil.add(set, result, "\ud83c\udff4\udb40\udc67\udb40\udc62\udb40\udc65\udb40\udc6e\udb40\udc67\udb40\udc7f", "1f3f4-e0067-e0062-e0065-e006e-e0067-e007f.png", ":england:", ":flag_england:", "Flags", "11.0");
        EmojiUtil.add(set, result, "\ud83c\udff4\udb40\udc67\udb40\udc62\udb40\udc73\udb40\udc63\udb40\udc74\udb40\udc7f", "1f3f4-e0067-e0062-e0073-e0063-e0074-e007f.png", ":scotland:", ":flag_scotland:", "Flags", "11.0");
        EmojiUtil.add(set, result, "\ud83c\udff4\udb40\udc67\udb40\udc62\udb40\udc77\udb40\udc6c\udb40\udc73\udb40\udc7f", "1f3f4-e0067-e0062-e0077-e006c-e0073-e007f.png", ":wales:", ":flag_wales:", "Flags", "11.0");
        EmojiUtil.add(set, result, "\ud83c\udff4", "1f3f4.png", ":black_flag:", ":flag_black:", "Flags", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udff5", "1f3f5.png", ":rosette:", null, "Animals & Nature", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udff7", "1f3f7.png", ":label:", null, "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udff8", "1f3f8.png", ":badminton:", null, "Activities", "8.0");
        EmojiUtil.add(set, result, "\ud83c\udff9", "1f3f9.png", ":bow_and_arrow:", null, "Objects", "8.0");
        EmojiUtil.add(set, result, "\ud83c\udffa", "1f3fa.png", ":amphora:", null, "Food & Drink", "8.0");
        EmojiUtil.add(set, result, "\ud83c\udffb", "1f3fb.png", ":tone1:", ":light_skin_tone:", "Other", null);
        EmojiUtil.add(set, result, "\ud83c\udffc", "1f3fc.png", ":tone2:", ":medium_light_skin_tone:", "Other", null);
        EmojiUtil.add(set, result, "\ud83c\udffd", "1f3fd.png", ":tone3:", ":medium_skin_tone:", "Other", null);
        EmojiUtil.add(set, result, "\ud83c\udffe", "1f3fe.png", ":tone4:", ":medium_dark_skin_tone:", "Other", null);
        EmojiUtil.add(set, result, "\ud83c\udfff", "1f3ff.png", ":tone5:", ":dark_skin_tone:", "Other", null);
        EmojiUtil.add(set, result, "\ud83d\udc00", "1f400.png", ":rat:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc01", "1f401.png", ":mouse2:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc02", "1f402.png", ":ox:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc03", "1f403.png", ":water_buffalo:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc04", "1f404.png", ":cow2:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc05", "1f405.png", ":tiger2:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc06", "1f406.png", ":leopard:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc07", "1f407.png", ":rabbit2:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc08\u200d\u2b1b", "1f408-200d-2b1b.png", ":black_cat:", null, "Animals & Nature", "13.0");
        EmojiUtil.add(set, result, "\ud83d\udc08", "1f408.png", ":cat2:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc09", "1f409.png", ":dragon:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc0a", "1f40a.png", ":crocodile:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc0b", "1f40b.png", ":whale2:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc0c", "1f40c.png", ":snail:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc0d", "1f40d.png", ":snake:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc0e", "1f40e.png", ":racehorse:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc0f", "1f40f.png", ":ram:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc10", "1f410.png", ":goat:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc11", "1f411.png", ":sheep:", ":ewe:", "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc12", "1f412.png", ":monkey:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc13", "1f413.png", ":rooster:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc14", "1f414.png", ":chicken:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc15\u200d\ud83e\uddba", "1f415-200d-1f9ba.png", ":service_dog:", null, "Animals & Nature", "12.0");
        EmojiUtil.add(set, result, "\ud83d\udc15", "1f415.png", ":dog2:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc16", "1f416.png", ":pig2:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc17", "1f417.png", ":boar:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc18", "1f418.png", ":elephant:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc19", "1f419.png", ":octopus:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc1a", "1f41a.png", ":shell:", ":spiral_shell:", "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc1b", "1f41b.png", ":bug:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc1c", "1f41c.png", ":ant:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc1d", "1f41d.png", ":bee:", ":honeybee:", "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc1e", "1f41e.png", ":lady_beetle:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc1f", "1f41f.png", ":fish:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc20", "1f420.png", ":tropical_fish:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc21", "1f421.png", ":blowfish:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc22", "1f422.png", ":turtle:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc23", "1f423.png", ":hatching_chick:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc24", "1f424.png", ":baby_chick:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc25", "1f425.png", ":hatched_chick:", ":front_facing_baby_chick:", "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc26", "1f426.png", ":bird:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc27", "1f427.png", ":penguin:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc28", "1f428.png", ":koala:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc29", "1f429.png", ":poodle:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc2a", "1f42a.png", ":dromedary_camel:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc2b", "1f42b.png", ":camel:", ":two_hump_camel:", "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc2c", "1f42c.png", ":dolphin:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc2d", "1f42d.png", ":mouse:", ":mouse_face:", "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc2e", "1f42e.png", ":cow:", ":cow_face:", "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc2f", "1f42f.png", ":tiger:", ":tiger_face:", "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc30", "1f430.png", ":rabbit:", ":rabbit_face:", "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc31", "1f431.png", ":cat:", ":cat_face:", "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc32", "1f432.png", ":dragon_face:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc33", "1f433.png", ":whale:", ":spouting_whale:", "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc34", "1f434.png", ":horse:", ":horse_face:", "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc35", "1f435.png", ":monkey_face:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc36", "1f436.png", ":dog:", ":dog_face:", "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc37", "1f437.png", ":pig:", ":pig_face:", "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc38", "1f438.png", ":frog:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc39", "1f439.png", ":hamster:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc3a", "1f43a.png", ":wolf:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc3b\u200d\u2744\ufe0f", "1f43b-200d-2744-fe0f.png", ":polar_bear:", null, "Animals & Nature", "13.0");
        EmojiUtil.add(set, result, "\ud83d\udc3b", "1f43b.png", ":bear:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc3c", "1f43c.png", ":panda_face:", ":panda:", "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc3d", "1f43d.png", ":pig_nose:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc3e", "1f43e.png", ":feet:", ":paw_prints:", "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc3f", "1f43f.png", ":chipmunk:", null, "Animals & Nature", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udc40", "1f440.png", ":eyes:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc41\u200d\ud83d\udde8", "1f441-200d-1f5e8.png", ":eye_speech_bubble:", null, "Smileys & Emotion", "11.0");
        EmojiUtil.add(set, result, "\ud83d\udc41", "1f441.png", ":eye:", null, "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udc42\ud83c\udffb", "1f442-1f3fb.png", ":ear_tone1:", ":ear_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc42\ud83c\udffc", "1f442-1f3fc.png", ":ear_tone2:", ":ear_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc42\ud83c\udffd", "1f442-1f3fd.png", ":ear_tone3:", ":ear_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc42\ud83c\udffe", "1f442-1f3fe.png", ":ear_tone4:", ":ear_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc42\ud83c\udfff", "1f442-1f3ff.png", ":ear_tone5:", ":ear_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc42", "1f442.png", ":ear:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc43\ud83c\udffb", "1f443-1f3fb.png", ":nose_tone1:", ":nose_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc43\ud83c\udffc", "1f443-1f3fc.png", ":nose_tone2:", ":nose_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc43\ud83c\udffd", "1f443-1f3fd.png", ":nose_tone3:", ":nose_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc43\ud83c\udffe", "1f443-1f3fe.png", ":nose_tone4:", ":nose_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc43\ud83c\udfff", "1f443-1f3ff.png", ":nose_tone5:", ":nose_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc43", "1f443.png", ":nose:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc44", "1f444.png", ":lips:", ":mouth:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc45", "1f445.png", ":tongue:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc46\ud83c\udffb", "1f446-1f3fb.png", ":point_up_2_tone1:", ":backhand_index_pointing_up_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc46\ud83c\udffc", "1f446-1f3fc.png", ":point_up_2_tone2:", ":backhand_index_pointing_up_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc46\ud83c\udffd", "1f446-1f3fd.png", ":point_up_2_tone3:", ":backhand_index_pointing_up_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc46\ud83c\udffe", "1f446-1f3fe.png", ":point_up_2_tone4:", ":backhand_index_pointing_up_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc46\ud83c\udfff", "1f446-1f3ff.png", ":point_up_2_tone5:", ":backhand_index_pointing_up_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc46", "1f446.png", ":point_up_2:", ":backhand_index_pointing_up:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc47\ud83c\udffb", "1f447-1f3fb.png", ":point_down_tone1:", ":backhand_index_pointing_down_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc47\ud83c\udffc", "1f447-1f3fc.png", ":point_down_tone2:", ":backhand_index_pointing_down_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc47\ud83c\udffd", "1f447-1f3fd.png", ":point_down_tone3:", ":backhand_index_pointing_down_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc47\ud83c\udffe", "1f447-1f3fe.png", ":point_down_tone4:", ":backhand_index_pointing_down_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc47\ud83c\udfff", "1f447-1f3ff.png", ":point_down_tone5:", ":backhand_index_pointing_down_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc47", "1f447.png", ":point_down:", ":backhand_index_pointing_down:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc48\ud83c\udffb", "1f448-1f3fb.png", ":point_left_tone1:", ":backhand_index_pointing_left_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc48\ud83c\udffc", "1f448-1f3fc.png", ":point_left_tone2:", ":backhand_index_pointing_left_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc48\ud83c\udffd", "1f448-1f3fd.png", ":point_left_tone3:", ":backhand_index_pointing_left_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc48\ud83c\udffe", "1f448-1f3fe.png", ":point_left_tone4:", ":backhand_index_pointing_left_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc48\ud83c\udfff", "1f448-1f3ff.png", ":point_left_tone5:", ":backhand_index_pointing_left_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc48", "1f448.png", ":point_left:", ":backhand_index_pointing_left:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc49\ud83c\udffb", "1f449-1f3fb.png", ":point_right_tone1:", ":backhand_index_pointing_right_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc49\ud83c\udffc", "1f449-1f3fc.png", ":point_right_tone2:", ":backhand_index_pointing_right_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc49\ud83c\udffd", "1f449-1f3fd.png", ":point_right_tone3:", ":backhand_index_pointing_right_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc49\ud83c\udffe", "1f449-1f3fe.png", ":point_right_tone4:", ":backhand_index_pointing_right_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc49\ud83c\udfff", "1f449-1f3ff.png", ":point_right_tone5:", ":backhand_index_pointing_right_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc49", "1f449.png", ":point_right:", ":backhand_index_pointing_right:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4a\ud83c\udffb", "1f44a-1f3fb.png", ":fist_oncoming_tone1:", ":punch_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4a\ud83c\udffc", "1f44a-1f3fc.png", ":fist_oncoming_tone2:", ":punch_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4a\ud83c\udffd", "1f44a-1f3fd.png", ":fist_oncoming_tone3:", ":punch_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4a\ud83c\udffe", "1f44a-1f3fe.png", ":fist_oncoming_tone4:", ":punch_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4a\ud83c\udfff", "1f44a-1f3ff.png", ":fist_oncoming_tone5:", ":punch_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4a", "1f44a.png", ":fist_oncoming:", ":punch:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4b\ud83c\udffb", "1f44b-1f3fb.png", ":wave_tone1:", ":waving_hand_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4b\ud83c\udffc", "1f44b-1f3fc.png", ":wave_tone2:", ":waving_hand_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4b\ud83c\udffd", "1f44b-1f3fd.png", ":wave_tone3:", ":waving_hand_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4b\ud83c\udffe", "1f44b-1f3fe.png", ":wave_tone4:", ":waving_hand_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4b\ud83c\udfff", "1f44b-1f3ff.png", ":wave_tone5:", ":waving_hand_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4b", "1f44b.png", ":wave:", ":waving_hand:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4c\ud83c\udffb", "1f44c-1f3fb.png", ":ok_hand_tone1:", ":ok_hand_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4c\ud83c\udffc", "1f44c-1f3fc.png", ":ok_hand_tone2:", ":ok_hand_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4c\ud83c\udffd", "1f44c-1f3fd.png", ":ok_hand_tone3:", ":ok_hand_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4c\ud83c\udffe", "1f44c-1f3fe.png", ":ok_hand_tone4:", ":ok_hand_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4c\ud83c\udfff", "1f44c-1f3ff.png", ":ok_hand_tone5:", ":ok_hand_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4c", "1f44c.png", ":ok_hand:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4d\ud83c\udffb", "1f44d-1f3fb.png", ":+1_tone1:", ":thumbsup_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4d\ud83c\udffc", "1f44d-1f3fc.png", ":+1_tone2:", ":thumbsup_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4d\ud83c\udffd", "1f44d-1f3fd.png", ":+1_tone3:", ":thumbsup_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4d\ud83c\udffe", "1f44d-1f3fe.png", ":+1_tone4:", ":thumbsup_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4d\ud83c\udfff", "1f44d-1f3ff.png", ":+1_tone5:", ":thumbsup_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4d", "1f44d.png", ":+1:", ":thumbsup:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4e\ud83c\udffb", "1f44e-1f3fb.png", ":-1_tone1:", ":thumbsdown_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4e\ud83c\udffc", "1f44e-1f3fc.png", ":-1_tone2:", ":thumbsdown_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4e\ud83c\udffd", "1f44e-1f3fd.png", ":-1_tone3:", ":thumbsdown_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4e\ud83c\udffe", "1f44e-1f3fe.png", ":-1_tone4:", ":thumbsdown_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4e\ud83c\udfff", "1f44e-1f3ff.png", ":-1_tone5:", ":thumbsdown_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4e", "1f44e.png", ":-1:", ":thumbsdown:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4f\ud83c\udffb", "1f44f-1f3fb.png", ":clap_tone1:", ":clapping_hands_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4f\ud83c\udffc", "1f44f-1f3fc.png", ":clap_tone2:", ":clapping_hands_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4f\ud83c\udffd", "1f44f-1f3fd.png", ":clap_tone3:", ":clapping_hands_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4f\ud83c\udffe", "1f44f-1f3fe.png", ":clap_tone4:", ":clapping_hands_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4f\ud83c\udfff", "1f44f-1f3ff.png", ":clap_tone5:", ":clapping_hands_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4f", "1f44f.png", ":clap:", ":clapping_hands:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc50\ud83c\udffb", "1f450-1f3fb.png", ":open_hands_tone1:", ":open_hands_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc50\ud83c\udffc", "1f450-1f3fc.png", ":open_hands_tone2:", ":open_hands_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc50\ud83c\udffd", "1f450-1f3fd.png", ":open_hands_tone3:", ":open_hands_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc50\ud83c\udffe", "1f450-1f3fe.png", ":open_hands_tone4:", ":open_hands_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc50\ud83c\udfff", "1f450-1f3ff.png", ":open_hands_tone5:", ":open_hands_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc50", "1f450.png", ":open_hands:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc51", "1f451.png", ":crown:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc52", "1f452.png", ":womans_hat:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc53", "1f453.png", ":eyeglasses:", ":glasses:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc54", "1f454.png", ":necktie:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc55", "1f455.png", ":shirt:", ":t_shirt:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc56", "1f456.png", ":jeans:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc57", "1f457.png", ":dress:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc58", "1f458.png", ":kimono:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc59", "1f459.png", ":bikini:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc5a", "1f45a.png", ":womans_clothes:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc5b", "1f45b.png", ":purse:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc5c", "1f45c.png", ":handbag:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc5d", "1f45d.png", ":pouch:", ":clutch_bag:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc5e", "1f45e.png", ":mans_shoe:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc5f", "1f45f.png", ":athletic_shoe:", ":running_shoe:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc60", "1f460.png", ":high_heel:", ":high_heeled_shoe:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc61", "1f461.png", ":sandal:", ":womans_sandal:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc62", "1f462.png", ":boot:", ":womans_boot:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc63", "1f463.png", ":footprints:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc64", "1f464.png", ":bust_in_silhouette:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc65", "1f465.png", ":busts_in_silhouette:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc66\ud83c\udffb", "1f466-1f3fb.png", ":boy_tone1:", ":boy_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc66\ud83c\udffc", "1f466-1f3fc.png", ":boy_tone2:", ":boy_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc66\ud83c\udffd", "1f466-1f3fd.png", ":boy_tone3:", ":boy_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc66\ud83c\udffe", "1f466-1f3fe.png", ":boy_tone4:", ":boy_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc66\ud83c\udfff", "1f466-1f3ff.png", ":boy_tone5:", ":boy_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc66", "1f466.png", ":boy:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc67\ud83c\udffb", "1f467-1f3fb.png", ":girl_tone1:", ":girl_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc67\ud83c\udffc", "1f467-1f3fc.png", ":girl_tone2:", ":girl_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc67\ud83c\udffd", "1f467-1f3fd.png", ":girl_tone3:", ":girl_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc67\ud83c\udffe", "1f467-1f3fe.png", ":girl_tone4:", ":girl_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc67\ud83c\udfff", "1f467-1f3ff.png", ":girl_tone5:", ":girl_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc67", "1f467.png", ":girl:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\ud83c\udf3e", "1f468-1f3fb-200d-1f33e.png", ":man_farmer_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\ud83c\udf73", "1f468-1f3fb-200d-1f373.png", ":man_cook_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\ud83c\udf7c", "1f468-1f3fb-200d-1f37c.png", ":man_feeding_baby_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\ud83c\udf84", "1f468-1f3fb-200d-1f384.png", null, null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\ud83c\udf93", "1f468-1f3fb-200d-1f393.png", ":man_student_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\ud83c\udfa4", "1f468-1f3fb-200d-1f3a4.png", ":man_singer_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\ud83c\udfa8", "1f468-1f3fb-200d-1f3a8.png", ":man_artist_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\ud83c\udfeb", "1f468-1f3fb-200d-1f3eb.png", ":man_teacher_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\ud83c\udfed", "1f468-1f3fb-200d-1f3ed.png", ":man_factory_worker_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\ud83d\udcbb", "1f468-1f3fb-200d-1f4bb.png", ":man_technologist_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\ud83d\udcbc", "1f468-1f3fb-200d-1f4bc.png", ":man_office_worker_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\ud83d\udd27", "1f468-1f3fb-200d-1f527.png", ":man_mechanic_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\ud83d\udd2c", "1f468-1f3fb-200d-1f52c.png", ":man_scientist_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\ud83d\ude80", "1f468-1f3fb-200d-1f680.png", ":man_astronaut_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\ud83d\ude92", "1f468-1f3fb-200d-1f692.png", ":man_firefighter_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udffc", "1f468-1f3fb-200d-1f91d-200d-1f468-1f3fc.png", ":men_holding_hands_light_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udffd", "1f468-1f3fb-200d-1f91d-200d-1f468-1f3fd.png", ":men_holding_hands_light_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udffe", "1f468-1f3fb-200d-1f91d-200d-1f468-1f3fe.png", ":men_holding_hands_light_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udfff", "1f468-1f3fb-200d-1f91d-200d-1f468-1f3ff.png", ":men_holding_hands_light_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\ud83e\uddaf", "1f468-1f3fb-200d-1f9af.png", ":man_with_white_cane_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\ud83e\uddb0", "1f468-1f3fb-200d-1f9b0.png", ":man_light_skin_tone_red_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\ud83e\uddb1", "1f468-1f3fb-200d-1f9b1.png", ":man_light_skin_tone_curly_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\ud83e\uddb2", "1f468-1f3fb-200d-1f9b2.png", ":man_light_skin_tone_bald:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\ud83e\uddb3", "1f468-1f3fb-200d-1f9b3.png", ":man_light_skin_tone_white_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\ud83e\uddbc", "1f468-1f3fb-200d-1f9bc.png", ":man_in_motorized_wheelchair_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\ud83e\uddbd", "1f468-1f3fb-200d-1f9bd.png", ":man_in_manual_wheelchair_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\u2695\ufe0f", "1f468-1f3fb-200d-2695-fe0f.png", ":man_health_worker_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\u2696\ufe0f", "1f468-1f3fb-200d-2696-fe0f.png", ":man_judge_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\u2708\ufe0f", "1f468-1f3fb-200d-2708-fe0f.png", ":man_pilot_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffb", "1f468-1f3fb-200d-2764-fe0f-200d-1f468-1f3fb.png", ":couple_with_heart_man_man_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffc", "1f468-1f3fb-200d-2764-fe0f-200d-1f468-1f3fc.png", ":couple_with_heart_man_man_light_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffd", "1f468-1f3fb-200d-2764-fe0f-200d-1f468-1f3fd.png", ":couple_with_heart_man_man_light_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffe", "1f468-1f3fb-200d-2764-fe0f-200d-1f468-1f3fe.png", ":couple_with_heart_man_man_light_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udfff", "1f468-1f3fb-200d-2764-fe0f-200d-1f468-1f3ff.png", ":couple_with_heart_man_man_light_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffb", "1f468-1f3fb-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fb.png", ":kiss_man_man_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffc", "1f468-1f3fb-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fc.png", ":kiss_man_man_light_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffd", "1f468-1f3fb-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fd.png", ":kiss_man_man_light_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffe", "1f468-1f3fb-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fe.png", ":kiss_man_man_light_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udfff", "1f468-1f3fb-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3ff.png", ":kiss_man_man_light_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb", "1f468-1f3fb.png", ":man_tone1:", ":man_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\ud83c\udf3e", "1f468-1f3fc-200d-1f33e.png", ":man_farmer_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\ud83c\udf73", "1f468-1f3fc-200d-1f373.png", ":man_cook_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\ud83c\udf7c", "1f468-1f3fc-200d-1f37c.png", ":man_feeding_baby_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\ud83c\udf84", "1f468-1f3fc-200d-1f384.png", null, null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\ud83c\udf93", "1f468-1f3fc-200d-1f393.png", ":man_student_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\ud83c\udfa4", "1f468-1f3fc-200d-1f3a4.png", ":man_singer_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\ud83c\udfa8", "1f468-1f3fc-200d-1f3a8.png", ":man_artist_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\ud83c\udfeb", "1f468-1f3fc-200d-1f3eb.png", ":man_teacher_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\ud83c\udfed", "1f468-1f3fc-200d-1f3ed.png", ":man_factory_worker_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\ud83d\udcbb", "1f468-1f3fc-200d-1f4bb.png", ":man_technologist_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\ud83d\udcbc", "1f468-1f3fc-200d-1f4bc.png", ":man_office_worker_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\ud83d\udd27", "1f468-1f3fc-200d-1f527.png", ":man_mechanic_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\ud83d\udd2c", "1f468-1f3fc-200d-1f52c.png", ":man_scientist_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\ud83d\ude80", "1f468-1f3fc-200d-1f680.png", ":man_astronaut_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\ud83d\ude92", "1f468-1f3fc-200d-1f692.png", ":man_firefighter_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udffb", "1f468-1f3fc-200d-1f91d-200d-1f468-1f3fb.png", ":men_holding_hands_medium_light_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udffd", "1f468-1f3fc-200d-1f91d-200d-1f468-1f3fd.png", ":men_holding_hands_medium_light_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udffe", "1f468-1f3fc-200d-1f91d-200d-1f468-1f3fe.png", ":men_holding_hands_medium_light_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udfff", "1f468-1f3fc-200d-1f91d-200d-1f468-1f3ff.png", ":men_holding_hands_medium_light_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\ud83e\uddaf", "1f468-1f3fc-200d-1f9af.png", ":man_with_white_cane_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\ud83e\uddb0", "1f468-1f3fc-200d-1f9b0.png", ":man_medium_light_skin_tone_red_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\ud83e\uddb1", "1f468-1f3fc-200d-1f9b1.png", ":man_medium_light_skin_tone_curly_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\ud83e\uddb2", "1f468-1f3fc-200d-1f9b2.png", ":man_medium_light_skin_tone_bald:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\ud83e\uddb3", "1f468-1f3fc-200d-1f9b3.png", ":man_medium_light_skin_tone_white_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\ud83e\uddbc", "1f468-1f3fc-200d-1f9bc.png", ":man_in_motorized_wheelchair_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\ud83e\uddbd", "1f468-1f3fc-200d-1f9bd.png", ":man_in_manual_wheelchair_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\u2695\ufe0f", "1f468-1f3fc-200d-2695-fe0f.png", ":man_health_worker_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\u2696\ufe0f", "1f468-1f3fc-200d-2696-fe0f.png", ":man_judge_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\u2708\ufe0f", "1f468-1f3fc-200d-2708-fe0f.png", ":man_pilot_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffb", "1f468-1f3fc-200d-2764-fe0f-200d-1f468-1f3fb.png", ":couple_with_heart_man_man_medium_light_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffc", "1f468-1f3fc-200d-2764-fe0f-200d-1f468-1f3fc.png", ":couple_with_heart_man_man_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffd", "1f468-1f3fc-200d-2764-fe0f-200d-1f468-1f3fd.png", ":couple_with_heart_man_man_medium_light_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffe", "1f468-1f3fc-200d-2764-fe0f-200d-1f468-1f3fe.png", ":couple_with_heart_man_man_medium_light_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udfff", "1f468-1f3fc-200d-2764-fe0f-200d-1f468-1f3ff.png", ":couple_with_heart_man_man_medium_light_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffb", "1f468-1f3fc-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fb.png", ":kiss_man_man_medium_light_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffc", "1f468-1f3fc-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fc.png", ":kiss_man_man_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffd", "1f468-1f3fc-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fd.png", ":kiss_man_man_medium_light_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffe", "1f468-1f3fc-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fe.png", ":kiss_man_man_medium_light_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udfff", "1f468-1f3fc-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3ff.png", ":kiss_man_man_medium_light_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc", "1f468-1f3fc.png", ":man_tone2:", ":man_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\ud83c\udf3e", "1f468-1f3fd-200d-1f33e.png", ":man_farmer_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\ud83c\udf73", "1f468-1f3fd-200d-1f373.png", ":man_cook_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\ud83c\udf7c", "1f468-1f3fd-200d-1f37c.png", ":man_feeding_baby_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\ud83c\udf84", "1f468-1f3fd-200d-1f384.png", null, null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\ud83c\udf93", "1f468-1f3fd-200d-1f393.png", ":man_student_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\ud83c\udfa4", "1f468-1f3fd-200d-1f3a4.png", ":man_singer_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\ud83c\udfa8", "1f468-1f3fd-200d-1f3a8.png", ":man_artist_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\ud83c\udfeb", "1f468-1f3fd-200d-1f3eb.png", ":man_teacher_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\ud83c\udfed", "1f468-1f3fd-200d-1f3ed.png", ":man_factory_worker_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\ud83d\udcbb", "1f468-1f3fd-200d-1f4bb.png", ":man_technologist_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\ud83d\udcbc", "1f468-1f3fd-200d-1f4bc.png", ":man_office_worker_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\ud83d\udd27", "1f468-1f3fd-200d-1f527.png", ":man_mechanic_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\ud83d\udd2c", "1f468-1f3fd-200d-1f52c.png", ":man_scientist_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\ud83d\ude80", "1f468-1f3fd-200d-1f680.png", ":man_astronaut_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\ud83d\ude92", "1f468-1f3fd-200d-1f692.png", ":man_firefighter_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udffb", "1f468-1f3fd-200d-1f91d-200d-1f468-1f3fb.png", ":men_holding_hands_medium_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udffc", "1f468-1f3fd-200d-1f91d-200d-1f468-1f3fc.png", ":men_holding_hands_medium_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udffe", "1f468-1f3fd-200d-1f91d-200d-1f468-1f3fe.png", ":men_holding_hands_medium_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udfff", "1f468-1f3fd-200d-1f91d-200d-1f468-1f3ff.png", ":men_holding_hands_medium_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\ud83e\uddaf", "1f468-1f3fd-200d-1f9af.png", ":man_with_white_cane_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\ud83e\uddb0", "1f468-1f3fd-200d-1f9b0.png", ":man_medium_skin_tone_red_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\ud83e\uddb1", "1f468-1f3fd-200d-1f9b1.png", ":man_medium_skin_tone_curly_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\ud83e\uddb2", "1f468-1f3fd-200d-1f9b2.png", ":man_medium_skin_tone_bald:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\ud83e\uddb3", "1f468-1f3fd-200d-1f9b3.png", ":man_medium_skin_tone_white_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\ud83e\uddbc", "1f468-1f3fd-200d-1f9bc.png", ":man_in_motorized_wheelchair_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\ud83e\uddbd", "1f468-1f3fd-200d-1f9bd.png", ":man_in_manual_wheelchair_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\u2695\ufe0f", "1f468-1f3fd-200d-2695-fe0f.png", ":man_health_worker_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\u2696\ufe0f", "1f468-1f3fd-200d-2696-fe0f.png", ":man_judge_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\u2708\ufe0f", "1f468-1f3fd-200d-2708-fe0f.png", ":man_pilot_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffb", "1f468-1f3fd-200d-2764-fe0f-200d-1f468-1f3fb.png", ":couple_with_heart_man_man_medium_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffc", "1f468-1f3fd-200d-2764-fe0f-200d-1f468-1f3fc.png", ":couple_with_heart_man_man_medium_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffd", "1f468-1f3fd-200d-2764-fe0f-200d-1f468-1f3fd.png", ":couple_with_heart_man_man_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffe", "1f468-1f3fd-200d-2764-fe0f-200d-1f468-1f3fe.png", ":couple_with_heart_man_man_medium_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udfff", "1f468-1f3fd-200d-2764-fe0f-200d-1f468-1f3ff.png", ":couple_with_heart_man_man_medium_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffb", "1f468-1f3fd-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fb.png", ":kiss_man_man_medium_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffc", "1f468-1f3fd-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fc.png", ":kiss_man_man_medium_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffd", "1f468-1f3fd-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fd.png", ":kiss_man_man_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffe", "1f468-1f3fd-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fe.png", ":kiss_man_man_medium_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udfff", "1f468-1f3fd-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3ff.png", ":kiss_man_man_medium_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd", "1f468-1f3fd.png", ":man_tone3:", ":man_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\ud83c\udf3e", "1f468-1f3fe-200d-1f33e.png", ":man_farmer_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\ud83c\udf73", "1f468-1f3fe-200d-1f373.png", ":man_cook_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\ud83c\udf7c", "1f468-1f3fe-200d-1f37c.png", ":man_feeding_baby_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\ud83c\udf84", "1f468-1f3fe-200d-1f384.png", null, null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\ud83c\udf93", "1f468-1f3fe-200d-1f393.png", ":man_student_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\ud83c\udfa4", "1f468-1f3fe-200d-1f3a4.png", ":man_singer_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\ud83c\udfa8", "1f468-1f3fe-200d-1f3a8.png", ":man_artist_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\ud83c\udfeb", "1f468-1f3fe-200d-1f3eb.png", ":man_teacher_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\ud83c\udfed", "1f468-1f3fe-200d-1f3ed.png", ":man_factory_worker_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\ud83d\udcbb", "1f468-1f3fe-200d-1f4bb.png", ":man_technologist_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\ud83d\udcbc", "1f468-1f3fe-200d-1f4bc.png", ":man_office_worker_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\ud83d\udd27", "1f468-1f3fe-200d-1f527.png", ":man_mechanic_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\ud83d\udd2c", "1f468-1f3fe-200d-1f52c.png", ":man_scientist_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\ud83d\ude80", "1f468-1f3fe-200d-1f680.png", ":man_astronaut_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\ud83d\ude92", "1f468-1f3fe-200d-1f692.png", ":man_firefighter_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udffb", "1f468-1f3fe-200d-1f91d-200d-1f468-1f3fb.png", ":men_holding_hands_medium_dark_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udffc", "1f468-1f3fe-200d-1f91d-200d-1f468-1f3fc.png", ":men_holding_hands_medium_dark_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udffd", "1f468-1f3fe-200d-1f91d-200d-1f468-1f3fd.png", ":men_holding_hands_medium_dark_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udfff", "1f468-1f3fe-200d-1f91d-200d-1f468-1f3ff.png", ":men_holding_hands_medium_dark_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\ud83e\uddaf", "1f468-1f3fe-200d-1f9af.png", ":man_with_white_cane_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\ud83e\uddb0", "1f468-1f3fe-200d-1f9b0.png", ":man_medium_dark_skin_tone_red_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\ud83e\uddb1", "1f468-1f3fe-200d-1f9b1.png", ":man_medium_dark_skin_tone_curly_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\ud83e\uddb2", "1f468-1f3fe-200d-1f9b2.png", ":man_medium_dark_skin_tone_bald:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\ud83e\uddb3", "1f468-1f3fe-200d-1f9b3.png", ":man_medium_dark_skin_tone_white_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\ud83e\uddbc", "1f468-1f3fe-200d-1f9bc.png", ":man_in_motorized_wheelchair_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\ud83e\uddbd", "1f468-1f3fe-200d-1f9bd.png", ":man_in_manual_wheelchair_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\u2695\ufe0f", "1f468-1f3fe-200d-2695-fe0f.png", ":man_health_worker_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\u2696\ufe0f", "1f468-1f3fe-200d-2696-fe0f.png", ":man_judge_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\u2708\ufe0f", "1f468-1f3fe-200d-2708-fe0f.png", ":man_pilot_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffb", "1f468-1f3fe-200d-2764-fe0f-200d-1f468-1f3fb.png", ":couple_with_heart_man_man_medium_dark_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffc", "1f468-1f3fe-200d-2764-fe0f-200d-1f468-1f3fc.png", ":couple_with_heart_man_man_medium_dark_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffd", "1f468-1f3fe-200d-2764-fe0f-200d-1f468-1f3fd.png", ":couple_with_heart_man_man_medium_dark_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffe", "1f468-1f3fe-200d-2764-fe0f-200d-1f468-1f3fe.png", ":couple_with_heart_man_man_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udfff", "1f468-1f3fe-200d-2764-fe0f-200d-1f468-1f3ff.png", ":couple_with_heart_man_man_medium_dark_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffb", "1f468-1f3fe-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fb.png", ":kiss_man_man_medium_dark_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffc", "1f468-1f3fe-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fc.png", ":kiss_man_man_medium_dark_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffd", "1f468-1f3fe-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fd.png", ":kiss_man_man_medium_dark_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffe", "1f468-1f3fe-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fe.png", ":kiss_man_man_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udfff", "1f468-1f3fe-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3ff.png", ":kiss_man_man_medium_dark_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe", "1f468-1f3fe.png", ":man_tone4:", ":man_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\ud83c\udf3e", "1f468-1f3ff-200d-1f33e.png", ":man_farmer_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\ud83c\udf73", "1f468-1f3ff-200d-1f373.png", ":man_cook_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\ud83c\udf7c", "1f468-1f3ff-200d-1f37c.png", ":man_feeding_baby_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\ud83c\udf84", "1f468-1f3ff-200d-1f384.png", null, null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\ud83c\udf93", "1f468-1f3ff-200d-1f393.png", ":man_student_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\ud83c\udfa4", "1f468-1f3ff-200d-1f3a4.png", ":man_singer_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\ud83c\udfa8", "1f468-1f3ff-200d-1f3a8.png", ":man_artist_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\ud83c\udfeb", "1f468-1f3ff-200d-1f3eb.png", ":man_teacher_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\ud83c\udfed", "1f468-1f3ff-200d-1f3ed.png", ":man_factory_worker_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\ud83d\udcbb", "1f468-1f3ff-200d-1f4bb.png", ":man_technologist_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\ud83d\udcbc", "1f468-1f3ff-200d-1f4bc.png", ":man_office_worker_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\ud83d\udd27", "1f468-1f3ff-200d-1f527.png", ":man_mechanic_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\ud83d\udd2c", "1f468-1f3ff-200d-1f52c.png", ":man_scientist_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\ud83d\ude80", "1f468-1f3ff-200d-1f680.png", ":man_astronaut_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\ud83d\ude92", "1f468-1f3ff-200d-1f692.png", ":man_firefighter_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udffb", "1f468-1f3ff-200d-1f91d-200d-1f468-1f3fb.png", ":men_holding_hands_dark_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udffc", "1f468-1f3ff-200d-1f91d-200d-1f468-1f3fc.png", ":men_holding_hands_dark_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udffd", "1f468-1f3ff-200d-1f91d-200d-1f468-1f3fd.png", ":men_holding_hands_dark_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udffe", "1f468-1f3ff-200d-1f91d-200d-1f468-1f3fe.png", ":men_holding_hands_dark_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\ud83e\uddaf", "1f468-1f3ff-200d-1f9af.png", ":man_with_white_cane_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\ud83e\uddb0", "1f468-1f3ff-200d-1f9b0.png", ":man_dark_skin_tone_red_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\ud83e\uddb1", "1f468-1f3ff-200d-1f9b1.png", ":man_dark_skin_tone_curly_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\ud83e\uddb2", "1f468-1f3ff-200d-1f9b2.png", ":man_dark_skin_tone_bald:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\ud83e\uddb3", "1f468-1f3ff-200d-1f9b3.png", ":man_dark_skin_tone_white_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\ud83e\uddbc", "1f468-1f3ff-200d-1f9bc.png", ":man_in_motorized_wheelchair_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\ud83e\uddbd", "1f468-1f3ff-200d-1f9bd.png", ":man_in_manual_wheelchair_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\u2695\ufe0f", "1f468-1f3ff-200d-2695-fe0f.png", ":man_health_worker_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\u2696\ufe0f", "1f468-1f3ff-200d-2696-fe0f.png", ":man_judge_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\u2708\ufe0f", "1f468-1f3ff-200d-2708-fe0f.png", ":man_pilot_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffb", "1f468-1f3ff-200d-2764-fe0f-200d-1f468-1f3fb.png", ":couple_with_heart_man_man_dark_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffc", "1f468-1f3ff-200d-2764-fe0f-200d-1f468-1f3fc.png", ":couple_with_heart_man_man_dark_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffd", "1f468-1f3ff-200d-2764-fe0f-200d-1f468-1f3fd.png", ":couple_with_heart_man_man_dark_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffe", "1f468-1f3ff-200d-2764-fe0f-200d-1f468-1f3fe.png", ":couple_with_heart_man_man_dark_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udfff", "1f468-1f3ff-200d-2764-fe0f-200d-1f468-1f3ff.png", ":couple_with_heart_man_man_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffb", "1f468-1f3ff-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fb.png", ":kiss_man_man_dark_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffc", "1f468-1f3ff-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fc.png", ":kiss_man_man_dark_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffd", "1f468-1f3ff-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fd.png", ":kiss_man_man_dark_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffe", "1f468-1f3ff-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fe.png", ":kiss_man_man_dark_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udfff", "1f468-1f3ff-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3ff.png", ":kiss_man_man_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff", "1f468-1f3ff.png", ":man_tone5:", ":man_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\ud83c\udf3e", "1f468-200d-1f33e.png", ":man_farmer:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\ud83c\udf73", "1f468-200d-1f373.png", ":man_cook:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\ud83c\udf7c", "1f468-200d-1f37c.png", ":man_feeding_baby:", null, "People & Body", "13.0");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\ud83c\udf84", "1f468-200d-1f384.png", null, null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\ud83c\udf93", "1f468-200d-1f393.png", ":man_student:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\ud83c\udfa4", "1f468-200d-1f3a4.png", ":man_singer:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\ud83c\udfa8", "1f468-200d-1f3a8.png", ":man_artist:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\ud83c\udfeb", "1f468-200d-1f3eb.png", ":man_teacher:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\ud83c\udfed", "1f468-200d-1f3ed.png", ":man_factory_worker:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\ud83d\udc66\u200d\ud83d\udc66", "1f468-200d-1f466-200d-1f466.png", ":family_man_boy_boy:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\ud83d\udc66", "1f468-200d-1f466.png", ":family_man_boy:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\ud83d\udc67\u200d\ud83d\udc66", "1f468-200d-1f467-200d-1f466.png", ":family_man_girl_boy:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\ud83d\udc67\u200d\ud83d\udc67", "1f468-200d-1f467-200d-1f467.png", ":family_man_girl_girl:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\ud83d\udc67", "1f468-200d-1f467.png", ":family_man_girl:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\ud83d\udc68\u200d\ud83d\udc66\u200d\ud83d\udc66", "1f468-200d-1f468-200d-1f466-200d-1f466.png", ":family_man_man_boy_boy:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\ud83d\udc68\u200d\ud83d\udc66", "1f468-200d-1f468-200d-1f466.png", ":family_man_man_boy:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\ud83d\udc68\u200d\ud83d\udc67\u200d\ud83d\udc66", "1f468-200d-1f468-200d-1f467-200d-1f466.png", ":family_man_man_girl_boy:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\ud83d\udc68\u200d\ud83d\udc67\u200d\ud83d\udc67", "1f468-200d-1f468-200d-1f467-200d-1f467.png", ":family_man_man_girl_girl:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\ud83d\udc68\u200d\ud83d\udc67", "1f468-200d-1f468-200d-1f467.png", ":family_man_man_girl:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\ud83d\udc69\u200d\ud83d\udc66\u200d\ud83d\udc66", "1f468-200d-1f469-200d-1f466-200d-1f466.png", ":family_man_woman_boy_boy:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\ud83d\udc69\u200d\ud83d\udc66", "1f468-200d-1f469-200d-1f466.png", ":family_man_woman_boy:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\ud83d\udc69\u200d\ud83d\udc67\u200d\ud83d\udc66", "1f468-200d-1f469-200d-1f467-200d-1f466.png", ":family_man_woman_girl_boy:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\ud83d\udc69\u200d\ud83d\udc67\u200d\ud83d\udc67", "1f468-200d-1f469-200d-1f467-200d-1f467.png", ":family_man_woman_girl_girl:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\ud83d\udc69\u200d\ud83d\udc67", "1f468-200d-1f469-200d-1f467.png", ":family_man_woman_girl:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\ud83d\udcbb", "1f468-200d-1f4bb.png", ":man_technologist:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\ud83d\udcbc", "1f468-200d-1f4bc.png", ":man_office_worker:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\ud83d\udd27", "1f468-200d-1f527.png", ":man_mechanic:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\ud83d\udd2c", "1f468-200d-1f52c.png", ":man_scientist:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\ud83d\ude80", "1f468-200d-1f680.png", ":man_astronaut:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\ud83d\ude92", "1f468-200d-1f692.png", ":man_firefighter:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\ud83e\uddaf", "1f468-200d-1f9af.png", ":man_with_probing_cane:", ":man_with_white_cane:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\ud83e\uddb0", "1f468-200d-1f9b0.png", ":red_haired_man:", ":man_red_hair:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\ud83e\uddb1", "1f468-200d-1f9b1.png", ":curly_haired_man:", ":man_curly_hair:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\ud83e\uddb2", "1f468-200d-1f9b2.png", ":bald_man:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\ud83e\uddb3", "1f468-200d-1f9b3.png", ":white_haired_man:", ":man_white_hair:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\ud83e\uddbc", "1f468-200d-1f9bc.png", ":man_in_motorized_wheelchair:", null, "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\ud83e\uddbd", "1f468-200d-1f9bd.png", ":man_in_manual_wheelchair:", null, "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\u2695\ufe0f", "1f468-200d-2695-fe0f.png", ":man_health_worker:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\u2696\ufe0f", "1f468-200d-2696-fe0f.png", ":man_judge:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\u2708\ufe0f", "1f468-200d-2708-fe0f.png", ":man_pilot:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\u2764\ufe0f\u200d\ud83d\udc68", "1f468-200d-2764-fe0f-200d-1f468.png", ":couple_with_heart_man_man:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc68\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68", "1f468-200d-2764-fe0f-200d-1f48b-200d-1f468.png", ":couplekiss_man_man:", ":kiss_man_man:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc68", "1f468.png", ":man:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\ud83c\udf3e", "1f469-1f3fb-200d-1f33e.png", ":woman_farmer_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\ud83c\udf73", "1f469-1f3fb-200d-1f373.png", ":woman_cook_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\ud83c\udf7c", "1f469-1f3fb-200d-1f37c.png", ":woman_feeding_baby_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\ud83c\udf84", "1f469-1f3fb-200d-1f384.png", null, null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\ud83c\udf93", "1f469-1f3fb-200d-1f393.png", ":woman_student_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\ud83c\udfa4", "1f469-1f3fb-200d-1f3a4.png", ":woman_singer_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\ud83c\udfa8", "1f469-1f3fb-200d-1f3a8.png", ":woman_artist_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\ud83c\udfeb", "1f469-1f3fb-200d-1f3eb.png", ":woman_teacher_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\ud83c\udfed", "1f469-1f3fb-200d-1f3ed.png", ":woman_factory_worker_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\ud83d\udcbb", "1f469-1f3fb-200d-1f4bb.png", ":woman_technologist_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\ud83d\udcbc", "1f469-1f3fb-200d-1f4bc.png", ":woman_office_worker_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\ud83d\udd27", "1f469-1f3fb-200d-1f527.png", ":woman_mechanic_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\ud83d\udd2c", "1f469-1f3fb-200d-1f52c.png", ":woman_scientist_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\ud83d\ude80", "1f469-1f3fb-200d-1f680.png", ":woman_astronaut_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\ud83d\ude92", "1f469-1f3fb-200d-1f692.png", ":woman_firefighter_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udffc", "1f469-1f3fb-200d-1f91d-200d-1f468-1f3fc.png", ":woman_and_man_holding_hands_light_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udffd", "1f469-1f3fb-200d-1f91d-200d-1f468-1f3fd.png", ":woman_and_man_holding_hands_light_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udffe", "1f469-1f3fb-200d-1f91d-200d-1f468-1f3fe.png", ":woman_and_man_holding_hands_light_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udfff", "1f469-1f3fb-200d-1f91d-200d-1f468-1f3ff.png", ":woman_and_man_holding_hands_light_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\ud83e\udd1d\u200d\ud83d\udc69\ud83c\udffc", "1f469-1f3fb-200d-1f91d-200d-1f469-1f3fc.png", ":women_holding_hands_light_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\ud83e\udd1d\u200d\ud83d\udc69\ud83c\udffd", "1f469-1f3fb-200d-1f91d-200d-1f469-1f3fd.png", ":women_holding_hands_light_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\ud83e\udd1d\u200d\ud83d\udc69\ud83c\udffe", "1f469-1f3fb-200d-1f91d-200d-1f469-1f3fe.png", ":women_holding_hands_light_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\ud83e\udd1d\u200d\ud83d\udc69\ud83c\udfff", "1f469-1f3fb-200d-1f91d-200d-1f469-1f3ff.png", ":women_holding_hands_light_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\ud83e\uddaf", "1f469-1f3fb-200d-1f9af.png", ":woman_with_white_cane_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\ud83e\uddb0", "1f469-1f3fb-200d-1f9b0.png", ":woman_light_skin_tone_red_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\ud83e\uddb1", "1f469-1f3fb-200d-1f9b1.png", ":woman_light_skin_tone_curly_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\ud83e\uddb2", "1f469-1f3fb-200d-1f9b2.png", ":woman_light_skin_tone_bald:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\ud83e\uddb3", "1f469-1f3fb-200d-1f9b3.png", ":woman_light_skin_tone_white_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\ud83e\uddbc", "1f469-1f3fb-200d-1f9bc.png", ":woman_in_motorized_wheelchair_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\ud83e\uddbd", "1f469-1f3fb-200d-1f9bd.png", ":woman_in_manual_wheelchair_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\u2695\ufe0f", "1f469-1f3fb-200d-2695-fe0f.png", ":woman_health_worker_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\u2696\ufe0f", "1f469-1f3fb-200d-2696-fe0f.png", ":woman_judge_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\u2708\ufe0f", "1f469-1f3fb-200d-2708-fe0f.png", ":woman_pilot_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffb", "1f469-1f3fb-200d-2764-fe0f-200d-1f468-1f3fb.png", ":couple_with_heart_woman_man_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffc", "1f469-1f3fb-200d-2764-fe0f-200d-1f468-1f3fc.png", ":couple_with_heart_woman_man_light_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffd", "1f469-1f3fb-200d-2764-fe0f-200d-1f468-1f3fd.png", ":couple_with_heart_woman_man_light_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffe", "1f469-1f3fb-200d-2764-fe0f-200d-1f468-1f3fe.png", ":couple_with_heart_woman_man_light_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udfff", "1f469-1f3fb-200d-2764-fe0f-200d-1f468-1f3ff.png", ":couple_with_heart_woman_man_light_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc69\ud83c\udffb", "1f469-1f3fb-200d-2764-fe0f-200d-1f469-1f3fb.png", ":couple_with_heart_woman_woman_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc69\ud83c\udffc", "1f469-1f3fb-200d-2764-fe0f-200d-1f469-1f3fc.png", ":couple_with_heart_woman_woman_light_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc69\ud83c\udffd", "1f469-1f3fb-200d-2764-fe0f-200d-1f469-1f3fd.png", ":couple_with_heart_woman_woman_light_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc69\ud83c\udffe", "1f469-1f3fb-200d-2764-fe0f-200d-1f469-1f3fe.png", ":couple_with_heart_woman_woman_light_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc69\ud83c\udfff", "1f469-1f3fb-200d-2764-fe0f-200d-1f469-1f3ff.png", ":couple_with_heart_woman_woman_light_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffb", "1f469-1f3fb-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fb.png", ":kiss_woman_man_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffc", "1f469-1f3fb-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fc.png", ":kiss_woman_man_light_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffd", "1f469-1f3fb-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fd.png", ":kiss_woman_man_light_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffe", "1f469-1f3fb-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fe.png", ":kiss_woman_man_light_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udfff", "1f469-1f3fb-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3ff.png", ":kiss_woman_man_light_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc69\ud83c\udffb", "1f469-1f3fb-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fb.png", ":kiss_woman_woman_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc69\ud83c\udffc", "1f469-1f3fb-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fc.png", ":kiss_woman_woman_light_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc69\ud83c\udffd", "1f469-1f3fb-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fd.png", ":kiss_woman_woman_light_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc69\ud83c\udffe", "1f469-1f3fb-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fe.png", ":kiss_woman_woman_light_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc69\ud83c\udfff", "1f469-1f3fb-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3ff.png", ":kiss_woman_woman_light_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb", "1f469-1f3fb.png", ":woman_tone1:", ":woman_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\ud83c\udf3e", "1f469-1f3fc-200d-1f33e.png", ":woman_farmer_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\ud83c\udf73", "1f469-1f3fc-200d-1f373.png", ":woman_cook_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\ud83c\udf7c", "1f469-1f3fc-200d-1f37c.png", ":woman_feeding_baby_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\ud83c\udf84", "1f469-1f3fc-200d-1f384.png", null, null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\ud83c\udf93", "1f469-1f3fc-200d-1f393.png", ":woman_student_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\ud83c\udfa4", "1f469-1f3fc-200d-1f3a4.png", ":woman_singer_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\ud83c\udfa8", "1f469-1f3fc-200d-1f3a8.png", ":woman_artist_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\ud83c\udfeb", "1f469-1f3fc-200d-1f3eb.png", ":woman_teacher_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\ud83c\udfed", "1f469-1f3fc-200d-1f3ed.png", ":woman_factory_worker_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\ud83d\udcbb", "1f469-1f3fc-200d-1f4bb.png", ":woman_technologist_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\ud83d\udcbc", "1f469-1f3fc-200d-1f4bc.png", ":woman_office_worker_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\ud83d\udd27", "1f469-1f3fc-200d-1f527.png", ":woman_mechanic_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\ud83d\udd2c", "1f469-1f3fc-200d-1f52c.png", ":woman_scientist_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\ud83d\ude80", "1f469-1f3fc-200d-1f680.png", ":woman_astronaut_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\ud83d\ude92", "1f469-1f3fc-200d-1f692.png", ":woman_firefighter_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udffb", "1f469-1f3fc-200d-1f91d-200d-1f468-1f3fb.png", ":woman_and_man_holding_hands_medium_light_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udffd", "1f469-1f3fc-200d-1f91d-200d-1f468-1f3fd.png", ":woman_and_man_holding_hands_medium_light_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udffe", "1f469-1f3fc-200d-1f91d-200d-1f468-1f3fe.png", ":woman_and_man_holding_hands_medium_light_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udfff", "1f469-1f3fc-200d-1f91d-200d-1f468-1f3ff.png", ":woman_and_man_holding_hands_medium_light_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\ud83e\udd1d\u200d\ud83d\udc69\ud83c\udffb", "1f469-1f3fc-200d-1f91d-200d-1f469-1f3fb.png", ":women_holding_hands_medium_light_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\ud83e\udd1d\u200d\ud83d\udc69\ud83c\udffd", "1f469-1f3fc-200d-1f91d-200d-1f469-1f3fd.png", ":women_holding_hands_medium_light_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\ud83e\udd1d\u200d\ud83d\udc69\ud83c\udffe", "1f469-1f3fc-200d-1f91d-200d-1f469-1f3fe.png", ":women_holding_hands_medium_light_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\ud83e\udd1d\u200d\ud83d\udc69\ud83c\udfff", "1f469-1f3fc-200d-1f91d-200d-1f469-1f3ff.png", ":women_holding_hands_medium_light_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\ud83e\uddaf", "1f469-1f3fc-200d-1f9af.png", ":woman_with_white_cane_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\ud83e\uddb0", "1f469-1f3fc-200d-1f9b0.png", ":woman_medium_light_skin_tone_red_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\ud83e\uddb1", "1f469-1f3fc-200d-1f9b1.png", ":woman_medium_light_skin_tone_curly_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\ud83e\uddb2", "1f469-1f3fc-200d-1f9b2.png", ":woman_medium_light_skin_tone_bald:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\ud83e\uddb3", "1f469-1f3fc-200d-1f9b3.png", ":woman_medium_light_skin_tone_white_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\ud83e\uddbc", "1f469-1f3fc-200d-1f9bc.png", ":woman_in_motorized_wheelchair_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\ud83e\uddbd", "1f469-1f3fc-200d-1f9bd.png", ":woman_in_manual_wheelchair_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\u2695\ufe0f", "1f469-1f3fc-200d-2695-fe0f.png", ":woman_health_worker_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\u2696\ufe0f", "1f469-1f3fc-200d-2696-fe0f.png", ":woman_judge_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\u2708\ufe0f", "1f469-1f3fc-200d-2708-fe0f.png", ":woman_pilot_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffb", "1f469-1f3fc-200d-2764-fe0f-200d-1f468-1f3fb.png", ":couple_with_heart_woman_man_medium_light_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffc", "1f469-1f3fc-200d-2764-fe0f-200d-1f468-1f3fc.png", ":couple_with_heart_woman_man_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffd", "1f469-1f3fc-200d-2764-fe0f-200d-1f468-1f3fd.png", ":couple_with_heart_woman_man_medium_light_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffe", "1f469-1f3fc-200d-2764-fe0f-200d-1f468-1f3fe.png", ":couple_with_heart_woman_man_medium_light_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udfff", "1f469-1f3fc-200d-2764-fe0f-200d-1f468-1f3ff.png", ":couple_with_heart_woman_man_medium_light_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc69\ud83c\udffb", "1f469-1f3fc-200d-2764-fe0f-200d-1f469-1f3fb.png", ":couple_with_heart_woman_woman_medium_light_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc69\ud83c\udffc", "1f469-1f3fc-200d-2764-fe0f-200d-1f469-1f3fc.png", ":couple_with_heart_woman_woman_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc69\ud83c\udffd", "1f469-1f3fc-200d-2764-fe0f-200d-1f469-1f3fd.png", ":couple_with_heart_woman_woman_medium_light_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc69\ud83c\udffe", "1f469-1f3fc-200d-2764-fe0f-200d-1f469-1f3fe.png", ":couple_with_heart_woman_woman_medium_light_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc69\ud83c\udfff", "1f469-1f3fc-200d-2764-fe0f-200d-1f469-1f3ff.png", ":couple_with_heart_woman_woman_medium_light_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffb", "1f469-1f3fc-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fb.png", ":kiss_woman_man_medium_light_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffc", "1f469-1f3fc-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fc.png", ":kiss_woman_man_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffd", "1f469-1f3fc-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fd.png", ":kiss_woman_man_medium_light_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffe", "1f469-1f3fc-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fe.png", ":kiss_woman_man_medium_light_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udfff", "1f469-1f3fc-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3ff.png", ":kiss_woman_man_medium_light_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc69\ud83c\udffb", "1f469-1f3fc-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fb.png", ":kiss_woman_woman_medium_light_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc69\ud83c\udffc", "1f469-1f3fc-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fc.png", ":kiss_woman_woman_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc69\ud83c\udffd", "1f469-1f3fc-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fd.png", ":kiss_woman_woman_medium_light_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc69\ud83c\udffe", "1f469-1f3fc-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fe.png", ":kiss_woman_woman_medium_light_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc69\ud83c\udfff", "1f469-1f3fc-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3ff.png", ":kiss_woman_woman_medium_light_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc", "1f469-1f3fc.png", ":woman_tone2:", ":woman_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\ud83c\udf3e", "1f469-1f3fd-200d-1f33e.png", ":woman_farmer_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\ud83c\udf73", "1f469-1f3fd-200d-1f373.png", ":woman_cook_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\ud83c\udf7c", "1f469-1f3fd-200d-1f37c.png", ":woman_feeding_baby_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\ud83c\udf84", "1f469-1f3fd-200d-1f384.png", null, null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\ud83c\udf93", "1f469-1f3fd-200d-1f393.png", ":woman_student_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\ud83c\udfa4", "1f469-1f3fd-200d-1f3a4.png", ":woman_singer_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\ud83c\udfa8", "1f469-1f3fd-200d-1f3a8.png", ":woman_artist_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\ud83c\udfeb", "1f469-1f3fd-200d-1f3eb.png", ":woman_teacher_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\ud83c\udfed", "1f469-1f3fd-200d-1f3ed.png", ":woman_factory_worker_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\ud83d\udcbb", "1f469-1f3fd-200d-1f4bb.png", ":woman_technologist_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\ud83d\udcbc", "1f469-1f3fd-200d-1f4bc.png", ":woman_office_worker_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\ud83d\udd27", "1f469-1f3fd-200d-1f527.png", ":woman_mechanic_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\ud83d\udd2c", "1f469-1f3fd-200d-1f52c.png", ":woman_scientist_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\ud83d\ude80", "1f469-1f3fd-200d-1f680.png", ":woman_astronaut_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\ud83d\ude92", "1f469-1f3fd-200d-1f692.png", ":woman_firefighter_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udffb", "1f469-1f3fd-200d-1f91d-200d-1f468-1f3fb.png", ":woman_and_man_holding_hands_medium_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udffc", "1f469-1f3fd-200d-1f91d-200d-1f468-1f3fc.png", ":woman_and_man_holding_hands_medium_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udffe", "1f469-1f3fd-200d-1f91d-200d-1f468-1f3fe.png", ":woman_and_man_holding_hands_medium_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udfff", "1f469-1f3fd-200d-1f91d-200d-1f468-1f3ff.png", ":woman_and_man_holding_hands_medium_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\ud83e\udd1d\u200d\ud83d\udc69\ud83c\udffb", "1f469-1f3fd-200d-1f91d-200d-1f469-1f3fb.png", ":women_holding_hands_medium_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\ud83e\udd1d\u200d\ud83d\udc69\ud83c\udffc", "1f469-1f3fd-200d-1f91d-200d-1f469-1f3fc.png", ":women_holding_hands_medium_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\ud83e\udd1d\u200d\ud83d\udc69\ud83c\udffe", "1f469-1f3fd-200d-1f91d-200d-1f469-1f3fe.png", ":women_holding_hands_medium_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\ud83e\udd1d\u200d\ud83d\udc69\ud83c\udfff", "1f469-1f3fd-200d-1f91d-200d-1f469-1f3ff.png", ":women_holding_hands_medium_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\ud83e\uddaf", "1f469-1f3fd-200d-1f9af.png", ":woman_with_white_cane_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\ud83e\uddb0", "1f469-1f3fd-200d-1f9b0.png", ":woman_medium_skin_tone_red_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\ud83e\uddb1", "1f469-1f3fd-200d-1f9b1.png", ":woman_medium_skin_tone_curly_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\ud83e\uddb2", "1f469-1f3fd-200d-1f9b2.png", ":woman_medium_skin_tone_bald:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\ud83e\uddb3", "1f469-1f3fd-200d-1f9b3.png", ":woman_medium_skin_tone_white_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\ud83e\uddbc", "1f469-1f3fd-200d-1f9bc.png", ":woman_in_motorized_wheelchair_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\ud83e\uddbd", "1f469-1f3fd-200d-1f9bd.png", ":woman_in_manual_wheelchair_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\u2695\ufe0f", "1f469-1f3fd-200d-2695-fe0f.png", ":woman_health_worker_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\u2696\ufe0f", "1f469-1f3fd-200d-2696-fe0f.png", ":woman_judge_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\u2708\ufe0f", "1f469-1f3fd-200d-2708-fe0f.png", ":woman_pilot_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffb", "1f469-1f3fd-200d-2764-fe0f-200d-1f468-1f3fb.png", ":couple_with_heart_woman_man_medium_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffc", "1f469-1f3fd-200d-2764-fe0f-200d-1f468-1f3fc.png", ":couple_with_heart_woman_man_medium_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffd", "1f469-1f3fd-200d-2764-fe0f-200d-1f468-1f3fd.png", ":couple_with_heart_woman_man_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffe", "1f469-1f3fd-200d-2764-fe0f-200d-1f468-1f3fe.png", ":couple_with_heart_woman_man_medium_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udfff", "1f469-1f3fd-200d-2764-fe0f-200d-1f468-1f3ff.png", ":couple_with_heart_woman_man_medium_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc69\ud83c\udffb", "1f469-1f3fd-200d-2764-fe0f-200d-1f469-1f3fb.png", ":couple_with_heart_woman_woman_medium_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc69\ud83c\udffc", "1f469-1f3fd-200d-2764-fe0f-200d-1f469-1f3fc.png", ":couple_with_heart_woman_woman_medium_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc69\ud83c\udffd", "1f469-1f3fd-200d-2764-fe0f-200d-1f469-1f3fd.png", ":couple_with_heart_woman_woman_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc69\ud83c\udffe", "1f469-1f3fd-200d-2764-fe0f-200d-1f469-1f3fe.png", ":couple_with_heart_woman_woman_medium_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc69\ud83c\udfff", "1f469-1f3fd-200d-2764-fe0f-200d-1f469-1f3ff.png", ":couple_with_heart_woman_woman_medium_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffb", "1f469-1f3fd-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fb.png", ":kiss_woman_man_medium_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffc", "1f469-1f3fd-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fc.png", ":kiss_woman_man_medium_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffd", "1f469-1f3fd-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fd.png", ":kiss_woman_man_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffe", "1f469-1f3fd-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fe.png", ":kiss_woman_man_medium_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udfff", "1f469-1f3fd-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3ff.png", ":kiss_woman_man_medium_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc69\ud83c\udffb", "1f469-1f3fd-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fb.png", ":kiss_woman_woman_medium_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc69\ud83c\udffc", "1f469-1f3fd-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fc.png", ":kiss_woman_woman_medium_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc69\ud83c\udffd", "1f469-1f3fd-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fd.png", ":kiss_woman_woman_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc69\ud83c\udffe", "1f469-1f3fd-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fe.png", ":kiss_woman_woman_medium_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc69\ud83c\udfff", "1f469-1f3fd-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3ff.png", ":kiss_woman_woman_medium_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd", "1f469-1f3fd.png", ":woman_tone3:", ":woman_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\ud83c\udf3e", "1f469-1f3fe-200d-1f33e.png", ":woman_farmer_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\ud83c\udf73", "1f469-1f3fe-200d-1f373.png", ":woman_cook_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\ud83c\udf7c", "1f469-1f3fe-200d-1f37c.png", ":woman_feeding_baby_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\ud83c\udf84", "1f469-1f3fe-200d-1f384.png", null, null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\ud83c\udf93", "1f469-1f3fe-200d-1f393.png", ":woman_student_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\ud83c\udfa4", "1f469-1f3fe-200d-1f3a4.png", ":woman_singer_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\ud83c\udfa8", "1f469-1f3fe-200d-1f3a8.png", ":woman_artist_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\ud83c\udfeb", "1f469-1f3fe-200d-1f3eb.png", ":woman_teacher_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\ud83c\udfed", "1f469-1f3fe-200d-1f3ed.png", ":woman_factory_worker_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\ud83d\udcbb", "1f469-1f3fe-200d-1f4bb.png", ":woman_technologist_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\ud83d\udcbc", "1f469-1f3fe-200d-1f4bc.png", ":woman_office_worker_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\ud83d\udd27", "1f469-1f3fe-200d-1f527.png", ":woman_mechanic_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\ud83d\udd2c", "1f469-1f3fe-200d-1f52c.png", ":woman_scientist_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\ud83d\ude80", "1f469-1f3fe-200d-1f680.png", ":woman_astronaut_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\ud83d\ude92", "1f469-1f3fe-200d-1f692.png", ":woman_firefighter_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udffb", "1f469-1f3fe-200d-1f91d-200d-1f468-1f3fb.png", ":woman_and_man_holding_hands_medium_dark_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udffc", "1f469-1f3fe-200d-1f91d-200d-1f468-1f3fc.png", ":woman_and_man_holding_hands_medium_dark_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udffd", "1f469-1f3fe-200d-1f91d-200d-1f468-1f3fd.png", ":woman_and_man_holding_hands_medium_dark_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udfff", "1f469-1f3fe-200d-1f91d-200d-1f468-1f3ff.png", ":woman_and_man_holding_hands_medium_dark_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\ud83e\udd1d\u200d\ud83d\udc69\ud83c\udffb", "1f469-1f3fe-200d-1f91d-200d-1f469-1f3fb.png", ":women_holding_hands_medium_dark_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\ud83e\udd1d\u200d\ud83d\udc69\ud83c\udffc", "1f469-1f3fe-200d-1f91d-200d-1f469-1f3fc.png", ":women_holding_hands_medium_dark_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\ud83e\udd1d\u200d\ud83d\udc69\ud83c\udffd", "1f469-1f3fe-200d-1f91d-200d-1f469-1f3fd.png", ":women_holding_hands_medium_dark_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\ud83e\udd1d\u200d\ud83d\udc69\ud83c\udfff", "1f469-1f3fe-200d-1f91d-200d-1f469-1f3ff.png", ":women_holding_hands_medium_dark_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\ud83e\uddaf", "1f469-1f3fe-200d-1f9af.png", ":woman_with_white_cane_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\ud83e\uddb0", "1f469-1f3fe-200d-1f9b0.png", ":woman_medium_dark_skin_tone_red_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\ud83e\uddb1", "1f469-1f3fe-200d-1f9b1.png", ":woman_medium_dark_skin_tone_curly_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\ud83e\uddb2", "1f469-1f3fe-200d-1f9b2.png", ":woman_medium_dark_skin_tone_bald:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\ud83e\uddb3", "1f469-1f3fe-200d-1f9b3.png", ":woman_medium_dark_skin_tone_white_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\ud83e\uddbc", "1f469-1f3fe-200d-1f9bc.png", ":woman_in_motorized_wheelchair_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\ud83e\uddbd", "1f469-1f3fe-200d-1f9bd.png", ":woman_in_manual_wheelchair_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\u2695\ufe0f", "1f469-1f3fe-200d-2695-fe0f.png", ":woman_health_worker_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\u2696\ufe0f", "1f469-1f3fe-200d-2696-fe0f.png", ":woman_judge_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\u2708\ufe0f", "1f469-1f3fe-200d-2708-fe0f.png", ":woman_pilot_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffb", "1f469-1f3fe-200d-2764-fe0f-200d-1f468-1f3fb.png", ":couple_with_heart_woman_man_medium_dark_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffc", "1f469-1f3fe-200d-2764-fe0f-200d-1f468-1f3fc.png", ":couple_with_heart_woman_man_medium_dark_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffd", "1f469-1f3fe-200d-2764-fe0f-200d-1f468-1f3fd.png", ":couple_with_heart_woman_man_medium_dark_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffe", "1f469-1f3fe-200d-2764-fe0f-200d-1f468-1f3fe.png", ":couple_with_heart_woman_man_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udfff", "1f469-1f3fe-200d-2764-fe0f-200d-1f468-1f3ff.png", ":couple_with_heart_woman_man_medium_dark_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc69\ud83c\udffb", "1f469-1f3fe-200d-2764-fe0f-200d-1f469-1f3fb.png", ":couple_with_heart_woman_woman_medium_dark_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc69\ud83c\udffc", "1f469-1f3fe-200d-2764-fe0f-200d-1f469-1f3fc.png", ":couple_with_heart_woman_woman_medium_dark_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc69\ud83c\udffd", "1f469-1f3fe-200d-2764-fe0f-200d-1f469-1f3fd.png", ":couple_with_heart_woman_woman_medium_dark_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc69\ud83c\udffe", "1f469-1f3fe-200d-2764-fe0f-200d-1f469-1f3fe.png", ":couple_with_heart_woman_woman_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc69\ud83c\udfff", "1f469-1f3fe-200d-2764-fe0f-200d-1f469-1f3ff.png", ":couple_with_heart_woman_woman_medium_dark_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffb", "1f469-1f3fe-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fb.png", ":kiss_woman_man_medium_dark_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffc", "1f469-1f3fe-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fc.png", ":kiss_woman_man_medium_dark_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffd", "1f469-1f3fe-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fd.png", ":kiss_woman_man_medium_dark_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffe", "1f469-1f3fe-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fe.png", ":kiss_woman_man_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udfff", "1f469-1f3fe-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3ff.png", ":kiss_woman_man_medium_dark_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc69\ud83c\udffb", "1f469-1f3fe-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fb.png", ":kiss_woman_woman_medium_dark_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc69\ud83c\udffc", "1f469-1f3fe-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fc.png", ":kiss_woman_woman_medium_dark_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc69\ud83c\udffd", "1f469-1f3fe-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fd.png", ":kiss_woman_woman_medium_dark_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc69\ud83c\udffe", "1f469-1f3fe-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fe.png", ":kiss_woman_woman_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc69\ud83c\udfff", "1f469-1f3fe-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3ff.png", ":kiss_woman_woman_medium_dark_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe", "1f469-1f3fe.png", ":woman_tone4:", ":woman_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\ud83c\udf3e", "1f469-1f3ff-200d-1f33e.png", ":woman_farmer_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\ud83c\udf73", "1f469-1f3ff-200d-1f373.png", ":woman_cook_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\ud83c\udf7c", "1f469-1f3ff-200d-1f37c.png", ":woman_feeding_baby_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\ud83c\udf84", "1f469-1f3ff-200d-1f384.png", null, null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\ud83c\udf93", "1f469-1f3ff-200d-1f393.png", ":woman_student_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\ud83c\udfa4", "1f469-1f3ff-200d-1f3a4.png", ":woman_singer_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\ud83c\udfa8", "1f469-1f3ff-200d-1f3a8.png", ":woman_artist_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\ud83c\udfeb", "1f469-1f3ff-200d-1f3eb.png", ":woman_teacher_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\ud83c\udfed", "1f469-1f3ff-200d-1f3ed.png", ":woman_factory_worker_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\ud83d\udcbb", "1f469-1f3ff-200d-1f4bb.png", ":woman_technologist_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\ud83d\udcbc", "1f469-1f3ff-200d-1f4bc.png", ":woman_office_worker_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\ud83d\udd27", "1f469-1f3ff-200d-1f527.png", ":woman_mechanic_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\ud83d\udd2c", "1f469-1f3ff-200d-1f52c.png", ":woman_scientist_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\ud83d\ude80", "1f469-1f3ff-200d-1f680.png", ":woman_astronaut_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\ud83d\ude92", "1f469-1f3ff-200d-1f692.png", ":woman_firefighter_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udffb", "1f469-1f3ff-200d-1f91d-200d-1f468-1f3fb.png", ":woman_and_man_holding_hands_dark_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udffc", "1f469-1f3ff-200d-1f91d-200d-1f468-1f3fc.png", ":woman_and_man_holding_hands_dark_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udffd", "1f469-1f3ff-200d-1f91d-200d-1f468-1f3fd.png", ":woman_and_man_holding_hands_dark_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\ud83e\udd1d\u200d\ud83d\udc68\ud83c\udffe", "1f469-1f3ff-200d-1f91d-200d-1f468-1f3fe.png", ":woman_and_man_holding_hands_dark_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\ud83e\udd1d\u200d\ud83d\udc69\ud83c\udffb", "1f469-1f3ff-200d-1f91d-200d-1f469-1f3fb.png", ":women_holding_hands_dark_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\ud83e\udd1d\u200d\ud83d\udc69\ud83c\udffc", "1f469-1f3ff-200d-1f91d-200d-1f469-1f3fc.png", ":women_holding_hands_dark_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\ud83e\udd1d\u200d\ud83d\udc69\ud83c\udffd", "1f469-1f3ff-200d-1f91d-200d-1f469-1f3fd.png", ":women_holding_hands_dark_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\ud83e\udd1d\u200d\ud83d\udc69\ud83c\udffe", "1f469-1f3ff-200d-1f91d-200d-1f469-1f3fe.png", ":women_holding_hands_dark_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\ud83e\uddaf", "1f469-1f3ff-200d-1f9af.png", ":woman_with_white_cane_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\ud83e\uddb0", "1f469-1f3ff-200d-1f9b0.png", ":woman_dark_skin_tone_red_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\ud83e\uddb1", "1f469-1f3ff-200d-1f9b1.png", ":woman_dark_skin_tone_curly_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\ud83e\uddb2", "1f469-1f3ff-200d-1f9b2.png", ":woman_dark_skin_tone_bald:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\ud83e\uddb3", "1f469-1f3ff-200d-1f9b3.png", ":woman_dark_skin_tone_white_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\ud83e\uddbc", "1f469-1f3ff-200d-1f9bc.png", ":woman_in_motorized_wheelchair_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\ud83e\uddbd", "1f469-1f3ff-200d-1f9bd.png", ":woman_in_manual_wheelchair_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\u2695\ufe0f", "1f469-1f3ff-200d-2695-fe0f.png", ":woman_health_worker_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\u2696\ufe0f", "1f469-1f3ff-200d-2696-fe0f.png", ":woman_judge_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\u2708\ufe0f", "1f469-1f3ff-200d-2708-fe0f.png", ":woman_pilot_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffb", "1f469-1f3ff-200d-2764-fe0f-200d-1f468-1f3fb.png", ":couple_with_heart_woman_man_dark_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffc", "1f469-1f3ff-200d-2764-fe0f-200d-1f468-1f3fc.png", ":couple_with_heart_woman_man_dark_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffd", "1f469-1f3ff-200d-2764-fe0f-200d-1f468-1f3fd.png", ":couple_with_heart_woman_man_dark_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udffe", "1f469-1f3ff-200d-2764-fe0f-200d-1f468-1f3fe.png", ":couple_with_heart_woman_man_dark_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc68\ud83c\udfff", "1f469-1f3ff-200d-2764-fe0f-200d-1f468-1f3ff.png", ":couple_with_heart_woman_man_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc69\ud83c\udffb", "1f469-1f3ff-200d-2764-fe0f-200d-1f469-1f3fb.png", ":couple_with_heart_woman_woman_dark_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc69\ud83c\udffc", "1f469-1f3ff-200d-2764-fe0f-200d-1f469-1f3fc.png", ":couple_with_heart_woman_woman_dark_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc69\ud83c\udffd", "1f469-1f3ff-200d-2764-fe0f-200d-1f469-1f3fd.png", ":couple_with_heart_woman_woman_dark_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc69\ud83c\udffe", "1f469-1f3ff-200d-2764-fe0f-200d-1f469-1f3fe.png", ":couple_with_heart_woman_woman_dark_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc69\ud83c\udfff", "1f469-1f3ff-200d-2764-fe0f-200d-1f469-1f3ff.png", ":couple_with_heart_woman_woman_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffb", "1f469-1f3ff-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fb.png", ":kiss_woman_man_dark_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffc", "1f469-1f3ff-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fc.png", ":kiss_woman_man_dark_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffd", "1f469-1f3ff-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fd.png", ":kiss_woman_man_dark_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udffe", "1f469-1f3ff-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3fe.png", ":kiss_woman_man_dark_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68\ud83c\udfff", "1f469-1f3ff-200d-2764-fe0f-200d-1f48b-200d-1f468-1f3ff.png", ":kiss_woman_man_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc69\ud83c\udffb", "1f469-1f3ff-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fb.png", ":kiss_woman_woman_dark_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc69\ud83c\udffc", "1f469-1f3ff-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fc.png", ":kiss_woman_woman_dark_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc69\ud83c\udffd", "1f469-1f3ff-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fd.png", ":kiss_woman_woman_dark_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc69\ud83c\udffe", "1f469-1f3ff-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3fe.png", ":kiss_woman_woman_dark_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc69\ud83c\udfff", "1f469-1f3ff-200d-2764-fe0f-200d-1f48b-200d-1f469-1f3ff.png", ":kiss_woman_woman_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff", "1f469-1f3ff.png", ":woman_tone5:", ":woman_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\ud83c\udf3e", "1f469-200d-1f33e.png", ":woman_farmer:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\ud83c\udf73", "1f469-200d-1f373.png", ":woman_cook:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\ud83c\udf7c", "1f469-200d-1f37c.png", ":woman_feeding_baby:", null, "People & Body", "13.0");
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\ud83c\udf84", "1f469-200d-1f384.png", null, null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\ud83c\udf93", "1f469-200d-1f393.png", ":woman_student:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\ud83c\udfa4", "1f469-200d-1f3a4.png", ":woman_singer:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\ud83c\udfa8", "1f469-200d-1f3a8.png", ":woman_artist:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\ud83c\udfeb", "1f469-200d-1f3eb.png", ":woman_teacher:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\ud83c\udfed", "1f469-200d-1f3ed.png", ":woman_factory_worker:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\ud83d\udc66\u200d\ud83d\udc66", "1f469-200d-1f466-200d-1f466.png", ":family_woman_boy_boy:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\ud83d\udc66", "1f469-200d-1f466.png", ":family_woman_boy:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\ud83d\udc67\u200d\ud83d\udc66", "1f469-200d-1f467-200d-1f466.png", ":family_woman_girl_boy:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\ud83d\udc67\u200d\ud83d\udc67", "1f469-200d-1f467-200d-1f467.png", ":family_woman_girl_girl:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\ud83d\udc67", "1f469-200d-1f467.png", ":family_woman_girl:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\ud83d\udc69\u200d\ud83d\udc66\u200d\ud83d\udc66", "1f469-200d-1f469-200d-1f466-200d-1f466.png", ":family_woman_woman_boy_boy:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\ud83d\udc69\u200d\ud83d\udc66", "1f469-200d-1f469-200d-1f466.png", ":family_woman_woman_boy:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\ud83d\udc69\u200d\ud83d\udc67\u200d\ud83d\udc66", "1f469-200d-1f469-200d-1f467-200d-1f466.png", ":family_woman_woman_girl_boy:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\ud83d\udc69\u200d\ud83d\udc67\u200d\ud83d\udc67", "1f469-200d-1f469-200d-1f467-200d-1f467.png", ":family_woman_woman_girl_girl:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\ud83d\udc69\u200d\ud83d\udc67", "1f469-200d-1f469-200d-1f467.png", ":family_woman_woman_girl:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\ud83d\udcbb", "1f469-200d-1f4bb.png", ":woman_technologist:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\ud83d\udcbc", "1f469-200d-1f4bc.png", ":woman_office_worker:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\ud83d\udd27", "1f469-200d-1f527.png", ":woman_mechanic:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\ud83d\udd2c", "1f469-200d-1f52c.png", ":woman_scientist:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\ud83d\ude80", "1f469-200d-1f680.png", ":woman_astronaut:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\ud83d\ude92", "1f469-200d-1f692.png", ":woman_firefighter:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\ud83e\uddaf", "1f469-200d-1f9af.png", ":woman_with_probing_cane:", ":woman_with_white_cane:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\ud83e\uddb0", "1f469-200d-1f9b0.png", ":red_haired_woman:", ":woman_red_hair:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\ud83e\uddb1", "1f469-200d-1f9b1.png", ":curly_haired_woman:", ":woman_curly_hair:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\ud83e\uddb2", "1f469-200d-1f9b2.png", ":bald_woman:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\ud83e\uddb3", "1f469-200d-1f9b3.png", ":white_haired_woman:", ":woman_white_hair:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\ud83e\uddbc", "1f469-200d-1f9bc.png", ":woman_in_motorized_wheelchair:", null, "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\ud83e\uddbd", "1f469-200d-1f9bd.png", ":woman_in_manual_wheelchair:", null, "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\u2695\ufe0f", "1f469-200d-2695-fe0f.png", ":woman_health_worker:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\u2696\ufe0f", "1f469-200d-2696-fe0f.png", ":woman_judge:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\u2708\ufe0f", "1f469-200d-2708-fe0f.png", ":woman_pilot:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\u2764\ufe0f\u200d\ud83d\udc68", "1f469-200d-2764-fe0f-200d-1f468.png", ":couple_with_heart_woman_man:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\u2764\ufe0f\u200d\ud83d\udc69", "1f469-200d-2764-fe0f-200d-1f469.png", ":couple_with_heart_woman_woman:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc68", "1f469-200d-2764-fe0f-200d-1f48b-200d-1f468.png", ":couplekiss_man_woman:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83d\udc69\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83d\udc69", "1f469-200d-2764-fe0f-200d-1f48b-200d-1f469.png", ":couplekiss_woman_woman:", ":kiss_woman_woman:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc69", "1f469.png", ":woman:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6a", "1f46a.png", ":family:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6b\ud83c\udffb", "1f46b-1f3fb.png", ":couple_tone1:", ":woman_and_man_holding_hands_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6b\ud83c\udffc", "1f46b-1f3fc.png", ":couple_tone2:", ":woman_and_man_holding_hands_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6b\ud83c\udffd", "1f46b-1f3fd.png", ":couple_tone3:", ":woman_and_man_holding_hands_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6b\ud83c\udffe", "1f46b-1f3fe.png", ":couple_tone4:", ":woman_and_man_holding_hands_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6b\ud83c\udfff", "1f46b-1f3ff.png", ":couple_tone5:", ":woman_and_man_holding_hands_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6b", "1f46b.png", ":couple:", ":woman_and_man_holding_hands:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6c\ud83c\udffb", "1f46c-1f3fb.png", ":two_men_holding_hands_tone1:", ":men_holding_hands_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6c\ud83c\udffc", "1f46c-1f3fc.png", ":two_men_holding_hands_tone2:", ":men_holding_hands_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6c\ud83c\udffd", "1f46c-1f3fd.png", ":two_men_holding_hands_tone3:", ":men_holding_hands_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6c\ud83c\udffe", "1f46c-1f3fe.png", ":two_men_holding_hands_tone4:", ":men_holding_hands_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6c\ud83c\udfff", "1f46c-1f3ff.png", ":two_men_holding_hands_tone5:", ":men_holding_hands_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6c", "1f46c.png", ":two_men_holding_hands:", ":men_holding_hands:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6d\ud83c\udffb", "1f46d-1f3fb.png", ":two_women_holding_hands_tone1:", ":women_holding_hands_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6d\ud83c\udffc", "1f46d-1f3fc.png", ":two_women_holding_hands_tone2:", ":women_holding_hands_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6d\ud83c\udffd", "1f46d-1f3fd.png", ":two_women_holding_hands_tone3:", ":women_holding_hands_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6d\ud83c\udffe", "1f46d-1f3fe.png", ":two_women_holding_hands_tone4:", ":women_holding_hands_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6d\ud83c\udfff", "1f46d-1f3ff.png", ":two_women_holding_hands_tone5:", ":women_holding_hands_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6d", "1f46d.png", ":two_women_holding_hands:", ":women_holding_hands:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6e\ud83c\udffb\u200d\u2640\ufe0f", "1f46e-1f3fb-200d-2640-fe0f.png", ":woman_police_officer_tone1:", ":woman_police_officer_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6e\ud83c\udffb\u200d\u2642\ufe0f", "1f46e-1f3fb-200d-2642-fe0f.png", ":man_police_officer_tone1:", ":man_police_officer_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6e\ud83c\udffb", "1f46e-1f3fb.png", ":police_officer_tone1:", ":police_officer_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6e\ud83c\udffc\u200d\u2640\ufe0f", "1f46e-1f3fc-200d-2640-fe0f.png", ":woman_police_officer_tone2:", ":woman_police_officer_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6e\ud83c\udffc\u200d\u2642\ufe0f", "1f46e-1f3fc-200d-2642-fe0f.png", ":man_police_officer_tone2:", ":man_police_officer_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6e\ud83c\udffc", "1f46e-1f3fc.png", ":police_officer_tone2:", ":police_officer_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6e\ud83c\udffd\u200d\u2640\ufe0f", "1f46e-1f3fd-200d-2640-fe0f.png", ":woman_police_officer_tone3:", ":woman_police_officer_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6e\ud83c\udffd\u200d\u2642\ufe0f", "1f46e-1f3fd-200d-2642-fe0f.png", ":man_police_officer_tone3:", ":man_police_officer_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6e\ud83c\udffd", "1f46e-1f3fd.png", ":police_officer_tone3:", ":police_officer_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6e\ud83c\udffe\u200d\u2640\ufe0f", "1f46e-1f3fe-200d-2640-fe0f.png", ":woman_police_officer_tone4:", ":woman_police_officer_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6e\ud83c\udffe\u200d\u2642\ufe0f", "1f46e-1f3fe-200d-2642-fe0f.png", ":man_police_officer_tone4:", ":man_police_officer_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6e\ud83c\udffe", "1f46e-1f3fe.png", ":police_officer_tone4:", ":police_officer_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6e\ud83c\udfff\u200d\u2640\ufe0f", "1f46e-1f3ff-200d-2640-fe0f.png", ":woman_police_officer_tone5:", ":woman_police_officer_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6e\ud83c\udfff\u200d\u2642\ufe0f", "1f46e-1f3ff-200d-2642-fe0f.png", ":man_police_officer_tone5:", ":man_police_officer_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6e\ud83c\udfff", "1f46e-1f3ff.png", ":police_officer_tone5:", ":police_officer_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6e\u200d\u2640\ufe0f", "1f46e-200d-2640-fe0f.png", ":policewoman:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6e\u200d\u2642\ufe0f", "1f46e-200d-2642-fe0f.png", ":policeman:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83d\udc6e", "1f46e.png", ":police_officer:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6f\u200d\u2640\ufe0f", "1f46f-200d-2640-fe0f.png", ":dancing_women:", ":women_with_bunny_ears:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83d\udc6f\u200d\u2642\ufe0f", "1f46f-200d-2642-fe0f.png", ":dancing_men:", ":men_with_bunny_ears:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6f", "1f46f.png", ":dancers:", ":people_with_bunny_ears_partying:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc70\ud83c\udffb\u200d\u2640\ufe0f", "1f470-1f3fb-200d-2640-fe0f.png", ":woman_person_with_veil_tone1:", ":woman_with_veil_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc70\ud83c\udffb\u200d\u2642\ufe0f", "1f470-1f3fb-200d-2642-fe0f.png", ":man_person_with_veil_tone1:", ":man_with_veil_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc70\ud83c\udffb", "1f470-1f3fb.png", ":person_with_veil_tone1:", ":bride_with_veil_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc70\ud83c\udffc\u200d\u2640\ufe0f", "1f470-1f3fc-200d-2640-fe0f.png", ":woman_person_with_veil_tone2:", ":woman_with_veil_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc70\ud83c\udffc\u200d\u2642\ufe0f", "1f470-1f3fc-200d-2642-fe0f.png", ":man_person_with_veil_tone2:", ":man_with_veil_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc70\ud83c\udffc", "1f470-1f3fc.png", ":person_with_veil_tone2:", ":bride_with_veil_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc70\ud83c\udffd\u200d\u2640\ufe0f", "1f470-1f3fd-200d-2640-fe0f.png", ":woman_person_with_veil_tone3:", ":woman_with_veil_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc70\ud83c\udffd\u200d\u2642\ufe0f", "1f470-1f3fd-200d-2642-fe0f.png", ":man_person_with_veil_tone3:", ":man_with_veil_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc70\ud83c\udffd", "1f470-1f3fd.png", ":person_with_veil_tone3:", ":bride_with_veil_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc70\ud83c\udffe\u200d\u2640\ufe0f", "1f470-1f3fe-200d-2640-fe0f.png", ":woman_person_with_veil_tone4:", ":woman_with_veil_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc70\ud83c\udffe\u200d\u2642\ufe0f", "1f470-1f3fe-200d-2642-fe0f.png", ":man_person_with_veil_tone4:", ":man_with_veil_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc70\ud83c\udffe", "1f470-1f3fe.png", ":person_with_veil_tone4:", ":bride_with_veil_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc70\ud83c\udfff\u200d\u2640\ufe0f", "1f470-1f3ff-200d-2640-fe0f.png", ":woman_person_with_veil_tone5:", ":woman_with_veil_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc70\ud83c\udfff\u200d\u2642\ufe0f", "1f470-1f3ff-200d-2642-fe0f.png", ":man_person_with_veil_tone5:", ":man_with_veil_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc70\ud83c\udfff", "1f470-1f3ff.png", ":person_with_veil_tone5:", ":bride_with_veil_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc70\u200d\u2640\ufe0f", "1f470-200d-2640-fe0f.png", ":woman_with_veil:", null, "People & Body", "13.0");
        EmojiUtil.add(set, result, "\ud83d\udc70\u200d\u2642\ufe0f", "1f470-200d-2642-fe0f.png", ":man_with_veil:", null, "People & Body", "13.0");
        EmojiUtil.add(set, result, "\ud83d\udc70", "1f470.png", ":person_with_veil:", ":bride_with_veil:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc71\ud83c\udffb\u200d\u2640\ufe0f", "1f471-1f3fb-200d-2640-fe0f.png", ":woman_blond_haired_person_tone1:", ":woman_light_skin_tone_blond_hair:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc71\ud83c\udffb\u200d\u2642\ufe0f", "1f471-1f3fb-200d-2642-fe0f.png", ":man_blond_haired_person_tone1:", ":man_light_skin_tone_blond_hair:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc71\ud83c\udffb", "1f471-1f3fb.png", ":blond_haired_person_tone1:", ":person_light_skin_tone_blond_hair:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc71\ud83c\udffc\u200d\u2640\ufe0f", "1f471-1f3fc-200d-2640-fe0f.png", ":woman_blond_haired_person_tone2:", ":woman_medium_light_skin_tone_blond_hair:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc71\ud83c\udffc\u200d\u2642\ufe0f", "1f471-1f3fc-200d-2642-fe0f.png", ":man_blond_haired_person_tone2:", ":man_medium_light_skin_tone_blond_hair:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc71\ud83c\udffc", "1f471-1f3fc.png", ":blond_haired_person_tone2:", ":person_medium_light_skin_tone_blond_hair:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc71\ud83c\udffd\u200d\u2640\ufe0f", "1f471-1f3fd-200d-2640-fe0f.png", ":woman_blond_haired_person_tone3:", ":woman_medium_skin_tone_blond_hair:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc71\ud83c\udffd\u200d\u2642\ufe0f", "1f471-1f3fd-200d-2642-fe0f.png", ":man_blond_haired_person_tone3:", ":man_medium_skin_tone_blond_hair:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc71\ud83c\udffd", "1f471-1f3fd.png", ":blond_haired_person_tone3:", ":person_medium_skin_tone_blond_hair:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc71\ud83c\udffe\u200d\u2640\ufe0f", "1f471-1f3fe-200d-2640-fe0f.png", ":woman_blond_haired_person_tone4:", ":woman_medium_dark_skin_tone_blond_hair:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc71\ud83c\udffe\u200d\u2642\ufe0f", "1f471-1f3fe-200d-2642-fe0f.png", ":man_blond_haired_person_tone4:", ":man_medium_dark_skin_tone_blond_hair:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc71\ud83c\udffe", "1f471-1f3fe.png", ":blond_haired_person_tone4:", ":person_medium_dark_skin_tone_blond_hair:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc71\ud83c\udfff\u200d\u2640\ufe0f", "1f471-1f3ff-200d-2640-fe0f.png", ":woman_blond_haired_person_tone5:", ":woman_dark_skin_tone_blond_hair:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc71\ud83c\udfff\u200d\u2642\ufe0f", "1f471-1f3ff-200d-2642-fe0f.png", ":man_blond_haired_person_tone5:", ":man_dark_skin_tone_blond_hair:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc71\ud83c\udfff", "1f471-1f3ff.png", ":blond_haired_person_tone5:", ":person_dark_skin_tone_blond_hair:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc71\u200d\u2640\ufe0f", "1f471-200d-2640-fe0f.png", ":blond_haired_woman:", ":woman_blond_hair:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc71\u200d\u2642\ufe0f", "1f471-200d-2642-fe0f.png", ":blond_haired_man:", ":man_blond_hair:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83d\udc71", "1f471.png", ":blond_haired_person:", ":person_blond_hair:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc72\ud83c\udffb", "1f472-1f3fb.png", ":man_with_gua_pi_mao_tone1:", ":man_with_chinese_cap_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc72\ud83c\udffc", "1f472-1f3fc.png", ":man_with_gua_pi_mao_tone2:", ":man_with_chinese_cap_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc72\ud83c\udffd", "1f472-1f3fd.png", ":man_with_gua_pi_mao_tone3:", ":man_with_chinese_cap_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc72\ud83c\udffe", "1f472-1f3fe.png", ":man_with_gua_pi_mao_tone4:", ":man_with_chinese_cap_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc72\ud83c\udfff", "1f472-1f3ff.png", ":man_with_gua_pi_mao_tone5:", ":man_with_chinese_cap_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc72", "1f472.png", ":man_with_gua_pi_mao:", ":man_with_chinese_cap:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc73\ud83c\udffb\u200d\u2640\ufe0f", "1f473-1f3fb-200d-2640-fe0f.png", ":woman_person_with_turban_tone1:", ":woman_wearing_turban_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc73\ud83c\udffb\u200d\u2642\ufe0f", "1f473-1f3fb-200d-2642-fe0f.png", ":man_person_with_turban_tone1:", ":man_wearing_turban_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc73\ud83c\udffb", "1f473-1f3fb.png", ":person_with_turban_tone1:", ":person_wearing_turban_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc73\ud83c\udffc\u200d\u2640\ufe0f", "1f473-1f3fc-200d-2640-fe0f.png", ":woman_person_with_turban_tone2:", ":woman_wearing_turban_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc73\ud83c\udffc\u200d\u2642\ufe0f", "1f473-1f3fc-200d-2642-fe0f.png", ":man_person_with_turban_tone2:", ":man_wearing_turban_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc73\ud83c\udffc", "1f473-1f3fc.png", ":person_with_turban_tone2:", ":person_wearing_turban_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc73\ud83c\udffd\u200d\u2640\ufe0f", "1f473-1f3fd-200d-2640-fe0f.png", ":woman_person_with_turban_tone3:", ":woman_wearing_turban_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc73\ud83c\udffd\u200d\u2642\ufe0f", "1f473-1f3fd-200d-2642-fe0f.png", ":man_person_with_turban_tone3:", ":man_wearing_turban_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc73\ud83c\udffd", "1f473-1f3fd.png", ":person_with_turban_tone3:", ":person_wearing_turban_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc73\ud83c\udffe\u200d\u2640\ufe0f", "1f473-1f3fe-200d-2640-fe0f.png", ":woman_person_with_turban_tone4:", ":woman_wearing_turban_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc73\ud83c\udffe\u200d\u2642\ufe0f", "1f473-1f3fe-200d-2642-fe0f.png", ":man_person_with_turban_tone4:", ":man_wearing_turban_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc73\ud83c\udffe", "1f473-1f3fe.png", ":person_with_turban_tone4:", ":person_wearing_turban_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc73\ud83c\udfff\u200d\u2640\ufe0f", "1f473-1f3ff-200d-2640-fe0f.png", ":woman_person_with_turban_tone5:", ":woman_wearing_turban_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc73\ud83c\udfff\u200d\u2642\ufe0f", "1f473-1f3ff-200d-2642-fe0f.png", ":man_person_with_turban_tone5:", ":man_wearing_turban_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc73\ud83c\udfff", "1f473-1f3ff.png", ":person_with_turban_tone5:", ":person_wearing_turban_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc73\u200d\u2640\ufe0f", "1f473-200d-2640-fe0f.png", ":woman_with_turban:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc73\u200d\u2642\ufe0f", "1f473-200d-2642-fe0f.png", ":man_with_turban:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83d\udc73", "1f473.png", ":person_with_turban:", ":person_wearing_turban:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc74\ud83c\udffb", "1f474-1f3fb.png", ":older_man_tone1:", ":old_man_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc74\ud83c\udffc", "1f474-1f3fc.png", ":older_man_tone2:", ":old_man_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc74\ud83c\udffd", "1f474-1f3fd.png", ":older_man_tone3:", ":old_man_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc74\ud83c\udffe", "1f474-1f3fe.png", ":older_man_tone4:", ":old_man_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc74\ud83c\udfff", "1f474-1f3ff.png", ":older_man_tone5:", ":old_man_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc74", "1f474.png", ":older_man:", ":old_man:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc75\ud83c\udffb", "1f475-1f3fb.png", ":older_woman_tone1:", ":old_woman_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc75\ud83c\udffc", "1f475-1f3fc.png", ":older_woman_tone2:", ":old_woman_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc75\ud83c\udffd", "1f475-1f3fd.png", ":older_woman_tone3:", ":old_woman_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc75\ud83c\udffe", "1f475-1f3fe.png", ":older_woman_tone4:", ":old_woman_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc75\ud83c\udfff", "1f475-1f3ff.png", ":older_woman_tone5:", ":old_woman_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc75", "1f475.png", ":older_woman:", ":old_woman:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc76\ud83c\udffb", "1f476-1f3fb.png", ":baby_tone1:", ":baby_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc76\ud83c\udffc", "1f476-1f3fc.png", ":baby_tone2:", ":baby_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc76\ud83c\udffd", "1f476-1f3fd.png", ":baby_tone3:", ":baby_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc76\ud83c\udffe", "1f476-1f3fe.png", ":baby_tone4:", ":baby_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc76\ud83c\udfff", "1f476-1f3ff.png", ":baby_tone5:", ":baby_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc76", "1f476.png", ":baby:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc77\ud83c\udffb\u200d\u2640\ufe0f", "1f477-1f3fb-200d-2640-fe0f.png", ":woman_construction_worker_tone1:", ":woman_construction_worker_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc77\ud83c\udffb\u200d\u2642\ufe0f", "1f477-1f3fb-200d-2642-fe0f.png", ":man_construction_worker_tone1:", ":man_construction_worker_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc77\ud83c\udffb", "1f477-1f3fb.png", ":construction_worker_tone1:", ":construction_worker_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc77\ud83c\udffc\u200d\u2640\ufe0f", "1f477-1f3fc-200d-2640-fe0f.png", ":woman_construction_worker_tone2:", ":woman_construction_worker_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc77\ud83c\udffc\u200d\u2642\ufe0f", "1f477-1f3fc-200d-2642-fe0f.png", ":man_construction_worker_tone2:", ":man_construction_worker_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc77\ud83c\udffc", "1f477-1f3fc.png", ":construction_worker_tone2:", ":construction_worker_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc77\ud83c\udffd\u200d\u2640\ufe0f", "1f477-1f3fd-200d-2640-fe0f.png", ":woman_construction_worker_tone3:", ":woman_construction_worker_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc77\ud83c\udffd\u200d\u2642\ufe0f", "1f477-1f3fd-200d-2642-fe0f.png", ":man_construction_worker_tone3:", ":man_construction_worker_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc77\ud83c\udffd", "1f477-1f3fd.png", ":construction_worker_tone3:", ":construction_worker_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc77\ud83c\udffe\u200d\u2640\ufe0f", "1f477-1f3fe-200d-2640-fe0f.png", ":woman_construction_worker_tone4:", ":woman_construction_worker_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc77\ud83c\udffe\u200d\u2642\ufe0f", "1f477-1f3fe-200d-2642-fe0f.png", ":man_construction_worker_tone4:", ":man_construction_worker_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc77\ud83c\udffe", "1f477-1f3fe.png", ":construction_worker_tone4:", ":construction_worker_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc77\ud83c\udfff\u200d\u2640\ufe0f", "1f477-1f3ff-200d-2640-fe0f.png", ":woman_construction_worker_tone5:", ":woman_construction_worker_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc77\ud83c\udfff\u200d\u2642\ufe0f", "1f477-1f3ff-200d-2642-fe0f.png", ":man_construction_worker_tone5:", ":man_construction_worker_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc77\ud83c\udfff", "1f477-1f3ff.png", ":construction_worker_tone5:", ":construction_worker_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc77\u200d\u2640\ufe0f", "1f477-200d-2640-fe0f.png", ":construction_worker_woman:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc77\u200d\u2642\ufe0f", "1f477-200d-2642-fe0f.png", ":construction_worker_man:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83d\udc77", "1f477.png", ":construction_worker:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc78\ud83c\udffb", "1f478-1f3fb.png", ":princess_tone1:", ":princess_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc78\ud83c\udffc", "1f478-1f3fc.png", ":princess_tone2:", ":princess_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc78\ud83c\udffd", "1f478-1f3fd.png", ":princess_tone3:", ":princess_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc78\ud83c\udffe", "1f478-1f3fe.png", ":princess_tone4:", ":princess_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc78\ud83c\udfff", "1f478-1f3ff.png", ":princess_tone5:", ":princess_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc78", "1f478.png", ":princess:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc79", "1f479.png", ":japanese_ogre:", ":ogre:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc7a", "1f47a.png", ":japanese_goblin:", ":goblin:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc7b", "1f47b.png", ":ghost:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc7c\ud83c\udffb", "1f47c-1f3fb.png", ":angel_tone1:", ":baby_angel_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc7c\ud83c\udffc", "1f47c-1f3fc.png", ":angel_tone2:", ":baby_angel_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc7c\ud83c\udffd", "1f47c-1f3fd.png", ":angel_tone3:", ":baby_angel_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc7c\ud83c\udffe", "1f47c-1f3fe.png", ":angel_tone4:", ":baby_angel_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc7c\ud83c\udfff", "1f47c-1f3ff.png", ":angel_tone5:", ":baby_angel_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc7c", "1f47c.png", ":angel:", ":baby_angel:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc7d", "1f47d.png", ":alien:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc7e", "1f47e.png", ":space_invader:", ":alien_monster:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc7f", "1f47f.png", ":imp:", ":angry_face_with_horns:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc80", "1f480.png", ":skull:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc81\ud83c\udffb\u200d\u2640\ufe0f", "1f481-1f3fb-200d-2640-fe0f.png", ":woman_tipping_hand_person_tone1:", ":woman_tipping_hand_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc81\ud83c\udffb\u200d\u2642\ufe0f", "1f481-1f3fb-200d-2642-fe0f.png", ":man_tipping_hand_person_tone1:", ":man_tipping_hand_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc81\ud83c\udffb", "1f481-1f3fb.png", ":tipping_hand_person_tone1:", ":person_tipping_hand_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc81\ud83c\udffc\u200d\u2640\ufe0f", "1f481-1f3fc-200d-2640-fe0f.png", ":woman_tipping_hand_person_tone2:", ":woman_tipping_hand_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc81\ud83c\udffc\u200d\u2642\ufe0f", "1f481-1f3fc-200d-2642-fe0f.png", ":man_tipping_hand_person_tone2:", ":man_tipping_hand_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc81\ud83c\udffc", "1f481-1f3fc.png", ":tipping_hand_person_tone2:", ":person_tipping_hand_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc81\ud83c\udffd\u200d\u2640\ufe0f", "1f481-1f3fd-200d-2640-fe0f.png", ":woman_tipping_hand_person_tone3:", ":woman_tipping_hand_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc81\ud83c\udffd\u200d\u2642\ufe0f", "1f481-1f3fd-200d-2642-fe0f.png", ":man_tipping_hand_person_tone3:", ":man_tipping_hand_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc81\ud83c\udffd", "1f481-1f3fd.png", ":tipping_hand_person_tone3:", ":person_tipping_hand_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc81\ud83c\udffe\u200d\u2640\ufe0f", "1f481-1f3fe-200d-2640-fe0f.png", ":woman_tipping_hand_person_tone4:", ":woman_tipping_hand_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc81\ud83c\udffe\u200d\u2642\ufe0f", "1f481-1f3fe-200d-2642-fe0f.png", ":man_tipping_hand_person_tone4:", ":man_tipping_hand_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc81\ud83c\udffe", "1f481-1f3fe.png", ":tipping_hand_person_tone4:", ":person_tipping_hand_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc81\ud83c\udfff\u200d\u2640\ufe0f", "1f481-1f3ff-200d-2640-fe0f.png", ":woman_tipping_hand_person_tone5:", ":woman_tipping_hand_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc81\ud83c\udfff\u200d\u2642\ufe0f", "1f481-1f3ff-200d-2642-fe0f.png", ":man_tipping_hand_person_tone5:", ":man_tipping_hand_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc81\ud83c\udfff", "1f481-1f3ff.png", ":tipping_hand_person_tone5:", ":person_tipping_hand_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc81\u200d\u2640\ufe0f", "1f481-200d-2640-fe0f.png", ":tipping_hand_woman:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83d\udc81\u200d\u2642\ufe0f", "1f481-200d-2642-fe0f.png", ":tipping_hand_man:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc81", "1f481.png", ":tipping_hand_person:", ":person_tipping_hand:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc82\ud83c\udffb\u200d\u2640\ufe0f", "1f482-1f3fb-200d-2640-fe0f.png", ":woman_guard_tone1:", ":woman_guard_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc82\ud83c\udffb\u200d\u2642\ufe0f", "1f482-1f3fb-200d-2642-fe0f.png", ":man_guard_tone1:", ":man_guard_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc82\ud83c\udffb", "1f482-1f3fb.png", ":guard_tone1:", ":guard_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc82\ud83c\udffc\u200d\u2640\ufe0f", "1f482-1f3fc-200d-2640-fe0f.png", ":woman_guard_tone2:", ":woman_guard_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc82\ud83c\udffc\u200d\u2642\ufe0f", "1f482-1f3fc-200d-2642-fe0f.png", ":man_guard_tone2:", ":man_guard_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc82\ud83c\udffc", "1f482-1f3fc.png", ":guard_tone2:", ":guard_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc82\ud83c\udffd\u200d\u2640\ufe0f", "1f482-1f3fd-200d-2640-fe0f.png", ":woman_guard_tone3:", ":woman_guard_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc82\ud83c\udffd\u200d\u2642\ufe0f", "1f482-1f3fd-200d-2642-fe0f.png", ":man_guard_tone3:", ":man_guard_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc82\ud83c\udffd", "1f482-1f3fd.png", ":guard_tone3:", ":guard_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc82\ud83c\udffe\u200d\u2640\ufe0f", "1f482-1f3fe-200d-2640-fe0f.png", ":woman_guard_tone4:", ":woman_guard_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc82\ud83c\udffe\u200d\u2642\ufe0f", "1f482-1f3fe-200d-2642-fe0f.png", ":man_guard_tone4:", ":man_guard_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc82\ud83c\udffe", "1f482-1f3fe.png", ":guard_tone4:", ":guard_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc82\ud83c\udfff\u200d\u2640\ufe0f", "1f482-1f3ff-200d-2640-fe0f.png", ":woman_guard_tone5:", ":woman_guard_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc82\ud83c\udfff\u200d\u2642\ufe0f", "1f482-1f3ff-200d-2642-fe0f.png", ":man_guard_tone5:", ":man_guard_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc82\ud83c\udfff", "1f482-1f3ff.png", ":guard_tone5:", ":guard_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc82\u200d\u2640\ufe0f", "1f482-200d-2640-fe0f.png", ":guardswoman:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc82\u200d\u2642\ufe0f", "1f482-200d-2642-fe0f.png", ":guardsman:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83d\udc82", "1f482.png", ":guard:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc83\ud83c\udffb", "1f483-1f3fb.png", ":woman_dancing_tone1:", ":dancer_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc83\ud83c\udffc", "1f483-1f3fc.png", ":woman_dancing_tone2:", ":dancer_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc83\ud83c\udffd", "1f483-1f3fd.png", ":woman_dancing_tone3:", ":dancer_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc83\ud83c\udffe", "1f483-1f3fe.png", ":woman_dancing_tone4:", ":dancer_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc83\ud83c\udfff", "1f483-1f3ff.png", ":woman_dancing_tone5:", ":dancer_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc83", "1f483.png", ":woman_dancing:", ":dancer:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc84", "1f484.png", ":lipstick:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc85\ud83c\udffb", "1f485-1f3fb.png", ":nail_care_tone1:", ":nail_polish_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc85\ud83c\udffc", "1f485-1f3fc.png", ":nail_care_tone2:", ":nail_polish_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc85\ud83c\udffd", "1f485-1f3fd.png", ":nail_care_tone3:", ":nail_polish_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc85\ud83c\udffe", "1f485-1f3fe.png", ":nail_care_tone4:", ":nail_polish_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc85\ud83c\udfff", "1f485-1f3ff.png", ":nail_care_tone5:", ":nail_polish_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc85", "1f485.png", ":nail_care:", ":nail_polish:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc86\ud83c\udffb\u200d\u2640\ufe0f", "1f486-1f3fb-200d-2640-fe0f.png", ":woman_massage_tone1:", ":woman_getting_massage_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc86\ud83c\udffb\u200d\u2642\ufe0f", "1f486-1f3fb-200d-2642-fe0f.png", ":man_massage_tone1:", ":man_getting_massage_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc86\ud83c\udffb", "1f486-1f3fb.png", ":massage_tone1:", ":person_getting_massage_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc86\ud83c\udffc\u200d\u2640\ufe0f", "1f486-1f3fc-200d-2640-fe0f.png", ":woman_massage_tone2:", ":woman_getting_massage_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc86\ud83c\udffc\u200d\u2642\ufe0f", "1f486-1f3fc-200d-2642-fe0f.png", ":man_massage_tone2:", ":man_getting_massage_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc86\ud83c\udffc", "1f486-1f3fc.png", ":massage_tone2:", ":person_getting_massage_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc86\ud83c\udffd\u200d\u2640\ufe0f", "1f486-1f3fd-200d-2640-fe0f.png", ":woman_massage_tone3:", ":woman_getting_massage_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc86\ud83c\udffd\u200d\u2642\ufe0f", "1f486-1f3fd-200d-2642-fe0f.png", ":man_massage_tone3:", ":man_getting_massage_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc86\ud83c\udffd", "1f486-1f3fd.png", ":massage_tone3:", ":person_getting_massage_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc86\ud83c\udffe\u200d\u2640\ufe0f", "1f486-1f3fe-200d-2640-fe0f.png", ":woman_massage_tone4:", ":woman_getting_massage_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc86\ud83c\udffe\u200d\u2642\ufe0f", "1f486-1f3fe-200d-2642-fe0f.png", ":man_massage_tone4:", ":man_getting_massage_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc86\ud83c\udffe", "1f486-1f3fe.png", ":massage_tone4:", ":person_getting_massage_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc86\ud83c\udfff\u200d\u2640\ufe0f", "1f486-1f3ff-200d-2640-fe0f.png", ":woman_massage_tone5:", ":woman_getting_massage_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc86\ud83c\udfff\u200d\u2642\ufe0f", "1f486-1f3ff-200d-2642-fe0f.png", ":man_massage_tone5:", ":man_getting_massage_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc86\ud83c\udfff", "1f486-1f3ff.png", ":massage_tone5:", ":person_getting_massage_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc86\u200d\u2640\ufe0f", "1f486-200d-2640-fe0f.png", ":massage_woman:", ":woman_getting_massage:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83d\udc86\u200d\u2642\ufe0f", "1f486-200d-2642-fe0f.png", ":massage_man:", ":man_getting_massage:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc86", "1f486.png", ":massage:", ":person_getting_massage:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc87\ud83c\udffb\u200d\u2640\ufe0f", "1f487-1f3fb-200d-2640-fe0f.png", ":woman_haircut_tone1:", ":woman_getting_haircut_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc87\ud83c\udffb\u200d\u2642\ufe0f", "1f487-1f3fb-200d-2642-fe0f.png", ":man_haircut_tone1:", ":man_getting_haircut_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc87\ud83c\udffb", "1f487-1f3fb.png", ":haircut_tone1:", ":person_getting_haircut_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc87\ud83c\udffc\u200d\u2640\ufe0f", "1f487-1f3fc-200d-2640-fe0f.png", ":woman_haircut_tone2:", ":woman_getting_haircut_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc87\ud83c\udffc\u200d\u2642\ufe0f", "1f487-1f3fc-200d-2642-fe0f.png", ":man_haircut_tone2:", ":man_getting_haircut_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc87\ud83c\udffc", "1f487-1f3fc.png", ":haircut_tone2:", ":person_getting_haircut_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc87\ud83c\udffd\u200d\u2640\ufe0f", "1f487-1f3fd-200d-2640-fe0f.png", ":woman_haircut_tone3:", ":woman_getting_haircut_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc87\ud83c\udffd\u200d\u2642\ufe0f", "1f487-1f3fd-200d-2642-fe0f.png", ":man_haircut_tone3:", ":man_getting_haircut_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc87\ud83c\udffd", "1f487-1f3fd.png", ":haircut_tone3:", ":person_getting_haircut_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc87\ud83c\udffe\u200d\u2640\ufe0f", "1f487-1f3fe-200d-2640-fe0f.png", ":woman_haircut_tone4:", ":woman_getting_haircut_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc87\ud83c\udffe\u200d\u2642\ufe0f", "1f487-1f3fe-200d-2642-fe0f.png", ":man_haircut_tone4:", ":man_getting_haircut_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc87\ud83c\udffe", "1f487-1f3fe.png", ":haircut_tone4:", ":person_getting_haircut_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc87\ud83c\udfff\u200d\u2640\ufe0f", "1f487-1f3ff-200d-2640-fe0f.png", ":woman_haircut_tone5:", ":woman_getting_haircut_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc87\ud83c\udfff\u200d\u2642\ufe0f", "1f487-1f3ff-200d-2642-fe0f.png", ":man_haircut_tone5:", ":man_getting_haircut_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc87\ud83c\udfff", "1f487-1f3ff.png", ":haircut_tone5:", ":person_getting_haircut_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc87\u200d\u2640\ufe0f", "1f487-200d-2640-fe0f.png", ":haircut_woman:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83d\udc87\u200d\u2642\ufe0f", "1f487-200d-2642-fe0f.png", ":haircut_man:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc87", "1f487.png", ":haircut:", ":person_getting_haircut:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc88", "1f488.png", ":barber:", ":barber_pole:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc89", "1f489.png", ":syringe:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc8a", "1f48a.png", ":pill:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc8b", "1f48b.png", ":kiss:", ":kiss_mark:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc8c", "1f48c.png", ":love_letter:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc8d", "1f48d.png", ":ring:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc8e", "1f48e.png", ":gem:", ":gem_stone:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc8f\ud83c\udffb", "1f48f-1f3fb.png", ":couplekiss_tone1:", ":kiss_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc8f\ud83c\udffc", "1f48f-1f3fc.png", ":couplekiss_tone2:", ":kiss_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc8f\ud83c\udffd", "1f48f-1f3fd.png", ":couplekiss_tone3:", ":kiss_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc8f\ud83c\udffe", "1f48f-1f3fe.png", ":couplekiss_tone4:", ":kiss_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc8f\ud83c\udfff", "1f48f-1f3ff.png", ":couplekiss_tone5:", ":kiss_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc8f", "1f48f.png", ":couplekiss:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc90", "1f490.png", ":bouquet:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc91\ud83c\udffb", "1f491-1f3fb.png", ":couple_with_heart_tone1:", ":couple_with_heart_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc91\ud83c\udffc", "1f491-1f3fc.png", ":couple_with_heart_tone2:", ":couple_with_heart_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc91\ud83c\udffd", "1f491-1f3fd.png", ":couple_with_heart_tone3:", ":couple_with_heart_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc91\ud83c\udffe", "1f491-1f3fe.png", ":couple_with_heart_tone4:", ":couple_with_heart_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc91\ud83c\udfff", "1f491-1f3ff.png", ":couple_with_heart_tone5:", ":couple_with_heart_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc91", "1f491.png", ":couple_with_heart:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc92", "1f492.png", ":wedding:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc93", "1f493.png", ":heartbeat:", ":beating_heart:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc94", "1f494.png", ":broken_heart:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc95", "1f495.png", ":two_hearts:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc96", "1f496.png", ":sparkling_heart:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc97", "1f497.png", ":heartpulse:", ":growing_heart:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc98", "1f498.png", ":cupid:", ":heart_with_arrow:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc99", "1f499.png", ":blue_heart:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc9a", "1f49a.png", ":green_heart:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc9b", "1f49b.png", ":yellow_heart:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc9c", "1f49c.png", ":purple_heart:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc9d", "1f49d.png", ":gift_heart:", ":heart_with_ribbon:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc9e", "1f49e.png", ":revolving_hearts:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc9f", "1f49f.png", ":heart_decoration:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udca0", "1f4a0.png", ":diamond_shape_with_a_dot_inside:", ":diamond_with_a_dot:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udca1", "1f4a1.png", ":bulb:", ":light_bulb:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udca2", "1f4a2.png", ":anger:", ":anger_symbol:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udca3", "1f4a3.png", ":bomb:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udca4", "1f4a4.png", ":zzz:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udca5", "1f4a5.png", ":boom:", ":collision:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udca6", "1f4a6.png", ":sweat_drops:", ":sweat_droplets:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udca7", "1f4a7.png", ":droplet:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udca8", "1f4a8.png", ":dash:", ":dashing_away:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udca9", "1f4a9.png", ":hankey:", ":poop:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcaa\ud83c\udffb", "1f4aa-1f3fb.png", ":muscle_tone1:", ":flexed_biceps_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcaa\ud83c\udffc", "1f4aa-1f3fc.png", ":muscle_tone2:", ":flexed_biceps_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcaa\ud83c\udffd", "1f4aa-1f3fd.png", ":muscle_tone3:", ":flexed_biceps_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcaa\ud83c\udffe", "1f4aa-1f3fe.png", ":muscle_tone4:", ":flexed_biceps_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcaa\ud83c\udfff", "1f4aa-1f3ff.png", ":muscle_tone5:", ":flexed_biceps_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcaa", "1f4aa.png", ":muscle:", ":flexed_biceps:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcab", "1f4ab.png", ":dizzy:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcac", "1f4ac.png", ":speech_balloon:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcad", "1f4ad.png", ":thought_balloon:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcae", "1f4ae.png", ":white_flower:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcaf", "1f4af.png", ":100:", ":hundred_points:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcb0", "1f4b0.png", ":moneybag:", ":money_bag:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcb1", "1f4b1.png", ":currency_exchange:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcb2", "1f4b2.png", ":heavy_dollar_sign:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcb3", "1f4b3.png", ":credit_card:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcb4", "1f4b4.png", ":yen:", ":yen_banknote:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcb5", "1f4b5.png", ":dollar:", ":dollar_banknote:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcb6", "1f4b6.png", ":euro:", ":euro_banknote:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcb7", "1f4b7.png", ":pound:", ":pound_banknote:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcb8", "1f4b8.png", ":money_with_wings:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcb9", "1f4b9.png", ":chart:", ":chart_increasing_with_yen:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcba", "1f4ba.png", ":seat:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcbb", "1f4bb.png", ":computer:", ":laptop:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcbc", "1f4bc.png", ":briefcase:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcbd", "1f4bd.png", ":minidisc:", ":computer_disk:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcbe", "1f4be.png", ":floppy_disk:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcbf", "1f4bf.png", ":cd:", ":optical_disk:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcc0", "1f4c0.png", ":dvd:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcc1", "1f4c1.png", ":file_folder:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcc2", "1f4c2.png", ":open_file_folder:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcc3", "1f4c3.png", ":page_with_curl:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcc4", "1f4c4.png", ":page_facing_up:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcc5", "1f4c5.png", ":date:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcc6", "1f4c6.png", ":calendar:", ":tear_off_calendar:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcc7", "1f4c7.png", ":card_index:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcc8", "1f4c8.png", ":chart_with_upwards_trend:", ":chart_increasing:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcc9", "1f4c9.png", ":chart_with_downwards_trend:", ":chart_decreasing:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcca", "1f4ca.png", ":bar_chart:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udccb", "1f4cb.png", ":clipboard:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udccc", "1f4cc.png", ":pushpin:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udccd", "1f4cd.png", ":round_pushpin:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcce", "1f4ce.png", ":paperclip:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udccf", "1f4cf.png", ":straight_ruler:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcd0", "1f4d0.png", ":triangular_ruler:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcd1", "1f4d1.png", ":bookmark_tabs:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcd2", "1f4d2.png", ":ledger:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcd3", "1f4d3.png", ":notebook:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcd4", "1f4d4.png", ":notebook_with_decorative_cover:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcd5", "1f4d5.png", ":closed_book:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcd6", "1f4d6.png", ":book:", ":open_book:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcd7", "1f4d7.png", ":green_book:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcd8", "1f4d8.png", ":blue_book:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcd9", "1f4d9.png", ":orange_book:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcda", "1f4da.png", ":books:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcdb", "1f4db.png", ":name_badge:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcdc", "1f4dc.png", ":scroll:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcdd", "1f4dd.png", ":memo:", ":pencil:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcde", "1f4de.png", ":telephone_receiver:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcdf", "1f4df.png", ":pager:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udce0", "1f4e0.png", ":fax:", ":fax_machine:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udce1", "1f4e1.png", ":satellite:", ":satellite_antenna:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udce2", "1f4e2.png", ":loudspeaker:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udce3", "1f4e3.png", ":mega:", ":megaphone:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udce4", "1f4e4.png", ":outbox_tray:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udce5", "1f4e5.png", ":inbox_tray:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udce6", "1f4e6.png", ":package:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udce7", "1f4e7.png", ":email:", ":e-mail:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udce8", "1f4e8.png", ":incoming_envelope:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udce9", "1f4e9.png", ":envelope_with_arrow:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcea", "1f4ea.png", ":mailbox_closed:", ":closed_mailbox_with_lowered_flag:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udceb", "1f4eb.png", ":mailbox:", ":closed_mailbox_with_raised_flag:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcec", "1f4ec.png", ":mailbox_with_mail:", ":open_mailbox_with_raised_flag:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udced", "1f4ed.png", ":mailbox_with_no_mail:", ":open_mailbox_with_lowered_flag:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcee", "1f4ee.png", ":postbox:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcef", "1f4ef.png", ":postal_horn:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcf0", "1f4f0.png", ":newspaper:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcf1", "1f4f1.png", ":iphone:", ":mobile_phone:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcf2", "1f4f2.png", ":calling:", ":mobile_phone_with_arrow:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcf3", "1f4f3.png", ":vibration_mode:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcf4", "1f4f4.png", ":mobile_phone_off:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcf5", "1f4f5.png", ":no_mobile_phones:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcf6", "1f4f6.png", ":signal_strength:", ":antenna_bars:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcf7", "1f4f7.png", ":camera:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcf8", "1f4f8.png", ":camera_flash:", ":camera_with_flash:", "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udcf9", "1f4f9.png", ":video_camera:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcfa", "1f4fa.png", ":tv:", ":television:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcfb", "1f4fb.png", ":radio:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcfc", "1f4fc.png", ":vhs:", ":videocassette:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcfd", "1f4fd.png", ":film_projector:", ":projector:", "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udcff", "1f4ff.png", ":prayer_beads:", null, "Objects", "8.0");
        EmojiUtil.add(set, result, "\ud83d\udd00", "1f500.png", ":twisted_rightwards_arrows:", ":shuffle_tracks_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd01", "1f501.png", ":repeat:", ":repeat_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd02", "1f502.png", ":repeat_one:", ":repeat_single_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd03", "1f503.png", ":arrows_clockwise:", ":clockwise_vertical_arrows:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd04", "1f504.png", ":arrows_counterclockwise:", ":counterclockwise_arrows_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd05", "1f505.png", ":low_brightness:", ":dim_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd06", "1f506.png", ":high_brightness:", ":bright_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd07", "1f507.png", ":mute:", ":muted_speaker:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd08", "1f508.png", ":speaker:", ":speaker_low_volume:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd09", "1f509.png", ":sound:", ":speaker_medium_volume:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd0a", "1f50a.png", ":loud_sound:", ":speaker_high_volume:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd0b", "1f50b.png", ":battery:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd0c", "1f50c.png", ":electric_plug:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd0d", "1f50d.png", ":mag:", ":magnifying_glass_tilted_left:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd0e", "1f50e.png", ":mag_right:", ":magnifying_glass_tilted_right:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd0f", "1f50f.png", ":lock_with_ink_pen:", ":locked_with_pen:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd10", "1f510.png", ":closed_lock_with_key:", ":locked_with_key:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd11", "1f511.png", ":key:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd12", "1f512.png", ":lock:", ":locked:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd13", "1f513.png", ":unlock:", ":unlocked:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd14", "1f514.png", ":bell:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd15", "1f515.png", ":no_bell:", ":bell_with_slash:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd16", "1f516.png", ":bookmark:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd17", "1f517.png", ":link:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd18", "1f518.png", ":radio_button:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd19", "1f519.png", ":back:", ":back_arrow:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd1a", "1f51a.png", ":end:", ":end_arrow:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd1b", "1f51b.png", ":on:", ":on_arrow:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd1c", "1f51c.png", ":soon:", ":soon_arrow:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd1d", "1f51d.png", ":top:", ":top_arrow:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd1e", "1f51e.png", ":underage:", ":no_one_under_eighteen:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd1f", "1f51f.png", ":keycap_ten:", ":keycap_10:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd20", "1f520.png", ":capital_abcd:", ":input_latin_uppercase:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd21", "1f521.png", ":abcd:", ":input_latin_lowercase:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd22", "1f522.png", ":1234:", ":input_numbers:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd23", "1f523.png", ":symbols:", ":input_symbols:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd24", "1f524.png", ":abc:", ":input_latin_letters:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd25", "1f525.png", ":fire:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd26", "1f526.png", ":flashlight:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd27", "1f527.png", ":wrench:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd28", "1f528.png", ":hammer:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd29", "1f529.png", ":nut_and_bolt:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd2a", "1f52a.png", ":hocho:", ":knife:", "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd2b", "1f52b.png", ":gun:", ":water_pistol:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd2c", "1f52c.png", ":microscope:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd2d", "1f52d.png", ":telescope:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd2e", "1f52e.png", ":crystal_ball:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd2f", "1f52f.png", ":six_pointed_star:", ":dotted_six_pointed_star:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd30", "1f530.png", ":beginner:", ":japanese_symbol_for_beginner:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd31", "1f531.png", ":trident:", ":trident_emblem:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd32", "1f532.png", ":black_square_button:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd33", "1f533.png", ":white_square_button:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd34", "1f534.png", ":red_circle:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd35", "1f535.png", ":large_blue_circle:", ":blue_circle:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd36", "1f536.png", ":large_orange_diamond:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd37", "1f537.png", ":large_blue_diamond:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd38", "1f538.png", ":small_orange_diamond:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd39", "1f539.png", ":small_blue_diamond:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd3a", "1f53a.png", ":small_red_triangle:", ":red_triangle_pointed_up:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd3b", "1f53b.png", ":small_red_triangle_down:", ":red_triangle_pointed_down:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd3c", "1f53c.png", ":arrow_up_small:", ":upwards_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd3d", "1f53d.png", ":arrow_down_small:", ":downwards_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd49", "1f549.png", ":om:", ":om_symbol:", "Symbols", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd4a", "1f54a.png", ":dove:", null, "Animals & Nature", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd4b", "1f54b.png", ":kaaba:", null, "Travel & Places", "8.0");
        EmojiUtil.add(set, result, "\ud83d\udd4c", "1f54c.png", ":mosque:", null, "Travel & Places", "8.0");
        EmojiUtil.add(set, result, "\ud83d\udd4d", "1f54d.png", ":synagogue:", null, "Travel & Places", "8.0");
        EmojiUtil.add(set, result, "\ud83d\udd4e", "1f54e.png", ":menorah:", null, "Symbols", "8.0");
        EmojiUtil.add(set, result, "\ud83d\udd50", "1f550.png", ":clock1:", ":one_oclock:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd51", "1f551.png", ":clock2:", ":two_oclock:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd52", "1f552.png", ":clock3:", ":three_oclock:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd53", "1f553.png", ":clock4:", ":four_oclock:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd54", "1f554.png", ":clock5:", ":five_oclock:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd55", "1f555.png", ":clock6:", ":six_oclock:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd56", "1f556.png", ":clock7:", ":seven_oclock:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd57", "1f557.png", ":clock8:", ":eight_oclock:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd58", "1f558.png", ":clock9:", ":nine_oclock:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd59", "1f559.png", ":clock10:", ":ten_oclock:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd5a", "1f55a.png", ":clock11:", ":eleven_oclock:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd5b", "1f55b.png", ":clock12:", ":twelve_oclock:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd5c", "1f55c.png", ":clock130:", ":one_thirty:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd5d", "1f55d.png", ":clock230:", ":two_thirty:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd5e", "1f55e.png", ":clock330:", ":three_thirty:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd5f", "1f55f.png", ":clock430:", ":four_thirty:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd60", "1f560.png", ":clock530:", ":five_thirty:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd61", "1f561.png", ":clock630:", ":six_thirty:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd62", "1f562.png", ":clock730:", ":seven_thirty:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd63", "1f563.png", ":clock830:", ":eight_thirty:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd64", "1f564.png", ":clock930:", ":nine_thirty:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd65", "1f565.png", ":clock1030:", ":ten_thirty:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd66", "1f566.png", ":clock1130:", ":eleven_thirty:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd67", "1f567.png", ":clock1230:", ":twelve_thirty:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd6f", "1f56f.png", ":candle:", null, "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd70", "1f570.png", ":mantelpiece_clock:", ":clock:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd73", "1f573.png", ":hole:", null, "Smileys & Emotion", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd74\ud83c\udffb\u200d\u2640\ufe0f", "1f574-1f3fb-200d-2640-fe0f.png", ":woman_business_suit_levitating_tone1:", null, "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd74\ud83c\udffb\u200d\u2642\ufe0f", "1f574-1f3fb-200d-2642-fe0f.png", ":man_business_suit_levitating_tone1:", null, "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd74\ud83c\udffb", "1f574-1f3fb.png", ":business_suit_levitating_tone1:", ":levitate_tone1:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd74\ud83c\udffc\u200d\u2640\ufe0f", "1f574-1f3fc-200d-2640-fe0f.png", ":woman_business_suit_levitating_tone2:", null, "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd74\ud83c\udffc\u200d\u2642\ufe0f", "1f574-1f3fc-200d-2642-fe0f.png", ":man_business_suit_levitating_tone2:", null, "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd74\ud83c\udffc", "1f574-1f3fc.png", ":business_suit_levitating_tone2:", ":levitate_tone2:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd74\ud83c\udffd\u200d\u2640\ufe0f", "1f574-1f3fd-200d-2640-fe0f.png", ":woman_business_suit_levitating_tone3:", null, "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd74\ud83c\udffd\u200d\u2642\ufe0f", "1f574-1f3fd-200d-2642-fe0f.png", ":man_business_suit_levitating_tone3:", null, "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd74\ud83c\udffd", "1f574-1f3fd.png", ":business_suit_levitating_tone3:", ":levitate_tone3:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd74\ud83c\udffe\u200d\u2640\ufe0f", "1f574-1f3fe-200d-2640-fe0f.png", ":woman_business_suit_levitating_tone4:", null, "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd74\ud83c\udffe\u200d\u2642\ufe0f", "1f574-1f3fe-200d-2642-fe0f.png", ":man_business_suit_levitating_tone4:", null, "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd74\ud83c\udffe", "1f574-1f3fe.png", ":business_suit_levitating_tone4:", ":levitate_tone4:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd74\ud83c\udfff\u200d\u2640\ufe0f", "1f574-1f3ff-200d-2640-fe0f.png", ":woman_business_suit_levitating_tone5:", null, "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd74\ud83c\udfff\u200d\u2642\ufe0f", "1f574-1f3ff-200d-2642-fe0f.png", ":man_business_suit_levitating_tone5:", null, "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd74\ud83c\udfff", "1f574-1f3ff.png", ":business_suit_levitating_tone5:", ":levitate_tone5:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd74\ufe0f\u200d\u2640\ufe0f", "1f574-fe0f-200d-2640-fe0f.png", ":woman_business_suit_levitating:", null, "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd74\ufe0f\u200d\u2642\ufe0f", "1f574-fe0f-200d-2642-fe0f.png", ":man_business_suit_levitating:", null, "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd74", "1f574.png", ":business_suit_levitating:", ":levitate:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd75\ud83c\udffb\u200d\u2640\ufe0f", "1f575-1f3fb-200d-2640-fe0f.png", ":woman_detective_tone1:", ":woman_detective_light_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd75\ud83c\udffb\u200d\u2642\ufe0f", "1f575-1f3fb-200d-2642-fe0f.png", ":man_detective_tone1:", ":man_detective_light_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd75\ud83c\udffb", "1f575-1f3fb.png", ":detective_tone1:", ":detective_light_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd75\ud83c\udffc\u200d\u2640\ufe0f", "1f575-1f3fc-200d-2640-fe0f.png", ":woman_detective_tone2:", ":woman_detective_medium_light_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd75\ud83c\udffc\u200d\u2642\ufe0f", "1f575-1f3fc-200d-2642-fe0f.png", ":man_detective_tone2:", ":man_detective_medium_light_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd75\ud83c\udffc", "1f575-1f3fc.png", ":detective_tone2:", ":detective_medium_light_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd75\ud83c\udffd\u200d\u2640\ufe0f", "1f575-1f3fd-200d-2640-fe0f.png", ":woman_detective_tone3:", ":woman_detective_medium_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd75\ud83c\udffd\u200d\u2642\ufe0f", "1f575-1f3fd-200d-2642-fe0f.png", ":man_detective_tone3:", ":man_detective_medium_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd75\ud83c\udffd", "1f575-1f3fd.png", ":detective_tone3:", ":detective_medium_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd75\ud83c\udffe\u200d\u2640\ufe0f", "1f575-1f3fe-200d-2640-fe0f.png", ":woman_detective_tone4:", ":woman_detective_medium_dark_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd75\ud83c\udffe\u200d\u2642\ufe0f", "1f575-1f3fe-200d-2642-fe0f.png", ":man_detective_tone4:", ":man_detective_medium_dark_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd75\ud83c\udffe", "1f575-1f3fe.png", ":detective_tone4:", ":detective_medium_dark_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd75\ud83c\udfff\u200d\u2640\ufe0f", "1f575-1f3ff-200d-2640-fe0f.png", ":woman_detective_tone5:", ":woman_detective_dark_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd75\ud83c\udfff\u200d\u2642\ufe0f", "1f575-1f3ff-200d-2642-fe0f.png", ":man_detective_tone5:", ":man_detective_dark_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd75\ud83c\udfff", "1f575-1f3ff.png", ":detective_tone5:", ":detective_dark_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd75\ufe0f\u200d\u2640\ufe0f", "1f575-fe0f-200d-2640-fe0f.png", ":female_detective:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd75\ufe0f\u200d\u2642\ufe0f", "1f575-fe0f-200d-2642-fe0f.png", ":male_detective:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83d\udd75", "1f575.png", ":detective:", null, "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd76", "1f576.png", ":dark_sunglasses:", null, "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd77", "1f577.png", ":spider:", null, "Animals & Nature", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd78", "1f578.png", ":spider_web:", null, "Animals & Nature", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd79", "1f579.png", ":joystick:", null, "Activities", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd7a\ud83c\udffb", "1f57a-1f3fb.png", ":man_dancing_tone1:", ":man_dancing_light_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83d\udd7a\ud83c\udffc", "1f57a-1f3fc.png", ":man_dancing_tone2:", ":man_dancing_medium_light_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83d\udd7a\ud83c\udffd", "1f57a-1f3fd.png", ":man_dancing_tone3:", ":man_dancing_medium_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83d\udd7a\ud83c\udffe", "1f57a-1f3fe.png", ":man_dancing_tone4:", ":man_dancing_medium_dark_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83d\udd7a\ud83c\udfff", "1f57a-1f3ff.png", ":man_dancing_tone5:", ":man_dancing_dark_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83d\udd7a", "1f57a.png", ":man_dancing:", null, "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83d\udd87", "1f587.png", ":paperclips:", null, "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd8a", "1f58a.png", ":pen:", ":pen_ballpoint:", "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd8b", "1f58b.png", ":fountain_pen:", ":pen_fountain:", "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd8c", "1f58c.png", ":paintbrush:", null, "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd8d", "1f58d.png", ":crayon:", null, "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd90\ud83c\udffb", "1f590-1f3fb.png", ":raised_hand_with_fingers_splayed_tone1:", ":hand_splayed_tone1:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd90\ud83c\udffc", "1f590-1f3fc.png", ":raised_hand_with_fingers_splayed_tone2:", ":hand_splayed_tone2:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd90\ud83c\udffd", "1f590-1f3fd.png", ":raised_hand_with_fingers_splayed_tone3:", ":hand_splayed_tone3:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd90\ud83c\udffe", "1f590-1f3fe.png", ":raised_hand_with_fingers_splayed_tone4:", ":hand_splayed_tone4:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd90\ud83c\udfff", "1f590-1f3ff.png", ":raised_hand_with_fingers_splayed_tone5:", ":hand_splayed_tone5:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd90", "1f590.png", ":raised_hand_with_fingers_splayed:", ":hand_splayed:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd95\ud83c\udffb", "1f595-1f3fb.png", ":middle_finger_tone1:", ":middle_finger_light_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd95\ud83c\udffc", "1f595-1f3fc.png", ":middle_finger_tone2:", ":middle_finger_medium_light_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd95\ud83c\udffd", "1f595-1f3fd.png", ":middle_finger_tone3:", ":middle_finger_medium_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd95\ud83c\udffe", "1f595-1f3fe.png", ":middle_finger_tone4:", ":middle_finger_medium_dark_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd95\ud83c\udfff", "1f595-1f3ff.png", ":middle_finger_tone5:", ":middle_finger_dark_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd95", "1f595.png", ":middle_finger:", null, "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd96\ud83c\udffb", "1f596-1f3fb.png", ":vulcan_salute_tone1:", ":vulcan_tone1:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd96\ud83c\udffc", "1f596-1f3fc.png", ":vulcan_salute_tone2:", ":vulcan_tone2:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd96\ud83c\udffd", "1f596-1f3fd.png", ":vulcan_salute_tone3:", ":vulcan_tone3:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd96\ud83c\udffe", "1f596-1f3fe.png", ":vulcan_salute_tone4:", ":vulcan_tone4:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd96\ud83c\udfff", "1f596-1f3ff.png", ":vulcan_salute_tone5:", ":vulcan_tone5:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd96", "1f596.png", ":vulcan_salute:", ":vulcan:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udda4", "1f5a4.png", ":black_heart:", null, "Smileys & Emotion", "9.0");
        EmojiUtil.add(set, result, "\ud83d\udda5", "1f5a5.png", ":desktop_computer:", ":desktop:", "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udda8", "1f5a8.png", ":printer:", null, "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\uddb1", "1f5b1.png", ":computer_mouse:", ":mouse_three_button:", "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\uddb2", "1f5b2.png", ":trackball:", null, "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\uddbc", "1f5bc.png", ":framed_picture:", ":frame_photo:", "Activities", "7.0");
        EmojiUtil.add(set, result, "\ud83d\uddc2", "1f5c2.png", ":card_index_dividers:", ":dividers:", "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\uddc3", "1f5c3.png", ":card_file_box:", ":card_box:", "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\uddc4", "1f5c4.png", ":file_cabinet:", null, "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\uddd1", "1f5d1.png", ":wastebasket:", null, "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\uddd2", "1f5d2.png", ":spiral_notepad:", ":notepad_spiral:", "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\uddd3", "1f5d3.png", ":spiral_calendar:", ":calendar_spiral:", "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udddc", "1f5dc.png", ":clamp:", ":compression:", "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udddd", "1f5dd.png", ":old_key:", ":key2:", "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\uddde", "1f5de.png", ":newspaper_roll:", ":newspaper2:", "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udde1", "1f5e1.png", ":dagger:", null, "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udde3", "1f5e3.png", ":speaking_head:", null, "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udde8", "1f5e8.png", ":left_speech_bubble:", ":speech_left:", "Smileys & Emotion", "11.0");
        EmojiUtil.add(set, result, "\ud83d\uddef", "1f5ef.png", ":right_anger_bubble:", ":anger_right:", "Smileys & Emotion", "7.0");
        EmojiUtil.add(set, result, "\ud83d\uddf3", "1f5f3.png", ":ballot_box:", null, "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\uddfa", "1f5fa.png", ":world_map:", ":map:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83d\uddfb", "1f5fb.png", ":mount_fuji:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\uddfc", "1f5fc.png", ":tokyo_tower:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\uddfd", "1f5fd.png", ":statue_of_liberty:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\uddfe", "1f5fe.png", ":japan:", ":map_of_japan:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\uddff", "1f5ff.png", ":moyai:", ":moai:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude00", "1f600.png", ":grinning:", ":grinning_face:", "Smileys & Emotion", "6.1");
        EmojiUtil.add(set, result, "\ud83d\ude01", "1f601.png", ":grin:", ":beaming_face_with_smiling_eyes:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude02", "1f602.png", ":joy:", ":face_with_tears_of_joy:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude03", "1f603.png", ":smiley:", ":grinning_face_with_big_eyes:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude04", "1f604.png", ":smile:", ":grinning_face_with_smiling_eyes:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude05", "1f605.png", ":sweat_smile:", ":grinning_face_with_sweat:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude06", "1f606.png", ":laughing:", ":grinning_squinting_face:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude07", "1f607.png", ":innocent:", ":smiling_face_with_halo:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude08", "1f608.png", ":smiling_imp:", ":smiling_face_with_horns:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude09", "1f609.png", ":wink:", ":winking_face:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude0a", "1f60a.png", ":blush:", ":smiling_face_with_smiling_eyes:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude0b", "1f60b.png", ":yum:", ":face_savoring_food:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude0c", "1f60c.png", ":relieved:", ":relieved_face:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude0d", "1f60d.png", ":heart_eyes:", ":smiling_face_with_heart_eyes:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude0e", "1f60e.png", ":sunglasses:", ":smiling_face_with_sunglasses:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude0f", "1f60f.png", ":smirk:", ":smirking_face:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude10", "1f610.png", ":neutral_face:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude11", "1f611.png", ":expressionless:", ":expressionless_face:", "Smileys & Emotion", "6.1");
        EmojiUtil.add(set, result, "\ud83d\ude12", "1f612.png", ":unamused:", ":unamused_face:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude13", "1f613.png", ":sweat:", ":downcast_face_with_sweat:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude14", "1f614.png", ":pensive:", ":pensive_face:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude15", "1f615.png", ":confused:", ":confused_face:", "Smileys & Emotion", "6.1");
        EmojiUtil.add(set, result, "\ud83d\ude16", "1f616.png", ":confounded:", ":confounded_face:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude17", "1f617.png", ":kissing:", ":kissing_face:", "Smileys & Emotion", "6.1");
        EmojiUtil.add(set, result, "\ud83d\ude18", "1f618.png", ":kissing_heart:", ":face_blowing_a_kiss:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude19", "1f619.png", ":kissing_smiling_eyes:", ":kissing_face_with_smiling_eyes:", "Smileys & Emotion", "6.1");
        EmojiUtil.add(set, result, "\ud83d\ude1a", "1f61a.png", ":kissing_closed_eyes:", ":kissing_face_with_closed_eyes:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude1b", "1f61b.png", ":stuck_out_tongue:", ":face_with_tongue:", "Smileys & Emotion", "6.1");
        EmojiUtil.add(set, result, "\ud83d\ude1c", "1f61c.png", ":stuck_out_tongue_winking_eye:", ":winking_face_with_tongue:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude1d", "1f61d.png", ":stuck_out_tongue_closed_eyes:", ":squinting_face_with_tongue:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude1e", "1f61e.png", ":disappointed:", ":disappointed_face:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude1f", "1f61f.png", ":worried:", ":worried_face:", "Smileys & Emotion", "6.1");
        EmojiUtil.add(set, result, "\ud83d\ude20", "1f620.png", ":angry:", ":angry_face:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude21", "1f621.png", ":rage:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude22", "1f622.png", ":cry:", ":crying_face:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude23", "1f623.png", ":persevere:", ":persevering_face:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude24", "1f624.png", ":triumph:", ":face_with_steam_from_nose:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude25", "1f625.png", ":disappointed_relieved:", ":sad_but_relieved_face:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude26", "1f626.png", ":frowning:", ":frowning_face_with_open_mouth:", "Smileys & Emotion", "6.1");
        EmojiUtil.add(set, result, "\ud83d\ude27", "1f627.png", ":anguished:", ":anguished_face:", "Smileys & Emotion", "6.1");
        EmojiUtil.add(set, result, "\ud83d\ude28", "1f628.png", ":fearful:", ":fearful_face:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude29", "1f629.png", ":weary:", ":weary_face:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude2a", "1f62a.png", ":sleepy:", ":sleepy_face:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude2b", "1f62b.png", ":tired_face:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude2c", "1f62c.png", ":grimacing:", ":grimacing_face:", "Smileys & Emotion", "6.1");
        EmojiUtil.add(set, result, "\ud83d\ude2d", "1f62d.png", ":sob:", ":loudly_crying_face:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude2e\u200d\ud83d\udca8", "1f62e-200d-1f4a8.png", ":face_exhaling:", null, "Smileys & Emotion", "13.1");
        EmojiUtil.add(set, result, "\ud83d\ude2e", "1f62e.png", ":open_mouth:", ":face_with_open_mouth:", "Smileys & Emotion", "6.1");
        EmojiUtil.add(set, result, "\ud83d\ude2f", "1f62f.png", ":hushed:", ":hushed_face:", "Smileys & Emotion", "6.1");
        EmojiUtil.add(set, result, "\ud83d\ude30", "1f630.png", ":cold_sweat:", ":anxious_face_with_sweat:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude31", "1f631.png", ":scream:", ":face_screaming_in_fear:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude32", "1f632.png", ":astonished:", ":astonished_face:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude33", "1f633.png", ":flushed:", ":flushed_face:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude34", "1f634.png", ":sleeping:", ":sleeping_face:", "Smileys & Emotion", "6.1");
        EmojiUtil.add(set, result, "\ud83d\ude35\u200d\ud83d\udcab", "1f635-200d-1f4ab.png", ":face_with_spiral_eyes:", null, "Smileys & Emotion", "13.1");
        EmojiUtil.add(set, result, "\ud83d\ude35", "1f635.png", ":dizzy_face:", ":face_with_crossed_out_eyes:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude36\u200d\ud83c\udf2b\ufe0f", "1f636-200d-1f32b-fe0f.png", ":face_in_clouds:", null, "Smileys & Emotion", "13.1");
        EmojiUtil.add(set, result, "\ud83d\ude36", "1f636.png", ":no_mouth:", ":face_without_mouth:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude37", "1f637.png", ":mask:", ":face_with_medical_mask:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude38", "1f638.png", ":smile_cat:", ":grinning_cat_with_smiling_eyes:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude39", "1f639.png", ":joy_cat:", ":cat_with_tears_of_joy:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude3a", "1f63a.png", ":smiley_cat:", ":grinning_cat:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude3b", "1f63b.png", ":heart_eyes_cat:", ":smiling_cat_with_heart_eyes:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude3c", "1f63c.png", ":smirk_cat:", ":cat_with_wry_smile:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude3d", "1f63d.png", ":kissing_cat:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude3e", "1f63e.png", ":pouting_cat:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude3f", "1f63f.png", ":crying_cat_face:", ":crying_cat:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude40", "1f640.png", ":scream_cat:", ":weary_cat:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude41", "1f641.png", ":slightly_frowning_face:", ":slight_frown:", "Smileys & Emotion", "7.0");
        EmojiUtil.add(set, result, "\ud83d\ude42", "1f642.png", ":slightly_smiling_face:", ":slight_smile:", "Smileys & Emotion", "7.0");
        EmojiUtil.add(set, result, "\ud83d\ude43", "1f643.png", ":upside_down_face:", ":upside_down:", "Smileys & Emotion", "8.0");
        EmojiUtil.add(set, result, "\ud83d\ude44", "1f644.png", ":roll_eyes:", ":rolling_eyes:", "Smileys & Emotion", "8.0");
        EmojiUtil.add(set, result, "\ud83d\ude45\ud83c\udffb\u200d\u2640\ufe0f", "1f645-1f3fb-200d-2640-fe0f.png", ":woman_no_good_tone1:", ":woman_gesturing_no_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude45\ud83c\udffb\u200d\u2642\ufe0f", "1f645-1f3fb-200d-2642-fe0f.png", ":man_no_good_tone1:", ":man_gesturing_no_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude45\ud83c\udffb", "1f645-1f3fb.png", ":no_good_tone1:", ":person_gesturing_no_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude45\ud83c\udffc\u200d\u2640\ufe0f", "1f645-1f3fc-200d-2640-fe0f.png", ":woman_no_good_tone2:", ":woman_gesturing_no_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude45\ud83c\udffc\u200d\u2642\ufe0f", "1f645-1f3fc-200d-2642-fe0f.png", ":man_no_good_tone2:", ":man_gesturing_no_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude45\ud83c\udffc", "1f645-1f3fc.png", ":no_good_tone2:", ":person_gesturing_no_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude45\ud83c\udffd\u200d\u2640\ufe0f", "1f645-1f3fd-200d-2640-fe0f.png", ":woman_no_good_tone3:", ":woman_gesturing_no_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude45\ud83c\udffd\u200d\u2642\ufe0f", "1f645-1f3fd-200d-2642-fe0f.png", ":man_no_good_tone3:", ":man_gesturing_no_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude45\ud83c\udffd", "1f645-1f3fd.png", ":no_good_tone3:", ":person_gesturing_no_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude45\ud83c\udffe\u200d\u2640\ufe0f", "1f645-1f3fe-200d-2640-fe0f.png", ":woman_no_good_tone4:", ":woman_gesturing_no_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude45\ud83c\udffe\u200d\u2642\ufe0f", "1f645-1f3fe-200d-2642-fe0f.png", ":man_no_good_tone4:", ":man_gesturing_no_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude45\ud83c\udffe", "1f645-1f3fe.png", ":no_good_tone4:", ":person_gesturing_no_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude45\ud83c\udfff\u200d\u2640\ufe0f", "1f645-1f3ff-200d-2640-fe0f.png", ":woman_no_good_tone5:", ":woman_gesturing_no_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude45\ud83c\udfff\u200d\u2642\ufe0f", "1f645-1f3ff-200d-2642-fe0f.png", ":man_no_good_tone5:", ":man_gesturing_no_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude45\ud83c\udfff", "1f645-1f3ff.png", ":no_good_tone5:", ":person_gesturing_no_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude45\u200d\u2640\ufe0f", "1f645-200d-2640-fe0f.png", ":no_good_woman:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83d\ude45\u200d\u2642\ufe0f", "1f645-200d-2642-fe0f.png", ":no_good_man:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude45", "1f645.png", ":no_good:", ":person_gesturing_no:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude46\ud83c\udffb\u200d\u2640\ufe0f", "1f646-1f3fb-200d-2640-fe0f.png", ":woman_ok_person_tone1:", ":woman_gesturing_ok_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude46\ud83c\udffb\u200d\u2642\ufe0f", "1f646-1f3fb-200d-2642-fe0f.png", ":man_ok_person_tone1:", ":man_gesturing_ok_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude46\ud83c\udffb", "1f646-1f3fb.png", ":ok_person_tone1:", ":person_gesturing_ok_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude46\ud83c\udffc\u200d\u2640\ufe0f", "1f646-1f3fc-200d-2640-fe0f.png", ":woman_ok_person_tone2:", ":woman_gesturing_ok_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude46\ud83c\udffc\u200d\u2642\ufe0f", "1f646-1f3fc-200d-2642-fe0f.png", ":man_ok_person_tone2:", ":man_gesturing_ok_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude46\ud83c\udffc", "1f646-1f3fc.png", ":ok_person_tone2:", ":person_gesturing_ok_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude46\ud83c\udffd\u200d\u2640\ufe0f", "1f646-1f3fd-200d-2640-fe0f.png", ":woman_ok_person_tone3:", ":woman_gesturing_ok_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude46\ud83c\udffd\u200d\u2642\ufe0f", "1f646-1f3fd-200d-2642-fe0f.png", ":man_ok_person_tone3:", ":man_gesturing_ok_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude46\ud83c\udffd", "1f646-1f3fd.png", ":ok_person_tone3:", ":person_gesturing_ok_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude46\ud83c\udffe\u200d\u2640\ufe0f", "1f646-1f3fe-200d-2640-fe0f.png", ":woman_ok_person_tone4:", ":woman_gesturing_ok_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude46\ud83c\udffe\u200d\u2642\ufe0f", "1f646-1f3fe-200d-2642-fe0f.png", ":man_ok_person_tone4:", ":man_gesturing_ok_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude46\ud83c\udffe", "1f646-1f3fe.png", ":ok_person_tone4:", ":person_gesturing_ok_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude46\ud83c\udfff\u200d\u2640\ufe0f", "1f646-1f3ff-200d-2640-fe0f.png", ":woman_ok_person_tone5:", ":woman_gesturing_ok_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude46\ud83c\udfff\u200d\u2642\ufe0f", "1f646-1f3ff-200d-2642-fe0f.png", ":man_ok_person_tone5:", ":man_gesturing_ok_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude46\ud83c\udfff", "1f646-1f3ff.png", ":ok_person_tone5:", ":person_gesturing_ok_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude46\u200d\u2640\ufe0f", "1f646-200d-2640-fe0f.png", ":ok_woman:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83d\ude46\u200d\u2642\ufe0f", "1f646-200d-2642-fe0f.png", ":ok_man:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude46", "1f646.png", ":ok_person:", ":person_gesturing_ok:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude47\ud83c\udffb\u200d\u2640\ufe0f", "1f647-1f3fb-200d-2640-fe0f.png", ":woman_bow_tone1:", ":woman_bowing_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude47\ud83c\udffb\u200d\u2642\ufe0f", "1f647-1f3fb-200d-2642-fe0f.png", ":man_bow_tone1:", ":man_bowing_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude47\ud83c\udffb", "1f647-1f3fb.png", ":bow_tone1:", ":person_bowing_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude47\ud83c\udffc\u200d\u2640\ufe0f", "1f647-1f3fc-200d-2640-fe0f.png", ":woman_bow_tone2:", ":woman_bowing_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude47\ud83c\udffc\u200d\u2642\ufe0f", "1f647-1f3fc-200d-2642-fe0f.png", ":man_bow_tone2:", ":man_bowing_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude47\ud83c\udffc", "1f647-1f3fc.png", ":bow_tone2:", ":person_bowing_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude47\ud83c\udffd\u200d\u2640\ufe0f", "1f647-1f3fd-200d-2640-fe0f.png", ":woman_bow_tone3:", ":woman_bowing_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude47\ud83c\udffd\u200d\u2642\ufe0f", "1f647-1f3fd-200d-2642-fe0f.png", ":man_bow_tone3:", ":man_bowing_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude47\ud83c\udffd", "1f647-1f3fd.png", ":bow_tone3:", ":person_bowing_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude47\ud83c\udffe\u200d\u2640\ufe0f", "1f647-1f3fe-200d-2640-fe0f.png", ":woman_bow_tone4:", ":woman_bowing_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude47\ud83c\udffe\u200d\u2642\ufe0f", "1f647-1f3fe-200d-2642-fe0f.png", ":man_bow_tone4:", ":man_bowing_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude47\ud83c\udffe", "1f647-1f3fe.png", ":bow_tone4:", ":person_bowing_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude47\ud83c\udfff\u200d\u2640\ufe0f", "1f647-1f3ff-200d-2640-fe0f.png", ":woman_bow_tone5:", ":woman_bowing_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude47\ud83c\udfff\u200d\u2642\ufe0f", "1f647-1f3ff-200d-2642-fe0f.png", ":man_bow_tone5:", ":man_bowing_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude47\ud83c\udfff", "1f647-1f3ff.png", ":bow_tone5:", ":person_bowing_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude47\u200d\u2640\ufe0f", "1f647-200d-2640-fe0f.png", ":bowing_woman:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude47\u200d\u2642\ufe0f", "1f647-200d-2642-fe0f.png", ":bowing_man:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83d\ude47", "1f647.png", ":bow:", ":person_bowing:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude48", "1f648.png", ":see_no_evil:", ":see_no_evil_monkey:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude49", "1f649.png", ":hear_no_evil:", ":hear_no_evil_monkey:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4a", "1f64a.png", ":speak_no_evil:", ":speak_no_evil_monkey:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4b\ud83c\udffb\u200d\u2640\ufe0f", "1f64b-1f3fb-200d-2640-fe0f.png", ":woman_raising_hand_tone1:", ":woman_raising_hand_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4b\ud83c\udffb\u200d\u2642\ufe0f", "1f64b-1f3fb-200d-2642-fe0f.png", ":man_raising_hand_tone1:", ":man_raising_hand_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4b\ud83c\udffb", "1f64b-1f3fb.png", ":raising_hand_tone1:", ":person_raising_hand_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4b\ud83c\udffc\u200d\u2640\ufe0f", "1f64b-1f3fc-200d-2640-fe0f.png", ":woman_raising_hand_tone2:", ":woman_raising_hand_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4b\ud83c\udffc\u200d\u2642\ufe0f", "1f64b-1f3fc-200d-2642-fe0f.png", ":man_raising_hand_tone2:", ":man_raising_hand_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4b\ud83c\udffc", "1f64b-1f3fc.png", ":raising_hand_tone2:", ":person_raising_hand_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4b\ud83c\udffd\u200d\u2640\ufe0f", "1f64b-1f3fd-200d-2640-fe0f.png", ":woman_raising_hand_tone3:", ":woman_raising_hand_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4b\ud83c\udffd\u200d\u2642\ufe0f", "1f64b-1f3fd-200d-2642-fe0f.png", ":man_raising_hand_tone3:", ":man_raising_hand_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4b\ud83c\udffd", "1f64b-1f3fd.png", ":raising_hand_tone3:", ":person_raising_hand_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4b\ud83c\udffe\u200d\u2640\ufe0f", "1f64b-1f3fe-200d-2640-fe0f.png", ":woman_raising_hand_tone4:", ":woman_raising_hand_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4b\ud83c\udffe\u200d\u2642\ufe0f", "1f64b-1f3fe-200d-2642-fe0f.png", ":man_raising_hand_tone4:", ":man_raising_hand_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4b\ud83c\udffe", "1f64b-1f3fe.png", ":raising_hand_tone4:", ":person_raising_hand_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4b\ud83c\udfff\u200d\u2640\ufe0f", "1f64b-1f3ff-200d-2640-fe0f.png", ":woman_raising_hand_tone5:", ":woman_raising_hand_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4b\ud83c\udfff\u200d\u2642\ufe0f", "1f64b-1f3ff-200d-2642-fe0f.png", ":man_raising_hand_tone5:", ":man_raising_hand_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4b\ud83c\udfff", "1f64b-1f3ff.png", ":raising_hand_tone5:", ":person_raising_hand_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4b\u200d\u2640\ufe0f", "1f64b-200d-2640-fe0f.png", ":raising_hand_woman:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83d\ude4b\u200d\u2642\ufe0f", "1f64b-200d-2642-fe0f.png", ":raising_hand_man:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4b", "1f64b.png", ":raising_hand:", ":person_raising_hand:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4c\ud83c\udffb", "1f64c-1f3fb.png", ":raised_hands_tone1:", ":raising_hands_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4c\ud83c\udffc", "1f64c-1f3fc.png", ":raised_hands_tone2:", ":raising_hands_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4c\ud83c\udffd", "1f64c-1f3fd.png", ":raised_hands_tone3:", ":raising_hands_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4c\ud83c\udffe", "1f64c-1f3fe.png", ":raised_hands_tone4:", ":raising_hands_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4c\ud83c\udfff", "1f64c-1f3ff.png", ":raised_hands_tone5:", ":raising_hands_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4c", "1f64c.png", ":raised_hands:", ":raising_hands:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4d\ud83c\udffb\u200d\u2640\ufe0f", "1f64d-1f3fb-200d-2640-fe0f.png", ":woman_frowning_person_tone1:", ":woman_frowning_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4d\ud83c\udffb\u200d\u2642\ufe0f", "1f64d-1f3fb-200d-2642-fe0f.png", ":man_frowning_person_tone1:", ":man_frowning_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4d\ud83c\udffb", "1f64d-1f3fb.png", ":frowning_person_tone1:", ":person_frowning_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4d\ud83c\udffc\u200d\u2640\ufe0f", "1f64d-1f3fc-200d-2640-fe0f.png", ":woman_frowning_person_tone2:", ":woman_frowning_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4d\ud83c\udffc\u200d\u2642\ufe0f", "1f64d-1f3fc-200d-2642-fe0f.png", ":man_frowning_person_tone2:", ":man_frowning_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4d\ud83c\udffc", "1f64d-1f3fc.png", ":frowning_person_tone2:", ":person_frowning_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4d\ud83c\udffd\u200d\u2640\ufe0f", "1f64d-1f3fd-200d-2640-fe0f.png", ":woman_frowning_person_tone3:", ":woman_frowning_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4d\ud83c\udffd\u200d\u2642\ufe0f", "1f64d-1f3fd-200d-2642-fe0f.png", ":man_frowning_person_tone3:", ":man_frowning_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4d\ud83c\udffd", "1f64d-1f3fd.png", ":frowning_person_tone3:", ":person_frowning_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4d\ud83c\udffe\u200d\u2640\ufe0f", "1f64d-1f3fe-200d-2640-fe0f.png", ":woman_frowning_person_tone4:", ":woman_frowning_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4d\ud83c\udffe\u200d\u2642\ufe0f", "1f64d-1f3fe-200d-2642-fe0f.png", ":man_frowning_person_tone4:", ":man_frowning_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4d\ud83c\udffe", "1f64d-1f3fe.png", ":frowning_person_tone4:", ":person_frowning_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4d\ud83c\udfff\u200d\u2640\ufe0f", "1f64d-1f3ff-200d-2640-fe0f.png", ":woman_frowning_person_tone5:", ":woman_frowning_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4d\ud83c\udfff\u200d\u2642\ufe0f", "1f64d-1f3ff-200d-2642-fe0f.png", ":man_frowning_person_tone5:", ":man_frowning_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4d\ud83c\udfff", "1f64d-1f3ff.png", ":frowning_person_tone5:", ":person_frowning_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4d\u200d\u2640\ufe0f", "1f64d-200d-2640-fe0f.png", ":frowning_woman:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83d\ude4d\u200d\u2642\ufe0f", "1f64d-200d-2642-fe0f.png", ":frowning_man:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4d", "1f64d.png", ":frowning_person:", ":person_frowning:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4e\ud83c\udffb\u200d\u2640\ufe0f", "1f64e-1f3fb-200d-2640-fe0f.png", ":woman_pouting_face_tone1:", ":woman_pouting_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4e\ud83c\udffb\u200d\u2642\ufe0f", "1f64e-1f3fb-200d-2642-fe0f.png", ":man_pouting_face_tone1:", ":man_pouting_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4e\ud83c\udffb", "1f64e-1f3fb.png", ":pouting_face_tone1:", ":person_pouting_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4e\ud83c\udffc\u200d\u2640\ufe0f", "1f64e-1f3fc-200d-2640-fe0f.png", ":woman_pouting_face_tone2:", ":woman_pouting_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4e\ud83c\udffc\u200d\u2642\ufe0f", "1f64e-1f3fc-200d-2642-fe0f.png", ":man_pouting_face_tone2:", ":man_pouting_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4e\ud83c\udffc", "1f64e-1f3fc.png", ":pouting_face_tone2:", ":person_pouting_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4e\ud83c\udffd\u200d\u2640\ufe0f", "1f64e-1f3fd-200d-2640-fe0f.png", ":woman_pouting_face_tone3:", ":woman_pouting_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4e\ud83c\udffd\u200d\u2642\ufe0f", "1f64e-1f3fd-200d-2642-fe0f.png", ":man_pouting_face_tone3:", ":man_pouting_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4e\ud83c\udffd", "1f64e-1f3fd.png", ":pouting_face_tone3:", ":person_pouting_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4e\ud83c\udffe\u200d\u2640\ufe0f", "1f64e-1f3fe-200d-2640-fe0f.png", ":woman_pouting_face_tone4:", ":woman_pouting_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4e\ud83c\udffe\u200d\u2642\ufe0f", "1f64e-1f3fe-200d-2642-fe0f.png", ":man_pouting_face_tone4:", ":man_pouting_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4e\ud83c\udffe", "1f64e-1f3fe.png", ":pouting_face_tone4:", ":person_pouting_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4e\ud83c\udfff\u200d\u2640\ufe0f", "1f64e-1f3ff-200d-2640-fe0f.png", ":woman_pouting_face_tone5:", ":woman_pouting_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4e\ud83c\udfff\u200d\u2642\ufe0f", "1f64e-1f3ff-200d-2642-fe0f.png", ":man_pouting_face_tone5:", ":man_pouting_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4e\ud83c\udfff", "1f64e-1f3ff.png", ":pouting_face_tone5:", ":person_pouting_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4e\u200d\u2640\ufe0f", "1f64e-200d-2640-fe0f.png", ":pouting_woman:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83d\ude4e\u200d\u2642\ufe0f", "1f64e-200d-2642-fe0f.png", ":pouting_man:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4e", "1f64e.png", ":pouting_face:", ":person_pouting:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4f\ud83c\udffb", "1f64f-1f3fb.png", ":pray_tone1:", ":folded_hands_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4f\ud83c\udffc", "1f64f-1f3fc.png", ":pray_tone2:", ":folded_hands_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4f\ud83c\udffd", "1f64f-1f3fd.png", ":pray_tone3:", ":folded_hands_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4f\ud83c\udffe", "1f64f-1f3fe.png", ":pray_tone4:", ":folded_hands_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4f\ud83c\udfff", "1f64f-1f3ff.png", ":pray_tone5:", ":folded_hands_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4f", "1f64f.png", ":pray:", ":folded_hands:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude80", "1f680.png", ":rocket:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude81", "1f681.png", ":helicopter:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude82", "1f682.png", ":steam_locomotive:", ":locomotive:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude83", "1f683.png", ":railway_car:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude84", "1f684.png", ":bullettrain_side:", ":high_speed_train:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude85", "1f685.png", ":bullettrain_front:", ":bullet_train:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude86", "1f686.png", ":train2:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude87", "1f687.png", ":metro:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude88", "1f688.png", ":light_rail:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude89", "1f689.png", ":station:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude8a", "1f68a.png", ":tram:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude8b", "1f68b.png", ":train:", ":tram_car:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude8c", "1f68c.png", ":bus:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude8d", "1f68d.png", ":oncoming_bus:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude8e", "1f68e.png", ":trolleybus:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude8f", "1f68f.png", ":busstop:", ":bus_stop:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude90", "1f690.png", ":minibus:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude91", "1f691.png", ":ambulance:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude92", "1f692.png", ":fire_engine:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude93", "1f693.png", ":police_car:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude94", "1f694.png", ":oncoming_police_car:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude95", "1f695.png", ":taxi:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude96", "1f696.png", ":oncoming_taxi:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude97", "1f697.png", ":car:", ":red_car:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude98", "1f698.png", ":oncoming_automobile:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude99", "1f699.png", ":blue_car:", ":sport_utility_vehicle:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude9a", "1f69a.png", ":truck:", ":delivery_truck:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude9b", "1f69b.png", ":articulated_lorry:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude9c", "1f69c.png", ":tractor:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude9d", "1f69d.png", ":monorail:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude9e", "1f69e.png", ":mountain_railway:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude9f", "1f69f.png", ":suspension_railway:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea0", "1f6a0.png", ":mountain_cableway:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea1", "1f6a1.png", ":aerial_tramway:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea2", "1f6a2.png", ":ship:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea3\ud83c\udffb\u200d\u2640\ufe0f", "1f6a3-1f3fb-200d-2640-fe0f.png", ":woman_rowboat_tone1:", ":woman_rowing_boat_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea3\ud83c\udffb\u200d\u2642\ufe0f", "1f6a3-1f3fb-200d-2642-fe0f.png", ":man_rowboat_tone1:", ":man_rowing_boat_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea3\ud83c\udffb", "1f6a3-1f3fb.png", ":rowboat_tone1:", ":person_rowing_boat_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea3\ud83c\udffc\u200d\u2640\ufe0f", "1f6a3-1f3fc-200d-2640-fe0f.png", ":woman_rowboat_tone2:", ":woman_rowing_boat_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea3\ud83c\udffc\u200d\u2642\ufe0f", "1f6a3-1f3fc-200d-2642-fe0f.png", ":man_rowboat_tone2:", ":man_rowing_boat_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea3\ud83c\udffc", "1f6a3-1f3fc.png", ":rowboat_tone2:", ":person_rowing_boat_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea3\ud83c\udffd\u200d\u2640\ufe0f", "1f6a3-1f3fd-200d-2640-fe0f.png", ":woman_rowboat_tone3:", ":woman_rowing_boat_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea3\ud83c\udffd\u200d\u2642\ufe0f", "1f6a3-1f3fd-200d-2642-fe0f.png", ":man_rowboat_tone3:", ":man_rowing_boat_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea3\ud83c\udffd", "1f6a3-1f3fd.png", ":rowboat_tone3:", ":person_rowing_boat_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea3\ud83c\udffe\u200d\u2640\ufe0f", "1f6a3-1f3fe-200d-2640-fe0f.png", ":woman_rowboat_tone4:", ":woman_rowing_boat_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea3\ud83c\udffe\u200d\u2642\ufe0f", "1f6a3-1f3fe-200d-2642-fe0f.png", ":man_rowboat_tone4:", ":man_rowing_boat_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea3\ud83c\udffe", "1f6a3-1f3fe.png", ":rowboat_tone4:", ":person_rowing_boat_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea3\ud83c\udfff\u200d\u2640\ufe0f", "1f6a3-1f3ff-200d-2640-fe0f.png", ":woman_rowboat_tone5:", ":woman_rowing_boat_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea3\ud83c\udfff\u200d\u2642\ufe0f", "1f6a3-1f3ff-200d-2642-fe0f.png", ":man_rowboat_tone5:", ":man_rowing_boat_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea3\ud83c\udfff", "1f6a3-1f3ff.png", ":rowboat_tone5:", ":person_rowing_boat_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea3\u200d\u2640\ufe0f", "1f6a3-200d-2640-fe0f.png", ":rowing_woman:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea3\u200d\u2642\ufe0f", "1f6a3-200d-2642-fe0f.png", ":rowing_man:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83d\udea3", "1f6a3.png", ":rowboat:", ":person_rowing_boat:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea4", "1f6a4.png", ":speedboat:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea5", "1f6a5.png", ":traffic_light:", ":horizontal_traffic_light:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea6", "1f6a6.png", ":vertical_traffic_light:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea7", "1f6a7.png", ":construction:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea8", "1f6a8.png", ":rotating_light:", ":police_car_light:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea9", "1f6a9.png", ":triangular_flag_on_post:", ":triangular_flag:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeaa", "1f6aa.png", ":door:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeab", "1f6ab.png", ":no_entry_sign:", ":prohibited:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeac", "1f6ac.png", ":smoking:", ":cigarette:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udead", "1f6ad.png", ":no_smoking:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeae", "1f6ae.png", ":put_litter_in_its_place:", ":litter_in_bin_sign:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeaf", "1f6af.png", ":do_not_litter:", ":no_littering:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb0", "1f6b0.png", ":potable_water:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb1", "1f6b1.png", ":non-potable_water:", ":non_potable_water:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb2", "1f6b2.png", ":bike:", ":bicycle:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb3", "1f6b3.png", ":no_bicycles:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb4\ud83c\udffb\u200d\u2640\ufe0f", "1f6b4-1f3fb-200d-2640-fe0f.png", ":woman_bicyclist_tone1:", ":woman_biking_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb4\ud83c\udffb\u200d\u2642\ufe0f", "1f6b4-1f3fb-200d-2642-fe0f.png", ":man_bicyclist_tone1:", ":man_biking_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb4\ud83c\udffb", "1f6b4-1f3fb.png", ":bicyclist_tone1:", ":person_biking_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb4\ud83c\udffc\u200d\u2640\ufe0f", "1f6b4-1f3fc-200d-2640-fe0f.png", ":woman_bicyclist_tone2:", ":woman_biking_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb4\ud83c\udffc\u200d\u2642\ufe0f", "1f6b4-1f3fc-200d-2642-fe0f.png", ":man_bicyclist_tone2:", ":man_biking_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb4\ud83c\udffc", "1f6b4-1f3fc.png", ":bicyclist_tone2:", ":person_biking_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb4\ud83c\udffd\u200d\u2640\ufe0f", "1f6b4-1f3fd-200d-2640-fe0f.png", ":woman_bicyclist_tone3:", ":woman_biking_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb4\ud83c\udffd\u200d\u2642\ufe0f", "1f6b4-1f3fd-200d-2642-fe0f.png", ":man_bicyclist_tone3:", ":man_biking_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb4\ud83c\udffd", "1f6b4-1f3fd.png", ":bicyclist_tone3:", ":person_biking_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb4\ud83c\udffe\u200d\u2640\ufe0f", "1f6b4-1f3fe-200d-2640-fe0f.png", ":woman_bicyclist_tone4:", ":woman_biking_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb4\ud83c\udffe\u200d\u2642\ufe0f", "1f6b4-1f3fe-200d-2642-fe0f.png", ":man_bicyclist_tone4:", ":man_biking_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb4\ud83c\udffe", "1f6b4-1f3fe.png", ":bicyclist_tone4:", ":person_biking_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb4\ud83c\udfff\u200d\u2640\ufe0f", "1f6b4-1f3ff-200d-2640-fe0f.png", ":woman_bicyclist_tone5:", ":woman_biking_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb4\ud83c\udfff\u200d\u2642\ufe0f", "1f6b4-1f3ff-200d-2642-fe0f.png", ":man_bicyclist_tone5:", ":man_biking_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb4\ud83c\udfff", "1f6b4-1f3ff.png", ":bicyclist_tone5:", ":person_biking_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb4\u200d\u2640\ufe0f", "1f6b4-200d-2640-fe0f.png", ":biking_woman:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb4\u200d\u2642\ufe0f", "1f6b4-200d-2642-fe0f.png", ":biking_man:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83d\udeb4", "1f6b4.png", ":bicyclist:", ":person_biking:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb5\ud83c\udffb\u200d\u2640\ufe0f", "1f6b5-1f3fb-200d-2640-fe0f.png", ":woman_mountain_bicyclist_tone1:", ":woman_mountain_biking_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb5\ud83c\udffb\u200d\u2642\ufe0f", "1f6b5-1f3fb-200d-2642-fe0f.png", ":man_mountain_bicyclist_tone1:", ":man_mountain_biking_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb5\ud83c\udffb", "1f6b5-1f3fb.png", ":mountain_bicyclist_tone1:", ":person_mountain_biking_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb5\ud83c\udffc\u200d\u2640\ufe0f", "1f6b5-1f3fc-200d-2640-fe0f.png", ":woman_mountain_bicyclist_tone2:", ":woman_mountain_biking_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb5\ud83c\udffc\u200d\u2642\ufe0f", "1f6b5-1f3fc-200d-2642-fe0f.png", ":man_mountain_bicyclist_tone2:", ":man_mountain_biking_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb5\ud83c\udffc", "1f6b5-1f3fc.png", ":mountain_bicyclist_tone2:", ":person_mountain_biking_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb5\ud83c\udffd\u200d\u2640\ufe0f", "1f6b5-1f3fd-200d-2640-fe0f.png", ":woman_mountain_bicyclist_tone3:", ":woman_mountain_biking_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb5\ud83c\udffd\u200d\u2642\ufe0f", "1f6b5-1f3fd-200d-2642-fe0f.png", ":man_mountain_bicyclist_tone3:", ":man_mountain_biking_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb5\ud83c\udffd", "1f6b5-1f3fd.png", ":mountain_bicyclist_tone3:", ":person_mountain_biking_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb5\ud83c\udffe\u200d\u2640\ufe0f", "1f6b5-1f3fe-200d-2640-fe0f.png", ":woman_mountain_bicyclist_tone4:", ":woman_mountain_biking_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb5\ud83c\udffe\u200d\u2642\ufe0f", "1f6b5-1f3fe-200d-2642-fe0f.png", ":man_mountain_bicyclist_tone4:", ":man_mountain_biking_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb5\ud83c\udffe", "1f6b5-1f3fe.png", ":mountain_bicyclist_tone4:", ":person_mountain_biking_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb5\ud83c\udfff\u200d\u2640\ufe0f", "1f6b5-1f3ff-200d-2640-fe0f.png", ":woman_mountain_bicyclist_tone5:", ":woman_mountain_biking_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb5\ud83c\udfff\u200d\u2642\ufe0f", "1f6b5-1f3ff-200d-2642-fe0f.png", ":man_mountain_bicyclist_tone5:", ":man_mountain_biking_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb5\ud83c\udfff", "1f6b5-1f3ff.png", ":mountain_bicyclist_tone5:", ":person_mountain_biking_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb5\u200d\u2640\ufe0f", "1f6b5-200d-2640-fe0f.png", ":mountain_biking_woman:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb5\u200d\u2642\ufe0f", "1f6b5-200d-2642-fe0f.png", ":mountain_biking_man:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83d\udeb5", "1f6b5.png", ":mountain_bicyclist:", ":person_mountain_biking:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb6\ud83c\udffb\u200d\u2640\ufe0f", "1f6b6-1f3fb-200d-2640-fe0f.png", ":woman_walking_tone1:", ":woman_walking_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb6\ud83c\udffb\u200d\u2642\ufe0f", "1f6b6-1f3fb-200d-2642-fe0f.png", ":man_walking_tone1:", ":man_walking_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb6\ud83c\udffb", "1f6b6-1f3fb.png", ":walking_tone1:", ":person_walking_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb6\ud83c\udffc\u200d\u2640\ufe0f", "1f6b6-1f3fc-200d-2640-fe0f.png", ":woman_walking_tone2:", ":woman_walking_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb6\ud83c\udffc\u200d\u2642\ufe0f", "1f6b6-1f3fc-200d-2642-fe0f.png", ":man_walking_tone2:", ":man_walking_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb6\ud83c\udffc", "1f6b6-1f3fc.png", ":walking_tone2:", ":person_walking_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb6\ud83c\udffd\u200d\u2640\ufe0f", "1f6b6-1f3fd-200d-2640-fe0f.png", ":woman_walking_tone3:", ":woman_walking_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb6\ud83c\udffd\u200d\u2642\ufe0f", "1f6b6-1f3fd-200d-2642-fe0f.png", ":man_walking_tone3:", ":man_walking_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb6\ud83c\udffd", "1f6b6-1f3fd.png", ":walking_tone3:", ":person_walking_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb6\ud83c\udffe\u200d\u2640\ufe0f", "1f6b6-1f3fe-200d-2640-fe0f.png", ":woman_walking_tone4:", ":woman_walking_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb6\ud83c\udffe\u200d\u2642\ufe0f", "1f6b6-1f3fe-200d-2642-fe0f.png", ":man_walking_tone4:", ":man_walking_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb6\ud83c\udffe", "1f6b6-1f3fe.png", ":walking_tone4:", ":person_walking_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb6\ud83c\udfff\u200d\u2640\ufe0f", "1f6b6-1f3ff-200d-2640-fe0f.png", ":woman_walking_tone5:", ":woman_walking_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb6\ud83c\udfff\u200d\u2642\ufe0f", "1f6b6-1f3ff-200d-2642-fe0f.png", ":man_walking_tone5:", ":man_walking_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb6\ud83c\udfff", "1f6b6-1f3ff.png", ":walking_tone5:", ":person_walking_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb6\u200d\u2640\ufe0f", "1f6b6-200d-2640-fe0f.png", ":walking_woman:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb6\u200d\u2642\ufe0f", "1f6b6-200d-2642-fe0f.png", ":walking_man:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83d\udeb6", "1f6b6.png", ":walking:", ":person_walking:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb7", "1f6b7.png", ":no_pedestrians:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb8", "1f6b8.png", ":children_crossing:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb9", "1f6b9.png", ":mens:", ":mens_room:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeba", "1f6ba.png", ":womens:", ":womens_room:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udebb", "1f6bb.png", ":restroom:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udebc", "1f6bc.png", ":baby_symbol:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udebd", "1f6bd.png", ":toilet:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udebe", "1f6be.png", ":wc:", ":water_closet:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udebf", "1f6bf.png", ":shower:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udec0\ud83c\udffb", "1f6c0-1f3fb.png", ":bath_tone1:", ":person_taking_bath_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udec0\ud83c\udffc", "1f6c0-1f3fc.png", ":bath_tone2:", ":person_taking_bath_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udec0\ud83c\udffd", "1f6c0-1f3fd.png", ":bath_tone3:", ":person_taking_bath_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udec0\ud83c\udffe", "1f6c0-1f3fe.png", ":bath_tone4:", ":person_taking_bath_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udec0\ud83c\udfff", "1f6c0-1f3ff.png", ":bath_tone5:", ":person_taking_bath_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udec0", "1f6c0.png", ":bath:", ":person_taking_bath:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udec1", "1f6c1.png", ":bathtub:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udec2", "1f6c2.png", ":passport_control:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udec3", "1f6c3.png", ":customs:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udec4", "1f6c4.png", ":baggage_claim:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udec5", "1f6c5.png", ":left_luggage:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udecb", "1f6cb.png", ":couch_and_lamp:", ":couch:", "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udecc\ud83c\udffb", "1f6cc-1f3fb.png", ":sleeping_bed_tone1:", ":person_in_bed_tone1:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udecc\ud83c\udffc", "1f6cc-1f3fc.png", ":sleeping_bed_tone2:", ":person_in_bed_tone2:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udecc\ud83c\udffd", "1f6cc-1f3fd.png", ":sleeping_bed_tone3:", ":person_in_bed_tone3:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udecc\ud83c\udffe", "1f6cc-1f3fe.png", ":sleeping_bed_tone4:", ":person_in_bed_tone4:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udecc\ud83c\udfff", "1f6cc-1f3ff.png", ":sleeping_bed_tone5:", ":person_in_bed_tone5:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udecc", "1f6cc.png", ":sleeping_bed:", ":sleeping_accommodation:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udecd", "1f6cd.png", ":shopping:", ":shopping_bags:", "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udece", "1f6ce.png", ":bellhop_bell:", ":bellhop:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udecf", "1f6cf.png", ":bed:", null, "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\uded0", "1f6d0.png", ":place_of_worship:", null, "Symbols", "8.0");
        EmojiUtil.add(set, result, "\ud83d\uded1", "1f6d1.png", ":stop_sign:", ":octagonal_sign:", "Travel & Places", "9.0");
        EmojiUtil.add(set, result, "\ud83d\uded2", "1f6d2.png", ":shopping_cart:", null, "Objects", "9.0");
        EmojiUtil.add(set, result, "\ud83d\uded5", "1f6d5.png", ":hindu_temple:", null, "Travel & Places", "12.0");
        EmojiUtil.add(set, result, "\ud83d\uded6", "1f6d6.png", ":hut:", null, "Travel & Places", "13.0");
        EmojiUtil.add(set, result, "\ud83d\uded7", "1f6d7.png", ":elevator:", null, "Objects", "13.0");
        EmojiUtil.add(set, result, "\ud83d\udedd", "1f6dd.png", ":playground_slide:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udede", "1f6de.png", ":wheel:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udedf", "1f6df.png", ":ring_buoy:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udee0", "1f6e0.png", ":hammer_and_wrench:", ":tools:", "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udee1", "1f6e1.png", ":shield:", null, "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udee2", "1f6e2.png", ":oil_drum:", ":oil:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udee3", "1f6e3.png", ":motorway:", null, "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udee4", "1f6e4.png", ":railway_track:", null, "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udee5", "1f6e5.png", ":motor_boat:", ":motorboat:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udee9", "1f6e9.png", ":small_airplane:", ":airplane_small:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udeeb", "1f6eb.png", ":flight_departure:", ":airplane_departure:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udeec", "1f6ec.png", ":flight_arrival:", ":airplane_arriving:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udef0", "1f6f0.png", ":artificial_satellite:", ":satellite_orbital:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udef3", "1f6f3.png", ":passenger_ship:", ":cruise_ship:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udef4", "1f6f4.png", ":kick_scooter:", ":scooter:", "Travel & Places", "9.0");
        EmojiUtil.add(set, result, "\ud83d\udef5", "1f6f5.png", ":motor_scooter:", null, "Travel & Places", "9.0");
        EmojiUtil.add(set, result, "\ud83d\udef6", "1f6f6.png", ":canoe:", null, "Travel & Places", "9.0");
        EmojiUtil.add(set, result, "\ud83d\udef7", "1f6f7.png", ":sled:", null, "Activities", "11.0");
        EmojiUtil.add(set, result, "\ud83d\udef8", "1f6f8.png", ":flying_saucer:", null, "Travel & Places", "11.0");
        EmojiUtil.add(set, result, "\ud83d\udef9", "1f6f9.png", ":skateboard:", null, "Travel & Places", "11.0");
        EmojiUtil.add(set, result, "\ud83d\udefa", "1f6fa.png", ":auto_rickshaw:", null, "Travel & Places", "12.0");
        EmojiUtil.add(set, result, "\ud83d\udefb", "1f6fb.png", ":pickup_truck:", null, "Travel & Places", "13.0");
        EmojiUtil.add(set, result, "\ud83d\udefc", "1f6fc.png", ":roller_skate:", null, "Travel & Places", "13.0");
        EmojiUtil.add(set, result, "\ud83d\udfe0", "1f7e0.png", ":orange_circle:", null, "Symbols", "12.0");
        EmojiUtil.add(set, result, "\ud83d\udfe1", "1f7e1.png", ":yellow_circle:", null, "Symbols", "12.0");
        EmojiUtil.add(set, result, "\ud83d\udfe2", "1f7e2.png", ":green_circle:", null, "Symbols", "12.0");
        EmojiUtil.add(set, result, "\ud83d\udfe3", "1f7e3.png", ":purple_circle:", null, "Symbols", "12.0");
        EmojiUtil.add(set, result, "\ud83d\udfe4", "1f7e4.png", ":brown_circle:", null, "Symbols", "12.0");
        EmojiUtil.add(set, result, "\ud83d\udfe5", "1f7e5.png", ":red_square:", null, "Symbols", "12.0");
        EmojiUtil.add(set, result, "\ud83d\udfe6", "1f7e6.png", ":blue_square:", null, "Symbols", "12.0");
        EmojiUtil.add(set, result, "\ud83d\udfe7", "1f7e7.png", ":orange_square:", null, "Symbols", "12.0");
        EmojiUtil.add(set, result, "\ud83d\udfe8", "1f7e8.png", ":yellow_square:", null, "Symbols", "12.0");
        EmojiUtil.add(set, result, "\ud83d\udfe9", "1f7e9.png", ":green_square:", null, "Symbols", "12.0");
        EmojiUtil.add(set, result, "\ud83d\udfea", "1f7ea.png", ":purple_square:", null, "Symbols", "12.0");
        EmojiUtil.add(set, result, "\ud83d\udfeb", "1f7eb.png", ":brown_square:", null, "Symbols", "12.0");
        EmojiUtil.add(set, result, "\ud83d\udff0", "1f7f0.png", ":heavy_equals_sign:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udd0c\ud83c\udffb", "1f90c-1f3fb.png", ":pinched_fingers_tone1:", ":pinched_fingers_light_skin_tone:", "People & Body", "13.0");
        EmojiUtil.add(set, result, "\ud83e\udd0c\ud83c\udffc", "1f90c-1f3fc.png", ":pinched_fingers_tone2:", ":pinched_fingers_medium_light_skin_tone:", "People & Body", "13.0");
        EmojiUtil.add(set, result, "\ud83e\udd0c\ud83c\udffd", "1f90c-1f3fd.png", ":pinched_fingers_tone3:", ":pinched_fingers_medium_skin_tone:", "People & Body", "13.0");
        EmojiUtil.add(set, result, "\ud83e\udd0c\ud83c\udffe", "1f90c-1f3fe.png", ":pinched_fingers_tone4:", ":pinched_fingers_medium_dark_skin_tone:", "People & Body", "13.0");
        EmojiUtil.add(set, result, "\ud83e\udd0c\ud83c\udfff", "1f90c-1f3ff.png", ":pinched_fingers_tone5:", ":pinched_fingers_dark_skin_tone:", "People & Body", "13.0");
        EmojiUtil.add(set, result, "\ud83e\udd0c", "1f90c.png", ":pinched_fingers:", null, "People & Body", "13.0");
        EmojiUtil.add(set, result, "\ud83e\udd0d", "1f90d.png", ":white_heart:", null, "Smileys & Emotion", "12.0");
        EmojiUtil.add(set, result, "\ud83e\udd0e", "1f90e.png", ":brown_heart:", null, "Smileys & Emotion", "12.0");
        EmojiUtil.add(set, result, "\ud83e\udd0f\ud83c\udffb", "1f90f-1f3fb.png", ":pinching_hand_tone1:", ":pinching_hand_light_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\udd0f\ud83c\udffc", "1f90f-1f3fc.png", ":pinching_hand_tone2:", ":pinching_hand_medium_light_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\udd0f\ud83c\udffd", "1f90f-1f3fd.png", ":pinching_hand_tone3:", ":pinching_hand_medium_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\udd0f\ud83c\udffe", "1f90f-1f3fe.png", ":pinching_hand_tone4:", ":pinching_hand_medium_dark_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\udd0f\ud83c\udfff", "1f90f-1f3ff.png", ":pinching_hand_tone5:", ":pinching_hand_dark_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\udd0f", "1f90f.png", ":pinching_hand:", null, "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\udd10", "1f910.png", ":zipper_mouth_face:", ":zipper_mouth:", "Smileys & Emotion", "8.0");
        EmojiUtil.add(set, result, "\ud83e\udd11", "1f911.png", ":money_mouth_face:", ":money_mouth:", "Smileys & Emotion", "8.0");
        EmojiUtil.add(set, result, "\ud83e\udd12", "1f912.png", ":face_with_thermometer:", ":thermometer_face:", "Smileys & Emotion", "8.0");
        EmojiUtil.add(set, result, "\ud83e\udd13", "1f913.png", ":nerd_face:", ":nerd:", "Smileys & Emotion", "8.0");
        EmojiUtil.add(set, result, "\ud83e\udd14", "1f914.png", ":thinking:", ":thinking_face:", "Smileys & Emotion", "8.0");
        EmojiUtil.add(set, result, "\ud83e\udd15", "1f915.png", ":face_with_head_bandage:", ":head_bandage:", "Smileys & Emotion", "8.0");
        EmojiUtil.add(set, result, "\ud83e\udd16", "1f916.png", ":robot:", null, "Smileys & Emotion", "8.0");
        EmojiUtil.add(set, result, "\ud83e\udd17", "1f917.png", ":hugs:", ":hugging:", "Smileys & Emotion", "8.0");
        EmojiUtil.add(set, result, "\ud83e\udd18\ud83c\udffb", "1f918-1f3fb.png", ":metal_tone1:", ":sign_of_the_horns_light_skin_tone:", "People & Body", "8.0");
        EmojiUtil.add(set, result, "\ud83e\udd18\ud83c\udffc", "1f918-1f3fc.png", ":metal_tone2:", ":sign_of_the_horns_medium_light_skin_tone:", "People & Body", "8.0");
        EmojiUtil.add(set, result, "\ud83e\udd18\ud83c\udffd", "1f918-1f3fd.png", ":metal_tone3:", ":sign_of_the_horns_medium_skin_tone:", "People & Body", "8.0");
        EmojiUtil.add(set, result, "\ud83e\udd18\ud83c\udffe", "1f918-1f3fe.png", ":metal_tone4:", ":sign_of_the_horns_medium_dark_skin_tone:", "People & Body", "8.0");
        EmojiUtil.add(set, result, "\ud83e\udd18\ud83c\udfff", "1f918-1f3ff.png", ":metal_tone5:", ":sign_of_the_horns_dark_skin_tone:", "People & Body", "8.0");
        EmojiUtil.add(set, result, "\ud83e\udd18", "1f918.png", ":metal:", ":sign_of_the_horns:", "People & Body", "8.0");
        EmojiUtil.add(set, result, "\ud83e\udd19\ud83c\udffb", "1f919-1f3fb.png", ":call_me_hand_tone1:", ":call_me_tone1:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd19\ud83c\udffc", "1f919-1f3fc.png", ":call_me_hand_tone2:", ":call_me_tone2:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd19\ud83c\udffd", "1f919-1f3fd.png", ":call_me_hand_tone3:", ":call_me_tone3:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd19\ud83c\udffe", "1f919-1f3fe.png", ":call_me_hand_tone4:", ":call_me_tone4:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd19\ud83c\udfff", "1f919-1f3ff.png", ":call_me_hand_tone5:", ":call_me_tone5:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd19", "1f919.png", ":call_me_hand:", ":call_me:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1a\ud83c\udffb", "1f91a-1f3fb.png", ":raised_back_of_hand_tone1:", ":raised_back_of_hand_light_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1a\ud83c\udffc", "1f91a-1f3fc.png", ":raised_back_of_hand_tone2:", ":raised_back_of_hand_medium_light_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1a\ud83c\udffd", "1f91a-1f3fd.png", ":raised_back_of_hand_tone3:", ":raised_back_of_hand_medium_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1a\ud83c\udffe", "1f91a-1f3fe.png", ":raised_back_of_hand_tone4:", ":raised_back_of_hand_medium_dark_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1a\ud83c\udfff", "1f91a-1f3ff.png", ":raised_back_of_hand_tone5:", ":raised_back_of_hand_dark_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1a", "1f91a.png", ":raised_back_of_hand:", null, "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1b\ud83c\udffb", "1f91b-1f3fb.png", ":fist_left_tone1:", ":left_facing_fist_tone1:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1b\ud83c\udffc", "1f91b-1f3fc.png", ":fist_left_tone2:", ":left_facing_fist_tone2:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1b\ud83c\udffd", "1f91b-1f3fd.png", ":fist_left_tone3:", ":left_facing_fist_tone3:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1b\ud83c\udffe", "1f91b-1f3fe.png", ":fist_left_tone4:", ":left_facing_fist_tone4:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1b\ud83c\udfff", "1f91b-1f3ff.png", ":fist_left_tone5:", ":left_facing_fist_tone5:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1b", "1f91b.png", ":fist_left:", ":left_facing_fist:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1c\ud83c\udffb", "1f91c-1f3fb.png", ":fist_right_tone1:", ":right_facing_fist_tone1:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1c\ud83c\udffc", "1f91c-1f3fc.png", ":fist_right_tone2:", ":right_facing_fist_tone2:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1c\ud83c\udffd", "1f91c-1f3fd.png", ":fist_right_tone3:", ":right_facing_fist_tone3:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1c\ud83c\udffe", "1f91c-1f3fe.png", ":fist_right_tone4:", ":right_facing_fist_tone4:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1c\ud83c\udfff", "1f91c-1f3ff.png", ":fist_right_tone5:", ":right_facing_fist_tone5:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1c", "1f91c.png", ":fist_right:", ":right_facing_fist:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1d\ud83c\udffb", "1f91d-1f3fb.png", ":handshake_tone1:", ":handshake_light_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1d\ud83c\udffc", "1f91d-1f3fc.png", ":handshake_tone2:", ":handshake_medium_light_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1d\ud83c\udffd", "1f91d-1f3fd.png", ":handshake_tone3:", ":handshake_medium_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1d\ud83c\udffe", "1f91d-1f3fe.png", ":handshake_tone4:", ":handshake_medium_dark_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1d\ud83c\udfff", "1f91d-1f3ff.png", ":handshake_tone5:", ":handshake_dark_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1d", "1f91d.png", ":handshake:", null, "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1e\ud83c\udffb", "1f91e-1f3fb.png", ":crossed_fingers_tone1:", ":fingers_crossed_tone1:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1e\ud83c\udffc", "1f91e-1f3fc.png", ":crossed_fingers_tone2:", ":fingers_crossed_tone2:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1e\ud83c\udffd", "1f91e-1f3fd.png", ":crossed_fingers_tone3:", ":fingers_crossed_tone3:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1e\ud83c\udffe", "1f91e-1f3fe.png", ":crossed_fingers_tone4:", ":fingers_crossed_tone4:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1e\ud83c\udfff", "1f91e-1f3ff.png", ":crossed_fingers_tone5:", ":fingers_crossed_tone5:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1e", "1f91e.png", ":crossed_fingers:", ":fingers_crossed:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1f\ud83c\udffb", "1f91f-1f3fb.png", ":love_you_gesture_tone1:", ":love_you_gesture_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd1f\ud83c\udffc", "1f91f-1f3fc.png", ":love_you_gesture_tone2:", ":love_you_gesture_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd1f\ud83c\udffd", "1f91f-1f3fd.png", ":love_you_gesture_tone3:", ":love_you_gesture_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd1f\ud83c\udffe", "1f91f-1f3fe.png", ":love_you_gesture_tone4:", ":love_you_gesture_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd1f\ud83c\udfff", "1f91f-1f3ff.png", ":love_you_gesture_tone5:", ":love_you_gesture_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd1f", "1f91f.png", ":love_you_gesture:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd20", "1f920.png", ":cowboy_hat_face:", ":cowboy:", "Smileys & Emotion", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd21", "1f921.png", ":clown_face:", ":clown:", "Smileys & Emotion", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd22", "1f922.png", ":nauseated_face:", null, "Smileys & Emotion", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd23", "1f923.png", ":rofl:", ":rolling_on_the_floor_laughing:", "Smileys & Emotion", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd24", "1f924.png", ":drooling_face:", null, "Smileys & Emotion", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd25", "1f925.png", ":lying_face:", null, "Smileys & Emotion", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd26\ud83c\udffb\u200d\u2640\ufe0f", "1f926-1f3fb-200d-2640-fe0f.png", ":woman_facepalm_tone1:", ":woman_facepalming_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd26\ud83c\udffb\u200d\u2642\ufe0f", "1f926-1f3fb-200d-2642-fe0f.png", ":man_facepalm_tone1:", ":man_facepalming_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd26\ud83c\udffb", "1f926-1f3fb.png", ":facepalm_tone1:", ":person_facepalming_tone1:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd26\ud83c\udffc\u200d\u2640\ufe0f", "1f926-1f3fc-200d-2640-fe0f.png", ":woman_facepalm_tone2:", ":woman_facepalming_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd26\ud83c\udffc\u200d\u2642\ufe0f", "1f926-1f3fc-200d-2642-fe0f.png", ":man_facepalm_tone2:", ":man_facepalming_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd26\ud83c\udffc", "1f926-1f3fc.png", ":facepalm_tone2:", ":person_facepalming_tone2:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd26\ud83c\udffd\u200d\u2640\ufe0f", "1f926-1f3fd-200d-2640-fe0f.png", ":woman_facepalm_tone3:", ":woman_facepalming_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd26\ud83c\udffd\u200d\u2642\ufe0f", "1f926-1f3fd-200d-2642-fe0f.png", ":man_facepalm_tone3:", ":man_facepalming_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd26\ud83c\udffd", "1f926-1f3fd.png", ":facepalm_tone3:", ":person_facepalming_tone3:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd26\ud83c\udffe\u200d\u2640\ufe0f", "1f926-1f3fe-200d-2640-fe0f.png", ":woman_facepalm_tone4:", ":woman_facepalming_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd26\ud83c\udffe\u200d\u2642\ufe0f", "1f926-1f3fe-200d-2642-fe0f.png", ":man_facepalm_tone4:", ":man_facepalming_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd26\ud83c\udffe", "1f926-1f3fe.png", ":facepalm_tone4:", ":person_facepalming_tone4:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd26\ud83c\udfff\u200d\u2640\ufe0f", "1f926-1f3ff-200d-2640-fe0f.png", ":woman_facepalm_tone5:", ":woman_facepalming_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd26\ud83c\udfff\u200d\u2642\ufe0f", "1f926-1f3ff-200d-2642-fe0f.png", ":man_facepalm_tone5:", ":man_facepalming_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd26\ud83c\udfff", "1f926-1f3ff.png", ":facepalm_tone5:", ":person_facepalming_tone5:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd26\u200d\u2640\ufe0f", "1f926-200d-2640-fe0f.png", ":woman_facepalming:", null, "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd26\u200d\u2642\ufe0f", "1f926-200d-2642-fe0f.png", ":man_facepalming:", null, "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd26", "1f926.png", ":facepalm:", ":person_facepalming:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd27", "1f927.png", ":sneezing_face:", null, "Smileys & Emotion", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd28", "1f928.png", ":raised_eyebrow:", ":face_with_raised_eyebrow:", "Smileys & Emotion", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd29", "1f929.png", ":star_struck:", null, "Smileys & Emotion", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd2a", "1f92a.png", ":zany_face:", null, "Smileys & Emotion", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd2b", "1f92b.png", ":shushing_face:", null, "Smileys & Emotion", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd2c", "1f92c.png", ":cursing_face:", ":face_with_symbols_over_mouth:", "Smileys & Emotion", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd2d", "1f92d.png", ":hand_over_mouth:", ":face_with_hand_over_mouth:", "Smileys & Emotion", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd2e", "1f92e.png", ":vomiting_face:", ":face_vomiting:", "Smileys & Emotion", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd2f", "1f92f.png", ":exploding_head:", null, "Smileys & Emotion", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd30\ud83c\udffb", "1f930-1f3fb.png", ":pregnant_woman_tone1:", ":pregnant_woman_light_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd30\ud83c\udffc", "1f930-1f3fc.png", ":pregnant_woman_tone2:", ":pregnant_woman_medium_light_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd30\ud83c\udffd", "1f930-1f3fd.png", ":pregnant_woman_tone3:", ":pregnant_woman_medium_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd30\ud83c\udffe", "1f930-1f3fe.png", ":pregnant_woman_tone4:", ":pregnant_woman_medium_dark_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd30\ud83c\udfff", "1f930-1f3ff.png", ":pregnant_woman_tone5:", ":pregnant_woman_dark_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd30", "1f930.png", ":pregnant_woman:", null, "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd31\ud83c\udffb", "1f931-1f3fb.png", ":breast_feeding_tone1:", ":breast_feeding_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd31\ud83c\udffc", "1f931-1f3fc.png", ":breast_feeding_tone2:", ":breast_feeding_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd31\ud83c\udffd", "1f931-1f3fd.png", ":breast_feeding_tone3:", ":breast_feeding_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd31\ud83c\udffe", "1f931-1f3fe.png", ":breast_feeding_tone4:", ":breast_feeding_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd31\ud83c\udfff", "1f931-1f3ff.png", ":breast_feeding_tone5:", ":breast_feeding_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd31", "1f931.png", ":breast_feeding:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd32\ud83c\udffb", "1f932-1f3fb.png", ":palms_up_together_tone1:", ":palms_up_together_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd32\ud83c\udffc", "1f932-1f3fc.png", ":palms_up_together_tone2:", ":palms_up_together_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd32\ud83c\udffd", "1f932-1f3fd.png", ":palms_up_together_tone3:", ":palms_up_together_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd32\ud83c\udffe", "1f932-1f3fe.png", ":palms_up_together_tone4:", ":palms_up_together_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd32\ud83c\udfff", "1f932-1f3ff.png", ":palms_up_together_tone5:", ":palms_up_together_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd32", "1f932.png", ":palms_up_together:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd33\ud83c\udffb", "1f933-1f3fb.png", ":selfie_tone1:", ":selfie_light_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd33\ud83c\udffc", "1f933-1f3fc.png", ":selfie_tone2:", ":selfie_medium_light_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd33\ud83c\udffd", "1f933-1f3fd.png", ":selfie_tone3:", ":selfie_medium_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd33\ud83c\udffe", "1f933-1f3fe.png", ":selfie_tone4:", ":selfie_medium_dark_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd33\ud83c\udfff", "1f933-1f3ff.png", ":selfie_tone5:", ":selfie_dark_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd33", "1f933.png", ":selfie:", null, "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd34\ud83c\udffb", "1f934-1f3fb.png", ":prince_tone1:", ":prince_light_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd34\ud83c\udffc", "1f934-1f3fc.png", ":prince_tone2:", ":prince_medium_light_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd34\ud83c\udffd", "1f934-1f3fd.png", ":prince_tone3:", ":prince_medium_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd34\ud83c\udffe", "1f934-1f3fe.png", ":prince_tone4:", ":prince_medium_dark_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd34\ud83c\udfff", "1f934-1f3ff.png", ":prince_tone5:", ":prince_dark_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd34", "1f934.png", ":prince:", null, "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd35\ud83c\udffb\u200d\u2640\ufe0f", "1f935-1f3fb-200d-2640-fe0f.png", ":woman_person_in_tuxedo_tone1:", ":woman_in_tuxedo_light_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd35\ud83c\udffb\u200d\u2642\ufe0f", "1f935-1f3fb-200d-2642-fe0f.png", ":man_person_in_tuxedo_tone1:", ":man_in_tuxedo_light_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd35\ud83c\udffb", "1f935-1f3fb.png", ":person_in_tuxedo_tone1:", ":person_in_tuxedo_light_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd35\ud83c\udffc\u200d\u2640\ufe0f", "1f935-1f3fc-200d-2640-fe0f.png", ":woman_person_in_tuxedo_tone2:", ":woman_in_tuxedo_medium_light_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd35\ud83c\udffc\u200d\u2642\ufe0f", "1f935-1f3fc-200d-2642-fe0f.png", ":man_person_in_tuxedo_tone2:", ":man_in_tuxedo_medium_light_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd35\ud83c\udffc", "1f935-1f3fc.png", ":person_in_tuxedo_tone2:", ":person_in_tuxedo_medium_light_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd35\ud83c\udffd\u200d\u2640\ufe0f", "1f935-1f3fd-200d-2640-fe0f.png", ":woman_person_in_tuxedo_tone3:", ":woman_in_tuxedo_medium_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd35\ud83c\udffd\u200d\u2642\ufe0f", "1f935-1f3fd-200d-2642-fe0f.png", ":man_person_in_tuxedo_tone3:", ":man_in_tuxedo_medium_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd35\ud83c\udffd", "1f935-1f3fd.png", ":person_in_tuxedo_tone3:", ":person_in_tuxedo_medium_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd35\ud83c\udffe\u200d\u2640\ufe0f", "1f935-1f3fe-200d-2640-fe0f.png", ":woman_person_in_tuxedo_tone4:", ":woman_in_tuxedo_medium_dark_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd35\ud83c\udffe\u200d\u2642\ufe0f", "1f935-1f3fe-200d-2642-fe0f.png", ":man_person_in_tuxedo_tone4:", ":man_in_tuxedo_medium_dark_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd35\ud83c\udffe", "1f935-1f3fe.png", ":person_in_tuxedo_tone4:", ":person_in_tuxedo_medium_dark_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd35\ud83c\udfff\u200d\u2640\ufe0f", "1f935-1f3ff-200d-2640-fe0f.png", ":woman_person_in_tuxedo_tone5:", ":woman_in_tuxedo_dark_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd35\ud83c\udfff\u200d\u2642\ufe0f", "1f935-1f3ff-200d-2642-fe0f.png", ":man_person_in_tuxedo_tone5:", ":man_in_tuxedo_dark_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd35\ud83c\udfff", "1f935-1f3ff.png", ":person_in_tuxedo_tone5:", ":person_in_tuxedo_dark_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd35\u200d\u2640\ufe0f", "1f935-200d-2640-fe0f.png", ":woman_in_tuxedo:", null, "People & Body", "13.0");
        EmojiUtil.add(set, result, "\ud83e\udd35\u200d\u2642\ufe0f", "1f935-200d-2642-fe0f.png", ":man_in_tuxedo:", null, "People & Body", "13.0");
        EmojiUtil.add(set, result, "\ud83e\udd35", "1f935.png", ":person_in_tuxedo:", null, "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd36\ud83c\udffb", "1f936-1f3fb.png", ":mrs_claus_tone1:", ":mrs_claus_light_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd36\ud83c\udffc", "1f936-1f3fc.png", ":mrs_claus_tone2:", ":mrs_claus_medium_light_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd36\ud83c\udffd", "1f936-1f3fd.png", ":mrs_claus_tone3:", ":mrs_claus_medium_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd36\ud83c\udffe", "1f936-1f3fe.png", ":mrs_claus_tone4:", ":mrs_claus_medium_dark_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd36\ud83c\udfff", "1f936-1f3ff.png", ":mrs_claus_tone5:", ":mrs_claus_dark_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd36", "1f936.png", ":mrs_claus:", null, "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd37\ud83c\udffb\u200d\u2640\ufe0f", "1f937-1f3fb-200d-2640-fe0f.png", ":woman_shrug_tone1:", ":woman_shrugging_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd37\ud83c\udffb\u200d\u2642\ufe0f", "1f937-1f3fb-200d-2642-fe0f.png", ":man_shrug_tone1:", ":man_shrugging_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd37\ud83c\udffb", "1f937-1f3fb.png", ":shrug_tone1:", ":person_shrugging_tone1:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd37\ud83c\udffc\u200d\u2640\ufe0f", "1f937-1f3fc-200d-2640-fe0f.png", ":woman_shrug_tone2:", ":woman_shrugging_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd37\ud83c\udffc\u200d\u2642\ufe0f", "1f937-1f3fc-200d-2642-fe0f.png", ":man_shrug_tone2:", ":man_shrugging_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd37\ud83c\udffc", "1f937-1f3fc.png", ":shrug_tone2:", ":person_shrugging_tone2:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd37\ud83c\udffd\u200d\u2640\ufe0f", "1f937-1f3fd-200d-2640-fe0f.png", ":woman_shrug_tone3:", ":woman_shrugging_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd37\ud83c\udffd\u200d\u2642\ufe0f", "1f937-1f3fd-200d-2642-fe0f.png", ":man_shrug_tone3:", ":man_shrugging_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd37\ud83c\udffd", "1f937-1f3fd.png", ":shrug_tone3:", ":person_shrugging_tone3:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd37\ud83c\udffe\u200d\u2640\ufe0f", "1f937-1f3fe-200d-2640-fe0f.png", ":woman_shrug_tone4:", ":woman_shrugging_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd37\ud83c\udffe\u200d\u2642\ufe0f", "1f937-1f3fe-200d-2642-fe0f.png", ":man_shrug_tone4:", ":man_shrugging_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd37\ud83c\udffe", "1f937-1f3fe.png", ":shrug_tone4:", ":person_shrugging_tone4:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd37\ud83c\udfff\u200d\u2640\ufe0f", "1f937-1f3ff-200d-2640-fe0f.png", ":woman_shrug_tone5:", ":woman_shrugging_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd37\ud83c\udfff\u200d\u2642\ufe0f", "1f937-1f3ff-200d-2642-fe0f.png", ":man_shrug_tone5:", ":man_shrugging_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd37\ud83c\udfff", "1f937-1f3ff.png", ":shrug_tone5:", ":person_shrugging_tone5:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd37\u200d\u2640\ufe0f", "1f937-200d-2640-fe0f.png", ":woman_shrugging:", null, "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd37\u200d\u2642\ufe0f", "1f937-200d-2642-fe0f.png", ":man_shrugging:", null, "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd37", "1f937.png", ":shrug:", ":person_shrugging:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd38\ud83c\udffb\u200d\u2640\ufe0f", "1f938-1f3fb-200d-2640-fe0f.png", ":woman_cartwheeling_tone1:", ":woman_cartwheeling_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd38\ud83c\udffb\u200d\u2642\ufe0f", "1f938-1f3fb-200d-2642-fe0f.png", ":man_cartwheeling_tone1:", ":man_cartwheeling_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd38\ud83c\udffb", "1f938-1f3fb.png", ":cartwheeling_tone1:", ":person_doing_cartwheel_tone1:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd38\ud83c\udffc\u200d\u2640\ufe0f", "1f938-1f3fc-200d-2640-fe0f.png", ":woman_cartwheeling_tone2:", ":woman_cartwheeling_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd38\ud83c\udffc\u200d\u2642\ufe0f", "1f938-1f3fc-200d-2642-fe0f.png", ":man_cartwheeling_tone2:", ":man_cartwheeling_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd38\ud83c\udffc", "1f938-1f3fc.png", ":cartwheeling_tone2:", ":person_doing_cartwheel_tone2:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd38\ud83c\udffd\u200d\u2640\ufe0f", "1f938-1f3fd-200d-2640-fe0f.png", ":woman_cartwheeling_tone3:", ":woman_cartwheeling_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd38\ud83c\udffd\u200d\u2642\ufe0f", "1f938-1f3fd-200d-2642-fe0f.png", ":man_cartwheeling_tone3:", ":man_cartwheeling_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd38\ud83c\udffd", "1f938-1f3fd.png", ":cartwheeling_tone3:", ":person_doing_cartwheel_tone3:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd38\ud83c\udffe\u200d\u2640\ufe0f", "1f938-1f3fe-200d-2640-fe0f.png", ":woman_cartwheeling_tone4:", ":woman_cartwheeling_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd38\ud83c\udffe\u200d\u2642\ufe0f", "1f938-1f3fe-200d-2642-fe0f.png", ":man_cartwheeling_tone4:", ":man_cartwheeling_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd38\ud83c\udffe", "1f938-1f3fe.png", ":cartwheeling_tone4:", ":person_doing_cartwheel_tone4:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd38\ud83c\udfff\u200d\u2640\ufe0f", "1f938-1f3ff-200d-2640-fe0f.png", ":woman_cartwheeling_tone5:", ":woman_cartwheeling_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd38\ud83c\udfff\u200d\u2642\ufe0f", "1f938-1f3ff-200d-2642-fe0f.png", ":man_cartwheeling_tone5:", ":man_cartwheeling_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd38\ud83c\udfff", "1f938-1f3ff.png", ":cartwheeling_tone5:", ":person_doing_cartwheel_tone5:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd38\u200d\u2640\ufe0f", "1f938-200d-2640-fe0f.png", ":woman_cartwheeling:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\ud83e\udd38\u200d\u2642\ufe0f", "1f938-200d-2642-fe0f.png", ":man_cartwheeling:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\ud83e\udd38", "1f938.png", ":cartwheeling:", ":person_doing_cartwheel:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd39\ud83c\udffb\u200d\u2640\ufe0f", "1f939-1f3fb-200d-2640-fe0f.png", ":woman_juggling_person_tone1:", ":woman_juggling_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd39\ud83c\udffb\u200d\u2642\ufe0f", "1f939-1f3fb-200d-2642-fe0f.png", ":man_juggling_person_tone1:", ":man_juggling_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd39\ud83c\udffb", "1f939-1f3fb.png", ":juggling_person_tone1:", ":person_juggling_tone1:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd39\ud83c\udffc\u200d\u2640\ufe0f", "1f939-1f3fc-200d-2640-fe0f.png", ":woman_juggling_person_tone2:", ":woman_juggling_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd39\ud83c\udffc\u200d\u2642\ufe0f", "1f939-1f3fc-200d-2642-fe0f.png", ":man_juggling_person_tone2:", ":man_juggling_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd39\ud83c\udffc", "1f939-1f3fc.png", ":juggling_person_tone2:", ":person_juggling_tone2:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd39\ud83c\udffd\u200d\u2640\ufe0f", "1f939-1f3fd-200d-2640-fe0f.png", ":woman_juggling_person_tone3:", ":woman_juggling_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd39\ud83c\udffd\u200d\u2642\ufe0f", "1f939-1f3fd-200d-2642-fe0f.png", ":man_juggling_person_tone3:", ":man_juggling_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd39\ud83c\udffd", "1f939-1f3fd.png", ":juggling_person_tone3:", ":person_juggling_tone3:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd39\ud83c\udffe\u200d\u2640\ufe0f", "1f939-1f3fe-200d-2640-fe0f.png", ":woman_juggling_person_tone4:", ":woman_juggling_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd39\ud83c\udffe\u200d\u2642\ufe0f", "1f939-1f3fe-200d-2642-fe0f.png", ":man_juggling_person_tone4:", ":man_juggling_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd39\ud83c\udffe", "1f939-1f3fe.png", ":juggling_person_tone4:", ":person_juggling_tone4:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd39\ud83c\udfff\u200d\u2640\ufe0f", "1f939-1f3ff-200d-2640-fe0f.png", ":woman_juggling_person_tone5:", ":woman_juggling_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd39\ud83c\udfff\u200d\u2642\ufe0f", "1f939-1f3ff-200d-2642-fe0f.png", ":man_juggling_person_tone5:", ":man_juggling_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd39\ud83c\udfff", "1f939-1f3ff.png", ":juggling_person_tone5:", ":person_juggling_tone5:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd39\u200d\u2640\ufe0f", "1f939-200d-2640-fe0f.png", ":woman_juggling:", null, "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd39\u200d\u2642\ufe0f", "1f939-200d-2642-fe0f.png", ":man_juggling:", null, "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd39", "1f939.png", ":juggling_person:", ":person_juggling:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3a", "1f93a.png", ":person_fencing:", null, "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd3c\ud83c\udffb", "1f93c-1f3fb.png", ":wrestling_tone1:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3c\ud83c\udffc", "1f93c-1f3fc.png", ":wrestling_tone2:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3c\ud83c\udffd", "1f93c-1f3fd.png", ":wrestling_tone3:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3c\ud83c\udffe", "1f93c-1f3fe.png", ":wrestling_tone4:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3c\ud83c\udfff", "1f93c-1f3ff.png", ":wrestling_tone5:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3c\u200d\u2640\ufe0f", "1f93c-200d-2640-fe0f.png", ":women_wrestling:", null, "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd3c\u200d\u2642\ufe0f", "1f93c-200d-2642-fe0f.png", ":men_wrestling:", null, "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd3c", "1f93c.png", ":wrestling:", ":people_wrestling:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3d\ud83c\udffb\u200d\u2640\ufe0f", "1f93d-1f3fb-200d-2640-fe0f.png", ":woman_water_polo_tone1:", ":woman_playing_water_polo_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3d\ud83c\udffb\u200d\u2642\ufe0f", "1f93d-1f3fb-200d-2642-fe0f.png", ":man_water_polo_tone1:", ":man_playing_water_polo_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3d\ud83c\udffb", "1f93d-1f3fb.png", ":water_polo_tone1:", ":person_playing_water_polo_tone1:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3d\ud83c\udffc\u200d\u2640\ufe0f", "1f93d-1f3fc-200d-2640-fe0f.png", ":woman_water_polo_tone2:", ":woman_playing_water_polo_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3d\ud83c\udffc\u200d\u2642\ufe0f", "1f93d-1f3fc-200d-2642-fe0f.png", ":man_water_polo_tone2:", ":man_playing_water_polo_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3d\ud83c\udffc", "1f93d-1f3fc.png", ":water_polo_tone2:", ":person_playing_water_polo_tone2:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3d\ud83c\udffd\u200d\u2640\ufe0f", "1f93d-1f3fd-200d-2640-fe0f.png", ":woman_water_polo_tone3:", ":woman_playing_water_polo_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3d\ud83c\udffd\u200d\u2642\ufe0f", "1f93d-1f3fd-200d-2642-fe0f.png", ":man_water_polo_tone3:", ":man_playing_water_polo_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3d\ud83c\udffd", "1f93d-1f3fd.png", ":water_polo_tone3:", ":person_playing_water_polo_tone3:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3d\ud83c\udffe\u200d\u2640\ufe0f", "1f93d-1f3fe-200d-2640-fe0f.png", ":woman_water_polo_tone4:", ":woman_playing_water_polo_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3d\ud83c\udffe\u200d\u2642\ufe0f", "1f93d-1f3fe-200d-2642-fe0f.png", ":man_water_polo_tone4:", ":man_playing_water_polo_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3d\ud83c\udffe", "1f93d-1f3fe.png", ":water_polo_tone4:", ":person_playing_water_polo_tone4:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3d\ud83c\udfff\u200d\u2640\ufe0f", "1f93d-1f3ff-200d-2640-fe0f.png", ":woman_water_polo_tone5:", ":woman_playing_water_polo_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3d\ud83c\udfff\u200d\u2642\ufe0f", "1f93d-1f3ff-200d-2642-fe0f.png", ":man_water_polo_tone5:", ":man_playing_water_polo_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3d\ud83c\udfff", "1f93d-1f3ff.png", ":water_polo_tone5:", ":person_playing_water_polo_tone5:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3d\u200d\u2640\ufe0f", "1f93d-200d-2640-fe0f.png", ":woman_playing_water_polo:", null, "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd3d\u200d\u2642\ufe0f", "1f93d-200d-2642-fe0f.png", ":man_playing_water_polo:", null, "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd3d", "1f93d.png", ":water_polo:", ":person_playing_water_polo:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3e\ud83c\udffb\u200d\u2640\ufe0f", "1f93e-1f3fb-200d-2640-fe0f.png", ":woman_handball_person_tone1:", ":woman_playing_handball_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3e\ud83c\udffb\u200d\u2642\ufe0f", "1f93e-1f3fb-200d-2642-fe0f.png", ":man_handball_person_tone1:", ":man_playing_handball_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3e\ud83c\udffb", "1f93e-1f3fb.png", ":handball_person_tone1:", ":person_playing_handball_tone1:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3e\ud83c\udffc\u200d\u2640\ufe0f", "1f93e-1f3fc-200d-2640-fe0f.png", ":woman_handball_person_tone2:", ":woman_playing_handball_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3e\ud83c\udffc\u200d\u2642\ufe0f", "1f93e-1f3fc-200d-2642-fe0f.png", ":man_handball_person_tone2:", ":man_playing_handball_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3e\ud83c\udffc", "1f93e-1f3fc.png", ":handball_person_tone2:", ":person_playing_handball_tone2:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3e\ud83c\udffd\u200d\u2640\ufe0f", "1f93e-1f3fd-200d-2640-fe0f.png", ":woman_handball_person_tone3:", ":woman_playing_handball_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3e\ud83c\udffd\u200d\u2642\ufe0f", "1f93e-1f3fd-200d-2642-fe0f.png", ":man_handball_person_tone3:", ":man_playing_handball_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3e\ud83c\udffd", "1f93e-1f3fd.png", ":handball_person_tone3:", ":person_playing_handball_tone3:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3e\ud83c\udffe\u200d\u2640\ufe0f", "1f93e-1f3fe-200d-2640-fe0f.png", ":woman_handball_person_tone4:", ":woman_playing_handball_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3e\ud83c\udffe\u200d\u2642\ufe0f", "1f93e-1f3fe-200d-2642-fe0f.png", ":man_handball_person_tone4:", ":man_playing_handball_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3e\ud83c\udffe", "1f93e-1f3fe.png", ":handball_person_tone4:", ":person_playing_handball_tone4:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3e\ud83c\udfff\u200d\u2640\ufe0f", "1f93e-1f3ff-200d-2640-fe0f.png", ":woman_handball_person_tone5:", ":woman_playing_handball_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3e\ud83c\udfff\u200d\u2642\ufe0f", "1f93e-1f3ff-200d-2642-fe0f.png", ":man_handball_person_tone5:", ":man_playing_handball_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3e\ud83c\udfff", "1f93e-1f3ff.png", ":handball_person_tone5:", ":person_playing_handball_tone5:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3e\u200d\u2640\ufe0f", "1f93e-200d-2640-fe0f.png", ":woman_playing_handball:", null, "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd3e\u200d\u2642\ufe0f", "1f93e-200d-2642-fe0f.png", ":man_playing_handball:", null, "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd3e", "1f93e.png", ":handball_person:", ":person_playing_handball:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3f", "1f93f.png", ":diving_mask:", null, "Activities", "12.0");
        EmojiUtil.add(set, result, "\ud83e\udd40", "1f940.png", ":wilted_flower:", ":wilted_rose:", "Animals & Nature", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd41", "1f941.png", ":drum:", null, "Objects", "");
        EmojiUtil.add(set, result, "\ud83e\udd42", "1f942.png", ":clinking_glasses:", ":champagne_glass:", "Food & Drink", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd43", "1f943.png", ":tumbler_glass:", null, "Food & Drink", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd44", "1f944.png", ":spoon:", null, "Food & Drink", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd45", "1f945.png", ":goal_net:", ":goal:", "Activities", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd47", "1f947.png", ":1st_place_medal:", ":first_place:", "Activities", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd48", "1f948.png", ":2nd_place_medal:", ":second_place:", "Activities", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd49", "1f949.png", ":3rd_place_medal:", ":third_place:", "Activities", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd4a", "1f94a.png", ":boxing_glove:", null, "Activities", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd4b", "1f94b.png", ":martial_arts_uniform:", null, "Activities", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd4c", "1f94c.png", ":curling_stone:", null, "Activities", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd4d", "1f94d.png", ":lacrosse:", null, "Activities", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd4e", "1f94e.png", ":softball:", null, "Activities", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd4f", "1f94f.png", ":flying_disc:", null, "Activities", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd50", "1f950.png", ":croissant:", null, "Food & Drink", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd51", "1f951.png", ":avocado:", null, "Food & Drink", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd52", "1f952.png", ":cucumber:", null, "Food & Drink", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd53", "1f953.png", ":bacon:", null, "Food & Drink", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd54", "1f954.png", ":potato:", null, "Food & Drink", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd55", "1f955.png", ":carrot:", null, "Food & Drink", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd56", "1f956.png", ":baguette_bread:", ":french_bread:", "Food & Drink", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd57", "1f957.png", ":green_salad:", ":salad:", "Food & Drink", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd58", "1f958.png", ":shallow_pan_of_food:", null, "Food & Drink", "");
        EmojiUtil.add(set, result, "\ud83e\udd59", "1f959.png", ":stuffed_flatbread:", null, "Food & Drink", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd5a", "1f95a.png", ":egg:", null, "Food & Drink", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd5b", "1f95b.png", ":milk_glass:", ":milk:", "Food & Drink", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd5c", "1f95c.png", ":peanuts:", null, "Food & Drink", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd5d", "1f95d.png", ":kiwi_fruit:", ":kiwi:", "Food & Drink", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd5e", "1f95e.png", ":pancakes:", null, "Food & Drink", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd5f", "1f95f.png", ":dumpling:", null, "Food & Drink", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd60", "1f960.png", ":fortune_cookie:", null, "Food & Drink", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd61", "1f961.png", ":takeout_box:", null, "Food & Drink", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd62", "1f962.png", ":chopsticks:", null, "Food & Drink", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd63", "1f963.png", ":bowl_with_spoon:", null, "Food & Drink", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd64", "1f964.png", ":cup_with_straw:", null, "Food & Drink", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd65", "1f965.png", ":coconut:", null, "Food & Drink", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd66", "1f966.png", ":broccoli:", null, "Food & Drink", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd67", "1f967.png", ":pie:", null, "Food & Drink", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd68", "1f968.png", ":pretzel:", null, "Food & Drink", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd69", "1f969.png", ":cut_of_meat:", null, "Food & Drink", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd6a", "1f96a.png", ":sandwich:", null, "Food & Drink", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd6b", "1f96b.png", ":canned_food:", null, "Food & Drink", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd6c", "1f96c.png", ":leafy_green:", null, "Food & Drink", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd6d", "1f96d.png", ":mango:", null, "Food & Drink", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd6e", "1f96e.png", ":moon_cake:", null, "Food & Drink", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd6f", "1f96f.png", ":bagel:", null, "Food & Drink", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd70", "1f970.png", ":smiling_face_with_three_hearts:", ":smiling_face_with_3_hearts:", "Smileys & Emotion", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd71", "1f971.png", ":yawning_face:", null, "Smileys & Emotion", "12.0");
        EmojiUtil.add(set, result, "\ud83e\udd72", "1f972.png", ":smiling_face_with_tear:", null, "Smileys & Emotion", "13.0");
        EmojiUtil.add(set, result, "\ud83e\udd73", "1f973.png", ":partying_face:", null, "Smileys & Emotion", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd74", "1f974.png", ":woozy_face:", null, "Smileys & Emotion", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd75", "1f975.png", ":hot_face:", null, "Smileys & Emotion", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd76", "1f976.png", ":cold_face:", null, "Smileys & Emotion", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd77\ud83c\udffb", "1f977-1f3fb.png", ":ninja_tone1:", ":ninja_light_skin_tone:", "People & Body", "13.0");
        EmojiUtil.add(set, result, "\ud83e\udd77\ud83c\udffc", "1f977-1f3fc.png", ":ninja_tone2:", ":ninja_medium_light_skin_tone:", "People & Body", "13.0");
        EmojiUtil.add(set, result, "\ud83e\udd77\ud83c\udffd", "1f977-1f3fd.png", ":ninja_tone3:", ":ninja_medium_skin_tone:", "People & Body", "13.0");
        EmojiUtil.add(set, result, "\ud83e\udd77\ud83c\udffe", "1f977-1f3fe.png", ":ninja_tone4:", ":ninja_medium_dark_skin_tone:", "People & Body", "13.0");
        EmojiUtil.add(set, result, "\ud83e\udd77\ud83c\udfff", "1f977-1f3ff.png", ":ninja_tone5:", ":ninja_dark_skin_tone:", "People & Body", "13.0");
        EmojiUtil.add(set, result, "\ud83e\udd77", "1f977.png", ":ninja:", null, "People & Body", "13.0");
        EmojiUtil.add(set, result, "\ud83e\udd78", "1f978.png", ":disguised_face:", null, "Smileys & Emotion", "13.0");
        EmojiUtil.add(set, result, "\ud83e\udd79", "1f979.png", ":face_holding_back_tears:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udd7a", "1f97a.png", ":pleading_face:", null, "Smileys & Emotion", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd7b", "1f97b.png", ":sari:", null, "Objects", "12.0");
        EmojiUtil.add(set, result, "\ud83e\udd7c", "1f97c.png", ":lab_coat:", null, "Objects", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd7d", "1f97d.png", ":goggles:", null, "Objects", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd7e", "1f97e.png", ":hiking_boot:", null, "Objects", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd7f", "1f97f.png", ":flat_shoe:", ":womans_flat_shoe:", "Objects", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd80", "1f980.png", ":crab:", null, "Food & Drink", "8.0");
        EmojiUtil.add(set, result, "\ud83e\udd81", "1f981.png", ":lion:", ":lion_face:", "Animals & Nature", "8.0");
        EmojiUtil.add(set, result, "\ud83e\udd82", "1f982.png", ":scorpion:", null, "Animals & Nature", "8.0");
        EmojiUtil.add(set, result, "\ud83e\udd83", "1f983.png", ":turkey:", null, "Animals & Nature", "8.0");
        EmojiUtil.add(set, result, "\ud83e\udd84", "1f984.png", ":unicorn:", null, "Animals & Nature", "8.0");
        EmojiUtil.add(set, result, "\ud83e\udd85", "1f985.png", ":eagle:", null, "Animals & Nature", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd86", "1f986.png", ":duck:", null, "Animals & Nature", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd87", "1f987.png", ":bat:", null, "Animals & Nature", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd88", "1f988.png", ":shark:", null, "Animals & Nature", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd89", "1f989.png", ":owl:", null, "Animals & Nature", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd8a", "1f98a.png", ":fox_face:", ":fox:", "Animals & Nature", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd8b", "1f98b.png", ":butterfly:", null, "Animals & Nature", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd8c", "1f98c.png", ":deer:", null, "Animals & Nature", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd8d", "1f98d.png", ":gorilla:", null, "Animals & Nature", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd8e", "1f98e.png", ":lizard:", null, "Animals & Nature", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd8f", "1f98f.png", ":rhinoceros:", ":rhino:", "Animals & Nature", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd90", "1f990.png", ":shrimp:", null, "Food & Drink", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd91", "1f991.png", ":squid:", null, "Food & Drink", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd92", "1f992.png", ":giraffe:", null, "Animals & Nature", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd93", "1f993.png", ":zebra:", null, "Animals & Nature", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd94", "1f994.png", ":hedgehog:", null, "Animals & Nature", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd95", "1f995.png", ":sauropod:", null, "Animals & Nature", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd96", "1f996.png", ":t-rex:", ":t_rex:", "Animals & Nature", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd97", "1f997.png", ":cricket:", null, "Animals & Nature", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd98", "1f998.png", ":kangaroo:", null, "Animals & Nature", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd99", "1f999.png", ":llama:", null, "Animals & Nature", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd9a", "1f99a.png", ":peacock:", null, "Animals & Nature", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd9b", "1f99b.png", ":hippopotamus:", null, "Animals & Nature", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd9c", "1f99c.png", ":parrot:", null, "Animals & Nature", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd9d", "1f99d.png", ":raccoon:", null, "Animals & Nature", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd9e", "1f99e.png", ":lobster:", null, "Food & Drink", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd9f", "1f99f.png", ":mosquito:", null, "Animals & Nature", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udda0", "1f9a0.png", ":microbe:", null, "Animals & Nature", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udda1", "1f9a1.png", ":badger:", null, "Animals & Nature", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udda2", "1f9a2.png", ":swan:", null, "Animals & Nature", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udda3", "1f9a3.png", ":mammoth:", null, "Animals & Nature", "13.0");
        EmojiUtil.add(set, result, "\ud83e\udda4", "1f9a4.png", ":dodo:", null, "Animals & Nature", "13.0");
        EmojiUtil.add(set, result, "\ud83e\udda5", "1f9a5.png", ":sloth:", null, "Animals & Nature", "12.0");
        EmojiUtil.add(set, result, "\ud83e\udda6", "1f9a6.png", ":otter:", null, "Animals & Nature", "12.0");
        EmojiUtil.add(set, result, "\ud83e\udda7", "1f9a7.png", ":orangutan:", null, "Animals & Nature", "12.0");
        EmojiUtil.add(set, result, "\ud83e\udda8", "1f9a8.png", ":skunk:", null, "Animals & Nature", "12.0");
        EmojiUtil.add(set, result, "\ud83e\udda9", "1f9a9.png", ":flamingo:", null, "Animals & Nature", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddaa", "1f9aa.png", ":oyster:", null, "Food & Drink", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddab", "1f9ab.png", ":beaver:", null, "Animals & Nature", "13.0");
        EmojiUtil.add(set, result, "\ud83e\uddac", "1f9ac.png", ":bison:", null, "Animals & Nature", "13.0");
        EmojiUtil.add(set, result, "\ud83e\uddad", "1f9ad.png", ":seal:", null, "Animals & Nature", "13.0");
        EmojiUtil.add(set, result, "\ud83e\uddae", "1f9ae.png", ":guide_dog:", null, "Animals & Nature", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddaf", "1f9af.png", ":probing_cane:", ":white_cane:", "Objects", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddb0", "1f9b0.png", ":red_haired:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddb1", "1f9b1.png", ":curly_haired:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddb2", "1f9b2.png", ":bald:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddb3", "1f9b3.png", ":white_haired:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddb4", "1f9b4.png", ":bone:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb5\ud83c\udffb", "1f9b5-1f3fb.png", ":leg_tone1:", ":leg_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb5\ud83c\udffc", "1f9b5-1f3fc.png", ":leg_tone2:", ":leg_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb5\ud83c\udffd", "1f9b5-1f3fd.png", ":leg_tone3:", ":leg_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb5\ud83c\udffe", "1f9b5-1f3fe.png", ":leg_tone4:", ":leg_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb5\ud83c\udfff", "1f9b5-1f3ff.png", ":leg_tone5:", ":leg_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb5", "1f9b5.png", ":leg:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb6\ud83c\udffb", "1f9b6-1f3fb.png", ":foot_tone1:", ":foot_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb6\ud83c\udffc", "1f9b6-1f3fc.png", ":foot_tone2:", ":foot_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb6\ud83c\udffd", "1f9b6-1f3fd.png", ":foot_tone3:", ":foot_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb6\ud83c\udffe", "1f9b6-1f3fe.png", ":foot_tone4:", ":foot_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb6\ud83c\udfff", "1f9b6-1f3ff.png", ":foot_tone5:", ":foot_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb6", "1f9b6.png", ":foot:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb7", "1f9b7.png", ":tooth:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb8\ud83c\udffb\u200d\u2640\ufe0f", "1f9b8-1f3fb-200d-2640-fe0f.png", ":woman_superhero_tone1:", ":woman_superhero_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb8\ud83c\udffb\u200d\u2642\ufe0f", "1f9b8-1f3fb-200d-2642-fe0f.png", ":man_superhero_tone1:", ":man_superhero_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb8\ud83c\udffb", "1f9b8-1f3fb.png", ":superhero_tone1:", ":superhero_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb8\ud83c\udffc\u200d\u2640\ufe0f", "1f9b8-1f3fc-200d-2640-fe0f.png", ":woman_superhero_tone2:", ":woman_superhero_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb8\ud83c\udffc\u200d\u2642\ufe0f", "1f9b8-1f3fc-200d-2642-fe0f.png", ":man_superhero_tone2:", ":man_superhero_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb8\ud83c\udffc", "1f9b8-1f3fc.png", ":superhero_tone2:", ":superhero_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb8\ud83c\udffd\u200d\u2640\ufe0f", "1f9b8-1f3fd-200d-2640-fe0f.png", ":woman_superhero_tone3:", ":woman_superhero_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb8\ud83c\udffd\u200d\u2642\ufe0f", "1f9b8-1f3fd-200d-2642-fe0f.png", ":man_superhero_tone3:", ":man_superhero_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb8\ud83c\udffd", "1f9b8-1f3fd.png", ":superhero_tone3:", ":superhero_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb8\ud83c\udffe\u200d\u2640\ufe0f", "1f9b8-1f3fe-200d-2640-fe0f.png", ":woman_superhero_tone4:", ":woman_superhero_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb8\ud83c\udffe\u200d\u2642\ufe0f", "1f9b8-1f3fe-200d-2642-fe0f.png", ":man_superhero_tone4:", ":man_superhero_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb8\ud83c\udffe", "1f9b8-1f3fe.png", ":superhero_tone4:", ":superhero_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb8\ud83c\udfff\u200d\u2640\ufe0f", "1f9b8-1f3ff-200d-2640-fe0f.png", ":woman_superhero_tone5:", ":woman_superhero_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb8\ud83c\udfff\u200d\u2642\ufe0f", "1f9b8-1f3ff-200d-2642-fe0f.png", ":man_superhero_tone5:", ":man_superhero_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb8\ud83c\udfff", "1f9b8-1f3ff.png", ":superhero_tone5:", ":superhero_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb8\u200d\u2640\ufe0f", "1f9b8-200d-2640-fe0f.png", ":superhero_woman:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb8\u200d\u2642\ufe0f", "1f9b8-200d-2642-fe0f.png", ":superhero_man:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb8", "1f9b8.png", ":superhero:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb9\ud83c\udffb\u200d\u2640\ufe0f", "1f9b9-1f3fb-200d-2640-fe0f.png", ":woman_supervillain_tone1:", ":woman_supervillain_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb9\ud83c\udffb\u200d\u2642\ufe0f", "1f9b9-1f3fb-200d-2642-fe0f.png", ":man_supervillain_tone1:", ":man_supervillain_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb9\ud83c\udffb", "1f9b9-1f3fb.png", ":supervillain_tone1:", ":supervillain_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb9\ud83c\udffc\u200d\u2640\ufe0f", "1f9b9-1f3fc-200d-2640-fe0f.png", ":woman_supervillain_tone2:", ":woman_supervillain_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb9\ud83c\udffc\u200d\u2642\ufe0f", "1f9b9-1f3fc-200d-2642-fe0f.png", ":man_supervillain_tone2:", ":man_supervillain_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb9\ud83c\udffc", "1f9b9-1f3fc.png", ":supervillain_tone2:", ":supervillain_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb9\ud83c\udffd\u200d\u2640\ufe0f", "1f9b9-1f3fd-200d-2640-fe0f.png", ":woman_supervillain_tone3:", ":woman_supervillain_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb9\ud83c\udffd\u200d\u2642\ufe0f", "1f9b9-1f3fd-200d-2642-fe0f.png", ":man_supervillain_tone3:", ":man_supervillain_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb9\ud83c\udffd", "1f9b9-1f3fd.png", ":supervillain_tone3:", ":supervillain_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb9\ud83c\udffe\u200d\u2640\ufe0f", "1f9b9-1f3fe-200d-2640-fe0f.png", ":woman_supervillain_tone4:", ":woman_supervillain_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb9\ud83c\udffe\u200d\u2642\ufe0f", "1f9b9-1f3fe-200d-2642-fe0f.png", ":man_supervillain_tone4:", ":man_supervillain_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb9\ud83c\udffe", "1f9b9-1f3fe.png", ":supervillain_tone4:", ":supervillain_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb9\ud83c\udfff\u200d\u2640\ufe0f", "1f9b9-1f3ff-200d-2640-fe0f.png", ":woman_supervillain_tone5:", ":woman_supervillain_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb9\ud83c\udfff\u200d\u2642\ufe0f", "1f9b9-1f3ff-200d-2642-fe0f.png", ":man_supervillain_tone5:", ":man_supervillain_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb9\ud83c\udfff", "1f9b9-1f3ff.png", ":supervillain_tone5:", ":supervillain_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb9\u200d\u2640\ufe0f", "1f9b9-200d-2640-fe0f.png", ":supervillain_woman:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb9\u200d\u2642\ufe0f", "1f9b9-200d-2642-fe0f.png", ":supervillain_man:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddb9", "1f9b9.png", ":supervillain:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddba", "1f9ba.png", ":safety_vest:", null, "Objects", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddbb\ud83c\udffb", "1f9bb-1f3fb.png", ":ear_with_hearing_aid_tone1:", ":ear_with_hearing_aid_light_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddbb\ud83c\udffc", "1f9bb-1f3fc.png", ":ear_with_hearing_aid_tone2:", ":ear_with_hearing_aid_medium_light_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddbb\ud83c\udffd", "1f9bb-1f3fd.png", ":ear_with_hearing_aid_tone3:", ":ear_with_hearing_aid_medium_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddbb\ud83c\udffe", "1f9bb-1f3fe.png", ":ear_with_hearing_aid_tone4:", ":ear_with_hearing_aid_medium_dark_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddbb\ud83c\udfff", "1f9bb-1f3ff.png", ":ear_with_hearing_aid_tone5:", ":ear_with_hearing_aid_dark_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddbb", "1f9bb.png", ":ear_with_hearing_aid:", null, "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddbc", "1f9bc.png", ":motorized_wheelchair:", null, "Travel & Places", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddbd", "1f9bd.png", ":manual_wheelchair:", null, "Travel & Places", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddbe", "1f9be.png", ":mechanical_arm:", null, "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddbf", "1f9bf.png", ":mechanical_leg:", null, "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddc0", "1f9c0.png", ":cheese:", ":cheese_wedge:", "Food & Drink", "8.0");
        EmojiUtil.add(set, result, "\ud83e\uddc1", "1f9c1.png", ":cupcake:", null, "Food & Drink", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddc2", "1f9c2.png", ":salt:", null, "Food & Drink", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddc3", "1f9c3.png", ":beverage_box:", null, "Food & Drink", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddc4", "1f9c4.png", ":garlic:", null, "Food & Drink", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddc5", "1f9c5.png", ":onion:", null, "Food & Drink", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddc6", "1f9c6.png", ":falafel:", null, "Food & Drink", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddc7", "1f9c7.png", ":waffle:", null, "Food & Drink", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddc8", "1f9c8.png", ":butter:", null, "Food & Drink", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddc9", "1f9c9.png", ":mate:", null, "Food & Drink", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddca", "1f9ca.png", ":ice_cube:", ":ice:", "Food & Drink", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddcb", "1f9cb.png", ":bubble_tea:", null, "Food & Drink", "13.0");
    }

    private static void twemoji_b(EmojiSet set, Set<Emoticon> result) {
        EmojiUtil.add(set, result, "\ud83e\uddcc", "1f9cc.png", ":troll:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddcd\ud83c\udffb\u200d\u2640\ufe0f", "1f9cd-1f3fb-200d-2640-fe0f.png", ":woman_standing_person_tone1:", ":woman_standing_light_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddcd\ud83c\udffb\u200d\u2642\ufe0f", "1f9cd-1f3fb-200d-2642-fe0f.png", ":man_standing_person_tone1:", ":man_standing_light_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddcd\ud83c\udffb", "1f9cd-1f3fb.png", ":standing_person_tone1:", ":person_standing_light_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddcd\ud83c\udffc\u200d\u2640\ufe0f", "1f9cd-1f3fc-200d-2640-fe0f.png", ":woman_standing_person_tone2:", ":woman_standing_medium_light_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddcd\ud83c\udffc\u200d\u2642\ufe0f", "1f9cd-1f3fc-200d-2642-fe0f.png", ":man_standing_person_tone2:", ":man_standing_medium_light_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddcd\ud83c\udffc", "1f9cd-1f3fc.png", ":standing_person_tone2:", ":person_standing_medium_light_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddcd\ud83c\udffd\u200d\u2640\ufe0f", "1f9cd-1f3fd-200d-2640-fe0f.png", ":woman_standing_person_tone3:", ":woman_standing_medium_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddcd\ud83c\udffd\u200d\u2642\ufe0f", "1f9cd-1f3fd-200d-2642-fe0f.png", ":man_standing_person_tone3:", ":man_standing_medium_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddcd\ud83c\udffd", "1f9cd-1f3fd.png", ":standing_person_tone3:", ":person_standing_medium_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddcd\ud83c\udffe\u200d\u2640\ufe0f", "1f9cd-1f3fe-200d-2640-fe0f.png", ":woman_standing_person_tone4:", ":woman_standing_medium_dark_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddcd\ud83c\udffe\u200d\u2642\ufe0f", "1f9cd-1f3fe-200d-2642-fe0f.png", ":man_standing_person_tone4:", ":man_standing_medium_dark_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddcd\ud83c\udffe", "1f9cd-1f3fe.png", ":standing_person_tone4:", ":person_standing_medium_dark_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddcd\ud83c\udfff\u200d\u2640\ufe0f", "1f9cd-1f3ff-200d-2640-fe0f.png", ":woman_standing_person_tone5:", ":woman_standing_dark_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddcd\ud83c\udfff\u200d\u2642\ufe0f", "1f9cd-1f3ff-200d-2642-fe0f.png", ":man_standing_person_tone5:", ":man_standing_dark_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddcd\ud83c\udfff", "1f9cd-1f3ff.png", ":standing_person_tone5:", ":person_standing_dark_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddcd\u200d\u2640\ufe0f", "1f9cd-200d-2640-fe0f.png", ":standing_woman:", ":woman_standing:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddcd\u200d\u2642\ufe0f", "1f9cd-200d-2642-fe0f.png", ":standing_man:", ":man_standing:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddcd", "1f9cd.png", ":standing_person:", ":person_standing:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddce\ud83c\udffb\u200d\u2640\ufe0f", "1f9ce-1f3fb-200d-2640-fe0f.png", ":woman_kneeling_person_tone1:", ":woman_kneeling_light_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddce\ud83c\udffb\u200d\u2642\ufe0f", "1f9ce-1f3fb-200d-2642-fe0f.png", ":man_kneeling_person_tone1:", ":man_kneeling_light_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddce\ud83c\udffb", "1f9ce-1f3fb.png", ":kneeling_person_tone1:", ":person_kneeling_light_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddce\ud83c\udffc\u200d\u2640\ufe0f", "1f9ce-1f3fc-200d-2640-fe0f.png", ":woman_kneeling_person_tone2:", ":woman_kneeling_medium_light_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddce\ud83c\udffc\u200d\u2642\ufe0f", "1f9ce-1f3fc-200d-2642-fe0f.png", ":man_kneeling_person_tone2:", ":man_kneeling_medium_light_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddce\ud83c\udffc", "1f9ce-1f3fc.png", ":kneeling_person_tone2:", ":person_kneeling_medium_light_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddce\ud83c\udffd\u200d\u2640\ufe0f", "1f9ce-1f3fd-200d-2640-fe0f.png", ":woman_kneeling_person_tone3:", ":woman_kneeling_medium_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddce\ud83c\udffd\u200d\u2642\ufe0f", "1f9ce-1f3fd-200d-2642-fe0f.png", ":man_kneeling_person_tone3:", ":man_kneeling_medium_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddce\ud83c\udffd", "1f9ce-1f3fd.png", ":kneeling_person_tone3:", ":person_kneeling_medium_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddce\ud83c\udffe\u200d\u2640\ufe0f", "1f9ce-1f3fe-200d-2640-fe0f.png", ":woman_kneeling_person_tone4:", ":woman_kneeling_medium_dark_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddce\ud83c\udffe\u200d\u2642\ufe0f", "1f9ce-1f3fe-200d-2642-fe0f.png", ":man_kneeling_person_tone4:", ":man_kneeling_medium_dark_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddce\ud83c\udffe", "1f9ce-1f3fe.png", ":kneeling_person_tone4:", ":person_kneeling_medium_dark_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddce\ud83c\udfff\u200d\u2640\ufe0f", "1f9ce-1f3ff-200d-2640-fe0f.png", ":woman_kneeling_person_tone5:", ":woman_kneeling_dark_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddce\ud83c\udfff\u200d\u2642\ufe0f", "1f9ce-1f3ff-200d-2642-fe0f.png", ":man_kneeling_person_tone5:", ":man_kneeling_dark_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddce\ud83c\udfff", "1f9ce-1f3ff.png", ":kneeling_person_tone5:", ":person_kneeling_dark_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddce\u200d\u2640\ufe0f", "1f9ce-200d-2640-fe0f.png", ":kneeling_woman:", ":woman_kneeling:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddce\u200d\u2642\ufe0f", "1f9ce-200d-2642-fe0f.png", ":kneeling_man:", ":man_kneeling:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddce", "1f9ce.png", ":kneeling_person:", ":person_kneeling:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddcf\ud83c\udffb\u200d\u2640\ufe0f", "1f9cf-1f3fb-200d-2640-fe0f.png", ":woman_deaf_person_tone1:", ":deaf_woman_light_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddcf\ud83c\udffb\u200d\u2642\ufe0f", "1f9cf-1f3fb-200d-2642-fe0f.png", ":man_deaf_person_tone1:", ":deaf_man_light_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddcf\ud83c\udffb", "1f9cf-1f3fb.png", ":deaf_person_tone1:", ":deaf_person_light_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddcf\ud83c\udffc\u200d\u2640\ufe0f", "1f9cf-1f3fc-200d-2640-fe0f.png", ":woman_deaf_person_tone2:", ":deaf_woman_medium_light_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddcf\ud83c\udffc\u200d\u2642\ufe0f", "1f9cf-1f3fc-200d-2642-fe0f.png", ":man_deaf_person_tone2:", ":deaf_man_medium_light_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddcf\ud83c\udffc", "1f9cf-1f3fc.png", ":deaf_person_tone2:", ":deaf_person_medium_light_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddcf\ud83c\udffd\u200d\u2640\ufe0f", "1f9cf-1f3fd-200d-2640-fe0f.png", ":woman_deaf_person_tone3:", ":deaf_woman_medium_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddcf\ud83c\udffd\u200d\u2642\ufe0f", "1f9cf-1f3fd-200d-2642-fe0f.png", ":man_deaf_person_tone3:", ":deaf_man_medium_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddcf\ud83c\udffd", "1f9cf-1f3fd.png", ":deaf_person_tone3:", ":deaf_person_medium_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddcf\ud83c\udffe\u200d\u2640\ufe0f", "1f9cf-1f3fe-200d-2640-fe0f.png", ":woman_deaf_person_tone4:", ":deaf_woman_medium_dark_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddcf\ud83c\udffe\u200d\u2642\ufe0f", "1f9cf-1f3fe-200d-2642-fe0f.png", ":man_deaf_person_tone4:", ":deaf_man_medium_dark_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddcf\ud83c\udffe", "1f9cf-1f3fe.png", ":deaf_person_tone4:", ":deaf_person_medium_dark_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddcf\ud83c\udfff\u200d\u2640\ufe0f", "1f9cf-1f3ff-200d-2640-fe0f.png", ":woman_deaf_person_tone5:", ":deaf_woman_dark_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddcf\ud83c\udfff\u200d\u2642\ufe0f", "1f9cf-1f3ff-200d-2642-fe0f.png", ":man_deaf_person_tone5:", ":deaf_man_dark_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddcf\ud83c\udfff", "1f9cf-1f3ff.png", ":deaf_person_tone5:", ":deaf_person_dark_skin_tone:", "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddcf\u200d\u2640\ufe0f", "1f9cf-200d-2640-fe0f.png", ":deaf_woman:", null, "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddcf\u200d\u2642\ufe0f", "1f9cf-200d-2642-fe0f.png", ":deaf_man:", null, "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddcf", "1f9cf.png", ":deaf_person:", null, "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddd0", "1f9d0.png", ":monocle_face:", ":face_with_monocle:", "Smileys & Emotion", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb\u200d\ud83c\udf3e", "1f9d1-1f3fb-200d-1f33e.png", ":farmer_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb\u200d\ud83c\udf73", "1f9d1-1f3fb-200d-1f373.png", ":cook_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb\u200d\ud83c\udf7c", "1f9d1-1f3fb-200d-1f37c.png", ":person_feeding_baby_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb\u200d\ud83c\udf84", "1f9d1-1f3fb-200d-1f384.png", ":mx_claus_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb\u200d\ud83c\udf93", "1f9d1-1f3fb-200d-1f393.png", ":student_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb\u200d\ud83c\udfa4", "1f9d1-1f3fb-200d-1f3a4.png", ":singer_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb\u200d\ud83c\udfa8", "1f9d1-1f3fb-200d-1f3a8.png", ":artist_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb\u200d\ud83c\udfeb", "1f9d1-1f3fb-200d-1f3eb.png", ":teacher_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb\u200d\ud83c\udfed", "1f9d1-1f3fb-200d-1f3ed.png", ":factory_worker_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb\u200d\ud83d\udcbb", "1f9d1-1f3fb-200d-1f4bb.png", ":technologist_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb\u200d\ud83d\udcbc", "1f9d1-1f3fb-200d-1f4bc.png", ":office_worker_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb\u200d\ud83d\udd27", "1f9d1-1f3fb-200d-1f527.png", ":mechanic_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb\u200d\ud83d\udd2c", "1f9d1-1f3fb-200d-1f52c.png", ":scientist_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb\u200d\ud83d\ude80", "1f9d1-1f3fb-200d-1f680.png", ":astronaut_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb\u200d\ud83d\ude92", "1f9d1-1f3fb-200d-1f692.png", ":firefighter_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb\u200d\ud83e\udd1d\u200d\ud83e\uddd1\ud83c\udffb", "1f9d1-1f3fb-200d-1f91d-200d-1f9d1-1f3fb.png", ":people_holding_hands_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb\u200d\ud83e\udd1d\u200d\ud83e\uddd1\ud83c\udffc", "1f9d1-1f3fb-200d-1f91d-200d-1f9d1-1f3fc.png", ":people_holding_hands_light_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb\u200d\ud83e\udd1d\u200d\ud83e\uddd1\ud83c\udffd", "1f9d1-1f3fb-200d-1f91d-200d-1f9d1-1f3fd.png", ":people_holding_hands_light_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb\u200d\ud83e\udd1d\u200d\ud83e\uddd1\ud83c\udffe", "1f9d1-1f3fb-200d-1f91d-200d-1f9d1-1f3fe.png", ":people_holding_hands_light_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb\u200d\ud83e\udd1d\u200d\ud83e\uddd1\ud83c\udfff", "1f9d1-1f3fb-200d-1f91d-200d-1f9d1-1f3ff.png", ":people_holding_hands_light_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb\u200d\ud83e\uddaf", "1f9d1-1f3fb-200d-1f9af.png", ":person_with_white_cane_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb\u200d\ud83e\uddb0", "1f9d1-1f3fb-200d-1f9b0.png", ":person_light_skin_tone_red_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb\u200d\ud83e\uddb1", "1f9d1-1f3fb-200d-1f9b1.png", ":person_light_skin_tone_curly_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb\u200d\ud83e\uddb2", "1f9d1-1f3fb-200d-1f9b2.png", ":person_light_skin_tone_bald:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb\u200d\ud83e\uddb3", "1f9d1-1f3fb-200d-1f9b3.png", ":person_light_skin_tone_white_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb\u200d\ud83e\uddbc", "1f9d1-1f3fb-200d-1f9bc.png", ":person_in_motorized_wheelchair_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb\u200d\ud83e\uddbd", "1f9d1-1f3fb-200d-1f9bd.png", ":person_in_manual_wheelchair_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb\u200d\u2695\ufe0f", "1f9d1-1f3fb-200d-2695-fe0f.png", ":health_worker_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb\u200d\u2696\ufe0f", "1f9d1-1f3fb-200d-2696-fe0f.png", ":judge_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb\u200d\u2708\ufe0f", "1f9d1-1f3fb-200d-2708-fe0f.png", ":pilot_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83e\uddd1\ud83c\udffc", "1f9d1-1f3fb-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3fc.png", ":kiss_person_person_light_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83e\uddd1\ud83c\udffd", "1f9d1-1f3fb-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3fd.png", ":kiss_person_person_light_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83e\uddd1\ud83c\udffe", "1f9d1-1f3fb-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3fe.png", ":kiss_person_person_light_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83e\uddd1\ud83c\udfff", "1f9d1-1f3fb-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3ff.png", ":kiss_person_person_light_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83e\uddd1\ud83c\udffc", "1f9d1-1f3fb-200d-2764-fe0f-200d-1f9d1-1f3fc.png", ":couple_with_heart_person_person_light_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83e\uddd1\ud83c\udffd", "1f9d1-1f3fb-200d-2764-fe0f-200d-1f9d1-1f3fd.png", ":couple_with_heart_person_person_light_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83e\uddd1\ud83c\udffe", "1f9d1-1f3fb-200d-2764-fe0f-200d-1f9d1-1f3fe.png", ":couple_with_heart_person_person_light_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb\u200d\u2764\ufe0f\u200d\ud83e\uddd1\ud83c\udfff", "1f9d1-1f3fb-200d-2764-fe0f-200d-1f9d1-1f3ff.png", ":couple_with_heart_person_person_light_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffb", "1f9d1-1f3fb.png", ":adult_tone1:", ":person_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc\u200d\ud83c\udf3e", "1f9d1-1f3fc-200d-1f33e.png", ":farmer_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc\u200d\ud83c\udf73", "1f9d1-1f3fc-200d-1f373.png", ":cook_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc\u200d\ud83c\udf7c", "1f9d1-1f3fc-200d-1f37c.png", ":person_feeding_baby_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc\u200d\ud83c\udf84", "1f9d1-1f3fc-200d-1f384.png", ":mx_claus_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc\u200d\ud83c\udf93", "1f9d1-1f3fc-200d-1f393.png", ":student_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc\u200d\ud83c\udfa4", "1f9d1-1f3fc-200d-1f3a4.png", ":singer_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc\u200d\ud83c\udfa8", "1f9d1-1f3fc-200d-1f3a8.png", ":artist_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc\u200d\ud83c\udfeb", "1f9d1-1f3fc-200d-1f3eb.png", ":teacher_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc\u200d\ud83c\udfed", "1f9d1-1f3fc-200d-1f3ed.png", ":factory_worker_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc\u200d\ud83d\udcbb", "1f9d1-1f3fc-200d-1f4bb.png", ":technologist_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc\u200d\ud83d\udcbc", "1f9d1-1f3fc-200d-1f4bc.png", ":office_worker_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc\u200d\ud83d\udd27", "1f9d1-1f3fc-200d-1f527.png", ":mechanic_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc\u200d\ud83d\udd2c", "1f9d1-1f3fc-200d-1f52c.png", ":scientist_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc\u200d\ud83d\ude80", "1f9d1-1f3fc-200d-1f680.png", ":astronaut_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc\u200d\ud83d\ude92", "1f9d1-1f3fc-200d-1f692.png", ":firefighter_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc\u200d\ud83e\udd1d\u200d\ud83e\uddd1\ud83c\udffb", "1f9d1-1f3fc-200d-1f91d-200d-1f9d1-1f3fb.png", ":people_holding_hands_medium_light_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc\u200d\ud83e\udd1d\u200d\ud83e\uddd1\ud83c\udffc", "1f9d1-1f3fc-200d-1f91d-200d-1f9d1-1f3fc.png", ":people_holding_hands_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc\u200d\ud83e\udd1d\u200d\ud83e\uddd1\ud83c\udffd", "1f9d1-1f3fc-200d-1f91d-200d-1f9d1-1f3fd.png", ":people_holding_hands_medium_light_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc\u200d\ud83e\udd1d\u200d\ud83e\uddd1\ud83c\udffe", "1f9d1-1f3fc-200d-1f91d-200d-1f9d1-1f3fe.png", ":people_holding_hands_medium_light_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc\u200d\ud83e\udd1d\u200d\ud83e\uddd1\ud83c\udfff", "1f9d1-1f3fc-200d-1f91d-200d-1f9d1-1f3ff.png", ":people_holding_hands_medium_light_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc\u200d\ud83e\uddaf", "1f9d1-1f3fc-200d-1f9af.png", ":person_with_white_cane_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc\u200d\ud83e\uddb0", "1f9d1-1f3fc-200d-1f9b0.png", ":person_medium_light_skin_tone_red_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc\u200d\ud83e\uddb1", "1f9d1-1f3fc-200d-1f9b1.png", ":person_medium_light_skin_tone_curly_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc\u200d\ud83e\uddb2", "1f9d1-1f3fc-200d-1f9b2.png", ":person_medium_light_skin_tone_bald:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc\u200d\ud83e\uddb3", "1f9d1-1f3fc-200d-1f9b3.png", ":person_medium_light_skin_tone_white_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc\u200d\ud83e\uddbc", "1f9d1-1f3fc-200d-1f9bc.png", ":person_in_motorized_wheelchair_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc\u200d\ud83e\uddbd", "1f9d1-1f3fc-200d-1f9bd.png", ":person_in_manual_wheelchair_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc\u200d\u2695\ufe0f", "1f9d1-1f3fc-200d-2695-fe0f.png", ":health_worker_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc\u200d\u2696\ufe0f", "1f9d1-1f3fc-200d-2696-fe0f.png", ":judge_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc\u200d\u2708\ufe0f", "1f9d1-1f3fc-200d-2708-fe0f.png", ":pilot_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83e\uddd1\ud83c\udffb", "1f9d1-1f3fc-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3fb.png", ":kiss_person_person_medium_light_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83e\uddd1\ud83c\udffd", "1f9d1-1f3fc-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3fd.png", ":kiss_person_person_medium_light_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83e\uddd1\ud83c\udffe", "1f9d1-1f3fc-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3fe.png", ":kiss_person_person_medium_light_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83e\uddd1\ud83c\udfff", "1f9d1-1f3fc-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3ff.png", ":kiss_person_person_medium_light_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83e\uddd1\ud83c\udffb", "1f9d1-1f3fc-200d-2764-fe0f-200d-1f9d1-1f3fb.png", ":couple_with_heart_person_person_medium_light_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83e\uddd1\ud83c\udffd", "1f9d1-1f3fc-200d-2764-fe0f-200d-1f9d1-1f3fd.png", ":couple_with_heart_person_person_medium_light_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83e\uddd1\ud83c\udffe", "1f9d1-1f3fc-200d-2764-fe0f-200d-1f9d1-1f3fe.png", ":couple_with_heart_person_person_medium_light_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc\u200d\u2764\ufe0f\u200d\ud83e\uddd1\ud83c\udfff", "1f9d1-1f3fc-200d-2764-fe0f-200d-1f9d1-1f3ff.png", ":couple_with_heart_person_person_medium_light_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffc", "1f9d1-1f3fc.png", ":adult_tone2:", ":person_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd\u200d\ud83c\udf3e", "1f9d1-1f3fd-200d-1f33e.png", ":farmer_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd\u200d\ud83c\udf73", "1f9d1-1f3fd-200d-1f373.png", ":cook_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd\u200d\ud83c\udf7c", "1f9d1-1f3fd-200d-1f37c.png", ":person_feeding_baby_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd\u200d\ud83c\udf84", "1f9d1-1f3fd-200d-1f384.png", ":mx_claus_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd\u200d\ud83c\udf93", "1f9d1-1f3fd-200d-1f393.png", ":student_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd\u200d\ud83c\udfa4", "1f9d1-1f3fd-200d-1f3a4.png", ":singer_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd\u200d\ud83c\udfa8", "1f9d1-1f3fd-200d-1f3a8.png", ":artist_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd\u200d\ud83c\udfeb", "1f9d1-1f3fd-200d-1f3eb.png", ":teacher_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd\u200d\ud83c\udfed", "1f9d1-1f3fd-200d-1f3ed.png", ":factory_worker_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd\u200d\ud83d\udcbb", "1f9d1-1f3fd-200d-1f4bb.png", ":technologist_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd\u200d\ud83d\udcbc", "1f9d1-1f3fd-200d-1f4bc.png", ":office_worker_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd\u200d\ud83d\udd27", "1f9d1-1f3fd-200d-1f527.png", ":mechanic_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd\u200d\ud83d\udd2c", "1f9d1-1f3fd-200d-1f52c.png", ":scientist_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd\u200d\ud83d\ude80", "1f9d1-1f3fd-200d-1f680.png", ":astronaut_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd\u200d\ud83d\ude92", "1f9d1-1f3fd-200d-1f692.png", ":firefighter_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd\u200d\ud83e\udd1d\u200d\ud83e\uddd1\ud83c\udffb", "1f9d1-1f3fd-200d-1f91d-200d-1f9d1-1f3fb.png", ":people_holding_hands_medium_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd\u200d\ud83e\udd1d\u200d\ud83e\uddd1\ud83c\udffc", "1f9d1-1f3fd-200d-1f91d-200d-1f9d1-1f3fc.png", ":people_holding_hands_medium_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd\u200d\ud83e\udd1d\u200d\ud83e\uddd1\ud83c\udffd", "1f9d1-1f3fd-200d-1f91d-200d-1f9d1-1f3fd.png", ":people_holding_hands_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd\u200d\ud83e\udd1d\u200d\ud83e\uddd1\ud83c\udffe", "1f9d1-1f3fd-200d-1f91d-200d-1f9d1-1f3fe.png", ":people_holding_hands_medium_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd\u200d\ud83e\udd1d\u200d\ud83e\uddd1\ud83c\udfff", "1f9d1-1f3fd-200d-1f91d-200d-1f9d1-1f3ff.png", ":people_holding_hands_medium_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd\u200d\ud83e\uddaf", "1f9d1-1f3fd-200d-1f9af.png", ":person_with_white_cane_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd\u200d\ud83e\uddb0", "1f9d1-1f3fd-200d-1f9b0.png", ":person_medium_skin_tone_red_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd\u200d\ud83e\uddb1", "1f9d1-1f3fd-200d-1f9b1.png", ":person_medium_skin_tone_curly_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd\u200d\ud83e\uddb2", "1f9d1-1f3fd-200d-1f9b2.png", ":person_medium_skin_tone_bald:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd\u200d\ud83e\uddb3", "1f9d1-1f3fd-200d-1f9b3.png", ":person_medium_skin_tone_white_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd\u200d\ud83e\uddbc", "1f9d1-1f3fd-200d-1f9bc.png", ":person_in_motorized_wheelchair_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd\u200d\ud83e\uddbd", "1f9d1-1f3fd-200d-1f9bd.png", ":person_in_manual_wheelchair_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd\u200d\u2695\ufe0f", "1f9d1-1f3fd-200d-2695-fe0f.png", ":health_worker_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd\u200d\u2696\ufe0f", "1f9d1-1f3fd-200d-2696-fe0f.png", ":judge_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd\u200d\u2708\ufe0f", "1f9d1-1f3fd-200d-2708-fe0f.png", ":pilot_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83e\uddd1\ud83c\udffb", "1f9d1-1f3fd-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3fb.png", ":kiss_person_person_medium_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83e\uddd1\ud83c\udffc", "1f9d1-1f3fd-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3fc.png", ":kiss_person_person_medium_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83e\uddd1\ud83c\udffe", "1f9d1-1f3fd-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3fe.png", ":kiss_person_person_medium_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83e\uddd1\ud83c\udfff", "1f9d1-1f3fd-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3ff.png", ":kiss_person_person_medium_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83e\uddd1\ud83c\udffb", "1f9d1-1f3fd-200d-2764-fe0f-200d-1f9d1-1f3fb.png", ":couple_with_heart_person_person_medium_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83e\uddd1\ud83c\udffc", "1f9d1-1f3fd-200d-2764-fe0f-200d-1f9d1-1f3fc.png", ":couple_with_heart_person_person_medium_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83e\uddd1\ud83c\udffe", "1f9d1-1f3fd-200d-2764-fe0f-200d-1f9d1-1f3fe.png", ":couple_with_heart_person_person_medium_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd\u200d\u2764\ufe0f\u200d\ud83e\uddd1\ud83c\udfff", "1f9d1-1f3fd-200d-2764-fe0f-200d-1f9d1-1f3ff.png", ":couple_with_heart_person_person_medium_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffd", "1f9d1-1f3fd.png", ":adult_tone3:", ":person_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe\u200d\ud83c\udf3e", "1f9d1-1f3fe-200d-1f33e.png", ":farmer_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe\u200d\ud83c\udf73", "1f9d1-1f3fe-200d-1f373.png", ":cook_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe\u200d\ud83c\udf7c", "1f9d1-1f3fe-200d-1f37c.png", ":person_feeding_baby_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe\u200d\ud83c\udf84", "1f9d1-1f3fe-200d-1f384.png", ":mx_claus_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe\u200d\ud83c\udf93", "1f9d1-1f3fe-200d-1f393.png", ":student_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe\u200d\ud83c\udfa4", "1f9d1-1f3fe-200d-1f3a4.png", ":singer_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe\u200d\ud83c\udfa8", "1f9d1-1f3fe-200d-1f3a8.png", ":artist_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe\u200d\ud83c\udfeb", "1f9d1-1f3fe-200d-1f3eb.png", ":teacher_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe\u200d\ud83c\udfed", "1f9d1-1f3fe-200d-1f3ed.png", ":factory_worker_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe\u200d\ud83d\udcbb", "1f9d1-1f3fe-200d-1f4bb.png", ":technologist_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe\u200d\ud83d\udcbc", "1f9d1-1f3fe-200d-1f4bc.png", ":office_worker_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe\u200d\ud83d\udd27", "1f9d1-1f3fe-200d-1f527.png", ":mechanic_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe\u200d\ud83d\udd2c", "1f9d1-1f3fe-200d-1f52c.png", ":scientist_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe\u200d\ud83d\ude80", "1f9d1-1f3fe-200d-1f680.png", ":astronaut_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe\u200d\ud83d\ude92", "1f9d1-1f3fe-200d-1f692.png", ":firefighter_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe\u200d\ud83e\udd1d\u200d\ud83e\uddd1\ud83c\udffb", "1f9d1-1f3fe-200d-1f91d-200d-1f9d1-1f3fb.png", ":people_holding_hands_medium_dark_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe\u200d\ud83e\udd1d\u200d\ud83e\uddd1\ud83c\udffc", "1f9d1-1f3fe-200d-1f91d-200d-1f9d1-1f3fc.png", ":people_holding_hands_medium_dark_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe\u200d\ud83e\udd1d\u200d\ud83e\uddd1\ud83c\udffd", "1f9d1-1f3fe-200d-1f91d-200d-1f9d1-1f3fd.png", ":people_holding_hands_medium_dark_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe\u200d\ud83e\udd1d\u200d\ud83e\uddd1\ud83c\udffe", "1f9d1-1f3fe-200d-1f91d-200d-1f9d1-1f3fe.png", ":people_holding_hands_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe\u200d\ud83e\udd1d\u200d\ud83e\uddd1\ud83c\udfff", "1f9d1-1f3fe-200d-1f91d-200d-1f9d1-1f3ff.png", ":people_holding_hands_medium_dark_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe\u200d\ud83e\uddaf", "1f9d1-1f3fe-200d-1f9af.png", ":person_with_white_cane_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe\u200d\ud83e\uddb0", "1f9d1-1f3fe-200d-1f9b0.png", ":person_medium_dark_skin_tone_red_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe\u200d\ud83e\uddb1", "1f9d1-1f3fe-200d-1f9b1.png", ":person_medium_dark_skin_tone_curly_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe\u200d\ud83e\uddb2", "1f9d1-1f3fe-200d-1f9b2.png", ":person_medium_dark_skin_tone_bald:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe\u200d\ud83e\uddb3", "1f9d1-1f3fe-200d-1f9b3.png", ":person_medium_dark_skin_tone_white_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe\u200d\ud83e\uddbc", "1f9d1-1f3fe-200d-1f9bc.png", ":person_in_motorized_wheelchair_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe\u200d\ud83e\uddbd", "1f9d1-1f3fe-200d-1f9bd.png", ":person_in_manual_wheelchair_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe\u200d\u2695\ufe0f", "1f9d1-1f3fe-200d-2695-fe0f.png", ":health_worker_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe\u200d\u2696\ufe0f", "1f9d1-1f3fe-200d-2696-fe0f.png", ":judge_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe\u200d\u2708\ufe0f", "1f9d1-1f3fe-200d-2708-fe0f.png", ":pilot_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83e\uddd1\ud83c\udffb", "1f9d1-1f3fe-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3fb.png", ":kiss_person_person_medium_dark_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83e\uddd1\ud83c\udffc", "1f9d1-1f3fe-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3fc.png", ":kiss_person_person_medium_dark_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83e\uddd1\ud83c\udffd", "1f9d1-1f3fe-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3fd.png", ":kiss_person_person_medium_dark_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83e\uddd1\ud83c\udfff", "1f9d1-1f3fe-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3ff.png", ":kiss_person_person_medium_dark_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83e\uddd1\ud83c\udffb", "1f9d1-1f3fe-200d-2764-fe0f-200d-1f9d1-1f3fb.png", ":couple_with_heart_person_person_medium_dark_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83e\uddd1\ud83c\udffc", "1f9d1-1f3fe-200d-2764-fe0f-200d-1f9d1-1f3fc.png", ":couple_with_heart_person_person_medium_dark_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83e\uddd1\ud83c\udffd", "1f9d1-1f3fe-200d-2764-fe0f-200d-1f9d1-1f3fd.png", ":couple_with_heart_person_person_medium_dark_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe\u200d\u2764\ufe0f\u200d\ud83e\uddd1\ud83c\udfff", "1f9d1-1f3fe-200d-2764-fe0f-200d-1f9d1-1f3ff.png", ":couple_with_heart_person_person_medium_dark_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udffe", "1f9d1-1f3fe.png", ":adult_tone4:", ":person_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff\u200d\ud83c\udf3e", "1f9d1-1f3ff-200d-1f33e.png", ":farmer_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff\u200d\ud83c\udf73", "1f9d1-1f3ff-200d-1f373.png", ":cook_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff\u200d\ud83c\udf7c", "1f9d1-1f3ff-200d-1f37c.png", ":person_feeding_baby_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff\u200d\ud83c\udf84", "1f9d1-1f3ff-200d-1f384.png", ":mx_claus_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff\u200d\ud83c\udf93", "1f9d1-1f3ff-200d-1f393.png", ":student_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff\u200d\ud83c\udfa4", "1f9d1-1f3ff-200d-1f3a4.png", ":singer_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff\u200d\ud83c\udfa8", "1f9d1-1f3ff-200d-1f3a8.png", ":artist_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff\u200d\ud83c\udfeb", "1f9d1-1f3ff-200d-1f3eb.png", ":teacher_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff\u200d\ud83c\udfed", "1f9d1-1f3ff-200d-1f3ed.png", ":factory_worker_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff\u200d\ud83d\udcbb", "1f9d1-1f3ff-200d-1f4bb.png", ":technologist_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff\u200d\ud83d\udcbc", "1f9d1-1f3ff-200d-1f4bc.png", ":office_worker_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff\u200d\ud83d\udd27", "1f9d1-1f3ff-200d-1f527.png", ":mechanic_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff\u200d\ud83d\udd2c", "1f9d1-1f3ff-200d-1f52c.png", ":scientist_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff\u200d\ud83d\ude80", "1f9d1-1f3ff-200d-1f680.png", ":astronaut_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff\u200d\ud83d\ude92", "1f9d1-1f3ff-200d-1f692.png", ":firefighter_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff\u200d\ud83e\udd1d\u200d\ud83e\uddd1\ud83c\udffb", "1f9d1-1f3ff-200d-1f91d-200d-1f9d1-1f3fb.png", ":people_holding_hands_dark_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff\u200d\ud83e\udd1d\u200d\ud83e\uddd1\ud83c\udffc", "1f9d1-1f3ff-200d-1f91d-200d-1f9d1-1f3fc.png", ":people_holding_hands_dark_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff\u200d\ud83e\udd1d\u200d\ud83e\uddd1\ud83c\udffd", "1f9d1-1f3ff-200d-1f91d-200d-1f9d1-1f3fd.png", ":people_holding_hands_dark_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff\u200d\ud83e\udd1d\u200d\ud83e\uddd1\ud83c\udffe", "1f9d1-1f3ff-200d-1f91d-200d-1f9d1-1f3fe.png", ":people_holding_hands_dark_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff\u200d\ud83e\udd1d\u200d\ud83e\uddd1\ud83c\udfff", "1f9d1-1f3ff-200d-1f91d-200d-1f9d1-1f3ff.png", ":people_holding_hands_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff\u200d\ud83e\uddaf", "1f9d1-1f3ff-200d-1f9af.png", ":person_with_white_cane_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff\u200d\ud83e\uddb0", "1f9d1-1f3ff-200d-1f9b0.png", ":person_dark_skin_tone_red_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff\u200d\ud83e\uddb1", "1f9d1-1f3ff-200d-1f9b1.png", ":person_dark_skin_tone_curly_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff\u200d\ud83e\uddb2", "1f9d1-1f3ff-200d-1f9b2.png", ":person_dark_skin_tone_bald:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff\u200d\ud83e\uddb3", "1f9d1-1f3ff-200d-1f9b3.png", ":person_dark_skin_tone_white_hair:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff\u200d\ud83e\uddbc", "1f9d1-1f3ff-200d-1f9bc.png", ":person_in_motorized_wheelchair_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff\u200d\ud83e\uddbd", "1f9d1-1f3ff-200d-1f9bd.png", ":person_in_manual_wheelchair_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff\u200d\u2695\ufe0f", "1f9d1-1f3ff-200d-2695-fe0f.png", ":health_worker_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff\u200d\u2696\ufe0f", "1f9d1-1f3ff-200d-2696-fe0f.png", ":judge_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff\u200d\u2708\ufe0f", "1f9d1-1f3ff-200d-2708-fe0f.png", ":pilot_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83e\uddd1\ud83c\udffb", "1f9d1-1f3ff-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3fb.png", ":kiss_person_person_dark_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83e\uddd1\ud83c\udffc", "1f9d1-1f3ff-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3fc.png", ":kiss_person_person_dark_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83e\uddd1\ud83c\udffd", "1f9d1-1f3ff-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3fd.png", ":kiss_person_person_dark_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83d\udc8b\u200d\ud83e\uddd1\ud83c\udffe", "1f9d1-1f3ff-200d-2764-fe0f-200d-1f48b-200d-1f9d1-1f3fe.png", ":kiss_person_person_dark_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83e\uddd1\ud83c\udffb", "1f9d1-1f3ff-200d-2764-fe0f-200d-1f9d1-1f3fb.png", ":couple_with_heart_person_person_dark_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83e\uddd1\ud83c\udffc", "1f9d1-1f3ff-200d-2764-fe0f-200d-1f9d1-1f3fc.png", ":couple_with_heart_person_person_dark_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83e\uddd1\ud83c\udffd", "1f9d1-1f3ff-200d-2764-fe0f-200d-1f9d1-1f3fd.png", ":couple_with_heart_person_person_dark_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff\u200d\u2764\ufe0f\u200d\ud83e\uddd1\ud83c\udffe", "1f9d1-1f3ff-200d-2764-fe0f-200d-1f9d1-1f3fe.png", ":couple_with_heart_person_person_dark_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uddd1\ud83c\udfff", "1f9d1-1f3ff.png", ":adult_tone5:", ":person_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd1\u200d\ud83c\udf3e", "1f9d1-200d-1f33e.png", ":farmer:", null, "People & Body", "12.1");
        EmojiUtil.add(set, result, "\ud83e\uddd1\u200d\ud83c\udf73", "1f9d1-200d-1f373.png", ":cook:", null, "People & Body", "12.1");
        EmojiUtil.add(set, result, "\ud83e\uddd1\u200d\ud83c\udf7c", "1f9d1-200d-1f37c.png", ":person_feeding_baby:", null, "People & Body", "13.0");
        EmojiUtil.add(set, result, "\ud83e\uddd1\u200d\ud83c\udf84", "1f9d1-200d-1f384.png", ":mx_claus:", null, "People & Body", "13.0");
        EmojiUtil.add(set, result, "\ud83e\uddd1\u200d\ud83c\udf93", "1f9d1-200d-1f393.png", ":student:", null, "People & Body", "12.1");
        EmojiUtil.add(set, result, "\ud83e\uddd1\u200d\ud83c\udfa4", "1f9d1-200d-1f3a4.png", ":singer:", null, "People & Body", "12.1");
        EmojiUtil.add(set, result, "\ud83e\uddd1\u200d\ud83c\udfa8", "1f9d1-200d-1f3a8.png", ":artist:", null, "People & Body", "12.1");
        EmojiUtil.add(set, result, "\ud83e\uddd1\u200d\ud83c\udfeb", "1f9d1-200d-1f3eb.png", ":teacher:", null, "People & Body", "12.1");
        EmojiUtil.add(set, result, "\ud83e\uddd1\u200d\ud83c\udfed", "1f9d1-200d-1f3ed.png", ":factory_worker:", null, "People & Body", "12.1");
        EmojiUtil.add(set, result, "\ud83e\uddd1\u200d\ud83d\udcbb", "1f9d1-200d-1f4bb.png", ":technologist:", null, "People & Body", "12.1");
        EmojiUtil.add(set, result, "\ud83e\uddd1\u200d\ud83d\udcbc", "1f9d1-200d-1f4bc.png", ":office_worker:", null, "People & Body", "12.1");
        EmojiUtil.add(set, result, "\ud83e\uddd1\u200d\ud83d\udd27", "1f9d1-200d-1f527.png", ":mechanic:", null, "People & Body", "12.1");
        EmojiUtil.add(set, result, "\ud83e\uddd1\u200d\ud83d\udd2c", "1f9d1-200d-1f52c.png", ":scientist:", null, "People & Body", "12.1");
        EmojiUtil.add(set, result, "\ud83e\uddd1\u200d\ud83d\ude80", "1f9d1-200d-1f680.png", ":astronaut:", null, "People & Body", "12.1");
        EmojiUtil.add(set, result, "\ud83e\uddd1\u200d\ud83d\ude92", "1f9d1-200d-1f692.png", ":firefighter:", null, "People & Body", "12.1");
        EmojiUtil.add(set, result, "\ud83e\uddd1\u200d\ud83e\udd1d\u200d\ud83e\uddd1", "1f9d1-200d-1f91d-200d-1f9d1.png", ":people_holding_hands:", null, "People & Body", "12.0");
        EmojiUtil.add(set, result, "\ud83e\uddd1\u200d\ud83e\uddaf", "1f9d1-200d-1f9af.png", ":person_with_probing_cane:", ":person_with_white_cane:", "People & Body", "12.1");
        EmojiUtil.add(set, result, "\ud83e\uddd1\u200d\ud83e\uddb0", "1f9d1-200d-1f9b0.png", ":person_red_hair:", null, "People & Body", "12.1");
        EmojiUtil.add(set, result, "\ud83e\uddd1\u200d\ud83e\uddb1", "1f9d1-200d-1f9b1.png", ":person_curly_hair:", null, "People & Body", "12.1");
        EmojiUtil.add(set, result, "\ud83e\uddd1\u200d\ud83e\uddb2", "1f9d1-200d-1f9b2.png", ":person_bald:", null, "People & Body", "12.1");
        EmojiUtil.add(set, result, "\ud83e\uddd1\u200d\ud83e\uddb3", "1f9d1-200d-1f9b3.png", ":person_white_hair:", null, "People & Body", "12.1");
        EmojiUtil.add(set, result, "\ud83e\uddd1\u200d\ud83e\uddbc", "1f9d1-200d-1f9bc.png", ":person_in_motorized_wheelchair:", null, "People & Body", "12.1");
        EmojiUtil.add(set, result, "\ud83e\uddd1\u200d\ud83e\uddbd", "1f9d1-200d-1f9bd.png", ":person_in_manual_wheelchair:", null, "People & Body", "12.1");
        EmojiUtil.add(set, result, "\ud83e\uddd1\u200d\u2695\ufe0f", "1f9d1-200d-2695-fe0f.png", ":health_worker:", null, "People & Body", "12.1");
        EmojiUtil.add(set, result, "\ud83e\uddd1\u200d\u2696\ufe0f", "1f9d1-200d-2696-fe0f.png", ":judge:", null, "People & Body", "12.1");
        EmojiUtil.add(set, result, "\ud83e\uddd1\u200d\u2708\ufe0f", "1f9d1-200d-2708-fe0f.png", ":pilot:", null, "People & Body", "12.1");
        EmojiUtil.add(set, result, "\ud83e\uddd1", "1f9d1.png", ":adult:", ":person:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd2\ud83c\udffb", "1f9d2-1f3fb.png", ":child_tone1:", ":child_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd2\ud83c\udffc", "1f9d2-1f3fc.png", ":child_tone2:", ":child_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd2\ud83c\udffd", "1f9d2-1f3fd.png", ":child_tone3:", ":child_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd2\ud83c\udffe", "1f9d2-1f3fe.png", ":child_tone4:", ":child_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd2\ud83c\udfff", "1f9d2-1f3ff.png", ":child_tone5:", ":child_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd2", "1f9d2.png", ":child:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd3\ud83c\udffb", "1f9d3-1f3fb.png", ":older_adult_tone1:", ":older_person_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd3\ud83c\udffc", "1f9d3-1f3fc.png", ":older_adult_tone2:", ":older_person_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd3\ud83c\udffd", "1f9d3-1f3fd.png", ":older_adult_tone3:", ":older_person_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd3\ud83c\udffe", "1f9d3-1f3fe.png", ":older_adult_tone4:", ":older_person_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd3\ud83c\udfff", "1f9d3-1f3ff.png", ":older_adult_tone5:", ":older_person_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd3", "1f9d3.png", ":older_adult:", ":older_person:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd4\ud83c\udffb\u200d\u2640\ufe0f", "1f9d4-1f3fb-200d-2640-fe0f.png", ":woman_bearded_person_tone1:", ":woman_light_skin_tone_beard:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd4\ud83c\udffb\u200d\u2642\ufe0f", "1f9d4-1f3fb-200d-2642-fe0f.png", ":man_bearded_person_tone1:", ":man_light_skin_tone_beard:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd4\ud83c\udffb", "1f9d4-1f3fb.png", ":bearded_person_tone1:", ":person_light_skin_tone_beard:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd4\ud83c\udffc\u200d\u2640\ufe0f", "1f9d4-1f3fc-200d-2640-fe0f.png", ":woman_bearded_person_tone2:", ":woman_medium_light_skin_tone_beard:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd4\ud83c\udffc\u200d\u2642\ufe0f", "1f9d4-1f3fc-200d-2642-fe0f.png", ":man_bearded_person_tone2:", ":man_medium_light_skin_tone_beard:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd4\ud83c\udffc", "1f9d4-1f3fc.png", ":bearded_person_tone2:", ":person_medium_light_skin_tone_beard:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd4\ud83c\udffd\u200d\u2640\ufe0f", "1f9d4-1f3fd-200d-2640-fe0f.png", ":woman_bearded_person_tone3:", ":woman_medium_skin_tone_beard:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd4\ud83c\udffd\u200d\u2642\ufe0f", "1f9d4-1f3fd-200d-2642-fe0f.png", ":man_bearded_person_tone3:", ":man_medium_skin_tone_beard:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd4\ud83c\udffd", "1f9d4-1f3fd.png", ":bearded_person_tone3:", ":person_medium_skin_tone_beard:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd4\ud83c\udffe\u200d\u2640\ufe0f", "1f9d4-1f3fe-200d-2640-fe0f.png", ":woman_bearded_person_tone4:", ":woman_medium_dark_skin_tone_beard:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd4\ud83c\udffe\u200d\u2642\ufe0f", "1f9d4-1f3fe-200d-2642-fe0f.png", ":man_bearded_person_tone4:", ":man_medium_dark_skin_tone_beard:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd4\ud83c\udffe", "1f9d4-1f3fe.png", ":bearded_person_tone4:", ":person_medium_dark_skin_tone_beard:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd4\ud83c\udfff\u200d\u2640\ufe0f", "1f9d4-1f3ff-200d-2640-fe0f.png", ":woman_bearded_person_tone5:", ":woman_dark_skin_tone_beard:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd4\ud83c\udfff\u200d\u2642\ufe0f", "1f9d4-1f3ff-200d-2642-fe0f.png", ":man_bearded_person_tone5:", ":man_dark_skin_tone_beard:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd4\ud83c\udfff", "1f9d4-1f3ff.png", ":bearded_person_tone5:", ":person_dark_skin_tone_beard:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd4\u200d\u2640\ufe0f", "1f9d4-200d-2640-fe0f.png", ":woman_beard:", null, "People & Body", "13.1");
        EmojiUtil.add(set, result, "\ud83e\uddd4\u200d\u2642\ufe0f", "1f9d4-200d-2642-fe0f.png", ":man_beard:", null, "People & Body", "13.1");
        EmojiUtil.add(set, result, "\ud83e\uddd4", "1f9d4.png", ":bearded_person:", ":person_beard:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd5\ud83c\udffb", "1f9d5-1f3fb.png", ":woman_with_headscarf_tone1:", ":woman_with_headscarf_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd5\ud83c\udffc", "1f9d5-1f3fc.png", ":woman_with_headscarf_tone2:", ":woman_with_headscarf_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd5\ud83c\udffd", "1f9d5-1f3fd.png", ":woman_with_headscarf_tone3:", ":woman_with_headscarf_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd5\ud83c\udffe", "1f9d5-1f3fe.png", ":woman_with_headscarf_tone4:", ":woman_with_headscarf_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd5\ud83c\udfff", "1f9d5-1f3ff.png", ":woman_with_headscarf_tone5:", ":woman_with_headscarf_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd5", "1f9d5.png", ":woman_with_headscarf:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd6\ud83c\udffb\u200d\u2640\ufe0f", "1f9d6-1f3fb-200d-2640-fe0f.png", ":woman_sauna_person_tone1:", ":woman_in_steamy_room_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd6\ud83c\udffb\u200d\u2642\ufe0f", "1f9d6-1f3fb-200d-2642-fe0f.png", ":man_sauna_person_tone1:", ":man_in_steamy_room_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd6\ud83c\udffb", "1f9d6-1f3fb.png", ":sauna_person_tone1:", ":person_in_steamy_room_tone1:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd6\ud83c\udffc\u200d\u2640\ufe0f", "1f9d6-1f3fc-200d-2640-fe0f.png", ":woman_sauna_person_tone2:", ":woman_in_steamy_room_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd6\ud83c\udffc\u200d\u2642\ufe0f", "1f9d6-1f3fc-200d-2642-fe0f.png", ":man_sauna_person_tone2:", ":man_in_steamy_room_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd6\ud83c\udffc", "1f9d6-1f3fc.png", ":sauna_person_tone2:", ":person_in_steamy_room_tone2:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd6\ud83c\udffd\u200d\u2640\ufe0f", "1f9d6-1f3fd-200d-2640-fe0f.png", ":woman_sauna_person_tone3:", ":woman_in_steamy_room_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd6\ud83c\udffd\u200d\u2642\ufe0f", "1f9d6-1f3fd-200d-2642-fe0f.png", ":man_sauna_person_tone3:", ":man_in_steamy_room_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd6\ud83c\udffd", "1f9d6-1f3fd.png", ":sauna_person_tone3:", ":person_in_steamy_room_tone3:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd6\ud83c\udffe\u200d\u2640\ufe0f", "1f9d6-1f3fe-200d-2640-fe0f.png", ":woman_sauna_person_tone4:", ":woman_in_steamy_room_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd6\ud83c\udffe\u200d\u2642\ufe0f", "1f9d6-1f3fe-200d-2642-fe0f.png", ":man_sauna_person_tone4:", ":man_in_steamy_room_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd6\ud83c\udffe", "1f9d6-1f3fe.png", ":sauna_person_tone4:", ":person_in_steamy_room_tone4:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd6\ud83c\udfff\u200d\u2640\ufe0f", "1f9d6-1f3ff-200d-2640-fe0f.png", ":woman_sauna_person_tone5:", ":woman_in_steamy_room_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd6\ud83c\udfff\u200d\u2642\ufe0f", "1f9d6-1f3ff-200d-2642-fe0f.png", ":man_sauna_person_tone5:", ":man_in_steamy_room_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd6\ud83c\udfff", "1f9d6-1f3ff.png", ":sauna_person_tone5:", ":person_in_steamy_room_tone5:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd6\u200d\u2640\ufe0f", "1f9d6-200d-2640-fe0f.png", ":sauna_woman:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd6\u200d\u2642\ufe0f", "1f9d6-200d-2642-fe0f.png", ":sauna_man:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd6", "1f9d6.png", ":sauna_person:", ":person_in_steamy_room:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd7\ud83c\udffb\u200d\u2640\ufe0f", "1f9d7-1f3fb-200d-2640-fe0f.png", ":woman_climbing_tone1:", ":woman_climbing_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd7\ud83c\udffb\u200d\u2642\ufe0f", "1f9d7-1f3fb-200d-2642-fe0f.png", ":man_climbing_tone1:", ":man_climbing_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd7\ud83c\udffb", "1f9d7-1f3fb.png", ":climbing_tone1:", ":person_climbing_tone1:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd7\ud83c\udffc\u200d\u2640\ufe0f", "1f9d7-1f3fc-200d-2640-fe0f.png", ":woman_climbing_tone2:", ":woman_climbing_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd7\ud83c\udffc\u200d\u2642\ufe0f", "1f9d7-1f3fc-200d-2642-fe0f.png", ":man_climbing_tone2:", ":man_climbing_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd7\ud83c\udffc", "1f9d7-1f3fc.png", ":climbing_tone2:", ":person_climbing_tone2:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd7\ud83c\udffd\u200d\u2640\ufe0f", "1f9d7-1f3fd-200d-2640-fe0f.png", ":woman_climbing_tone3:", ":woman_climbing_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd7\ud83c\udffd\u200d\u2642\ufe0f", "1f9d7-1f3fd-200d-2642-fe0f.png", ":man_climbing_tone3:", ":man_climbing_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd7\ud83c\udffd", "1f9d7-1f3fd.png", ":climbing_tone3:", ":person_climbing_tone3:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd7\ud83c\udffe\u200d\u2640\ufe0f", "1f9d7-1f3fe-200d-2640-fe0f.png", ":woman_climbing_tone4:", ":woman_climbing_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd7\ud83c\udffe\u200d\u2642\ufe0f", "1f9d7-1f3fe-200d-2642-fe0f.png", ":man_climbing_tone4:", ":man_climbing_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd7\ud83c\udffe", "1f9d7-1f3fe.png", ":climbing_tone4:", ":person_climbing_tone4:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd7\ud83c\udfff\u200d\u2640\ufe0f", "1f9d7-1f3ff-200d-2640-fe0f.png", ":woman_climbing_tone5:", ":woman_climbing_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd7\ud83c\udfff\u200d\u2642\ufe0f", "1f9d7-1f3ff-200d-2642-fe0f.png", ":man_climbing_tone5:", ":man_climbing_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd7\ud83c\udfff", "1f9d7-1f3ff.png", ":climbing_tone5:", ":person_climbing_tone5:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd7\u200d\u2640\ufe0f", "1f9d7-200d-2640-fe0f.png", ":climbing_woman:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd7\u200d\u2642\ufe0f", "1f9d7-200d-2642-fe0f.png", ":climbing_man:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd7", "1f9d7.png", ":climbing:", ":person_climbing:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd8\ud83c\udffb\u200d\u2640\ufe0f", "1f9d8-1f3fb-200d-2640-fe0f.png", ":woman_lotus_position_tone1:", ":woman_in_lotus_position_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd8\ud83c\udffb\u200d\u2642\ufe0f", "1f9d8-1f3fb-200d-2642-fe0f.png", ":man_lotus_position_tone1:", ":man_in_lotus_position_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd8\ud83c\udffb", "1f9d8-1f3fb.png", ":lotus_position_tone1:", ":person_in_lotus_position_tone1:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd8\ud83c\udffc\u200d\u2640\ufe0f", "1f9d8-1f3fc-200d-2640-fe0f.png", ":woman_lotus_position_tone2:", ":woman_in_lotus_position_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd8\ud83c\udffc\u200d\u2642\ufe0f", "1f9d8-1f3fc-200d-2642-fe0f.png", ":man_lotus_position_tone2:", ":man_in_lotus_position_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd8\ud83c\udffc", "1f9d8-1f3fc.png", ":lotus_position_tone2:", ":person_in_lotus_position_tone2:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd8\ud83c\udffd\u200d\u2640\ufe0f", "1f9d8-1f3fd-200d-2640-fe0f.png", ":woman_lotus_position_tone3:", ":woman_in_lotus_position_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd8\ud83c\udffd\u200d\u2642\ufe0f", "1f9d8-1f3fd-200d-2642-fe0f.png", ":man_lotus_position_tone3:", ":man_in_lotus_position_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd8\ud83c\udffd", "1f9d8-1f3fd.png", ":lotus_position_tone3:", ":person_in_lotus_position_tone3:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd8\ud83c\udffe\u200d\u2640\ufe0f", "1f9d8-1f3fe-200d-2640-fe0f.png", ":woman_lotus_position_tone4:", ":woman_in_lotus_position_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd8\ud83c\udffe\u200d\u2642\ufe0f", "1f9d8-1f3fe-200d-2642-fe0f.png", ":man_lotus_position_tone4:", ":man_in_lotus_position_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd8\ud83c\udffe", "1f9d8-1f3fe.png", ":lotus_position_tone4:", ":person_in_lotus_position_tone4:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd8\ud83c\udfff\u200d\u2640\ufe0f", "1f9d8-1f3ff-200d-2640-fe0f.png", ":woman_lotus_position_tone5:", ":woman_in_lotus_position_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd8\ud83c\udfff\u200d\u2642\ufe0f", "1f9d8-1f3ff-200d-2642-fe0f.png", ":man_lotus_position_tone5:", ":man_in_lotus_position_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd8\ud83c\udfff", "1f9d8-1f3ff.png", ":lotus_position_tone5:", ":person_in_lotus_position_tone5:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd8\u200d\u2640\ufe0f", "1f9d8-200d-2640-fe0f.png", ":lotus_position_woman:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd8\u200d\u2642\ufe0f", "1f9d8-200d-2642-fe0f.png", ":lotus_position_man:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd8", "1f9d8.png", ":lotus_position:", ":person_in_lotus_position:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd9\ud83c\udffb\u200d\u2640\ufe0f", "1f9d9-1f3fb-200d-2640-fe0f.png", ":woman_mage_tone1:", ":woman_mage_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd9\ud83c\udffb\u200d\u2642\ufe0f", "1f9d9-1f3fb-200d-2642-fe0f.png", ":man_mage_tone1:", ":man_mage_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd9\ud83c\udffb", "1f9d9-1f3fb.png", ":mage_tone1:", ":mage_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd9\ud83c\udffc\u200d\u2640\ufe0f", "1f9d9-1f3fc-200d-2640-fe0f.png", ":woman_mage_tone2:", ":woman_mage_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd9\ud83c\udffc\u200d\u2642\ufe0f", "1f9d9-1f3fc-200d-2642-fe0f.png", ":man_mage_tone2:", ":man_mage_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd9\ud83c\udffc", "1f9d9-1f3fc.png", ":mage_tone2:", ":mage_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd9\ud83c\udffd\u200d\u2640\ufe0f", "1f9d9-1f3fd-200d-2640-fe0f.png", ":woman_mage_tone3:", ":woman_mage_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd9\ud83c\udffd\u200d\u2642\ufe0f", "1f9d9-1f3fd-200d-2642-fe0f.png", ":man_mage_tone3:", ":man_mage_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd9\ud83c\udffd", "1f9d9-1f3fd.png", ":mage_tone3:", ":mage_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd9\ud83c\udffe\u200d\u2640\ufe0f", "1f9d9-1f3fe-200d-2640-fe0f.png", ":woman_mage_tone4:", ":woman_mage_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd9\ud83c\udffe\u200d\u2642\ufe0f", "1f9d9-1f3fe-200d-2642-fe0f.png", ":man_mage_tone4:", ":man_mage_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd9\ud83c\udffe", "1f9d9-1f3fe.png", ":mage_tone4:", ":mage_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd9\ud83c\udfff\u200d\u2640\ufe0f", "1f9d9-1f3ff-200d-2640-fe0f.png", ":woman_mage_tone5:", ":woman_mage_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd9\ud83c\udfff\u200d\u2642\ufe0f", "1f9d9-1f3ff-200d-2642-fe0f.png", ":man_mage_tone5:", ":man_mage_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd9\ud83c\udfff", "1f9d9-1f3ff.png", ":mage_tone5:", ":mage_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd9\u200d\u2640\ufe0f", "1f9d9-200d-2640-fe0f.png", ":mage_woman:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd9\u200d\u2642\ufe0f", "1f9d9-200d-2642-fe0f.png", ":mage_man:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddd9", "1f9d9.png", ":mage:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddda\ud83c\udffb\u200d\u2640\ufe0f", "1f9da-1f3fb-200d-2640-fe0f.png", ":woman_fairy_tone1:", ":woman_fairy_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddda\ud83c\udffb\u200d\u2642\ufe0f", "1f9da-1f3fb-200d-2642-fe0f.png", ":man_fairy_tone1:", ":man_fairy_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddda\ud83c\udffb", "1f9da-1f3fb.png", ":fairy_tone1:", ":fairy_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddda\ud83c\udffc\u200d\u2640\ufe0f", "1f9da-1f3fc-200d-2640-fe0f.png", ":woman_fairy_tone2:", ":woman_fairy_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddda\ud83c\udffc\u200d\u2642\ufe0f", "1f9da-1f3fc-200d-2642-fe0f.png", ":man_fairy_tone2:", ":man_fairy_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddda\ud83c\udffc", "1f9da-1f3fc.png", ":fairy_tone2:", ":fairy_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddda\ud83c\udffd\u200d\u2640\ufe0f", "1f9da-1f3fd-200d-2640-fe0f.png", ":woman_fairy_tone3:", ":woman_fairy_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddda\ud83c\udffd\u200d\u2642\ufe0f", "1f9da-1f3fd-200d-2642-fe0f.png", ":man_fairy_tone3:", ":man_fairy_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddda\ud83c\udffd", "1f9da-1f3fd.png", ":fairy_tone3:", ":fairy_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddda\ud83c\udffe\u200d\u2640\ufe0f", "1f9da-1f3fe-200d-2640-fe0f.png", ":woman_fairy_tone4:", ":woman_fairy_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddda\ud83c\udffe\u200d\u2642\ufe0f", "1f9da-1f3fe-200d-2642-fe0f.png", ":man_fairy_tone4:", ":man_fairy_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddda\ud83c\udffe", "1f9da-1f3fe.png", ":fairy_tone4:", ":fairy_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddda\ud83c\udfff\u200d\u2640\ufe0f", "1f9da-1f3ff-200d-2640-fe0f.png", ":woman_fairy_tone5:", ":woman_fairy_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddda\ud83c\udfff\u200d\u2642\ufe0f", "1f9da-1f3ff-200d-2642-fe0f.png", ":man_fairy_tone5:", ":man_fairy_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddda\ud83c\udfff", "1f9da-1f3ff.png", ":fairy_tone5:", ":fairy_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddda\u200d\u2640\ufe0f", "1f9da-200d-2640-fe0f.png", ":fairy_woman:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddda\u200d\u2642\ufe0f", "1f9da-200d-2642-fe0f.png", ":fairy_man:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddda", "1f9da.png", ":fairy:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddb\ud83c\udffb\u200d\u2640\ufe0f", "1f9db-1f3fb-200d-2640-fe0f.png", ":woman_vampire_tone1:", ":woman_vampire_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddb\ud83c\udffb\u200d\u2642\ufe0f", "1f9db-1f3fb-200d-2642-fe0f.png", ":man_vampire_tone1:", ":man_vampire_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddb\ud83c\udffb", "1f9db-1f3fb.png", ":vampire_tone1:", ":vampire_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddb\ud83c\udffc\u200d\u2640\ufe0f", "1f9db-1f3fc-200d-2640-fe0f.png", ":woman_vampire_tone2:", ":woman_vampire_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddb\ud83c\udffc\u200d\u2642\ufe0f", "1f9db-1f3fc-200d-2642-fe0f.png", ":man_vampire_tone2:", ":man_vampire_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddb\ud83c\udffc", "1f9db-1f3fc.png", ":vampire_tone2:", ":vampire_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddb\ud83c\udffd\u200d\u2640\ufe0f", "1f9db-1f3fd-200d-2640-fe0f.png", ":woman_vampire_tone3:", ":woman_vampire_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddb\ud83c\udffd\u200d\u2642\ufe0f", "1f9db-1f3fd-200d-2642-fe0f.png", ":man_vampire_tone3:", ":man_vampire_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddb\ud83c\udffd", "1f9db-1f3fd.png", ":vampire_tone3:", ":vampire_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddb\ud83c\udffe\u200d\u2640\ufe0f", "1f9db-1f3fe-200d-2640-fe0f.png", ":woman_vampire_tone4:", ":woman_vampire_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddb\ud83c\udffe\u200d\u2642\ufe0f", "1f9db-1f3fe-200d-2642-fe0f.png", ":man_vampire_tone4:", ":man_vampire_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddb\ud83c\udffe", "1f9db-1f3fe.png", ":vampire_tone4:", ":vampire_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddb\ud83c\udfff\u200d\u2640\ufe0f", "1f9db-1f3ff-200d-2640-fe0f.png", ":woman_vampire_tone5:", ":woman_vampire_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddb\ud83c\udfff\u200d\u2642\ufe0f", "1f9db-1f3ff-200d-2642-fe0f.png", ":man_vampire_tone5:", ":man_vampire_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddb\ud83c\udfff", "1f9db-1f3ff.png", ":vampire_tone5:", ":vampire_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddb\u200d\u2640\ufe0f", "1f9db-200d-2640-fe0f.png", ":vampire_woman:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddb\u200d\u2642\ufe0f", "1f9db-200d-2642-fe0f.png", ":vampire_man:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddb", "1f9db.png", ":vampire:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddc\ud83c\udffb\u200d\u2640\ufe0f", "1f9dc-1f3fb-200d-2640-fe0f.png", ":woman_merperson_tone1:", ":mermaid_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddc\ud83c\udffb\u200d\u2642\ufe0f", "1f9dc-1f3fb-200d-2642-fe0f.png", ":man_merperson_tone1:", ":merman_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddc\ud83c\udffb", "1f9dc-1f3fb.png", ":merperson_tone1:", ":merperson_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddc\ud83c\udffc\u200d\u2640\ufe0f", "1f9dc-1f3fc-200d-2640-fe0f.png", ":woman_merperson_tone2:", ":mermaid_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddc\ud83c\udffc\u200d\u2642\ufe0f", "1f9dc-1f3fc-200d-2642-fe0f.png", ":man_merperson_tone2:", ":merman_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddc\ud83c\udffc", "1f9dc-1f3fc.png", ":merperson_tone2:", ":merperson_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddc\ud83c\udffd\u200d\u2640\ufe0f", "1f9dc-1f3fd-200d-2640-fe0f.png", ":woman_merperson_tone3:", ":mermaid_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddc\ud83c\udffd\u200d\u2642\ufe0f", "1f9dc-1f3fd-200d-2642-fe0f.png", ":man_merperson_tone3:", ":merman_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddc\ud83c\udffd", "1f9dc-1f3fd.png", ":merperson_tone3:", ":merperson_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddc\ud83c\udffe\u200d\u2640\ufe0f", "1f9dc-1f3fe-200d-2640-fe0f.png", ":woman_merperson_tone4:", ":mermaid_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddc\ud83c\udffe\u200d\u2642\ufe0f", "1f9dc-1f3fe-200d-2642-fe0f.png", ":man_merperson_tone4:", ":merman_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddc\ud83c\udffe", "1f9dc-1f3fe.png", ":merperson_tone4:", ":merperson_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddc\ud83c\udfff\u200d\u2640\ufe0f", "1f9dc-1f3ff-200d-2640-fe0f.png", ":woman_merperson_tone5:", ":mermaid_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddc\ud83c\udfff\u200d\u2642\ufe0f", "1f9dc-1f3ff-200d-2642-fe0f.png", ":man_merperson_tone5:", ":merman_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddc\ud83c\udfff", "1f9dc-1f3ff.png", ":merperson_tone5:", ":merperson_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddc\u200d\u2640\ufe0f", "1f9dc-200d-2640-fe0f.png", ":mermaid:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddc\u200d\u2642\ufe0f", "1f9dc-200d-2642-fe0f.png", ":merman:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddc", "1f9dc.png", ":merperson:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddd\ud83c\udffb\u200d\u2640\ufe0f", "1f9dd-1f3fb-200d-2640-fe0f.png", ":woman_elf_tone1:", ":woman_elf_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddd\ud83c\udffb\u200d\u2642\ufe0f", "1f9dd-1f3fb-200d-2642-fe0f.png", ":man_elf_tone1:", ":man_elf_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddd\ud83c\udffb", "1f9dd-1f3fb.png", ":elf_tone1:", ":elf_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddd\ud83c\udffc\u200d\u2640\ufe0f", "1f9dd-1f3fc-200d-2640-fe0f.png", ":woman_elf_tone2:", ":woman_elf_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddd\ud83c\udffc\u200d\u2642\ufe0f", "1f9dd-1f3fc-200d-2642-fe0f.png", ":man_elf_tone2:", ":man_elf_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddd\ud83c\udffc", "1f9dd-1f3fc.png", ":elf_tone2:", ":elf_medium_light_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddd\ud83c\udffd\u200d\u2640\ufe0f", "1f9dd-1f3fd-200d-2640-fe0f.png", ":woman_elf_tone3:", ":woman_elf_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddd\ud83c\udffd\u200d\u2642\ufe0f", "1f9dd-1f3fd-200d-2642-fe0f.png", ":man_elf_tone3:", ":man_elf_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddd\ud83c\udffd", "1f9dd-1f3fd.png", ":elf_tone3:", ":elf_medium_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddd\ud83c\udffe\u200d\u2640\ufe0f", "1f9dd-1f3fe-200d-2640-fe0f.png", ":woman_elf_tone4:", ":woman_elf_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddd\ud83c\udffe\u200d\u2642\ufe0f", "1f9dd-1f3fe-200d-2642-fe0f.png", ":man_elf_tone4:", ":man_elf_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddd\ud83c\udffe", "1f9dd-1f3fe.png", ":elf_tone4:", ":elf_medium_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddd\ud83c\udfff\u200d\u2640\ufe0f", "1f9dd-1f3ff-200d-2640-fe0f.png", ":woman_elf_tone5:", ":woman_elf_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddd\ud83c\udfff\u200d\u2642\ufe0f", "1f9dd-1f3ff-200d-2642-fe0f.png", ":man_elf_tone5:", ":man_elf_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddd\ud83c\udfff", "1f9dd-1f3ff.png", ":elf_tone5:", ":elf_dark_skin_tone:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddd\u200d\u2640\ufe0f", "1f9dd-200d-2640-fe0f.png", ":elf_woman:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddd\u200d\u2642\ufe0f", "1f9dd-200d-2642-fe0f.png", ":elf_man:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddd", "1f9dd.png", ":elf:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddde\u200d\u2640\ufe0f", "1f9de-200d-2640-fe0f.png", ":genie_woman:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddde\u200d\u2642\ufe0f", "1f9de-200d-2642-fe0f.png", ":genie_man:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddde", "1f9de.png", ":genie:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddf\u200d\u2640\ufe0f", "1f9df-200d-2640-fe0f.png", ":zombie_woman:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddf\u200d\u2642\ufe0f", "1f9df-200d-2642-fe0f.png", ":zombie_man:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udddf", "1f9df.png", ":zombie:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udde0", "1f9e0.png", ":brain:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udde1", "1f9e1.png", ":orange_heart:", null, "Smileys & Emotion", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udde2", "1f9e2.png", ":billed_cap:", null, "Objects", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udde3", "1f9e3.png", ":scarf:", null, "Objects", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udde4", "1f9e4.png", ":gloves:", null, "Objects", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udde5", "1f9e5.png", ":coat:", null, "Objects", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udde6", "1f9e6.png", ":socks:", null, "Objects", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udde7", "1f9e7.png", ":red_envelope:", null, "Activities", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udde8", "1f9e8.png", ":firecracker:", null, "Activities", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udde9", "1f9e9.png", ":jigsaw:", ":puzzle_piece:", "Activities", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddea", "1f9ea.png", ":test_tube:", null, "Objects", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddeb", "1f9eb.png", ":petri_dish:", null, "Objects", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddec", "1f9ec.png", ":dna:", null, "Objects", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udded", "1f9ed.png", ":compass:", null, "Travel & Places", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddee", "1f9ee.png", ":abacus:", null, "Objects", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddef", "1f9ef.png", ":fire_extinguisher:", null, "Objects", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddf0", "1f9f0.png", ":toolbox:", null, "Objects", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddf1", "1f9f1.png", ":bricks:", ":brick:", "Travel & Places", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddf2", "1f9f2.png", ":magnet:", null, "Objects", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddf3", "1f9f3.png", ":luggage:", null, "Travel & Places", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddf4", "1f9f4.png", ":lotion_bottle:", ":squeeze_bottle:", "Objects", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddf5", "1f9f5.png", ":thread:", null, "Activities", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddf6", "1f9f6.png", ":yarn:", null, "Activities", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddf7", "1f9f7.png", ":safety_pin:", null, "Objects", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddf8", "1f9f8.png", ":teddy_bear:", null, "Activities", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddf9", "1f9f9.png", ":broom:", null, "Objects", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddfa", "1f9fa.png", ":basket:", null, "Objects", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddfb", "1f9fb.png", ":roll_of_paper:", null, "Objects", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddfc", "1f9fc.png", ":soap:", null, "Objects", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddfd", "1f9fd.png", ":sponge:", null, "Objects", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddfe", "1f9fe.png", ":receipt:", null, "Objects", "11.0");
        EmojiUtil.add(set, result, "\ud83e\uddff", "1f9ff.png", ":nazar_amulet:", null, "Activities", "11.0");
        EmojiUtil.add(set, result, "\ud83e\ude70", "1fa70.png", ":ballet_shoes:", null, "Objects", "12.0");
        EmojiUtil.add(set, result, "\ud83e\ude71", "1fa71.png", ":one_piece_swimsuit:", null, "Objects", "12.0");
        EmojiUtil.add(set, result, "\ud83e\ude72", "1fa72.png", ":swim_brief:", ":briefs:", "Objects", "12.0");
        EmojiUtil.add(set, result, "\ud83e\ude73", "1fa73.png", ":shorts:", null, "Objects", "12.0");
        EmojiUtil.add(set, result, "\ud83e\ude74", "1fa74.png", ":thong_sandal:", null, "Objects", "13.0");
        EmojiUtil.add(set, result, "\ud83e\ude78", "1fa78.png", ":drop_of_blood:", null, "Objects", "12.0");
        EmojiUtil.add(set, result, "\ud83e\ude79", "1fa79.png", ":adhesive_bandage:", null, "Objects", "12.0");
        EmojiUtil.add(set, result, "\ud83e\ude7a", "1fa7a.png", ":stethoscope:", null, "Objects", "12.0");
        EmojiUtil.add(set, result, "\ud83e\ude7b", "1fa7b.png", ":x_ray:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\ude7c", "1fa7c.png", ":crutch:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\ude80", "1fa80.png", ":yo_yo:", null, "Activities", "12.0");
        EmojiUtil.add(set, result, "\ud83e\ude81", "1fa81.png", ":kite:", null, "Activities", "12.0");
        EmojiUtil.add(set, result, "\ud83e\ude82", "1fa82.png", ":parachute:", null, "Travel & Places", "12.0");
        EmojiUtil.add(set, result, "\ud83e\ude83", "1fa83.png", ":boomerang:", null, "Objects", "13.0");
        EmojiUtil.add(set, result, "\ud83e\ude84", "1fa84.png", ":magic_wand:", null, "Activities", "13.0");
        EmojiUtil.add(set, result, "\ud83e\ude85", "1fa85.png", ":pinata:", ":pi_ata:", "Activities", "13.0");
        EmojiUtil.add(set, result, "\ud83e\ude86", "1fa86.png", ":nesting_dolls:", null, "Activities", "13.0");
        EmojiUtil.add(set, result, "\ud83e\ude90", "1fa90.png", ":ringed_planet:", null, "Travel & Places", "12.0");
        EmojiUtil.add(set, result, "\ud83e\ude91", "1fa91.png", ":chair:", null, "Objects", "12.0");
        EmojiUtil.add(set, result, "\ud83e\ude92", "1fa92.png", ":razor:", null, "Objects", "12.0");
        EmojiUtil.add(set, result, "\ud83e\ude93", "1fa93.png", ":axe:", null, "Objects", "12.0");
        EmojiUtil.add(set, result, "\ud83e\ude94", "1fa94.png", ":diya_lamp:", null, "Objects", "12.0");
        EmojiUtil.add(set, result, "\ud83e\ude95", "1fa95.png", ":banjo:", null, "Objects", "12.0");
        EmojiUtil.add(set, result, "\ud83e\ude96", "1fa96.png", ":military_helmet:", null, "Objects", "13.0");
        EmojiUtil.add(set, result, "\ud83e\ude97", "1fa97.png", ":accordion:", null, "Objects", "13.0");
        EmojiUtil.add(set, result, "\ud83e\ude98", "1fa98.png", ":long_drum:", null, "Objects", "13.0");
        EmojiUtil.add(set, result, "\ud83e\ude99", "1fa99.png", ":coin:", null, "Objects", "13.0");
        EmojiUtil.add(set, result, "\ud83e\ude9a", "1fa9a.png", ":carpentry_saw:", null, "Objects", "13.0");
        EmojiUtil.add(set, result, "\ud83e\ude9b", "1fa9b.png", ":screwdriver:", null, "Objects", "13.0");
        EmojiUtil.add(set, result, "\ud83e\ude9c", "1fa9c.png", ":ladder:", null, "Objects", "13.0");
        EmojiUtil.add(set, result, "\ud83e\ude9d", "1fa9d.png", ":hook:", null, "Objects", "13.0");
        EmojiUtil.add(set, result, "\ud83e\ude9e", "1fa9e.png", ":mirror:", null, "Objects", "13.0");
        EmojiUtil.add(set, result, "\ud83e\ude9f", "1fa9f.png", ":window:", null, "Objects", "13.0");
        EmojiUtil.add(set, result, "\ud83e\udea0", "1faa0.png", ":plunger:", null, "Objects", "13.0");
        EmojiUtil.add(set, result, "\ud83e\udea1", "1faa1.png", ":sewing_needle:", null, "Activities", "13.0");
        EmojiUtil.add(set, result, "\ud83e\udea2", "1faa2.png", ":knot:", null, "Activities", "13.0");
        EmojiUtil.add(set, result, "\ud83e\udea3", "1faa3.png", ":bucket:", null, "Objects", "13.0");
        EmojiUtil.add(set, result, "\ud83e\udea4", "1faa4.png", ":mouse_trap:", null, "Objects", "13.0");
        EmojiUtil.add(set, result, "\ud83e\udea5", "1faa5.png", ":toothbrush:", null, "Objects", "13.0");
        EmojiUtil.add(set, result, "\ud83e\udea6", "1faa6.png", ":headstone:", null, "Objects", "13.0");
        EmojiUtil.add(set, result, "\ud83e\udea7", "1faa7.png", ":placard:", null, "Objects", "13.0");
        EmojiUtil.add(set, result, "\ud83e\udea8", "1faa8.png", ":rock:", null, "Travel & Places", "13.0");
        EmojiUtil.add(set, result, "\ud83e\udea9", "1faa9.png", ":mirror_ball:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udeaa", "1faaa.png", ":identification_card:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udeab", "1faab.png", ":low_battery:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udeac", "1faac.png", ":hamsa:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udeb0", "1fab0.png", ":fly:", null, "Animals & Nature", "13.0");
        EmojiUtil.add(set, result, "\ud83e\udeb1", "1fab1.png", ":worm:", null, "Animals & Nature", "13.0");
        EmojiUtil.add(set, result, "\ud83e\udeb2", "1fab2.png", ":beetle:", null, "Animals & Nature", "13.0");
        EmojiUtil.add(set, result, "\ud83e\udeb3", "1fab3.png", ":cockroach:", null, "Animals & Nature", "13.0");
        EmojiUtil.add(set, result, "\ud83e\udeb4", "1fab4.png", ":potted_plant:", null, "Animals & Nature", "13.0");
        EmojiUtil.add(set, result, "\ud83e\udeb5", "1fab5.png", ":wood:", null, "Travel & Places", "13.0");
        EmojiUtil.add(set, result, "\ud83e\udeb6", "1fab6.png", ":feather:", null, "Animals & Nature", "13.0");
        EmojiUtil.add(set, result, "\ud83e\udeb7", "1fab7.png", ":lotus:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udeb8", "1fab8.png", ":coral:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udeb9", "1fab9.png", ":empty_nest:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udeba", "1faba.png", ":nest_with_eggs:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udec0", "1fac0.png", ":anatomical_heart:", null, "People & Body", "13.0");
        EmojiUtil.add(set, result, "\ud83e\udec1", "1fac1.png", ":lungs:", null, "People & Body", "13.0");
        EmojiUtil.add(set, result, "\ud83e\udec2", "1fac2.png", ":people_hugging:", null, "People & Body", "13.0");
        EmojiUtil.add(set, result, "\ud83e\udec3\ud83c\udffb", "1fac3-1f3fb.png", ":pregnant_man_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udec3\ud83c\udffc", "1fac3-1f3fc.png", ":pregnant_man_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udec3\ud83c\udffd", "1fac3-1f3fd.png", ":pregnant_man_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udec3\ud83c\udffe", "1fac3-1f3fe.png", ":pregnant_man_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udec3\ud83c\udfff", "1fac3-1f3ff.png", ":pregnant_man_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udec3", "1fac3.png", ":pregnant_man:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udec4\ud83c\udffb", "1fac4-1f3fb.png", ":pregnant_person_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udec4\ud83c\udffc", "1fac4-1f3fc.png", ":pregnant_person_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udec4\ud83c\udffd", "1fac4-1f3fd.png", ":pregnant_person_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udec4\ud83c\udffe", "1fac4-1f3fe.png", ":pregnant_person_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udec4\ud83c\udfff", "1fac4-1f3ff.png", ":pregnant_person_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udec4", "1fac4.png", ":pregnant_person:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udec5\ud83c\udffb", "1fac5-1f3fb.png", ":person_with_crown_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udec5\ud83c\udffc", "1fac5-1f3fc.png", ":person_with_crown_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udec5\ud83c\udffd", "1fac5-1f3fd.png", ":person_with_crown_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udec5\ud83c\udffe", "1fac5-1f3fe.png", ":person_with_crown_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udec5\ud83c\udfff", "1fac5-1f3ff.png", ":person_with_crown_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udec5", "1fac5.png", ":person_with_crown:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uded0", "1fad0.png", ":blueberries:", null, "Food & Drink", "13.0");
        EmojiUtil.add(set, result, "\ud83e\uded1", "1fad1.png", ":bell_pepper:", null, "Food & Drink", "13.0");
        EmojiUtil.add(set, result, "\ud83e\uded2", "1fad2.png", ":olive:", null, "Food & Drink", "13.0");
        EmojiUtil.add(set, result, "\ud83e\uded3", "1fad3.png", ":flatbread:", null, "Food & Drink", "13.0");
        EmojiUtil.add(set, result, "\ud83e\uded4", "1fad4.png", ":tamale:", null, "Food & Drink", "13.0");
        EmojiUtil.add(set, result, "\ud83e\uded5", "1fad5.png", ":fondue:", null, "Food & Drink", "13.0");
        EmojiUtil.add(set, result, "\ud83e\uded6", "1fad6.png", ":teapot:", null, "Food & Drink", "13.0");
        EmojiUtil.add(set, result, "\ud83e\uded7", "1fad7.png", ":pouring_liquid:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uded8", "1fad8.png", ":beans:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\uded9", "1fad9.png", ":jar:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udee0", "1fae0.png", ":melting_face:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udee1", "1fae1.png", ":saluting_face:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udee2", "1fae2.png", ":face_with_open_eyes_and_hand_over_mouth:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udee3", "1fae3.png", ":face_with_peeking_eye:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udee4", "1fae4.png", ":face_with_diagonal_mouth:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udee5", "1fae5.png", ":dotted_line_face:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udee6", "1fae6.png", ":biting_lip:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udee7", "1fae7.png", ":bubbles:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef0\ud83c\udffb", "1faf0-1f3fb.png", ":hand_with_index_finger_and_thumb_crossed_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef0\ud83c\udffc", "1faf0-1f3fc.png", ":hand_with_index_finger_and_thumb_crossed_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef0\ud83c\udffd", "1faf0-1f3fd.png", ":hand_with_index_finger_and_thumb_crossed_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef0\ud83c\udffe", "1faf0-1f3fe.png", ":hand_with_index_finger_and_thumb_crossed_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef0\ud83c\udfff", "1faf0-1f3ff.png", ":hand_with_index_finger_and_thumb_crossed_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef0", "1faf0.png", ":hand_with_index_finger_and_thumb_crossed:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef1\ud83c\udffb\u200d\ud83e\udef2\ud83c\udffc", "1faf1-1f3fb-200d-1faf2-1f3fc.png", ":handshake_light_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef1\ud83c\udffb\u200d\ud83e\udef2\ud83c\udffd", "1faf1-1f3fb-200d-1faf2-1f3fd.png", ":handshake_light_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef1\ud83c\udffb\u200d\ud83e\udef2\ud83c\udffe", "1faf1-1f3fb-200d-1faf2-1f3fe.png", ":handshake_light_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef1\ud83c\udffb\u200d\ud83e\udef2\ud83c\udfff", "1faf1-1f3fb-200d-1faf2-1f3ff.png", ":handshake_light_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef1\ud83c\udffb", "1faf1-1f3fb.png", ":rightwards_hand_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef1\ud83c\udffc\u200d\ud83e\udef2\ud83c\udffb", "1faf1-1f3fc-200d-1faf2-1f3fb.png", ":handshake_medium_light_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef1\ud83c\udffc\u200d\ud83e\udef2\ud83c\udffd", "1faf1-1f3fc-200d-1faf2-1f3fd.png", ":handshake_medium_light_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef1\ud83c\udffc\u200d\ud83e\udef2\ud83c\udffe", "1faf1-1f3fc-200d-1faf2-1f3fe.png", ":handshake_medium_light_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef1\ud83c\udffc\u200d\ud83e\udef2\ud83c\udfff", "1faf1-1f3fc-200d-1faf2-1f3ff.png", ":handshake_medium_light_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef1\ud83c\udffc", "1faf1-1f3fc.png", ":rightwards_hand_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef1\ud83c\udffd\u200d\ud83e\udef2\ud83c\udffb", "1faf1-1f3fd-200d-1faf2-1f3fb.png", ":handshake_medium_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef1\ud83c\udffd\u200d\ud83e\udef2\ud83c\udffc", "1faf1-1f3fd-200d-1faf2-1f3fc.png", ":handshake_medium_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef1\ud83c\udffd\u200d\ud83e\udef2\ud83c\udffe", "1faf1-1f3fd-200d-1faf2-1f3fe.png", ":handshake_medium_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef1\ud83c\udffd\u200d\ud83e\udef2\ud83c\udfff", "1faf1-1f3fd-200d-1faf2-1f3ff.png", ":handshake_medium_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef1\ud83c\udffd", "1faf1-1f3fd.png", ":rightwards_hand_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef1\ud83c\udffe\u200d\ud83e\udef2\ud83c\udffb", "1faf1-1f3fe-200d-1faf2-1f3fb.png", ":handshake_medium_dark_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef1\ud83c\udffe\u200d\ud83e\udef2\ud83c\udffc", "1faf1-1f3fe-200d-1faf2-1f3fc.png", ":handshake_medium_dark_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef1\ud83c\udffe\u200d\ud83e\udef2\ud83c\udffd", "1faf1-1f3fe-200d-1faf2-1f3fd.png", ":handshake_medium_dark_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef1\ud83c\udffe\u200d\ud83e\udef2\ud83c\udfff", "1faf1-1f3fe-200d-1faf2-1f3ff.png", ":handshake_medium_dark_skin_tone_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef1\ud83c\udffe", "1faf1-1f3fe.png", ":rightwards_hand_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef1\ud83c\udfff\u200d\ud83e\udef2\ud83c\udffb", "1faf1-1f3ff-200d-1faf2-1f3fb.png", ":handshake_dark_skin_tone_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef1\ud83c\udfff\u200d\ud83e\udef2\ud83c\udffc", "1faf1-1f3ff-200d-1faf2-1f3fc.png", ":handshake_dark_skin_tone_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef1\ud83c\udfff\u200d\ud83e\udef2\ud83c\udffd", "1faf1-1f3ff-200d-1faf2-1f3fd.png", ":handshake_dark_skin_tone_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef1\ud83c\udfff\u200d\ud83e\udef2\ud83c\udffe", "1faf1-1f3ff-200d-1faf2-1f3fe.png", ":handshake_dark_skin_tone_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef1\ud83c\udfff", "1faf1-1f3ff.png", ":rightwards_hand_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef1", "1faf1.png", ":rightwards_hand:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef2\ud83c\udffb", "1faf2-1f3fb.png", ":leftwards_hand_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef2\ud83c\udffc", "1faf2-1f3fc.png", ":leftwards_hand_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef2\ud83c\udffd", "1faf2-1f3fd.png", ":leftwards_hand_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef2\ud83c\udffe", "1faf2-1f3fe.png", ":leftwards_hand_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef2\ud83c\udfff", "1faf2-1f3ff.png", ":leftwards_hand_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef2", "1faf2.png", ":leftwards_hand:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef3\ud83c\udffb", "1faf3-1f3fb.png", ":palm_down_hand_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef3\ud83c\udffc", "1faf3-1f3fc.png", ":palm_down_hand_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef3\ud83c\udffd", "1faf3-1f3fd.png", ":palm_down_hand_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef3\ud83c\udffe", "1faf3-1f3fe.png", ":palm_down_hand_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef3\ud83c\udfff", "1faf3-1f3ff.png", ":palm_down_hand_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef3", "1faf3.png", ":palm_down_hand:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef4\ud83c\udffb", "1faf4-1f3fb.png", ":palm_up_hand_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef4\ud83c\udffc", "1faf4-1f3fc.png", ":palm_up_hand_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef4\ud83c\udffd", "1faf4-1f3fd.png", ":palm_up_hand_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef4\ud83c\udffe", "1faf4-1f3fe.png", ":palm_up_hand_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef4\ud83c\udfff", "1faf4-1f3ff.png", ":palm_up_hand_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef4", "1faf4.png", ":palm_up_hand:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef5\ud83c\udffb", "1faf5-1f3fb.png", ":index_pointing_at_the_viewer_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef5\ud83c\udffc", "1faf5-1f3fc.png", ":index_pointing_at_the_viewer_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef5\ud83c\udffd", "1faf5-1f3fd.png", ":index_pointing_at_the_viewer_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef5\ud83c\udffe", "1faf5-1f3fe.png", ":index_pointing_at_the_viewer_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef5\ud83c\udfff", "1faf5-1f3ff.png", ":index_pointing_at_the_viewer_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef5", "1faf5.png", ":index_pointing_at_the_viewer:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef6\ud83c\udffb", "1faf6-1f3fb.png", ":heart_hands_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef6\ud83c\udffc", "1faf6-1f3fc.png", ":heart_hands_medium_light_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef6\ud83c\udffd", "1faf6-1f3fd.png", ":heart_hands_medium_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef6\ud83c\udffe", "1faf6-1f3fe.png", ":heart_hands_medium_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef6\ud83c\udfff", "1faf6-1f3ff.png", ":heart_hands_dark_skin_tone:", null, null, null);
        EmojiUtil.add(set, result, "\ud83e\udef6", "1faf6.png", ":heart_hands:", null, null, null);
        EmojiUtil.add(set, result, "\u203c", "203c.png", ":bangbang:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2049", "2049.png", ":interrobang:", null, "Symbols", "3.0");
        EmojiUtil.add(set, result, "\u2139", "2139.png", ":information_source:", null, "Symbols", "3.0");
        EmojiUtil.add(set, result, "\u2194", "2194.png", ":left_right_arrow:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2195", "2195.png", ":arrow_up_down:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2196", "2196.png", ":arrow_upper_left:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2197", "2197.png", ":arrow_upper_right:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2198", "2198.png", ":arrow_lower_right:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2199", "2199.png", ":arrow_lower_left:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u21a9", "21a9.png", ":leftwards_arrow_with_hook:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u21aa", "21aa.png", ":arrow_right_hook:", null, "Symbols", "");
        EmojiUtil.add(set, result, "#\u20e3", "23-20e3.png", ":hash:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u231a", "231a.png", ":watch:", null, "Travel & Places", "");
        EmojiUtil.add(set, result, "\u231b", "231b.png", ":hourglass:", ":hourglass_done:", "Travel & Places", "");
        EmojiUtil.add(set, result, "\u2328", "2328.png", ":keyboard:", null, "Objects", "");
        EmojiUtil.add(set, result, "\u23cf", "23cf.png", ":eject_button:", ":eject:", "Symbols", "11.0");
        EmojiUtil.add(set, result, "\u23e9", "23e9.png", ":fast_forward:", ":fast_forward_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\u23ea", "23ea.png", ":rewind:", ":fast_reverse_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\u23eb", "23eb.png", ":arrow_double_up:", ":fast_up_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\u23ec", "23ec.png", ":arrow_double_down:", ":fast_down_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\u23ed", "23ed.png", ":next_track_button:", ":track_next:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\u23ee", "23ee.png", ":previous_track_button:", ":track_previous:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\u23ef", "23ef.png", ":play_or_pause_button:", ":play_pause:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\u23f0", "23f0.png", ":alarm_clock:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\u23f1", "23f1.png", ":stopwatch:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\u23f2", "23f2.png", ":timer_clock:", ":timer:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\u23f3", "23f3.png", ":hourglass_flowing_sand:", ":hourglass_not_done:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\u23f8", "23f8.png", ":pause_button:", null, "Symbols", "7.0");
        EmojiUtil.add(set, result, "\u23f9", "23f9.png", ":stop_button:", null, "Symbols", "7.0");
        EmojiUtil.add(set, result, "\u23fa", "23fa.png", ":record_button:", null, "Symbols", "7.0");
        EmojiUtil.add(set, result, "\u24c2", "24c2.png", ":m:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u25aa", "25aa.png", ":black_small_square:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u25ab", "25ab.png", ":white_small_square:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u25b6", "25b6.png", ":arrow_forward:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u25c0", "25c0.png", ":arrow_backward:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u25fb", "25fb.png", ":white_medium_square:", null, "Symbols", "3.2");
        EmojiUtil.add(set, result, "\u25fc", "25fc.png", ":black_medium_square:", null, "Symbols", "3.2");
        EmojiUtil.add(set, result, "\u25fd", "25fd.png", ":white_medium_small_square:", null, "Symbols", "3.2");
        EmojiUtil.add(set, result, "\u25fe", "25fe.png", ":black_medium_small_square:", null, "Symbols", "3.2");
        EmojiUtil.add(set, result, "\u2600", "2600.png", ":sunny:", null, "Travel & Places", "");
        EmojiUtil.add(set, result, "\u2601", "2601.png", ":cloud:", null, "Travel & Places", "");
        EmojiUtil.add(set, result, "\u2602", "2602.png", ":open_umbrella:", ":umbrella2:", "Travel & Places", "");
        EmojiUtil.add(set, result, "\u2603", "2603.png", ":snowman_with_snow:", ":snowman2:", "Travel & Places", "");
        EmojiUtil.add(set, result, "\u2604", "2604.png", ":comet:", null, "Travel & Places", "");
        EmojiUtil.add(set, result, "\u260e", "260e.png", ":phone:", ":telephone:", "Objects", "");
        EmojiUtil.add(set, result, "\u2611", "2611.png", ":ballot_box_with_check:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2614", "2614.png", ":umbrella:", ":umbrella_with_rain_drops:", "Travel & Places", "4.0");
        EmojiUtil.add(set, result, "\u2615", "2615.png", ":coffee:", ":hot_beverage:", "Food & Drink", "4.0");
        EmojiUtil.add(set, result, "\u2618", "2618.png", ":shamrock:", null, "Animals & Nature", "4.1");
        EmojiUtil.add(set, result, "\u261d\ud83c\udffb", "261d-1f3fb.png", ":point_up_tone1:", ":index_pointing_up_light_skin_tone:", "People & Body", "");
        EmojiUtil.add(set, result, "\u261d\ud83c\udffc", "261d-1f3fc.png", ":point_up_tone2:", ":index_pointing_up_medium_light_skin_tone:", "People & Body", "");
        EmojiUtil.add(set, result, "\u261d\ud83c\udffd", "261d-1f3fd.png", ":point_up_tone3:", ":index_pointing_up_medium_skin_tone:", "People & Body", "");
        EmojiUtil.add(set, result, "\u261d\ud83c\udffe", "261d-1f3fe.png", ":point_up_tone4:", ":index_pointing_up_medium_dark_skin_tone:", "People & Body", "");
        EmojiUtil.add(set, result, "\u261d\ud83c\udfff", "261d-1f3ff.png", ":point_up_tone5:", ":index_pointing_up_dark_skin_tone:", "People & Body", "");
        EmojiUtil.add(set, result, "\u261d", "261d.png", ":point_up:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\u2620", "2620.png", ":skull_and_crossbones:", ":skull_crossbones:", "Smileys & Emotion", "");
        EmojiUtil.add(set, result, "\u2622", "2622.png", ":radioactive:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2623", "2623.png", ":biohazard:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2626", "2626.png", ":orthodox_cross:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u262a", "262a.png", ":star_and_crescent:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u262e", "262e.png", ":peace_symbol:", ":peace:", "Symbols", "");
        EmojiUtil.add(set, result, "\u262f", "262f.png", ":yin_yang:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2638", "2638.png", ":wheel_of_dharma:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2639", "2639.png", ":frowning_face:", ":frowning2:", "Smileys & Emotion", "");
        EmojiUtil.add(set, result, "\u263a", "263a.png", ":relaxed:", null, "Smileys & Emotion", "");
        EmojiUtil.add(set, result, "\u2640", "2640.png", ":female_sign:", null, "Symbols", "11.0");
        EmojiUtil.add(set, result, "\u2642", "2642.png", ":male_sign:", null, "Symbols", "11.0");
        EmojiUtil.add(set, result, "\u2648", "2648.png", ":aries:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2649", "2649.png", ":taurus:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u264a", "264a.png", ":gemini:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u264b", "264b.png", ":cancer:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u264c", "264c.png", ":leo:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u264d", "264d.png", ":virgo:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u264e", "264e.png", ":libra:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u264f", "264f.png", ":scorpius:", ":scorpio:", "Symbols", "");
        EmojiUtil.add(set, result, "\u2650", "2650.png", ":sagittarius:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2651", "2651.png", ":capricorn:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2652", "2652.png", ":aquarius:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2653", "2653.png", ":pisces:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u265f", "265f.png", ":chess_pawn:", null, "Activities", "11.0");
        EmojiUtil.add(set, result, "\u2660", "2660.png", ":spades:", null, "Activities", "");
        EmojiUtil.add(set, result, "\u2663", "2663.png", ":clubs:", null, "Activities", "");
        EmojiUtil.add(set, result, "\u2665", "2665.png", ":hearts:", null, "Activities", "");
        EmojiUtil.add(set, result, "\u2666", "2666.png", ":diamonds:", null, "Activities", "");
        EmojiUtil.add(set, result, "\u2668", "2668.png", ":hotsprings:", null, "Travel & Places", "");
        EmojiUtil.add(set, result, "\u267b", "267b.png", ":recycle:", null, "Symbols", "3.2");
        EmojiUtil.add(set, result, "\u267e", "267e.png", ":infinity:", null, "Symbols", "11.0");
        EmojiUtil.add(set, result, "\u267f", "267f.png", ":wheelchair:", ":wheelchair_symbol:", "Symbols", "4.1");
        EmojiUtil.add(set, result, "\u2692", "2692.png", ":hammer_and_pick:", ":hammer_pick:", "Objects", "4.1");
        EmojiUtil.add(set, result, "\u2693", "2693.png", ":anchor:", null, "Travel & Places", "4.1");
        EmojiUtil.add(set, result, "\u2694", "2694.png", ":crossed_swords:", null, "Objects", "4.1");
        EmojiUtil.add(set, result, "\u2695", "2695.png", ":medical_symbol:", null, "Symbols", "11.0");
        EmojiUtil.add(set, result, "\u2696", "2696.png", ":balance_scale:", ":scales:", "Objects", "4.1");
        EmojiUtil.add(set, result, "\u2697", "2697.png", ":alembic:", null, "Objects", "4.1");
        EmojiUtil.add(set, result, "\u2699", "2699.png", ":gear:", null, "Objects", "4.1");
        EmojiUtil.add(set, result, "\u269b", "269b.png", ":atom_symbol:", ":atom:", "Symbols", "4.1");
        EmojiUtil.add(set, result, "\u269c", "269c.png", ":fleur_de_lis:", ":fleur-de-lis:", "Symbols", "4.1");
        EmojiUtil.add(set, result, "\u26a0", "26a0.png", ":warning:", null, "Symbols", "4.0");
        EmojiUtil.add(set, result, "\u26a1", "26a1.png", ":zap:", ":high_voltage:", "Travel & Places", "4.0");
        EmojiUtil.add(set, result, "\u26a7", "26a7.png", ":transgender_symbol:", null, "Symbols", "13.0");
        EmojiUtil.add(set, result, "\u26aa", "26aa.png", ":white_circle:", null, "Symbols", "4.1");
        EmojiUtil.add(set, result, "\u26ab", "26ab.png", ":black_circle:", null, "Symbols", "4.1");
        EmojiUtil.add(set, result, "\u26b0", "26b0.png", ":coffin:", null, "Objects", "4.1");
        EmojiUtil.add(set, result, "\u26b1", "26b1.png", ":funeral_urn:", ":urn:", "Objects", "4.1");
        EmojiUtil.add(set, result, "\u26bd", "26bd.png", ":soccer:", ":soccer_ball:", "Activities", "5.2");
        EmojiUtil.add(set, result, "\u26be", "26be.png", ":baseball:", null, "Activities", "5.2");
        EmojiUtil.add(set, result, "\u26c4", "26c4.png", ":snowman:", ":snowman_without_snow:", "Travel & Places", "5.2");
        EmojiUtil.add(set, result, "\u26c5", "26c5.png", ":partly_sunny:", ":sun_behind_cloud:", "Travel & Places", "5.2");
        EmojiUtil.add(set, result, "\u26c8", "26c8.png", ":cloud_with_lightning_and_rain:", ":thunder_cloud_rain:", "Travel & Places", "5.2");
        EmojiUtil.add(set, result, "\u26ce", "26ce.png", ":ophiuchus:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\u26cf", "26cf.png", ":pick:", null, "Objects", "5.2");
        EmojiUtil.add(set, result, "\u26d1", "26d1.png", ":rescue_worker_helmet:", ":helmet_with_cross:", "Objects", "5.2");
        EmojiUtil.add(set, result, "\u26d3", "26d3.png", ":chains:", null, "Objects", "5.2");
        EmojiUtil.add(set, result, "\u26d4", "26d4.png", ":no_entry:", null, "Symbols", "5.2");
        EmojiUtil.add(set, result, "\u26e9", "26e9.png", ":shinto_shrine:", null, "Travel & Places", "5.2");
        EmojiUtil.add(set, result, "\u26ea", "26ea.png", ":church:", null, "Travel & Places", "5.2");
        EmojiUtil.add(set, result, "\u26f0", "26f0.png", ":mountain:", null, "Travel & Places", "5.2");
        EmojiUtil.add(set, result, "\u26f1", "26f1.png", ":parasol_on_ground:", null, "Travel & Places", "5.2");
        EmojiUtil.add(set, result, "\u26f2", "26f2.png", ":fountain:", null, "Travel & Places", "5.2");
        EmojiUtil.add(set, result, "\u26f3", "26f3.png", ":golf:", ":flag_in_hole:", "Activities", "5.2");
        EmojiUtil.add(set, result, "\u26f4", "26f4.png", ":ferry:", null, "Travel & Places", "5.2");
        EmojiUtil.add(set, result, "\u26f5", "26f5.png", ":boat:", ":sailboat:", "Travel & Places", "5.2");
        EmojiUtil.add(set, result, "\u26f7\ud83c\udffb", "26f7-1f3fb.png", ":skier_tone1:", null, "People & Body", "5.2");
        EmojiUtil.add(set, result, "\u26f7\ud83c\udffc", "26f7-1f3fc.png", ":skier_tone2:", null, "People & Body", "5.2");
        EmojiUtil.add(set, result, "\u26f7\ud83c\udffd", "26f7-1f3fd.png", ":skier_tone3:", null, "People & Body", "5.2");
        EmojiUtil.add(set, result, "\u26f7\ud83c\udffe", "26f7-1f3fe.png", ":skier_tone4:", null, "People & Body", "5.2");
        EmojiUtil.add(set, result, "\u26f7\ud83c\udfff", "26f7-1f3ff.png", ":skier_tone5:", null, "People & Body", "5.2");
        EmojiUtil.add(set, result, "\u26f7", "26f7.png", ":skier:", null, "People & Body", "5.2");
        EmojiUtil.add(set, result, "\u26f8", "26f8.png", ":ice_skate:", null, "Activities", "5.2");
        EmojiUtil.add(set, result, "\u26f9\ud83c\udffb\u200d\u2640\ufe0f", "26f9-1f3fb-200d-2640-fe0f.png", ":woman_bouncing_ball_person_tone1:", ":woman_bouncing_ball_light_skin_tone:", "People & Body", "5.2");
        EmojiUtil.add(set, result, "\u26f9\ud83c\udffb\u200d\u2642\ufe0f", "26f9-1f3fb-200d-2642-fe0f.png", ":man_bouncing_ball_person_tone1:", ":man_bouncing_ball_light_skin_tone:", "People & Body", "5.2");
        EmojiUtil.add(set, result, "\u26f9\ud83c\udffb", "26f9-1f3fb.png", ":bouncing_ball_person_tone1:", ":person_bouncing_ball_tone1:", "People & Body", "5.2");
        EmojiUtil.add(set, result, "\u26f9\ud83c\udffc\u200d\u2640\ufe0f", "26f9-1f3fc-200d-2640-fe0f.png", ":woman_bouncing_ball_person_tone2:", ":woman_bouncing_ball_medium_light_skin_tone:", "People & Body", "5.2");
        EmojiUtil.add(set, result, "\u26f9\ud83c\udffc\u200d\u2642\ufe0f", "26f9-1f3fc-200d-2642-fe0f.png", ":man_bouncing_ball_person_tone2:", ":man_bouncing_ball_medium_light_skin_tone:", "People & Body", "5.2");
        EmojiUtil.add(set, result, "\u26f9\ud83c\udffc", "26f9-1f3fc.png", ":bouncing_ball_person_tone2:", ":person_bouncing_ball_tone2:", "People & Body", "5.2");
        EmojiUtil.add(set, result, "\u26f9\ud83c\udffd\u200d\u2640\ufe0f", "26f9-1f3fd-200d-2640-fe0f.png", ":woman_bouncing_ball_person_tone3:", ":woman_bouncing_ball_medium_skin_tone:", "People & Body", "5.2");
        EmojiUtil.add(set, result, "\u26f9\ud83c\udffd\u200d\u2642\ufe0f", "26f9-1f3fd-200d-2642-fe0f.png", ":man_bouncing_ball_person_tone3:", ":man_bouncing_ball_medium_skin_tone:", "People & Body", "5.2");
        EmojiUtil.add(set, result, "\u26f9\ud83c\udffd", "26f9-1f3fd.png", ":bouncing_ball_person_tone3:", ":person_bouncing_ball_tone3:", "People & Body", "5.2");
        EmojiUtil.add(set, result, "\u26f9\ud83c\udffe\u200d\u2640\ufe0f", "26f9-1f3fe-200d-2640-fe0f.png", ":woman_bouncing_ball_person_tone4:", ":woman_bouncing_ball_medium_dark_skin_tone:", "People & Body", "5.2");
        EmojiUtil.add(set, result, "\u26f9\ud83c\udffe\u200d\u2642\ufe0f", "26f9-1f3fe-200d-2642-fe0f.png", ":man_bouncing_ball_person_tone4:", ":man_bouncing_ball_medium_dark_skin_tone:", "People & Body", "5.2");
        EmojiUtil.add(set, result, "\u26f9\ud83c\udffe", "26f9-1f3fe.png", ":bouncing_ball_person_tone4:", ":person_bouncing_ball_tone4:", "People & Body", "5.2");
        EmojiUtil.add(set, result, "\u26f9\ud83c\udfff\u200d\u2640\ufe0f", "26f9-1f3ff-200d-2640-fe0f.png", ":woman_bouncing_ball_person_tone5:", ":woman_bouncing_ball_dark_skin_tone:", "People & Body", "5.2");
        EmojiUtil.add(set, result, "\u26f9\ud83c\udfff\u200d\u2642\ufe0f", "26f9-1f3ff-200d-2642-fe0f.png", ":man_bouncing_ball_person_tone5:", ":man_bouncing_ball_dark_skin_tone:", "People & Body", "5.2");
        EmojiUtil.add(set, result, "\u26f9\ud83c\udfff", "26f9-1f3ff.png", ":bouncing_ball_person_tone5:", ":person_bouncing_ball_tone5:", "People & Body", "5.2");
        EmojiUtil.add(set, result, "\u26f9\ufe0f\u200d\u2640\ufe0f", "26f9-fe0f-200d-2640-fe0f.png", ":bouncing_ball_woman:", null, "People & Body", "7.0");
        EmojiUtil.add(set, result, "\u26f9\ufe0f\u200d\u2642\ufe0f", "26f9-fe0f-200d-2642-fe0f.png", ":bouncing_ball_man:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\u26f9", "26f9.png", ":bouncing_ball_person:", ":person_bouncing_ball:", "People & Body", "5.2");
        EmojiUtil.add(set, result, "\u26fa", "26fa.png", ":tent:", null, "Travel & Places", "5.2");
        EmojiUtil.add(set, result, "\u26fd", "26fd.png", ":fuelpump:", ":fuel_pump:", "Travel & Places", "5.2");
        EmojiUtil.add(set, result, "\u2702", "2702.png", ":scissors:", null, "Objects", "");
        EmojiUtil.add(set, result, "\u2705", "2705.png", ":white_check_mark:", ":check_mark_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\u2708", "2708.png", ":airplane:", null, "Travel & Places", "");
        EmojiUtil.add(set, result, "\u2709", "2709.png", ":envelope:", null, "Objects", "");
        EmojiUtil.add(set, result, "\u270a\ud83c\udffb", "270a-1f3fb.png", ":fist_raised_tone1:", ":fist_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\u270a\ud83c\udffc", "270a-1f3fc.png", ":fist_raised_tone2:", ":fist_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\u270a\ud83c\udffd", "270a-1f3fd.png", ":fist_raised_tone3:", ":fist_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\u270a\ud83c\udffe", "270a-1f3fe.png", ":fist_raised_tone4:", ":fist_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\u270a\ud83c\udfff", "270a-1f3ff.png", ":fist_raised_tone5:", ":fist_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\u270a", "270a.png", ":fist_raised:", ":fist:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\u270b\ud83c\udffb", "270b-1f3fb.png", ":hand_tone1:", ":raised_hand_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\u270b\ud83c\udffc", "270b-1f3fc.png", ":hand_tone2:", ":raised_hand_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\u270b\ud83c\udffd", "270b-1f3fd.png", ":hand_tone3:", ":raised_hand_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\u270b\ud83c\udffe", "270b-1f3fe.png", ":hand_tone4:", ":raised_hand_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\u270b\ud83c\udfff", "270b-1f3ff.png", ":hand_tone5:", ":raised_hand_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\u270b", "270b.png", ":hand:", ":raised_hand:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\u270c\ud83c\udffb", "270c-1f3fb.png", ":v_tone1:", ":victory_hand_light_skin_tone:", "People & Body", "");
        EmojiUtil.add(set, result, "\u270c\ud83c\udffc", "270c-1f3fc.png", ":v_tone2:", ":victory_hand_medium_light_skin_tone:", "People & Body", "");
        EmojiUtil.add(set, result, "\u270c\ud83c\udffd", "270c-1f3fd.png", ":v_tone3:", ":victory_hand_medium_skin_tone:", "People & Body", "");
        EmojiUtil.add(set, result, "\u270c\ud83c\udffe", "270c-1f3fe.png", ":v_tone4:", ":victory_hand_medium_dark_skin_tone:", "People & Body", "");
        EmojiUtil.add(set, result, "\u270c\ud83c\udfff", "270c-1f3ff.png", ":v_tone5:", ":victory_hand_dark_skin_tone:", "People & Body", "");
        EmojiUtil.add(set, result, "\u270c", "270c.png", ":v:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\u270d\ud83c\udffb", "270d-1f3fb.png", ":writing_hand_tone1:", ":writing_hand_light_skin_tone:", "People & Body", "");
        EmojiUtil.add(set, result, "\u270d\ud83c\udffc", "270d-1f3fc.png", ":writing_hand_tone2:", ":writing_hand_medium_light_skin_tone:", "People & Body", "");
        EmojiUtil.add(set, result, "\u270d\ud83c\udffd", "270d-1f3fd.png", ":writing_hand_tone3:", ":writing_hand_medium_skin_tone:", "People & Body", "");
        EmojiUtil.add(set, result, "\u270d\ud83c\udffe", "270d-1f3fe.png", ":writing_hand_tone4:", ":writing_hand_medium_dark_skin_tone:", "People & Body", "");
        EmojiUtil.add(set, result, "\u270d\ud83c\udfff", "270d-1f3ff.png", ":writing_hand_tone5:", ":writing_hand_dark_skin_tone:", "People & Body", "");
        EmojiUtil.add(set, result, "\u270d", "270d.png", ":writing_hand:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\u270f", "270f.png", ":pencil2:", null, "Objects", "");
        EmojiUtil.add(set, result, "\u2712", "2712.png", ":black_nib:", null, "Objects", "");
        EmojiUtil.add(set, result, "\u2714", "2714.png", ":heavy_check_mark:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2716", "2716.png", ":heavy_multiplication_x:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u271d", "271d.png", ":latin_cross:", ":cross:", "Symbols", "");
        EmojiUtil.add(set, result, "\u2721", "2721.png", ":star_of_david:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2728", "2728.png", ":sparkles:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\u2733", "2733.png", ":eight_spoked_asterisk:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2734", "2734.png", ":eight_pointed_black_star:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2744", "2744.png", ":snowflake:", null, "Travel & Places", "");
        EmojiUtil.add(set, result, "\u2747", "2747.png", ":sparkle:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u274c", "274c.png", ":x:", ":cross_mark:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\u274e", "274e.png", ":negative_squared_cross_mark:", ":cross_mark_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\u2753", "2753.png", ":question:", ":red_question_mark:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\u2754", "2754.png", ":grey_question:", ":white_question_mark:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\u2755", "2755.png", ":grey_exclamation:", ":white_exclamation_mark:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\u2757", "2757.png", ":exclamation:", ":red_exclamation_mark:", "Symbols", "5.2");
        EmojiUtil.add(set, result, "\u2763", "2763.png", ":heavy_heart_exclamation:", ":heart_exclamation:", "Smileys & Emotion", "");
        EmojiUtil.add(set, result, "\u2764\ufe0f\u200d\ud83d\udd25", "2764-fe0f-200d-1f525.png", ":heart_on_fire:", null, "Smileys & Emotion", "13.1");
        EmojiUtil.add(set, result, "\u2764\ufe0f\u200d\ud83e\ude79", "2764-fe0f-200d-1fa79.png", ":mending_heart:", null, "Smileys & Emotion", "13.1");
        EmojiUtil.add(set, result, "\u2764", "2764.png", ":heart:", null, "Smileys & Emotion", "");
        EmojiUtil.add(set, result, "\u2795", "2795.png", ":heavy_plus_sign:", ":plus:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\u2796", "2796.png", ":heavy_minus_sign:", ":minus:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\u2797", "2797.png", ":heavy_division_sign:", ":divide:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\u27a1", "27a1.png", ":arrow_right:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u27b0", "27b0.png", ":curly_loop:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\u27bf", "27bf.png", ":loop:", ":double_curly_loop:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\u2934", "2934.png", ":arrow_heading_up:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2935", "2935.png", ":arrow_heading_down:", null, "Symbols", "");
        EmojiUtil.add(set, result, "*\u20e3", "2a-20e3.png", ":asterisk:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2b05", "2b05.png", ":arrow_left:", null, "Symbols", "4.0");
        EmojiUtil.add(set, result, "\u2b06", "2b06.png", ":arrow_up:", null, "Symbols", "4.0");
        EmojiUtil.add(set, result, "\u2b07", "2b07.png", ":arrow_down:", null, "Symbols", "4.0");
        EmojiUtil.add(set, result, "\u2b1b", "2b1b.png", ":black_large_square:", null, "Symbols", "5.1");
        EmojiUtil.add(set, result, "\u2b1c", "2b1c.png", ":white_large_square:", null, "Symbols", "5.1");
        EmojiUtil.add(set, result, "\u2b50", "2b50.png", ":star:", null, "Travel & Places", "5.1");
        EmojiUtil.add(set, result, "\u2b55", "2b55.png", ":o:", ":hollow_red_circle:", "Symbols", "5.2");
        EmojiUtil.add(set, result, "0\u20e3", "30-20e3.png", ":zero:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u3030", "3030.png", ":wavy_dash:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u303d", "303d.png", ":part_alternation_mark:", null, "Symbols", "3.2");
        EmojiUtil.add(set, result, "1\u20e3", "31-20e3.png", ":one:", null, "Symbols", "");
        EmojiUtil.add(set, result, "2\u20e3", "32-20e3.png", ":two:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u3297", "3297.png", ":congratulations:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u3299", "3299.png", ":secret:", null, "Symbols", "");
        EmojiUtil.add(set, result, "3\u20e3", "33-20e3.png", ":three:", null, "Symbols", "");
        EmojiUtil.add(set, result, "4\u20e3", "34-20e3.png", ":four:", null, "Symbols", "");
        EmojiUtil.add(set, result, "5\u20e3", "35-20e3.png", ":five:", null, "Symbols", "");
        EmojiUtil.add(set, result, "6\u20e3", "36-20e3.png", ":six:", null, "Symbols", "");
        EmojiUtil.add(set, result, "7\u20e3", "37-20e3.png", ":seven:", null, "Symbols", "");
        EmojiUtil.add(set, result, "8\u20e3", "38-20e3.png", ":eight:", null, "Symbols", "");
        EmojiUtil.add(set, result, "9\u20e3", "39-20e3.png", ":nine:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\ue50a", "e50a.png", null, null, null, null);
    }

    /*
     * Opcode count of 16355 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static void e1(EmojiSet set, Set<Emoticon> result) {
        EmojiUtil.add(set, result, "#\u20e3", "0023-20e3.png", ":hash:", null, "Symbols", "");
        EmojiUtil.add(set, result, "*\u20e3", "002a-20e3.png", ":asterisk:", null, "Symbols", "");
        EmojiUtil.add(set, result, "0\u20e3", "0030-20e3.png", ":zero:", null, "Symbols", "");
        EmojiUtil.add(set, result, "1\u20e3", "0031-20e3.png", ":one:", null, "Symbols", "");
        EmojiUtil.add(set, result, "2\u20e3", "0032-20e3.png", ":two:", null, "Symbols", "");
        EmojiUtil.add(set, result, "3\u20e3", "0033-20e3.png", ":three:", null, "Symbols", "");
        EmojiUtil.add(set, result, "4\u20e3", "0034-20e3.png", ":four:", null, "Symbols", "");
        EmojiUtil.add(set, result, "5\u20e3", "0035-20e3.png", ":five:", null, "Symbols", "");
        EmojiUtil.add(set, result, "6\u20e3", "0036-20e3.png", ":six:", null, "Symbols", "");
        EmojiUtil.add(set, result, "7\u20e3", "0037-20e3.png", ":seven:", null, "Symbols", "");
        EmojiUtil.add(set, result, "8\u20e3", "0038-20e3.png", ":eight:", null, "Symbols", "");
        EmojiUtil.add(set, result, "9\u20e3", "0039-20e3.png", ":nine:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\ud83c\udc04", "1f004.png", ":mahjong:", ":mahjong_red_dragon:", "Activities", "");
        EmojiUtil.add(set, result, "\ud83c\udccf", "1f0cf.png", ":black_joker:", ":joker:", "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udd70", "1f170.png", ":a:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udd71", "1f171.png", ":b:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udd7e", "1f17e.png", ":o2:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udd7f", "1f17f.png", ":parking:", null, "Symbols", "5.2");
        EmojiUtil.add(set, result, "\ud83c\udd8e", "1f18e.png", ":ab:", ":ab_button_blood_type:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udd91", "1f191.png", ":cl:", ":cl_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udd92", "1f192.png", ":cool:", ":cool_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udd93", "1f193.png", ":free:", ":free_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udd94", "1f194.png", ":id:", ":id_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udd95", "1f195.png", ":new:", ":new_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udd96", "1f196.png", ":ng:", ":ng_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udd97", "1f197.png", ":ok:", ":ok_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udd98", "1f198.png", ":sos:", ":sos_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udd99", "1f199.png", ":up:", ":up_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udd9a", "1f19a.png", ":vs:", ":vs_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde6\ud83c\udde8", "1f1e6-1f1e8.png", ":ascension_island:", ":flag_ac:", "Flags", "11.0");
        EmojiUtil.add(set, result, "\ud83c\udde6\ud83c\udde9", "1f1e6-1f1e9.png", ":andorra:", ":flag_ad:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde6\ud83c\uddea", "1f1e6-1f1ea.png", ":united_arab_emirates:", ":flag_ae:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde6\ud83c\uddeb", "1f1e6-1f1eb.png", ":afghanistan:", ":flag_af:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde6\ud83c\uddec", "1f1e6-1f1ec.png", ":antigua_barbuda:", ":flag_ag:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde6\ud83c\uddee", "1f1e6-1f1ee.png", ":anguilla:", ":flag_ai:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde6\ud83c\uddf1", "1f1e6-1f1f1.png", ":albania:", ":flag_al:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde6\ud83c\uddf2", "1f1e6-1f1f2.png", ":armenia:", ":flag_am:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde6\ud83c\uddf4", "1f1e6-1f1f4.png", ":angola:", ":flag_ao:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde6\ud83c\uddf6", "1f1e6-1f1f6.png", ":antarctica:", ":flag_aq:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde6\ud83c\uddf7", "1f1e6-1f1f7.png", ":argentina:", ":flag_ar:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde6\ud83c\uddf8", "1f1e6-1f1f8.png", ":american_samoa:", ":flag_as:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde6\ud83c\uddf9", "1f1e6-1f1f9.png", ":austria:", ":flag_at:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde6\ud83c\uddfa", "1f1e6-1f1fa.png", ":australia:", ":flag_au:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde6\ud83c\uddfc", "1f1e6-1f1fc.png", ":aruba:", ":flag_aw:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde6\ud83c\uddfd", "1f1e6-1f1fd.png", ":aland_islands:", ":flag_ax:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde6\ud83c\uddff", "1f1e6-1f1ff.png", ":azerbaijan:", ":flag_az:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde6", "1f1e6.png", ":regional_indicator_a:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\udde6", "1f1e7-1f1e6.png", ":bosnia_herzegovina:", ":flag_ba:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\udde7", "1f1e7-1f1e7.png", ":barbados:", ":flag_bb:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\udde9", "1f1e7-1f1e9.png", ":bangladesh:", ":flag_bd:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\uddea", "1f1e7-1f1ea.png", ":belgium:", ":flag_be:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\uddeb", "1f1e7-1f1eb.png", ":burkina_faso:", ":flag_bf:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\uddec", "1f1e7-1f1ec.png", ":bulgaria:", ":flag_bg:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\udded", "1f1e7-1f1ed.png", ":bahrain:", ":flag_bh:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\uddee", "1f1e7-1f1ee.png", ":burundi:", ":flag_bi:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\uddef", "1f1e7-1f1ef.png", ":benin:", ":flag_bj:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\uddf1", "1f1e7-1f1f1.png", ":st_barthelemy:", ":flag_bl:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\uddf2", "1f1e7-1f1f2.png", ":bermuda:", ":flag_bm:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\uddf3", "1f1e7-1f1f3.png", ":brunei:", ":flag_bn:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\uddf4", "1f1e7-1f1f4.png", ":bolivia:", ":flag_bo:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\uddf6", "1f1e7-1f1f6.png", ":caribbean_netherlands:", ":flag_bq:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\uddf7", "1f1e7-1f1f7.png", ":brazil:", ":flag_br:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\uddf8", "1f1e7-1f1f8.png", ":bahamas:", ":flag_bs:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\uddf9", "1f1e7-1f1f9.png", ":bhutan:", ":flag_bt:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\uddfb", "1f1e7-1f1fb.png", ":bouvet_island:", ":flag_bv:", "Flags", "11.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\uddfc", "1f1e7-1f1fc.png", ":botswana:", ":flag_bw:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\uddfe", "1f1e7-1f1fe.png", ":belarus:", ":flag_by:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7\ud83c\uddff", "1f1e7-1f1ff.png", ":belize:", ":flag_bz:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde7", "1f1e7.png", ":regional_indicator_b:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\udde6", "1f1e8-1f1e6.png", ":canada:", ":flag_ca:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\udde8", "1f1e8-1f1e8.png", ":cocos_islands:", ":flag_cc:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\udde9", "1f1e8-1f1e9.png", ":congo_kinshasa:", ":flag_cd:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\uddeb", "1f1e8-1f1eb.png", ":central_african_republic:", ":flag_cf:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\uddec", "1f1e8-1f1ec.png", ":congo_brazzaville:", ":flag_cg:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\udded", "1f1e8-1f1ed.png", ":switzerland:", ":flag_ch:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\uddee", "1f1e8-1f1ee.png", ":cote_divoire:", ":flag_ci:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\uddf0", "1f1e8-1f1f0.png", ":cook_islands:", ":flag_ck:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\uddf1", "1f1e8-1f1f1.png", ":chile:", ":flag_cl:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\uddf2", "1f1e8-1f1f2.png", ":cameroon:", ":flag_cm:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\uddf3", "1f1e8-1f1f3.png", ":cn:", ":flag_cn:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\uddf4", "1f1e8-1f1f4.png", ":colombia:", ":flag_co:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\uddf5", "1f1e8-1f1f5.png", ":clipperton_island:", ":flag_cp:", "Flags", "11.0");
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\uddf7", "1f1e8-1f1f7.png", ":costa_rica:", ":flag_cr:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\uddfa", "1f1e8-1f1fa.png", ":cuba:", ":flag_cu:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\uddfb", "1f1e8-1f1fb.png", ":cape_verde:", ":flag_cv:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\uddfc", "1f1e8-1f1fc.png", ":curacao:", ":flag_cw:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\uddfd", "1f1e8-1f1fd.png", ":christmas_island:", ":flag_cx:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\uddfe", "1f1e8-1f1fe.png", ":cyprus:", ":flag_cy:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde8\ud83c\uddff", "1f1e8-1f1ff.png", ":czech_republic:", ":flag_cz:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde8", "1f1e8.png", ":regional_indicator_c:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\udde9\ud83c\uddea", "1f1e9-1f1ea.png", ":de:", ":flag_de:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde9\ud83c\uddec", "1f1e9-1f1ec.png", ":diego_garcia:", ":flag_dg:", "Flags", "11.0");
        EmojiUtil.add(set, result, "\ud83c\udde9\ud83c\uddef", "1f1e9-1f1ef.png", ":djibouti:", ":flag_dj:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde9\ud83c\uddf0", "1f1e9-1f1f0.png", ":denmark:", ":flag_dk:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde9\ud83c\uddf2", "1f1e9-1f1f2.png", ":dominica:", ":flag_dm:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde9\ud83c\uddf4", "1f1e9-1f1f4.png", ":dominican_republic:", ":flag_do:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde9\ud83c\uddff", "1f1e9-1f1ff.png", ":algeria:", ":flag_dz:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udde9", "1f1e9.png", ":regional_indicator_d:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddea\ud83c\udde6", "1f1ea-1f1e6.png", ":ceuta_melilla:", ":flag_ea:", "Flags", "11.0");
        EmojiUtil.add(set, result, "\ud83c\uddea\ud83c\udde8", "1f1ea-1f1e8.png", ":ecuador:", ":flag_ec:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddea\ud83c\uddea", "1f1ea-1f1ea.png", ":estonia:", ":flag_ee:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddea\ud83c\uddec", "1f1ea-1f1ec.png", ":egypt:", ":flag_eg:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddea\ud83c\udded", "1f1ea-1f1ed.png", ":western_sahara:", ":flag_eh:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddea\ud83c\uddf7", "1f1ea-1f1f7.png", ":eritrea:", ":flag_er:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddea\ud83c\uddf8", "1f1ea-1f1f8.png", ":es:", ":flag_es:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddea\ud83c\uddf9", "1f1ea-1f1f9.png", ":ethiopia:", ":flag_et:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddea\ud83c\uddfa", "1f1ea-1f1fa.png", ":eu:", ":flag_eu:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddea", "1f1ea.png", ":regional_indicator_e:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddeb\ud83c\uddee", "1f1eb-1f1ee.png", ":finland:", ":flag_fi:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddeb\ud83c\uddef", "1f1eb-1f1ef.png", ":fiji:", ":flag_fj:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddeb\ud83c\uddf0", "1f1eb-1f1f0.png", ":falkland_islands:", ":flag_fk:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddeb\ud83c\uddf2", "1f1eb-1f1f2.png", ":micronesia:", ":flag_fm:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddeb\ud83c\uddf4", "1f1eb-1f1f4.png", ":faroe_islands:", ":flag_fo:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddeb\ud83c\uddf7", "1f1eb-1f1f7.png", ":fr:", ":flag_fr:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddeb", "1f1eb.png", ":regional_indicator_f:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddec\ud83c\udde6", "1f1ec-1f1e6.png", ":gabon:", ":flag_ga:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddec\ud83c\udde7", "1f1ec-1f1e7.png", ":gb:", ":flag_gb:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddec\ud83c\udde9", "1f1ec-1f1e9.png", ":grenada:", ":flag_gd:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddec\ud83c\uddea", "1f1ec-1f1ea.png", ":georgia:", ":flag_ge:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddec\ud83c\uddeb", "1f1ec-1f1eb.png", ":french_guiana:", ":flag_gf:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddec\ud83c\uddec", "1f1ec-1f1ec.png", ":guernsey:", ":flag_gg:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddec\ud83c\udded", "1f1ec-1f1ed.png", ":ghana:", ":flag_gh:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddec\ud83c\uddee", "1f1ec-1f1ee.png", ":gibraltar:", ":flag_gi:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddec\ud83c\uddf1", "1f1ec-1f1f1.png", ":greenland:", ":flag_gl:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddec\ud83c\uddf2", "1f1ec-1f1f2.png", ":gambia:", ":flag_gm:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddec\ud83c\uddf3", "1f1ec-1f1f3.png", ":guinea:", ":flag_gn:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddec\ud83c\uddf5", "1f1ec-1f1f5.png", ":guadeloupe:", ":flag_gp:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddec\ud83c\uddf6", "1f1ec-1f1f6.png", ":equatorial_guinea:", ":flag_gq:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddec\ud83c\uddf7", "1f1ec-1f1f7.png", ":greece:", ":flag_gr:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddec\ud83c\uddf8", "1f1ec-1f1f8.png", ":south_georgia_south_sandwich_islands:", ":flag_gs:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddec\ud83c\uddf9", "1f1ec-1f1f9.png", ":guatemala:", ":flag_gt:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddec\ud83c\uddfa", "1f1ec-1f1fa.png", ":guam:", ":flag_gu:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddec\ud83c\uddfc", "1f1ec-1f1fc.png", ":guinea_bissau:", ":flag_gw:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddec\ud83c\uddfe", "1f1ec-1f1fe.png", ":guyana:", ":flag_gy:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddec", "1f1ec.png", ":regional_indicator_g:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\udded\ud83c\uddf0", "1f1ed-1f1f0.png", ":hong_kong:", ":flag_hk:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udded\ud83c\uddf2", "1f1ed-1f1f2.png", ":heard_mcdonald_islands:", ":flag_hm:", "Flags", "11.0");
        EmojiUtil.add(set, result, "\ud83c\udded\ud83c\uddf3", "1f1ed-1f1f3.png", ":honduras:", ":flag_hn:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udded\ud83c\uddf7", "1f1ed-1f1f7.png", ":croatia:", ":flag_hr:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udded\ud83c\uddf9", "1f1ed-1f1f9.png", ":haiti:", ":flag_ht:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udded\ud83c\uddfa", "1f1ed-1f1fa.png", ":hungary:", ":flag_hu:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udded", "1f1ed.png", ":regional_indicator_h:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddee\ud83c\udde8", "1f1ee-1f1e8.png", ":canary_islands:", ":flag_ic:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddee\ud83c\udde9", "1f1ee-1f1e9.png", ":indonesia:", ":flag_id:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddee\ud83c\uddea", "1f1ee-1f1ea.png", ":ireland:", ":flag_ie:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddee\ud83c\uddf1", "1f1ee-1f1f1.png", ":israel:", ":flag_il:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddee\ud83c\uddf2", "1f1ee-1f1f2.png", ":isle_of_man:", ":flag_im:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddee\ud83c\uddf3", "1f1ee-1f1f3.png", ":india:", ":flag_in:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddee\ud83c\uddf4", "1f1ee-1f1f4.png", ":british_indian_ocean_territory:", ":flag_io:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddee\ud83c\uddf6", "1f1ee-1f1f6.png", ":iraq:", ":flag_iq:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddee\ud83c\uddf7", "1f1ee-1f1f7.png", ":iran:", ":flag_ir:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddee\ud83c\uddf8", "1f1ee-1f1f8.png", ":iceland:", ":flag_is:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddee\ud83c\uddf9", "1f1ee-1f1f9.png", ":it:", ":flag_it:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddee", "1f1ee.png", ":regional_indicator_i:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddef\ud83c\uddea", "1f1ef-1f1ea.png", ":jersey:", ":flag_je:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddef\ud83c\uddf2", "1f1ef-1f1f2.png", ":jamaica:", ":flag_jm:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddef\ud83c\uddf4", "1f1ef-1f1f4.png", ":jordan:", ":flag_jo:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddef\ud83c\uddf5", "1f1ef-1f1f5.png", ":jp:", ":flag_jp:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddef", "1f1ef.png", ":regional_indicator_j:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddf0\ud83c\uddea", "1f1f0-1f1ea.png", ":kenya:", ":flag_ke:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf0\ud83c\uddec", "1f1f0-1f1ec.png", ":kyrgyzstan:", ":flag_kg:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf0\ud83c\udded", "1f1f0-1f1ed.png", ":cambodia:", ":flag_kh:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf0\ud83c\uddee", "1f1f0-1f1ee.png", ":kiribati:", ":flag_ki:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf0\ud83c\uddf2", "1f1f0-1f1f2.png", ":comoros:", ":flag_km:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf0\ud83c\uddf3", "1f1f0-1f1f3.png", ":st_kitts_nevis:", ":flag_kn:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf0\ud83c\uddf5", "1f1f0-1f1f5.png", ":north_korea:", ":flag_kp:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf0\ud83c\uddf7", "1f1f0-1f1f7.png", ":kr:", ":flag_kr:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf0\ud83c\uddfc", "1f1f0-1f1fc.png", ":kuwait:", ":flag_kw:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf0\ud83c\uddfe", "1f1f0-1f1fe.png", ":cayman_islands:", ":flag_ky:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf0\ud83c\uddff", "1f1f0-1f1ff.png", ":kazakhstan:", ":flag_kz:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf0", "1f1f0.png", ":regional_indicator_k:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddf1\ud83c\udde6", "1f1f1-1f1e6.png", ":laos:", ":flag_la:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf1\ud83c\udde7", "1f1f1-1f1e7.png", ":lebanon:", ":flag_lb:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf1\ud83c\udde8", "1f1f1-1f1e8.png", ":st_lucia:", ":flag_lc:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf1\ud83c\uddee", "1f1f1-1f1ee.png", ":liechtenstein:", ":flag_li:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf1\ud83c\uddf0", "1f1f1-1f1f0.png", ":sri_lanka:", ":flag_lk:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf1\ud83c\uddf7", "1f1f1-1f1f7.png", ":liberia:", ":flag_lr:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf1\ud83c\uddf8", "1f1f1-1f1f8.png", ":lesotho:", ":flag_ls:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf1\ud83c\uddf9", "1f1f1-1f1f9.png", ":lithuania:", ":flag_lt:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf1\ud83c\uddfa", "1f1f1-1f1fa.png", ":luxembourg:", ":flag_lu:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf1\ud83c\uddfb", "1f1f1-1f1fb.png", ":latvia:", ":flag_lv:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf1\ud83c\uddfe", "1f1f1-1f1fe.png", ":libya:", ":flag_ly:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf1", "1f1f1.png", ":regional_indicator_l:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\udde6", "1f1f2-1f1e6.png", ":morocco:", ":flag_ma:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\udde8", "1f1f2-1f1e8.png", ":monaco:", ":flag_mc:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\udde9", "1f1f2-1f1e9.png", ":moldova:", ":flag_md:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\uddea", "1f1f2-1f1ea.png", ":montenegro:", ":flag_me:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\uddeb", "1f1f2-1f1eb.png", ":st_martin:", ":flag_mf:", "Flags", "11.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\uddec", "1f1f2-1f1ec.png", ":madagascar:", ":flag_mg:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\udded", "1f1f2-1f1ed.png", ":marshall_islands:", ":flag_mh:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\uddf0", "1f1f2-1f1f0.png", ":macedonia:", ":flag_mk:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\uddf1", "1f1f2-1f1f1.png", ":mali:", ":flag_ml:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\uddf2", "1f1f2-1f1f2.png", ":myanmar:", ":flag_mm:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\uddf3", "1f1f2-1f1f3.png", ":mongolia:", ":flag_mn:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\uddf4", "1f1f2-1f1f4.png", ":macau:", ":flag_mo:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\uddf5", "1f1f2-1f1f5.png", ":northern_mariana_islands:", ":flag_mp:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\uddf6", "1f1f2-1f1f6.png", ":martinique:", ":flag_mq:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\uddf7", "1f1f2-1f1f7.png", ":mauritania:", ":flag_mr:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\uddf8", "1f1f2-1f1f8.png", ":montserrat:", ":flag_ms:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\uddf9", "1f1f2-1f1f9.png", ":malta:", ":flag_mt:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\uddfa", "1f1f2-1f1fa.png", ":mauritius:", ":flag_mu:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\uddfb", "1f1f2-1f1fb.png", ":maldives:", ":flag_mv:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\uddfc", "1f1f2-1f1fc.png", ":malawi:", ":flag_mw:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\uddfd", "1f1f2-1f1fd.png", ":mexico:", ":flag_mx:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\uddfe", "1f1f2-1f1fe.png", ":malaysia:", ":flag_my:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2\ud83c\uddff", "1f1f2-1f1ff.png", ":mozambique:", ":flag_mz:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf2", "1f1f2.png", ":regional_indicator_m:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddf3\ud83c\udde6", "1f1f3-1f1e6.png", ":namibia:", ":flag_na:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf3\ud83c\udde8", "1f1f3-1f1e8.png", ":new_caledonia:", ":flag_nc:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf3\ud83c\uddea", "1f1f3-1f1ea.png", ":niger:", ":flag_ne:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf3\ud83c\uddeb", "1f1f3-1f1eb.png", ":norfolk_island:", ":flag_nf:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf3\ud83c\uddec", "1f1f3-1f1ec.png", ":nigeria:", ":flag_ng:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf3\ud83c\uddee", "1f1f3-1f1ee.png", ":nicaragua:", ":flag_ni:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf3\ud83c\uddf1", "1f1f3-1f1f1.png", ":netherlands:", ":flag_nl:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf3\ud83c\uddf4", "1f1f3-1f1f4.png", ":norway:", ":flag_no:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf3\ud83c\uddf5", "1f1f3-1f1f5.png", ":nepal:", ":flag_np:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf3\ud83c\uddf7", "1f1f3-1f1f7.png", ":nauru:", ":flag_nr:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf3\ud83c\uddfa", "1f1f3-1f1fa.png", ":niue:", ":flag_nu:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf3\ud83c\uddff", "1f1f3-1f1ff.png", ":new_zealand:", ":flag_nz:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf3", "1f1f3.png", ":regional_indicator_n:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddf4\ud83c\uddf2", "1f1f4-1f1f2.png", ":oman:", ":flag_om:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf4", "1f1f4.png", ":regional_indicator_o:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddf5\ud83c\udde6", "1f1f5-1f1e6.png", ":panama:", ":flag_pa:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf5\ud83c\uddea", "1f1f5-1f1ea.png", ":peru:", ":flag_pe:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf5\ud83c\uddeb", "1f1f5-1f1eb.png", ":french_polynesia:", ":flag_pf:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf5\ud83c\uddec", "1f1f5-1f1ec.png", ":papua_new_guinea:", ":flag_pg:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf5\ud83c\udded", "1f1f5-1f1ed.png", ":philippines:", ":flag_ph:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf5\ud83c\uddf0", "1f1f5-1f1f0.png", ":pakistan:", ":flag_pk:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf5\ud83c\uddf1", "1f1f5-1f1f1.png", ":poland:", ":flag_pl:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf5\ud83c\uddf2", "1f1f5-1f1f2.png", ":st_pierre_miquelon:", ":flag_pm:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf5\ud83c\uddf3", "1f1f5-1f1f3.png", ":pitcairn_islands:", ":flag_pn:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf5\ud83c\uddf7", "1f1f5-1f1f7.png", ":puerto_rico:", ":flag_pr:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf5\ud83c\uddf8", "1f1f5-1f1f8.png", ":palestinian_territories:", ":flag_ps:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf5\ud83c\uddf9", "1f1f5-1f1f9.png", ":portugal:", ":flag_pt:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf5\ud83c\uddfc", "1f1f5-1f1fc.png", ":palau:", ":flag_pw:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf5\ud83c\uddfe", "1f1f5-1f1fe.png", ":paraguay:", ":flag_py:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf5", "1f1f5.png", ":regional_indicator_p:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddf6\ud83c\udde6", "1f1f6-1f1e6.png", ":qatar:", ":flag_qa:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf6", "1f1f6.png", ":regional_indicator_q:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddf7\ud83c\uddea", "1f1f7-1f1ea.png", ":reunion:", ":flag_re:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf7\ud83c\uddf4", "1f1f7-1f1f4.png", ":romania:", ":flag_ro:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf7\ud83c\uddf8", "1f1f7-1f1f8.png", ":serbia:", ":flag_rs:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf7\ud83c\uddfa", "1f1f7-1f1fa.png", ":ru:", ":flag_ru:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf7\ud83c\uddfc", "1f1f7-1f1fc.png", ":rwanda:", ":flag_rw:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf7", "1f1f7.png", ":regional_indicator_r:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\udde6", "1f1f8-1f1e6.png", ":saudi_arabia:", ":flag_sa:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\udde7", "1f1f8-1f1e7.png", ":solomon_islands:", ":flag_sb:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\udde8", "1f1f8-1f1e8.png", ":seychelles:", ":flag_sc:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\udde9", "1f1f8-1f1e9.png", ":sudan:", ":flag_sd:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\uddea", "1f1f8-1f1ea.png", ":sweden:", ":flag_se:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\uddec", "1f1f8-1f1ec.png", ":singapore:", ":flag_sg:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\udded", "1f1f8-1f1ed.png", ":st_helena:", ":flag_sh:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\uddee", "1f1f8-1f1ee.png", ":slovenia:", ":flag_si:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\uddef", "1f1f8-1f1ef.png", ":svalbard_jan_mayen:", ":flag_sj:", "Flags", "11.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\uddf0", "1f1f8-1f1f0.png", ":slovakia:", ":flag_sk:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\uddf1", "1f1f8-1f1f1.png", ":sierra_leone:", ":flag_sl:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\uddf2", "1f1f8-1f1f2.png", ":san_marino:", ":flag_sm:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\uddf3", "1f1f8-1f1f3.png", ":senegal:", ":flag_sn:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\uddf4", "1f1f8-1f1f4.png", ":somalia:", ":flag_so:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\uddf7", "1f1f8-1f1f7.png", ":suriname:", ":flag_sr:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\uddf8", "1f1f8-1f1f8.png", ":south_sudan:", ":flag_ss:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\uddf9", "1f1f8-1f1f9.png", ":sao_tome_principe:", ":flag_st:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\uddfb", "1f1f8-1f1fb.png", ":el_salvador:", ":flag_sv:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\uddfd", "1f1f8-1f1fd.png", ":sint_maarten:", ":flag_sx:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\uddfe", "1f1f8-1f1fe.png", ":syria:", ":flag_sy:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8\ud83c\uddff", "1f1f8-1f1ff.png", ":swaziland:", ":flag_sz:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf8", "1f1f8.png", ":regional_indicator_s:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddf9\ud83c\udde6", "1f1f9-1f1e6.png", ":tristan_da_cunha:", ":flag_ta:", "Flags", "11.0");
        EmojiUtil.add(set, result, "\ud83c\uddf9\ud83c\udde8", "1f1f9-1f1e8.png", ":turks_caicos_islands:", ":flag_tc:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf9\ud83c\udde9", "1f1f9-1f1e9.png", ":chad:", ":flag_td:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf9\ud83c\uddeb", "1f1f9-1f1eb.png", ":french_southern_territories:", ":flag_tf:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf9\ud83c\uddec", "1f1f9-1f1ec.png", ":togo:", ":flag_tg:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf9\ud83c\udded", "1f1f9-1f1ed.png", ":thailand:", ":flag_th:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf9\ud83c\uddef", "1f1f9-1f1ef.png", ":tajikistan:", ":flag_tj:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf9\ud83c\uddf0", "1f1f9-1f1f0.png", ":tokelau:", ":flag_tk:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf9\ud83c\uddf1", "1f1f9-1f1f1.png", ":timor_leste:", ":flag_tl:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf9\ud83c\uddf2", "1f1f9-1f1f2.png", ":turkmenistan:", ":flag_tm:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf9\ud83c\uddf3", "1f1f9-1f1f3.png", ":tunisia:", ":flag_tn:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf9\ud83c\uddf4", "1f1f9-1f1f4.png", ":tonga:", ":flag_to:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf9\ud83c\uddf7", "1f1f9-1f1f7.png", ":tr:", ":flag_tr:", "Flags", "8.0");
        EmojiUtil.add(set, result, "\ud83c\uddf9\ud83c\uddf9", "1f1f9-1f1f9.png", ":trinidad_tobago:", ":flag_tt:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf9\ud83c\uddfb", "1f1f9-1f1fb.png", ":tuvalu:", ":flag_tv:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf9\ud83c\uddfc", "1f1f9-1f1fc.png", ":taiwan:", ":flag_tw:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf9\ud83c\uddff", "1f1f9-1f1ff.png", ":tanzania:", ":flag_tz:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddf9", "1f1f9.png", ":regional_indicator_t:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddfa\ud83c\udde6", "1f1fa-1f1e6.png", ":ukraine:", ":flag_ua:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddfa\ud83c\uddec", "1f1fa-1f1ec.png", ":uganda:", ":flag_ug:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddfa\ud83c\uddf2", "1f1fa-1f1f2.png", ":us_outlying_islands:", ":flag_um:", "Flags", "11.0");
        EmojiUtil.add(set, result, "\ud83c\uddfa\ud83c\uddf8", "1f1fa-1f1f8.png", ":us:", ":flag_us:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddfa\ud83c\uddfe", "1f1fa-1f1fe.png", ":uruguay:", ":flag_uy:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddfa\ud83c\uddff", "1f1fa-1f1ff.png", ":uzbekistan:", ":flag_uz:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddfa", "1f1fa.png", ":regional_indicator_u:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddfb\ud83c\udde6", "1f1fb-1f1e6.png", ":vatican_city:", ":flag_va:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddfb\ud83c\udde8", "1f1fb-1f1e8.png", ":st_vincent_grenadines:", ":flag_vc:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddfb\ud83c\uddea", "1f1fb-1f1ea.png", ":venezuela:", ":flag_ve:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddfb\ud83c\uddec", "1f1fb-1f1ec.png", ":british_virgin_islands:", ":flag_vg:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddfb\ud83c\uddee", "1f1fb-1f1ee.png", ":us_virgin_islands:", ":flag_vi:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddfb\ud83c\uddf3", "1f1fb-1f1f3.png", ":vietnam:", ":flag_vn:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddfb\ud83c\uddfa", "1f1fb-1f1fa.png", ":vanuatu:", ":flag_vu:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddfb", "1f1fb.png", ":regional_indicator_v:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddfc\ud83c\uddeb", "1f1fc-1f1eb.png", ":wallis_futuna:", ":flag_wf:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddfc\ud83c\uddf8", "1f1fc-1f1f8.png", ":samoa:", ":flag_ws:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddfc", "1f1fc.png", ":regional_indicator_w:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddfd\ud83c\uddf0", "1f1fd-1f1f0.png", ":kosovo:", ":flag_xk:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddfd", "1f1fd.png", ":regional_indicator_x:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddfe\ud83c\uddea", "1f1fe-1f1ea.png", ":yemen:", ":flag_ye:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddfe\ud83c\uddf9", "1f1fe-1f1f9.png", ":mayotte:", ":flag_yt:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddfe", "1f1fe.png", ":regional_indicator_y:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\uddff\ud83c\udde6", "1f1ff-1f1e6.png", ":south_africa:", ":flag_za:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddff\ud83c\uddf2", "1f1ff-1f1f2.png", ":zambia:", ":flag_zm:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddff\ud83c\uddfc", "1f1ff-1f1fc.png", ":zimbabwe:", ":flag_zw:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\uddff", "1f1ff.png", ":regional_indicator_z:", null, "Other", null);
        EmojiUtil.add(set, result, "\ud83c\ude01", "1f201.png", ":koko:", ":japanese_here_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\ude02", "1f202.png", ":sa:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\ude1a", "1f21a.png", ":u7121:", ":japanese_free_of_charge_button:", "Symbols", "");
        EmojiUtil.add(set, result, "\ud83c\ude2f", "1f22f.png", ":u6307:", ":japanese_reserved_button:", "Symbols", "");
        EmojiUtil.add(set, result, "\ud83c\ude32", "1f232.png", ":u7981:", ":japanese_prohibited_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\ude33", "1f233.png", ":u7a7a:", ":japanese_vacancy_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\ude34", "1f234.png", ":u5408:", ":japanese_passing_grade_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\ude35", "1f235.png", ":u6e80:", ":japanese_no_vacancy_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\ude36", "1f236.png", ":u6709:", ":japanese_not_free_of_charge_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\ude37", "1f237.png", ":u6708:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\ude38", "1f238.png", ":u7533:", ":japanese_application_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\ude39", "1f239.png", ":u5272:", ":japanese_discount_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\ude3a", "1f23a.png", ":u55b6:", ":japanese_open_for_business_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\ude50", "1f250.png", ":ideograph_advantage:", ":japanese_bargain_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\ude51", "1f251.png", ":accept:", ":japanese_acceptable_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf00", "1f300.png", ":cyclone:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf01", "1f301.png", ":foggy:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf02", "1f302.png", ":closed_umbrella:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf03", "1f303.png", ":night_with_stars:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf04", "1f304.png", ":sunrise_over_mountains:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf05", "1f305.png", ":sunrise:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf06", "1f306.png", ":city_sunset:", ":city_dusk:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf07", "1f307.png", ":city_sunrise:", ":sunset:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf08", "1f308.png", ":rainbow:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf09", "1f309.png", ":bridge_at_night:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf0a", "1f30a.png", ":ocean:", ":water_wave:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf0b", "1f30b.png", ":volcano:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf0c", "1f30c.png", ":milky_way:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf0d", "1f30d.png", ":earth_africa:", ":globe_showing_europe_africa:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf0e", "1f30e.png", ":earth_americas:", ":globe_showing_americas:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf0f", "1f30f.png", ":earth_asia:", ":globe_showing_asia_australia:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf10", "1f310.png", ":globe_with_meridians:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf11", "1f311.png", ":new_moon:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf12", "1f312.png", ":waxing_crescent_moon:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf13", "1f313.png", ":first_quarter_moon:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf14", "1f314.png", ":moon:", ":waxing_gibbous_moon:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf15", "1f315.png", ":full_moon:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf16", "1f316.png", ":waning_gibbous_moon:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf17", "1f317.png", ":last_quarter_moon:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf18", "1f318.png", ":waning_crescent_moon:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf19", "1f319.png", ":crescent_moon:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf1a", "1f31a.png", ":new_moon_with_face:", ":new_moon_face:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf1b", "1f31b.png", ":first_quarter_moon_with_face:", ":first_quarter_moon_face:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf1c", "1f31c.png", ":last_quarter_moon_with_face:", ":last_quarter_moon_face:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf1d", "1f31d.png", ":full_moon_with_face:", ":full_moon_face:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf1e", "1f31e.png", ":sun_with_face:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf1f", "1f31f.png", ":star2:", ":glowing_star:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf20", "1f320.png", ":stars:", ":shooting_star:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf21", "1f321.png", ":thermometer:", null, "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udf24", "1f324.png", ":sun_behind_small_cloud:", ":white_sun_small_cloud:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udf25", "1f325.png", ":sun_behind_large_cloud:", ":white_sun_cloud:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udf26", "1f326.png", ":sun_behind_rain_cloud:", ":white_sun_rain_cloud:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udf27", "1f327.png", ":cloud_with_rain:", ":cloud_rain:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udf28", "1f328.png", ":cloud_with_snow:", ":cloud_snow:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udf29", "1f329.png", ":cloud_with_lightning:", ":cloud_lightning:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udf2a", "1f32a.png", ":tornado:", ":cloud_tornado:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udf2b", "1f32b.png", ":fog:", null, "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udf2c", "1f32c.png", ":wind_face:", ":wind_blowing_face:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udf2d", "1f32d.png", ":hotdog:", ":hot_dog:", "Food & Drink", "8.0");
        EmojiUtil.add(set, result, "\ud83c\udf2e", "1f32e.png", ":taco:", null, "Food & Drink", "8.0");
        EmojiUtil.add(set, result, "\ud83c\udf2f", "1f32f.png", ":burrito:", null, "Food & Drink", "8.0");
        EmojiUtil.add(set, result, "\ud83c\udf30", "1f330.png", ":chestnut:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf31", "1f331.png", ":seedling:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf32", "1f332.png", ":evergreen_tree:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf33", "1f333.png", ":deciduous_tree:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf34", "1f334.png", ":palm_tree:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf35", "1f335.png", ":cactus:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf36", "1f336.png", ":hot_pepper:", null, "Food & Drink", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udf37", "1f337.png", ":tulip:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf38", "1f338.png", ":cherry_blossom:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf39", "1f339.png", ":rose:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf3a", "1f33a.png", ":hibiscus:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf3b", "1f33b.png", ":sunflower:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf3c", "1f33c.png", ":blossom:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf3d", "1f33d.png", ":corn:", ":ear_of_corn:", "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf3e", "1f33e.png", ":ear_of_rice:", ":sheaf_of_rice:", "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf3f", "1f33f.png", ":herb:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf40", "1f340.png", ":four_leaf_clover:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf41", "1f341.png", ":maple_leaf:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf42", "1f342.png", ":fallen_leaf:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf43", "1f343.png", ":leaves:", ":leaf_fluttering_in_wind:", "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf44", "1f344.png", ":mushroom:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf45", "1f345.png", ":tomato:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf46", "1f346.png", ":eggplant:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf47", "1f347.png", ":grapes:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf48", "1f348.png", ":melon:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf49", "1f349.png", ":watermelon:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf4a", "1f34a.png", ":tangerine:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf4b", "1f34b.png", ":lemon:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf4c", "1f34c.png", ":banana:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf4d", "1f34d.png", ":pineapple:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf4e", "1f34e.png", ":apple:", ":red_apple:", "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf4f", "1f34f.png", ":green_apple:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf50", "1f350.png", ":pear:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf51", "1f351.png", ":peach:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf52", "1f352.png", ":cherries:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf53", "1f353.png", ":strawberry:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf54", "1f354.png", ":hamburger:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf55", "1f355.png", ":pizza:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf56", "1f356.png", ":meat_on_bone:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf57", "1f357.png", ":poultry_leg:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf58", "1f358.png", ":rice_cracker:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf59", "1f359.png", ":rice_ball:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf5a", "1f35a.png", ":rice:", ":cooked_rice:", "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf5b", "1f35b.png", ":curry:", ":curry_rice:", "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf5c", "1f35c.png", ":ramen:", ":steaming_bowl:", "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf5d", "1f35d.png", ":spaghetti:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf5e", "1f35e.png", ":bread:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf5f", "1f35f.png", ":fries:", ":french_fries:", "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf60", "1f360.png", ":sweet_potato:", ":roasted_sweet_potato:", "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf61", "1f361.png", ":dango:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf62", "1f362.png", ":oden:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf63", "1f363.png", ":sushi:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf64", "1f364.png", ":fried_shrimp:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf65", "1f365.png", ":fish_cake:", ":fish_cake_with_swirl:", "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf66", "1f366.png", ":icecream:", ":soft_ice_cream:", "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf67", "1f367.png", ":shaved_ice:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf68", "1f368.png", ":ice_cream:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf69", "1f369.png", ":doughnut:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf6a", "1f36a.png", ":cookie:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf6b", "1f36b.png", ":chocolate_bar:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf6c", "1f36c.png", ":candy:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf6d", "1f36d.png", ":lollipop:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf6e", "1f36e.png", ":custard:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf6f", "1f36f.png", ":honey_pot:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf70", "1f370.png", ":cake:", ":shortcake:", "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf71", "1f371.png", ":bento:", ":bento_box:", "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf72", "1f372.png", ":stew:", ":pot_of_food:", "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf73", "1f373.png", ":fried_egg:", ":cooking:", "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf74", "1f374.png", ":fork_and_knife:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf75", "1f375.png", ":tea:", ":teacup_without_handle:", "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf76", "1f376.png", ":sake:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf77", "1f377.png", ":wine_glass:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf78", "1f378.png", ":cocktail:", ":cocktail_glass:", "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf79", "1f379.png", ":tropical_drink:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf7a", "1f37a.png", ":beer:", ":beer_mug:", "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf7b", "1f37b.png", ":beers:", ":clinking_beer_mugs:", "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf7c", "1f37c.png", ":baby_bottle:", null, "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf7d", "1f37d.png", ":plate_with_cutlery:", ":fork_knife_plate:", "Food & Drink", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udf7e", "1f37e.png", ":champagne:", ":bottle_with_popping_cork:", "Food & Drink", "8.0");
        EmojiUtil.add(set, result, "\ud83c\udf7f", "1f37f.png", ":popcorn:", null, "Food & Drink", "8.0");
        EmojiUtil.add(set, result, "\ud83c\udf80", "1f380.png", ":ribbon:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf81", "1f381.png", ":gift:", ":wrapped_gift:", "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf82", "1f382.png", ":birthday:", ":birthday_cake:", "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf83", "1f383.png", ":jack_o_lantern:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf84", "1f384.png", ":christmas_tree:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf85\ud83c\udffb", "1f385-1f3fb.png", ":santa_tone1:", ":santa_claus_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf85\ud83c\udffc", "1f385-1f3fc.png", ":santa_tone2:", ":santa_claus_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf85\ud83c\udffd", "1f385-1f3fd.png", ":santa_tone3:", ":santa_claus_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf85\ud83c\udffe", "1f385-1f3fe.png", ":santa_tone4:", ":santa_claus_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf85\ud83c\udfff", "1f385-1f3ff.png", ":santa_tone5:", ":santa_claus_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf85", "1f385.png", ":santa:", ":santa_claus:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf86", "1f386.png", ":fireworks:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf87", "1f387.png", ":sparkler:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf88", "1f388.png", ":balloon:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf89", "1f389.png", ":tada:", ":party_popper:", "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf8a", "1f38a.png", ":confetti_ball:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf8b", "1f38b.png", ":tanabata_tree:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf8c", "1f38c.png", ":crossed_flags:", null, "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf8d", "1f38d.png", ":bamboo:", ":pine_decoration:", "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf8e", "1f38e.png", ":dolls:", ":japanese_dolls:", "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf8f", "1f38f.png", ":flags:", ":carp_streamer:", "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf90", "1f390.png", ":wind_chime:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf91", "1f391.png", ":rice_scene:", ":moon_viewing_ceremony:", "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf92", "1f392.png", ":school_satchel:", ":backpack:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf93", "1f393.png", ":mortar_board:", ":graduation_cap:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udf96", "1f396.png", ":medal_military:", ":military_medal:", "Activities", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udf97", "1f397.png", ":reminder_ribbon:", null, "Activities", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udf99", "1f399.png", ":studio_microphone:", ":microphone2:", "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udf9a", "1f39a.png", ":level_slider:", null, "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udf9b", "1f39b.png", ":control_knobs:", null, "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udf9e", "1f39e.png", ":film_strip:", ":film_frames:", "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udf9f", "1f39f.png", ":tickets:", null, "Activities", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfa0", "1f3a0.png", ":carousel_horse:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfa1", "1f3a1.png", ":ferris_wheel:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfa2", "1f3a2.png", ":roller_coaster:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfa3", "1f3a3.png", ":fishing_pole_and_fish:", ":fishing_pole:", "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfa4", "1f3a4.png", ":microphone:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfa5", "1f3a5.png", ":movie_camera:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfa6", "1f3a6.png", ":cinema:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfa7", "1f3a7.png", ":headphones:", ":headphone:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfa8", "1f3a8.png", ":art:", ":artist_palette:", "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfa9", "1f3a9.png", ":tophat:", ":top_hat:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfaa", "1f3aa.png", ":circus_tent:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfab", "1f3ab.png", ":ticket:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfac", "1f3ac.png", ":clapper:", ":clapper_board:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfad", "1f3ad.png", ":performing_arts:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfae", "1f3ae.png", ":video_game:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfaf", "1f3af.png", ":dart:", ":bullseye:", "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfb0", "1f3b0.png", ":slot_machine:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfb1", "1f3b1.png", ":8ball:", ":pool_8_ball:", "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfb2", "1f3b2.png", ":game_die:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfb3", "1f3b3.png", ":bowling:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfb4", "1f3b4.png", ":flower_playing_cards:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfb5", "1f3b5.png", ":musical_note:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfb6", "1f3b6.png", ":notes:", ":musical_notes:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfb7", "1f3b7.png", ":saxophone:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfb8", "1f3b8.png", ":guitar:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfb9", "1f3b9.png", ":musical_keyboard:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfba", "1f3ba.png", ":trumpet:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfbb", "1f3bb.png", ":violin:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfbc", "1f3bc.png", ":musical_score:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfbd", "1f3bd.png", ":running_shirt_with_sash:", ":running_shirt:", "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfbe", "1f3be.png", ":tennis:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfbf", "1f3bf.png", ":ski:", ":skis:", "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc0", "1f3c0.png", ":basketball:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc1", "1f3c1.png", ":checkered_flag:", ":chequered_flag:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc2", "1f3c2.png", ":snowboarder:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc3\ud83c\udffb", "1f3c3-1f3fb.png", ":runner_tone1:", ":person_running_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc3\ud83c\udffc", "1f3c3-1f3fc.png", ":runner_tone2:", ":person_running_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc3\ud83c\udffd", "1f3c3-1f3fd.png", ":runner_tone3:", ":person_running_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc3\ud83c\udffe", "1f3c3-1f3fe.png", ":runner_tone4:", ":person_running_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc3\ud83c\udfff", "1f3c3-1f3ff.png", ":runner_tone5:", ":person_running_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc3", "1f3c3.png", ":runner:", ":person_running:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc4\ud83c\udffb", "1f3c4-1f3fb.png", ":surfer_tone1:", ":person_surfing_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc4\ud83c\udffc", "1f3c4-1f3fc.png", ":surfer_tone2:", ":person_surfing_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc4\ud83c\udffd", "1f3c4-1f3fd.png", ":surfer_tone3:", ":person_surfing_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc4\ud83c\udffe", "1f3c4-1f3fe.png", ":surfer_tone4:", ":person_surfing_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc4\ud83c\udfff", "1f3c4-1f3ff.png", ":surfer_tone5:", ":person_surfing_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc4", "1f3c4.png", ":surfer:", ":person_surfing:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc5", "1f3c5.png", ":medal_sports:", ":medal:", "Activities", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfc6", "1f3c6.png", ":trophy:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc7\ud83c\udffb", "1f3c7-1f3fb.png", ":horse_racing_tone1:", ":horse_racing_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc7\ud83c\udffc", "1f3c7-1f3fc.png", ":horse_racing_tone2:", ":horse_racing_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc7\ud83c\udffd", "1f3c7-1f3fd.png", ":horse_racing_tone3:", ":horse_racing_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc7\ud83c\udffe", "1f3c7-1f3fe.png", ":horse_racing_tone4:", ":horse_racing_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc7\ud83c\udfff", "1f3c7-1f3ff.png", ":horse_racing_tone5:", ":horse_racing_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc7", "1f3c7.png", ":horse_racing:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc8", "1f3c8.png", ":football:", ":american_football:", "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfc9", "1f3c9.png", ":rugby_football:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfca\ud83c\udffb", "1f3ca-1f3fb.png", ":swimmer_tone1:", ":person_swimming_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfca\ud83c\udffc", "1f3ca-1f3fc.png", ":swimmer_tone2:", ":person_swimming_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfca\ud83c\udffd", "1f3ca-1f3fd.png", ":swimmer_tone3:", ":person_swimming_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfca\ud83c\udffe", "1f3ca-1f3fe.png", ":swimmer_tone4:", ":person_swimming_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfca\ud83c\udfff", "1f3ca-1f3ff.png", ":swimmer_tone5:", ":person_swimming_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfca", "1f3ca.png", ":swimmer:", ":person_swimming:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfcb\ud83c\udffb", "1f3cb-1f3fb.png", ":weight_lifting_tone1:", ":person_lifting_weights_tone1:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcb\ud83c\udffc", "1f3cb-1f3fc.png", ":weight_lifting_tone2:", ":person_lifting_weights_tone2:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcb\ud83c\udffd", "1f3cb-1f3fd.png", ":weight_lifting_tone3:", ":person_lifting_weights_tone3:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcb\ud83c\udffe", "1f3cb-1f3fe.png", ":weight_lifting_tone4:", ":person_lifting_weights_tone4:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcb\ud83c\udfff", "1f3cb-1f3ff.png", ":weight_lifting_tone5:", ":person_lifting_weights_tone5:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcb", "1f3cb.png", ":weight_lifting:", ":person_lifting_weights:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcc", "1f3cc.png", ":golfing:", ":person_golfing:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcd", "1f3cd.png", ":motorcycle:", null, "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfce", "1f3ce.png", ":racing_car:", ":race_car:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfcf", "1f3cf.png", ":cricket_game:", null, "Activities", "8.0");
        EmojiUtil.add(set, result, "\ud83c\udfd0", "1f3d0.png", ":volleyball:", null, "Activities", "8.0");
        EmojiUtil.add(set, result, "\ud83c\udfd1", "1f3d1.png", ":field_hockey:", null, "Activities", "8.0");
        EmojiUtil.add(set, result, "\ud83c\udfd2", "1f3d2.png", ":ice_hockey:", ":hockey:", "Activities", "8.0");
        EmojiUtil.add(set, result, "\ud83c\udfd3", "1f3d3.png", ":ping_pong:", null, "Activities", "8.0");
        EmojiUtil.add(set, result, "\ud83c\udfd4", "1f3d4.png", ":mountain_snow:", null, "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfd5", "1f3d5.png", ":camping:", null, "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfd6", "1f3d6.png", ":beach_umbrella:", ":beach:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfd7", "1f3d7.png", ":building_construction:", ":construction_site:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfd8", "1f3d8.png", ":houses:", ":homes:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfd9", "1f3d9.png", ":cityscape:", null, "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfda", "1f3da.png", ":derelict_house:", ":house_abandoned:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfdb", "1f3db.png", ":classical_building:", null, "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfdc", "1f3dc.png", ":desert:", null, "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfdd", "1f3dd.png", ":desert_island:", ":island:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfde", "1f3de.png", ":national_park:", ":park:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfdf", "1f3df.png", ":stadium:", null, "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udfe0", "1f3e0.png", ":house:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfe1", "1f3e1.png", ":house_with_garden:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfe2", "1f3e2.png", ":office:", ":office_building:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfe3", "1f3e3.png", ":post_office:", ":japanese_post_office:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfe4", "1f3e4.png", ":european_post_office:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfe5", "1f3e5.png", ":hospital:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfe6", "1f3e6.png", ":bank:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfe7", "1f3e7.png", ":atm:", ":atm_sign:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfe8", "1f3e8.png", ":hotel:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfe9", "1f3e9.png", ":love_hotel:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfea", "1f3ea.png", ":convenience_store:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfeb", "1f3eb.png", ":school:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfec", "1f3ec.png", ":department_store:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfed", "1f3ed.png", ":factory:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfee", "1f3ee.png", ":izakaya_lantern:", ":red_paper_lantern:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udfef", "1f3ef.png", ":japanese_castle:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udff0", "1f3f0.png", ":european_castle:", ":castle:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83c\udff3\ud83c\udf08", "1f3f3-1f308.png", null, null, null, null);
        EmojiUtil.add(set, result, "\ud83c\udff3", "1f3f3.png", ":white_flag:", ":flag_white:", "Flags", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udff4", "1f3f4.png", ":black_flag:", ":flag_black:", "Flags", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udff5", "1f3f5.png", ":rosette:", null, "Animals & Nature", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udff7", "1f3f7.png", ":label:", null, "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83c\udff8", "1f3f8.png", ":badminton:", null, "Activities", "8.0");
        EmojiUtil.add(set, result, "\ud83c\udff9", "1f3f9.png", ":bow_and_arrow:", null, "Objects", "8.0");
        EmojiUtil.add(set, result, "\ud83c\udffa", "1f3fa.png", ":amphora:", null, "Food & Drink", "8.0");
        EmojiUtil.add(set, result, "\ud83c\udffb", "1f3fb.png", ":tone1:", ":light_skin_tone:", "Other", null);
        EmojiUtil.add(set, result, "\ud83c\udffc", "1f3fc.png", ":tone2:", ":medium_light_skin_tone:", "Other", null);
        EmojiUtil.add(set, result, "\ud83c\udffd", "1f3fd.png", ":tone3:", ":medium_skin_tone:", "Other", null);
        EmojiUtil.add(set, result, "\ud83c\udffe", "1f3fe.png", ":tone4:", ":medium_dark_skin_tone:", "Other", null);
        EmojiUtil.add(set, result, "\ud83c\udfff", "1f3ff.png", ":tone5:", ":dark_skin_tone:", "Other", null);
        EmojiUtil.add(set, result, "\ud83d\udc00", "1f400.png", ":rat:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc01", "1f401.png", ":mouse2:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc02", "1f402.png", ":ox:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc03", "1f403.png", ":water_buffalo:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc04", "1f404.png", ":cow2:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc05", "1f405.png", ":tiger2:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc06", "1f406.png", ":leopard:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc07", "1f407.png", ":rabbit2:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc08", "1f408.png", ":cat2:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc09", "1f409.png", ":dragon:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc0a", "1f40a.png", ":crocodile:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc0b", "1f40b.png", ":whale2:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc0c", "1f40c.png", ":snail:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc0d", "1f40d.png", ":snake:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc0e", "1f40e.png", ":racehorse:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc0f", "1f40f.png", ":ram:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc10", "1f410.png", ":goat:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc11", "1f411.png", ":sheep:", ":ewe:", "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc12", "1f412.png", ":monkey:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc13", "1f413.png", ":rooster:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc14", "1f414.png", ":chicken:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc15", "1f415.png", ":dog2:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc16", "1f416.png", ":pig2:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc17", "1f417.png", ":boar:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc18", "1f418.png", ":elephant:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc19", "1f419.png", ":octopus:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc1a", "1f41a.png", ":shell:", ":spiral_shell:", "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc1b", "1f41b.png", ":bug:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc1c", "1f41c.png", ":ant:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc1d", "1f41d.png", ":bee:", ":honeybee:", "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc1e", "1f41e.png", ":lady_beetle:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc1f", "1f41f.png", ":fish:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc20", "1f420.png", ":tropical_fish:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc21", "1f421.png", ":blowfish:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc22", "1f422.png", ":turtle:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc23", "1f423.png", ":hatching_chick:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc24", "1f424.png", ":baby_chick:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc25", "1f425.png", ":hatched_chick:", ":front_facing_baby_chick:", "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc26", "1f426.png", ":bird:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc27", "1f427.png", ":penguin:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc28", "1f428.png", ":koala:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc29", "1f429.png", ":poodle:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc2a", "1f42a.png", ":dromedary_camel:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc2b", "1f42b.png", ":camel:", ":two_hump_camel:", "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc2c", "1f42c.png", ":dolphin:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc2d", "1f42d.png", ":mouse:", ":mouse_face:", "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc2e", "1f42e.png", ":cow:", ":cow_face:", "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc2f", "1f42f.png", ":tiger:", ":tiger_face:", "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc30", "1f430.png", ":rabbit:", ":rabbit_face:", "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc31", "1f431.png", ":cat:", ":cat_face:", "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc32", "1f432.png", ":dragon_face:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc33", "1f433.png", ":whale:", ":spouting_whale:", "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc34", "1f434.png", ":horse:", ":horse_face:", "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc35", "1f435.png", ":monkey_face:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc36", "1f436.png", ":dog:", ":dog_face:", "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc37", "1f437.png", ":pig:", ":pig_face:", "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc38", "1f438.png", ":frog:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc39", "1f439.png", ":hamster:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc3a", "1f43a.png", ":wolf:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc3b", "1f43b.png", ":bear:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc3c", "1f43c.png", ":panda_face:", ":panda:", "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc3d", "1f43d.png", ":pig_nose:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc3e", "1f43e.png", ":feet:", ":paw_prints:", "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc3f", "1f43f.png", ":chipmunk:", null, "Animals & Nature", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udc40", "1f440.png", ":eyes:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc41\ud83d\udde8", "1f441-1f5e8.png", ":eye_in_speech_bubble:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc41", "1f441.png", ":eye:", null, "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udc42\ud83c\udffb", "1f442-1f3fb.png", ":ear_tone1:", ":ear_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc42\ud83c\udffc", "1f442-1f3fc.png", ":ear_tone2:", ":ear_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc42\ud83c\udffd", "1f442-1f3fd.png", ":ear_tone3:", ":ear_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc42\ud83c\udffe", "1f442-1f3fe.png", ":ear_tone4:", ":ear_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc42\ud83c\udfff", "1f442-1f3ff.png", ":ear_tone5:", ":ear_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc42", "1f442.png", ":ear:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc43\ud83c\udffb", "1f443-1f3fb.png", ":nose_tone1:", ":nose_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc43\ud83c\udffc", "1f443-1f3fc.png", ":nose_tone2:", ":nose_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc43\ud83c\udffd", "1f443-1f3fd.png", ":nose_tone3:", ":nose_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc43\ud83c\udffe", "1f443-1f3fe.png", ":nose_tone4:", ":nose_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc43\ud83c\udfff", "1f443-1f3ff.png", ":nose_tone5:", ":nose_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc43", "1f443.png", ":nose:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc44", "1f444.png", ":lips:", ":mouth:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc45", "1f445.png", ":tongue:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc46\ud83c\udffb", "1f446-1f3fb.png", ":point_up_2_tone1:", ":backhand_index_pointing_up_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc46\ud83c\udffc", "1f446-1f3fc.png", ":point_up_2_tone2:", ":backhand_index_pointing_up_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc46\ud83c\udffd", "1f446-1f3fd.png", ":point_up_2_tone3:", ":backhand_index_pointing_up_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc46\ud83c\udffe", "1f446-1f3fe.png", ":point_up_2_tone4:", ":backhand_index_pointing_up_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc46\ud83c\udfff", "1f446-1f3ff.png", ":point_up_2_tone5:", ":backhand_index_pointing_up_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc46", "1f446.png", ":point_up_2:", ":backhand_index_pointing_up:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc47\ud83c\udffb", "1f447-1f3fb.png", ":point_down_tone1:", ":backhand_index_pointing_down_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc47\ud83c\udffc", "1f447-1f3fc.png", ":point_down_tone2:", ":backhand_index_pointing_down_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc47\ud83c\udffd", "1f447-1f3fd.png", ":point_down_tone3:", ":backhand_index_pointing_down_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc47\ud83c\udffe", "1f447-1f3fe.png", ":point_down_tone4:", ":backhand_index_pointing_down_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc47\ud83c\udfff", "1f447-1f3ff.png", ":point_down_tone5:", ":backhand_index_pointing_down_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc47", "1f447.png", ":point_down:", ":backhand_index_pointing_down:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc48\ud83c\udffb", "1f448-1f3fb.png", ":point_left_tone1:", ":backhand_index_pointing_left_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc48\ud83c\udffc", "1f448-1f3fc.png", ":point_left_tone2:", ":backhand_index_pointing_left_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc48\ud83c\udffd", "1f448-1f3fd.png", ":point_left_tone3:", ":backhand_index_pointing_left_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc48\ud83c\udffe", "1f448-1f3fe.png", ":point_left_tone4:", ":backhand_index_pointing_left_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc48\ud83c\udfff", "1f448-1f3ff.png", ":point_left_tone5:", ":backhand_index_pointing_left_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc48", "1f448.png", ":point_left:", ":backhand_index_pointing_left:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc49\ud83c\udffb", "1f449-1f3fb.png", ":point_right_tone1:", ":backhand_index_pointing_right_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc49\ud83c\udffc", "1f449-1f3fc.png", ":point_right_tone2:", ":backhand_index_pointing_right_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc49\ud83c\udffd", "1f449-1f3fd.png", ":point_right_tone3:", ":backhand_index_pointing_right_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc49\ud83c\udffe", "1f449-1f3fe.png", ":point_right_tone4:", ":backhand_index_pointing_right_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc49\ud83c\udfff", "1f449-1f3ff.png", ":point_right_tone5:", ":backhand_index_pointing_right_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc49", "1f449.png", ":point_right:", ":backhand_index_pointing_right:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4a\ud83c\udffb", "1f44a-1f3fb.png", ":fist_oncoming_tone1:", ":punch_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4a\ud83c\udffc", "1f44a-1f3fc.png", ":fist_oncoming_tone2:", ":punch_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4a\ud83c\udffd", "1f44a-1f3fd.png", ":fist_oncoming_tone3:", ":punch_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4a\ud83c\udffe", "1f44a-1f3fe.png", ":fist_oncoming_tone4:", ":punch_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4a\ud83c\udfff", "1f44a-1f3ff.png", ":fist_oncoming_tone5:", ":punch_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4a", "1f44a.png", ":fist_oncoming:", ":punch:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4b\ud83c\udffb", "1f44b-1f3fb.png", ":wave_tone1:", ":waving_hand_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4b\ud83c\udffc", "1f44b-1f3fc.png", ":wave_tone2:", ":waving_hand_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4b\ud83c\udffd", "1f44b-1f3fd.png", ":wave_tone3:", ":waving_hand_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4b\ud83c\udffe", "1f44b-1f3fe.png", ":wave_tone4:", ":waving_hand_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4b\ud83c\udfff", "1f44b-1f3ff.png", ":wave_tone5:", ":waving_hand_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4b", "1f44b.png", ":wave:", ":waving_hand:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4c\ud83c\udffb", "1f44c-1f3fb.png", ":ok_hand_tone1:", ":ok_hand_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4c\ud83c\udffc", "1f44c-1f3fc.png", ":ok_hand_tone2:", ":ok_hand_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4c\ud83c\udffd", "1f44c-1f3fd.png", ":ok_hand_tone3:", ":ok_hand_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4c\ud83c\udffe", "1f44c-1f3fe.png", ":ok_hand_tone4:", ":ok_hand_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4c\ud83c\udfff", "1f44c-1f3ff.png", ":ok_hand_tone5:", ":ok_hand_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4c", "1f44c.png", ":ok_hand:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4d\ud83c\udffb", "1f44d-1f3fb.png", ":+1_tone1:", ":thumbsup_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4d\ud83c\udffc", "1f44d-1f3fc.png", ":+1_tone2:", ":thumbsup_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4d\ud83c\udffd", "1f44d-1f3fd.png", ":+1_tone3:", ":thumbsup_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4d\ud83c\udffe", "1f44d-1f3fe.png", ":+1_tone4:", ":thumbsup_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4d\ud83c\udfff", "1f44d-1f3ff.png", ":+1_tone5:", ":thumbsup_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4d", "1f44d.png", ":+1:", ":thumbsup:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4e\ud83c\udffb", "1f44e-1f3fb.png", ":-1_tone1:", ":thumbsdown_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4e\ud83c\udffc", "1f44e-1f3fc.png", ":-1_tone2:", ":thumbsdown_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4e\ud83c\udffd", "1f44e-1f3fd.png", ":-1_tone3:", ":thumbsdown_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4e\ud83c\udffe", "1f44e-1f3fe.png", ":-1_tone4:", ":thumbsdown_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4e\ud83c\udfff", "1f44e-1f3ff.png", ":-1_tone5:", ":thumbsdown_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4e", "1f44e.png", ":-1:", ":thumbsdown:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4f\ud83c\udffb", "1f44f-1f3fb.png", ":clap_tone1:", ":clapping_hands_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4f\ud83c\udffc", "1f44f-1f3fc.png", ":clap_tone2:", ":clapping_hands_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4f\ud83c\udffd", "1f44f-1f3fd.png", ":clap_tone3:", ":clapping_hands_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4f\ud83c\udffe", "1f44f-1f3fe.png", ":clap_tone4:", ":clapping_hands_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4f\ud83c\udfff", "1f44f-1f3ff.png", ":clap_tone5:", ":clapping_hands_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc4f", "1f44f.png", ":clap:", ":clapping_hands:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc50\ud83c\udffb", "1f450-1f3fb.png", ":open_hands_tone1:", ":open_hands_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc50\ud83c\udffc", "1f450-1f3fc.png", ":open_hands_tone2:", ":open_hands_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc50\ud83c\udffd", "1f450-1f3fd.png", ":open_hands_tone3:", ":open_hands_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc50\ud83c\udffe", "1f450-1f3fe.png", ":open_hands_tone4:", ":open_hands_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc50\ud83c\udfff", "1f450-1f3ff.png", ":open_hands_tone5:", ":open_hands_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc50", "1f450.png", ":open_hands:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc51", "1f451.png", ":crown:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc52", "1f452.png", ":womans_hat:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc53", "1f453.png", ":eyeglasses:", ":glasses:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc54", "1f454.png", ":necktie:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc55", "1f455.png", ":shirt:", ":t_shirt:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc56", "1f456.png", ":jeans:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc57", "1f457.png", ":dress:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc58", "1f458.png", ":kimono:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc59", "1f459.png", ":bikini:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc5a", "1f45a.png", ":womans_clothes:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc5b", "1f45b.png", ":purse:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc5c", "1f45c.png", ":handbag:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc5d", "1f45d.png", ":pouch:", ":clutch_bag:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc5e", "1f45e.png", ":mans_shoe:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc5f", "1f45f.png", ":athletic_shoe:", ":running_shoe:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc60", "1f460.png", ":high_heel:", ":high_heeled_shoe:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc61", "1f461.png", ":sandal:", ":womans_sandal:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc62", "1f462.png", ":boot:", ":womans_boot:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc63", "1f463.png", ":footprints:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc64", "1f464.png", ":bust_in_silhouette:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc65", "1f465.png", ":busts_in_silhouette:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc66\ud83c\udffb", "1f466-1f3fb.png", ":boy_tone1:", ":boy_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc66\ud83c\udffc", "1f466-1f3fc.png", ":boy_tone2:", ":boy_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc66\ud83c\udffd", "1f466-1f3fd.png", ":boy_tone3:", ":boy_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc66\ud83c\udffe", "1f466-1f3fe.png", ":boy_tone4:", ":boy_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc66\ud83c\udfff", "1f466-1f3ff.png", ":boy_tone5:", ":boy_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc66", "1f466.png", ":boy:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc67\ud83c\udffb", "1f467-1f3fb.png", ":girl_tone1:", ":girl_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc67\ud83c\udffc", "1f467-1f3fc.png", ":girl_tone2:", ":girl_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc67\ud83c\udffd", "1f467-1f3fd.png", ":girl_tone3:", ":girl_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc67\ud83c\udffe", "1f467-1f3fe.png", ":girl_tone4:", ":girl_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc67\ud83c\udfff", "1f467-1f3ff.png", ":girl_tone5:", ":girl_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc67", "1f467.png", ":girl:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffb", "1f468-1f3fb.png", ":man_tone1:", ":man_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffc", "1f468-1f3fc.png", ":man_tone2:", ":man_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffd", "1f468-1f3fd.png", ":man_tone3:", ":man_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udffe", "1f468-1f3fe.png", ":man_tone4:", ":man_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83c\udfff", "1f468-1f3ff.png", ":man_tone5:", ":man_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83d\udc68\ud83d\udc66\ud83d\udc66", "1f468-1f468-1f466-1f466.png", ":family_mmbb:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83d\udc68\ud83d\udc66", "1f468-1f468-1f466.png", ":family_mmb:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83d\udc68\ud83d\udc67\ud83d\udc66", "1f468-1f468-1f467-1f466.png", ":family_mmgb:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83d\udc68\ud83d\udc67\ud83d\udc67", "1f468-1f468-1f467-1f467.png", ":family_mmgg:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83d\udc68\ud83d\udc67", "1f468-1f468-1f467.png", ":family_mmg:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83d\udc69\ud83d\udc66\ud83d\udc66", "1f468-1f469-1f466-1f466.png", ":family_mwbb:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83d\udc69\ud83d\udc67\ud83d\udc66", "1f468-1f469-1f467-1f466.png", ":family_mwgb:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83d\udc69\ud83d\udc67\ud83d\udc67", "1f468-1f469-1f467-1f467.png", ":family_mwgg:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\ud83d\udc69\ud83d\udc67", "1f468-1f469-1f467.png", ":family_mwg:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\u2764\ud83d\udc68", "1f468-2764-1f468.png", ":couple_mm:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68\u2764\ud83d\udc8b\ud83d\udc68", "1f468-2764-1f48b-1f468.png", ":kiss_mm:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc68", "1f468.png", ":man:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffb", "1f469-1f3fb.png", ":woman_tone1:", ":woman_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffc", "1f469-1f3fc.png", ":woman_tone2:", ":woman_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffd", "1f469-1f3fd.png", ":woman_tone3:", ":woman_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udffe", "1f469-1f3fe.png", ":woman_tone4:", ":woman_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83c\udfff", "1f469-1f3ff.png", ":woman_tone5:", ":woman_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83d\udc69\ud83d\udc66\ud83d\udc66", "1f469-1f469-1f466-1f466.png", ":family_wwbb:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83d\udc69\ud83d\udc66", "1f469-1f469-1f466.png", ":family_wwb:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83d\udc69\ud83d\udc67\ud83d\udc66", "1f469-1f469-1f467-1f466.png", ":family_wwgb:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83d\udc69\ud83d\udc67\ud83d\udc67", "1f469-1f469-1f467-1f467.png", ":family_wwgg:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\ud83d\udc69\ud83d\udc67", "1f469-1f469-1f467.png", ":family_wwg:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\u2764\ud83d\udc69", "1f469-2764-1f469.png", ":couple_ww:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69\u2764\ud83d\udc8b\ud83d\udc69", "1f469-2764-1f48b-1f469.png", ":kiss_ww:", null, null, null);
        EmojiUtil.add(set, result, "\ud83d\udc69", "1f469.png", ":woman:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6a", "1f46a.png", ":family:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6b", "1f46b.png", ":couple:", ":woman_and_man_holding_hands:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6c", "1f46c.png", ":two_men_holding_hands:", ":men_holding_hands:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6d", "1f46d.png", ":two_women_holding_hands:", ":women_holding_hands:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6e\ud83c\udffb", "1f46e-1f3fb.png", ":police_officer_tone1:", ":police_officer_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6e\ud83c\udffc", "1f46e-1f3fc.png", ":police_officer_tone2:", ":police_officer_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6e\ud83c\udffd", "1f46e-1f3fd.png", ":police_officer_tone3:", ":police_officer_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6e\ud83c\udffe", "1f46e-1f3fe.png", ":police_officer_tone4:", ":police_officer_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6e\ud83c\udfff", "1f46e-1f3ff.png", ":police_officer_tone5:", ":police_officer_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6e", "1f46e.png", ":police_officer:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc6f", "1f46f.png", ":dancers:", ":people_with_bunny_ears_partying:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc70\ud83c\udffb", "1f470-1f3fb.png", ":person_with_veil_tone1:", ":bride_with_veil_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc70\ud83c\udffc", "1f470-1f3fc.png", ":person_with_veil_tone2:", ":bride_with_veil_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc70\ud83c\udffd", "1f470-1f3fd.png", ":person_with_veil_tone3:", ":bride_with_veil_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc70\ud83c\udffe", "1f470-1f3fe.png", ":person_with_veil_tone4:", ":bride_with_veil_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc70\ud83c\udfff", "1f470-1f3ff.png", ":person_with_veil_tone5:", ":bride_with_veil_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc70", "1f470.png", ":person_with_veil:", ":bride_with_veil:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc71\ud83c\udffb", "1f471-1f3fb.png", ":blond_haired_person_tone1:", ":person_light_skin_tone_blond_hair:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc71\ud83c\udffc", "1f471-1f3fc.png", ":blond_haired_person_tone2:", ":person_medium_light_skin_tone_blond_hair:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc71\ud83c\udffd", "1f471-1f3fd.png", ":blond_haired_person_tone3:", ":person_medium_skin_tone_blond_hair:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc71\ud83c\udffe", "1f471-1f3fe.png", ":blond_haired_person_tone4:", ":person_medium_dark_skin_tone_blond_hair:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc71\ud83c\udfff", "1f471-1f3ff.png", ":blond_haired_person_tone5:", ":person_dark_skin_tone_blond_hair:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc71", "1f471.png", ":blond_haired_person:", ":person_blond_hair:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc72\ud83c\udffb", "1f472-1f3fb.png", ":man_with_gua_pi_mao_tone1:", ":man_with_chinese_cap_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc72\ud83c\udffc", "1f472-1f3fc.png", ":man_with_gua_pi_mao_tone2:", ":man_with_chinese_cap_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc72\ud83c\udffd", "1f472-1f3fd.png", ":man_with_gua_pi_mao_tone3:", ":man_with_chinese_cap_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc72\ud83c\udffe", "1f472-1f3fe.png", ":man_with_gua_pi_mao_tone4:", ":man_with_chinese_cap_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc72\ud83c\udfff", "1f472-1f3ff.png", ":man_with_gua_pi_mao_tone5:", ":man_with_chinese_cap_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc72", "1f472.png", ":man_with_gua_pi_mao:", ":man_with_chinese_cap:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc73\ud83c\udffb", "1f473-1f3fb.png", ":person_with_turban_tone1:", ":person_wearing_turban_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc73\ud83c\udffc", "1f473-1f3fc.png", ":person_with_turban_tone2:", ":person_wearing_turban_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc73\ud83c\udffd", "1f473-1f3fd.png", ":person_with_turban_tone3:", ":person_wearing_turban_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc73\ud83c\udffe", "1f473-1f3fe.png", ":person_with_turban_tone4:", ":person_wearing_turban_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc73\ud83c\udfff", "1f473-1f3ff.png", ":person_with_turban_tone5:", ":person_wearing_turban_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc73", "1f473.png", ":person_with_turban:", ":person_wearing_turban:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc74\ud83c\udffb", "1f474-1f3fb.png", ":older_man_tone1:", ":old_man_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc74\ud83c\udffc", "1f474-1f3fc.png", ":older_man_tone2:", ":old_man_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc74\ud83c\udffd", "1f474-1f3fd.png", ":older_man_tone3:", ":old_man_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc74\ud83c\udffe", "1f474-1f3fe.png", ":older_man_tone4:", ":old_man_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc74\ud83c\udfff", "1f474-1f3ff.png", ":older_man_tone5:", ":old_man_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc74", "1f474.png", ":older_man:", ":old_man:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc75\ud83c\udffb", "1f475-1f3fb.png", ":older_woman_tone1:", ":old_woman_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc75\ud83c\udffc", "1f475-1f3fc.png", ":older_woman_tone2:", ":old_woman_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc75\ud83c\udffd", "1f475-1f3fd.png", ":older_woman_tone3:", ":old_woman_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc75\ud83c\udffe", "1f475-1f3fe.png", ":older_woman_tone4:", ":old_woman_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc75\ud83c\udfff", "1f475-1f3ff.png", ":older_woman_tone5:", ":old_woman_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc75", "1f475.png", ":older_woman:", ":old_woman:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc76\ud83c\udffb", "1f476-1f3fb.png", ":baby_tone1:", ":baby_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc76\ud83c\udffc", "1f476-1f3fc.png", ":baby_tone2:", ":baby_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc76\ud83c\udffd", "1f476-1f3fd.png", ":baby_tone3:", ":baby_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc76\ud83c\udffe", "1f476-1f3fe.png", ":baby_tone4:", ":baby_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc76\ud83c\udfff", "1f476-1f3ff.png", ":baby_tone5:", ":baby_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc76", "1f476.png", ":baby:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc77\ud83c\udffb", "1f477-1f3fb.png", ":construction_worker_tone1:", ":construction_worker_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc77\ud83c\udffc", "1f477-1f3fc.png", ":construction_worker_tone2:", ":construction_worker_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc77\ud83c\udffd", "1f477-1f3fd.png", ":construction_worker_tone3:", ":construction_worker_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc77\ud83c\udffe", "1f477-1f3fe.png", ":construction_worker_tone4:", ":construction_worker_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc77\ud83c\udfff", "1f477-1f3ff.png", ":construction_worker_tone5:", ":construction_worker_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc77", "1f477.png", ":construction_worker:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc78\ud83c\udffb", "1f478-1f3fb.png", ":princess_tone1:", ":princess_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc78\ud83c\udffc", "1f478-1f3fc.png", ":princess_tone2:", ":princess_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc78\ud83c\udffd", "1f478-1f3fd.png", ":princess_tone3:", ":princess_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc78\ud83c\udffe", "1f478-1f3fe.png", ":princess_tone4:", ":princess_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc78\ud83c\udfff", "1f478-1f3ff.png", ":princess_tone5:", ":princess_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc78", "1f478.png", ":princess:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc79", "1f479.png", ":japanese_ogre:", ":ogre:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc7a", "1f47a.png", ":japanese_goblin:", ":goblin:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc7b", "1f47b.png", ":ghost:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc7c\ud83c\udffb", "1f47c-1f3fb.png", ":angel_tone1:", ":baby_angel_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc7c\ud83c\udffc", "1f47c-1f3fc.png", ":angel_tone2:", ":baby_angel_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc7c\ud83c\udffd", "1f47c-1f3fd.png", ":angel_tone3:", ":baby_angel_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc7c\ud83c\udffe", "1f47c-1f3fe.png", ":angel_tone4:", ":baby_angel_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc7c\ud83c\udfff", "1f47c-1f3ff.png", ":angel_tone5:", ":baby_angel_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc7c", "1f47c.png", ":angel:", ":baby_angel:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc7d", "1f47d.png", ":alien:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc7e", "1f47e.png", ":space_invader:", ":alien_monster:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc7f", "1f47f.png", ":imp:", ":angry_face_with_horns:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc80", "1f480.png", ":skull:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc81\ud83c\udffb", "1f481-1f3fb.png", ":tipping_hand_person_tone1:", ":person_tipping_hand_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc81\ud83c\udffc", "1f481-1f3fc.png", ":tipping_hand_person_tone2:", ":person_tipping_hand_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc81\ud83c\udffd", "1f481-1f3fd.png", ":tipping_hand_person_tone3:", ":person_tipping_hand_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc81\ud83c\udffe", "1f481-1f3fe.png", ":tipping_hand_person_tone4:", ":person_tipping_hand_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc81\ud83c\udfff", "1f481-1f3ff.png", ":tipping_hand_person_tone5:", ":person_tipping_hand_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc81", "1f481.png", ":tipping_hand_person:", ":person_tipping_hand:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc82\ud83c\udffb", "1f482-1f3fb.png", ":guard_tone1:", ":guard_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc82\ud83c\udffc", "1f482-1f3fc.png", ":guard_tone2:", ":guard_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc82\ud83c\udffd", "1f482-1f3fd.png", ":guard_tone3:", ":guard_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc82\ud83c\udffe", "1f482-1f3fe.png", ":guard_tone4:", ":guard_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc82\ud83c\udfff", "1f482-1f3ff.png", ":guard_tone5:", ":guard_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc82", "1f482.png", ":guard:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc83\ud83c\udffb", "1f483-1f3fb.png", ":woman_dancing_tone1:", ":dancer_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc83\ud83c\udffc", "1f483-1f3fc.png", ":woman_dancing_tone2:", ":dancer_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc83\ud83c\udffd", "1f483-1f3fd.png", ":woman_dancing_tone3:", ":dancer_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc83\ud83c\udffe", "1f483-1f3fe.png", ":woman_dancing_tone4:", ":dancer_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc83\ud83c\udfff", "1f483-1f3ff.png", ":woman_dancing_tone5:", ":dancer_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc83", "1f483.png", ":woman_dancing:", ":dancer:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc84", "1f484.png", ":lipstick:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc85\ud83c\udffb", "1f485-1f3fb.png", ":nail_care_tone1:", ":nail_polish_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc85\ud83c\udffc", "1f485-1f3fc.png", ":nail_care_tone2:", ":nail_polish_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc85\ud83c\udffd", "1f485-1f3fd.png", ":nail_care_tone3:", ":nail_polish_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc85\ud83c\udffe", "1f485-1f3fe.png", ":nail_care_tone4:", ":nail_polish_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc85\ud83c\udfff", "1f485-1f3ff.png", ":nail_care_tone5:", ":nail_polish_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc85", "1f485.png", ":nail_care:", ":nail_polish:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc86\ud83c\udffb", "1f486-1f3fb.png", ":massage_tone1:", ":person_getting_massage_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc86\ud83c\udffc", "1f486-1f3fc.png", ":massage_tone2:", ":person_getting_massage_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc86\ud83c\udffd", "1f486-1f3fd.png", ":massage_tone3:", ":person_getting_massage_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc86\ud83c\udffe", "1f486-1f3fe.png", ":massage_tone4:", ":person_getting_massage_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc86\ud83c\udfff", "1f486-1f3ff.png", ":massage_tone5:", ":person_getting_massage_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc86", "1f486.png", ":massage:", ":person_getting_massage:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc87\ud83c\udffb", "1f487-1f3fb.png", ":haircut_tone1:", ":person_getting_haircut_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc87\ud83c\udffc", "1f487-1f3fc.png", ":haircut_tone2:", ":person_getting_haircut_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc87\ud83c\udffd", "1f487-1f3fd.png", ":haircut_tone3:", ":person_getting_haircut_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc87\ud83c\udffe", "1f487-1f3fe.png", ":haircut_tone4:", ":person_getting_haircut_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc87\ud83c\udfff", "1f487-1f3ff.png", ":haircut_tone5:", ":person_getting_haircut_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc87", "1f487.png", ":haircut:", ":person_getting_haircut:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc88", "1f488.png", ":barber:", ":barber_pole:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc89", "1f489.png", ":syringe:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc8a", "1f48a.png", ":pill:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc8b", "1f48b.png", ":kiss:", ":kiss_mark:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc8c", "1f48c.png", ":love_letter:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc8d", "1f48d.png", ":ring:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc8e", "1f48e.png", ":gem:", ":gem_stone:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc8f", "1f48f.png", ":couplekiss:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc90", "1f490.png", ":bouquet:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc91", "1f491.png", ":couple_with_heart:", null, "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc92", "1f492.png", ":wedding:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc93", "1f493.png", ":heartbeat:", ":beating_heart:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc94", "1f494.png", ":broken_heart:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc95", "1f495.png", ":two_hearts:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc96", "1f496.png", ":sparkling_heart:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc97", "1f497.png", ":heartpulse:", ":growing_heart:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc98", "1f498.png", ":cupid:", ":heart_with_arrow:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc99", "1f499.png", ":blue_heart:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc9a", "1f49a.png", ":green_heart:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc9b", "1f49b.png", ":yellow_heart:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc9c", "1f49c.png", ":purple_heart:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc9d", "1f49d.png", ":gift_heart:", ":heart_with_ribbon:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc9e", "1f49e.png", ":revolving_hearts:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udc9f", "1f49f.png", ":heart_decoration:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udca0", "1f4a0.png", ":diamond_shape_with_a_dot_inside:", ":diamond_with_a_dot:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udca1", "1f4a1.png", ":bulb:", ":light_bulb:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udca2", "1f4a2.png", ":anger:", ":anger_symbol:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udca3", "1f4a3.png", ":bomb:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udca4", "1f4a4.png", ":zzz:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udca5", "1f4a5.png", ":boom:", ":collision:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udca6", "1f4a6.png", ":sweat_drops:", ":sweat_droplets:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udca7", "1f4a7.png", ":droplet:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udca8", "1f4a8.png", ":dash:", ":dashing_away:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udca9", "1f4a9.png", ":hankey:", ":poop:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcaa\ud83c\udffb", "1f4aa-1f3fb.png", ":muscle_tone1:", ":flexed_biceps_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcaa\ud83c\udffc", "1f4aa-1f3fc.png", ":muscle_tone2:", ":flexed_biceps_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcaa\ud83c\udffd", "1f4aa-1f3fd.png", ":muscle_tone3:", ":flexed_biceps_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcaa\ud83c\udffe", "1f4aa-1f3fe.png", ":muscle_tone4:", ":flexed_biceps_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcaa\ud83c\udfff", "1f4aa-1f3ff.png", ":muscle_tone5:", ":flexed_biceps_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcaa", "1f4aa.png", ":muscle:", ":flexed_biceps:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcab", "1f4ab.png", ":dizzy:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcac", "1f4ac.png", ":speech_balloon:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcad", "1f4ad.png", ":thought_balloon:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcae", "1f4ae.png", ":white_flower:", null, "Animals & Nature", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcaf", "1f4af.png", ":100:", ":hundred_points:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcb0", "1f4b0.png", ":moneybag:", ":money_bag:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcb1", "1f4b1.png", ":currency_exchange:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcb2", "1f4b2.png", ":heavy_dollar_sign:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcb3", "1f4b3.png", ":credit_card:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcb4", "1f4b4.png", ":yen:", ":yen_banknote:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcb5", "1f4b5.png", ":dollar:", ":dollar_banknote:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcb6", "1f4b6.png", ":euro:", ":euro_banknote:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcb7", "1f4b7.png", ":pound:", ":pound_banknote:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcb8", "1f4b8.png", ":money_with_wings:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcb9", "1f4b9.png", ":chart:", ":chart_increasing_with_yen:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcba", "1f4ba.png", ":seat:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcbb", "1f4bb.png", ":computer:", ":laptop:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcbc", "1f4bc.png", ":briefcase:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcbd", "1f4bd.png", ":minidisc:", ":computer_disk:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcbe", "1f4be.png", ":floppy_disk:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcbf", "1f4bf.png", ":cd:", ":optical_disk:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcc0", "1f4c0.png", ":dvd:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcc1", "1f4c1.png", ":file_folder:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcc2", "1f4c2.png", ":open_file_folder:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcc3", "1f4c3.png", ":page_with_curl:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcc4", "1f4c4.png", ":page_facing_up:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcc5", "1f4c5.png", ":date:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcc6", "1f4c6.png", ":calendar:", ":tear_off_calendar:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcc7", "1f4c7.png", ":card_index:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcc8", "1f4c8.png", ":chart_with_upwards_trend:", ":chart_increasing:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcc9", "1f4c9.png", ":chart_with_downwards_trend:", ":chart_decreasing:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcca", "1f4ca.png", ":bar_chart:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udccb", "1f4cb.png", ":clipboard:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udccc", "1f4cc.png", ":pushpin:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udccd", "1f4cd.png", ":round_pushpin:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcce", "1f4ce.png", ":paperclip:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udccf", "1f4cf.png", ":straight_ruler:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcd0", "1f4d0.png", ":triangular_ruler:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcd1", "1f4d1.png", ":bookmark_tabs:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcd2", "1f4d2.png", ":ledger:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcd3", "1f4d3.png", ":notebook:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcd4", "1f4d4.png", ":notebook_with_decorative_cover:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcd5", "1f4d5.png", ":closed_book:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcd6", "1f4d6.png", ":book:", ":open_book:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcd7", "1f4d7.png", ":green_book:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcd8", "1f4d8.png", ":blue_book:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcd9", "1f4d9.png", ":orange_book:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcda", "1f4da.png", ":books:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcdb", "1f4db.png", ":name_badge:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcdc", "1f4dc.png", ":scroll:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcdd", "1f4dd.png", ":memo:", ":pencil:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcde", "1f4de.png", ":telephone_receiver:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcdf", "1f4df.png", ":pager:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udce0", "1f4e0.png", ":fax:", ":fax_machine:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udce1", "1f4e1.png", ":satellite:", ":satellite_antenna:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udce2", "1f4e2.png", ":loudspeaker:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udce3", "1f4e3.png", ":mega:", ":megaphone:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udce4", "1f4e4.png", ":outbox_tray:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udce5", "1f4e5.png", ":inbox_tray:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udce6", "1f4e6.png", ":package:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udce7", "1f4e7.png", ":email:", ":e-mail:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udce8", "1f4e8.png", ":incoming_envelope:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udce9", "1f4e9.png", ":envelope_with_arrow:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcea", "1f4ea.png", ":mailbox_closed:", ":closed_mailbox_with_lowered_flag:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udceb", "1f4eb.png", ":mailbox:", ":closed_mailbox_with_raised_flag:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcec", "1f4ec.png", ":mailbox_with_mail:", ":open_mailbox_with_raised_flag:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udced", "1f4ed.png", ":mailbox_with_no_mail:", ":open_mailbox_with_lowered_flag:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcee", "1f4ee.png", ":postbox:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcef", "1f4ef.png", ":postal_horn:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcf0", "1f4f0.png", ":newspaper:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcf1", "1f4f1.png", ":iphone:", ":mobile_phone:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcf2", "1f4f2.png", ":calling:", ":mobile_phone_with_arrow:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcf3", "1f4f3.png", ":vibration_mode:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcf4", "1f4f4.png", ":mobile_phone_off:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcf5", "1f4f5.png", ":no_mobile_phones:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcf6", "1f4f6.png", ":signal_strength:", ":antenna_bars:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcf7", "1f4f7.png", ":camera:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcf8", "1f4f8.png", ":camera_flash:", ":camera_with_flash:", "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udcf9", "1f4f9.png", ":video_camera:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcfa", "1f4fa.png", ":tv:", ":television:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcfb", "1f4fb.png", ":radio:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcfc", "1f4fc.png", ":vhs:", ":videocassette:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udcfd", "1f4fd.png", ":film_projector:", ":projector:", "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udcff", "1f4ff.png", ":prayer_beads:", null, "Objects", "8.0");
        EmojiUtil.add(set, result, "\ud83d\udd00", "1f500.png", ":twisted_rightwards_arrows:", ":shuffle_tracks_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd01", "1f501.png", ":repeat:", ":repeat_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd02", "1f502.png", ":repeat_one:", ":repeat_single_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd03", "1f503.png", ":arrows_clockwise:", ":clockwise_vertical_arrows:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd04", "1f504.png", ":arrows_counterclockwise:", ":counterclockwise_arrows_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd05", "1f505.png", ":low_brightness:", ":dim_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd06", "1f506.png", ":high_brightness:", ":bright_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd07", "1f507.png", ":mute:", ":muted_speaker:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd08", "1f508.png", ":speaker:", ":speaker_low_volume:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd09", "1f509.png", ":sound:", ":speaker_medium_volume:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd0a", "1f50a.png", ":loud_sound:", ":speaker_high_volume:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd0b", "1f50b.png", ":battery:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd0c", "1f50c.png", ":electric_plug:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd0d", "1f50d.png", ":mag:", ":magnifying_glass_tilted_left:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd0e", "1f50e.png", ":mag_right:", ":magnifying_glass_tilted_right:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd0f", "1f50f.png", ":lock_with_ink_pen:", ":locked_with_pen:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd10", "1f510.png", ":closed_lock_with_key:", ":locked_with_key:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd11", "1f511.png", ":key:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd12", "1f512.png", ":lock:", ":locked:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd13", "1f513.png", ":unlock:", ":unlocked:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd14", "1f514.png", ":bell:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd15", "1f515.png", ":no_bell:", ":bell_with_slash:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd16", "1f516.png", ":bookmark:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd17", "1f517.png", ":link:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd18", "1f518.png", ":radio_button:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd19", "1f519.png", ":back:", ":back_arrow:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd1a", "1f51a.png", ":end:", ":end_arrow:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd1b", "1f51b.png", ":on:", ":on_arrow:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd1c", "1f51c.png", ":soon:", ":soon_arrow:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd1d", "1f51d.png", ":top:", ":top_arrow:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd1e", "1f51e.png", ":underage:", ":no_one_under_eighteen:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd1f", "1f51f.png", ":keycap_ten:", ":keycap_10:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd20", "1f520.png", ":capital_abcd:", ":input_latin_uppercase:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd21", "1f521.png", ":abcd:", ":input_latin_lowercase:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd22", "1f522.png", ":1234:", ":input_numbers:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd23", "1f523.png", ":symbols:", ":input_symbols:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd24", "1f524.png", ":abc:", ":input_latin_letters:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd25", "1f525.png", ":fire:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd26", "1f526.png", ":flashlight:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd27", "1f527.png", ":wrench:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd28", "1f528.png", ":hammer:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd29", "1f529.png", ":nut_and_bolt:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd2a", "1f52a.png", ":hocho:", ":knife:", "Food & Drink", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd2b", "1f52b.png", ":gun:", ":water_pistol:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd2c", "1f52c.png", ":microscope:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd2d", "1f52d.png", ":telescope:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd2e", "1f52e.png", ":crystal_ball:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd2f", "1f52f.png", ":six_pointed_star:", ":dotted_six_pointed_star:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd30", "1f530.png", ":beginner:", ":japanese_symbol_for_beginner:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd31", "1f531.png", ":trident:", ":trident_emblem:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd32", "1f532.png", ":black_square_button:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd33", "1f533.png", ":white_square_button:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd34", "1f534.png", ":red_circle:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd35", "1f535.png", ":large_blue_circle:", ":blue_circle:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd36", "1f536.png", ":large_orange_diamond:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd37", "1f537.png", ":large_blue_diamond:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd38", "1f538.png", ":small_orange_diamond:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd39", "1f539.png", ":small_blue_diamond:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd3a", "1f53a.png", ":small_red_triangle:", ":red_triangle_pointed_up:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd3b", "1f53b.png", ":small_red_triangle_down:", ":red_triangle_pointed_down:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd3c", "1f53c.png", ":arrow_up_small:", ":upwards_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd3d", "1f53d.png", ":arrow_down_small:", ":downwards_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd49", "1f549.png", ":om:", ":om_symbol:", "Symbols", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd4a", "1f54a.png", ":dove:", null, "Animals & Nature", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd4b", "1f54b.png", ":kaaba:", null, "Travel & Places", "8.0");
        EmojiUtil.add(set, result, "\ud83d\udd4c", "1f54c.png", ":mosque:", null, "Travel & Places", "8.0");
        EmojiUtil.add(set, result, "\ud83d\udd4d", "1f54d.png", ":synagogue:", null, "Travel & Places", "8.0");
        EmojiUtil.add(set, result, "\ud83d\udd4e", "1f54e.png", ":menorah:", null, "Symbols", "8.0");
        EmojiUtil.add(set, result, "\ud83d\udd50", "1f550.png", ":clock1:", ":one_oclock:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd51", "1f551.png", ":clock2:", ":two_oclock:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd52", "1f552.png", ":clock3:", ":three_oclock:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd53", "1f553.png", ":clock4:", ":four_oclock:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd54", "1f554.png", ":clock5:", ":five_oclock:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd55", "1f555.png", ":clock6:", ":six_oclock:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd56", "1f556.png", ":clock7:", ":seven_oclock:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd57", "1f557.png", ":clock8:", ":eight_oclock:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd58", "1f558.png", ":clock9:", ":nine_oclock:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd59", "1f559.png", ":clock10:", ":ten_oclock:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd5a", "1f55a.png", ":clock11:", ":eleven_oclock:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd5b", "1f55b.png", ":clock12:", ":twelve_oclock:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd5c", "1f55c.png", ":clock130:", ":one_thirty:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd5d", "1f55d.png", ":clock230:", ":two_thirty:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd5e", "1f55e.png", ":clock330:", ":three_thirty:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd5f", "1f55f.png", ":clock430:", ":four_thirty:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd60", "1f560.png", ":clock530:", ":five_thirty:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd61", "1f561.png", ":clock630:", ":six_thirty:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd62", "1f562.png", ":clock730:", ":seven_thirty:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd63", "1f563.png", ":clock830:", ":eight_thirty:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd64", "1f564.png", ":clock930:", ":nine_thirty:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd65", "1f565.png", ":clock1030:", ":ten_thirty:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd66", "1f566.png", ":clock1130:", ":eleven_thirty:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd67", "1f567.png", ":clock1230:", ":twelve_thirty:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udd6f", "1f56f.png", ":candle:", null, "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd70", "1f570.png", ":mantelpiece_clock:", ":clock:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd73", "1f573.png", ":hole:", null, "Smileys & Emotion", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd74", "1f574.png", ":business_suit_levitating:", ":levitate:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd75\ud83c\udffb", "1f575-1f3fb.png", ":detective_tone1:", ":detective_light_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd75\ud83c\udffc", "1f575-1f3fc.png", ":detective_tone2:", ":detective_medium_light_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd75\ud83c\udffd", "1f575-1f3fd.png", ":detective_tone3:", ":detective_medium_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd75\ud83c\udffe", "1f575-1f3fe.png", ":detective_tone4:", ":detective_medium_dark_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd75\ud83c\udfff", "1f575-1f3ff.png", ":detective_tone5:", ":detective_dark_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd75", "1f575.png", ":detective:", null, "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd76", "1f576.png", ":dark_sunglasses:", null, "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd77", "1f577.png", ":spider:", null, "Animals & Nature", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd78", "1f578.png", ":spider_web:", null, "Animals & Nature", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd79", "1f579.png", ":joystick:", null, "Activities", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd7a\ud83c\udffb", "1f57a-1f3fb.png", ":man_dancing_tone1:", ":man_dancing_light_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83d\udd7a\ud83c\udffc", "1f57a-1f3fc.png", ":man_dancing_tone2:", ":man_dancing_medium_light_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83d\udd7a\ud83c\udffd", "1f57a-1f3fd.png", ":man_dancing_tone3:", ":man_dancing_medium_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83d\udd7a\ud83c\udffe", "1f57a-1f3fe.png", ":man_dancing_tone4:", ":man_dancing_medium_dark_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83d\udd7a\ud83c\udfff", "1f57a-1f3ff.png", ":man_dancing_tone5:", ":man_dancing_dark_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83d\udd7a", "1f57a.png", ":man_dancing:", null, "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83d\udd87", "1f587.png", ":paperclips:", null, "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd8a", "1f58a.png", ":pen:", ":pen_ballpoint:", "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd8b", "1f58b.png", ":fountain_pen:", ":pen_fountain:", "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd8c", "1f58c.png", ":paintbrush:", null, "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd8d", "1f58d.png", ":crayon:", null, "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd90\ud83c\udffb", "1f590-1f3fb.png", ":raised_hand_with_fingers_splayed_tone1:", ":hand_splayed_tone1:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd90\ud83c\udffc", "1f590-1f3fc.png", ":raised_hand_with_fingers_splayed_tone2:", ":hand_splayed_tone2:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd90\ud83c\udffd", "1f590-1f3fd.png", ":raised_hand_with_fingers_splayed_tone3:", ":hand_splayed_tone3:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd90\ud83c\udffe", "1f590-1f3fe.png", ":raised_hand_with_fingers_splayed_tone4:", ":hand_splayed_tone4:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd90\ud83c\udfff", "1f590-1f3ff.png", ":raised_hand_with_fingers_splayed_tone5:", ":hand_splayed_tone5:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd90", "1f590.png", ":raised_hand_with_fingers_splayed:", ":hand_splayed:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd95\ud83c\udffb", "1f595-1f3fb.png", ":middle_finger_tone1:", ":middle_finger_light_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd95\ud83c\udffc", "1f595-1f3fc.png", ":middle_finger_tone2:", ":middle_finger_medium_light_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd95\ud83c\udffd", "1f595-1f3fd.png", ":middle_finger_tone3:", ":middle_finger_medium_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd95\ud83c\udffe", "1f595-1f3fe.png", ":middle_finger_tone4:", ":middle_finger_medium_dark_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd95\ud83c\udfff", "1f595-1f3ff.png", ":middle_finger_tone5:", ":middle_finger_dark_skin_tone:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd95", "1f595.png", ":middle_finger:", null, "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd96\ud83c\udffb", "1f596-1f3fb.png", ":vulcan_salute_tone1:", ":vulcan_tone1:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd96\ud83c\udffc", "1f596-1f3fc.png", ":vulcan_salute_tone2:", ":vulcan_tone2:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd96\ud83c\udffd", "1f596-1f3fd.png", ":vulcan_salute_tone3:", ":vulcan_tone3:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd96\ud83c\udffe", "1f596-1f3fe.png", ":vulcan_salute_tone4:", ":vulcan_tone4:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd96\ud83c\udfff", "1f596-1f3ff.png", ":vulcan_salute_tone5:", ":vulcan_tone5:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udd96", "1f596.png", ":vulcan_salute:", ":vulcan:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udda4", "1f5a4.png", ":black_heart:", null, "Smileys & Emotion", "9.0");
        EmojiUtil.add(set, result, "\ud83d\udda5", "1f5a5.png", ":desktop_computer:", ":desktop:", "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udda8", "1f5a8.png", ":printer:", null, "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\uddb1", "1f5b1.png", ":computer_mouse:", ":mouse_three_button:", "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\uddb2", "1f5b2.png", ":trackball:", null, "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\uddbc", "1f5bc.png", ":framed_picture:", ":frame_photo:", "Activities", "7.0");
        EmojiUtil.add(set, result, "\ud83d\uddc2", "1f5c2.png", ":card_index_dividers:", ":dividers:", "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\uddc3", "1f5c3.png", ":card_file_box:", ":card_box:", "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\uddc4", "1f5c4.png", ":file_cabinet:", null, "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\uddd1", "1f5d1.png", ":wastebasket:", null, "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\uddd2", "1f5d2.png", ":spiral_notepad:", ":notepad_spiral:", "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\uddd3", "1f5d3.png", ":spiral_calendar:", ":calendar_spiral:", "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udddc", "1f5dc.png", ":clamp:", ":compression:", "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udddd", "1f5dd.png", ":old_key:", ":key2:", "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\uddde", "1f5de.png", ":newspaper_roll:", ":newspaper2:", "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udde1", "1f5e1.png", ":dagger:", null, "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udde3", "1f5e3.png", ":speaking_head:", null, "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udde8", "1f5e8.png", ":left_speech_bubble:", ":speech_left:", "Smileys & Emotion", "11.0");
        EmojiUtil.add(set, result, "\ud83d\uddef", "1f5ef.png", ":right_anger_bubble:", ":anger_right:", "Smileys & Emotion", "7.0");
        EmojiUtil.add(set, result, "\ud83d\uddf3", "1f5f3.png", ":ballot_box:", null, "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\uddfa", "1f5fa.png", ":world_map:", ":map:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83d\uddfb", "1f5fb.png", ":mount_fuji:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\uddfc", "1f5fc.png", ":tokyo_tower:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\uddfd", "1f5fd.png", ":statue_of_liberty:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\uddfe", "1f5fe.png", ":japan:", ":map_of_japan:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\uddff", "1f5ff.png", ":moyai:", ":moai:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude00", "1f600.png", ":grinning:", ":grinning_face:", "Smileys & Emotion", "6.1");
        EmojiUtil.add(set, result, "\ud83d\ude01", "1f601.png", ":grin:", ":beaming_face_with_smiling_eyes:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude02", "1f602.png", ":joy:", ":face_with_tears_of_joy:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude03", "1f603.png", ":smiley:", ":grinning_face_with_big_eyes:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude04", "1f604.png", ":smile:", ":grinning_face_with_smiling_eyes:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude05", "1f605.png", ":sweat_smile:", ":grinning_face_with_sweat:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude06", "1f606.png", ":laughing:", ":grinning_squinting_face:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude07", "1f607.png", ":innocent:", ":smiling_face_with_halo:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude08", "1f608.png", ":smiling_imp:", ":smiling_face_with_horns:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude09", "1f609.png", ":wink:", ":winking_face:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude0a", "1f60a.png", ":blush:", ":smiling_face_with_smiling_eyes:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude0b", "1f60b.png", ":yum:", ":face_savoring_food:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude0c", "1f60c.png", ":relieved:", ":relieved_face:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude0d", "1f60d.png", ":heart_eyes:", ":smiling_face_with_heart_eyes:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude0e", "1f60e.png", ":sunglasses:", ":smiling_face_with_sunglasses:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude0f", "1f60f.png", ":smirk:", ":smirking_face:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude10", "1f610.png", ":neutral_face:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude11", "1f611.png", ":expressionless:", ":expressionless_face:", "Smileys & Emotion", "6.1");
        EmojiUtil.add(set, result, "\ud83d\ude12", "1f612.png", ":unamused:", ":unamused_face:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude13", "1f613.png", ":sweat:", ":downcast_face_with_sweat:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude14", "1f614.png", ":pensive:", ":pensive_face:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude15", "1f615.png", ":confused:", ":confused_face:", "Smileys & Emotion", "6.1");
        EmojiUtil.add(set, result, "\ud83d\ude16", "1f616.png", ":confounded:", ":confounded_face:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude17", "1f617.png", ":kissing:", ":kissing_face:", "Smileys & Emotion", "6.1");
        EmojiUtil.add(set, result, "\ud83d\ude18", "1f618.png", ":kissing_heart:", ":face_blowing_a_kiss:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude19", "1f619.png", ":kissing_smiling_eyes:", ":kissing_face_with_smiling_eyes:", "Smileys & Emotion", "6.1");
        EmojiUtil.add(set, result, "\ud83d\ude1a", "1f61a.png", ":kissing_closed_eyes:", ":kissing_face_with_closed_eyes:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude1b", "1f61b.png", ":stuck_out_tongue:", ":face_with_tongue:", "Smileys & Emotion", "6.1");
        EmojiUtil.add(set, result, "\ud83d\ude1c", "1f61c.png", ":stuck_out_tongue_winking_eye:", ":winking_face_with_tongue:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude1d", "1f61d.png", ":stuck_out_tongue_closed_eyes:", ":squinting_face_with_tongue:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude1e", "1f61e.png", ":disappointed:", ":disappointed_face:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude1f", "1f61f.png", ":worried:", ":worried_face:", "Smileys & Emotion", "6.1");
        EmojiUtil.add(set, result, "\ud83d\ude20", "1f620.png", ":angry:", ":angry_face:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude21", "1f621.png", ":rage:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude22", "1f622.png", ":cry:", ":crying_face:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude23", "1f623.png", ":persevere:", ":persevering_face:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude24", "1f624.png", ":triumph:", ":face_with_steam_from_nose:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude25", "1f625.png", ":disappointed_relieved:", ":sad_but_relieved_face:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude26", "1f626.png", ":frowning:", ":frowning_face_with_open_mouth:", "Smileys & Emotion", "6.1");
        EmojiUtil.add(set, result, "\ud83d\ude27", "1f627.png", ":anguished:", ":anguished_face:", "Smileys & Emotion", "6.1");
        EmojiUtil.add(set, result, "\ud83d\ude28", "1f628.png", ":fearful:", ":fearful_face:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude29", "1f629.png", ":weary:", ":weary_face:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude2a", "1f62a.png", ":sleepy:", ":sleepy_face:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude2b", "1f62b.png", ":tired_face:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude2c", "1f62c.png", ":grimacing:", ":grimacing_face:", "Smileys & Emotion", "6.1");
        EmojiUtil.add(set, result, "\ud83d\ude2d", "1f62d.png", ":sob:", ":loudly_crying_face:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude2e", "1f62e.png", ":open_mouth:", ":face_with_open_mouth:", "Smileys & Emotion", "6.1");
        EmojiUtil.add(set, result, "\ud83d\ude2f", "1f62f.png", ":hushed:", ":hushed_face:", "Smileys & Emotion", "6.1");
        EmojiUtil.add(set, result, "\ud83d\ude30", "1f630.png", ":cold_sweat:", ":anxious_face_with_sweat:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude31", "1f631.png", ":scream:", ":face_screaming_in_fear:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude32", "1f632.png", ":astonished:", ":astonished_face:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude33", "1f633.png", ":flushed:", ":flushed_face:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude34", "1f634.png", ":sleeping:", ":sleeping_face:", "Smileys & Emotion", "6.1");
        EmojiUtil.add(set, result, "\ud83d\ude35", "1f635.png", ":dizzy_face:", ":face_with_crossed_out_eyes:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude36", "1f636.png", ":no_mouth:", ":face_without_mouth:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude37", "1f637.png", ":mask:", ":face_with_medical_mask:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude38", "1f638.png", ":smile_cat:", ":grinning_cat_with_smiling_eyes:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude39", "1f639.png", ":joy_cat:", ":cat_with_tears_of_joy:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude3a", "1f63a.png", ":smiley_cat:", ":grinning_cat:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude3b", "1f63b.png", ":heart_eyes_cat:", ":smiling_cat_with_heart_eyes:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude3c", "1f63c.png", ":smirk_cat:", ":cat_with_wry_smile:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude3d", "1f63d.png", ":kissing_cat:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude3e", "1f63e.png", ":pouting_cat:", null, "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude3f", "1f63f.png", ":crying_cat_face:", ":crying_cat:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude40", "1f640.png", ":scream_cat:", ":weary_cat:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude41", "1f641.png", ":slightly_frowning_face:", ":slight_frown:", "Smileys & Emotion", "7.0");
        EmojiUtil.add(set, result, "\ud83d\ude42", "1f642.png", ":slightly_smiling_face:", ":slight_smile:", "Smileys & Emotion", "7.0");
        EmojiUtil.add(set, result, "\ud83d\ude43", "1f643.png", ":upside_down_face:", ":upside_down:", "Smileys & Emotion", "8.0");
        EmojiUtil.add(set, result, "\ud83d\ude44", "1f644.png", ":roll_eyes:", ":rolling_eyes:", "Smileys & Emotion", "8.0");
        EmojiUtil.add(set, result, "\ud83d\ude45\ud83c\udffb", "1f645-1f3fb.png", ":no_good_tone1:", ":person_gesturing_no_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude45\ud83c\udffc", "1f645-1f3fc.png", ":no_good_tone2:", ":person_gesturing_no_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude45\ud83c\udffd", "1f645-1f3fd.png", ":no_good_tone3:", ":person_gesturing_no_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude45\ud83c\udffe", "1f645-1f3fe.png", ":no_good_tone4:", ":person_gesturing_no_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude45\ud83c\udfff", "1f645-1f3ff.png", ":no_good_tone5:", ":person_gesturing_no_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude45", "1f645.png", ":no_good:", ":person_gesturing_no:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude46\ud83c\udffb", "1f646-1f3fb.png", ":ok_person_tone1:", ":person_gesturing_ok_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude46\ud83c\udffc", "1f646-1f3fc.png", ":ok_person_tone2:", ":person_gesturing_ok_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude46\ud83c\udffd", "1f646-1f3fd.png", ":ok_person_tone3:", ":person_gesturing_ok_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude46\ud83c\udffe", "1f646-1f3fe.png", ":ok_person_tone4:", ":person_gesturing_ok_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude46\ud83c\udfff", "1f646-1f3ff.png", ":ok_person_tone5:", ":person_gesturing_ok_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude46", "1f646.png", ":ok_person:", ":person_gesturing_ok:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude47\ud83c\udffb", "1f647-1f3fb.png", ":bow_tone1:", ":person_bowing_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude47\ud83c\udffc", "1f647-1f3fc.png", ":bow_tone2:", ":person_bowing_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude47\ud83c\udffd", "1f647-1f3fd.png", ":bow_tone3:", ":person_bowing_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude47\ud83c\udffe", "1f647-1f3fe.png", ":bow_tone4:", ":person_bowing_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude47\ud83c\udfff", "1f647-1f3ff.png", ":bow_tone5:", ":person_bowing_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude47", "1f647.png", ":bow:", ":person_bowing:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude48", "1f648.png", ":see_no_evil:", ":see_no_evil_monkey:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude49", "1f649.png", ":hear_no_evil:", ":hear_no_evil_monkey:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4a", "1f64a.png", ":speak_no_evil:", ":speak_no_evil_monkey:", "Smileys & Emotion", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4b\ud83c\udffb", "1f64b-1f3fb.png", ":raising_hand_tone1:", ":person_raising_hand_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4b\ud83c\udffc", "1f64b-1f3fc.png", ":raising_hand_tone2:", ":person_raising_hand_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4b\ud83c\udffd", "1f64b-1f3fd.png", ":raising_hand_tone3:", ":person_raising_hand_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4b\ud83c\udffe", "1f64b-1f3fe.png", ":raising_hand_tone4:", ":person_raising_hand_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4b\ud83c\udfff", "1f64b-1f3ff.png", ":raising_hand_tone5:", ":person_raising_hand_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4b", "1f64b.png", ":raising_hand:", ":person_raising_hand:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4c\ud83c\udffb", "1f64c-1f3fb.png", ":raised_hands_tone1:", ":raising_hands_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4c\ud83c\udffc", "1f64c-1f3fc.png", ":raised_hands_tone2:", ":raising_hands_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4c\ud83c\udffd", "1f64c-1f3fd.png", ":raised_hands_tone3:", ":raising_hands_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4c\ud83c\udffe", "1f64c-1f3fe.png", ":raised_hands_tone4:", ":raising_hands_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4c\ud83c\udfff", "1f64c-1f3ff.png", ":raised_hands_tone5:", ":raising_hands_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4c", "1f64c.png", ":raised_hands:", ":raising_hands:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4d\ud83c\udffb", "1f64d-1f3fb.png", ":frowning_person_tone1:", ":person_frowning_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4d\ud83c\udffc", "1f64d-1f3fc.png", ":frowning_person_tone2:", ":person_frowning_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4d\ud83c\udffd", "1f64d-1f3fd.png", ":frowning_person_tone3:", ":person_frowning_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4d\ud83c\udffe", "1f64d-1f3fe.png", ":frowning_person_tone4:", ":person_frowning_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4d\ud83c\udfff", "1f64d-1f3ff.png", ":frowning_person_tone5:", ":person_frowning_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4d", "1f64d.png", ":frowning_person:", ":person_frowning:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4e\ud83c\udffb", "1f64e-1f3fb.png", ":pouting_face_tone1:", ":person_pouting_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4e\ud83c\udffc", "1f64e-1f3fc.png", ":pouting_face_tone2:", ":person_pouting_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4e\ud83c\udffd", "1f64e-1f3fd.png", ":pouting_face_tone3:", ":person_pouting_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4e\ud83c\udffe", "1f64e-1f3fe.png", ":pouting_face_tone4:", ":person_pouting_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4e\ud83c\udfff", "1f64e-1f3ff.png", ":pouting_face_tone5:", ":person_pouting_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4e", "1f64e.png", ":pouting_face:", ":person_pouting:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4f\ud83c\udffb", "1f64f-1f3fb.png", ":pray_tone1:", ":folded_hands_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4f\ud83c\udffc", "1f64f-1f3fc.png", ":pray_tone2:", ":folded_hands_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4f\ud83c\udffd", "1f64f-1f3fd.png", ":pray_tone3:", ":folded_hands_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4f\ud83c\udffe", "1f64f-1f3fe.png", ":pray_tone4:", ":folded_hands_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4f\ud83c\udfff", "1f64f-1f3ff.png", ":pray_tone5:", ":folded_hands_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude4f", "1f64f.png", ":pray:", ":folded_hands:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude80", "1f680.png", ":rocket:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude81", "1f681.png", ":helicopter:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude82", "1f682.png", ":steam_locomotive:", ":locomotive:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude83", "1f683.png", ":railway_car:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude84", "1f684.png", ":bullettrain_side:", ":high_speed_train:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude85", "1f685.png", ":bullettrain_front:", ":bullet_train:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude86", "1f686.png", ":train2:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude87", "1f687.png", ":metro:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude88", "1f688.png", ":light_rail:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude89", "1f689.png", ":station:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude8a", "1f68a.png", ":tram:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude8b", "1f68b.png", ":train:", ":tram_car:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude8c", "1f68c.png", ":bus:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude8d", "1f68d.png", ":oncoming_bus:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude8e", "1f68e.png", ":trolleybus:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude8f", "1f68f.png", ":busstop:", ":bus_stop:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude90", "1f690.png", ":minibus:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude91", "1f691.png", ":ambulance:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude92", "1f692.png", ":fire_engine:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude93", "1f693.png", ":police_car:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude94", "1f694.png", ":oncoming_police_car:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude95", "1f695.png", ":taxi:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude96", "1f696.png", ":oncoming_taxi:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude97", "1f697.png", ":car:", ":red_car:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude98", "1f698.png", ":oncoming_automobile:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude99", "1f699.png", ":blue_car:", ":sport_utility_vehicle:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude9a", "1f69a.png", ":truck:", ":delivery_truck:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude9b", "1f69b.png", ":articulated_lorry:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude9c", "1f69c.png", ":tractor:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude9d", "1f69d.png", ":monorail:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude9e", "1f69e.png", ":mountain_railway:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\ude9f", "1f69f.png", ":suspension_railway:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea0", "1f6a0.png", ":mountain_cableway:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea1", "1f6a1.png", ":aerial_tramway:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea2", "1f6a2.png", ":ship:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea3\ud83c\udffb", "1f6a3-1f3fb.png", ":rowboat_tone1:", ":person_rowing_boat_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea3\ud83c\udffc", "1f6a3-1f3fc.png", ":rowboat_tone2:", ":person_rowing_boat_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea3\ud83c\udffd", "1f6a3-1f3fd.png", ":rowboat_tone3:", ":person_rowing_boat_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea3\ud83c\udffe", "1f6a3-1f3fe.png", ":rowboat_tone4:", ":person_rowing_boat_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea3\ud83c\udfff", "1f6a3-1f3ff.png", ":rowboat_tone5:", ":person_rowing_boat_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea3", "1f6a3.png", ":rowboat:", ":person_rowing_boat:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea4", "1f6a4.png", ":speedboat:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea5", "1f6a5.png", ":traffic_light:", ":horizontal_traffic_light:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea6", "1f6a6.png", ":vertical_traffic_light:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea7", "1f6a7.png", ":construction:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea8", "1f6a8.png", ":rotating_light:", ":police_car_light:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udea9", "1f6a9.png", ":triangular_flag_on_post:", ":triangular_flag:", "Flags", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeaa", "1f6aa.png", ":door:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeab", "1f6ab.png", ":no_entry_sign:", ":prohibited:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeac", "1f6ac.png", ":smoking:", ":cigarette:", "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udead", "1f6ad.png", ":no_smoking:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeae", "1f6ae.png", ":put_litter_in_its_place:", ":litter_in_bin_sign:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeaf", "1f6af.png", ":do_not_litter:", ":no_littering:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb0", "1f6b0.png", ":potable_water:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb1", "1f6b1.png", ":non-potable_water:", ":non_potable_water:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb2", "1f6b2.png", ":bike:", ":bicycle:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb3", "1f6b3.png", ":no_bicycles:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb4\ud83c\udffb", "1f6b4-1f3fb.png", ":bicyclist_tone1:", ":person_biking_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb4\ud83c\udffc", "1f6b4-1f3fc.png", ":bicyclist_tone2:", ":person_biking_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb4\ud83c\udffd", "1f6b4-1f3fd.png", ":bicyclist_tone3:", ":person_biking_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb4\ud83c\udffe", "1f6b4-1f3fe.png", ":bicyclist_tone4:", ":person_biking_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb4\ud83c\udfff", "1f6b4-1f3ff.png", ":bicyclist_tone5:", ":person_biking_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb4", "1f6b4.png", ":bicyclist:", ":person_biking:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb5\ud83c\udffb", "1f6b5-1f3fb.png", ":mountain_bicyclist_tone1:", ":person_mountain_biking_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb5\ud83c\udffc", "1f6b5-1f3fc.png", ":mountain_bicyclist_tone2:", ":person_mountain_biking_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb5\ud83c\udffd", "1f6b5-1f3fd.png", ":mountain_bicyclist_tone3:", ":person_mountain_biking_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb5\ud83c\udffe", "1f6b5-1f3fe.png", ":mountain_bicyclist_tone4:", ":person_mountain_biking_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb5\ud83c\udfff", "1f6b5-1f3ff.png", ":mountain_bicyclist_tone5:", ":person_mountain_biking_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb5", "1f6b5.png", ":mountain_bicyclist:", ":person_mountain_biking:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb6\ud83c\udffb", "1f6b6-1f3fb.png", ":walking_tone1:", ":person_walking_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb6\ud83c\udffc", "1f6b6-1f3fc.png", ":walking_tone2:", ":person_walking_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb6\ud83c\udffd", "1f6b6-1f3fd.png", ":walking_tone3:", ":person_walking_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb6\ud83c\udffe", "1f6b6-1f3fe.png", ":walking_tone4:", ":person_walking_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb6\ud83c\udfff", "1f6b6-1f3ff.png", ":walking_tone5:", ":person_walking_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb6", "1f6b6.png", ":walking:", ":person_walking:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb7", "1f6b7.png", ":no_pedestrians:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb8", "1f6b8.png", ":children_crossing:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeb9", "1f6b9.png", ":mens:", ":mens_room:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udeba", "1f6ba.png", ":womens:", ":womens_room:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udebb", "1f6bb.png", ":restroom:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udebc", "1f6bc.png", ":baby_symbol:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udebd", "1f6bd.png", ":toilet:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udebe", "1f6be.png", ":wc:", ":water_closet:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udebf", "1f6bf.png", ":shower:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udec0\ud83c\udffb", "1f6c0-1f3fb.png", ":bath_tone1:", ":person_taking_bath_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udec0\ud83c\udffc", "1f6c0-1f3fc.png", ":bath_tone2:", ":person_taking_bath_medium_light_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udec0\ud83c\udffd", "1f6c0-1f3fd.png", ":bath_tone3:", ":person_taking_bath_medium_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udec0\ud83c\udffe", "1f6c0-1f3fe.png", ":bath_tone4:", ":person_taking_bath_medium_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udec0\ud83c\udfff", "1f6c0-1f3ff.png", ":bath_tone5:", ":person_taking_bath_dark_skin_tone:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udec0", "1f6c0.png", ":bath:", ":person_taking_bath:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udec1", "1f6c1.png", ":bathtub:", null, "Objects", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udec2", "1f6c2.png", ":passport_control:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udec3", "1f6c3.png", ":customs:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udec4", "1f6c4.png", ":baggage_claim:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udec5", "1f6c5.png", ":left_luggage:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\ud83d\udecb", "1f6cb.png", ":couch_and_lamp:", ":couch:", "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udecc", "1f6cc.png", ":sleeping_bed:", ":sleeping_accommodation:", "People & Body", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udecd", "1f6cd.png", ":shopping:", ":shopping_bags:", "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udece", "1f6ce.png", ":bellhop_bell:", ":bellhop:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udecf", "1f6cf.png", ":bed:", null, "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\uded0", "1f6d0.png", ":place_of_worship:", null, "Symbols", "8.0");
        EmojiUtil.add(set, result, "\ud83d\uded1", "1f6d1.png", ":stop_sign:", ":octagonal_sign:", "Travel & Places", "9.0");
        EmojiUtil.add(set, result, "\ud83d\uded2", "1f6d2.png", ":shopping_cart:", null, "Objects", "9.0");
        EmojiUtil.add(set, result, "\ud83d\udee0", "1f6e0.png", ":hammer_and_wrench:", ":tools:", "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udee1", "1f6e1.png", ":shield:", null, "Objects", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udee2", "1f6e2.png", ":oil_drum:", ":oil:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udee3", "1f6e3.png", ":motorway:", null, "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udee4", "1f6e4.png", ":railway_track:", null, "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udee5", "1f6e5.png", ":motor_boat:", ":motorboat:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udee9", "1f6e9.png", ":small_airplane:", ":airplane_small:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udeeb", "1f6eb.png", ":flight_departure:", ":airplane_departure:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udeec", "1f6ec.png", ":flight_arrival:", ":airplane_arriving:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udef0", "1f6f0.png", ":artificial_satellite:", ":satellite_orbital:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udef3", "1f6f3.png", ":passenger_ship:", ":cruise_ship:", "Travel & Places", "7.0");
        EmojiUtil.add(set, result, "\ud83d\udef4", "1f6f4.png", ":kick_scooter:", ":scooter:", "Travel & Places", "9.0");
        EmojiUtil.add(set, result, "\ud83d\udef5", "1f6f5.png", ":motor_scooter:", null, "Travel & Places", "9.0");
        EmojiUtil.add(set, result, "\ud83d\udef6", "1f6f6.png", ":canoe:", null, "Travel & Places", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd10", "1f910.png", ":zipper_mouth_face:", ":zipper_mouth:", "Smileys & Emotion", "8.0");
        EmojiUtil.add(set, result, "\ud83e\udd11", "1f911.png", ":money_mouth_face:", ":money_mouth:", "Smileys & Emotion", "8.0");
        EmojiUtil.add(set, result, "\ud83e\udd12", "1f912.png", ":face_with_thermometer:", ":thermometer_face:", "Smileys & Emotion", "8.0");
        EmojiUtil.add(set, result, "\ud83e\udd13", "1f913.png", ":nerd_face:", ":nerd:", "Smileys & Emotion", "8.0");
        EmojiUtil.add(set, result, "\ud83e\udd14", "1f914.png", ":thinking:", ":thinking_face:", "Smileys & Emotion", "8.0");
        EmojiUtil.add(set, result, "\ud83e\udd15", "1f915.png", ":face_with_head_bandage:", ":head_bandage:", "Smileys & Emotion", "8.0");
        EmojiUtil.add(set, result, "\ud83e\udd16", "1f916.png", ":robot:", null, "Smileys & Emotion", "8.0");
        EmojiUtil.add(set, result, "\ud83e\udd17", "1f917.png", ":hugs:", ":hugging:", "Smileys & Emotion", "8.0");
        EmojiUtil.add(set, result, "\ud83e\udd18\ud83c\udffb", "1f918-1f3fb.png", ":metal_tone1:", ":sign_of_the_horns_light_skin_tone:", "People & Body", "8.0");
        EmojiUtil.add(set, result, "\ud83e\udd18\ud83c\udffc", "1f918-1f3fc.png", ":metal_tone2:", ":sign_of_the_horns_medium_light_skin_tone:", "People & Body", "8.0");
        EmojiUtil.add(set, result, "\ud83e\udd18\ud83c\udffd", "1f918-1f3fd.png", ":metal_tone3:", ":sign_of_the_horns_medium_skin_tone:", "People & Body", "8.0");
        EmojiUtil.add(set, result, "\ud83e\udd18\ud83c\udffe", "1f918-1f3fe.png", ":metal_tone4:", ":sign_of_the_horns_medium_dark_skin_tone:", "People & Body", "8.0");
        EmojiUtil.add(set, result, "\ud83e\udd18\ud83c\udfff", "1f918-1f3ff.png", ":metal_tone5:", ":sign_of_the_horns_dark_skin_tone:", "People & Body", "8.0");
        EmojiUtil.add(set, result, "\ud83e\udd18", "1f918.png", ":metal:", ":sign_of_the_horns:", "People & Body", "8.0");
        EmojiUtil.add(set, result, "\ud83e\udd19\ud83c\udffb", "1f919-1f3fb.png", ":call_me_hand_tone1:", ":call_me_tone1:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd19\ud83c\udffc", "1f919-1f3fc.png", ":call_me_hand_tone2:", ":call_me_tone2:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd19\ud83c\udffd", "1f919-1f3fd.png", ":call_me_hand_tone3:", ":call_me_tone3:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd19\ud83c\udffe", "1f919-1f3fe.png", ":call_me_hand_tone4:", ":call_me_tone4:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd19\ud83c\udfff", "1f919-1f3ff.png", ":call_me_hand_tone5:", ":call_me_tone5:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd19", "1f919.png", ":call_me_hand:", ":call_me:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1a\ud83c\udffb", "1f91a-1f3fb.png", ":raised_back_of_hand_tone1:", ":raised_back_of_hand_light_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1a\ud83c\udffc", "1f91a-1f3fc.png", ":raised_back_of_hand_tone2:", ":raised_back_of_hand_medium_light_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1a\ud83c\udffd", "1f91a-1f3fd.png", ":raised_back_of_hand_tone3:", ":raised_back_of_hand_medium_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1a\ud83c\udffe", "1f91a-1f3fe.png", ":raised_back_of_hand_tone4:", ":raised_back_of_hand_medium_dark_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1a\ud83c\udfff", "1f91a-1f3ff.png", ":raised_back_of_hand_tone5:", ":raised_back_of_hand_dark_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1a", "1f91a.png", ":raised_back_of_hand:", null, "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1b\ud83c\udffb", "1f91b-1f3fb.png", ":fist_left_tone1:", ":left_facing_fist_tone1:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1b\ud83c\udffc", "1f91b-1f3fc.png", ":fist_left_tone2:", ":left_facing_fist_tone2:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1b\ud83c\udffd", "1f91b-1f3fd.png", ":fist_left_tone3:", ":left_facing_fist_tone3:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1b\ud83c\udffe", "1f91b-1f3fe.png", ":fist_left_tone4:", ":left_facing_fist_tone4:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1b\ud83c\udfff", "1f91b-1f3ff.png", ":fist_left_tone5:", ":left_facing_fist_tone5:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1b", "1f91b.png", ":fist_left:", ":left_facing_fist:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1c\ud83c\udffb", "1f91c-1f3fb.png", ":fist_right_tone1:", ":right_facing_fist_tone1:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1c\ud83c\udffc", "1f91c-1f3fc.png", ":fist_right_tone2:", ":right_facing_fist_tone2:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1c\ud83c\udffd", "1f91c-1f3fd.png", ":fist_right_tone3:", ":right_facing_fist_tone3:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1c\ud83c\udffe", "1f91c-1f3fe.png", ":fist_right_tone4:", ":right_facing_fist_tone4:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1c\ud83c\udfff", "1f91c-1f3ff.png", ":fist_right_tone5:", ":right_facing_fist_tone5:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1c", "1f91c.png", ":fist_right:", ":right_facing_fist:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1d\ud83c\udffb", "1f91d-1f3fb.png", ":handshake_tone1:", ":handshake_light_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1d\ud83c\udffc", "1f91d-1f3fc.png", ":handshake_tone2:", ":handshake_medium_light_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1d\ud83c\udffd", "1f91d-1f3fd.png", ":handshake_tone3:", ":handshake_medium_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1d\ud83c\udffe", "1f91d-1f3fe.png", ":handshake_tone4:", ":handshake_medium_dark_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1d\ud83c\udfff", "1f91d-1f3ff.png", ":handshake_tone5:", ":handshake_dark_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1d", "1f91d.png", ":handshake:", null, "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1e\ud83c\udffb", "1f91e-1f3fb.png", ":crossed_fingers_tone1:", ":fingers_crossed_tone1:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1e\ud83c\udffc", "1f91e-1f3fc.png", ":crossed_fingers_tone2:", ":fingers_crossed_tone2:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1e\ud83c\udffd", "1f91e-1f3fd.png", ":crossed_fingers_tone3:", ":fingers_crossed_tone3:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1e\ud83c\udffe", "1f91e-1f3fe.png", ":crossed_fingers_tone4:", ":fingers_crossed_tone4:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1e\ud83c\udfff", "1f91e-1f3ff.png", ":crossed_fingers_tone5:", ":fingers_crossed_tone5:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd1e", "1f91e.png", ":crossed_fingers:", ":fingers_crossed:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd20", "1f920.png", ":cowboy_hat_face:", ":cowboy:", "Smileys & Emotion", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd21", "1f921.png", ":clown_face:", ":clown:", "Smileys & Emotion", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd22", "1f922.png", ":nauseated_face:", null, "Smileys & Emotion", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd23", "1f923.png", ":rofl:", ":rolling_on_the_floor_laughing:", "Smileys & Emotion", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd24", "1f924.png", ":drooling_face:", null, "Smileys & Emotion", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd25", "1f925.png", ":lying_face:", null, "Smileys & Emotion", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd26\ud83c\udffb", "1f926-1f3fb.png", ":facepalm_tone1:", ":person_facepalming_tone1:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd26\ud83c\udffc", "1f926-1f3fc.png", ":facepalm_tone2:", ":person_facepalming_tone2:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd26\ud83c\udffd", "1f926-1f3fd.png", ":facepalm_tone3:", ":person_facepalming_tone3:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd26\ud83c\udffe", "1f926-1f3fe.png", ":facepalm_tone4:", ":person_facepalming_tone4:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd26\ud83c\udfff", "1f926-1f3ff.png", ":facepalm_tone5:", ":person_facepalming_tone5:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd26", "1f926.png", ":facepalm:", ":person_facepalming:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd27", "1f927.png", ":sneezing_face:", null, "Smileys & Emotion", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd30\ud83c\udffb", "1f930-1f3fb.png", ":pregnant_woman_tone1:", ":pregnant_woman_light_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd30\ud83c\udffc", "1f930-1f3fc.png", ":pregnant_woman_tone2:", ":pregnant_woman_medium_light_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd30\ud83c\udffd", "1f930-1f3fd.png", ":pregnant_woman_tone3:", ":pregnant_woman_medium_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd30\ud83c\udffe", "1f930-1f3fe.png", ":pregnant_woman_tone4:", ":pregnant_woman_medium_dark_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd30\ud83c\udfff", "1f930-1f3ff.png", ":pregnant_woman_tone5:", ":pregnant_woman_dark_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd30", "1f930.png", ":pregnant_woman:", null, "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd33\ud83c\udffb", "1f933-1f3fb.png", ":selfie_tone1:", ":selfie_light_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd33\ud83c\udffc", "1f933-1f3fc.png", ":selfie_tone2:", ":selfie_medium_light_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd33\ud83c\udffd", "1f933-1f3fd.png", ":selfie_tone3:", ":selfie_medium_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd33\ud83c\udffe", "1f933-1f3fe.png", ":selfie_tone4:", ":selfie_medium_dark_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd33\ud83c\udfff", "1f933-1f3ff.png", ":selfie_tone5:", ":selfie_dark_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd33", "1f933.png", ":selfie:", null, "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd34\ud83c\udffb", "1f934-1f3fb.png", ":prince_tone1:", ":prince_light_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd34\ud83c\udffc", "1f934-1f3fc.png", ":prince_tone2:", ":prince_medium_light_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd34\ud83c\udffd", "1f934-1f3fd.png", ":prince_tone3:", ":prince_medium_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd34\ud83c\udffe", "1f934-1f3fe.png", ":prince_tone4:", ":prince_medium_dark_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd34\ud83c\udfff", "1f934-1f3ff.png", ":prince_tone5:", ":prince_dark_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd34", "1f934.png", ":prince:", null, "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd35\ud83c\udffb", "1f935-1f3fb.png", ":person_in_tuxedo_tone1:", ":person_in_tuxedo_light_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd35\ud83c\udffc", "1f935-1f3fc.png", ":person_in_tuxedo_tone2:", ":person_in_tuxedo_medium_light_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd35\ud83c\udffd", "1f935-1f3fd.png", ":person_in_tuxedo_tone3:", ":person_in_tuxedo_medium_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd35\ud83c\udffe", "1f935-1f3fe.png", ":person_in_tuxedo_tone4:", ":person_in_tuxedo_medium_dark_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd35\ud83c\udfff", "1f935-1f3ff.png", ":person_in_tuxedo_tone5:", ":person_in_tuxedo_dark_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd35", "1f935.png", ":person_in_tuxedo:", null, "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd36\ud83c\udffb", "1f936-1f3fb.png", ":mrs_claus_tone1:", ":mrs_claus_light_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd36\ud83c\udffc", "1f936-1f3fc.png", ":mrs_claus_tone2:", ":mrs_claus_medium_light_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd36\ud83c\udffd", "1f936-1f3fd.png", ":mrs_claus_tone3:", ":mrs_claus_medium_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd36\ud83c\udffe", "1f936-1f3fe.png", ":mrs_claus_tone4:", ":mrs_claus_medium_dark_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd36\ud83c\udfff", "1f936-1f3ff.png", ":mrs_claus_tone5:", ":mrs_claus_dark_skin_tone:", "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd36", "1f936.png", ":mrs_claus:", null, "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd37\ud83c\udffb", "1f937-1f3fb.png", ":shrug_tone1:", ":person_shrugging_tone1:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd37\ud83c\udffc", "1f937-1f3fc.png", ":shrug_tone2:", ":person_shrugging_tone2:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd37\ud83c\udffd", "1f937-1f3fd.png", ":shrug_tone3:", ":person_shrugging_tone3:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd37\ud83c\udffe", "1f937-1f3fe.png", ":shrug_tone4:", ":person_shrugging_tone4:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd37\ud83c\udfff", "1f937-1f3ff.png", ":shrug_tone5:", ":person_shrugging_tone5:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd37", "1f937.png", ":shrug:", ":person_shrugging:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd38\ud83c\udffb", "1f938-1f3fb.png", ":cartwheeling_tone1:", ":person_doing_cartwheel_tone1:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd38\ud83c\udffc", "1f938-1f3fc.png", ":cartwheeling_tone2:", ":person_doing_cartwheel_tone2:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd38\ud83c\udffd", "1f938-1f3fd.png", ":cartwheeling_tone3:", ":person_doing_cartwheel_tone3:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd38\ud83c\udffe", "1f938-1f3fe.png", ":cartwheeling_tone4:", ":person_doing_cartwheel_tone4:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd38\ud83c\udfff", "1f938-1f3ff.png", ":cartwheeling_tone5:", ":person_doing_cartwheel_tone5:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd38", "1f938.png", ":cartwheeling:", ":person_doing_cartwheel:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd39\ud83c\udffb", "1f939-1f3fb.png", ":juggling_person_tone1:", ":person_juggling_tone1:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd39\ud83c\udffc", "1f939-1f3fc.png", ":juggling_person_tone2:", ":person_juggling_tone2:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd39\ud83c\udffd", "1f939-1f3fd.png", ":juggling_person_tone3:", ":person_juggling_tone3:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd39\ud83c\udffe", "1f939-1f3fe.png", ":juggling_person_tone4:", ":person_juggling_tone4:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd39\ud83c\udfff", "1f939-1f3ff.png", ":juggling_person_tone5:", ":person_juggling_tone5:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd39", "1f939.png", ":juggling_person:", ":person_juggling:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3a", "1f93a.png", ":person_fencing:", null, "People & Body", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd3c\ud83c\udffb", "1f93c-1f3fb.png", ":wrestling_tone1:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3c\ud83c\udffc", "1f93c-1f3fc.png", ":wrestling_tone2:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3c\ud83c\udffd", "1f93c-1f3fd.png", ":wrestling_tone3:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3c\ud83c\udffe", "1f93c-1f3fe.png", ":wrestling_tone4:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3c\ud83c\udfff", "1f93c-1f3ff.png", ":wrestling_tone5:", null, "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3c", "1f93c.png", ":wrestling:", ":people_wrestling:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3d\ud83c\udffb", "1f93d-1f3fb.png", ":water_polo_tone1:", ":person_playing_water_polo_tone1:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3d\ud83c\udffc", "1f93d-1f3fc.png", ":water_polo_tone2:", ":person_playing_water_polo_tone2:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3d\ud83c\udffd", "1f93d-1f3fd.png", ":water_polo_tone3:", ":person_playing_water_polo_tone3:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3d\ud83c\udffe", "1f93d-1f3fe.png", ":water_polo_tone4:", ":person_playing_water_polo_tone4:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3d\ud83c\udfff", "1f93d-1f3ff.png", ":water_polo_tone5:", ":person_playing_water_polo_tone5:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3d", "1f93d.png", ":water_polo:", ":person_playing_water_polo:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3e\ud83c\udffb", "1f93e-1f3fb.png", ":handball_person_tone1:", ":person_playing_handball_tone1:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3e\ud83c\udffc", "1f93e-1f3fc.png", ":handball_person_tone2:", ":person_playing_handball_tone2:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3e\ud83c\udffd", "1f93e-1f3fd.png", ":handball_person_tone3:", ":person_playing_handball_tone3:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3e\ud83c\udffe", "1f93e-1f3fe.png", ":handball_person_tone4:", ":person_playing_handball_tone4:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3e\ud83c\udfff", "1f93e-1f3ff.png", ":handball_person_tone5:", ":person_playing_handball_tone5:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd3e", "1f93e.png", ":handball_person:", ":person_playing_handball:", "People & Body", "11.0");
        EmojiUtil.add(set, result, "\ud83e\udd40", "1f940.png", ":wilted_flower:", ":wilted_rose:", "Animals & Nature", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd41", "1f941.png", ":drum:", null, "Objects", "");
        EmojiUtil.add(set, result, "\ud83e\udd42", "1f942.png", ":clinking_glasses:", ":champagne_glass:", "Food & Drink", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd43", "1f943.png", ":tumbler_glass:", null, "Food & Drink", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd44", "1f944.png", ":spoon:", null, "Food & Drink", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd45", "1f945.png", ":goal_net:", ":goal:", "Activities", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd47", "1f947.png", ":1st_place_medal:", ":first_place:", "Activities", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd48", "1f948.png", ":2nd_place_medal:", ":second_place:", "Activities", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd49", "1f949.png", ":3rd_place_medal:", ":third_place:", "Activities", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd4a", "1f94a.png", ":boxing_glove:", null, "Activities", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd4b", "1f94b.png", ":martial_arts_uniform:", null, "Activities", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd50", "1f950.png", ":croissant:", null, "Food & Drink", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd51", "1f951.png", ":avocado:", null, "Food & Drink", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd52", "1f952.png", ":cucumber:", null, "Food & Drink", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd53", "1f953.png", ":bacon:", null, "Food & Drink", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd54", "1f954.png", ":potato:", null, "Food & Drink", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd55", "1f955.png", ":carrot:", null, "Food & Drink", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd56", "1f956.png", ":baguette_bread:", ":french_bread:", "Food & Drink", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd57", "1f957.png", ":green_salad:", ":salad:", "Food & Drink", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd58", "1f958.png", ":shallow_pan_of_food:", null, "Food & Drink", "");
        EmojiUtil.add(set, result, "\ud83e\udd59", "1f959.png", ":stuffed_flatbread:", null, "Food & Drink", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd5a", "1f95a.png", ":egg:", null, "Food & Drink", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd5b", "1f95b.png", ":milk_glass:", ":milk:", "Food & Drink", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd5c", "1f95c.png", ":peanuts:", null, "Food & Drink", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd5d", "1f95d.png", ":kiwi_fruit:", ":kiwi:", "Food & Drink", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd5e", "1f95e.png", ":pancakes:", null, "Food & Drink", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd80", "1f980.png", ":crab:", null, "Food & Drink", "8.0");
        EmojiUtil.add(set, result, "\ud83e\udd81", "1f981.png", ":lion:", ":lion_face:", "Animals & Nature", "8.0");
        EmojiUtil.add(set, result, "\ud83e\udd82", "1f982.png", ":scorpion:", null, "Animals & Nature", "8.0");
        EmojiUtil.add(set, result, "\ud83e\udd83", "1f983.png", ":turkey:", null, "Animals & Nature", "8.0");
        EmojiUtil.add(set, result, "\ud83e\udd84", "1f984.png", ":unicorn:", null, "Animals & Nature", "8.0");
        EmojiUtil.add(set, result, "\ud83e\udd85", "1f985.png", ":eagle:", null, "Animals & Nature", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd86", "1f986.png", ":duck:", null, "Animals & Nature", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd87", "1f987.png", ":bat:", null, "Animals & Nature", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd88", "1f988.png", ":shark:", null, "Animals & Nature", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd89", "1f989.png", ":owl:", null, "Animals & Nature", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd8a", "1f98a.png", ":fox_face:", ":fox:", "Animals & Nature", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd8b", "1f98b.png", ":butterfly:", null, "Animals & Nature", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd8c", "1f98c.png", ":deer:", null, "Animals & Nature", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd8d", "1f98d.png", ":gorilla:", null, "Animals & Nature", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd8e", "1f98e.png", ":lizard:", null, "Animals & Nature", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd8f", "1f98f.png", ":rhinoceros:", ":rhino:", "Animals & Nature", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd90", "1f990.png", ":shrimp:", null, "Food & Drink", "9.0");
        EmojiUtil.add(set, result, "\ud83e\udd91", "1f991.png", ":squid:", null, "Food & Drink", "9.0");
        EmojiUtil.add(set, result, "\ud83e\uddc0", "1f9c0.png", ":cheese:", ":cheese_wedge:", "Food & Drink", "8.0");
        EmojiUtil.add(set, result, "\u203c", "203c.png", ":bangbang:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2049", "2049.png", ":interrobang:", null, "Symbols", "3.0");
        EmojiUtil.add(set, result, "\u2139", "2139.png", ":information_source:", null, "Symbols", "3.0");
        EmojiUtil.add(set, result, "\u2194", "2194.png", ":left_right_arrow:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2195", "2195.png", ":arrow_up_down:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2196", "2196.png", ":arrow_upper_left:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2197", "2197.png", ":arrow_upper_right:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2198", "2198.png", ":arrow_lower_right:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2199", "2199.png", ":arrow_lower_left:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u21a9", "21a9.png", ":leftwards_arrow_with_hook:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u21aa", "21aa.png", ":arrow_right_hook:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u231a", "231a.png", ":watch:", null, "Travel & Places", "");
        EmojiUtil.add(set, result, "\u231b", "231b.png", ":hourglass:", ":hourglass_done:", "Travel & Places", "");
        EmojiUtil.add(set, result, "\u2328", "2328.png", ":keyboard:", null, "Objects", "");
        EmojiUtil.add(set, result, "\u23cf", "23cf.png", ":eject_button:", ":eject:", "Symbols", "11.0");
        EmojiUtil.add(set, result, "\u23e9", "23e9.png", ":fast_forward:", ":fast_forward_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\u23ea", "23ea.png", ":rewind:", ":fast_reverse_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\u23eb", "23eb.png", ":arrow_double_up:", ":fast_up_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\u23ec", "23ec.png", ":arrow_double_down:", ":fast_down_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\u23ed", "23ed.png", ":next_track_button:", ":track_next:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\u23ee", "23ee.png", ":previous_track_button:", ":track_previous:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\u23ef", "23ef.png", ":play_or_pause_button:", ":play_pause:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\u23f0", "23f0.png", ":alarm_clock:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\u23f1", "23f1.png", ":stopwatch:", null, "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\u23f2", "23f2.png", ":timer_clock:", ":timer:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\u23f3", "23f3.png", ":hourglass_flowing_sand:", ":hourglass_not_done:", "Travel & Places", "6.0");
        EmojiUtil.add(set, result, "\u23f8", "23f8.png", ":pause_button:", null, "Symbols", "7.0");
        EmojiUtil.add(set, result, "\u23f9", "23f9.png", ":stop_button:", null, "Symbols", "7.0");
        EmojiUtil.add(set, result, "\u23fa", "23fa.png", ":record_button:", null, "Symbols", "7.0");
        EmojiUtil.add(set, result, "\u24c2", "24c2.png", ":m:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u25aa", "25aa.png", ":black_small_square:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u25ab", "25ab.png", ":white_small_square:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u25b6", "25b6.png", ":arrow_forward:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u25c0", "25c0.png", ":arrow_backward:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u25fb", "25fb.png", ":white_medium_square:", null, "Symbols", "3.2");
        EmojiUtil.add(set, result, "\u25fc", "25fc.png", ":black_medium_square:", null, "Symbols", "3.2");
        EmojiUtil.add(set, result, "\u25fd", "25fd.png", ":white_medium_small_square:", null, "Symbols", "3.2");
        EmojiUtil.add(set, result, "\u25fe", "25fe.png", ":black_medium_small_square:", null, "Symbols", "3.2");
        EmojiUtil.add(set, result, "\u2600", "2600.png", ":sunny:", null, "Travel & Places", "");
        EmojiUtil.add(set, result, "\u2601", "2601.png", ":cloud:", null, "Travel & Places", "");
        EmojiUtil.add(set, result, "\u2602", "2602.png", ":open_umbrella:", ":umbrella2:", "Travel & Places", "");
        EmojiUtil.add(set, result, "\u2603", "2603.png", ":snowman_with_snow:", ":snowman2:", "Travel & Places", "");
        EmojiUtil.add(set, result, "\u2604", "2604.png", ":comet:", null, "Travel & Places", "");
        EmojiUtil.add(set, result, "\u260e", "260e.png", ":phone:", ":telephone:", "Objects", "");
        EmojiUtil.add(set, result, "\u2611", "2611.png", ":ballot_box_with_check:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2614", "2614.png", ":umbrella:", ":umbrella_with_rain_drops:", "Travel & Places", "4.0");
        EmojiUtil.add(set, result, "\u2615", "2615.png", ":coffee:", ":hot_beverage:", "Food & Drink", "4.0");
        EmojiUtil.add(set, result, "\u2618", "2618.png", ":shamrock:", null, "Animals & Nature", "4.1");
        EmojiUtil.add(set, result, "\u261d\ud83c\udffb", "261d-1f3fb.png", ":point_up_tone1:", ":index_pointing_up_light_skin_tone:", "People & Body", "");
        EmojiUtil.add(set, result, "\u261d\ud83c\udffc", "261d-1f3fc.png", ":point_up_tone2:", ":index_pointing_up_medium_light_skin_tone:", "People & Body", "");
        EmojiUtil.add(set, result, "\u261d\ud83c\udffd", "261d-1f3fd.png", ":point_up_tone3:", ":index_pointing_up_medium_skin_tone:", "People & Body", "");
        EmojiUtil.add(set, result, "\u261d\ud83c\udffe", "261d-1f3fe.png", ":point_up_tone4:", ":index_pointing_up_medium_dark_skin_tone:", "People & Body", "");
        EmojiUtil.add(set, result, "\u261d\ud83c\udfff", "261d-1f3ff.png", ":point_up_tone5:", ":index_pointing_up_dark_skin_tone:", "People & Body", "");
        EmojiUtil.add(set, result, "\u261d", "261d.png", ":point_up:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\u2620", "2620.png", ":skull_and_crossbones:", ":skull_crossbones:", "Smileys & Emotion", "");
        EmojiUtil.add(set, result, "\u2622", "2622.png", ":radioactive:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2623", "2623.png", ":biohazard:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2626", "2626.png", ":orthodox_cross:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u262a", "262a.png", ":star_and_crescent:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u262e", "262e.png", ":peace_symbol:", ":peace:", "Symbols", "");
        EmojiUtil.add(set, result, "\u262f", "262f.png", ":yin_yang:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2638", "2638.png", ":wheel_of_dharma:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2639", "2639.png", ":frowning_face:", ":frowning2:", "Smileys & Emotion", "");
        EmojiUtil.add(set, result, "\u263a", "263a.png", ":relaxed:", null, "Smileys & Emotion", "");
        EmojiUtil.add(set, result, "\u2648", "2648.png", ":aries:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2649", "2649.png", ":taurus:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u264a", "264a.png", ":gemini:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u264b", "264b.png", ":cancer:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u264c", "264c.png", ":leo:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u264d", "264d.png", ":virgo:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u264e", "264e.png", ":libra:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u264f", "264f.png", ":scorpius:", ":scorpio:", "Symbols", "");
        EmojiUtil.add(set, result, "\u2650", "2650.png", ":sagittarius:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2651", "2651.png", ":capricorn:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2652", "2652.png", ":aquarius:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2653", "2653.png", ":pisces:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2660", "2660.png", ":spades:", null, "Activities", "");
        EmojiUtil.add(set, result, "\u2663", "2663.png", ":clubs:", null, "Activities", "");
        EmojiUtil.add(set, result, "\u2665", "2665.png", ":hearts:", null, "Activities", "");
        EmojiUtil.add(set, result, "\u2666", "2666.png", ":diamonds:", null, "Activities", "");
        EmojiUtil.add(set, result, "\u2668", "2668.png", ":hotsprings:", null, "Travel & Places", "");
        EmojiUtil.add(set, result, "\u267b", "267b.png", ":recycle:", null, "Symbols", "3.2");
        EmojiUtil.add(set, result, "\u267f", "267f.png", ":wheelchair:", ":wheelchair_symbol:", "Symbols", "4.1");
        EmojiUtil.add(set, result, "\u2692", "2692.png", ":hammer_and_pick:", ":hammer_pick:", "Objects", "4.1");
        EmojiUtil.add(set, result, "\u2693", "2693.png", ":anchor:", null, "Travel & Places", "4.1");
        EmojiUtil.add(set, result, "\u2694", "2694.png", ":crossed_swords:", null, "Objects", "4.1");
        EmojiUtil.add(set, result, "\u2696", "2696.png", ":balance_scale:", ":scales:", "Objects", "4.1");
        EmojiUtil.add(set, result, "\u2697", "2697.png", ":alembic:", null, "Objects", "4.1");
        EmojiUtil.add(set, result, "\u2699", "2699.png", ":gear:", null, "Objects", "4.1");
        EmojiUtil.add(set, result, "\u269b", "269b.png", ":atom_symbol:", ":atom:", "Symbols", "4.1");
        EmojiUtil.add(set, result, "\u269c", "269c.png", ":fleur_de_lis:", ":fleur-de-lis:", "Symbols", "4.1");
        EmojiUtil.add(set, result, "\u26a0", "26a0.png", ":warning:", null, "Symbols", "4.0");
        EmojiUtil.add(set, result, "\u26a1", "26a1.png", ":zap:", ":high_voltage:", "Travel & Places", "4.0");
        EmojiUtil.add(set, result, "\u26aa", "26aa.png", ":white_circle:", null, "Symbols", "4.1");
        EmojiUtil.add(set, result, "\u26ab", "26ab.png", ":black_circle:", null, "Symbols", "4.1");
        EmojiUtil.add(set, result, "\u26b0", "26b0.png", ":coffin:", null, "Objects", "4.1");
        EmojiUtil.add(set, result, "\u26b1", "26b1.png", ":funeral_urn:", ":urn:", "Objects", "4.1");
        EmojiUtil.add(set, result, "\u26bd", "26bd.png", ":soccer:", ":soccer_ball:", "Activities", "5.2");
        EmojiUtil.add(set, result, "\u26be", "26be.png", ":baseball:", null, "Activities", "5.2");
        EmojiUtil.add(set, result, "\u26c4", "26c4.png", ":snowman:", ":snowman_without_snow:", "Travel & Places", "5.2");
        EmojiUtil.add(set, result, "\u26c5", "26c5.png", ":partly_sunny:", ":sun_behind_cloud:", "Travel & Places", "5.2");
        EmojiUtil.add(set, result, "\u26c8", "26c8.png", ":cloud_with_lightning_and_rain:", ":thunder_cloud_rain:", "Travel & Places", "5.2");
        EmojiUtil.add(set, result, "\u26ce", "26ce.png", ":ophiuchus:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\u26cf", "26cf.png", ":pick:", null, "Objects", "5.2");
        EmojiUtil.add(set, result, "\u26d1", "26d1.png", ":rescue_worker_helmet:", ":helmet_with_cross:", "Objects", "5.2");
        EmojiUtil.add(set, result, "\u26d3", "26d3.png", ":chains:", null, "Objects", "5.2");
        EmojiUtil.add(set, result, "\u26d4", "26d4.png", ":no_entry:", null, "Symbols", "5.2");
        EmojiUtil.add(set, result, "\u26e9", "26e9.png", ":shinto_shrine:", null, "Travel & Places", "5.2");
        EmojiUtil.add(set, result, "\u26ea", "26ea.png", ":church:", null, "Travel & Places", "5.2");
        EmojiUtil.add(set, result, "\u26f0", "26f0.png", ":mountain:", null, "Travel & Places", "5.2");
        EmojiUtil.add(set, result, "\u26f1", "26f1.png", ":parasol_on_ground:", null, "Travel & Places", "5.2");
        EmojiUtil.add(set, result, "\u26f2", "26f2.png", ":fountain:", null, "Travel & Places", "5.2");
        EmojiUtil.add(set, result, "\u26f3", "26f3.png", ":golf:", ":flag_in_hole:", "Activities", "5.2");
        EmojiUtil.add(set, result, "\u26f4", "26f4.png", ":ferry:", null, "Travel & Places", "5.2");
        EmojiUtil.add(set, result, "\u26f5", "26f5.png", ":boat:", ":sailboat:", "Travel & Places", "5.2");
        EmojiUtil.add(set, result, "\u26f7", "26f7.png", ":skier:", null, "People & Body", "5.2");
        EmojiUtil.add(set, result, "\u26f8", "26f8.png", ":ice_skate:", null, "Activities", "5.2");
        EmojiUtil.add(set, result, "\u26f9\ud83c\udffb", "26f9-1f3fb.png", ":bouncing_ball_person_tone1:", ":person_bouncing_ball_tone1:", "People & Body", "5.2");
        EmojiUtil.add(set, result, "\u26f9\ud83c\udffc", "26f9-1f3fc.png", ":bouncing_ball_person_tone2:", ":person_bouncing_ball_tone2:", "People & Body", "5.2");
        EmojiUtil.add(set, result, "\u26f9\ud83c\udffd", "26f9-1f3fd.png", ":bouncing_ball_person_tone3:", ":person_bouncing_ball_tone3:", "People & Body", "5.2");
        EmojiUtil.add(set, result, "\u26f9\ud83c\udffe", "26f9-1f3fe.png", ":bouncing_ball_person_tone4:", ":person_bouncing_ball_tone4:", "People & Body", "5.2");
        EmojiUtil.add(set, result, "\u26f9\ud83c\udfff", "26f9-1f3ff.png", ":bouncing_ball_person_tone5:", ":person_bouncing_ball_tone5:", "People & Body", "5.2");
        EmojiUtil.add(set, result, "\u26f9", "26f9.png", ":bouncing_ball_person:", ":person_bouncing_ball:", "People & Body", "5.2");
        EmojiUtil.add(set, result, "\u26fa", "26fa.png", ":tent:", null, "Travel & Places", "5.2");
        EmojiUtil.add(set, result, "\u26fd", "26fd.png", ":fuelpump:", ":fuel_pump:", "Travel & Places", "5.2");
        EmojiUtil.add(set, result, "\u2702", "2702.png", ":scissors:", null, "Objects", "");
        EmojiUtil.add(set, result, "\u2705", "2705.png", ":white_check_mark:", ":check_mark_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\u2708", "2708.png", ":airplane:", null, "Travel & Places", "");
        EmojiUtil.add(set, result, "\u2709", "2709.png", ":envelope:", null, "Objects", "");
        EmojiUtil.add(set, result, "\u270a\ud83c\udffb", "270a-1f3fb.png", ":fist_raised_tone1:", ":fist_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\u270a\ud83c\udffc", "270a-1f3fc.png", ":fist_raised_tone2:", ":fist_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\u270a\ud83c\udffd", "270a-1f3fd.png", ":fist_raised_tone3:", ":fist_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\u270a\ud83c\udffe", "270a-1f3fe.png", ":fist_raised_tone4:", ":fist_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\u270a\ud83c\udfff", "270a-1f3ff.png", ":fist_raised_tone5:", ":fist_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\u270a", "270a.png", ":fist_raised:", ":fist:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\u270b\ud83c\udffb", "270b-1f3fb.png", ":hand_tone1:", ":raised_hand_tone1:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\u270b\ud83c\udffc", "270b-1f3fc.png", ":hand_tone2:", ":raised_hand_tone2:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\u270b\ud83c\udffd", "270b-1f3fd.png", ":hand_tone3:", ":raised_hand_tone3:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\u270b\ud83c\udffe", "270b-1f3fe.png", ":hand_tone4:", ":raised_hand_tone4:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\u270b\ud83c\udfff", "270b-1f3ff.png", ":hand_tone5:", ":raised_hand_tone5:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\u270b", "270b.png", ":hand:", ":raised_hand:", "People & Body", "6.0");
        EmojiUtil.add(set, result, "\u270c\ud83c\udffb", "270c-1f3fb.png", ":v_tone1:", ":victory_hand_light_skin_tone:", "People & Body", "");
        EmojiUtil.add(set, result, "\u270c\ud83c\udffc", "270c-1f3fc.png", ":v_tone2:", ":victory_hand_medium_light_skin_tone:", "People & Body", "");
        EmojiUtil.add(set, result, "\u270c\ud83c\udffd", "270c-1f3fd.png", ":v_tone3:", ":victory_hand_medium_skin_tone:", "People & Body", "");
        EmojiUtil.add(set, result, "\u270c\ud83c\udffe", "270c-1f3fe.png", ":v_tone4:", ":victory_hand_medium_dark_skin_tone:", "People & Body", "");
        EmojiUtil.add(set, result, "\u270c\ud83c\udfff", "270c-1f3ff.png", ":v_tone5:", ":victory_hand_dark_skin_tone:", "People & Body", "");
        EmojiUtil.add(set, result, "\u270c", "270c.png", ":v:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\u270d\ud83c\udffb", "270d-1f3fb.png", ":writing_hand_tone1:", ":writing_hand_light_skin_tone:", "People & Body", "");
        EmojiUtil.add(set, result, "\u270d\ud83c\udffc", "270d-1f3fc.png", ":writing_hand_tone2:", ":writing_hand_medium_light_skin_tone:", "People & Body", "");
        EmojiUtil.add(set, result, "\u270d\ud83c\udffd", "270d-1f3fd.png", ":writing_hand_tone3:", ":writing_hand_medium_skin_tone:", "People & Body", "");
        EmojiUtil.add(set, result, "\u270d\ud83c\udffe", "270d-1f3fe.png", ":writing_hand_tone4:", ":writing_hand_medium_dark_skin_tone:", "People & Body", "");
        EmojiUtil.add(set, result, "\u270d\ud83c\udfff", "270d-1f3ff.png", ":writing_hand_tone5:", ":writing_hand_dark_skin_tone:", "People & Body", "");
        EmojiUtil.add(set, result, "\u270d", "270d.png", ":writing_hand:", null, "People & Body", "");
        EmojiUtil.add(set, result, "\u270f", "270f.png", ":pencil2:", null, "Objects", "");
        EmojiUtil.add(set, result, "\u2712", "2712.png", ":black_nib:", null, "Objects", "");
        EmojiUtil.add(set, result, "\u2714", "2714.png", ":heavy_check_mark:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2716", "2716.png", ":heavy_multiplication_x:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u271d", "271d.png", ":latin_cross:", ":cross:", "Symbols", "");
        EmojiUtil.add(set, result, "\u2721", "2721.png", ":star_of_david:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2728", "2728.png", ":sparkles:", null, "Activities", "6.0");
        EmojiUtil.add(set, result, "\u2733", "2733.png", ":eight_spoked_asterisk:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2734", "2734.png", ":eight_pointed_black_star:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2744", "2744.png", ":snowflake:", null, "Travel & Places", "");
        EmojiUtil.add(set, result, "\u2747", "2747.png", ":sparkle:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u274c", "274c.png", ":x:", ":cross_mark:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\u274e", "274e.png", ":negative_squared_cross_mark:", ":cross_mark_button:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\u2753", "2753.png", ":question:", ":red_question_mark:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\u2754", "2754.png", ":grey_question:", ":white_question_mark:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\u2755", "2755.png", ":grey_exclamation:", ":white_exclamation_mark:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\u2757", "2757.png", ":exclamation:", ":red_exclamation_mark:", "Symbols", "5.2");
        EmojiUtil.add(set, result, "\u2763", "2763.png", ":heavy_heart_exclamation:", ":heart_exclamation:", "Smileys & Emotion", "");
        EmojiUtil.add(set, result, "\u2764", "2764.png", ":heart:", null, "Smileys & Emotion", "");
        EmojiUtil.add(set, result, "\u2795", "2795.png", ":heavy_plus_sign:", ":plus:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\u2796", "2796.png", ":heavy_minus_sign:", ":minus:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\u2797", "2797.png", ":heavy_division_sign:", ":divide:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\u27a1", "27a1.png", ":arrow_right:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u27b0", "27b0.png", ":curly_loop:", null, "Symbols", "6.0");
        EmojiUtil.add(set, result, "\u27bf", "27bf.png", ":loop:", ":double_curly_loop:", "Symbols", "6.0");
        EmojiUtil.add(set, result, "\u2934", "2934.png", ":arrow_heading_up:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2935", "2935.png", ":arrow_heading_down:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u2b05", "2b05.png", ":arrow_left:", null, "Symbols", "4.0");
        EmojiUtil.add(set, result, "\u2b06", "2b06.png", ":arrow_up:", null, "Symbols", "4.0");
        EmojiUtil.add(set, result, "\u2b07", "2b07.png", ":arrow_down:", null, "Symbols", "4.0");
        EmojiUtil.add(set, result, "\u2b1b", "2b1b.png", ":black_large_square:", null, "Symbols", "5.1");
        EmojiUtil.add(set, result, "\u2b1c", "2b1c.png", ":white_large_square:", null, "Symbols", "5.1");
        EmojiUtil.add(set, result, "\u2b50", "2b50.png", ":star:", null, "Travel & Places", "5.1");
        EmojiUtil.add(set, result, "\u2b55", "2b55.png", ":o:", ":hollow_red_circle:", "Symbols", "5.2");
        EmojiUtil.add(set, result, "\u3030", "3030.png", ":wavy_dash:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u303d", "303d.png", ":part_alternation_mark:", null, "Symbols", "3.2");
        EmojiUtil.add(set, result, "\u3297", "3297.png", ":congratulations:", null, "Symbols", "");
        EmojiUtil.add(set, result, "\u3299", "3299.png", ":secret:", null, "Symbols", "");
    }

    public static enum EmojiSet {
        TWEMOJI("twemoji", "Twemoji (Twitter)", "twemoji/72x72/"),
        E1("e1", "Emoji One", "e1/png_64/");

        String id;
        String name;
        String internalPath;

        private EmojiSet(String id, String name, String path) {
            this.id = id;
            this.name = name;
            this.internalPath = path;
        }
    }
}

