/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.laf;

import chatty.gui.laf.LaF;
import chatty.util.MiscUtil;
import com.formdev.flatlaf.FlatPropertiesLaf;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.UIManager;

public class FlatLafUtil {
    public static final int TAB_SELECTED_BACKGROUND = 1;
    public static final int TAB_SEP = 2;
    public static final int TAB_SEP_FULL = 4;
    private static final Logger LOGGER = Logger.getLogger(FlatLafUtil.class.getName());

    protected static void loadFlatLaf(String baseTheme, final LaF.LaFSettings settings) throws Exception {
        Properties pCustom = new Properties();
        pCustom.load(new ByteArrayInputStream(settings.flatProperties.getBytes(Charset.forName("ISO-8859-1"))));
        boolean loadChattyProperties = !pCustom.getOrDefault((Object)"chattyProperties", "true").equals("false");
        Properties p = new Properties();
        if (loadChattyProperties) {
            p.load(FlatLafUtil.class.getResourceAsStream("FlatLaf.properties"));
        }
        if (MiscUtil.isBitEnabled(settings.flatTabs, 1L)) {
            p.put("TabbedPane.selectedBackground", "if(@optionalSelectedTabBackground, @optionalSelectedTabBackground, mix(@selectionBackground,$TabbedPane.background,15%))");
        }
        p.put("TabbedPane.showTabSeparators", String.valueOf(MiscUtil.isBitEnabled(settings.flatTabs, 2L)));
        p.put("TabbedPane.tabSeparatorsFullHeight", String.valueOf(MiscUtil.isBitEnabled(settings.flatTabs, 4L)));
        p.put("TitlePane.menuBarEmbedded", String.valueOf(settings.flatEmbeddedMenu));
        p.put("TitlePane.useWindowDecorations", String.valueOf(settings.flatStyledWindow));
        p.put("@baseTheme", baseTheme);
        p.putAll((Map<?, ?>)pCustom);
        FlatPropertiesLaf lookAndFeel = new FlatPropertiesLaf("Customized Flat LaF", p){

            @Override
            public void provideErrorFeedback(Component component) {
                if (settings.errorSound) {
                    super.provideErrorFeedback(component);
                }
            }
        };
        UIManager.setLookAndFeel(lookAndFeel);
    }
}

