/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.laf;

import chatty.gui.components.settings.SettingsDialog;
import chatty.gui.laf.FlatLafUtil;
import chatty.gui.laf.LaFCustomDefaults;
import chatty.gui.laf.LaFUtil;
import chatty.util.StringUtil;
import chatty.util.colors.ColorCorrectionNew;
import chatty.util.colors.HtmlColors;
import chatty.util.settings.Settings;
import com.jtattoo.plaf.aero.AeroLookAndFeel;
import com.jtattoo.plaf.fast.FastLookAndFeel;
import com.jtattoo.plaf.graphite.GraphiteLookAndFeel;
import com.jtattoo.plaf.hifi.HiFiLookAndFeel;
import com.jtattoo.plaf.luna.LunaLookAndFeel;
import com.jtattoo.plaf.mint.MintLookAndFeel;
import com.jtattoo.plaf.noire.NoireLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;

public class LaF {
    private static final Logger LOGGER = Logger.getLogger(LaF.class.getName());
    private static final Color TAB_FOREGROUND_HIGHLIGHT_LIGHT = new Color(255, 80, 0);
    private static final Color TAB_FOREGROUND_UNREAD_LIGHT = new Color(200, 0, 0);
    private static final Color TAB_FOREGROUND_HIGHLIGHT_DARK = new Color(255, 180, 40);
    private static final Color TAB_FOREGROUND_UNREAD_DARK = new Color(255, 80, 80);
    private static LaFSettings settings;
    private static String linkColor;
    private static boolean isDarkTheme;
    private static String lafClass;
    private static Color tabForegroundHighlight;
    private static Color tabForegroundUnread;
    private static Border inputBorder;
    private static boolean defaultButtonInsets;

    public static String getLinkColor() {
        return linkColor;
    }

    public static Color getTabForegroundUnread() {
        return tabForegroundUnread;
    }

    public static Color getTabForegroundHighlight() {
        return tabForegroundHighlight;
    }

    public static boolean isDarkTheme() {
        return isDarkTheme;
    }

    public static Border getInputBorder() {
        return inputBorder;
    }

    public static boolean defaultButtonInsets() {
        return defaultButtonInsets;
    }

    public static boolean shouldUpdate(String settingName) {
        List<String> settingNames = Arrays.asList("laf", "lafTheme", "lafScroll", "lafForeground", "lafBackground", "lafStyle", "lafCustomTheme", "lafGradient", "lafVariant", "lafNativeWindow", "lafFlatProperties", "lafFlatStyledWindow", "lafFlatEmbeddedMenu", "lafFlatTabs", "lafErrorSound");
        return settingNames.contains(settingName);
    }

    public static LaFSettings getSettings() {
        return settings;
    }

    public static String setLookAndFeel(LaFSettings settings) {
        LaFUtil.resetDefaults();
        inputBorder = null;
        LaF.settings = settings;
        String lafCode = settings.lafCode;
        String theme = settings.theme;
        try {
            String laf = null;
            MetalLookAndFeel lafInstance = null;
            if (lafCode.startsWith(":")) {
                laf = lafCode.substring(1);
            } else {
                block16 : switch (lafCode) {
                    case "system": {
                        laf = UIManager.getSystemLookAndFeelClassName();
                        break;
                    }
                    case "hifi": {
                        laf = "com.jtattoo.plaf.hifi.HiFiLookAndFeel";
                        Properties p1 = LaF.prepareTheme(HiFiLookAndFeel.getThemeProperties(theme));
                        p1.put("selectionBackgroundColor", "65 65 65");
                        HiFiLookAndFeel.setCurrentTheme(LaF.addCustom(p1));
                        break;
                    }
                    case "hifi2": {
                        laf = "com.jtattoo.plaf.hifi.HiFiLookAndFeel";
                        Properties p2 = LaF.prepareTheme(HiFiLookAndFeel.getThemeProperties(theme));
                        p2.put("backgroundColor", "50 52 51");
                        p2.put("foregroundColor", "180 190 185");
                        p2.put("menuForegroundColor", "200 210 204");
                        p2.put("menuBackgroundColor", "40 42 40");
                        p2.put("inputForegroundColor", "190 200 195");
                        p2.put("inputBackgroundColor", "60 64 62");
                        p2.put("buttonForegroundColor", "210 220 215");
                        p2.put("buttonColorLight", "96 96 96");
                        p2.put("buttonColorDark", "44 44 44");
                        p2.put("selectionBackgroundColor", "65 65 65");
                        HiFiLookAndFeel.setCurrentTheme(LaF.addCustom(p2));
                        break;
                    }
                    case "hifiCustom": {
                        laf = "com.jtattoo.plaf.hifi.HiFiLookAndFeel";
                        Properties p4 = LaF.prepareTheme(HiFiLookAndFeel.getThemeProperties(theme));
                        LaF.customColors(p4);
                        HiFiLookAndFeel.setCurrentTheme(LaF.addCustom(p4));
                        break;
                    }
                    case "mint": {
                        laf = "com.jtattoo.plaf.mint.MintLookAndFeel";
                        MintLookAndFeel.setCurrentTheme(LaF.addCustom(LaF.prepareTheme(MintLookAndFeel.getThemeProperties(theme))));
                        break;
                    }
                    case "noire": {
                        laf = "com.jtattoo.plaf.noire.NoireLookAndFeel";
                        NoireLookAndFeel.setCurrentTheme(LaF.addCustom(LaF.prepareTheme(NoireLookAndFeel.getThemeProperties(theme))));
                        break;
                    }
                    case "graphite": {
                        laf = "com.jtattoo.plaf.graphite.GraphiteLookAndFeel";
                        GraphiteLookAndFeel.setCurrentTheme(LaF.addCustom(LaF.prepareTheme(GraphiteLookAndFeel.getThemeProperties(theme))));
                        break;
                    }
                    case "fast": {
                        laf = "com.jtattoo.plaf.fast.FastLookAndFeel";
                        FastLookAndFeel.setCurrentTheme(LaF.addCustom(LaF.prepareTheme(FastLookAndFeel.getThemeProperties(theme))));
                        break;
                    }
                    case "aero": {
                        laf = "com.jtattoo.plaf.aero.AeroLookAndFeel";
                        AeroLookAndFeel.setCurrentTheme(LaF.addCustom(LaF.prepareTheme(AeroLookAndFeel.getThemeProperties(theme))));
                        break;
                    }
                    case "luna": {
                        laf = "com.jtattoo.plaf.luna.LunaLookAndFeel";
                        LunaLookAndFeel.setCurrentTheme(LaF.addCustom(LaF.prepareTheme(LunaLookAndFeel.getThemeProperties(theme))));
                        break;
                    }
                    case "nimbus": {
                        for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                            if (!"Nimbus".equals(info.getName())) continue;
                            laf = info.getClassName();
                            break block16;
                        }
                        break;
                    }
                    case "flatdark": {
                        FlatLafUtil.loadFlatLaf("dark", settings);
                        laf = null;
                        defaultButtonInsets = true;
                        break;
                    }
                    case "flatlight": {
                        FlatLafUtil.loadFlatLaf("light", settings);
                        laf = null;
                        defaultButtonInsets = true;
                        break;
                    }
                    default: {
                        laf = UIManager.getCrossPlatformLookAndFeelClassName();
                        if (!settings.errorSound) {
                            lafInstance = new MetalLookAndFeel(){

                                @Override
                                public void provideErrorFeedback(Component component) {
                                }
                            };
                        }
                        MetalLookAndFeel.setCurrentTheme(new OceanTheme());
                    }
                }
            }
            LOGGER.info("[LAF] Set " + lafCode + "/" + theme + " [" + laf + "]");
            if (lafInstance != null) {
                UIManager.setLookAndFeel(lafInstance);
                lafClass = laf;
            } else if (laf != null) {
                UIManager.setLookAndFeel(laf);
                lafClass = laf;
            }
            LaF.modifyDefaults();
        }
        catch (Exception ex) {
            LOGGER.warning("[LAF] Failed setting LAF: " + ex);
            return ex.getLocalizedMessage();
        }
        isDarkTheme = LaF.determineDarkTheme();
        if (isDarkTheme) {
            linkColor = "#EEEEEE";
            tabForegroundHighlight = TAB_FOREGROUND_HIGHLIGHT_DARK;
            tabForegroundUnread = TAB_FOREGROUND_UNREAD_DARK;
        } else {
            linkColor = "#0000FF";
            tabForegroundHighlight = TAB_FOREGROUND_HIGHLIGHT_LIGHT;
            tabForegroundUnread = TAB_FOREGROUND_UNREAD_LIGHT;
        }
        LaF.loadOtherCustom();
        return null;
    }

    private static boolean determineDarkTheme() {
        Color color = UIManager.getColor("Panel.background");
        return color != null && ColorCorrectionNew.getLightness(color) < 128;
    }

    /*
     * WARNING - void declaration
     */
    private static void modifyDefaults() {
        LaFUtil.putDefault("TabbedPane.tabRunOverlay", 0);
        LaFUtil.putDefault("TabbedPane.rotateTabRuns", false);
        try {
            if (lafClass != null && lafClass.equals(UIManager.getSystemLookAndFeelClassName())) {
                Object font = UIManager.getLookAndFeelDefaults().get("TextField.font");
                UIManager.getLookAndFeelDefaults().put("TextArea.font", font);
                UIManager.getDefaults().put("TextArea.font", font);
                LOGGER.info("[LAF] Changed TextArea.font to " + font);
            }
        }
        catch (Exception ex) {
            LOGGER.warning("[LAF] Failed to change TextArea.font: " + ex);
        }
        int fontScale = LaF.settings.fontScale;
        if (fontScale != 100 && fontScale >= 10 && fontScale <= 200) {
            LOGGER.info("[LAF] Applying font scale " + fontScale);
            LaFUtil.modifyDefaults((k, v) -> {
                if (v instanceof FontUIResource) {
                    FontUIResource font = (FontUIResource)v;
                    int step = (fontScale - 100) / 10;
                    int fontSize = font.getSize() + step;
                    return new FontUIResource(font.getFamily(), font.getStyle(), fontSize);
                }
                return null;
            });
        }
        if (!StringUtil.isNullOrEmpty(LaF.settings.scroll)) {
            void var2_8;
            String string = LaF.settings.scroll;
            int n = -1;
            switch (string.hashCode()) {
                case 3560192: {
                    if (!string.equals("tiny")) break;
                    boolean bl = false;
                    break;
                }
                case -2097775628: {
                    if (!string.equals("smaller")) break;
                    boolean bl = true;
                    break;
                }
                case 109548807: {
                    if (!string.equals("small")) break;
                    int n2 = 2;
                }
            }
            switch (var2_8) {
                case 0: {
                    LaFUtil.putDefault("ScrollBar.width", 8);
                    break;
                }
                case 1: {
                    LaFUtil.putDefault("ScrollBar.width", 10);
                    break;
                }
                case 2: {
                    LaFUtil.putDefault("ScrollBar.width", 15);
                }
            }
        }
        for (Map.Entry entry : LaF.settings.custom.entrySet()) {
            if (!((String)entry.getKey()).startsWith("$")) continue;
            String key = ((String)entry.getKey()).substring(1);
            try {
                Object value = LaFCustomDefaults.fromString((String)entry.getValue());
                if (key.isEmpty() || value == null) continue;
                LaFUtil.putDefault(key, value);
            }
            catch (Exception ex) {
                LOGGER.warning("[LAF] Invalid custom: " + entry);
            }
        }
    }

    public static void updateLookAndFeel() {
        LaFUtil.updateLookAndFeel();
    }

    private static Properties prepareTheme(Properties properties) {
        properties = properties == null ? new Properties() : new Properties(properties);
        properties.put("logoString", "");
        properties.put("backgroundPattern", "off");
        if (!StringUtil.isNullOrEmpty(LaF.settings.scroll)) {
            switch (LaF.settings.scroll) {
                case "tiny": 
                case "smaller": {
                    properties.put("macStyleScrollBar", "on");
                }
            }
        }
        if (LaF.settings.nativeWindow) {
            properties.put("windowDecoration", "off");
        }
        properties.put("provideErrorFeedback", LaF.settings.errorSound ? "on" : "off");
        return properties;
    }

    private static Properties addCustom(Properties properties) {
        if (!LaF.settings.custom.isEmpty()) {
            properties.putAll(LaF.settings.custom);
            LOGGER.info("[LAF] Set Custom: " + LaF.settings.custom);
        }
        return properties;
    }

    private static void loadOtherCustom() {
        if (settings != null) {
            Object border;
            tabForegroundHighlight = LaF.loadCustomColor("cTabForegroundHighlight", tabForegroundHighlight);
            tabForegroundUnread = LaF.loadCustomColor("cTabForegroundUnread", tabForegroundUnread);
            if (LaF.settings.custom.containsKey("cInputBorder") && (border = LaFCustomDefaults.fromString(LaF.settings.custom.get("cInputBorder"))) instanceof Border) {
                inputBorder = (Border)border;
            }
        }
    }

    private static Color loadCustomColor(String key, Color defaultValue) {
        String value = LaF.settings.custom.get(key);
        if (value != null) {
            return LaFUtil.parseColor(value, defaultValue);
        }
        return defaultValue;
    }

    private static void customColors(Properties p) {
        if (settings == null) {
            return;
        }
        Color bg = LaF.settings.bg;
        Color fg = LaF.settings.fg;
        float gradient = (float)((double)LaF.settings.gradient / 100.0);
        float contrast = 1.0f;
        switch (LaF.settings.variant) {
            case 1: {
                contrast = 0.5f;
                break;
            }
            case 2: {
                contrast = 1.5f;
                break;
            }
            case 3: {
                contrast = 2.0f;
                break;
            }
            case 4: {
                contrast = 2.5f;
            }
        }
        float contrastLight = (float)((double)contrast + (double)(1.0f - contrast) * 0.5);
        float contrastLighter = (float)((double)contrast + (double)(1.0f - contrast) * 0.7);
        float titleBgC = 0.0f;
        float inactiveTitleBgC = 0.0f;
        float activeGradient = 0.0f;
        float frameFgC = -0.63f;
        float frame2FgC = -0.45f;
        float controlBgC = 0.03f;
        float buttonBgC = 0.03f;
        float menuBgC = 0.0f;
        int tabSeparatorStyle = 0;
        boolean minimalistic = false;
        Color lighterFg = LaF.changeColor(fg, 0.3f * contrastLight);
        Color activeTitleFg = LaF.changeColor(lighterFg, 0.0f);
        Color inactiveTitleFg = LaF.changeColor(fg, -0.3f);
        switch (LaF.settings.style) {
            case "classic": {
                titleBgC = -0.05f;
                inactiveTitleBgC = -0.12f;
                activeGradient = 0.12f;
                inactiveTitleFg = fg;
                menuBgC = -0.1f;
                activeTitleFg = LaF.changeColor(fg, 0.7f);
                controlBgC = -0.1f;
                buttonBgC = 0.0f;
                tabSeparatorStyle = 1;
                break;
            }
            case "classicStrong": {
                titleBgC = -0.2f;
                inactiveTitleBgC = -0.4f;
                activeGradient = 0.12f;
                inactiveTitleFg = fg;
                menuBgC = -0.18f;
                activeTitleFg = LaF.changeColor(fg, 0.7f);
                frameFgC = -0.7f;
                frame2FgC = -0.6f;
                controlBgC = -0.3f;
                buttonBgC = -0.05f;
                break;
            }
            case "regular": {
                titleBgC = -0.1f;
                inactiveTitleBgC = -0.1f;
                if (LaF.settings.variant <= 2) break;
                controlBgC = -0.02f;
                contrast -= 0.5f;
                break;
            }
            case "regularStrong": {
                titleBgC = -0.2f;
                inactiveTitleBgC = -0.2f;
                controlBgC = -0.1f;
                break;
            }
            case "simple": {
                buttonBgC = 0.0f;
                break;
            }
            case "sleek": {
                buttonBgC = 0.0f;
                menuBgC = 0.05f;
                minimalistic = true;
                break;
            }
            case "minimal": {
                buttonBgC = 0.0f;
                minimalistic = true;
            }
        }
        titleBgC *= contrast;
        inactiveTitleBgC *= contrast;
        activeGradient *= contrast;
        frameFgC *= contrastLight;
        frame2FgC *= contrastLight;
        controlBgC *= contrastLight;
        buttonBgC *= contrast;
        menuBgC *= contrastLight;
        Color titleBg = LaF.changeColor(bg, titleBgC);
        Color inactiveTitleBg = LaF.changeColor(bg, inactiveTitleBgC);
        LaF.setColor(p, "windowInactiveTitleForegroundColor", inactiveTitleFg);
        LaF.setColorG(p, "windowInactiveTitleColor", inactiveTitleBg, 0.0f, gradient);
        LaF.setColor(p, "windowTitleForegroundColor", activeTitleFg);
        LaF.setColorG(p, "windowTitleColor", titleBg, 0.0f, gradient + activeGradient);
        if (minimalistic) {
            LaF.setColor(p, "windowInnerBorderColor", bg);
            LaF.setColor(p, "windowInactiveInnerBorderColor", bg);
        }
        LaF.setColor(p, "windowIconColor", inactiveTitleFg);
        LaF.setColor(p, "windowIconRolloverColor", activeTitleFg);
        LaF.setColor(p, "windowBorderColor", bg, -0.4f * contrastLight);
        LaF.setColor(p, "windowInactiveBorderColor", bg, -0.4f * contrastLight);
        if (minimalistic) {
            LaFUtil.putDefault("ScrollPane.border", LaFCustomDefaults.EMPTY_BORDER);
            inputBorder = (Border)LaFCustomDefaults.fromString("border(1)");
        }
        if (LaF.settings.style.equals("simple")) {
            inputBorder = new LaFCustomDefaults.UIResourceMatteBorder(0, 1, 1, 1, LaF.changeColor(bg, frameFgC));
        }
        LaF.setColor(p, "frameColor", bg, frameFgC);
        LaF.setColor(p, "frameColor2", bg, frame2FgC);
        LaF.setColor(p, "foregroundColor", fg, 0.0f);
        LaF.setColor(p, "backgroundColor", bg);
        LaF.setColor(p, "disabledBackgroundColor", bg, -0.04f);
        LaF.setColor(p, "disabledForegroundColor", fg, -0.4f);
        LaF.setColor(p, "menuForegroundColor", lighterFg);
        LaF.setColor(p, "menuBackgroundColor", bg, menuBgC);
        LaF.setColor(p, "menuSelectionForegroundColor", lighterFg, 0.4f * contrastLight);
        LaF.setColor(p, "menuSelectionBackgroundColor", bg, 0.2f * contrastLight);
        Color controlColor = LaF.changeColor(bg, controlBgC);
        Color buttonColor = LaF.changeColor(bg, buttonBgC);
        LaF.setColorG(p, "buttonColor", buttonColor, 0.0f, gradient);
        LaF.setColor(p, "buttonForegroundColor", lighterFg);
        LaF.setColorG(p, "pressedBackgroundColor", buttonColor, 0.05f, gradient);
        LaF.setColor(p, "rolloverForegroundColor", lighterFg, 0.4f * contrastLight);
        LaF.setColorG(p, "rolloverColor", controlColor, 0.1f * contrastLight, gradient * 1.4f);
        LaF.setColor(p, "inputForegroundColor", fg, 0.0f);
        LaF.setColor(p, "selectionBackgroundColor", bg, 0.2f);
        Color inputBg = LaF.changeColor(bg, 0.07f * contrastLight);
        LaF.setColor(p, "inputBackgroundColor", inputBg);
        LaF.setColor(p, "focusBackgroundColor", inputBg);
        LaF.setColor(p, "controlForegroundColor", lighterFg);
        LaF.setColorG(p, "controlColor", controlColor, 0.0f, gradient * 1.05f);
        LaF.setColorG(p, "inactiveColor", controlColor, 0.0f, gradient * 1.05f);
        LaF.setColor(p, "tabAreaBackgroundColor", bg);
        LaF.setColorG(p, "selectionBackgroundColor", LaF.changeColor(controlColor, 0.15f * contrastLighter), 0.0f, gradient * 1.7f);
        p.put("tabSeparatorStyle", String.valueOf(tabSeparatorStyle));
    }

    private static void setColor(Properties p, String property, Color base, float offset) {
        LaF.setColor(p, property, LaF.changeColor(base, offset));
    }

    private static void setColorG(Properties p, String property, Color base, float offset, float offsetG) {
        Color offsetBase = LaF.changeColor(base, offset);
        LaF.setColorG(p, property, LaF.changeColor(offsetBase, offsetG * 0.55f), LaF.changeColor(offsetBase, -offsetG * 0.4f));
    }

    private static void setColor(Properties p, String property, Color color) {
        p.put(property, String.format(Locale.ROOT, "%d %d %d", color.getRed(), color.getGreen(), color.getBlue()));
    }

    private static void setColorG(Properties p, String property, Color cl, Color cd) {
        p.put(property + "Light", String.format(Locale.ROOT, "%d %d %d", cl.getRed(), cl.getGreen(), cl.getBlue()));
        p.put(property + "Dark", String.format(Locale.ROOT, "%d %d %d", cd.getRed(), cd.getGreen(), cd.getBlue()));
    }

    private static Color changeColor(Color color, float change) {
        if (change > 1.0f) {
            change = 1.0f;
        }
        if (change < -1.0f) {
            change = -1.0f;
        }
        if (change < 0.0f) {
            return ColorCorrectionNew.makeDarker(color, 1.0f - Math.abs(change));
        }
        return ColorCorrectionNew.makeBrighter(color, change);
    }

    static {
        linkColor = "#0000FF";
        tabForegroundHighlight = TAB_FOREGROUND_HIGHLIGHT_LIGHT;
        tabForegroundUnread = TAB_FOREGROUND_UNREAD_LIGHT;
        defaultButtonInsets = false;
    }

    public static class LaFSettings {
        public final String lafCode;
        public final String theme;
        public final int fontScale;
        public final Map<String, String> custom;
        public final Color bg;
        public final Color fg;
        public final String style;
        public final int gradient;
        public final String scroll;
        public final int variant;
        public final boolean nativeWindow;
        public final boolean flatStyledWindow;
        public final boolean flatEmbeddedMenu;
        public final String flatProperties;
        public final long flatTabs;
        public final boolean errorSound;

        public LaFSettings(String lafCode, String theme, int fontScale, Map<String, String> custom, Color fg, Color bg, String style, int gradient, String scroll, int variant, boolean nativeWindow, boolean styledWindow, boolean embeddedMenu, String flatProperties, long flatSelectedTab, boolean errorSound) {
            this.lafCode = lafCode;
            this.theme = theme;
            this.fontScale = fontScale;
            this.custom = custom;
            this.fg = fg;
            this.bg = bg;
            this.style = style;
            this.gradient = gradient;
            this.scroll = scroll;
            this.variant = variant;
            this.nativeWindow = nativeWindow;
            this.flatStyledWindow = styledWindow;
            this.flatEmbeddedMenu = embeddedMenu;
            this.flatProperties = flatProperties;
            this.flatTabs = flatSelectedTab;
            this.errorSound = errorSound;
        }

        public static LaFSettings fromSettings(Settings settings) {
            return new LaFSettings(settings.getString("laf"), settings.getString("lafTheme"), (int)settings.getLong("lafFontScale"), settings.getMap("lafCustomTheme"), HtmlColors.decode(settings.getString("lafForeground"), Color.WHITE), HtmlColors.decode(settings.getString("lafBackground"), Color.BLACK), settings.getString("lafStyle"), (int)settings.getLong("lafGradient"), settings.getString("lafScroll"), (int)settings.getLong("lafVariant"), settings.getBoolean("lafNativeWindow"), settings.getBoolean("lafFlatStyledWindow"), settings.getBoolean("lafFlatEmbeddedMenu"), settings.getString("lafFlatProperties"), settings.getLong("lafFlatTabs"), settings.getBoolean("lafErrorSound"));
        }

        public static LaFSettings fromSettingsDialog(SettingsDialog d, Settings settings) {
            String lafCode = d.getStringSetting("laf");
            String lafTheme = d.getStringSetting("lafTheme");
            int lafFontScale = ((Number)d.getLongSetting("lafFontScale")).intValue();
            Color bg = HtmlColors.decode(d.getStringSetting("lafBackground"), Color.BLACK);
            Color fg = HtmlColors.decode(d.getStringSetting("lafForeground"), Color.WHITE);
            String style = d.getStringSetting("lafStyle");
            int gradient = ((Number)d.getLongSetting("lafGradient")).intValue();
            int variant = ((Number)d.getLongSetting("lafVariant")).intValue();
            String scroll = d.getStringSetting("lafScroll");
            Map custom = settings.getMap("lafCustomTheme");
            boolean nativeWindow = d.getBooleanSettingValue("lafNativeWindow");
            return new LaFSettings(lafCode, lafTheme, lafFontScale, custom, fg, bg, style, gradient, scroll, variant, nativeWindow, d.getBooleanSettingValue("lafFlatStyledWindow"), d.getBooleanSettingValue("lafFlatEmbeddedMenu"), d.getStringSetting("lafFlatProperties"), d.getLongSetting("lafFlatTabs"), d.getBooleanSettingValue("lafErrorSound"));
        }
    }
}

