/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.laf;

import chatty.gui.laf.LaF;
import java.awt.Component;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class LaFChanger {
    private static final Logger LOGGER = Logger.getLogger(LaFChanger.class.getName());
    private static LaF.LaFSettings settingsBefore;
    private static String loggedError;
    private static Component parentComponent;

    public static void changeLookAndFeel(LaF.LaFSettings settings, Component parentComponent) {
        settingsBefore = LaF.getSettings();
        loggedError = null;
        LaFChanger.parentComponent = parentComponent;
        String caughtError = LaF.setLookAndFeel(settings);
        if (caughtError == null && loggedError == null) {
            LaF.updateLookAndFeel();
        } else {
            LaFChanger.revertLookAndFeelWithError(caughtError != null ? caughtError : loggedError);
        }
    }

    public static void loggedFlatLookAndFeelError(String error) {
        loggedError = error;
    }

    private static void revertLookAndFeelWithError(String error) {
        LOGGER.info("Reverting LaF due to error: " + error);
        SwingUtilities.invokeLater(() -> {
            LaF.setLookAndFeel(settingsBefore);
            LaF.updateLookAndFeel();
            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(parentComponent, error, "Failed to apply new Look&Feel settings", 2));
        });
    }
}

