/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.laf;

import chatty.gui.laf.LaFUtil;
import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;

public class LaFCustomDefaults {
    private static final Pattern PARSE_UIDEFAULT = Pattern.compile("(\\w+)\\((.+)\\)");
    public static final UIResourceEmptyBorder EMPTY_BORDER = new UIResourceEmptyBorder(0, 0, 0, 0);

    public static Object fromString(String input) {
        Matcher m = PARSE_UIDEFAULT.matcher(input);
        if (m.find()) {
            String type = m.group(1);
            String value = m.group(2);
            switch (type) {
                case "border": {
                    return LaFCustomDefaults.createDefaultBorder(value);
                }
                case "int": {
                    return Integer.parseInt(value);
                }
                case "color": {
                    return LaFUtil.parseColor(value, null);
                }
                case "insets": {
                    return LaFCustomDefaults.createDefaultInsets(value);
                }
                case "boolean": {
                    return Boolean.valueOf(value);
                }
            }
        }
        return null;
    }

    private static Border createDefaultBorder(String value) {
        String[] split = value.split(",");
        if (value.isEmpty()) {
            return EMPTY_BORDER;
        }
        InsetsUIResource insets = LaFCustomDefaults.createDefaultInsets(split[0]);
        Color color = null;
        if (split.length == 2) {
            color = LaFUtil.parseColor(split[1], null);
        }
        if (color != null) {
            return new UIResourceMatteBorder(insets.top, insets.left, insets.bottom, insets.right, color);
        }
        return new UIResourceEmptyBorder(insets.top, insets.left, insets.bottom, insets.right);
    }

    private static InsetsUIResource createDefaultInsets(String value) {
        String[] sizeSplit = value.split(" ");
        int top = 1;
        int left = 1;
        int bottom = 1;
        int right = 1;
        try {
            if (sizeSplit.length == 1) {
                top = Integer.parseInt(sizeSplit[0]);
                left = Integer.parseInt(sizeSplit[0]);
                bottom = Integer.parseInt(sizeSplit[0]);
                right = Integer.parseInt(sizeSplit[0]);
            } else {
                top = Integer.parseInt(sizeSplit[0]);
                left = Integer.parseInt(sizeSplit[1]);
                bottom = Integer.parseInt(sizeSplit[2]);
                right = Integer.parseInt(sizeSplit[3]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new InsetsUIResource(top, left, bottom, right);
    }

    public static class UIResourceEmptyBorder
    extends EmptyBorder
    implements UIResource {
        public UIResourceEmptyBorder(int top, int left, int bottom, int right) {
            super(top, left, bottom, right);
        }
    }

    public static class UIResourceMatteBorder
    extends MatteBorder
    implements UIResource {
        public UIResourceMatteBorder(int top, int left, int bottom, int right, Color matteColor) {
            super(top, left, bottom, right, matteColor);
        }
    }
}

