/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.laf;

import java.awt.Color;
import java.awt.Window;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiFunction;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class LaFUtil {
    private static final Set<Object> setKeys = Collections.synchronizedSet(new HashSet());

    public static void modifyDefaults(BiFunction<Object, Object, Object> modify) {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        HashSet keys = new HashSet(defaults.keySet());
        for (Object key : keys) {
            Object value;
            Object result = modify.apply(key, value = defaults.get(key));
            if (result == null) continue;
            LaFUtil.putDefault(key, result);
        }
    }

    public static void putDefault(Object key, Object value) {
        UIManager.getDefaults().put(key, value);
        setKeys.add(key);
    }

    public static void resetDefaults() {
        for (Object key : LaFUtil.getSetKeys()) {
            UIManager.getDefaults().put(key, (Object)null);
        }
        setKeys.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<Object> getSetKeys() {
        Set<Object> set = setKeys;
        synchronized (set) {
            return new HashSet<Object>(setKeys);
        }
    }

    public static Color parseColor(String value, Color defaultValue) {
        try {
            String[] split = value.split(" ");
            return new Color(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]));
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static void updateLookAndFeel() {
        for (Window w : Window.getWindows()) {
            if (!w.isDisplayable()) continue;
            SwingUtilities.updateComponentTreeUI(w);
        }
    }
}

