/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.notifications;

import chatty.Addressbook;
import chatty.Helper;
import chatty.User;
import chatty.gui.Highlighter;
import chatty.util.StringUtil;
import chatty.util.colors.HtmlColors;
import chatty.util.commands.CustomCommand;
import chatty.util.irc.MsgTags;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

public class Notification {
    private static final Logger LOGGER = Logger.getLogger(Notification.class.getName());
    private static final AtomicLong COUNTER = new AtomicLong();
    public final long id = COUNTER.getAndIncrement();
    public final Type type;
    public final List<String> options;
    private final Set<String> channels;
    public final String matcher;
    private final Highlighter.HighlightItem matcherItem;
    public final State desktopState;
    public final Color foregroundColor;
    public final Color backgroundColor;
    public final int fontSize;
    public final State soundState;
    public final String soundFile;
    public final long soundVolume;
    public final int soundCooldown;
    public final int soundInactiveCooldown;
    public final State messageState;
    public final String messageTarget;
    public final boolean messageUseColor;
    public final boolean messageOverrideDefault;
    public final State ttsState;
    public final CustomCommand ttsFormat;
    private long lastMatched;
    private long lastSoundPlayed;
    public static final String TTS_FORMAT_DEFAULT = "$(title) $(message)";

    public Notification(Builder builder) {
        this.type = builder.type;
        this.options = builder.options;
        this.channels = Notification.parseChannels(builder.channels);
        this.matcher = StringUtil.trim(builder.matcher);
        this.matcherItem = this.matcher != null && !this.matcher.isEmpty() ? new Highlighter.HighlightItem(this.matcher, "notification") : null;
        this.desktopState = builder.desktopState;
        this.foregroundColor = builder.foregroundColor;
        this.backgroundColor = builder.backgroundColor;
        this.fontSize = builder.fontSize;
        this.soundState = builder.soundState;
        this.soundFile = builder.soundFile;
        this.soundVolume = builder.soundVolume;
        this.soundCooldown = builder.soundCooldown;
        this.soundInactiveCooldown = builder.soundInactiveCooldown;
        this.messageState = builder.messageState;
        this.messageTarget = builder.messageTarget;
        this.messageUseColor = builder.messageUseColor;
        this.messageOverrideDefault = builder.messageOverrideDefault;
        this.ttsState = builder.ttsState;
        this.ttsFormat = builder.ttsFormat != null ? CustomCommand.parse(builder.ttsFormat) : null;
    }

    private static Set<String> parseChannels(String channels) {
        if (channels == null) {
            return null;
        }
        Set<String> parsedChannels = Helper.parseChannelsFromString(channels, true);
        if (!parsedChannels.isEmpty()) {
            TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            result.addAll(parsedChannels);
            return result;
        }
        return null;
    }

    public String getDesktopState() {
        return this.desktopState.label;
    }

    public String getSoundState() {
        return this.soundState.label;
    }

    public String getMessageState() {
        return this.messageState.label;
    }

    public boolean hasEnabled() {
        return this.desktopState != State.OFF || this.soundState != State.OFF || this.messageState != State.OFF || this.ttsState != State.OFF;
    }

    public void setMatched() {
        this.lastMatched = System.currentTimeMillis();
    }

    public void setSoundPlayed() {
        this.lastSoundPlayed = System.currentTimeMillis();
    }

    public long lastMatchedAgo() {
        return System.currentTimeMillis() - this.lastMatched;
    }

    public long lastPlayedAgo() {
        return System.currentTimeMillis() - this.lastSoundPlayed;
    }

    public boolean matchesChannel(String channel) {
        if (channel == null) {
            return true;
        }
        if (this.channels == null) {
            return true;
        }
        return this.channels.contains(Helper.toChannel(channel));
    }

    public boolean matches(String text, String channel, Addressbook ab, User user, User localUser, MsgTags tags, Highlighter.HighlightItem matchedItem) {
        if (this.matcherItem == null || text == null) {
            return true;
        }
        if (this.matcherItem.getNotificationCategories() != null && (matchedItem == null || matchedItem.getNotificationCategories() == null || Collections.disjoint(this.matcherItem.getNotificationCategories(), matchedItem.getNotificationCategories()))) {
            return false;
        }
        return this.matcherItem.matches(Highlighter.HighlightItem.Type.ANY, text, -1, -1, null, channel, ab, user, localUser, tags);
    }

    public boolean hasChannels() {
        return this.channels != null && !this.channels.isEmpty();
    }

    public String serializeChannels() {
        return this.channels == null ? "" : Helper.buildStreamsString(this.channels);
    }

    public boolean hasOption(TypeOption option) {
        return this.options.contains(option.id);
    }

    public boolean hasMatcher() {
        return this.matcherItem != null;
    }

    public Highlighter.HighlightItem getMatcher() {
        return this.matcherItem;
    }

    public boolean hasSound() {
        return this.soundFile != null && !this.soundFile.isEmpty();
    }

    public String getMatcherString() {
        return this.matcher == null ? "" : this.matcher;
    }

    public List<Object> toList() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(this.type.name());
        result.add(this.desktopState.id);
        result.add(this.soundState.id);
        result.add(HtmlColors.getColorString(this.foregroundColor));
        result.add(HtmlColors.getColorString(this.backgroundColor));
        result.add(this.fontSize);
        result.add(this.options);
        result.add(this.soundFile);
        result.add(this.soundVolume);
        result.add(this.soundCooldown);
        result.add(this.soundInactiveCooldown);
        result.add(this.serializeChannels());
        result.add(this.matcher);
        result.add(this.messageState.id);
        result.add(this.messageTarget);
        result.add(this.messageUseColor);
        result.add(this.messageOverrideDefault);
        result.add(this.ttsState.id);
        result.add(this.ttsFormat != null ? this.ttsFormat.getRaw() : "");
        return result;
    }

    public static Notification fromList(List<Object> list) {
        try {
            Type type = Type.valueOf((String)list.get(0));
            State desktopState = State.getTypeFromId(((Number)list.get(1)).intValue());
            State soundState = State.getTypeFromId(((Number)list.get(2)).intValue());
            Color foregroundColor = HtmlColors.decode((String)list.get(3));
            Color backgroundColor = HtmlColors.decode((String)list.get(4));
            int fontSize = ((Number)list.get(5)).intValue();
            List<String> options = Notification.getStringList(list.get(6));
            String soundFile = (String)list.get(7);
            long volume = ((Number)list.get(8)).longValue();
            int soundCooldown = ((Number)list.get(9)).intValue();
            int soundInactiveCooldown = ((Number)list.get(10)).intValue();
            String channels = (String)list.get(11);
            String matcher = (String)list.get(12);
            State messageState = State.OFF;
            String messageTarget = "";
            boolean messageUseColor = false;
            boolean messageOverrideDefault = false;
            if (list.size() > 13) {
                messageState = State.getTypeFromId(((Number)list.get(13)).intValue());
                messageTarget = (String)list.get(14);
                messageUseColor = (Boolean)list.get(15);
            }
            if (list.size() > 16) {
                messageOverrideDefault = (Boolean)list.get(16);
            }
            State ttsState = State.OFF;
            String ttsFormat = TTS_FORMAT_DEFAULT;
            if (list.size() > 18) {
                ttsState = State.getTypeFromId(((Number)list.get(17)).intValue());
                ttsFormat = (String)list.get(18);
            }
            Builder b = new Builder(type);
            b.setDesktopEnabled(desktopState);
            b.setSoundEnabled(soundState);
            b.setMessageEnabled(messageState);
            b.setForeground(foregroundColor);
            b.setBackground(backgroundColor);
            b.setFontSize(fontSize);
            b.setOptions(options);
            b.setSoundFile(soundFile);
            b.setVolume(volume);
            b.setSoundCooldown(soundCooldown);
            b.setSoundInactiveCooldown(soundInactiveCooldown);
            b.setChannels(channels);
            b.setMatcher(matcher);
            b.setMessageTarget(messageTarget);
            b.setMessageUseColor(messageUseColor);
            b.setMessageOverrideDefault(messageOverrideDefault);
            b.setTTSEnabled(ttsState);
            b.setTTSFormat(ttsFormat);
            return new Notification(b);
        }
        catch (Exception ex) {
            LOGGER.warning("Error parsing NotificationSettings: " + ex);
            return null;
        }
    }

    private static List<String> getStringList(Object o) {
        ArrayList<String> result = new ArrayList<String>();
        if (o instanceof Collection) {
            for (Object item : (Collection)o) {
                if (!(item instanceof String)) continue;
                result.add((String)item);
            }
        }
        return result;
    }

    public String toString() {
        return String.format("%s [Desktop: %s, Sound: %s, Message: %s]", this.type.label, this.getDesktopState(), this.getSoundState(), this.getMessageState());
    }

    public static class Builder {
        private final Type type;
        private State soundState = State.OFF;
        private State desktopState = State.OFF;
        private State messageState = State.OFF;
        private State ttsState = State.OFF;
        private String matcher;
        private Color foregroundColor = Color.BLACK;
        private Color backgroundColor = Color.WHITE;
        private int fontSize;
        private String soundFile;
        private long soundVolume = 20L;
        private int soundCooldown;
        private int soundInactiveCooldown;
        private List<String> options = new ArrayList<String>();
        private String channels;
        private String messageTarget;
        private boolean messageUseColor;
        private boolean messageOverrideDefault;
        private String ttsFormat;

        public Builder(Type type) {
            this.type = type;
        }

        public Builder setForeground(Color c) {
            this.foregroundColor = c;
            return this;
        }

        public Builder setBackground(Color c) {
            this.backgroundColor = c;
            return this;
        }

        public Builder setFontSize(int fontSize) {
            this.fontSize = fontSize;
            return this;
        }

        public Builder setVolume(long volume) {
            this.soundVolume = volume;
            return this;
        }

        public Builder setSoundCooldown(int cooldown) {
            this.soundCooldown = cooldown;
            return this;
        }

        public Builder setSoundInactiveCooldown(int cooldown) {
            this.soundInactiveCooldown = cooldown;
            return this;
        }

        public Builder setSoundFile(String file) {
            this.soundFile = file;
            return this;
        }

        public Builder setSoundEnabled(State enabled) {
            this.soundState = enabled;
            return this;
        }

        public Builder setDesktopEnabled(State enabled) {
            this.desktopState = enabled;
            return this;
        }

        public Builder setMessageEnabled(State enabled) {
            this.messageState = enabled;
            return this;
        }

        public Builder setTTSEnabled(State enabled) {
            this.ttsState = enabled;
            return this;
        }

        public Builder setOptions(List<String> options) {
            this.options = options;
            return this;
        }

        public Builder setChannels(String channels) {
            this.channels = channels;
            return this;
        }

        public Builder setMatcher(String matcher) {
            this.matcher = matcher;
            return this;
        }

        public Builder setMessageTarget(String customTab) {
            this.messageTarget = customTab;
            return this;
        }

        public Builder setMessageUseColor(boolean useColor) {
            this.messageUseColor = useColor;
            return this;
        }

        public Builder setMessageOverrideDefault(boolean override) {
            this.messageOverrideDefault = override;
            return this;
        }

        public Builder setTTSFormat(String format) {
            this.ttsFormat = format;
            return this;
        }
    }

    public static enum Type {
        STREAM_STATUS("Stream Status", Type.createStreamStatusSubtypes()),
        HIGHLIGHT("Highlights", Type.createMessageSubtypes()),
        MESSAGE("Chat Message", Type.createMessageSubtypes()),
        INFO("Info Message"),
        WHISPER("Whisper", Type.createMessageSubtypes()),
        JOIN("User Joined"),
        PART("User Left"),
        NEW_FOLLOWERS("New Followers"),
        SUBSCRIBER("Subscriber Notification"),
        AUTOMOD("AutoMod Message"),
        COMMAND("Triggered by command");

        public final String label;
        public final List<TypeOption> options;

        private Type(String name, List<TypeOption> options) {
            this.label = name;
            options.add(TypeOption.HIDE_ON_START);
            this.options = Collections.unmodifiableList(options);
        }

        private Type(String name) {
            this(name, new ArrayList<TypeOption>());
        }

        private static List<TypeOption> createStreamStatusSubtypes() {
            return new ArrayList<TypeOption>(Arrays.asList(TypeOption.NOW_LIVE, TypeOption.NEW_STREAM, TypeOption.LIVE, TypeOption.NO_UPTIME, TypeOption.FAV_CHAN, TypeOption.FAV_GAME));
        }

        private static List<TypeOption> createMessageSubtypes() {
            return new ArrayList<TypeOption>(Arrays.asList(TypeOption.OWN_MSG, TypeOption.CONTAINS_BITS, TypeOption.FAV_CHAN));
        }
    }

    public static enum State {
        ALWAYS(1, "Always enabled"),
        OFF(0, "Off"),
        CHANNEL_ACTIVE(2, "Chan focused"),
        CHANNEL_NOT_ACTIVE(3, "Chan not focused"),
        APP_NOT_ACTIVE(4, "App not focused"),
        CHANNEL_OR_APP_NOT_ACTIVE(5, "Chan or app not focused"),
        CHANNEL_AND_APP_NOT_ACTIVE(6, "Chan/app not focused");

        public String label;
        public int id;

        private State(int id, String label) {
            this.label = label;
            this.id = id;
        }

        public static State getTypeFromId(int triggerStateId) {
            for (State type : State.values()) {
                if (type.id != triggerStateId) continue;
                return type;
            }
            return OFF;
        }
    }

    public static enum TypeOption {
        NO_UPTIME("noUptime"),
        NEW_STREAM("justLive"),
        NOW_LIVE("nowLive"),
        HIDE_ON_START("hideOnStart"),
        LIVE("noOffline"),
        OWN_MSG("own"),
        FAV_CHAN("fav"),
        FAV_GAME("favGame"),
        CONTAINS_BITS("bits");

        public String id;

        private TypeOption(String id) {
            this.id = id;
        }
    }
}

