/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.notifications;

import chatty.Addressbook;
import chatty.ChannelFavorites;
import chatty.Chatty;
import chatty.Helper;
import chatty.Room;
import chatty.User;
import chatty.gui.Highlighter;
import chatty.gui.MainGui;
import chatty.gui.components.textpane.InfoMessage;
import chatty.gui.notifications.Notification;
import chatty.util.DateTime;
import chatty.util.Sound;
import chatty.util.StringUtil;
import chatty.util.api.Follower;
import chatty.util.api.FollowerInfo;
import chatty.util.api.StreamInfo;
import chatty.util.commands.Parameters;
import chatty.util.history.HistoryUtil;
import chatty.util.irc.MsgTags;
import chatty.util.settings.Settings;
import chatty.util.tts.TextToSpeech;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class NotificationManager {
    private final Settings settings;
    private final MainGui main;
    private final Addressbook ab;
    private final ChannelFavorites channelFavorites;
    private final List<Notification> properties = new ArrayList<Notification>();
    private static final String SETTING_NAME = "notifications";
    public static final String COLOR_PRESETS_SETTING_NAME = "nColorPresets";

    public NotificationManager(MainGui main, Settings settings, Addressbook ab, ChannelFavorites channelFavorites) {
        this.settings = settings;
        this.main = main;
        this.ab = ab;
        this.channelFavorites = channelFavorites;
        settings.addSettingChangeListener((s, t, v) -> {
            if (s.equals(SETTING_NAME)) {
                this.loadFromSettings();
            }
        });
    }

    public synchronized List<Notification> getData() {
        return new ArrayList<Notification>(this.properties);
    }

    public synchronized void setData(List<Notification> data) {
        this.properties.clear();
        this.properties.addAll(data);
        this.saveToSettings();
    }

    private void saveToSettings() {
        ArrayList<List<Object>> entriesToSave = new ArrayList<List<Object>>();
        for (Notification p : this.properties) {
            entriesToSave.add(p.toList());
        }
        this.settings.putList(SETTING_NAME, entriesToSave);
    }

    public synchronized void loadFromSettings() {
        List entriesToLoad = this.settings.getList(SETTING_NAME);
        this.properties.clear();
        for (List l : entriesToLoad) {
            Notification p = Notification.fromList(l);
            if (p == null) continue;
            this.properties.add(p);
        }
    }

    public void streamInfoChanged(String channel, StreamInfo info) {
        this.check(Notification.Type.STREAM_STATUS, "#" + info.getStream(), null, null, null, n -> {
            boolean gameFavReq;
            boolean liveReq = !n.hasOption(Notification.TypeOption.LIVE) || info.getOnline();
            boolean newReq = !n.hasOption(Notification.TypeOption.NEW_STREAM) || info.getTimeStartedWithPicnicAgo() < 900000L;
            boolean nowLiveReq = !n.hasOption(Notification.TypeOption.NOW_LIVE) || info.getPrevLastOnlineAgoSecs() > 900L;
            boolean bl = gameFavReq = !n.hasOption(Notification.TypeOption.FAV_GAME) || this.settings.listContains("gameFavorites", info.getGame());
            if (liveReq && newReq && nowLiveReq && gameFavReq) {
                String title = info.getOnline() && !n.hasOption(Notification.TypeOption.NO_UPTIME) ? String.format("[Status] %2$s (%1$s)", DateTime.agoUptimeCompact2(info.getTimeStartedWithPicnic()), info.getCapitalizedName()) : String.format("[Status] %s", info.getCapitalizedName());
                MsgTags tags = MsgTags.create("title", title, "game", info.getGame());
                if (n.matches(info.getFullStatus(), channel, this.ab, null, null, tags, null)) {
                    return new NotificationData(title, info.getFullStatus());
                }
            }
            return null;
        });
    }

    public void highlight(User user, User localUser, String message, MsgTags tags, boolean isOwnMessage, boolean isWhisper, boolean hasBits, Highlighter.HighlightItem matchedItem) {
        this.check(null, user.getChannel(), user, localUser, message, tags, matchedItem, n -> {
            if (isOwnMessage && !n.hasOption(Notification.TypeOption.OWN_MSG)) {
                return null;
            }
            if (!hasBits && n.hasOption(Notification.TypeOption.CONTAINS_BITS)) {
                return null;
            }
            if (n.type == Notification.Type.HIGHLIGHT) {
                String title = String.format("[Highlight] %s in %s", this.getDisplayName(user), user.getChannel());
                return new NotificationData(title, message);
            }
            if (n.type == Notification.Type.MESSAGE) {
                String title = String.format("[Message] %s in %s", this.getDisplayName(user), user.getChannel());
                return new NotificationData(title, message);
            }
            if (n.type == Notification.Type.WHISPER && isWhisper) {
                String title = String.format("[Whisper] %s", this.getDisplayName(user));
                return new NotificationData(title, message);
            }
            return null;
        });
    }

    public void infoHighlight(Room room, String message, Highlighter.HighlightItem matchedItem, User localUser) {
        String channel = room != null ? room.getChannel() : null;
        this.check(null, channel, null, localUser, message, MsgTags.EMPTY, matchedItem, n -> {
            boolean hasChannel;
            boolean bl = hasChannel = channel != null && !channel.isEmpty();
            if (n.type == Notification.Type.HIGHLIGHT) {
                String title = hasChannel ? String.format("[Highlight] Info Message in %s", channel) : "[Highlight] Info Message";
                return new NotificationData(title, message);
            }
            if (n.type == Notification.Type.INFO) {
                String title = hasChannel ? String.format("[Info] %s", channel) : "[Info]";
                return new NotificationData(title, message);
            }
            return null;
        });
    }

    public void info(Room room, String text, User localUser) {
        String channel = room != null ? room.getChannel() : null;
        this.check(Notification.Type.INFO, channel, null, localUser, text, n -> {
            String title = channel == null || channel.isEmpty() ? "[Info]" : "[Info] " + channel;
            return new NotificationData(title, text);
        });
    }

    public void message(User user, User localUser, String message, MsgTags tags, boolean isOwnMessage, boolean hasBits) {
        this.check(Notification.Type.MESSAGE, user.getChannel(), user, localUser, message, tags, n -> {
            if (isOwnMessage && !n.hasOption(Notification.TypeOption.OWN_MSG)) {
                return null;
            }
            if (!hasBits && n.hasOption(Notification.TypeOption.CONTAINS_BITS)) {
                return null;
            }
            String title = String.format("[Message] %s in %s", this.getDisplayName(user), user.getChannel());
            return new NotificationData(title, message);
        });
    }

    public void whisper(User user, User localUser, String message, boolean isOwnMessage) {
        this.check(Notification.Type.WHISPER, null, user, localUser, message, n -> {
            if (isOwnMessage && !n.hasOption(Notification.TypeOption.OWN_MSG)) {
                return null;
            }
            String title = String.format("[Whisper] %s", this.getDisplayName(user));
            return new NotificationData(title, message);
        });
    }

    public void userJoined(User user) {
        this.check(Notification.Type.JOIN, user.getChannel(), user, null, user.getName(), n -> {
            String title = String.format("[Join] %s in %s", this.getDisplayName(user), user.getChannel());
            return new NotificationData(title, "");
        });
    }

    public void userLeft(User user) {
        this.check(Notification.Type.PART, user.getChannel(), user, null, user.getName(), n -> {
            String title = String.format("[Part] %s in %s", this.getDisplayName(user), user.getChannel());
            return new NotificationData(title, "");
        });
    }

    public void newFollowers(FollowerInfo info) {
        String channel = Helper.toChannel(info.stream);
        this.check(Notification.Type.NEW_FOLLOWERS, channel, c -> {
            String title = String.format("[New Followers] %s", channel);
            StringBuilder b = new StringBuilder();
            for (Follower f : info.getNewFollowers()) {
                if (b.length() > 0) {
                    b.append(", ");
                }
                b.append(f.display_name);
            }
            return new NotificationData(title, b.toString());
        });
    }

    public void newSubscriber(User user, User localUser, String systemMsg, String message) {
        String text = message != null && !message.isEmpty() ? systemMsg + " [" + message + "]" : systemMsg;
        this.check(Notification.Type.SUBSCRIBER, user.getChannel(), user, localUser, text, c -> {
            String title = String.format("[Subscriber] %s in %s", user.getDisplayNick(), user.getChannel());
            return new NotificationData(title, text);
        });
    }

    public void autoModMessage(String channel, String username, String message) {
        this.check(Notification.Type.AUTOMOD, channel, c -> {
            String title = String.format("[AutoMod] %s in %s", username, channel);
            return new NotificationData(title, message);
        });
    }

    public void commandNotification(String channel, String title, String text, Highlighter.HighlightItem matchedItem) {
        this.check(Notification.Type.COMMAND, channel, null, null, text, null, matchedItem, n -> {
            if (title != null) {
                return new NotificationData(String.format(title, channel), text);
            }
            return new NotificationData(String.format("[Command] %s", channel), text);
        });
    }

    private void check(Notification.Type type, String channel, NotificationChecker c) {
        this.check(type, channel, null, null, null, MsgTags.EMPTY, null, c);
    }

    private void check(Notification.Type type, String channel, User user, User localUser, String message, NotificationChecker c) {
        this.check(type, channel, user, localUser, message, MsgTags.EMPTY, null, c);
    }

    private void check(Notification.Type type, String channel, User user, User localUser, String message, MsgTags tags, NotificationChecker c) {
        this.check(type, channel, user, localUser, message, tags, null, c);
    }

    private void check(Notification.Type type, String channel, User user, User localUser, String message, MsgTags tags, Highlighter.HighlightItem matchedItem, NotificationChecker c) {
        boolean shown = false;
        boolean played = false;
        boolean msgShown = false;
        boolean spoken = false;
        Notification shownNotifiction = null;
        NotificationData shownData = null;
        for (Notification n : this.properties) {
            NotificationData d;
            if (!n.hasEnabled() || type != n.type && type != null || !n.matchesChannel(channel) || !n.matches(message, channel, this.ab, user, localUser, tags, matchedItem) || !this.checkHistoricAllowMatch(tags, n) || n.hasOption(Notification.TypeOption.FAV_CHAN) && !this.channelFavorites.isFavorite(channel) || this.hideOnStart(n) || (d = c.check(n)) == null) continue;
            if (!(shown || matchedItem != null && matchedItem.noNotification() || !this.checkRequirements(n.desktopState, channel))) {
                shown = true;
                shownNotifiction = n;
                shownData = d;
                this.showNotification(n, d.title, d.message, channel, channel);
            }
            if (!played && (matchedItem == null || !matchedItem.noSound()) && this.checkRequirements(n.soundState, channel) && n.hasSound()) {
                played = true;
                this.playSound(n);
            }
            if (!msgShown && this.checkRequirements(n.messageState, channel) && !StringUtil.isNullOrEmpty(n.messageTarget)) {
                msgShown = true;
                this.addInfoMsg(n, d, channel, n.messageTarget);
            }
            if (!spoken && this.checkRequirements(n.ttsState, channel) && n.ttsFormat != null && !n.ttsFormat.hasError()) {
                spoken = true;
                Parameters params = Parameters.create(message);
                params.putObject("user", user);
                params.putObject("localUser", localUser);
                params.putObject("settings", this.settings);
                params.put("chan", Helper.toStream(channel));
                params.put("stream", Helper.toStream(channel));
                params.put("title", d.title);
                params.put("message", d.message);
                TextToSpeech.get(this.settings).speak(n.ttsFormat.replace(params));
            }
            n.setMatched();
        }
        String msgTarget = this.settings.getString("nInfoMsgTarget");
        if (this.settings.getBoolean("nInfoMsgEnabled") && !StringUtil.isNullOrEmpty(msgTarget) && shownNotifiction != null && !shownNotifiction.messageOverrideDefault) {
            this.addInfoMsg(shownNotifiction, shownData, channel, msgTarget);
        }
    }

    public boolean showNotification(Notification n, String title, String message, String data, String channel) {
        this.main.showNotification(title, message, n.foregroundColor, n.backgroundColor, new NotificationWindowData(n, data));
        return true;
    }

    private boolean playSound(Notification n) {
        if (!this.settings.getBoolean("sounds")) {
            return false;
        }
        if (n.lastPlayedAgo() < (long)(n.soundCooldown * 1000)) {
            return false;
        }
        if (n.lastMatchedAgo() < (long)(n.soundInactiveCooldown * 1000)) {
            return false;
        }
        n.setSoundPlayed();
        Chatty.updateCustomPathFromSettings(Chatty.PathType.SOUND);
        Path soundsPath = Chatty.getPath(Chatty.PathType.SOUND);
        Path path = soundsPath.resolve(n.soundFile);
        try {
            Sound.play(path, (float)n.soundVolume, "notification_" + n.type.toString(), 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private void addInfoMsg(Notification n, NotificationData d, String channel, String targets) {
        int start;
        MsgTags tags = MsgTags.EMPTY;
        String stream = Helper.toValidStream(channel);
        if (!StringUtil.isNullOrEmpty(stream) && (start = StringUtil.toLowerCase(d.title).indexOf(stream)) != -1) {
            int end = start + stream.length() - 1;
            tags = MsgTags.createLinks(new MsgTags.Link(MsgTags.Link.Type.JOIN, stream, start, end));
        }
        InfoMessage msg = new InfoMessage(InfoMessage.Type.INFO, String.format("%s: %s", d.title, d.message), tags);
        msg.routingSource = n;
        if (n.messageUseColor) {
            msg.color = n.foregroundColor;
            msg.bgColor = n.backgroundColor;
            msg.colorSource = n;
        }
        for (String target : StringUtil.split(targets, ',', '\"', '\"', 0, 2)) {
            if (StringUtil.isNullOrEmpty(target)) continue;
            this.main.routingManager.addNotification(target, channel, msg);
        }
    }

    private boolean hideOnStart(Notification n) {
        boolean enabled = this.settings.getBoolean("nHideOnStart") || n.hasOption(Notification.TypeOption.HIDE_ON_START);
        return enabled && Chatty.uptimeSeconds() < 120L;
    }

    private boolean checkRequirements(Notification.State setting, String channel) {
        if (setting == null) {
            return false;
        }
        boolean appActive = this.main.isAppActive();
        boolean channelActive = this.main.isChanActive(channel);
        if (setting == Notification.State.OFF) {
            return false;
        }
        if (setting == Notification.State.CHANNEL_AND_APP_NOT_ACTIVE && (channelActive || appActive)) {
            return false;
        }
        if (setting == Notification.State.CHANNEL_NOT_ACTIVE && channelActive) {
            return false;
        }
        if (setting == Notification.State.APP_NOT_ACTIVE && appActive) {
            return false;
        }
        if (setting == Notification.State.CHANNEL_OR_APP_NOT_ACTIVE && channelActive && appActive) {
            return false;
        }
        return setting != Notification.State.CHANNEL_ACTIVE || channelActive;
    }

    private boolean checkHistoricAllowMatch(MsgTags tags, Notification n) {
        return HistoryUtil.checkAllowMatch(tags, "Notifications", n.getMatcher(), this.settings);
    }

    private String getDisplayName(User user) {
        long displayNamesMode = this.settings.getLong("displayNamesMode");
        return Helper.makeDisplayNick(user, displayNamesMode);
    }

    private static interface NotificationChecker {
        public NotificationData check(Notification var1);
    }

    private static class NotificationData {
        public final String title;
        public final String message;

        public NotificationData(String title, String message) {
            this.title = title;
            this.message = message;
        }
    }

    public static class NotificationWindowData {
        public final Notification notification;
        public final String channel;

        public NotificationWindowData(Notification notification, String channel) {
            this.notification = notification;
            this.channel = channel;
        }
    }
}

