/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.notifications;

import chatty.Helper;
import chatty.gui.notifications.NotificationWindowListener;
import chatty.util.ActivityListener;
import chatty.util.ActivityTracker;
import chatty.util.IconManager;
import chatty.util.colors.ColorCorrection;
import chatty.util.colors.ColorCorrectionNew;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;

public class NotificationWindow {
    private static final int SECOND = 1000;
    private static final ImageIcon ICON = IconManager.getNotificationIcon();
    private static final Border PADDING_BORDER = BorderFactory.createEmptyBorder(9, 9, 9, 8);
    private static final Border LINE_BORDER_DARK = BorderFactory.createLineBorder(new Color(50, 50, 50), 1);
    private static final Border BORDER_DARK = BorderFactory.createCompoundBorder(LINE_BORDER_DARK, PADDING_BORDER);
    private static final int MAX_WIDTH = 190;
    private static final String HTML = "<html><body style='font-weight: normal;'>";
    private static final String HTML_FIXED_WIDTH = "<html><body style='width:190px;font-weight: normal;'>";
    private static final int MAX_MESSAGE_LENGTH = 250;
    private static final float DEFAULT_OPACITY = 0.99f;
    private static final int UPDATE_TIME_INTERVAL = 60000;
    private static final boolean SHORTER_AFTER_ACTIVITY = true;
    private static final int SHORTER_CUTOFF = 2000;
    private int timeout = 10000;
    private int fallbackTimeout = 1800000;
    private int activityTime = 60000;
    private boolean keepOpenOnHover;
    private long visibleSince = 0L;
    private final long createdAt;
    private boolean closed = false;
    private final JWindow window;
    private final NotificationWindowListener listener;
    private boolean translucencySupported = false;
    private HideMethod hideMethod = HideMethod.FADE_OUT;
    private final JLabel timeLabel;
    private Timer fadeOutTimer;
    private Timer fallbackTimer;
    private Timer regularTimer;
    private final Timer updateTimeTimer;
    private ActivityListener activityListener;

    public NotificationWindow(String title, String message, Color foreground, Color background, final NotificationWindowListener listener) {
        this.window = new JWindow();
        this.window.setFocusable(false);
        this.window.setFocusableWindowState(false);
        this.window.setAutoRequestFocus(false);
        this.window.setAlwaysOnTop(true);
        this.window.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        this.checkTranslucencySupport();
        this.setOpacity(0.99f);
        JPanel panel = new JPanel(new GridBagLayout());
        if (ColorCorrection.getBrightness(background) < 100) {
            Color bColor = ColorCorrectionNew.toLightness(background, 140);
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(bColor), PADDING_BORDER));
        } else {
            panel.setBorder(BORDER_DARK);
        }
        panel.setOpaque(true);
        panel.setBackground(background);
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel iconLabel = new JLabel();
        iconLabel.setIcon(ICON);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 11;
        gbc.insets = new Insets(2, 0, 0, 5);
        panel.add((Component)iconLabel, gbc);
        this.timeLabel = new JLabel("55m");
        this.timeLabel.setFont(this.timeLabel.getFont().deriveFont(10.0f));
        this.timeLabel.setForeground(ColorCorrectionNew.offset(foreground, 0.7f));
        gbc.gridx = 0;
        gbc.gridy = 1;
        panel.add((Component)this.timeLabel, gbc);
        title = Helper.htmlspecialchars_encode(title);
        message = Helper.htmlspecialchars_encode(message);
        if (message.length() > 250) {
            message = message.substring(0, 250) + "[..]";
        }
        JLabel content = new JLabel(this.makeContent(title, message, false));
        content.setForeground(foreground);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridheight = 2;
        panel.add((Component)content, gbc);
        this.window.add(panel);
        this.window.setMaximumSize(new Dimension(190, 100));
        if (this.window.getPreferredSize().width > 190) {
            content.setText(this.makeContent(title, message, true));
        }
        this.listener = listener;
        this.window.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e) && listener != null) {
                    listener.notificationAction(NotificationWindow.this);
                }
                NotificationWindow.this.close();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                NotificationWindow.this.mouseEntered();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                NotificationWindow.this.mouseExited();
            }
        });
        this.window.pack();
        this.createdAt = System.currentTimeMillis();
        this.updateCreatedTime();
        this.updateTimeTimer = new Timer(60000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotificationWindow.this.updateCreatedTime();
            }
        });
        this.updateTimeTimer.setRepeats(true);
        this.updateTimeTimer.start();
    }

    public long getVisibleTime() {
        return System.currentTimeMillis() - this.visibleSince;
    }

    public boolean isVisible() {
        return this.visibleSince > 0L && !this.closed;
    }

    public void setActivityTime(int time) {
        this.activityTime = time;
    }

    public void setHideMethod(HideMethod method) {
        this.hideMethod = method;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setKeepOpenOnHover(boolean enabled) {
        this.keepOpenOnHover = enabled;
    }

    public void setLocation(Point location) {
        this.window.setLocation(location);
    }

    public int getHeight() {
        return this.window.getHeight();
    }

    public Dimension getSize() {
        return this.window.getSize();
    }

    public void moveVertical(int offset) {
        Point location = this.window.getLocation();
        location.y += offset;
        this.window.setLocation(location);
    }

    public void show() {
        if (this.activityTime <= 0 || ActivityTracker.getLastActivityAgo() < (long)this.activityTime) {
            this.startTimer(false);
        } else {
            this.activityListener = new MyActivityListener();
            ActivityTracker.addActivityListener(this.activityListener);
        }
        this.startFallbackTimer();
        this.visibleSince = System.currentTimeMillis();
        this.window.setVisible(true);
    }

    public void hide() {
        switch (this.hideMethod) {
            case FADE_OUT: {
                this.fadeOut();
                break;
            }
            case CLOSE: {
                this.close();
            }
        }
    }

    public void setFallbackTimeout(int timeout) {
        this.fallbackTimeout = timeout;
        if (this.fallbackTimer != null && this.fallbackTimer.isRunning()) {
            this.fallbackTimer.stop();
            this.startFallbackTimer();
        }
    }

    public void close() {
        this.stopTimers();
        this.closed = true;
        this.window.dispose();
        if (this.listener != null) {
            this.listener.notificationRemoved(this);
        }
        if (this.activityListener != null) {
            ActivityTracker.removeActivityListener(this.activityListener);
        }
    }

    private void fadeOut() {
        if (this.fadeOutTimer == null) {
            this.fadeOutTimer = new Timer(80, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NotificationWindow.this.performFadeOut();
                }
            });
            this.fadeOutTimer.start();
        }
    }

    private void startTimer(boolean afterActivity) {
        if (this.regularTimer == null && !this.closed) {
            int timerDelay = this.timeout;
            if (afterActivity && timerDelay > 2000 && (timerDelay = (int)((double)timerDelay * 0.5)) < 2000) {
                timerDelay = 2000;
            }
            this.regularTimer = new Timer(timerDelay, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NotificationWindow.this.hide();
                }
            });
            this.regularTimer.setRepeats(false);
            this.regularTimer.start();
        }
    }

    private void startFallbackTimer() {
        this.fallbackTimer = new Timer(this.fallbackTimeout, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotificationWindow.this.hide();
            }
        });
        this.fallbackTimer.setRepeats(false);
        this.fallbackTimer.start();
    }

    private String makeContent(String title, String message, boolean fixedWidth) {
        return (fixedWidth ? HTML_FIXED_WIDTH : HTML) + "<p style='margin-bottom: 1px;'><b>" + title + "</b></p><p>" + message + "</p>";
    }

    private void performFadeOut() {
        if (!this.translucencySupported) {
            this.close();
        } else {
            float opacity = this.window.getOpacity();
            if ((double)opacity < 0.1) {
                this.close();
            } else {
                this.setOpacity(opacity - 0.05f);
            }
        }
    }

    private void setOpacity(float opacity) {
        if (this.translucencySupported) {
            if (opacity < 0.0f) {
                opacity = 0.0f;
            }
            this.window.setOpacity(opacity);
        }
    }

    private void checkTranslucencySupport() {
        this.translucencySupported = this.window.getGraphicsConfiguration().getDevice().isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT);
    }

    private void mouseEntered() {
        if (this.keepOpenOnHover) {
            this.setOpacity(0.99f);
            this.stopTimers();
        }
    }

    private void mouseExited() {
        if (!this.closed && this.regularTimer != null) {
            this.regularTimer.restart();
        }
    }

    private void stopTimers() {
        this.stopTimer(this.fadeOutTimer);
        this.stopTimer(this.regularTimer);
        this.stopTimer(this.fallbackTimer);
        this.stopTimer(this.updateTimeTimer);
        this.fadeOutTimer = null;
    }

    private void stopTimer(Timer timer) {
        if (timer != null && timer.isRunning()) {
            timer.stop();
        }
    }

    private void updateCreatedTime() {
        long ago = (System.currentTimeMillis() - this.createdAt) / 1000L;
        this.timeLabel.setText(this.makeTimeString(ago));
    }

    private String makeTimeString(long time) {
        if (time < 60L) {
            return "";
        }
        long minutes = time / 60L;
        if (minutes < 60L) {
            return minutes + "m";
        }
        long hours = minutes / 60L;
        return hours + "h";
    }

    public static enum HideMethod {
        FADE_OUT,
        CLOSE;

    }

    private class MyActivityListener
    implements ActivityListener {
        private MyActivityListener() {
        }

        @Override
        public void activity() {
            NotificationWindow.this.startTimer(true);
        }
    }
}

