/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.notifications;

import chatty.gui.notifications.NotificationActionListener;
import chatty.gui.notifications.NotificationWindow;
import chatty.gui.notifications.NotificationWindowListener;
import chatty.util.ActivityTracker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.SwingUtilities;

public class NotificationWindowManager<T> {
    private static final int VERTICAL_MARGIN = 3;
    private static final int HORIZONTAL_MARGIN = 4;
    private static final int SECOND = 1000;
    private static final int MINUTE = 60000;
    private final LinkedList<NotificationWindow> displayed = new LinkedList();
    private final LinkedList<NotificationWindow> queue = new LinkedList();
    private final Map<NotificationWindow, T> notificationData = new HashMap<NotificationWindow, T>();
    private int screen;
    private int position;
    private int verticalMoveDirection;
    private int horizontalMoveDirection;
    private int displayTime = 10000;
    private int maxDisplayTime = 1800000;
    private int shortMaxDisplayTime = 2000;
    private boolean keepOpenOnHover;
    private int activityTime = -1;
    private int maxItems = 4;
    private int maxQueueSize = 4;
    private NotificationWindow.HideMethod hideMethod = NotificationWindow.HideMethod.FADE_OUT;
    private final Component parent;
    private final NotificationWindowListener listener;
    private NotificationActionListener<T> actionListener;

    public NotificationWindowManager(Component parent) {
        this.parent = parent;
        this.setPosition(0);
        this.setScreen(0);
        this.listener = new NotificationWindowListener(){

            @Override
            public void notificationRemoved(NotificationWindow source) {
                NotificationWindowManager.this.notificationRemoved(source);
            }

            @Override
            public void notificationAction(NotificationWindow source) {
                if (NotificationWindowManager.this.actionListener != null) {
                    NotificationWindowManager.this.actionListener.notificationAction(NotificationWindowManager.this.notificationData.get(source));
                }
            }
        };
    }

    public void showMessage(String title, String message, Color foreground, Color background, T data) {
        if (this.queue.size() > this.maxQueueSize * 10) {
            return;
        }
        NotificationWindow n = new NotificationWindow(title, message, foreground, background, this.listener);
        n.setHideMethod(this.hideMethod);
        n.setFallbackTimeout(this.maxDisplayTime);
        n.setActivityTime(this.activityTime);
        if (this.displayed.size() < this.maxItems) {
            this.showNotification(n);
        } else {
            this.queue.add(n);
            this.checkQueueSize();
        }
        this.notificationData.put(n, data);
    }

    public void showMessage(String title, String message, Color foreground, Color background) {
        this.showMessage(title, message, foreground, background, null);
    }

    public void clearAll() {
        this.queue.clear();
        this.clearAllShown();
    }

    public void clearAllShown() {
        for (NotificationWindow n : new LinkedList<NotificationWindow>(this.displayed)) {
            n.close();
        }
    }

    public final void setPosition(int position) {
        if (this.isClear()) {
            this.position = position;
            this.updateVariables();
        }
    }

    public final void setScreen(int screen) {
        if (this.isClear()) {
            this.screen = screen;
        }
    }

    public final void setDisplayTime(int displayTime) {
        this.displayTime = displayTime * 1000;
    }

    public final void setMaxDisplayTime(int maxDisplayTime) {
        this.maxDisplayTime = maxDisplayTime * 1000;
    }

    public final void setShortMaxDisplayTime(int shortDisplayTime) {
        this.shortMaxDisplayTime = shortDisplayTime;
    }

    public final void keepOpenOnHover(boolean enabled) {
        this.keepOpenOnHover = enabled;
    }

    public final void setMaxQueueSize(int size) {
        this.maxQueueSize = size;
    }

    public final void setMaxDisplayItems(int count) {
        this.maxItems = count;
    }

    public final void setActivityTime(int time) {
        this.activityTime = time * 1000;
        if (this.activityTime > 0) {
            ActivityTracker.startTracking();
        }
    }

    public final void setHideMethod(NotificationWindow.HideMethod hideMethod) {
        this.hideMethod = hideMethod;
    }

    public final void setNotificationActionListener(NotificationActionListener<T> listener) {
        this.actionListener = listener;
    }

    private boolean isClear() {
        return this.displayed.isEmpty() && this.queue.isEmpty();
    }

    private void updateVariables() {
        this.verticalMoveDirection = this.position == 2 || this.position == 3 ? 1 : -1;
        this.horizontalMoveDirection = this.position == 1 || this.position == 3 ? 1 : -1;
    }

    private void notificationRemoved(NotificationWindow removed) {
        int offset = 0;
        Iterator it = this.displayed.iterator();
        while (it.hasNext()) {
            NotificationWindow n = (NotificationWindow)it.next();
            if (removed == n) {
                offset = n.getHeight() + 3;
                it.remove();
                continue;
            }
            if (offset <= 0) continue;
            n.moveVertical(this.verticalMoveDirection * offset);
        }
        Iterator itQueue = this.queue.iterator();
        while (itQueue.hasNext() && this.displayed.size() < this.maxItems) {
            NotificationWindow next = (NotificationWindow)itQueue.next();
            itQueue.remove();
            this.showNotification(next);
        }
        this.notificationData.remove(removed);
    }

    private void checkQueueSize() {
        if (this.queue.size() > this.maxQueueSize && this.displayed.size() > 0) {
            this.displayed.getFirst().setFallbackTimeout(this.shortMaxDisplayTime);
        }
    }

    private void showNotification(NotificationWindow n) {
        this.checkQueueSize();
        GraphicsConfiguration config = this.getGraphicsConfig();
        Point location = this.calculateLocation(this.position, NotificationWindowManager.getSafeBounds(config), n.getSize(), this.getCurrentOffset());
        n.setLocation(location);
        n.setTimeout(this.displayTime + this.displayTime / 4 * this.displayed.size());
        n.setKeepOpenOnHover(this.keepOpenOnHover);
        if (this.queue.size() > this.maxQueueSize && this.displayed.size() == 0) {
            n.setFallbackTimeout(this.shortMaxDisplayTime);
        }
        this.displayed.add(n);
        n.show();
    }

    private int getCurrentOffset() {
        int offset = 3;
        for (NotificationWindow n : this.displayed) {
            offset += n.getHeight() + 3;
        }
        return offset;
    }

    private GraphicsConfiguration getGraphicsConfig() {
        GraphicsConfiguration g;
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        if (this.screen >= 0 && devices.length - 1 >= this.screen) {
            return devices[this.screen].getDefaultConfiguration();
        }
        if (this.parent != null && (g = this.parent.getGraphicsConfiguration()) != null) {
            return g;
        }
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    private Point calculateLocation(int position, Rectangle bounds, Dimension size, int offset) {
        Point location = new Point();
        location.x = bounds.x - this.horizontalMoveDirection * 4;
        location.y = bounds.y;
        if (position == 1 || position == 3) {
            location.x += bounds.width - size.width;
        }
        if (position == 2 || position == 3) {
            location.y += bounds.height - size.height;
            offset = -offset;
        }
        location.y += offset;
        return location;
    }

    private static Rectangle getSafeBounds(GraphicsConfiguration config) {
        Rectangle bounds = new Rectangle(config.getBounds());
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(config);
        bounds.x += insets.left;
        bounds.y += insets.top;
        bounds.width -= insets.left + insets.right;
        bounds.height -= insets.top + insets.bottom;
        return bounds;
    }

    public static final void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NotificationWindowManager m = new NotificationWindowManager(null);
                m.setPosition(0);
                m.setScreen(1);
                m.showMessage("Test", "Test message with some text.", Color.WHITE, Color.BLACK);
            }
        });
    }
}

