/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.transparency;

import chatty.gui.GuiUtil;
import chatty.gui.MainGui;
import chatty.gui.components.admin.AdminDialog;
import chatty.gui.components.settings.SettingsUtil;
import chatty.gui.transparency.TransparencyManager;
import chatty.util.dnd.DockContent;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JToggleButton;

public class TransparencyDialog
extends JDialog {
    private static TransparencyDialog instance;
    private final JComboBox<DockContent> selection = new JComboBox();
    private final JButton toggleButton = new JButton("Toggle Transparency");
    private final JCheckBox clickThroughNative = new JCheckBox("Click-through (Windows OS only)");
    private final JComboBox<Integer> colorTransparency = new JComboBox();
    private final JButton refreshButton = new JButton(new ImageIcon(AdminDialog.class.getResource("view-refresh.png")));
    private final JToggleButton toggleHelpButton = new JToggleButton("Help");
    private final JLabel help = new JLabel("<html><body style='width:320px;'>" + SettingsUtil.getInfo("info-transparency.html", null));
    private final JButton setHotkeyButton = new JButton("Set hotkey");

    public static TransparencyDialog instance(MainGui main) {
        if (instance == null) {
            instance = new TransparencyDialog(main);
        }
        return instance;
    }

    public static DockContent selectedContent() {
        if (instance != null) {
            return (DockContent)TransparencyDialog.instance.selection.getSelectedItem();
        }
        return null;
    }

    private TransparencyDialog(MainGui main) {
        super(main);
        this.setTitle("Transparency");
        this.setLayout(new GridBagLayout());
        for (int i = 10; i <= 100; i += 10) {
            this.colorTransparency.addItem(i);
        }
        this.clickThroughNative.setToolTipText("The transparent window ignores any mouse clicks.");
        GridBagConstraints gbc = GuiUtil.makeGbc(0, 0, 1, 1);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add(this.selection, gbc);
        this.add((Component)this.refreshButton, GuiUtil.makeGbc(1, 0, 1, 1));
        this.add((Component)this.toggleButton, GuiUtil.makeGbc(2, 0, 1, 1));
        this.add((Component)this.clickThroughNative, GuiUtil.makeGbc(0, 1, 2, 1, 13));
        this.add((Component)this.setHotkeyButton, GuiUtil.makeGbc(2, 1, 1, 1, 13));
        this.add((Component)new JLabel("Window Background Transparency (%):"), GuiUtil.makeGbc(0, 2, 2, 1, 13));
        this.add(this.colorTransparency, GuiUtil.makeGbc(2, 2, 1, 1, 17));
        this.add((Component)this.toggleHelpButton, GuiUtil.makeGbc(0, 10, 1, 1, 17));
        this.add((Component)this.help, GuiUtil.makeGbc(0, 11, 3, 1, 17));
        this.help.setVisible(false);
        this.toggleButton.addActionListener(e -> {
            DockContent selectedContent = (DockContent)this.selection.getSelectedItem();
            if (selectedContent != null) {
                if (TransparencyManager.getCurrent() != selectedContent) {
                    TransparencyManager.setTransparent(selectedContent);
                } else {
                    TransparencyManager.toggleTransparent();
                }
            }
        });
        this.clickThroughNative.addItemListener(e -> TransparencyManager.setClickThrough(this.clickThroughNative.isSelected()));
        this.colorTransparency.addItemListener(e -> {
            if (this.colorTransparency.getSelectedItem() != null) {
                TransparencyManager.setColorTransparency((Integer)this.colorTransparency.getSelectedItem());
            }
        });
        this.refreshButton.addActionListener(e -> this.refresh());
        this.toggleHelpButton.addActionListener(e -> {
            this.help.setVisible(this.toggleHelpButton.isSelected());
            this.pack();
        });
        this.setHotkeyButton.addActionListener(e -> main.getSettingsDialog(s -> s.showSettings("editHotkey", "dialog.toggleTransparency")));
        this.clickThroughNative.setSelected(TransparencyManager.getClickThrough());
        this.colorTransparency.setSelectedItem(TransparencyManager.getColorTransparency());
    }

    public void refresh() {
        this.selection.removeAllItems();
        this.selection.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    this.setText(((DockContent)value).getTitle());
                }
                return this;
            }
        });
        for (DockContent content : TransparencyManager.getEligible()) {
            this.selection.addItem(content);
        }
        if (TransparencyManager.getCurrent() == null) {
            this.selection.setSelectedItem(TransparencyManager.getCurrentById());
        } else {
            this.selection.setSelectedItem(TransparencyManager.getCurrent());
        }
        this.pack();
    }
}

