/*
 * Decompiled with CFR 0.152.
 */
package chatty.gui.transparency;

import chatty.gui.Channels;
import chatty.gui.transparency.TransparencyComponent;
import chatty.gui.transparency.TransparencyDialog;
import chatty.util.MiscUtil;
import chatty.util.dnd.DockContent;
import chatty.util.dnd.DockPopout;
import chatty.util.settings.Settings;
import com.sun.jna.Native;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class TransparencyManager {
    private static Channels channels;
    private static DockContent current;
    private static String currentId;
    private static Set<JComponent> currentNotOpaque;
    private static JFrame currentFrame;
    private static boolean clickThrough;
    private static int colorTransparency;

    public static void setClickThrough(boolean enabled) {
        if (enabled == clickThrough) {
            return;
        }
        clickThrough = enabled;
        if (current != null && currentNotOpaque != null) {
            TransparencyManager.setWindowTransparent(currentFrame, false);
            TransparencyManager.setWindowTransparent(currentFrame, true);
        }
    }

    public static boolean getClickThrough() {
        return clickThrough;
    }

    public static void setColorTransparency(int transparency) {
        if (colorTransparency == transparency) {
            return;
        }
        colorTransparency = transparency;
        if (current != null && currentFrame != null) {
            TransparencyManager.findTransparencyComponent(current.getComponent()).setTransparent(transparency);
            if (!currentFrame.isUndecorated()) {
                return;
            }
            currentFrame.setBackground(new Color(0, 0, 0, TransparencyManager.transparencyToAlpha(colorTransparency)));
        }
    }

    public static int getColorTransparency() {
        return colorTransparency;
    }

    public static void init(Channels channels) {
        TransparencyManager.channels = channels;
    }

    public static void loadSettings(Settings settings) {
        TransparencyManager.setColorTransparency(settings.getInt("transparencyBackground"));
        TransparencyManager.setClickThrough(settings.getBoolean("transparencyClickThrough"));
        currentId = settings.getString("transparencyCurrentId");
    }

    public static void saveSettings(Settings settings) {
        settings.setLong("transparencyBackground", colorTransparency);
        settings.setBoolean("transparencyClickThrough", clickThrough);
        settings.setString("transparencyCurrentId", currentId);
    }

    public static void setTransparent(DockContent content) {
        if (current != content) {
            TransparencyManager.undoTransparent(current);
        }
        if (!TransparencyManager.isInPopout(content)) {
            channels.popout(content, true);
        }
        if (!TransparencyManager.isInPopout(content)) {
            return;
        }
        TransparencyComponent t = TransparencyManager.findTransparencyComponent(content.getComponent());
        if (t != null) {
            current = content;
            currentId = content.getId();
            currentNotOpaque = TransparencyManager.setNotOpaque((Container)((Object)t));
            currentFrame = TransparencyManager.getPopoutFrame(content);
            TransparencyManager.setWindowTransparent(currentFrame, true);
            channels.getDock().setWindowFixedAlwaysOnTop(currentFrame, true);
            currentFrame.setAlwaysOnTop(true);
            t.setTransparent(colorTransparency);
        }
    }

    public static void check() {
        if (current == null || currentFrame == null) {
            return;
        }
        if (currentFrame != channels.getDock().getPopoutFromContent(current)) {
            TransparencyManager.removeTransparent(current);
        }
    }

    public static DockContent getCurrent() {
        return current;
    }

    public static void removeTransparent(DockContent content) {
        TransparencyManager.undoTransparent(content);
        current = null;
    }

    public static void undoTransparent(DockContent content) {
        if (content == null || content != current) {
            return;
        }
        if (currentFrame != null) {
            TransparencyManager.setWindowTransparent(currentFrame, false);
            channels.getDock().setWindowFixedAlwaysOnTop(currentFrame, false);
            currentFrame = null;
        }
        if (currentNotOpaque != null) {
            for (JComponent comp : currentNotOpaque) {
                comp.setOpaque(true);
            }
            currentNotOpaque = null;
        }
        TransparencyManager.findTransparencyComponent(current.getComponent()).setTransparent(0);
    }

    public static List<DockContent> getEligible() {
        List<DockContent> contents = channels.getDock().getContents();
        ArrayList<DockContent> result = new ArrayList<DockContent>();
        for (DockContent content : contents) {
            if (TransparencyManager.findTransparencyComponent(content.getComponent()) == null) continue;
            result.add(content);
        }
        return result;
    }

    public static void toggleTransparent() {
        DockContent content = TransparencyDialog.selectedContent();
        if (content == null) {
            content = current;
        }
        if (content == null) {
            content = TransparencyManager.getEligibleById(currentId);
        }
        if (content == null) {
            return;
        }
        if (content != current || currentNotOpaque == null) {
            TransparencyManager.setTransparent(content);
        } else {
            TransparencyManager.undoTransparent(content);
        }
    }

    private static DockContent getEligibleById(String id) {
        if (id == null) {
            return null;
        }
        for (DockContent content : TransparencyManager.getEligible()) {
            if (!content.getId().equals(id)) continue;
            return content;
        }
        return null;
    }

    public static DockContent getCurrentById() {
        return TransparencyManager.getEligibleById(currentId);
    }

    public static String getCurrentId() {
        return currentId;
    }

    private static void setNotOpaque(Component container, Set<JComponent> notOpaque) {
        Container parent = container.getParent();
        if (container instanceof JComponent) {
            JComponent comp = (JComponent)container;
            if (parent != null && comp.isOpaque()) {
                comp.setOpaque(false);
                notOpaque.add(comp);
            }
        }
        if (parent != null) {
            TransparencyManager.setNotOpaque(parent, notOpaque);
        }
    }

    private static Set<JComponent> setNotOpaque(Component container) {
        HashSet<JComponent> notOpaque = new HashSet<JComponent>();
        TransparencyManager.setNotOpaque(container, notOpaque);
        return notOpaque;
    }

    public static TransparencyComponent findTransparencyComponent(Container container) {
        for (Component c : container.getComponents()) {
            TransparencyComponent result;
            if (c instanceof TransparencyComponent) {
                return (TransparencyComponent)((Object)c);
            }
            if (!(c instanceof Container) || (result = TransparencyManager.findTransparencyComponent((Container)c)) == null) continue;
            return result;
        }
        return null;
    }

    public static void setWindowTransparent(JFrame frame, boolean transparent) {
        if (frame.isUndecorated() == transparent) {
            return;
        }
        boolean frameVisible = frame.isVisible();
        frame.dispose();
        if (transparent) {
            frame.setUndecorated(true);
            frame.setBackground(new Color(0, 0, 0, TransparencyManager.transparencyToAlpha(colorTransparency)));
        } else {
            frame.setBackground(null);
            frame.setUndecorated(false);
        }
        frame.setVisible(true);
        if (MiscUtil.OS_WINDOWS && (!transparent || clickThrough)) {
            TransparencyManager.setWindowTransparentNativeWin(frame, transparent);
        }
        frame.setVisible(frameVisible);
    }

    private static JFrame getPopoutFrame(DockContent content) {
        DockPopout popout = channels.getDock().getPopoutFromContent(content);
        if (popout != null && popout.getWindow() instanceof JFrame) {
            return (JFrame)popout.getWindow();
        }
        return null;
    }

    private static boolean isInPopout(DockContent content) {
        return TransparencyManager.getPopoutFrame(content) != null;
    }

    private static void setWindowTransparentNativeWin(Component w, boolean transparent) {
        WinDef.HWND hwnd = TransparencyManager.getHWnd(w);
        int wl = User32.INSTANCE.GetWindowLong(hwnd, -20);
        wl = transparent ? wl | 0x80000 | 0x20 : wl & 0xFFF7FFFF & 0xFFFFFFDF;
        User32.INSTANCE.SetWindowLong(hwnd, -20, wl);
    }

    private static WinDef.HWND getHWnd(Component w) {
        WinDef.HWND hwnd = new WinDef.HWND();
        hwnd.setPointer(Native.getComponentPointer(w));
        return hwnd;
    }

    public static int transparencyToAlpha(int percentage) {
        if (percentage <= 0) {
            return 0;
        }
        return (int)(255.0 * (1.0 - (double)percentage / 100.0));
    }

    static {
        colorTransparency = 100;
    }
}

