/*
 * Decompiled with CFR 0.152.
 */
package chatty.lang;

import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class Language {
    private static final Logger LOGGER = Logger.getLogger(Language.class.getName());
    private static final boolean DEBUG = false;
    private static ResourceBundle strings;
    public static final ResourceBundle.Control CONTROL;

    public static synchronized void setLanguage(String language) {
        strings = Language.getBundleForLanguage(language);
        LOGGER.info(String.format("[Localization] Loaded locale '%s' for requested '%s'", strings.getLocale(), language));
    }

    public static ResourceBundle getBundleForLanguage(String language) {
        Locale locale = Language.parseLanguage(language);
        try {
            return ResourceBundle.getBundle("chatty.lang.Strings", locale, CONTROL);
        }
        catch (UnsupportedOperationException ex) {
            return ResourceBundle.getBundle("chatty.lang.Strings", locale);
        }
    }

    public static Locale parseLanguage(String language) {
        String[] split = language.split("_");
        Locale locale = language.trim().isEmpty() ? Locale.getDefault() : (split.length == 2 ? new Locale(split[0], split[1]) : new Locale(language));
        return locale;
    }

    public static String getString(String key) {
        return Language.getString(key, true);
    }

    public static synchronized String getString(String key, boolean nonNull) {
        Language.loadIfNecessary();
        if (!strings.containsKey(key)) {
            if (nonNull) {
                LOGGER.warning("Missing string key: " + key);
                return "?";
            }
            return null;
        }
        return strings.getString(key);
    }

    public static synchronized String getString(String key, Object ... arguments) {
        return Language.getString(key, true, arguments);
    }

    public static synchronized String getStringNull(String key) {
        return Language.getString(key, false);
    }

    public static synchronized String getStringNull(String key, Object ... arguments) {
        return Language.getString(key, false, arguments);
    }

    public static synchronized String getString(String key, boolean nonNull, Object ... arguments) {
        Language.loadIfNecessary();
        if (!strings.containsKey(key)) {
            if (nonNull) {
                LOGGER.warning("Missing string key: " + key);
                return "?";
            }
            return null;
        }
        return MessageFormat.format(strings.getString(key), arguments);
    }

    private static void loadIfNecessary() {
        if (strings == null) {
            try {
                strings = ResourceBundle.getBundle("chatty.lang.Strings", CONTROL);
            }
            catch (UnsupportedOperationException ex) {
                strings = ResourceBundle.getBundle("chatty.lang.Strings");
            }
        }
    }

    static {
        CONTROL = new ResourceBundle.Control(){

            @Override
            public List<String> getFormats(String name) {
                return FORMAT_PROPERTIES;
            }

            @Override
            public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
                String bundleName = this.toBundleName(baseName, locale);
                String resourceName = this.toResourceName(bundleName, "properties");
                PropertyResourceBundle bundle = null;
                try (InputStreamReader stream = new InputStreamReader(loader.getResourceAsStream(resourceName), "UTF-8");){
                    bundle = new PropertyResourceBundle(stream);
                }
                return bundle;
            }
        };
    }
}

