/*
 * Decompiled with CFR 0.152.
 */
package chatty.splash;

import chatty.Chatty;
import chatty.Helper;
import chatty.splash.SplashWindow;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.SplashScreen;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.concurrent.ThreadLocalRandom;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class Splash {
    private static final int SPLASH_WIDTH = 300;
    private static final int SPLASH_HEIGHT = 176;
    private static final String thing = Splash.getThing(0, 123456);

    private static String[] getThings() {
        return new String[]{"Happy Birthday, Broughy!", "Top 5 is always possible!", "When's True 100%+?", "Oh hey, thanks!", "Carl Carl, dude dude, man!", "Old Reece still got it cracking.", "Jaffa Kree!", "What fate Omoroca?", "Java is an island as well!", "And we're walking..", "Let's make life take the lemons back!", "CatBag", "Never eat the antennae.", "80 Million Kilograms is a lot of Kilograms", "Color or Colour?", "The hypnotic tick-tack of stilettos on virtual cobble", "Do you get to the cloud district often?", "Getting into the Swing of things..", "I've heard it both ways", "\ud83d\udc23", "Igniting the midnight petroleum!", "Tea, Earl Grey, Hot", "There's coffee in that nebula!", "70k lines of code!", "Free and open-source!", "Batteries not included", "Made with your support!", "Guten Morgen!", "Have a nice day!", "Wind's howling.", "Rac + <Shift-Tab>", "Alternating backgrounds!", "Right-click on all the things!", "Click on username to moderate", "'View - Channel Admin' to set your stream title", "Splash screen!", "Pop goes the weasel!", ":)", "Donaudampfschiffahrtsgesellschaftskapit\u00e4n", "Schleyfsteyn!", "Never dig below your feet!", "Kohle, Kohle, Kohle \ud83c\udfb5", "Remember the Cant!", "Global Hotkeys!"};
    }

    public static String getThing(int minLength, int maxLength) {
        if (Calendar.getInstance().get(6) == 1) {
            return "Happy new year!";
        }
        ArrayList<String> things = new ArrayList<String>(Arrays.asList(Splash.getThings()));
        things.removeIf(s -> s.length() > maxLength || s.length() < minLength);
        if (things.isEmpty()) {
            return "";
        }
        return (String)things.get(ThreadLocalRandom.current().nextInt(things.size()));
    }

    public static void initSplashScreen(Point location) {
        if (SwingUtilities.isEventDispatchThread()) {
            Splash.drawOnSplashscreen(location);
        } else {
            SwingUtilities.invokeLater(() -> Splash.drawOnSplashscreen(location));
        }
    }

    public static void closeSplashScreen() {
        if (SwingUtilities.isEventDispatchThread()) {
            SplashWindow.closeSplashWindow();
        } else {
            SwingUtilities.invokeLater(() -> SplashWindow.closeSplashWindow());
        }
    }

    private static void drawOnSplashscreen(Point location) {
        System.out.println(Chatty.uptimeMillis());
        SplashScreen splash = SplashScreen.getSplashScreen();
        if (splash != null) {
            Graphics2D g = splash.createGraphics();
            if (g != null) {
                Rectangle bounds = splash.getBounds();
                Splash.draw(g, bounds.width, bounds.height);
                splash.update();
            }
        } else {
            SplashWindow.createSplashWindow(new JComponent(){

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    Splash.draw((Graphics2D)g, this.getWidth(), this.getHeight());
                }
            }, location);
        }
    }

    private static void draw(Graphics2D g, int w, int h) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Font boldFont = new Font("Dialog", 1, 12);
        Font regularFont = new Font("Dialog", 0, 12);
        g.setColor(Color.BLACK);
        g.setFont(boldFont);
        int width = g.getFontMetrics().stringWidth(thing);
        g.drawString(thing, w / 2 - width / 2, 160);
        g.setColor(Color.DARK_GRAY);
        g.setFont(regularFont);
        g.drawString("v0.28", 10, 16);
    }

    public static Point getLocation(String setting) {
        if (setting == null) {
            return null;
        }
        String[] split = setting.split(";");
        if (split.length < 2) {
            return null;
        }
        Helper.IntegerPair coords = Helper.getNumbersFromString(split[0]);
        Helper.IntegerPair size = Helper.getNumbersFromString(split[1]);
        Rectangle r = new Rectangle(coords.a, coords.b, size.a, size.b);
        return new Point((int)r.getCenterX() - 150, (int)r.getCenterY() - 88);
    }

    public static void main(String[] args) throws InterruptedException {
        Splash.initSplashScreen(null);
        Thread.sleep(10000L);
        Splash.closeSplashScreen();
    }
}

