/*
 * Decompiled with CFR 0.152.
 */
package chatty.splash;

import chatty.util.IconManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class SplashWindow
extends JFrame {
    private static SplashWindow window = null;

    private SplashWindow(JComponent custom) {
        boolean translucency = SplashWindow.isTranslucencySupported();
        ImageIcon image = new ImageIcon(this.getClass().getResource(translucency ? "splash.png" : "splash_rectangle.png"));
        this.setSize(image.getIconWidth(), image.getIconHeight());
        this.add((Component)new JLabel(image), "Center");
        this.setGlassPane(custom);
        this.getGlassPane().setVisible(true);
        this.setLocationRelativeTo(null);
        this.setUndecorated(true);
        this.setDefaultCloseOperation(3);
        this.setTitle("Chatty starting..");
        this.setWindowIcons();
        if (translucency) {
            this.setBackground(new Color(0, 0, 0, 0));
        }
    }

    private void setWindowIcons() {
        this.setIconImages(IconManager.getMainIcons());
    }

    public static void createSplashWindow(JComponent custom, Point location) {
        SplashWindow.closeSplashWindow();
        window = new SplashWindow(custom);
        if (location != null) {
            window.setLocation(location);
        }
        window.setVisible(true);
    }

    public static void closeSplashWindow() {
        if (window != null) {
            window.setVisible(false);
            window.dispose();
            window = null;
        }
    }

    private static boolean isTranslucencySupported() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        return gd.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.PERPIXEL_TRANSLUCENT);
    }

    public static void main(String[] args) {
        try {
            SplashWindow.createSplashWindow(new JComponent(){}, null);
            Thread.sleep(3000L);
            System.exit(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

