/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import chatty.util.ActivityListener;
import java.awt.AWTEvent;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Timer;

public class ActivityTracker {
    private static final Logger LOGGER = Logger.getLogger(ActivityTracker.class.getName());
    private static final int DELAY = 5000;
    private static final List<ActivityListener> listeners = new ArrayList<ActivityListener>();
    private static Point lastLocation;
    private static long lastMoved;
    private static long lastActivity;
    private static Timer timer;

    public static void startTracking() {
        if (timer == null) {
            ActivityTracker.checkMouseLocation();
            timer = new Timer(5000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActivityTracker.checkMouseLocation();
                }
            });
            timer.start();
            Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent event) {
                    ActivityTracker.triggerActivity();
                }
            }, 24L);
            LOGGER.info("Started tracking user activity..");
        }
    }

    public static void triggerActivity() {
        lastActivity = System.currentTimeMillis();
        ActivityTracker.informListeners();
    }

    private static void checkMouseLocation() {
        PointerInfo info = MouseInfo.getPointerInfo();
        if (info == null) {
            return;
        }
        Point currentLocation = info.getLocation();
        if (lastLocation != null && !lastLocation.equals(currentLocation)) {
            lastMoved = System.currentTimeMillis();
            ActivityTracker.triggerActivity();
        }
        lastLocation = currentLocation;
    }

    public static long getLastActivityTime() {
        return lastActivity;
    }

    public static long getLastActivityAgo() {
        return System.currentTimeMillis() - lastActivity;
    }

    public static long getLastMouseMovedTime() {
        ActivityTracker.startTracking();
        return lastMoved;
    }

    public static long getLastMouseMovedAgo() {
        ActivityTracker.startTracking();
        return System.currentTimeMillis() - lastMoved;
    }

    public static void addActivityListener(ActivityListener listener) {
        if (listener != null) {
            ActivityTracker.startTracking();
            listeners.add(listener);
        }
    }

    public static void removeActivityListener(ActivityListener listener) {
        listeners.remove(listener);
    }

    private static void informListeners() {
        Iterator<ActivityListener> it = listeners.iterator();
        while (it.hasNext()) {
            it.next().activity();
            it.remove();
        }
    }

    static {
        lastMoved = 0L;
        lastActivity = 0L;
    }
}

