/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import chatty.Helper;
import chatty.util.EmoticonListener;
import chatty.util.JSONUtil;
import chatty.util.RetryManager;
import chatty.util.UrlRequest;
import chatty.util.api.Emoticon;
import chatty.util.api.EmoticonUpdate;
import chatty.util.api.TwitchApi;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class BTTVEmotes {
    private static final Logger LOGGER = Logger.getLogger(BTTVEmotes.class.getName());
    private static final String URL_GLOBAL = "https://api.betterttv.net/3/cached/emotes/global";
    private static final String URL_CHANNEL = "https://api.betterttv.net/3/cached/users/twitch/";
    public static final String TEMPLATE = "https://cdn.betterttv.net/emote/{{id}}/{{image}}";
    public static final String GLOBAL = "$global$";
    private final EmoticonListener listener;
    private final TwitchApi api;

    public BTTVEmotes(EmoticonListener listener, TwitchApi api) {
        this.listener = listener;
        this.api = api;
    }

    public synchronized void requestEmotes(String channel, boolean forcedUpdate) {
        String stream = Helper.toStream(channel);
        if (!Helper.isValidStream(stream) && !GLOBAL.equals(stream)) {
            return;
        }
        if (stream.equals(GLOBAL)) {
            this.request(GLOBAL, null, forcedUpdate);
        } else {
            this.api.getUserId(r -> {
                if (!r.hasError()) {
                    this.request(stream, r.getId(stream), forcedUpdate);
                }
            }, stream);
        }
    }

    private void request(String stream, String id, boolean forceRefresh) {
        String url = this.getUrlForStream(id);
        if (forceRefresh) {
            this.requestNow(url, stream);
        } else {
            RetryManager.getInstance().retry(url, k -> this.requestNow(url, stream));
        }
    }

    private void requestNow(String url, String stream) {
        UrlRequest request = new UrlRequest(url);
        request.setLabel("BTTV");
        request.async((result, responseCode) -> {
            if (responseCode == 200 && result != null) {
                this.loadEmotes(result, stream);
                RetryManager.getInstance().setSuccess(url);
            } else if (String.valueOf(responseCode).startsWith("4")) {
                RetryManager.getInstance().setNotFound(url);
            } else {
                RetryManager.getInstance().setError(url);
            }
        });
    }

    private String getUrlForStream(String id) {
        if (id == null) {
            return URL_GLOBAL;
        }
        return URL_CHANNEL + id;
    }

    private int loadEmotes(String json, String streamRestriction) {
        Set<Emoticon> emotes;
        Set<Object> bots = new HashSet();
        if (streamRestriction != null && streamRestriction.equals(GLOBAL)) {
            streamRestriction = null;
        }
        if (streamRestriction == null) {
            emotes = BTTVEmotes.parseGlobalEmotes(json);
        } else {
            emotes = BTTVEmotes.parseChannelEmotes(json, streamRestriction);
            bots = BTTVEmotes.parseBots(json);
        }
        LOGGER.info("|[BTTV] Found " + emotes.size() + " emotes / " + bots.size() + " bots");
        EmoticonUpdate.Builder updateBuilder = new EmoticonUpdate.Builder(emotes);
        updateBuilder.setTypeToRemove(Emoticon.Type.BTTV);
        updateBuilder.setRoomToRemove(streamRestriction);
        this.listener.receivedEmoticons(updateBuilder.build());
        this.listener.receivedBotNames(streamRestriction, bots);
        return emotes.size();
    }

    private static Set<String> parseBots(String json) {
        HashSet<String> result = new HashSet<String>();
        if (json == null) {
            return result;
        }
        JSONParser parser = new JSONParser();
        try {
            JSONObject root = (JSONObject)parser.parse(json);
            JSONArray botsArray = (JSONArray)root.get("bots");
            if (botsArray == null) {
                return result;
            }
            for (Object o : botsArray) {
                result.add((String)o);
            }
        }
        catch (ClassCastException | ParseException ex) {
            LOGGER.warning("|[BTTV] Error parsing bots: " + ex);
        }
        return result;
    }

    private static Set<Emoticon> parseGlobalEmotes(String json) {
        try {
            JSONParser parser = new JSONParser();
            JSONArray root = (JSONArray)parser.parse(json);
            if (root != null) {
                return BTTVEmotes.parseEmotes(root, null);
            }
        }
        catch (Exception ex) {
            LOGGER.warning("|[BTTV] Error parsing global emotes: " + ex);
        }
        return new HashSet<Emoticon>();
    }

    private static Set<Emoticon> parseChannelEmotes(String json, String streamRestriction) {
        HashSet<Emoticon> result = new HashSet<Emoticon>();
        try {
            JSONParser parser = new JSONParser();
            JSONObject root = (JSONObject)parser.parse(json);
            if (root != null) {
                result.addAll(BTTVEmotes.parseEmotes((JSONArray)root.get("channelEmotes"), streamRestriction));
                result.addAll(BTTVEmotes.parseEmotes((JSONArray)root.get("sharedEmotes"), streamRestriction));
            }
        }
        catch (Exception ex) {
            LOGGER.warning("|[BTTV] Error parsing channel emotes: " + ex);
        }
        return result;
    }

    private static Set<Emoticon> parseEmotes(JSONArray data, String channelRestriction) {
        HashSet<Emoticon> emotes = new HashSet<Emoticon>();
        try {
            for (Object o : data) {
                Emoticon emote;
                if (!(o instanceof JSONObject) || (emote = BTTVEmotes.parseEmote((JSONObject)o, TEMPLATE, channelRestriction)) == null) continue;
                emotes.add(emote);
            }
        }
        catch (ClassCastException ex) {
            LOGGER.warning("|[BTTV] Error parsing emotes: " + ex);
        }
        return emotes;
    }

    private static Emoticon parseEmote(JSONObject o, String urlTemplate, String channelRestriction) {
        try {
            Object restriction;
            String code = (String)o.get("code");
            JSONObject user = (JSONObject)o.get("user");
            String userName = null;
            userName = user != null ? JSONUtil.getString(user, "name") : channelRestriction;
            String id = (String)o.get("id");
            String imageType = null;
            if (o.get("imageType") instanceof String) {
                imageType = (String)o.get("imageType");
            }
            if (code == null || code.isEmpty() || id == null || id.isEmpty()) {
                return null;
            }
            Emoticon.Builder builder = new Emoticon.Builder(Emoticon.Type.BTTV, code);
            builder.setCreator(userName);
            builder.setLiteral(true);
            builder.setStringId(id);
            if (channelRestriction != null) {
                builder.addStreamRestriction(channelRestriction);
                builder.setStream(channelRestriction);
            }
            if (imageType != null && imageType.equals("gif")) {
                builder.setAnimated(true);
            }
            if ((restriction = o.get("restrictions")) != null && restriction instanceof JSONObject) {
                JSONObject restrictions = (JSONObject)restriction;
                for (Object r : restrictions.keySet()) {
                    boolean knownAndValid = BTTVEmotes.addRestriction(r, restrictions, builder);
                    if (knownAndValid) continue;
                    return null;
                }
            }
            return builder.build();
        }
        catch (ClassCastException | NullPointerException ex) {
            LOGGER.warning("|[BTTV] Error parsing emote: " + o + " [" + ex + "]");
            return null;
        }
    }

    private static boolean addRestriction(Object restriction, JSONObject restrictions, Emoticon.Builder builder) {
        try {
            String key = (String)restriction;
            if (key.equals("channels")) {
                for (Object chan : (JSONArray)restrictions.get(restriction)) {
                    if (!(chan instanceof String)) continue;
                    builder.addStreamRestriction((String)chan);
                }
                return true;
            }
            if (key.equals("emoticonSet")) {
                Object emoticon_set = restrictions.get(key);
                if (emoticon_set != null) {
                    if (emoticon_set instanceof String) {
                        return false;
                    }
                    builder.setEmoteset(String.valueOf(((Number)emoticon_set).intValue()));
                    return true;
                }
            } else {
                Object value = restrictions.get(restriction);
                if (value == null || ((JSONArray)value).isEmpty()) {
                    return true;
                }
            }
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            // empty catch block
        }
        return false;
    }
}

