/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import chatty.util.Debugging;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;

public class BatchAction {
    private static final Map<Object, Runnable> queued = new HashMap<Object, Runnable>();
    private static Timer timer;

    public static void queue(Object id, Runnable runnable) {
        BatchAction.queue(id, 10L, true, true, runnable);
    }

    public static void queue(final Object id, long delay, final boolean edt, boolean overwrite, Runnable runnable) {
        boolean scheduleTask = BatchAction.prepare(id, overwrite, runnable);
        if (scheduleTask) {
            timer.schedule(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Runnable r;
                    Map map = queued;
                    synchronized (map) {
                        r = (Runnable)queued.remove(id);
                    }
                    if (r != null) {
                        if (edt) {
                            SwingUtilities.invokeLater(() -> r.run());
                        } else {
                            r.run();
                        }
                    }
                }
            }, delay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean prepare(Object id, boolean overwrite, Runnable runnable) {
        Map<Object, Runnable> map = queued;
        synchronized (map) {
            if (!queued.containsKey(id)) {
                if (timer == null) {
                    timer = new Timer("BatchAction", true);
                }
                queued.put(id, runnable);
                return true;
            }
            if (overwrite) {
                Debugging.println("batchaction", "Overwriting %s", id);
                queued.put(id, runnable);
            }
            return false;
        }
    }
}

