/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

public class BitEncoder {
    private final int[][] valueDef;
    private final int[] values;

    public BitEncoder(int[] ... valueDef) {
        this.valueDef = valueDef;
        this.values = new int[valueDef.length];
    }

    public void setValue(int id, int value) {
        this.values[id] = value;
    }

    public int getValue(int id) {
        return this.values[id];
    }

    public long encode() {
        int result = 0;
        int count = 0;
        for (int id = 0; id < this.valueDef.length; ++id) {
            for (int i = 0; i < this.valueDef[id].length; ++i) {
                if (this.valueDef[id][i] == this.values[id]) {
                    result = (int)((double)result + Math.pow(2.0, count));
                }
                ++count;
            }
        }
        return result;
    }

    public void decode(long value) {
        int count = 0;
        for (int id = 0; id < this.valueDef.length; ++id) {
            for (int i = 0; i < this.valueDef[id].length; ++i) {
                long bitmask = (long)Math.pow(2.0, count);
                if ((value & bitmask) == bitmask) {
                    this.values[id] = this.valueDef[id][i];
                }
                ++count;
            }
        }
    }
}

