/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import chatty.util.StringUtil;
import chatty.util.settings.Settings;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BotNameManager {
    private final Map<String, Set<String>> botNames = new HashMap<String, Set<String>>();
    private final Set<BotNameListener> listeners = new HashSet<BotNameListener>();

    public BotNameManager(Settings settings) {
        if (settings != null) {
            for (Object name : settings.getList("botNames")) {
                this.addBotName(null, (String)name);
            }
        }
    }

    public void addBotNames(String channel, Set<String> botNames) {
        for (String name : botNames) {
            this.addBotName(channel, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addBotName(String channel, String botName) {
        if (botName == null || botName.isEmpty()) {
            return;
        }
        botName = StringUtil.toLowerCase(botName);
        Map<String, Set<String>> map = this.botNames;
        synchronized (map) {
            if (!this.botNames.containsKey(channel)) {
                this.botNames.put(channel, new HashSet());
            }
            this.botNames.get(channel).add(StringUtil.toLowerCase(botName));
        }
        this.informListeners(channel, botName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBotName(String channel, String botName) {
        Map<String, Set<String>> map = this.botNames;
        synchronized (map) {
            return this.botNames.containsKey(channel) && this.botNames.get(channel).contains(botName) || this.botNames.containsKey(null) && this.botNames.get(null).contains(botName);
        }
    }

    public void addListener(BotNameListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    private void informListeners(String channel, String botName) {
        for (BotNameListener listener : this.listeners) {
            listener.botNameAdded(channel, botName);
        }
    }

    public static interface BotNameListener {
        public void botNameAdded(String var1, String var2);
    }
}

