/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import chatty.util.Debugging;
import chatty.util.MiscUtil;
import chatty.util.Pair;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class CachedBulkManager<Key, Item> {
    private static final Logger LOGGER = Logger.getLogger(CachedBulkManager.class.getName());
    private final Object LOCK = new Object();
    public static final int NONE = 0;
    public static final int RETRY = 1;
    public static final int ASAP = 2;
    public static final int WAIT = 4;
    public static final int REFRESH = 8;
    public static final int DAEMON = 16;
    public static final int UNIQUE = 32;
    public static final int PARTIAL = 64;
    public static final int NO_REPLACE = 128;
    private final Options options;
    private final String debugPrefix;
    private long cacheRefresh;
    private long cacheRemove;
    private long testTimestamp = -1L;
    private final Map<Object, Query<Key, Item>> queries = new HashMap<Object, Query<Key, Item>>();
    private final Requester<Key, Item> requester;
    private final Map<Key, Long> requestPending = new HashMap<Key, Long>();
    private final Map<Key, CacheItem<Item>> cache = new HashMap<Key, CacheItem<Item>>();
    private final Map<Key, Long> lastError = new HashMap<Key, Long>();
    private final Map<Key, Integer> errorCount = new HashMap<Key, Integer>();
    private final Set<Key> notFound = new HashSet<Key>();
    private volatile boolean requestingInProgress;
    static int test = 0;

    public CachedBulkManager(Requester<Key, Item> requester, int settings) {
        this(requester, "Default", settings);
    }

    public CachedBulkManager(Requester<Key, Item> requester, String debugPrefix, int settings) {
        this.requester = requester;
        this.options = new Options(settings);
        this.debugPrefix = debugPrefix;
        int timerDelay = 10000;
        Timer timer = new Timer("CachedBulkManager." + debugPrefix, this.options.contains(16));
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                CachedBulkManager.this.doRequests();
            }
        }, timerDelay, (long)timerDelay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheTimes(int refresh, int remove, TimeUnit unit) {
        Object object = this.LOCK;
        synchronized (object) {
            this.cacheRefresh = unit.toMillis(refresh);
            this.cacheRemove = unit.toMillis(remove);
        }
    }

    private boolean shouldRemove(CacheItem<Item> item) {
        return item == null || this.cacheRemove > 0L && item.millisecondsPassed(this.cacheRemove);
    }

    private boolean shouldRefresh(CacheItem<Item> item) {
        return item == null || this.shouldRemove(item) || this.cacheRefresh > 0L && item.millisecondsPassed(this.cacheRefresh);
    }

    private void checkRemoveCache(Key key) {
        if (this.shouldRemove(this.cache.get(key))) {
            this.cache.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCacheToFile(Path file, BiFunction<Key, Item, String> itemToString) {
        Object object = this.LOCK;
        synchronized (object) {
            JSONObject data = new JSONObject();
            JSONArray items = new JSONArray();
            for (Map.Entry<Key, CacheItem<Item>> entry : this.cache.entrySet()) {
                if (this.shouldRemove(entry.getValue())) continue;
                JSONArray item = new JSONArray();
                item.add(entry.getValue().valueTimestamp);
                String value = itemToString.apply(entry.getKey(), entry.getValue().value);
                if (value == null) continue;
                item.add(value);
                items.add(item);
            }
            data.put("items", items);
            try (BufferedWriter writer = Files.newBufferedWriter(file, Charset.forName("UTF-8"), new OpenOption[0]);){
                writer.write(data.toJSONString());
                LOGGER.info(String.format("%sSaved to %s (%d/%d items)", this.debugPrefix, file, items.size(), this.cache.size()));
            }
            catch (IOException ex) {
                LOGGER.warning(String.format("%sError saving cache to %s: %s", this.debugPrefix, file, ex));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCacheFromFile(Path file, Function<String, Pair<Key, Item>> stringToItem) {
        Object object = this.LOCK;
        synchronized (object) {
            try (BufferedReader reader = Files.newBufferedReader(file, Charset.forName("UTF-8"));){
                JSONParser parser = new JSONParser();
                JSONObject root = (JSONObject)parser.parse(reader);
                JSONArray items = (JSONArray)root.get("items");
                for (Object o : items) {
                    CacheItem cacheItem;
                    JSONArray item = (JSONArray)o;
                    long timestamp = (Long)item.get(0);
                    String value = (String)item.get(1);
                    Pair<Key, Item> parsedItem = stringToItem.apply(value);
                    if (parsedItem == null || this.shouldRemove(cacheItem = new CacheItem(parsedItem.value, timestamp))) continue;
                    this.cache.put(parsedItem.key, cacheItem);
                }
                LOGGER.info(String.format("%sLoaded from %s (%d/%d items)", this.debugPrefix, file, this.cache.size(), items.size()));
            }
            catch (Exception ex) {
                LOGGER.warning(String.format("%sError loading cache from %s: %s", this.debugPrefix, file, ex));
            }
        }
    }

    private long currentTimestamp() {
        if (this.testTimestamp != -1L) {
            return this.testTimestamp;
        }
        return System.currentTimeMillis();
    }

    public void setCurrentTimestamp(long timestamp) {
        this.testTimestamp = timestamp;
    }

    @SafeVarargs
    public final void query(ResultListener<Key, Item> listener, int settings, Key ... keys) {
        this.query(listener, settings, (Collection<Key>)Arrays.asList(keys));
    }

    public Object query(ResultListener<Key, Item> listener, int settings, Collection<Key> keys) {
        return this.query((Object)null, listener, settings, keys);
    }

    @SafeVarargs
    public final void query(Object unique, ResultListener<Key, Item> listener, int settings, Key ... keys) {
        this.query(unique, listener, settings, (Collection<Key>)Arrays.asList(keys));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object query(Object unique, ResultListener<Key, Item> listener, int settings, Collection<Key> keys) {
        if (keys.isEmpty()) {
            return null;
        }
        if (unique == null) {
            unique = new Object();
        }
        Query<Key, Item> query = new Query<Key, Item>(listener, settings, keys);
        Object object = this.LOCK;
        synchronized (object) {
            if (this.option(query, 32) && this.queries.containsValue(query)) {
                return null;
            }
            if (this.option(query, 128) && this.queries.containsKey(unique)) {
                return null;
            }
            this.queries.put(unique, query);
            if (this.option(query, 8)) {
                for (Object key : query.keys) {
                    this.cache.remove(key);
                }
            }
        }
        this.checkDoneQueries();
        if (this.doImmediately(query)) {
            this.doRequests();
        }
        return unique;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doImmediately(Query<Key, Item> request) {
        Object object = this.LOCK;
        synchronized (object) {
            return this.option(request, 2) && this.queries.containsValue(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasQueryKey(Key key) {
        Object object = this.LOCK;
        synchronized (object) {
            for (Query<Key, Item> q : this.queries.values()) {
                if (!q.keys.contains(key)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Item get(Key key) {
        Object object = this.LOCK;
        synchronized (object) {
            this.checkRemoveCache(key);
            CacheItem<Item> cached = this.cache.get(key);
            if (cached != null) {
                return cached.value;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCachedValue(Key key) {
        Object object = this.LOCK;
        synchronized (object) {
            this.cache.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Item getOrQuerySingle(Object unique, ResultListener<Key, Item> listener, int settings, Key key) {
        Item result = null;
        Object object = this.LOCK;
        synchronized (object) {
            this.checkRemoveCache(key);
            CacheItem<Item> cached = this.cache.get(key);
            if (cached != null) {
                result = cached.value;
            }
            if (!this.shouldRefresh(cached)) {
                return result;
            }
        }
        this.query(unique, listener, settings, key);
        return result;
    }

    public Item getOrQuerySingle(ResultListener<Key, Item> listener, int settings, Key key) {
        return this.getOrQuerySingle(null, listener, settings, key);
    }

    @SafeVarargs
    public final Result<Key, Item> getOrQuery(Object unique, ResultListener<Key, Item> listener, int settings, Key ... keys) {
        return this.getOrQuery(unique, listener, settings, (Collection<Key>)Arrays.asList(keys));
    }

    public Result<Key, Item> getOrQuery(Object unique, ResultListener<Key, Item> listener, int settings, Collection<Key> keys) {
        Query<Key, Item> request = new Query<Key, Item>(listener, settings, keys);
        Result<Key, Item> result = this.getResult(request);
        if (result == null || !((Result)result).hasAllKeys) {
            this.query(unique, listener, settings, keys);
        }
        return result;
    }

    @SafeVarargs
    public final void setError(Key ... keys) {
        this.setError((Collection<Key>)Arrays.asList(keys));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setError(Collection<Key> keys) {
        Object object = this.LOCK;
        synchronized (object) {
            for (Key key : keys) {
                this.lastError.put(key, MiscUtil.ems());
                this.setResponseReceived(key);
                this.errorCount.put(key, this.errorCount.getOrDefault(key, 0) + 1);
            }
        }
        this.checkDoneQueries();
    }

    @SafeVarargs
    public final void setNotFound(Key ... keys) {
        this.setNotFound((Collection<Key>)Arrays.asList(keys));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotFound(Collection<Key> keys) {
        Object object = this.LOCK;
        synchronized (object) {
            this.notFound.addAll(keys);
            for (Key key : keys) {
                this.errorCount.remove(key);
                this.setResponseReceived(key);
            }
        }
        this.checkDoneQueries();
    }

    public void setResult(Key key, Item item) {
        this.setResult(key, item, this.currentTimestamp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(Key key, Item item, long timestamp) {
        Object object = this.LOCK;
        synchronized (object) {
            this.setResultInternal(key, item, timestamp);
        }
        this.checkDoneQueries();
    }

    public void setResult(Map<Key, Item> results) {
        this.setResult(results, this.currentTimestamp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(Map<Key, Item> results, long timestamp) {
        Object object = this.LOCK;
        synchronized (object) {
            for (Map.Entry<Key, Item> entry : results.entrySet()) {
                this.setResultInternal(entry.getKey(), entry.getValue(), timestamp);
            }
        }
        this.checkDoneQueries();
    }

    private void setResultInternal(Key key, Item item, long timestamp) {
        this.cache.put(key, new CacheItem<Item>(item, timestamp));
        this.errorCount.remove(key);
        this.notFound.remove(key);
        this.setResponseReceived(key);
    }

    private void setResponseReceived(Key key) {
        this.requestPending.remove(key);
        for (Query<Key, Item> r : this.queries.values()) {
            r.responseReceived(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String debug() {
        Object object = this.LOCK;
        synchronized (object) {
            return String.format("requests: %d pending: %d", this.queries.size(), this.requestPending.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String debugVerbose() {
        Object object = this.LOCK;
        synchronized (object) {
            return String.format("requests: %d pending: %d [%s]", this.queries.size(), this.requestPending.size(), this.queries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int pendingRequests() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.queries.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRequested(Collection<Key> keys) {
        if (keys != null && !keys.isEmpty()) {
            Object object = this.LOCK;
            synchronized (object) {
                for (Key key : keys) {
                    this.requestPending.put(key, MiscUtil.ems());
                }
            }
        }
    }

    @SafeVarargs
    public final void setRequested(Key ... keys) {
        this.setRequested((Collection<Key>)Arrays.asList(keys));
    }

    public Set<Key> makeAndSetRequested(Set<Key> asap, Set<Key> normal, Set<Key> backlog, int limit) {
        HashSet toRequest = new HashSet();
        MiscUtil.addLimited(asap, toRequest, limit);
        MiscUtil.addLimited(normal, toRequest, limit);
        MiscUtil.addLimited(backlog, toRequest, limit);
        this.setRequested(toRequest);
        return toRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRequests() {
        if (this.requestingInProgress) {
            LOGGER.warning("Ignored doRequests");
            return;
        }
        this.requestingInProgress = true;
        HashSet asap = new HashSet();
        HashSet normal = new HashSet();
        HashSet backlog = new HashSet();
        Object object = this.LOCK;
        synchronized (object) {
            for (Query<Key, Item> request : this.queries.values()) {
                this.addKeys(request, asap, normal, backlog);
            }
            for (Query<Key, Item> key : asap) {
                normal.remove(key);
                backlog.remove(key);
            }
            for (Query<Key, Item> key : normal) {
                backlog.remove(key);
            }
        }
        if (!asap.isEmpty() || !normal.isEmpty()) {
            this.requester.request(this, asap, normal, backlog);
        }
        this.requestingInProgress = false;
    }

    private void addKeys(Query<Key, Item> query, Set<Key> asap, Set<Key> normal, Set<Key> backlog) {
        for (Object key : query.keys) {
            if (this.requestPending.containsKey(key) || query.isAccepted(key)) continue;
            if (this.checkError(key, query)) {
                if (this.option(query, 2)) {
                    asap.add(key);
                    continue;
                }
                normal.add(key);
                continue;
            }
            backlog.add(key);
        }
    }

    private boolean checkError(Key key, Query<Key, Item> q) {
        if (this.option(q, 8) && !q.isResponseReceived(key)) {
            return true;
        }
        if (this.lastError.containsKey(key)) {
            long delay = this.errorDelay(key, q);
            delay += (long)ThreadLocalRandom.current().nextInt((int)((double)delay * 0.05) + 1);
            Debugging.println("cbm", "%sError delay: %d > %d (%s)", this.debugPrefix, this.secondsPassed(this.lastError, key), delay, key);
            return this.secondsPassed(this.lastError, key) > delay;
        }
        return true;
    }

    private long errorDelay(Key key, Query<Key, Item> r) {
        int errors = this.errorCount.getOrDefault(key, 0);
        int base = this.option(r, 2) ? 2 : 10;
        return (long)Math.min((double)base * Math.pow(10.0, errors), 1800.0);
    }

    private void checkDoneQueries() {
        Collection<Result<Key, Item>> completed = this.getDoneQueries();
        if (completed == null) {
            return;
        }
        for (Result<Key, Item> result : completed) {
            if (((Result)result).query.resultListener == null) continue;
            ((Result)result).query.resultListener.result(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Result<Key, Item>> getDoneQueries() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.queries.isEmpty()) {
                return null;
            }
            Collection<Result<Key, Item>> results = this.getDoneQueries2();
            return results;
        }
    }

    private Collection<Result<Key, Item>> getDoneQueries2() {
        ArrayList<Result<Key, Item>> results = new ArrayList<Result<Key, Item>>();
        Iterator<Map.Entry<Object, Query<Key, Item>>> it = this.queries.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Query<Key, Item>> entry = it.next();
            Result<Key, Item> requestResult = this.getResult(entry.getValue());
            if (requestResult == null) continue;
            results.add(requestResult);
            if (!((Result)requestResult).hasAllKeys) continue;
            it.remove();
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result<Key, Item> getResult(Query<Key, Item> q) {
        Object object = this.LOCK;
        synchronized (object) {
            Result result;
            boolean enoughKeys;
            HashMap results = new HashMap();
            HashSet waitErrors = new HashSet();
            for (Object k : q.keys) {
                if (this.option(q, 8) && !q.isResponseReceived(k)) continue;
                this.checkRemoveCache(k);
                CacheItem<Item> cached = this.cache.get(k);
                if (!this.shouldRefresh(cached) || cached != null && q.isResponseReceived(k)) {
                    results.put(k, cached.value);
                } else if (this.notFound.contains(k)) {
                    results.put(k, null);
                } else if (this.secondsPassed(this.lastError, k) < this.errorDelay(k, q)) {
                    if (this.option(q, 1) || this.option(q, 4)) {
                        waitErrors.add(k);
                    } else {
                        results.put(k, null);
                    }
                }
                if (!results.containsKey(k) || results.get(k) != null || cached == null) continue;
                results.put(k, cached.value);
            }
            q.accepted.addAll(results.keySet());
            boolean hasAllKeys = results.size() == q.keys.size();
            boolean hasAllKeysOrErrors = results.size() + waitErrors.size() == q.keys.size();
            boolean partial = this.option(q, 64) || this.option(q, 1);
            boolean bl = enoughKeys = this.option(q, 64) || hasAllKeysOrErrors;
            if ((hasAllKeys || partial && results.size() > 0 && enoughKeys) && !q.sameResult(result = new Result(results, q, hasAllKeys))) {
                q.setResult(result);
                return result;
            }
            return null;
        }
    }

    private boolean option(Query<Key, Item> r, int option) {
        return r.options.contains(option) || this.options.contains(option);
    }

    private long secondsPassed(Map<Key, Long> map, Key key) {
        if (!map.containsKey(key)) {
            return Long.MAX_VALUE;
        }
        return TimeUnit.MILLISECONDS.toSeconds(MiscUtil.ems() - map.get(key));
    }

    public static void main(String[] args) throws Exception {
        CachedBulkManager m = new CachedBulkManager((manager, asap, normal, backlog) -> {
            System.out.println("request");
            manager.setRequested(asap);
            SwingUtilities.invokeLater(() -> {
                for (String key : asap) {
                    if (test < 1) {
                        manager.setResult(key, key + "result" + System.currentTimeMillis());
                    } else {
                        System.out.println("setError");
                        manager.setError(asap);
                    }
                    ++test;
                }
            });
        }, 16);
        m.setCacheTimes(100, 200, TimeUnit.MILLISECONDS);
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("a");
        m.query((Object)null, (Result<Key, Item> result) -> System.out.println(result), 2, (Collection<Key>)keys);
        Thread.sleep(150L);
        System.out.println("----");
        m.query(null, (Result<Key, Item> r) -> System.out.println(r), 2, "a");
        m.query(null, (Result<Key, Item> r) -> System.out.println(r), 2, "a");
        System.out.println(m.debugVerbose());
    }

    public static interface Requester<Key, Item> {
        public void request(CachedBulkManager<Key, Item> var1, Set<Key> var2, Set<Key> var3, Set<Key> var4);
    }

    private static class Options {
        private final int options;

        protected Options(int options) {
            this.options = options;
        }

        public boolean contains(int option) {
            return (this.options & option) == option;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Options other = (Options)obj;
            return this.options == other.options;
        }

        public int hashCode() {
            int hash = 7;
            hash = 37 * hash + this.options;
            return hash;
        }
    }

    private class CacheItem<Item> {
        public final Item value;
        public final long valueTimestamp;

        public CacheItem(Item value, long timestamp) {
            this.value = value;
            this.valueTimestamp = timestamp;
        }

        public boolean millisecondsPassed(long milliseconds) {
            return this.getMillisecondsPassed() >= milliseconds;
        }

        public long getMillisecondsPassed() {
            return CachedBulkManager.this.currentTimestamp() - this.valueTimestamp;
        }

        public String toString() {
            return String.format("(%d)%s", this.getMillisecondsPassed() / 1000L, this.value);
        }
    }

    public static interface ResultListener<Key, Item> {
        public void result(Result<Key, Item> var1);
    }

    private static class Query<Key, Item> {
        public final Options options;
        public final ResultListener<Key, Item> resultListener;
        public final Set<Key> keys;
        private final Set<Key> accepted = new HashSet<Key>();
        private final Set<Key> responseReceived = new HashSet<Key>();
        private Result<Key, Item> result;

        Query(ResultListener<Key, Item> resultListener, int settings, Collection<Key> keys) {
            this.options = new Options(settings);
            HashSet<Key> set = new HashSet<Key>(keys);
            this.keys = Collections.unmodifiableSet(set);
            this.resultListener = resultListener;
        }

        public void accepted(Key key) {
            this.accepted.add(key);
        }

        public boolean isAccepted(Key key) {
            return this.accepted.contains(key);
        }

        public void responseReceived(Key key) {
            if (this.keys.contains(key)) {
                this.responseReceived.add(key);
            }
        }

        public boolean isResponseReceived(Key key) {
            return this.responseReceived.contains(key);
        }

        public void setResult(Result<Key, Item> result) {
            this.result = result;
        }

        public Result<Key, Item> getResult() {
            return this.result;
        }

        public boolean sameResult(Result<Key, Item> result) {
            return Objects.equals(this.result, result);
        }

        public String toString() {
            return this.keys.toString();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Query other = (Query)obj;
            if (!Objects.equals(this.options, other.options)) {
                return false;
            }
            if (!Objects.equals(this.resultListener, other.resultListener)) {
                return false;
            }
            return Objects.equals(this.keys, other.keys);
        }

        public int hashCode() {
            int hash = 7;
            hash = 11 * hash + Objects.hashCode(this.options);
            hash = 11 * hash + Objects.hashCode(this.resultListener);
            hash = 11 * hash + Objects.hashCode(this.keys);
            return hash;
        }
    }

    public static class Result<Key, Item> {
        private final Query<Key, Item> query;
        private final Map<Key, Item> results;
        private final boolean hasAllKeys;

        private Result(Map<Key, Item> results, Query<Key, Item> query, boolean hasAllKeys) {
            this.results = new HashMap<Key, Item>(results);
            this.hasAllKeys = hasAllKeys;
            this.query = query;
        }

        public Item get(Key key) {
            return this.results.get(key);
        }

        public boolean hasAllKeys() {
            return this.hasAllKeys;
        }

        public Map<Key, Item> getResults() {
            return this.results;
        }

        public String toString() {
            return this.query + " -> " + this.results;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Result other = (Result)obj;
            return Objects.equals(this.results, other.results);
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + Objects.hashCode(this.results);
            return hash;
        }
    }
}

