/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import chatty.util.JSONUtil;
import chatty.util.UrlRequest;
import chatty.util.api.Emoticon;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class ChattyMisc {
    private static final Logger LOGGER = Logger.getLogger(ChattyMisc.class.getName());
    private static volatile CombinedEmotesInfo combinedEmotesInfo = new CombinedEmotesInfo();
    private static final Object SMILIES_LOCK = new Object();
    private static Map<String, Set<Emoticon>> smilies;
    private static Map<String, Set<String>> smiliesSets;

    public static void request(Runnable responseReceived) {
        UrlRequest request = new UrlRequest("https://tduva.com/res/misc");
        request.setLabel("Misc");
        request.async((result, responseCode) -> {
            if (responseCode == 200) {
                ChattyMisc.parseMisc(result);
                responseReceived.run();
            }
        });
    }

    private static void parseMisc(String text) {
        try {
            JSONParser parser = new JSONParser();
            JSONObject root = (JSONObject)parser.parse(text);
            ChattyMisc.parseCombinedEmotes((JSONArray)root.get("combined_emotes"));
            ChattyMisc.parseSmilies((JSONObject)root.get("smilies"));
        }
        catch (Exception ex) {
            LOGGER.warning("Error parsing misc: " + ex);
        }
    }

    private static void parseCombinedEmotes(JSONArray root) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Object entry : root) {
            JSONObject emote = (JSONObject)entry;
            String code = JSONUtil.getString(emote, "code");
            int offset = JSONUtil.getInteger(emote, "yOffset", 0);
            if (code == null) continue;
            result.put(code, offset);
        }
        LOGGER.info(String.format(Locale.ROOT, "Found %d combined emotes", result.size()));
        combinedEmotesInfo = new CombinedEmotesInfo(result);
    }

    public static CombinedEmotesInfo getCombinedEmotesInfo() {
        return combinedEmotesInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseSmilies(JSONObject root) {
        HashMap<String, Set<Emoticon>> result = new HashMap<String, Set<Emoticon>>();
        HashMap<String, Set<String>> setsResult = new HashMap<String, Set<String>>();
        for (Object key : root.keySet()) {
            String type = (String)key;
            result.put(type, new HashSet());
            setsResult.put(type, new HashSet());
            JSONObject data = (JSONObject)root.get(key);
            JSONArray emotes = (JSONArray)data.get("emotes");
            for (Object item : emotes) {
                JSONObject emoteData = (JSONObject)item;
                String id = JSONUtil.getString(emoteData, "id");
                String code = JSONUtil.getString(emoteData, "code");
                String regex = JSONUtil.getString(emoteData, "regex");
                Emoticon.Builder b = new Emoticon.Builder(Emoticon.Type.TWITCH, code);
                b.setStringId(id);
                b.setRegex(regex);
                ((Set)result.get(type)).add(b.build());
            }
            JSONArray sets = (JSONArray)data.get("sets");
            if (sets == null) continue;
            for (Object item : sets) {
                ((Set)setsResult.get(type)).add((String)item);
            }
        }
        Object object = SMILIES_LOCK;
        synchronized (object) {
            smilies = result;
            smiliesSets = setsResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Set<Emoticon>> getSmilies() {
        Object object = SMILIES_LOCK;
        synchronized (object) {
            return smilies;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTypeByEmoteId(String emoteId) {
        Object object = SMILIES_LOCK;
        synchronized (object) {
            if (smilies != null) {
                for (Map.Entry<String, Set<Emoticon>> entry : smilies.entrySet()) {
                    String type = entry.getKey();
                    for (Emoticon emote : entry.getValue()) {
                        if (!emote.stringId.equals(emoteId)) continue;
                        return type;
                    }
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTypeByEmoteSet(String setId) {
        Object object = SMILIES_LOCK;
        synchronized (object) {
            if (smiliesSets != null) {
                for (Map.Entry<String, Set<String>> entry : smiliesSets.entrySet()) {
                    String type = entry.getKey();
                    for (String set : entry.getValue()) {
                        if (!set.equals(setId)) continue;
                        return type;
                    }
                }
            }
            return null;
        }
    }

    public static class CombinedEmotesInfo {
        private final Map<String, Integer> data = new HashMap<String, Integer>();

        public CombinedEmotesInfo() {
        }

        public CombinedEmotesInfo(Map<String, Integer> data) {
            this.data.putAll(data);
        }

        public boolean containsCode(String code) {
            return this.data.containsKey(code);
        }

        public int getOffset(String code) {
            Integer result = this.data.get(code);
            if (result != null) {
                return result;
            }
            return 0;
        }

        public boolean isEmpty() {
            return this.data.isEmpty();
        }
    }
}

