/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import chatty.util.ChattyMisc;
import chatty.util.Debugging;
import chatty.util.api.CachedImage;
import chatty.util.api.Emoticon;
import chatty.util.gif.Overlay;
import java.awt.Image;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class CombinedEmoticon
extends Emoticon {
    private static final Logger LOGGER = Logger.getLogger(CombinedEmoticon.class.getName());
    private final List<Emoticon> emotes;
    private final CachedImage.ImageType imageType;
    private final Set<CachedImage<Emoticon>> alreadyMade = new HashSet<CachedImage<Emoticon>>();

    public static String getCode(List<Emoticon> emotes) {
        StringBuilder result = new StringBuilder();
        for (Emoticon emote : emotes) {
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(emote.code);
        }
        return result.toString();
    }

    public static CombinedEmoticon create(List<Emoticon> emotes, String code, CachedImage.ImageType imageType) {
        Debugging.println("combinedemotes", "Create: %s", emotes);
        Emoticon base = emotes.get(0);
        Emoticon.Builder b = new Emoticon.Builder(base.type, code);
        b.setImageUrl(base.url);
        b.setStringId(base.stringId);
        b.setStringIdAlias(base.stringIdAlias);
        b.setLiteral(base.literal);
        b.setAnimated(false);
        int maxWidth = -1;
        int maxHeight = -1;
        for (Emoticon emote : emotes) {
            maxWidth = Math.max(maxWidth, emote.getWidth());
            maxHeight = Math.max(maxHeight, emote.getHeight());
            if (!emote.isAnimated()) continue;
            b.setAnimated(true);
            break;
        }
        b.setSize(maxWidth, maxHeight);
        b.setSubType(base.subType);
        b.addInfo("Special Combined Emote");
        return new CombinedEmoticon(b, emotes, imageType);
    }

    private CombinedEmoticon(Emoticon.Builder b, List<Emoticon> emotes, CachedImage.ImageType imageType) {
        super(b);
        this.emotes = emotes;
        this.imageType = imageType;
    }

    public List<Emoticon> getEmotes() {
        return new ArrayList<Emoticon>(this.emotes);
    }

    @Override
    public CachedImage<Emoticon> getIcon(final float scaleFactor, final int maxHeight, CachedImage.ImageType imageType, final CachedImage.CachedImageUser user) {
        CachedImage<Emoticon> emoteImage = super.getIcon(scaleFactor, maxHeight, CachedImage.ImageType.TEMP, user);
        Debugging.println("combinedemotes", "Get: %s [%s] %s", this.emotes, System.identityHashCode(this), this.alreadyMade.contains(emoteImage));
        if (this.alreadyMade.contains(emoteImage)) {
            return emoteImage;
        }
        Timer timer = new Timer(2000, e -> this.makeImage(scaleFactor, maxHeight, user));
        timer.setRepeats(false);
        timer.start();
        boolean allLoaded = true;
        for (Emoticon emote : this.emotes) {
            CachedImage<Emoticon> image = emote.getIcon(scaleFactor, maxHeight, imageType, new CachedImage.CachedImageUser(){

                @Override
                public void iconLoaded(Image oldImage, Image newImage, boolean sizeChanged) {
                    Debugging.println("combinedemotes", "iconLoaded: %s [%s]", CombinedEmoticon.this.emotes, System.identityHashCode(CombinedEmoticon.this));
                    SwingUtilities.invokeLater(() -> CombinedEmoticon.this.makeImage(scaleFactor, maxHeight, user));
                }
            });
            if (image.isLoaded()) continue;
            allLoaded = false;
            image.getImageIcon();
        }
        if (allLoaded) {
            this.makeImage(scaleFactor, maxHeight, user);
        }
        return emoteImage;
    }

    private void makeImage(float scaleFactor, int maxHeight, CachedImage.CachedImageUser user) {
        ImageIcon result;
        CachedImage<Emoticon> emoteImage = super.getIcon(scaleFactor, maxHeight, CachedImage.ImageType.TEMP, user);
        if (this.alreadyMade.contains(emoteImage)) {
            return;
        }
        Debugging.println("combinedemotes", "Make: %s [%s]", this.emotes, System.identityHashCode(this));
        LinkedHashMap<ImageIcon, Integer> data = new LinkedHashMap<ImageIcon, Integer>();
        for (Emoticon emote : this.emotes) {
            CachedImage<Emoticon> image = emote.getIcon(scaleFactor, maxHeight, this.imageType, null);
            if (!image.isLoaded()) {
                LOGGER.warning(image.getObject() + " not loaded for " + this.emotes);
                return;
            }
            int yOffset = ChattyMisc.getCombinedEmotesInfo().getOffset(emote.code);
            data.put(image.getImageIcon(), yOffset);
        }
        try {
            result = Overlay.overlayNew(data);
        }
        catch (Exception ex) {
            LOGGER.warning("Error when combining " + this.emotes + ": " + ex);
            return;
        }
        this.alreadyMade.add(emoteImage);
        emoteImage.setImageIcon(result, true);
    }
}

