/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import java.util.Collection;
import java.util.Iterator;

public class CombinedIterator<T>
implements Iterator<T> {
    private final Iterator<T> itA;
    private final Iterator<T> itB;
    private Iterator<T> lastUsed;

    public CombinedIterator(Collection<T> a, Collection<T> b) {
        this.itA = a.iterator();
        this.itB = b.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.itA.hasNext() || this.itB.hasNext();
    }

    @Override
    public T next() {
        if (this.itA.hasNext()) {
            this.lastUsed = this.itA;
            return this.itA.next();
        }
        this.lastUsed = this.itB;
        return this.itB.next();
    }

    @Override
    public void remove() {
        this.lastUsed.remove();
    }
}

