/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import chatty.util.Debugging;
import chatty.util.ElapsedTime;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateTime {
    private static final SimpleDateFormat FULL_DATETIME = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss ZZ");
    private static final SimpleDateFormat SDF = new SimpleDateFormat("HH:mm:ss");
    private static final SimpleDateFormat SDF2 = new SimpleDateFormat("HH:mm");
    private static final SimpleDateFormat SDF3 = new SimpleDateFormat("HH:mm:ss/SSS");
    public static final long MINUTE = 60L;
    public static final long HOUR = 3600L;
    public static final long DAY = 86400L;
    public static final long YEAR = 31536000L;
    private static final String[] TIMENAMES_COMPACT = new String[]{"y", "d", "h", "m", "s"};
    private static final String[] TIMENAMES_VERBOSE = new String[]{" years", " days", " hours", " minutes", " seconds"};
    public static final int S = 1;
    public static final int M = 2;
    public static final int H = 3;
    public static final int D = 4;
    public static final int N = 0;
    private static final long[] TIME_DEF = new long[]{31536000L, 86400L, 3600L, 60L, 1L};
    private static final MonthDay APRIL_FIRST = MonthDay.of(Month.APRIL, 1);
    private static final ElapsedTime isAprilFirstET = new ElapsedTime();
    private static boolean isAprilFirst;
    private static final Pattern AM_PM_CUSTOM;
    private static final Pattern DURATION_PARSER;
    private static final TimeUnit[] TIME_UNITS;

    public static void setTimeZone(TimeZone tz) {
        FULL_DATETIME.setTimeZone(tz);
        SDF.setTimeZone(tz);
        SDF2.setTimeZone(tz);
        SDF3.setTimeZone(tz);
    }

    public static int currentHour12Hour() {
        Calendar cal = Calendar.getInstance();
        return cal.get(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String currentTime(SimpleDateFormat sdf) {
        SimpleDateFormat simpleDateFormat = sdf;
        synchronized (simpleDateFormat) {
            Calendar cal = Calendar.getInstance();
            return sdf.format(cal.getTime());
        }
    }

    public static String fullDateTime() {
        return DateTime.currentTime(FULL_DATETIME);
    }

    public static String currentTime() {
        return DateTime.currentTime(SDF);
    }

    public static String currentTimeExact() {
        return DateTime.currentTime(SDF3);
    }

    public static String formatExact(long time) {
        return DateTime.format(time, SDF3);
    }

    public static String currentTime(String format) {
        return DateTime.currentTime(new SimpleDateFormat(format));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(long time, SimpleDateFormat sdf) {
        SimpleDateFormat simpleDateFormat = sdf;
        synchronized (simpleDateFormat) {
            return sdf.format(new Date(time));
        }
    }

    public static String format(long time) {
        return DateTime.format(time, SDF);
    }

    public static String formatFullDatetime(long time) {
        return DateTime.format(time, FULL_DATETIME);
    }

    public static String format2(long time) {
        return DateTime.format(time, SDF2);
    }

    public static String formatAccountAge(long time, Formatting ... options) {
        if (System.currentTimeMillis() - time > 86400000L) {
            return DateTime.ago(time, 0, 2, 3, options);
        }
        return DateTime.ago(time, 0, 1, 0, options);
    }

    public static String formatAccountAgeCompact(long time) {
        return DateTime.formatAccountAgeCompact(time, false);
    }

    public static String formatAccountAgeCompact(long time, boolean moreCompact) {
        Formatting compact;
        Formatting formatting = compact = moreCompact ? Formatting.COMPACT : Formatting.VERBOSE;
        if (System.currentTimeMillis() - time >= 31536000000L) {
            return DateTime.ago(time, 0, 1, 0, Formatting.LAST_ONE_EXACT, compact);
        }
        return DateTime.ago(time, 0, 1, 0, compact);
    }

    public static String formatAccountAgeVerbose(long time) {
        if (System.currentTimeMillis() - time > 86400000L) {
            return DateTime.ago(time, 0, 2, 3, Formatting.VERBOSE);
        }
        return DateTime.ago(time, 0, 1, 0, Formatting.VERBOSE);
    }

    public static String agoText(long time) {
        long seconds = (System.currentTimeMillis() - time) / 1000L;
        if (seconds < 600L) {
            return "just now";
        }
        if (seconds < 3600L) {
            return "recently";
        }
        if (seconds < 86400L) {
            long hours = seconds / 3600L;
            return hours + " " + (hours == 1L ? "hour" : "hours") + " ago";
        }
        if (seconds < 31536000L) {
            long days = seconds / 86400L;
            return days + " " + (days == 1L ? "day" : "days") + " ago";
        }
        long years = seconds / 31536000L;
        return years + " " + (years == 1L ? "year" : "years") + " ago";
    }

    public static String agoClock(long time, boolean showSeconds) {
        long timePassed = System.currentTimeMillis() - time;
        long seconds = timePassed / 1000L;
        return DateTime.durationClock(seconds, showSeconds);
    }

    public static String durationClock(long seconds, boolean showSeconds) {
        long hours = seconds / 3600L;
        long minutes = (seconds %= 3600L) / 60L;
        seconds %= 60L;
        if (showSeconds) {
            return String.format("%02d:%02d:%02d", hours, minutes, seconds);
        }
        return String.format("%02d:%02d", hours, minutes, seconds);
    }

    public static String agoSingleCompact(long time) {
        return DateTime.ago(time, 0, 1, 0, new Formatting[0]);
    }

    public static String agoSingleCompactAboveMinute(long time) {
        if (System.currentTimeMillis() - time > 60000L) {
            return DateTime.ago(time, 0, 1, 0, new Formatting[0]);
        }
        return "now";
    }

    public static String agoSingleVerbose(long time) {
        return DateTime.duration(System.currentTimeMillis() - time, 1, 0, Formatting.VERBOSE);
    }

    public static String agoUptimeCompact(long time) {
        long ago = System.currentTimeMillis() - time;
        if (ago < 3600000L) {
            return DateTime.duration(ago, 0, 0, 1, new Formatting[0]);
        }
        return DateTime.duration(ago, 3, 0, 2, Formatting.LAST_ONE_EXACT);
    }

    public static String agoUptimeCompact2(long time) {
        long seconds = (System.currentTimeMillis() - time) / 1000L;
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        if (hours > 0L) {
            return String.format("%dh %dm", hours, minutes);
        }
        return String.format("%dm", minutes);
    }

    public static String ago(long time, Formatting ... options) {
        return DateTime.duration(System.currentTimeMillis() - time, options);
    }

    public static String ago(long milliseconds, int upperLimit, int max, int lowerLimit, Formatting ... options) {
        return DateTime.duration(System.currentTimeMillis() - milliseconds, upperLimit, max, lowerLimit, options);
    }

    public static String duration(long milliseconds, Formatting ... options) {
        return DateTime.duration(milliseconds, 0, 0, options);
    }

    public static String duration(long milliseconds, int max, int lowerLimit, Formatting ... options) {
        return DateTime.duration(milliseconds, 0, max, lowerLimit, options);
    }

    public static String duration(long milliseconds, int upperLimit, int max, int lowerLimit, Formatting ... options) {
        return DateTime.duration(milliseconds, upperLimit, max, lowerLimit, 1, options);
    }

    public static String duration(long milliseconds, int upperLimit, int max, int lowerLimit, int min, Formatting ... options) {
        return DateTime.duration(milliseconds, upperLimit, max, lowerLimit, min, Arrays.asList(options));
    }

    public static String duration(long milliseconds, int upperLimit, int max, int lowerLimit, int min, List<Formatting> options) {
        boolean leadingZeroValues = options.contains((Object)Formatting.LEADING_ZERO_VALUES);
        boolean noZeroValues = options.contains((Object)Formatting.NO_ZERO_VALUES);
        boolean verbose = options.contains((Object)Formatting.VERBOSE);
        boolean lastOneExact = options.contains((Object)Formatting.LAST_ONE_EXACT);
        boolean doubleDigits = options.contains((Object)Formatting.DOUBLE_DIGITS) || options.contains((Object)Formatting.DOUBLE_DIGITS_EXCEPT_FIRST);
        boolean doubleDigitsExceptFirst = options.contains((Object)Formatting.DOUBLE_DIGITS_EXCEPT_FIRST);
        boolean clockStyle = options.contains((Object)Formatting.CLOCK_STYLE);
        String sep = " ";
        if (options.contains((Object)Formatting.NO_SPACES)) {
            sep = "";
        }
        if (clockStyle) {
            sep = ":";
        }
        boolean negative = false;
        if (milliseconds < 0L) {
            milliseconds = -milliseconds;
            negative = true;
        }
        double[] times = DateTime.getTimes(milliseconds, TIME_DEF, upperLimit);
        String[] timeNames = verbose ? TIMENAMES_VERBOSE : TIMENAMES_COMPACT;
        StringBuilder b = new StringBuilder();
        int shown = 0;
        int shownNonzero = 0;
        for (int i = 0; i < times.length; ++i) {
            int left = times.length - i;
            int time = (int)times[i];
            if (time == 0 && (left > lowerLimit + min || shown >= min) && (noZeroValues || !leadingZeroValues && shownNonzero == 0)) continue;
            if (shown > 0) {
                b.append(sep);
            } else if (negative) {
                b.append("-");
            }
            boolean lastOne = ++shown >= max && max > 0 || left - 1 <= lowerLimit && shown > 0;
            String timeName = timeNames[i + timeNames.length - times.length];
            if (!(time != 1 || !verbose || lastOne && lastOneExact)) {
                timeName = timeName.substring(0, timeName.length() - 1);
            }
            if (lastOne && lastOneExact) {
                double exact = times[i] - 0.05;
                if (doubleDigits && Math.round(exact * 10.0) < 100L && (shown > 1 || !doubleDigitsExceptFirst)) {
                    b.append("0");
                }
                b.append(String.format(Locale.ENGLISH, "%.1f", exact));
            } else {
                if (doubleDigits && time < 10 && (shown > 1 || !doubleDigitsExceptFirst)) {
                    b.append("0");
                }
                b.append(time);
            }
            if (!clockStyle) {
                b.append(timeName);
            }
            if (time > 0) {
                ++shownNonzero;
            }
            if (lastOne) break;
        }
        return b.toString();
    }

    public static double[] getTimes(long input, long[] timeDef, int upperLimit) {
        double seconds = input / 1000L;
        if (upperLimit <= 0 || upperLimit > timeDef.length) {
            upperLimit = timeDef.length;
        }
        double[] result = new double[upperLimit];
        int offset = timeDef.length - upperLimit;
        for (int i = 0; i < result.length; ++i) {
            long def = timeDef[i + offset];
            result[i] = seconds / (double)def;
            seconds %= (double)def;
        }
        return result;
    }

    public static boolean isAprilFirst() {
        if (Debugging.isEnabled("f2")) {
            return true;
        }
        if (isAprilFirstET.secondsElapsed(600)) {
            isAprilFirstET.set();
            isAprilFirst = MonthDay.now().equals(APRIL_FIRST);
        }
        return isAprilFirst;
    }

    public static long parseDatetime(String time) {
        OffsetDateTime odt = OffsetDateTime.parse(time);
        return odt.toInstant().toEpochMilli();
    }

    public static SimpleDateFormat createSdfAmPm(String format) {
        Matcher m = AM_PM_CUSTOM.matcher(format);
        if (m.find()) {
            String[] amPm = new String[]{m.group(1), m.group(2)};
            format = m.replaceAll("");
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            DateFormatSymbols symbols = sdf.getDateFormatSymbols();
            symbols.setAmPmStrings(amPm);
            sdf.setDateFormatSymbols(symbols);
            return sdf;
        }
        return new SimpleDateFormat(format);
    }

    public static String formatMonthsVerbose(int months) {
        if (months < 12) {
            return months + " months";
        }
        return months + " months, " + DateTime.formatMonths(months);
    }

    public static String formatMonths(int months) {
        if (months < 12) {
            return months + " months";
        }
        int y = months / 12;
        int m = months % 12;
        if (m == 0) {
            return String.format("%d %s", y, y == 1 ? "year" : "years");
        }
        return String.format("%d %s %d %s", y, y == 1 ? "year" : "years", m, m == 1 ? "month" : "months");
    }

    public static long parseDurationSeconds(String text) {
        return DateTime.parseDurationSeconds(text, TimeUnit.SECONDS);
    }

    public static long parseDurationSeconds(String text, TimeUnit defaultUnit) {
        if (text == null) {
            return -1L;
        }
        return DateTime.parseDuration(text, defaultUnit) / 1000L;
    }

    public static long parseDuration(String text) {
        return DateTime.parseDuration(text, TimeUnit.SECONDS);
    }

    public static long parseDuration(String text, TimeUnit defaultUnit) {
        if (text == null) {
            return -1L;
        }
        Matcher m = DURATION_PARSER.matcher(text);
        long ms = 0L;
        TimeUnit unit = defaultUnit;
        while (m.find()) {
            long num = Long.parseLong(m.group("num"));
            String unitText = m.group("unit");
            if (unitText != null) {
                unit = DateTime.getTimeUnitFromString(unitText);
            }
            ms += unit.toMillis(num);
            unit = DateTime.nextTimeUnit(unit);
        }
        return ms;
    }

    private static TimeUnit nextTimeUnit(TimeUnit unit) {
        for (int i = 0; i < TIME_UNITS.length - 1; ++i) {
            if (TIME_UNITS[i] != unit) continue;
            return TIME_UNITS[i + 1];
        }
        return unit;
    }

    private static TimeUnit getTimeUnitFromString(String unit) {
        if (unit != null) {
            switch (unit) {
                case "ms": {
                    return TimeUnit.MILLISECONDS;
                }
                case "m": {
                    return TimeUnit.MINUTES;
                }
                case "h": {
                    return TimeUnit.HOURS;
                }
                case "d": {
                    return TimeUnit.DAYS;
                }
            }
        }
        return TimeUnit.SECONDS;
    }

    public static final void main(String[] args) {
        int a = 16;
        int b = 32;
        int c = 2;
        int v = a | b;
        System.out.println(DateTime.formatAccountAgeCompact(System.currentTimeMillis() - 31536000000L, true));
        System.out.println(DateTime.duration(670200000L, 0, 0, 0, 0, Formatting.NO_ZERO_VALUES));
    }

    static {
        AM_PM_CUSTOM = Pattern.compile("'a:(.*?)\\/(.*?)'");
        DURATION_PARSER = Pattern.compile("(?<num>[0-9]+)(?<unit>ms|s|m|h|d)?");
        TIME_UNITS = new TimeUnit[]{TimeUnit.DAYS, TimeUnit.HOURS, TimeUnit.MINUTES, TimeUnit.SECONDS, TimeUnit.MILLISECONDS};
    }

    public static enum Formatting {
        COMPACT,
        VERBOSE,
        LEADING_ZERO_VALUES,
        NO_ZERO_VALUES,
        NO_SPACES,
        LAST_ONE_EXACT,
        DOUBLE_DIGITS,
        DOUBLE_DIGITS_EXCEPT_FIRST,
        CLOCK_STYLE;

    }
}

