/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import chatty.Chatty;
import chatty.util.StringUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class Debugging {
    private static final Logger LOGGER = Logger.getLogger(Debugging.class.getName());
    private static final long TIMED_OUTPUT_DELAY = 5000L;
    private static final Set<String> enabled = new HashSet<String>();
    private static final Map<String, Long> stopwatchData = new HashMap<String, Long>();
    private static final Set<OutputListener> outputListeners = new HashSet<OutputListener>();
    private static final Map<String, String> timedOutput = new HashMap<String, String>();
    private static final Map<String, Long> timedOutputTimes = new HashMap<String, Long>();
    private static final Timer timer;
    private static final Map<String, Long> counter;
    private static final Set<String> STACKTRACE_FILTER;

    public static synchronized String command(String parameter) {
        if (parameter == null) {
            return "Invalid parameter";
        }
        for (String id : parameter.split(" ")) {
            if (id.startsWith("+")) {
                enabled.add(id.substring(1));
                continue;
            }
            if (id.startsWith("-")) {
                enabled.remove(id.substring(1));
                continue;
            }
            if (enabled.contains(id)) {
                enabled.remove(id);
                continue;
            }
            enabled.add(id);
        }
        return "Now: " + enabled;
    }

    public static synchronized boolean isEnabled(String ... ids) {
        if (enabled.isEmpty()) {
            return false;
        }
        for (String id : ids) {
            if (!enabled.contains(id)) continue;
            return true;
        }
        return false;
    }

    public static synchronized void registerForOutput(OutputListener listener) {
        if (listener != null) {
            outputListeners.add(listener);
        }
    }

    public static synchronized void println(String line) {
        for (OutputListener o : outputListeners) {
            o.debug(line);
        }
        Chatty.println(line);
    }

    public static synchronized void printlnf(String line, Object ... args) {
        Debugging.println(String.format(line, args));
    }

    public static synchronized void printlnTimed(String type, String line) {
        if (Debugging.isEnabled("rt")) {
            Debugging.println(line);
        }
        timedOutput.put(type, line);
        timedOutputTimes.put(type, System.currentTimeMillis());
    }

    public static synchronized void println(String type, String line, Object ... args) {
        if (Debugging.isEnabled(type)) {
            if (args.length > 0) {
                Debugging.println(String.format(line, args));
            } else {
                Debugging.println(line);
            }
        }
    }

    public static void edt() {
        if (!SwingUtilities.isEventDispatchThread()) {
            Object[] st = Thread.currentThread().getStackTrace();
            Debugging.println("!EDT " + StringUtil.join(st));
        }
    }

    public static void edtLoud() {
        if (!SwingUtilities.isEventDispatchThread()) {
            Object[] st = Thread.currentThread().getStackTrace();
            LOGGER.warning("!EDT " + StringUtil.join(st));
        }
    }

    public static synchronized long millisecondsElapsed(String id) {
        Long previous = stopwatchData.get(id);
        stopwatchData.put(id, System.currentTimeMillis());
        if (previous == null) {
            return -1L;
        }
        return System.currentTimeMillis() - previous;
    }

    public static synchronized boolean millisecondsElapsed(String id, long milliseconds) {
        long elapsed = Debugging.millisecondsElapsed(id);
        return elapsed == -1L || elapsed >= milliseconds;
    }

    public static synchronized boolean millisecondsElapsedLenient(String id, long milliseconds) {
        Long previous = stopwatchData.get(id);
        if (previous == null || System.currentTimeMillis() - previous >= milliseconds) {
            stopwatchData.put(id, System.currentTimeMillis());
            return true;
        }
        return false;
    }

    public static synchronized long count(String key) {
        long value = 0L;
        if (counter.containsKey(key)) {
            value = counter.get(key) + 1L;
        }
        counter.put(key, value);
        return value;
    }

    public static String filterToken(String input) {
        return input.replaceAll("(-set:token|-token|-password) \\w+", "$1 <token>");
    }

    public static void writeToFile(String output) {
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get("E:\\abcdtest", new String[0]), Charset.forName("UTF-8"), new OpenOption[0]);){
            writer.append(output);
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }

    public static String getStacktrace(Exception ex) {
        try {
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            return sw.toString();
        }
        catch (Exception ex2) {
            LOGGER.warning("Error occured trying to get stacktrace: " + ex2);
            return null;
        }
    }

    public static String getStacktraceFiltered(Exception ex) {
        try {
            return ex + "\n\t" + StringUtil.join(Debugging.filterStacktrace(ex.getStackTrace()), "\n\t ");
        }
        catch (Exception ex2) {
            LOGGER.warning("Error occured trying to get stacktrace: " + ex2);
            return null;
        }
    }

    public static String getStacktraceFilteredFlat(Exception ex) {
        try {
            return ex + " [" + StringUtil.join(Debugging.filterStacktrace(ex.getStackTrace()), ",") + "]";
        }
        catch (Exception ex2) {
            LOGGER.warning("Error occured trying to get stacktrace: " + ex2);
            return null;
        }
    }

    public static List<String> filterStacktrace(StackTraceElement[] st) {
        ArrayList<String> result = new ArrayList<String>();
        String filtered = null;
        for (int i = 0; i < st.length; ++i) {
            StackTraceElement el = st[i];
            boolean show = true;
            for (String filter : STACKTRACE_FILTER) {
                if (!el.getClassName().startsWith(filter)) continue;
                if (!filter.equals(filtered)) {
                    result.add("[" + filter + "]");
                    filtered = filter;
                }
                show = false;
            }
            if (!show) continue;
            result.add(el.toString());
        }
        return result;
    }

    public static String getStacktrace() {
        Object[] st = Thread.currentThread().getStackTrace();
        return StringUtil.join(st);
    }

    public static String getCurrenThreadInfo() {
        return Debugging.getThreadInfo(Thread.currentThread());
    }

    public static String getThreadInfo(Thread thread) {
        StringBuilder b = new StringBuilder();
        b.append("[").append(thread.getName()).append("/").append((Object)thread.getState()).append("]");
        b.append(StringUtil.join(thread.getStackTrace()));
        return b.toString();
    }

    public static void main(String[] args) {
        System.out.println(Debugging.filterToken("-d \"G:\\chatty settings\" -set:token abc -token abc -password -password abc -connect"));
    }

    static {
        counter = new HashMap<String, Long>();
        timer = new Timer("Debugging", true);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (!Debugging.isEnabled("rt")) {
                    for (Map.Entry entry : timedOutput.entrySet()) {
                        String type = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        long lastValueAgo = System.currentTimeMillis() - (Long)timedOutputTimes.get(type);
                        if (lastValueAgo >= 5000L) continue;
                        Debugging.println(String.format("[%s] %s", type, value));
                    }
                }
            }
        }, 5000L, 5000L);
        STACKTRACE_FILTER = new HashSet<String>();
        STACKTRACE_FILTER.add("java.awt.EventDispatchThread");
        STACKTRACE_FILTER.add("java.awt.EventQueue");
        STACKTRACE_FILTER.add("java.awt.DefaultKeyboardFocusManager");
    }

    public static interface OutputListener {
        public void debug(String var1);
    }
}

