/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;

public class DelayedActionQueue<E> {
    private static final Logger LOGGER = Logger.getLogger(DelayedActionQueue.class.getName());
    private final DelayedActionListener<E> listener;
    private final long delay;
    private final BlockingQueue<E> q = new LinkedBlockingQueue();

    public static <T> DelayedActionQueue<T> create(DelayedActionListener<T> listener, long delay) {
        DelayedActionQueue<T> q = new DelayedActionQueue<T>(listener, delay);
        super.start();
        return q;
    }

    private DelayedActionQueue(DelayedActionListener<E> listener, long delay) {
        this.listener = listener;
        this.delay = delay;
    }

    private void start() {
        new Reader().start();
    }

    public void add(E item) {
        this.q.add(item);
    }

    public void clear() {
        this.q.clear();
    }

    public static interface DelayedActionListener<E> {
        public void actionPerformed(E var1);
    }

    private class Reader
    extends Thread {
        private Reader() {
            super("DelayedActionQueue");
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Object item = DelayedActionQueue.this.q.take();
                    DelayedActionQueue.this.listener.actionPerformed(item);
                    Reader.sleep(DelayedActionQueue.this.delay);
                }
            }
            catch (InterruptedException ex) {
                LOGGER.warning("Reader Thread interrupted.");
                return;
            }
        }
    }
}

