/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import java.util.concurrent.TimeUnit;

public class ElapsedTime {
    private final Object LOCK = new Object();
    private long time = -1L;

    public ElapsedTime(boolean initNow) {
        if (initNow) {
            this.time = ElapsedTime.ems();
        }
    }

    public ElapsedTime() {
        this(false);
    }

    public void set() {
        this.time = ElapsedTime.ems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSync() {
        Object object = this.LOCK;
        synchronized (object) {
            this.set();
        }
    }

    public void reset() {
        this.time = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetSync() {
        Object object = this.LOCK;
        synchronized (object) {
            this.reset();
        }
    }

    public boolean isSet() {
        return this.time != -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSetSync() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.isSet();
        }
    }

    public long millisElapsed() {
        if (this.time == -1L) {
            return Long.MAX_VALUE;
        }
        return ElapsedTime.ems() - this.time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long millisElapsedSync() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.millisElapsed();
        }
    }

    public long secondsElapsed() {
        if (this.time == -1L) {
            return Long.MAX_VALUE;
        }
        return TimeUnit.MILLISECONDS.toSeconds(ElapsedTime.ems() - this.time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long secondsElapsedSync() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.secondsElapsed();
        }
    }

    public boolean millisElapsed(long milliseconds) {
        if (this.time == -1L) {
            return true;
        }
        return this.millisElapsed() >= milliseconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean millisElapsedSync(long milliseconds) {
        Object object = this.LOCK;
        synchronized (object) {
            return this.millisElapsed(milliseconds);
        }
    }

    public boolean secondsElapsed(int seconds) {
        return this.millisElapsed(TimeUnit.SECONDS.toMillis(seconds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean secondsElapsedSync(int seconds) {
        Object object = this.LOCK;
        synchronized (object) {
            return this.secondsElapsed(seconds);
        }
    }

    public boolean isSetAndSecondsElapsed(int seconds) {
        return this.isSet() && this.secondsElapsed(seconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSetAndSecondsElapsedSync(int seconds) {
        Object object = this.LOCK;
        synchronized (object) {
            return this.isSet() && this.secondsElapsed(seconds);
        }
    }

    public static long ems() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
    }
}

