/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.logging.Logger;

public class FileWatcher
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(FileWatcher.class.getName());
    private final WatchService watcher;
    private final Path file;
    private final Path directory;
    private final FileChangedListener listener;

    public static boolean createFileWatcher(Path file, FileChangedListener listener) {
        if (listener == null || file == null) {
            return false;
        }
        try {
            FileWatcher watcher = new FileWatcher(file, listener);
            Thread thread = new Thread(watcher);
            thread.start();
            LOGGER.info("Added file watcher for: " + file.toAbsolutePath());
            return true;
        }
        catch (IOException ex) {
            LOGGER.warning("Error adding file watcher for: " + file.toAbsolutePath() + " [" + ex + "]");
            return false;
        }
    }

    private FileWatcher(Path file, FileChangedListener listener) throws IOException {
        this.directory = file.getParent();
        this.listener = listener;
        this.file = file;
        this.watcher = FileSystems.getDefault().newWatchService();
        this.directory.register(this.watcher, StandardWatchEventKinds.ENTRY_MODIFY);
    }

    @Override
    public void run() {
        WatchKey key;
        boolean valid;
        do {
            try {
                key = this.watcher.take();
            }
            catch (InterruptedException ex) {
                return;
            }
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException ex) {
                return;
            }
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent<?> ev;
                Path fileName;
                Path changedFile;
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW || !(changedFile = this.directory.resolve(fileName = (Path)(ev = event).context())).equals(this.file)) continue;
                this.listener.fileChanged();
            }
        } while (valid = key.reset());
    }

    public static final void main(String[] args) {
        final Path file = Paths.get("test/test.txt", new String[0]);
        FileWatcher.createFileWatcher(file, new FileChangedListener(){

            @Override
            public void fileChanged() {
                System.out.println(file + " changed");
            }
        });
    }

    public static interface FileChangedListener {
        public void fileChanged();
    }
}

