/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import chatty.util.DateTime;
import chatty.util.UrlRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class GitHub {
    private static final Logger LOGGER = Logger.getLogger(GitHub.class.getName());
    private static final String URL = "https://api.github.com/repos/chatty/chatty/releases";

    public static Releases getReleases() {
        UrlRequest request = new UrlRequest(URL);
        UrlRequest.FullResult result = request.sync();
        if (result.responseCode == 200) {
            try {
                List<Release> parsed = GitHub.parseReleases(result.getResult());
                return new Releases(parsed);
            }
            catch (Exception ex) {
                LOGGER.warning("Error parsing releases: " + ex);
            }
        }
        return null;
    }

    private static final List<Release> parseReleases(String data) throws Exception {
        JSONArray array = (JSONArray)new JSONParser().parse(data);
        ArrayList<Release> result = new ArrayList<Release>();
        for (Object obj : array) {
            result.add(GitHub.parseRelease((JSONObject)obj));
        }
        return result;
    }

    private static final Release parseRelease(JSONObject data) {
        String tag = (String)data.get("tag_name");
        String name = (String)data.get("name");
        String description = (String)data.get("body");
        boolean isBeta = (Boolean)data.get("prerelease");
        long published = DateTime.parseDatetime((String)data.get("published_at"));
        ArrayList<Asset> assets = new ArrayList<Asset>();
        JSONArray assetData = (JSONArray)data.get("assets");
        for (Object obj : assetData) {
            JSONObject asset = (JSONObject)obj;
            String download_url = (String)asset.get("browser_download_url");
            String asset_name = (String)asset.get("name");
            assets.add(new Asset(asset_name, download_url));
        }
        return new Release(tag, name, description, isBeta, assets, published);
    }

    public static void main(String[] args) {
        Releases result = GitHub.getReleases();
        System.out.println(result);
        for (Release r : result.releases) {
            System.out.println(r);
        }
    }

    public static class Releases {
        private final List<Release> releases;
        private final Release latest;
        private final Release latestBeta;

        public Releases(List<Release> releases) {
            this.releases = releases;
            Release latestTemp = null;
            Release latestBetaTemp = null;
            for (Release r : releases) {
                if (latestTemp == null && !r.isBeta()) {
                    latestTemp = r;
                }
                if (latestBetaTemp != null || latestTemp != null || !r.isBeta()) continue;
                latestBetaTemp = r;
            }
            this.latest = latestTemp;
            this.latestBeta = latestBetaTemp;
        }

        public Release getLatest() {
            return this.latest;
        }

        public Release getLatestBeta() {
            return this.latestBeta;
        }

        public List<Release> getReleases() {
            return this.releases;
        }

        public Release getByVersion(String version) {
            for (Release r : this.releases) {
                if (!r.getVersion().equals(version)) continue;
                return r;
            }
            return null;
        }

        public String toString() {
            return String.format(Locale.ROOT, "total: %d latest: %s latestBeta: %s", this.releases.size(), this.getLatest(), this.getLatestBeta());
        }
    }

    public static class Release {
        private static final long DAY = 86400000L;
        private final String name;
        private final String description;
        private final String tag;
        private final boolean isBeta;
        private final List<Asset> assets;
        private final String version;
        private final long publishedAt;

        public Release(String tag, String name, String description, boolean beta, List<Asset> assets, long publishedAt) {
            this.tag = tag;
            this.isBeta = beta;
            this.assets = assets;
            this.name = name;
            this.description = description;
            this.version = tag.startsWith("v") ? tag.substring(1) : tag;
            this.publishedAt = publishedAt;
        }

        public boolean isBeta() {
            return this.isBeta;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getTag() {
            return this.tag;
        }

        public String getVersion() {
            return this.version;
        }

        public long getPublishedAt() {
            return this.publishedAt;
        }

        public String getPublishedAgo() {
            return DateTime.agoText(this.publishedAt);
        }

        public int monthsOld() {
            return (int)((System.currentTimeMillis() - this.publishedAt) / 2592000000L);
        }

        public int daysOld() {
            return (int)((System.currentTimeMillis() - this.publishedAt) / 86400000L);
        }

        public boolean isOld() {
            return System.currentTimeMillis() - this.publishedAt > 8640000000L;
        }

        public List<Asset> getAssets() {
            return this.assets;
        }

        public Asset getAsset(String nameSuffix) {
            for (Asset a : this.assets) {
                if (!a.getName().endsWith(nameSuffix)) continue;
                return a;
            }
            return null;
        }

        public String toString() {
            return String.format("[%s] %s %s %s", this.tag, this.name, this.isBeta, this.assets);
        }
    }

    public static class Asset {
        private final String name;
        private final String download_url;

        public Asset(String name, String download_url) {
            this.name = name;
            this.download_url = download_url;
        }

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.download_url;
        }

        public String toString() {
            return this.name + "/" + this.download_url;
        }
    }
}

