/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;

public class HalfWeakSet<T>
implements Set<T> {
    private final Set<T> strong = new HashSet<T>();
    private final Set<T> weak = Collections.newSetFromMap(new WeakHashMap());

    @Override
    public int size() {
        return this.strong.size() + this.weak.size();
    }

    @Override
    public boolean isEmpty() {
        return this.strong.isEmpty() && this.weak.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.strong.contains(o) || this.weak.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return new MyIterator();
    }

    public Iterator<T> strongIterator() {
        return this.strong.iterator();
    }

    @Override
    public Object[] toArray() {
        return null;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return null;
    }

    @Override
    public boolean add(T e) {
        if (!this.weak.contains(e)) {
            return this.strong.add(e);
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        return this.strong.remove(o) || this.weak.remove(o);
    }

    public void markWeak(T o) {
        if (this.strong.remove(o)) {
            this.weak.add(o);
        }
    }

    public void markStrong(T o) {
        if (this.weak.remove(o)) {
            this.strong.add(o);
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return false;
    }

    @Override
    public void clear() {
        this.strong.clear();
        this.weak.clear();
    }

    public String toString() {
        return String.format("Strong%s Weak%s", this.strong, this.weak);
    }

    public static void main(String[] args) throws InterruptedException {
        Object a = new Object();
        Object b = new Object();
        Object c = new Object();
        HalfWeakSet<Object> test = new HalfWeakSet<Object>();
        test.add(a);
        test.add(b);
        test.add(c);
        test.markWeak(a);
        a = null;
        b = null;
        c = null;
        for (Object t : test) {
            System.out.println(t);
        }
        Thread.sleep(15000L);
        for (Object t : test) {
            System.out.println(t);
        }
    }

    private class MyIterator
    implements Iterator<T> {
        private final Iterator<T> strongIt;
        private final Iterator<T> weakIt;

        private MyIterator() {
            this.strongIt = HalfWeakSet.this.strong.iterator();
            this.weakIt = HalfWeakSet.this.weak.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.strongIt.hasNext() || this.weakIt.hasNext();
        }

        @Override
        public T next() {
            if (this.strongIt.hasNext()) {
                return this.strongIt.next();
            }
            return this.weakIt.next();
        }
    }
}

