/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HalfWeakSet2<T>
implements Iterable<T> {
    private List<T> strong;
    private List<WeakReference<T>> weak;

    public void add(T value) {
        if (this.contains(this.weak, value)) {
            this.remove(this.weak, value);
            this.ensureStrongExists();
            this.strong.add(value);
        } else if (!this.contains(this.strong, value)) {
            this.ensureStrongExists();
            this.strong.add(value);
        }
    }

    private void ensureStrongExists() {
        if (this.strong == null) {
            this.strong = new ArrayList<T>(1);
        }
    }

    private void ensureWeakExists() {
        if (this.weak == null) {
            this.weak = new ArrayList<WeakReference<T>>(1);
        }
    }

    public void markStrong(T value) {
        if (this.remove(this.weak, value)) {
            this.ensureStrongExists();
            this.strong.add(value);
        }
    }

    public void markWeak(T value) {
        if (this.remove(this.strong, value)) {
            this.ensureWeakExists();
            this.weak.add(new WeakReference<T>(value));
        }
    }

    public void cleanUp() {
        if (this.weak != null) {
            Iterator<WeakReference<T>> it = this.weak.iterator();
            while (it.hasNext()) {
                if (it.next().get() != null) continue;
                it.remove();
            }
            if (this.weak.isEmpty()) {
                this.weak = null;
            }
        }
        if (this.strong != null && this.strong.isEmpty()) {
            this.strong = null;
        }
    }

    private boolean contains(List list, Object search) {
        if (list == null) {
            return false;
        }
        for (Object value : list) {
            if ((list != this.weak || ((WeakReference)value).get() != search) && value != search) continue;
            return true;
        }
        return false;
    }

    private boolean remove(List list, Object search) {
        if (list == null) {
            return false;
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if ((list != this.weak || ((WeakReference)o).get() != search) && (list != this.strong || o != search)) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public void clear() {
        this.strong = null;
        this.weak = null;
    }

    @Override
    public Iterator<T> iterator() {
        this.cleanUp();
        return new CombinedIterator();
    }

    public Iterator<T> strongIterator() {
        if (this.strong == null) {
            return new EmptyIterator();
        }
        return this.strong.iterator();
    }

    public static void main(String[] args) throws InterruptedException {
        String a = new String("a");
        String b = new String("b");
        String c = new String("c");
        HalfWeakSet2<String> test = new HalfWeakSet2<String>();
        test.add(b);
        test.markWeak(a);
        test.markStrong(a);
        test.markStrong(a);
        test.markWeak(b);
        for (Object t : test) {
            System.out.println(t);
        }
        a = null;
        b = null;
        c = null;
        for (Object t : test) {
            System.out.println(t);
        }
        System.gc();
        System.out.println("--");
        for (Object t : test) {
            System.out.println(t);
        }
    }

    private class CombinedIterator
    implements Iterator<T> {
        private final Iterator<T> strongIt;
        private final Iterator<WeakReference<T>> weakIt;

        private CombinedIterator() {
            this.strongIt = HalfWeakSet2.this.strong != null ? HalfWeakSet2.this.strong.iterator() : null;
            this.weakIt = HalfWeakSet2.this.weak != null ? HalfWeakSet2.this.weak.iterator() : null;
        }

        @Override
        public boolean hasNext() {
            return this.strongIt != null && this.strongIt.hasNext() || this.weakIt != null && this.weakIt.hasNext();
        }

        @Override
        public T next() {
            if (this.strongIt != null && this.strongIt.hasNext()) {
                return this.strongIt.next();
            }
            return this.weakIt.next().get();
        }
    }

    private class EmptyIterator
    implements Iterator<T> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            return null;
        }
    }
}

