/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import chatty.Chatty;
import chatty.gui.MainGui;
import java.awt.Image;
import java.awt.Toolkit;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.ImageIcon;

public class IconManager {
    private static final Logger LOGGER = Logger.getLogger(IconManager.class.getName());
    private static List<CustomIcon> customIcons;

    public static void setCustomIcons(List<String> icons) {
        ArrayList<CustomIcon> result = new ArrayList<CustomIcon>();
        for (String path : icons) {
            CustomIcon.Type type = CustomIcon.Type.ALL;
            for (CustomIcon.Type t : CustomIcon.Type.values()) {
                String prefix = "[" + t.id + "]";
                if (!path.startsWith(prefix)) continue;
                path = path.substring(prefix.length());
                type = t;
            }
            Path absolutePath = Chatty.toAbsolutePathWdir(Paths.get(path, new String[0]));
            if (absolutePath.toFile().isFile()) {
                try {
                    ImageIcon image = new ImageIcon(absolutePath.toString());
                    result.add(new CustomIcon(type, image));
                }
                catch (Exception ex) {
                    LOGGER.warning(String.format("Error creating custom icon: %s [%s]", path, ex));
                }
                continue;
            }
            LOGGER.warning(String.format("Error creating custom icon: %s [not a file]", path));
        }
        if (!result.isEmpty()) {
            customIcons = result;
            StringBuilder b = new StringBuilder();
            for (CustomIcon ci : result) {
                if (b.length() > 0) {
                    b.append("/");
                }
                b.append("[").append((Object)ci.type).append("]");
                b.append(ci.icon.getIconWidth()).append("x").append(ci.icon.getIconHeight());
            }
            LOGGER.info(String.format("Created %s custom icons (%s)", result.size(), b.toString()));
        }
    }

    public static ImageIcon getNotificationIcon() {
        return new ImageIcon(IconManager.getSingleIcon(CustomIcon.Type.NOTIFICATION, 16));
    }

    public static Image getTrayIcon(int size) {
        return IconManager.getSingleIcon(CustomIcon.Type.TRAY, size);
    }

    public static Image getSingleIcon(CustomIcon.Type type, int size) {
        if (customIcons != null) {
            ImageIcon bestFit = IconManager.getBestFit(customIcons, type, size, size);
            if (bestFit == null) {
                bestFit = IconManager.getBestFit(customIcons, CustomIcon.Type.ALL, size, size);
            }
            if (bestFit != null) {
                if (bestFit.getIconWidth() != size || bestFit.getIconHeight() != size) {
                    return bestFit.getImage().getScaledInstance(size, size, 4);
                }
                return bestFit.getImage();
            }
        }
        if (size <= 16) {
            return IconManager.createScaledDefaultImage("app_main_16.png", size);
        }
        return IconManager.createScaledDefaultImage("app_main_64.png", size);
    }

    public static ImageIcon getBestFit(Collection<CustomIcon> imgs, CustomIcon.Type type, int width, int height) {
        ImageIcon bestFit = null;
        for (CustomIcon ci : imgs) {
            if (ci.type != type) continue;
            ImageIcon icon = ci.icon;
            if (bestFit == null || icon.getIconWidth() == width && icon.getIconHeight() == height) {
                bestFit = icon;
                continue;
            }
            int wDist = icon.getIconWidth() - width;
            int hDist = icon.getIconHeight() - height;
            int wDistB = bestFit.getIconWidth() - width;
            int hDistB = bestFit.getIconHeight() - height;
            if (wDist > 0 && hDist > 0 && (wDistB < 0 || hDistB < 0)) {
                bestFit = icon;
                continue;
            }
            if (wDistB >= 0 && hDistB >= 0 || Math.abs(wDist) + Math.abs(hDist) >= Math.abs(wDistB) + Math.abs(hDistB)) continue;
            bestFit = icon;
        }
        return bestFit;
    }

    private static Image createScaledDefaultImage(String name, int size) {
        ImageIcon icon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(MainGui.class.getResource(name)));
        if (icon.getIconWidth() != size) {
            return icon.getImage().getScaledInstance(size, size, 4);
        }
        return icon.getImage();
    }

    public static List<Image> getMainIcons() {
        List<Image> result = IconManager.getCustomIcons(CustomIcon.Type.MAIN);
        if (!result.isEmpty()) {
            return result;
        }
        ArrayList<Image> windowIcons = new ArrayList<Image>();
        windowIcons.add(IconManager.createDefaultImage("app_main_16.png"));
        windowIcons.add(IconManager.createDefaultImage("app_main_64.png"));
        windowIcons.add(IconManager.createDefaultImage("app_main_128.png"));
        return windowIcons;
    }

    public static List<Image> getLiveIcons() {
        List<Image> result = IconManager.getCustomIcons(CustomIcon.Type.LIVE);
        if (!result.isEmpty()) {
            return result;
        }
        ArrayList<Image> windowIcons = new ArrayList<Image>();
        windowIcons.add(IconManager.createDefaultImage("app_live_16.png"));
        windowIcons.add(IconManager.createDefaultImage("app_live_64.png"));
        windowIcons.add(IconManager.createDefaultImage("app_live_128.png"));
        return windowIcons;
    }

    public static List<Image> getHelpIcons() {
        List<Image> result = IconManager.getCustomIcons(CustomIcon.Type.HELP);
        if (!result.isEmpty()) {
            return result;
        }
        ArrayList<Image> windowIcons = new ArrayList<Image>();
        windowIcons.add(IconManager.createDefaultImage("app_help_16.png"));
        windowIcons.add(IconManager.createDefaultImage("app_help_64.png"));
        windowIcons.add(IconManager.createDefaultImage("app_help_128.png"));
        return windowIcons;
    }

    public static List<Image> getDebugIcons() {
        List<Image> result = IconManager.getCustomIcons(CustomIcon.Type.DEBUG);
        if (!result.isEmpty()) {
            return result;
        }
        ArrayList<Image> windowIcons = new ArrayList<Image>();
        windowIcons.add(IconManager.createDefaultImage("app_debug_16.png"));
        windowIcons.add(IconManager.createDefaultImage("app_debug_64.png"));
        windowIcons.add(IconManager.createDefaultImage("app_debug_128.png"));
        return windowIcons;
    }

    public static List<Image> getPopoutIcons() {
        List<Image> result = IconManager.getCustomIcons(CustomIcon.Type.POPOUT);
        if (!result.isEmpty()) {
            return result;
        }
        ArrayList<Image> windowIcons = new ArrayList<Image>();
        windowIcons.add(IconManager.createDefaultImage("app_popout_16.png"));
        windowIcons.add(IconManager.createDefaultImage("app_popout_64.png"));
        windowIcons.add(IconManager.createDefaultImage("app_popout_128.png"));
        return windowIcons;
    }

    private static List<Image> getCustomIcons(CustomIcon.Type type) {
        List<Image> result = IconManager.getCustomIcons2(type);
        if (result.isEmpty()) {
            result = IconManager.getCustomIcons2(CustomIcon.Type.ALL);
        }
        return result;
    }

    private static List<Image> getCustomIcons2(CustomIcon.Type type) {
        ArrayList<Image> result = new ArrayList<Image>();
        if (customIcons == null) {
            return result;
        }
        for (CustomIcon ci : customIcons) {
            if (ci.type != type) continue;
            result.add(ci.icon.getImage());
        }
        return result;
    }

    private static Image createDefaultImage(String name) {
        return Toolkit.getDefaultToolkit().createImage(MainGui.class.getResource(name));
    }

    public static class CustomIcon {
        public final Type type;
        public final ImageIcon icon;

        public CustomIcon(Type type, ImageIcon icon) {
            this.icon = icon;
            this.type = type;
        }

        public static enum Type {
            ALL("all"),
            MAIN("main"),
            TRAY("tray"),
            NOTIFICATION("notif"),
            LIVE("live"),
            HELP("help"),
            DEBUG("debug"),
            POPOUT("popout");

            public final String id;

            private Type(String id) {
                this.id = id;
            }
        }
    }
}

