/*
 * Decompiled with CFR 0.152.
 */
package chatty.util;

import chatty.util.Debugging;
import chatty.util.MathUtil;
import chatty.util.MiscUtil;
import chatty.util.gif.GifUtil;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;

public class ImageCache {
    private static final Logger LOGGER = Logger.getLogger(ImageCache.class.getName());
    private static final String GLOBAL_PREFIX = "imgcache-";
    private static final int DELETE_FILES_OLDER_THAN = 2592000;
    private static final int EXPIRED_FILES_CHECK_CAP = 100;
    private static volatile Path defaultPath = Paths.get("", new String[0]);
    private static volatile boolean cachingEnabled = true;
    private static final Map<String, Object> lockObjects = new HashMap<String, Object>();

    public static void setDefaultPath(Path path) {
        defaultPath = path;
    }

    public static void setCachingEnabled(boolean enabled) {
        cachingEnabled = enabled;
    }

    public static void main(String[] args) {
        try {
            ImageCache.setDefaultPath(Paths.get("cache", new String[0]));
            URL uRL = new URL("http://127.0.0.1");
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(ImageCache.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static int clearCache(String prefix) {
        return ImageCache.clearCache(defaultPath, prefix);
    }

    private static int clearCache(Path path, String prefix) {
        try {
            File dir = path.toRealPath(new LinkOption[0]).toFile();
            String fullPrefix = prefix == null ? GLOBAL_PREFIX : GLOBAL_PREFIX + prefix + "__";
            int deletedFilesCount = MiscUtil.deleteInDir(dir, fullPrefix, false);
            LOGGER.info(String.format(Locale.ROOT, "ImageCache: Deleted %d files in %s", deletedFilesCount, dir));
            return deletedFilesCount;
        }
        catch (IOException ex) {
            LOGGER.warning("ImageCache: Failed to resolve path [" + ex + "]");
            return -1;
        }
    }

    private static void removeOldCache() {
        try {
            int deletedCount = 0;
            File dir = defaultPath.toRealPath(new LinkOption[0]).toFile();
            File[] files = dir.listFiles(file -> file.isFile() && file.getName().startsWith(GLOBAL_PREFIX));
            if (files != null) {
                for (File file2 : files) {
                    if (!file2.delete()) continue;
                    ++deletedCount;
                }
            }
            if (deletedCount > 0) {
                LOGGER.info(String.format(Locale.ROOT, "Deleted %d files from old cache", deletedCount));
            }
        }
        catch (IOException ex) {
            LOGGER.warning("ImageCache: Error deleting old cache (" + ex + ")");
        }
    }

    public static void deleteExpiredFiles() {
        ImageCache.deleteExpiredFiles(defaultPath);
    }

    public static void deleteExpiredFiles(Path imgCachePath) {
        ImageCache.removeOldCache();
        LOGGER.info("ImageCache: Checking for old files in random directory..");
        try {
            File[] dirs = imgCachePath.toRealPath(new LinkOption[0]).toFile().listFiles(file -> file.isDirectory() && file.getName().startsWith(GLOBAL_PREFIX));
            if (dirs != null && dirs.length > 0) {
                File random = dirs[ThreadLocalRandom.current().nextInt(dirs.length)];
                File[] subdirs = random.listFiles(file -> file.isDirectory());
                ImageCache.deleteExpiredFilesInSubDirs(subdirs);
            }
        }
        catch (IOException ex) {
            LOGGER.warning("ImageCache: Failed clearing old files [" + ex + "]");
        }
    }

    private static void deleteExpiredFilesInSubDirs(File[] dirsArray) throws IOException {
        int fileCount;
        File random;
        if (dirsArray == null || dirsArray.length == 0) {
            return;
        }
        ArrayList<File> dirs = new ArrayList<File>(Arrays.asList(dirsArray));
        for (fileCount = 0; !dirs.isEmpty() && fileCount < 100; fileCount += ImageCache.deleteExpiredFilesInDir(random.getCanonicalFile(), 2592000)) {
            random = (File)dirs.get(ThreadLocalRandom.current().nextInt(dirs.size()));
            dirs.remove(random);
        }
        LOGGER.info(String.format(Locale.ROOT, "ImageCache: Checked %d files in %d subdirs (%s)", fileCount, dirsArray.length - dirs.size(), dirsArray[0].getParent()));
    }

    private static int deleteExpiredFilesInDir(File dir, int expireTime) {
        File[] files = dir.listFiles();
        if (files != null) {
            int deleted = 0;
            int toDelete = 0;
            for (File file : files) {
                if (!file.getName().startsWith(GLOBAL_PREFIX)) continue;
                long lastModified = file.lastModified();
                long ago = (System.currentTimeMillis() - lastModified) / 1000L;
                if (ago <= (long)expireTime) continue;
                ++toDelete;
                if (!file.delete()) continue;
                ++deleted;
            }
            if (toDelete > 0) {
                LOGGER.info(String.format(Locale.ROOT, "ImageCache: Deleted %d/%d files (checked %d in %s)", deleted, toDelete, files.length, dir));
            }
            return files.length;
        }
        return 0;
    }

    public static ImageResult getImage(ImageRequest request, String prefix, int expireTime) {
        return ImageCache.getImage(request, defaultPath, prefix, expireTime);
    }

    public static ImageResult getImage(ImageRequest request, Path path, String prefix, int expireTime) {
        ImageResult image;
        if (cachingEnabled && !ImageCache.isLocalURL(request.requestedURL) && (image = ImageCache.getCachedImage(request, path, prefix, expireTime)) != null) {
            return image;
        }
        return ImageCache.getImageDirectly(request);
    }

    public static ImageResult getImageDirectly(ImageRequest request) {
        try {
            return GifUtil.getGifFromUrl(request);
        }
        catch (Exception ex) {
            LOGGER.warning("Error loading image: " + ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageResult getCachedImage(ImageRequest request, Path path, String prefix, int expireTime) {
        Object o;
        String id = ImageCache.sha1(request.requestedURL.toString());
        path = path.resolve(GLOBAL_PREFIX + prefix).resolve(id.substring(0, 1));
        path.toFile().mkdirs();
        Path file = path.resolve(ImageCache.getFilename(prefix, id));
        ImageResult result = null;
        Object object = o = ImageCache.getLockObject(id);
        synchronized (object) {
            result = ImageCache.getCachedImage2(request, file, expireTime);
        }
        ImageCache.removeLockObject(id);
        return result;
    }

    private static ImageResult getCachedImage2(ImageRequest request, Path file, int expireTime) {
        ImageResult fromFile = ImageCache.getImageFromFile(file, request);
        if (fromFile == null) {
            if (ImageCache.saveFile(request.requestedURL, file)) {
                fromFile = ImageCache.getImageFromFile(file, request);
            }
        } else if (ImageCache.hasExpired(expireTime, file) && ImageCache.saveFile(request.requestedURL, file)) {
            fromFile = ImageCache.getImageFromFile(file, request);
        }
        return fromFile;
    }

    private static boolean hasExpired(int expireTime, Path file) {
        long lastModified = file.toFile().lastModified();
        long ago = (System.currentTimeMillis() - lastModified) / 1000L;
        return lastModified == 0L || expireTime > 0 && ago > (long)expireTime;
    }

    private static String getFilename(String prefix, String id) {
        return GLOBAL_PREFIX + prefix + "__" + id;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean saveFile(URL url, Path file) {
        try {
            URLConnection c = url.openConnection();
            try (InputStream is = c.getInputStream();){
                long written = Files.copy(is, file, StandardCopyOption.REPLACE_EXISTING);
                if (written <= 0L) return false;
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException ex) {
            LOGGER.warning("Error saving " + url + " to " + file + ": " + ex);
        }
        return false;
    }

    private static ImageResult getImageFromFile(Path file, ImageRequest request) {
        try {
            request.setCacheFile(file);
            return GifUtil.getGifFromUrl(request);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception ex) {
            LOGGER.warning("Error loading image from file: " + ex + " " + Debugging.getStacktrace(ex));
        }
        return null;
    }

    public static String sha1(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            return ImageCache.byteArrayToHexString(md.digest(input.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException ex) {
            Logger.getLogger(ImageCache.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static String byteArrayToHexString(byte[] b) {
        String result = "";
        for (int i = 0; i < b.length; ++i) {
            result = result + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }

    public static boolean isLocalURL(URL url) {
        return "file".equalsIgnoreCase(url.getProtocol()) || "jar".equalsIgnoreCase(url.getProtocol());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getLockObject(String file) {
        Map<String, Object> map = lockObjects;
        synchronized (map) {
            Object o = lockObjects.get(file);
            if (o == null) {
                o = new Object();
                lockObjects.put(file, o);
            }
            return o;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeLockObject(String file) {
        Map<String, Object> map = lockObjects;
        synchronized (map) {
            lockObjects.remove(file);
        }
    }

    public static class ImageRequest {
        public static final int MAX_SCALED_WIDTH = 250;
        public static final int MAX_SCALED_HEIGHT = 150;
        public final int urlFactor;
        public final int maxHeight;
        public final float scaleFactor;
        public final boolean valid;
        public final boolean resize;
        public final Dimension defaultSize;
        private final URL requestedURL;
        private URL cacheURL;

        public ImageRequest(URL url) {
            this.requestedURL = url;
            this.urlFactor = 1;
            this.maxHeight = -1;
            this.scaleFactor = -1.0f;
            this.valid = true;
            this.resize = false;
            this.defaultSize = null;
        }

        public ImageRequest(Function<Integer, String> urlRequester, float scaleFactor, int maxHeight, Dimension defaultSize, boolean forceDefaultAsBase) {
            int preferredFactor;
            int f;
            Dimension expectedSize = ImageRequest.getScaledSize(defaultSize, scaleFactor, maxHeight);
            int actualUrlFactor = 1;
            String preferredUrl = null;
            for (f = preferredFactor = ImageRequest.getPreferredScale(expectedSize, defaultSize); f <= 4; ++f) {
                preferredUrl = urlRequester.apply(f);
                if (preferredUrl == null) continue;
                actualUrlFactor = f;
                break;
            }
            if (preferredUrl == null) {
                for (f = preferredFactor - 1; f > 0; --f) {
                    preferredUrl = urlRequester.apply(f);
                    if (preferredUrl == null) continue;
                    actualUrlFactor = f;
                    break;
                }
            }
            URL actualUrl = null;
            try {
                actualUrl = new URL(preferredUrl);
            }
            catch (MalformedURLException ex) {
                LOGGER.warning("Invalid image URL: " + preferredUrl);
            }
            this.maxHeight = maxHeight;
            this.scaleFactor = scaleFactor;
            this.requestedURL = actualUrl;
            this.urlFactor = actualUrlFactor;
            this.valid = this.requestedURL != null;
            this.resize = true;
            this.defaultSize = forceDefaultAsBase ? defaultSize : null;
        }

        public void setCacheFile(Path file) throws MalformedURLException {
            this.cacheURL = file.toUri().toURL();
        }

        public URL getLoadFromURL() {
            return this.cacheURL != null ? this.cacheURL : this.requestedURL;
        }

        public URL getRequestedURL() {
            return this.requestedURL;
        }

        public ImageResult finishIcon(ImageIcon icon, boolean isGif) {
            Dimension actualBaseSize = this.getCorrectedSizeFromImage(icon);
            Dimension baseSize = this.defaultSize != null ? this.defaultSize : actualBaseSize;
            Dimension scaledSize = ImageRequest.getScaledSize(baseSize, this.scaleFactor, this.maxHeight);
            if (this.resize && !actualBaseSize.equals(scaledSize)) {
                Image image = this.getScaledImage(icon.getImage(), scaledSize.width, scaledSize.height);
                icon.setImage(image);
            }
            return new ImageResult(icon, actualBaseSize, isGif);
        }

        public Dimension getScaledSizeIfNecessary(Dimension actualBaseSize) {
            Dimension baseSize = this.defaultSize != null ? this.defaultSize : actualBaseSize;
            Dimension scaledSize = ImageRequest.getScaledSize(baseSize, this.scaleFactor, this.maxHeight);
            if (this.resize && !actualBaseSize.equals(scaledSize)) {
                return scaledSize;
            }
            return null;
        }

        public static Dimension getScaledSize(Dimension d, float scaleFactor, int maxHeight) {
            float scaledWidth = d.width;
            float scaledHeight = d.height;
            if (scaleFactor > 0.0f) {
                scaledWidth *= scaleFactor;
                scaledHeight *= scaleFactor;
            }
            if (maxHeight > 0 && scaledHeight > (float)maxHeight) {
                scaledWidth /= scaledHeight / (float)maxHeight;
                scaledHeight = maxHeight;
            }
            int resultWidth = (int)scaledWidth;
            int resultHeight = (int)scaledHeight;
            if (resultWidth < 1) {
                resultWidth = 1;
            }
            if (resultHeight < 1) {
                resultHeight = 1;
            }
            if (resultWidth > 250) {
                resultWidth = 250;
            }
            if (resultHeight > 150) {
                resultHeight = 150;
            }
            return new Dimension(resultWidth, resultHeight);
        }

        private static int getPreferredScale(Dimension expectedSize, Dimension defaultSize) {
            if (expectedSize.width > 0 && defaultSize.width > 0) {
                return MathUtil.divRoundUp(expectedSize.width, defaultSize.width);
            }
            return 1;
        }

        public Dimension getCorrectedSizeFromImage(ImageIcon icon) {
            return this.getUrlFactorCorrectedSize(icon.getIconWidth(), icon.getIconHeight());
        }

        public Dimension getCorrectedSizeFromImage(BufferedImage image) {
            return this.getUrlFactorCorrectedSize(image.getWidth(), image.getHeight());
        }

        public Dimension getUrlFactorCorrectedSize(int width, int height) {
            if (this.urlFactor > 1) {
                width /= this.urlFactor;
                height /= this.urlFactor;
            }
            return new Dimension(width, height);
        }

        private Image getScaledImage(Image img, int width, int height) {
            return img.getScaledInstance(width, height, 4);
        }
    }

    public static class ImageResult {
        public final ImageIcon icon;
        public final Dimension actualBaseSize;
        public final boolean loadedAsGif;

        public ImageResult(ImageIcon icon, Dimension actualBaseSize, boolean loadedAsGif) {
            this.icon = icon;
            this.actualBaseSize = actualBaseSize;
            this.loadedAsGif = loadedAsGif;
        }

        public boolean isValidImage() {
            return this.icon != null && this.icon.getImageLoadStatus() != 4 && this.icon.getIconWidth() != -1 && this.icon.getIconHeight() != -1;
        }
    }
}

